/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.ErrorDirective;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ReplaceList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.interfaces.compiler.ITokenManager;
import com.iscobol.rts.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class TokenManager
implements CobolToken,
ErrorsNumbers,
ITokenManager {
    public static final String EXTRAINFO_DELIMITERS = " \t\n\r\f=,;()";
    PreProcessor pp;
    private Vector tokenBuff = new Vector();
    private int tokenBuffIdx = -1;
    private OptionList optList;
    private Map<String, Object[]> allLiterals = new HashMap<String, Object[]>();
    private Map<String, Object[]> allUsedLiterals = new HashMap<String, Object[]>();
    private boolean lastVirtualDot;
    private Errors error;
    private Hashtable extraInfo = new Hashtable();
    boolean inExecSql;
    private int lowValue = 0;
    private int highValue = 255;
    private Vector workingStorageCopies = new Vector();
    private String inDoc;
    private boolean debug;
    private boolean debugExt;
    boolean declareAllLit;
    private boolean hexCompact;
    private boolean optionApost;
    private boolean optionCm;
    private boolean optionCa;
    private boolean optionCv;
    private boolean optionBig;
    private boolean optionB;
    private Token lastRemovedToken;
    private boolean optionCr;
    boolean optionMs;
    private boolean keepComments;
    boolean debuggingMode;
    private boolean hasResources;
    private HashSet<File> copyResources = new HashSet();
    private ArrayList<Token> commentList = new ArrayList();
    private ArrayList<Integer> commentIdxs = new ArrayList();
    private boolean keepAll;

    public TokenManager(PreProcessor preProcessor, OptionList optionList, Errors errors) {
        this.pp = preProcessor;
        this.optList = optionList;
        this.error = errors;
        this.initOptions();
        optionList.setNotifier(new OptionList.Notifier(){

            @Override
            public void optionListChanged() {
                TokenManager.this.initOptions();
            }
        });
    }

    void initOptions() {
        this.debugExt = this.optList.getOption("-dx") != null;
        this.debug = this.debugExt || this.optList.getOption("-d") != null;
        this.optionApost = this.optList.getOption("-apost") != null;
        this.optionCm = this.optList.getOption("-cm") != null;
        this.optionCa = this.optList.getOption("-ca") != null;
        this.optionCv = this.optList.getOption("-cv") != null;
        this.optionMs = this.optList.getOption("-jjms") != null;
        this.keepComments = this.optionMs && Config.b("iscobol.compiler.jjms.keep_comments", true);
        this.optionBig = !this.optionMs && this.optList.getOption("-big") != null;
        this.optionB = this.optList.getOption("-b") != null;
        this.hexCompact = this.optList.getOption("-xchlc") != null;
        this.optionCr = this.optList.getOption("-cr") != null;
    }

    public boolean isAcuCompFlag() {
        return this.optionCa;
    }

    public boolean isMainframeCompFlag() {
        return this.optionCv;
    }

    public boolean isRmCompFlag() {
        return this.optionCr;
    }

    public Marker getMarker() {
        return new Marker();
    }

    public void skipTillDot() throws EndOfProgramException, GeneralErrorException {
        while (this.getToken().getToknum() != 10006) {
        }
        this.ungetToken();
    }

    public void skipToDot() throws EndOfProgramException, GeneralErrorException {
        while (this.getToken().getToknum() != 10006) {
        }
    }

    public void skipTill(int[] nArray) throws EndOfProgramException, GeneralErrorException {
        block0: while (true) {
            int n2 = this.getToken().getToknum();
            int n3 = 0;
            while (true) {
                if (n3 >= nArray.length) continue block0;
                if (n2 == nArray[n3]) {
                    this.ungetToken();
                    return;
                }
                ++n3;
            }
            break;
        }
    }

    protected void setLowHighValues(int n2, int n3) {
        this.lowValue = n2;
        this.highValue = n3;
    }

    @Override
    public int getLowValue() {
        return this.lowValue;
    }

    @Override
    public int getHighValue() {
        return this.highValue;
    }

    public String getApost() {
        return this.optionApost ? "'''" : "'\"'";
    }

    @Override
    public Token getToken() throws EndOfProgramException, GeneralErrorException {
        return this.getToken(true);
    }

    @Override
    public Token getToken(boolean bl) throws EndOfProgramException, GeneralErrorException {
        Token token;
        Token token2;
        while ((token2 = this.getAllToken(bl)).isSeparator()) {
        }
        if (token2.getToknum() == 10009 && (token = this.getConstVar(token2.getWord())) != null) {
            token2.makeConst(token);
        }
        if (token2.getToknum() == 10026) {
            throw new ErrorDirective(token2);
        }
        return token2;
    }

    static String stringToHex(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (char c2 : string.toCharArray()) {
            String string2;
            if (bl) {
                string2 = Integer.toHexString(c2).toUpperCase();
                if (bl2) {
                    stringBuffer.append("\\u");
                }
                stringBuffer.append("0000".substring(0, 4 - string2.length()));
                stringBuffer.append(string2);
                continue;
            }
            string2 = Integer.toHexString(c2 & 0xFF).toUpperCase();
            if (bl2) {
                stringBuffer.append("\\u00");
            }
            stringBuffer.append("00".substring(0, 2 - string2.length()));
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static boolean hexToString(Token token, Errors errors, boolean bl) {
        String string = token.getWord();
        char c2 = string.charAt(1);
        StringBuffer stringBuffer = new StringBuffer().append(c2);
        int n2 = 2;
        int n3 = bl ? 4 : 2;
        int n4 = (string.length() - 3) % n3;
        if (n4 > 0) {
            string = "x'" + "000".substring(0, n3 - n4) + string.substring(2);
        }
        char[] cArray = string.toCharArray();
        while (n2 < cArray.length && cArray[n2] != c2) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3 && cArray[n2] != c2) {
                n5 <<= 4;
                switch (cArray[n2]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n5 += (char)(cArray[n2] - 48);
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        n5 += (char)(cArray[n2] - 65 + 10);
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        n5 += (char)(cArray[n2] - 97 + 10);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                ++n6;
                ++n2;
            }
            stringBuffer.append((char)n5);
        }
        stringBuffer.append(c2);
        if (stringBuffer.length() == 2) {
            token.setToknum(10002);
            token.setWord("0");
            return false;
        }
        token.setWord(stringBuffer.toString());
        token.setHexdecimal(true);
        return true;
    }

    private void checkNumLiteral(Token token) throws GeneralErrorException {
        char[] cArray = token.getWord().toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] < '0' || cArray[i2] > '9') continue;
            ++n2;
        }
        if (n2 > 31) {
            throw new GeneralErrorException(141, 4, token, token.getWord(), this.error);
        }
    }

    private void handleStringLiteral(Token token) {
        char c2 = token.getWord().charAt(0);
        if (c2 == 'X') {
            if (!TokenManager.hexToString(token, this.error, false)) {
                // empty if block
            }
        } else if (c2 == 'H') {
            if (this.optionCm) {
                String string = token.getWord();
                long l2 = PreProcessor.hexToNum(string.toCharArray(), new int[]{2}, string.length() - 1);
                token.setToknum(10002);
                token.setWord("" + l2);
            } else if (!TokenManager.hexToString(token, this.error, false)) {
                // empty if block
            }
        } else {
            c2 = token.getWord().charAt(0);
            if (c2 == 'N' || c2 == 'n') {
                token.setNational(true);
                c2 = token.getWord().charAt(1);
                if (c2 == 'X' || c2 == 'x') {
                    token.setWord(token.getWord().substring(1));
                    if (!TokenManager.hexToString(token, this.error, true)) {
                        // empty if block
                    }
                } else {
                    token.setWord(token.getWord().substring(1));
                }
            } else {
                c2 = token.getWord().charAt(0);
                if (c2 == 'R' || c2 == 'r') {
                    if (!this.optionB) {
                        token.setNational(true);
                    }
                    token.setResource(true);
                    token.setWord(token.getWord().substring(1));
                }
            }
        }
    }

    private void concat(Token token, Token token2) {
        String string = token.getWord();
        String string2 = token2.getWord();
        char c2 = string.charAt(0);
        char c3 = string2.charAt(0);
        boolean bl = token.isHexdecimal();
        boolean bl2 = token2.isHexdecimal();
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, string.length() - 1));
        if (c2 == c3 && bl == bl2) {
            stringBuffer.append(string2.substring(1, string2.length()));
        } else {
            char[] cArray = string2.toCharArray();
            for (int i2 = 1; i2 < cArray.length - 1; ++i2) {
                stringBuffer.append(cArray[i2]);
                if (cArray[i2] == c2) {
                    if (!bl) {
                        stringBuffer.append(cArray[i2]);
                        continue;
                    }
                    if (bl2) continue;
                    ++i2;
                    continue;
                }
                if (cArray[i2] != c3 || bl2) continue;
                ++i2;
            }
            stringBuffer.append(c2);
        }
        token.setWord(stringBuffer.toString());
    }

    @Override
    public Token getAllToken() throws EndOfProgramException, GeneralErrorException {
        return this.getAllToken(true);
    }

    @Override
    public Token getAllToken(boolean bl) throws EndOfProgramException, GeneralErrorException {
        Token token;
        Token token2 = this.myGetToken();
        Token token3 = null;
        if (bl && token2.getToknum() == 262) {
            token3 = token2;
            token2 = this.myGetToken();
            switch (token2.getToknum()) {
                case 10002: 
                case 10017: {
                    if (!token2.isZero()) {
                        this.error.print(219, 3, token2, token3.getWord() + " " + token2.getWord());
                    }
                    token3 = null;
                    break;
                }
                case 10009: {
                    token = this.getConstant(token2.getWord());
                    if (token != null) {
                        if (token.getToknum() == 10002 || token.getToknum() == 10017) {
                            this.error.print(219, 3, token2, token3.getWord() + " " + token2.getWord());
                            token3 = null;
                            break;
                        }
                        if (token.getToknum() == 10001 && token.getWord().length() == 2) {
                            this.error.print(317, 3, token2, token3.getWord() + " " + token2.getWord());
                            if (this.keepAll) {
                                token2 = new Token(token);
                                token2.setWord("\" \"");
                            } else {
                                token3 = null;
                                break;
                            }
                        }
                    }
                    token2.setAll(true);
                    break;
                }
                case 10001: {
                    if (token2.getWord().length() == 2) {
                        this.error.print(317, 3, token2, token3.getWord() + " " + token2.getWord());
                        if (this.keepAll) {
                            token2.setWord("\" \"");
                        } else {
                            token3 = null;
                            break;
                        }
                    }
                }
                default: {
                    token2.setAll(true);
                }
            }
        }
        block6 : switch (token2.getToknum()) {
            default: {
                if (token3 == null) break;
                token2.setAll(false);
                token2 = token3;
                this.ungetToken();
                break;
            }
            case 374: {
                break;
            }
            case 10017: {
                break;
            }
            case 10009: {
                token = this.getConstVar(token2.getWord(), true);
                if (token == null || token.getToknum() != 10001) break;
                token2.makeConst(token);
            }
            case 10001: {
                this.handleStringLiteral(token2);
                if (token2.getToknum() == 10002) break;
                block42: while (this.myGetToken().getToknum() == 38) {
                    Token token4 = this.myGetToken();
                    token = this.getConstVar(token4.getWord(), true);
                    if (token != null && token.getToknum() == 10001) {
                        token4.makeConst(token);
                    }
                    String string = null;
                    switch (token4.getToknum()) {
                        case 10001: {
                            this.handleStringLiteral(token4);
                            if (token2.isResource() || token4.isResource()) {
                                this.error.print(158, 3, token2, token2.getWord() + " & " + token4.getWord());
                            }
                            this.concat(token2, token4);
                            this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                            this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                            break;
                        }
                        case 576: 
                        case 577: 
                        case 600: 
                        case 601: {
                            string = "\"\u0000\"";
                            break;
                        }
                        case 516: 
                        case 517: {
                            string = "\"\u00ff\"";
                            break;
                        }
                        case 822: 
                        case 824: 
                        case 825: {
                            string = "\"0\"";
                            break;
                        }
                        case 736: 
                        case 737: {
                            string = "\" \"";
                            break;
                        }
                        case 660: 
                        case 661: {
                            string = "\"\"\"";
                            break;
                        }
                        default: {
                            this.error.print(158, 4, token2, " & " + token4.getWord());
                            break block42;
                        }
                    }
                    if (string == null) continue;
                    token4 = new Token(10001, string, 1, 1, "");
                    this.concat(token2, token4);
                    this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                    this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                }
                this.ungetToken();
                break;
            }
            case 600: 
            case 601: {
                if (this.inExecSql) {
                    token2.setNullFlag();
                    break;
                }
                token2.setNull((char)this.lowValue);
                break;
            }
            case 822: 
            case 824: 
            case 825: {
                token2.setToknum(10002);
                token2.setWord("0");
                token2.setAll(true);
                token2.setFigurative(true);
                break;
            }
            case 736: 
            case 737: {
                token2.setToknum(10001);
                token2.setWord("' '");
                token2.setFigurative(true);
                break;
            }
            case 576: 
            case 577: {
                token2.setHexAll((char)this.lowValue);
                break;
            }
            case 516: 
            case 517: {
                token2.setHexAll((char)this.highValue);
                break;
            }
            case 660: 
            case 661: {
                token2.setToknum(10001);
                token2.setWord(this.optionApost ? "'''" : "'\"'");
                token2.setAll(true);
                token2.setFigurative(true);
                break;
            }
            case 10014: {
                String string = "";
                int n2 = this.tokenBuffIdx;
                char c2 = token2.getWord().charAt(0);
                Token token5 = token2;
                char c3 = c2;
                String string2 = "" + c3;
                int n3 = token5.getWord().length();
                switch (c3) {
                    case 'B': 
                    case 'H': 
                    case 'O': 
                    case 'X': {
                        c2 = token2.getWord().charAt(1);
                        string = string + token5.getWord().substring(2, n3 - 2);
                        break;
                    }
                    case 'N': {
                        if (token2.getWord().length() > 1 && token2.getWord().charAt(1) == 'X') {
                            c2 = token2.getWord().charAt(2);
                            string = string + token5.getWord().substring(3, n3 - 2);
                            string2 = "NX";
                            break;
                        }
                    }
                    default: {
                        string = string + token5.getWord().substring(1, n3 - 2);
                    }
                }
                token5 = this.myGetToken();
                if (token5.getToknum() != 10021) {
                    this.ungetToken();
                }
                while ((token5 = this.myGetToken()).getToknum() == 10014) {
                    n3 = token5.getWord().length();
                    string = string + token5.getWord().substring(1, n3 - 2);
                    token5 = this.myGetToken();
                    if (token5.getToknum() == 10021) continue;
                    this.ungetToken();
                }
                if (token5.getToknum() != 10001) {
                    throw new GeneralErrorException(1, 4, token5, token5.getWord(), this.error);
                }
                n3 = token5.getWord().length();
                token2.setWord(c2 + string + token5.getWord().substring(1, n3 - 1) + c2);
                if (c3 != c2) {
                    token2.setWord(string2 + token2.getWord());
                    this.handleStringLiteral(token2);
                }
                if (token3 != null && token2.getWord().length() == 2) {
                    this.error.print(317, 3, token2, token3.getWord() + " " + token2.getWord());
                    if (this.keepAll) {
                        token2.setWord("\" \"");
                    } else {
                        token2.setAll(false);
                        token3 = null;
                    }
                }
                if (token2.getToknum() == 10014) {
                    token2.setToknum(10001);
                }
                while (this.tokenBuffIdx > n2) {
                    this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                }
                break;
            }
            case 10002: {
                int n4 = this.tokenBuffIdx;
                try {
                    Token token6;
                    Token token7 = this.myGetToken();
                    if (token7.getWord().length() == 1 && (token6 = this.myGetToken()).getToknum() == 10002 && (this.inExecSql && token7.getToknum() == 10006 || !this.inExecSql && this.pp.getDecimalPoint() == ',' && token7.getToknum() == 44 || this.pp.getDecimalPoint() == '.' && token7.getToknum() == 10006)) {
                        Token token8 = this.myGetToken();
                        if (token8.getToknum() == 10022) {
                            Token token9 = this.myGetToken();
                            token2.setDouble(true);
                            if (token9.getToknum() == 10002) {
                                token2.setWord(token2.getWord() + "." + token6.getWord() + "E" + token9.getWord());
                            } else {
                                --this.tokenBuffIdx;
                                token2.setWord(token2.getWord() + "." + token6.getWord() + "E00");
                            }
                        } else {
                            --this.tokenBuffIdx;
                            token2.setWord(token2.getWord() + token7.getWord() + token6.getWord());
                            token2.setDecimals(token6.getWord().length());
                        }
                        token2.setToknum(10017);
                        if (!this.inExecSql && this.pp.getDecimalPoint() == ',') {
                            token8 = this.myGetToken();
                            if (token8.getWord().length() == 0 && token8.getToknum() == 10002) {
                                token7 = this.myGetToken();
                                if (token7.getToknum() == 44 && token6.getOffset() + token6.getWord().length() == token7.getOffset()) {
                                    this.error.print(193, 2, token7.getFLN(), token7.getOffset(), token6.getWord() + ",", null, token7.getFileName());
                                } else {
                                    this.tokenBuffIdx -= 2;
                                }
                            } else {
                                --this.tokenBuffIdx;
                            }
                        }
                        while (this.tokenBuffIdx > n4) {
                            this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                        }
                    } else {
                        this.tokenBuffIdx = n4;
                    }
                }
                catch (EndOfProgramException endOfProgramException) {
                    this.tokenBuffIdx = n4;
                }
                this.checkNumLiteral(token2);
                break;
            }
            case 558: {
                int n5 = this.myGetToken().getToknum();
                switch (n5) {
                    case 609: {
                        token2.setToknum(10009);
                        token2.setWord("LENGTH OF");
                        this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                        break block6;
                    }
                    case 10001: 
                    case 10009: {
                        token2.setToknum(10009);
                        token2.setWord("LENGTH OF");
                        token2 = new Token(token2){

                            @Override
                            boolean isLength() {
                                return true;
                            }
                        };
                        this.tokenBuff.setElementAt(token2, --this.tokenBuffIdx);
                        break block6;
                    }
                }
                --this.tokenBuffIdx;
                break;
            }
            case 259: {
                if (this.myGetToken().getToknum() == 609) {
                    token2.setToknum(10009);
                    token2.setWord("ADDRESS OF");
                    this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                    break;
                }
                --this.tokenBuffIdx;
            }
        }
        if (token3 == null && !token2.isNull()) {
            switch (token2.getToknum()) {
                case 10001: 
                case 10002: 
                case 10017: {
                    this.loadLiteral(token2);
                }
            }
        }
        return token2;
    }

    public void addWorkingStorageCopy(String string) {
        this.workingStorageCopies.addElement(string);
    }

    void startWorkingStorage(Token token) {
        ReplaceList replaceList = new ReplaceList();
        int n2 = this.workingStorageCopies.size() - 1;
        if (n2 >= 0) {
            if (this.tokenBuffIdx < this.tokenBuff.size() - 1) {
                this.error.print(147, 4, token, " (-exec=)");
            }
            while (n2 >= 0) {
                String string = this.workingStorageCopies.elementAt(n2).toString();
                int n3 = this.pp.readCopy(token, string, false, replaceList);
                if (n3 != 0) {
                    this.error.print(n3, 4, token, string);
                }
                --n2;
            }
        }
    }

    private Token myGetToken() throws EndOfProgramException {
        Token token;
        while ((token = this._myGetToken()) == null) {
        }
        return token;
    }

    private Token _myGetToken() throws EndOfProgramException {
        int n2;
        Object object;
        Token token = null;
        ++this.tokenBuffIdx;
        while (this.tokenBuffIdx >= this.tokenBuff.size() && this.pp.getLine(this.tokenBuff, this) > 0) {
        }
        if (this.tokenBuffIdx < this.tokenBuff.size()) {
            object = null;
            n2 = this.tokenBuffIdx + 1;
            token = (Token)this.tokenBuff.elementAt(this.tokenBuffIdx);
            if (token.getToknum() == 10024 || n2 == this.tokenBuff.size() && token.getToknum() != 10006) {
                while (true) {
                    if (n2 >= this.tokenBuff.size() && this.pp.getLine(this.tokenBuff, this) > 0) {
                        continue;
                    }
                    if (n2 >= this.tokenBuff.size() || ((Token)(object = (Token)this.tokenBuff.elementAt(n2))).getToknum() != 10005 && ((Token)object).getToknum() != 10021) break;
                    ++n2;
                }
            }
            if (object != null) {
                if (((Token)object).getToknum() == 10021 && token.getToknum() == 10024) {
                    this.pp.getLine(this.tokenBuff, this);
                    this.tokenBuff.removeElementAt(n2);
                    object = (Token)this.tokenBuff.elementAt(n2);
                }
                if (((Token)object).getToknum() == 1) {
                    this.tokenBuff.removeElementAt(n2);
                    if (n2 < this.tokenBuff.size()) {
                        object = (Token)this.tokenBuff.elementAt(n2);
                        if (token.getToknum() == 10006) {
                            token.setWord(".");
                        } else if (token.getToknum() == 44) {
                            token.setWord(",");
                        } else if (token.getToknum() == 10024) {
                            token.setWord(token.getWord() + "\"-");
                            token.setToknum(10014);
                        } else {
                            String string = token.getWord();
                            String string2 = ((Token)object).getWord();
                            int n3 = string.length();
                            int n4 = string2.length();
                            if (n3 > 0 && n4 > 0) {
                                char c2 = string.charAt(n3 - 1);
                                char c3 = string2.charAt(0);
                                if ((Character.isJavaIdentifierPart(c2) || c2 == '-') && (Character.isJavaIdentifierPart(c3) || c3 == '-')) {
                                    token.setWord(token.getWord() + ((Token)object).getWord());
                                    token.putKeyword(this.pp.getNotReservedWords());
                                    this.tokenBuff.removeElementAt(n2);
                                }
                            }
                        }
                    }
                } else if (token.getToknum() == 10024 && token.doc != null) {
                    this.error.print(287, 3, token, token.getWord());
                    token.setWord(token.getWord() + token.doc);
                    token.doc = null;
                    token.setToknum(10001);
                }
            }
        }
        if (token == null) {
            if (this.lastVirtualDot) {
                object = this.pp.lastCondToken();
                if (object != null) {
                    token = (Token)object[0];
                    n2 = object[1] == null ? 2 : 4;
                    this.error.print(192, n2, token, ">>" + token.getWord());
                }
                throw new EndOfProgramException();
            }
            this.lastVirtualDot = true;
            token = new Token(10006, ".", 0, 0, "");
        } else if (token.getToknum() == 10020) {
            this.addExtraInfo(token);
            this.tokenBuff.remove(this.tokenBuffIdx--);
            token = null;
        } else if (token.getToknum() == 10005) {
            if (this.inDoc != null) {
                this.addExtraDoc(this.inDoc, token);
            } else if (this.keepComments && !this.commentList.contains(token)) {
                int n5 = this.tokenBuff.indexOf(token);
                this.commentList.add(token);
                this.commentIdxs.add(n5);
            }
            if (!this.keepComments) {
                this.tokenBuff.remove(this.tokenBuffIdx--);
            }
            token = null;
        }
        return token;
    }

    String getCommentCode(Token token, String string) {
        if (!this.keepComments) {
            return "";
        }
        int n2 = token.getFLN();
        int n3 = token.getFileIndex();
        if (n2 <= 0) {
            return "";
        }
        int n4 = this.tokenBuff.indexOf(token);
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        while (n5 < this.commentList.size()) {
            Token token2 = this.commentList.get(n5);
            if (n4 < this.commentIdxs.get(n5) && (token2.getFileIndex() != n3 || token2.getFLN() > n2)) break;
            String string2 = token2.getWord();
            string2 = string2.startsWith("|") ? string2.substring(1) : (token2.getFileIndex() < n3 || token2.getFLN() < n2 ? string2.substring(2) : null);
            if (string2 != null) {
                stringBuffer.append(string).append("// ").append(string2).append(eol);
                this.commentList.remove(n5);
                this.commentIdxs.remove(n5);
                continue;
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    @Override
    public void ungetToken() throws EndOfProgramException {
        if (this.optionMs) {
            Token token;
            do {
                this.ungetAllToken();
            } while (this.tokenBuffIdx > 0 && ((token = (Token)this.tokenBuff.elementAt(this.tokenBuffIdx)).isSeparator() || token.getToknum() == 10005));
        } else {
            do {
                this.ungetAllToken();
            } while (this.tokenBuffIdx > 0 && ((Token)this.tokenBuff.elementAt(this.tokenBuffIdx)).isSeparator());
        }
    }

    @Override
    public void ungetAllToken() throws EndOfProgramException {
        if (this.tokenBuffIdx >= 0) {
            --this.tokenBuffIdx;
        }
    }

    public void flushToken() {
        this.tokenBuffIdx = -1;
        this.tokenBuff = new Vector();
    }

    public void setMarker(Marker marker) {
        marker.marker = this.tokenBuffIdx;
    }

    int indexOf(Token token) {
        int n2 = this.tokenBuff.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.tokenBuff.elementAt(i2) != token) continue;
            return i2;
        }
        return -1;
    }

    void setTokenBuffIdx(int n2) {
        this.tokenBuffIdx = n2;
    }

    int getTokenBuffIdx() {
        return this.tokenBuffIdx;
    }

    public void rewindToMarker(Marker marker) throws InternalErrorException {
        if (marker.marker == -1) {
            throw new InternalErrorException("marker not set");
        }
        this.tokenBuffIdx = marker.marker;
    }

    @Override
    public int getLineNumber() {
        return this.pp.getLineNumber();
    }

    @Override
    public String getFileName() {
        return this.pp.getFileName();
    }

    public boolean isNotReservedWord(String string) {
        Hashtable hashtable = this.pp.getNotReservedWords();
        if (hashtable == null) {
            return false;
        }
        return hashtable.get(string) != null;
    }

    public Vector getCopyFileNames() {
        Vector vector = this.getCopyFiles();
        Vector<String[]> vector2 = new Vector<String[]>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            CopyBookDesc copyBookDesc = (CopyBookDesc)vector.elementAt(i2);
            vector2.addElement(new String[]{copyBookDesc.getParentName(), Integer.toString(copyBookDesc.getParentLineNumber()), copyBookDesc.getName()});
        }
        return vector2;
    }

    @Override
    public Vector getCopyFiles() {
        Vector vector = new Vector();
        Enumeration enumeration = this.pp.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            this.getCopyFilesRecur((PreProcessor)enumeration.nextElement(), vector, false);
        }
        return vector;
    }

    private void getCopyFilesRecur(PreProcessor preProcessor, Vector vector, boolean bl) {
        CopyBookDesc copyBookDesc = new CopyBookDesc(preProcessor.getFileName(), preProcessor.getParent().getFileName(), preProcessor.lineBeforeCopy, preProcessor.parentFileIndex, preProcessor.index());
        vector.addElement(copyBookDesc);
        Enumeration enumeration = preProcessor.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            this.getCopyFilesRecur((PreProcessor)enumeration.nextElement(), vector, bl);
        }
    }

    public void setDecimalPointIsComma() {
        this.pp.setDecimalPointIsComma(true);
    }

    @Override
    public String getDecimalPointIsComma() {
        return this.pp.decimalPointIsComma();
    }

    @Override
    public char getDecimalPoint() {
        return this.pp.getDecimalPoint();
    }

    public void setEnvValue(String string) {
        this.pp.setEnvValue(string);
    }

    public String getEnvValue() {
        return this.pp.getEnvValue();
    }

    public void setEnvName(String string) {
        this.pp.setEnvName(string);
    }

    public String getEnvName() {
        return this.pp.getEnvName();
    }

    public boolean getExecSql() {
        return this.pp.getExecSql();
    }

    public OptionList getOptionList() {
        return this.optList;
    }

    void addConstant(VariableDeclaration variableDeclaration) {
        this.pp.addConstant(variableDeclaration);
    }

    Token getConstant(String string) {
        return this.pp.getConstant(string);
    }

    void addConstVar(VariableDeclaration variableDeclaration) {
        this.pp.addConstVar(variableDeclaration);
    }

    Token getConstVar(String string) {
        return this.pp.getConstVar(string);
    }

    Token getConstVar(String string, boolean bl) {
        return this.pp.getConstVar(string, bl);
    }

    public void removeToken(Token token) {
        int n2 = this.tokenBuff.lastIndexOf(token);
        if (n2 >= 0) {
            this.tokenBuff.remove(n2);
        }
        --this.tokenBuffIdx;
    }

    public void removeLastToken() {
        this.tokenBuff.remove(this.tokenBuffIdx--);
    }

    public void removeToMarker(Marker marker) throws InternalErrorException {
        int n2 = this.tokenBuffIdx - 1;
        if (marker.marker == -1) {
            throw new InternalErrorException("marker not set");
        }
        for (int i2 = n2; i2 >= marker.marker; --i2) {
            this.removeToken((Token)this.tokenBuff.elementAt(i2));
        }
        this.tokenBuffIdx = marker.marker;
    }

    public Token remgetToken(Token token) throws GeneralErrorException, EndOfProgramException {
        this.lastRemovedToken = token;
        this.removeToken(this.lastRemovedToken);
        return this.getToken();
    }

    public Token getLastRemovedToken() {
        return this.lastRemovedToken;
    }

    private static String buildName(Token token) {
        StringBuffer stringBuffer = new StringBuffer(token.getWord());
        if (token.isResource()) {
            stringBuffer.insert(0, "R");
        }
        if (token.isNational()) {
            stringBuffer.insert(0, "N");
        }
        if (token.isAll()) {
            stringBuffer.insert(0, "all ");
        } else if (token.getNativeSize() > 0) {
            stringBuffer.insert(0, "nat ");
        } else if (token.getBitLen() > 0) {
            stringBuffer.insert(0, "bin ");
        }
        return stringBuffer.toString();
    }

    public void loadLiteral(Token token) {
        String string = TokenManager.buildName(token);
        if (this.allLiterals.get(string) == null) {
            String string2 = "$" + this.allLiterals.size() + "$";
            this.allLiterals.put(string, new Object[]{string2, token, Boolean.FALSE});
        }
    }

    public String getCodeLiteral(Token token) {
        if (this.declareAllLit || this.debugExt || this.optionMs) {
            if (token.isResource()) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.declareAllLit) {
                    stringBuffer.append("Factory.");
                }
                stringBuffer.append("getResource");
                if (!token.isNational()) {
                    stringBuffer.append("X");
                }
                stringBuffer.append("(\"");
                stringBuffer.append(token.getCode());
                stringBuffer.append("\")");
                return stringBuffer.toString();
            }
            return token.getLiteralFactory(this.pp.decimalPointIsComma(), this.hexCompact, this.optionMs);
        }
        String string = TokenManager.buildName(token);
        Object[] objectArray = this.allLiterals.get(string);
        if (objectArray == null) {
            this.loadLiteral(token);
            objectArray = this.allLiterals.get(string);
        }
        this.allUsedLiterals.put(string, objectArray);
        return (String)objectArray[0];
    }

    public boolean hasResources() {
        return this.hasResources;
    }

    public String declareResources(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.hasResources = false;
        for (String string : this.allLiterals.keySet()) {
            Object[] objectArray = this.allLiterals.get(string);
            String string2 = (String)objectArray[0];
            Token token = (Token)objectArray[1];
            if (!token.isResource()) continue;
            this.hasResources = true;
            if (this.debugExt || this.optionMs) {
                stringBuffer2.append("      resourceMap.put(");
                String string3 = "\"" + token.getCode() + "\"";
                stringBuffer2.append(string3);
                stringBuffer2.append(", ");
                if (token.isNational()) {
                    stringBuffer2.append("Factory.getResource(");
                } else {
                    stringBuffer2.append("Factory.getResourceX(");
                }
                stringBuffer2.append(string3);
                stringBuffer2.append("));");
            } else {
                stringBuffer2.append("   ");
                if (bl) {
                    stringBuffer2.append("static ");
                }
                stringBuffer2.append("final");
                stringBuffer2.append(token.getLiteralDeclaration(string2, this.pp.decimalPointIsComma(), this.optionMs, false));
            }
            stringBuffer2.append(eol);
            objectArray[2] = Boolean.TRUE;
        }
        if (this.hasResources) {
            if (this.debugExt || this.optionMs) {
                String string = "   " + (!this.optionBig ? "private " : "") + (bl ? "static " : "");
                stringBuffer.append((String)string + "final java.util.Map<String, ICobolVar> resourceMap = new java.util.HashMap<String, ICobolVar>();");
                stringBuffer.append(eol);
                stringBuffer.append("   ");
                if (bl) {
                    stringBuffer.append("static ");
                }
                stringBuffer.append("{");
                stringBuffer.append(eol);
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("   }");
                stringBuffer.append(eol);
                stringBuffer.append((String)string + "final PicN getResource(String name) {");
                stringBuffer.append(eol);
                stringBuffer.append("      return (PicN) resourceMap.get(name);");
                stringBuffer.append(eol);
                stringBuffer.append("   }");
                stringBuffer.append(eol);
                stringBuffer.append((String)string + "final PicX getResourceX(String name) {");
                stringBuffer.append(eol);
                stringBuffer.append("      return (PicX) resourceMap.get(name);");
                stringBuffer.append(eol);
                stringBuffer.append("   }");
                stringBuffer.append(eol);
            } else {
                stringBuffer.append(stringBuffer2);
            }
        }
        return stringBuffer.toString();
    }

    public String declareLiterals(String string, boolean bl, int[] nArray, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (!this.debugExt && !this.optionMs) {
            int n3 = 0;
            for (String string2 : this.allUsedLiterals.keySet()) {
                Object[] objectArray = this.allUsedLiterals.get(string2);
                String string3 = (String)objectArray[0];
                Token token = (Token)objectArray[1];
                if (objectArray[2] == Boolean.FALSE && !token.isResource()) {
                    if (bl && n3 > 0 && n3 % Pcc.MAX_CONSTANTS == 0) {
                        stringBuffer.append("}" + eol);
                        stringBuffer.append("class " + string + "_CONST" + "_" + n2 + " extends " + string + "_CONST" + "_" + (n2 + 1));
                        ++n2;
                        if (this.debug) {
                            stringBuffer.append(" implements IscobolDebugger");
                        }
                        stringBuffer.append(" {" + eol);
                    }
                    stringBuffer.append("   ");
                    if (!token.isAll() || bl2) {
                        stringBuffer.append("static ");
                    }
                    stringBuffer.append("final");
                    stringBuffer.append(token.getLiteralDeclaration(string3, this.pp.decimalPointIsComma(), this.optionMs, this.hexCompact));
                    stringBuffer.append(eol);
                }
                ++n3;
            }
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = n2;
        }
        return stringBuffer.toString();
    }

    public String declareAllLiterals(boolean bl) {
        if (this.debugExt || this.optionMs) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.allLiterals.keySet()) {
            Object[] objectArray = this.allLiterals.get(string);
            String string2 = (String)objectArray[0];
            Token token = (Token)objectArray[1];
            if (!token.isAll()) continue;
            stringBuffer.append("   ");
            if (bl) {
                stringBuffer.append("static ");
            }
            stringBuffer.append("final");
            stringBuffer.append(token.getLiteralDeclaration(string2, this.pp.decimalPointIsComma(), this.optionMs, this.hexCompact));
            stringBuffer.append(eol);
            objectArray[2] = Boolean.TRUE;
        }
        return stringBuffer.toString();
    }

    boolean isPropagate() {
        return this.pp.isPropagate();
    }

    @Override
    public Vector getAllPreProcessors() {
        return this.pp.getAllPreProcessors();
    }

    private void addExtraDoc(String string, Token token) {
        TokenList tokenList = (TokenList)this.extraInfo.get(string);
        if (tokenList != null) {
            tokenList.addItem(token);
        }
    }

    private void addExtraInfo(Token token) {
        String string = token.getWord();
        string = string.substring(4, string.length() - 2).trim();
        TokenList tokenList = new TokenList();
        StringBuffer stringBuffer = new StringBuffer(string);
        PreProcessor.tokenizer(tokenList, stringBuffer, token.getFLN(), "", 0, this.pp.getDecimalPoint(), this.pp.compFlags, new Errors(true), false);
        if (tokenList.getItemNum() > 1) {
            Token token2 = tokenList.getFirst();
            String string2 = tokenList.getFirst().getCode().toUpperCase(Locale.US);
            TokenList tokenList2 = (TokenList)this.extraInfo.get(string2);
            if (tokenList2 == null) {
                tokenList2 = new TokenList();
                tokenList2.addItem(token);
            } else {
                Token token3 = tokenList2.getFirst();
                token3.setWord(token3.getWord() + " " + token.getWord());
            }
            token2 = tokenList.getNext();
            while (token2 != null) {
                if (token2.getToknum() != 10001) {
                    if (string2.equals("ELK")) {
                        token2.setWord(token2.getOriginalWord());
                    } else {
                        token2.setWord(token2.getWord().toUpperCase(Locale.US));
                    }
                }
                tokenList2.addItem(token2);
                token2 = tokenList.getNext();
            }
            this.extraInfo.put(string2, tokenList2);
        } else {
            Token token4 = tokenList.getFirst();
            if (token4 != null) {
                String string3 = token4.getCode().toUpperCase(Locale.US);
                if ("DOC".equals(string3)) {
                    this.inDoc = string3;
                    this.extraInfo.put(string3, tokenList);
                } else if ("END_DOC".equals(string3)) {
                    this.inDoc = null;
                }
            }
        }
    }

    public TokenList getExtraInfo(String string) {
        return (TokenList)this.extraInfo.get(string.toUpperCase(Locale.US));
    }

    public TokenList delExtraInfo(String string) {
        return (TokenList)this.extraInfo.remove(string.toUpperCase(Locale.US));
    }

    public int getFormat() {
        return this.pp.getFormat();
    }

    public Vector getSvrFileNames() {
        return this.pp.getSvrFileNames();
    }

    public void putTokens(String string, Token token) {
        TokenList tokenList = PreProcessor.tokenizer(new StringBuffer(string), token.getFLN(), token.getFileName(), this.pp.getDecimalPoint(), false, true, this.pp.getNotReservedWords());
        int n2 = this.tokenBuffIdx + 1;
        Token token2 = tokenList.getLast();
        while (token2 != null) {
            this.tokenBuff.add(n2, token2);
            token2 = tokenList.getPrevious();
        }
    }

    void addCopyResource(File file) {
        try {
            this.copyResources.add(file.getCanonicalFile());
        }
        catch (IOException iOException) {
            this.copyResources.add(file);
        }
    }

    Collection<File> getCopyResources() {
        return this.copyResources;
    }

    boolean setKeepAll(boolean bl) {
        boolean bl2 = this.keepAll;
        this.keepAll = bl;
        return bl2;
    }

    public class Marker {
        private int marker = -1;

        public void removeUntilHere() throws InternalErrorException {
            int n2 = TokenManager.this.tokenBuffIdx;
            if (this.marker == -1) {
                throw new InternalErrorException("marker not set");
            }
            for (int i2 = n2; i2 >= this.marker; --i2) {
                TokenManager.this.removeToken((Token)TokenManager.this.tokenBuff.elementAt(i2));
            }
            TokenManager.this.tokenBuffIdx = this.marker - 1;
        }
    }
}

