/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Transform
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName source;
    private VariableName pattern1Vn;
    private Token pattern1Tk;
    private VariableName pattern2Vn;
    private Token pattern2Tk;
    private boolean hasNational;

    public Transform(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009 && token2.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.source = VariableName.get(this.tm, this.error, this.pc);
        if (this.source.isSetGetProperty() || !this.source.getVarDecl().isUsageDisplay()) {
            throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
        }
        this.setHasNational(this.source);
        token2 = this.tm.getToken();
        if (token2.getToknum() == 324) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() != 498) {
            throw new ExpectedFoundException(token2, this.error, "FROM");
        }
        token2 = this.tm.getToken();
        switch (token2.getToknum()) {
            case 10002: {
                if (token2.isFigurativeZero()) {
                    this.pattern1Tk = Transform.cloneToken(token2, 10001, "'0'");
                    break;
                }
                throw new UnexpectedTokenException(token2, this.error);
            }
            case 10001: {
                this.pattern1Tk = token2;
                break;
            }
            case 10009: {
                this.tm.ungetToken();
                this.pattern1Vn = VariableName.get(this.tm, this.error, this.pc);
                this.setHasNational(this.pattern1Vn);
                break;
            }
            default: {
                throw new UnexpectedTokenException(token2, this.error);
            }
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 773) {
            throw new ExpectedFoundException(token2, this.error, "TO");
        }
        token2 = this.tm.getToken();
        switch (token2.getToknum()) {
            case 10002: {
                if (token2.isFigurativeZero()) {
                    this.pattern2Tk = Transform.cloneToken(token2, 10001, "'0'");
                    break;
                }
                throw new UnexpectedTokenException(token2, this.error);
            }
            case 10001: {
                this.pattern2Tk = token2;
                break;
            }
            case 10009: {
                this.tm.ungetToken();
                this.pattern2Vn = VariableName.get(this.tm, this.error, this.pc);
                this.setHasNational(this.pattern2Vn);
                break;
            }
            default: {
                throw new UnexpectedTokenException(token2, this.error);
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    static Token cloneToken(Token token, int n2, String string) {
        Token token2 = new Token(token);
        token2.setToknum(n2);
        token2.setWord(string);
        token2.setAll(token.isAll());
        return token2;
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append(this.source.getCode());
        stringBuffer.append(".transform");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            stringBuffer.append("Byte");
        }
        stringBuffer.append("(");
        if (this.pattern1Tk != null) {
            stringBuffer.append(this.getCodeLiteral(this.pattern1Tk));
        } else {
            stringBuffer.append(this.pattern1Vn.getCode());
        }
        stringBuffer.append(" , ");
        if (this.pattern2Tk != null) {
            stringBuffer.append(this.getCodeLiteral(this.pattern2Tk));
        } else {
            stringBuffer.append(this.pattern2Vn.getCode());
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public VariableName getSource() {
        return this.source;
    }

    public VariableName getPattern1Vn() {
        return this.pattern1Vn;
    }

    public Token getPattern1Tk() {
        return this.pattern1Tk;
    }

    public VariableName getPattern2Vn() {
        return this.pattern2Vn;
    }

    public Token getPattern2Tk() {
        return this.pattern2Tk;
    }

    private void setHasNational(VariableName variableName) {
        if (!this.hasNational) {
            VariableDeclaration variableDeclaration = variableName.getVarDecl();
            this.hasNational = variableDeclaration != null && (variableDeclaration.isNational() || variableDeclaration.isPicG());
        }
    }
}

