/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EndTry;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.Vector;

public class Try
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Block tryBlock;
    private Vector catchClass = new Vector();
    private Vector catchBlocks = new Vector();
    private Block finallyBlock;
    private Block lastExBlock;
    private BlockException defException;

    public Try(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2;
        this.tryBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        while ((token2 = this.tm.getToken()).getToknum() == 315) {
            this.doCatch();
        }
        if (this.lastExBlock == null) {
            throw new ExpectedFoundException(token2, this.error, "'CATCH'");
        }
        this.tm.ungetToken();
        token2 = this.tm.getToken();
        if (token2.getToknum() == 488) {
            this.finallyBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 451) {
            throw new ExpectedFoundException(token2, this.error, "'END-TRY'");
        }
        this.lastExBlock.verbs.addItem(new EndTry(token2, this.lastExBlock, this.pc, this.tm, this.error, this.catchBlocks));
    }

    void doCatch() throws GeneralErrorException, EndOfProgramException {
        if (this.tm.getToken().getToknum() == 472) {
            if (this.defException != null) {
                throw new GeneralErrorException(131, 4, this.keyWord, "EXCEPTION", this.error);
            }
            this.defException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(Exception.class));
            this.lastExBlock = this.defException;
            this.tryBlock.setCatchBlock(this.defException);
        } else {
            this.tm.ungetToken();
            if (this.defException != null) {
                throw new GeneralErrorException(133, 4, this.keyWord, "", this.error);
            }
            VariableName variableName = VariableName.getObject(this.tm, this.error, this.parent, this.pc);
            if (variableName != null) {
                this.catchClass.addElement(variableName);
                BlockException blockException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, variableName.getType());
                this.lastExBlock = blockException;
                this.tryBlock.setCatchBlock(blockException);
                this.catchBlocks.addElement(blockException);
            } else {
                throw new UnexpectedTokenException(this.tm.getToken(), this.error);
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        int n2;
        int n3 = this.catchClass.size();
        MyClass myClass = null;
        for (int i2 = 0; i2 < n3; ++i2) {
            VariableName variableName = (VariableName)this.catchClass.elementAt(i2);
            if (myClass != null && myClass.isAssignableFrom(variableName.getType())) {
                throw new GeneralErrorException(131, 4, this.keyWord, variableName.getType().getName(), this.error);
            }
            myClass = variableName.getType();
            for (n2 = i2 + 1; n2 < n3; ++n2) {
                if (!variableName.getType().equals(((VariableName)this.catchClass.elementAt(n2)).getType())) continue;
                throw new GeneralErrorException(131, 4, this.keyWord, variableName.getType().getName(), this.error);
            }
            if (variableName.getType().isAssignableTo(Throwable.class) && variableName.getVarDecl().isFactory) continue;
            throw new GeneralErrorException(75, 4, this.keyWord, variableName.getType().getName(), this.error);
        }
        if (this.defException != null) {
            MyClass myClass2 = MyClass.getInstance(Exception.class);
            for (n2 = 0; n2 < n3; ++n2) {
                if (!myClass2.equals(((VariableName)this.catchClass.elementAt(n2)).getType())) continue;
                throw new GeneralErrorException(131, 4, this.keyWord, myClass2.getName(), this.error);
            }
        }
    }

    @Override
    public String getCode() {
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("try ");
        stringBuffer.append(eol);
        stringBuffer.append(this.tryBlock.getCode());
        for (int i2 = 0; i2 < this.catchBlocks.size(); ++i2) {
            VariableName variableName = (VariableName)this.catchClass.elementAt(i2);
            stringBuffer.append(" catch (");
            stringBuffer.append(variableName.getType().getName());
            stringBuffer.append(" ");
            stringBuffer.append(this.parent.getExceptName());
            stringBuffer.append(")");
            stringBuffer.append(eol);
            stringBuffer.append(((Block)this.catchBlocks.elementAt(i2)).getCode());
        }
        if (this.defException != null) {
            stringBuffer.append(" catch (java.lang.Exception ");
            stringBuffer.append(this.parent.getExceptName());
            stringBuffer.append(")");
            stringBuffer.append(eol);
            stringBuffer.append(this.defException.getCode());
        }
        if (this.finallyBlock != null) {
            stringBuffer.append(" finally ");
            stringBuffer.append(this.finallyBlock.getCode());
            stringBuffer.append(eol);
        }
        stringBuffer.append(eol);
        return stringBuffer.toString();
    }

    public Vector getCatchClasses() {
        return this.catchClass;
    }

    public Vector getCatchBlocks() {
        return this.catchBlocks;
    }

    public Block getFinallyBlock() {
        return this.finallyBlock;
    }

    public Block getTryBlock() {
        return this.tryBlock;
    }

    public boolean hasDefaultException() {
        return this.defException != null;
    }
}

