/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.Verb;

public class Unlock
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Select sel;
    private boolean all;

    public Unlock(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 262) {
            this.all = true;
            if (this.pc.getSelectList() == null) {
                this.error.print(53, 2, token2, token2.getWord());
            }
            token2 = this.tm.getToken();
        } else if (token2.getToknum() == 10009) {
            this.sel = this.pc.getSelect(token2.getWord());
            if (this.sel == null) {
                throw new GeneralErrorException(53, 4, token2, token2.getWord(), this.error);
            }
            if (this.sel.isSort()) {
                throw new GeneralErrorException(103, 4, token2, token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 262) {
                token2 = this.tm.getToken();
            }
        } else {
            throw new GeneralErrorException(174, 4, token, token.getWord(), this.error);
        }
        if (token2.getToknum() != 670 && token2.getToknum() != 672) {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.sel != null && this.pc.getDeclarative(this.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        if (this.all) {
            SelectList selectList = this.pc.getSelectList();
            if (selectList == null) {
                return "";
            }
            this.sel = selectList.getFirst();
            while (this.sel != null) {
                if (!this.sel.isSort()) {
                    stringBuffer.append(this.parent.getIndent());
                    stringBuffer.append("if (");
                    stringBuffer.append(this.sel.getName());
                    stringBuffer.append(".isOpen()) ");
                    stringBuffer.append(this.sel.getName());
                    stringBuffer.append(".unlock();");
                    stringBuffer.append(eol);
                }
                this.sel = selectList.getNext();
            }
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("} catch (CobolIOException dex$) {}");
        } else {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append(this.sel.getName());
            stringBuffer.append(".unlock();");
            stringBuffer.append(eol);
            Use.putFileStatus(stringBuffer, this.sel, this.parent.getIndent());
            Use.putDeclaratives(stringBuffer, this.pc, this.sel, this.parent.getIndent(), bl);
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public Select getSelect() {
        return this.sel;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }
}

