/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.Enumeration;
import java.util.Vector;

public class Unstring
extends Verb
implements CobolToken,
ErrorsNumbers {
    VariableName source;
    Vector delimiters = new Vector();
    Vector destVar = new Vector();
    VariableName ptr_var;
    VariableName tally_var;
    Block overflowBlock;
    Block notOverflowBlock;
    boolean delimited;
    private boolean hasNational;

    public Unstring(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.allowAllLitGen = false;
        Token token2 = this.tm.getToken();
        boolean bl = false;
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.source = VariableName.get(this.tm, this.error, this.pc);
        if (!(!this.source.getVarDecl().isNumeric() || this.source.hasSubValue() || this.pc.getOption("-cm") != null && this.source.getVarDecl().isEdited())) {
            throw new GeneralErrorException(66, 4, token2, token2.getWord(), this.error);
        }
        this.setHasNational(this.source);
        token2 = this.tm.getToken();
        if (token2.getToknum() == 398) {
            VariableName variableName;
            this.delimited = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() == 312) {
                token2 = this.tm.getToken();
            }
            if (token2.isFigurativeZero()) {
                token2 = Unstring.cloneToken(token2, 10001, "'0'");
            } else if (token2.isFigurativeHighValue() && this.source.getVarDecl().isNational) {
                token2.setNational(true);
            }
            if (token2.getToknum() == 10001) {
                this.delimiters.addElement(token2);
            } else if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc);
                if (variableName.getVarDecl().isNumeric() && !variableName.hasSubValue()) {
                    if (this.pc.getOption("-ca") == null) {
                        throw new GeneralErrorException(66, 4, token2, token2.getWord(), this.error);
                    }
                    if (!variableName.getVarDecl().isUsageDisplay()) {
                        throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
                    }
                }
                this.setHasNational(variableName);
                this.delimiters.addElement(variableName);
            } else {
                throw new UnexpectedTokenException(token2, this.error);
            }
            token2 = this.tm.getToken();
            while (token2.getToknum() == 617) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 10001) {
                    this.delimiters.addElement(token2);
                } else if (token2.getToknum() == 10009) {
                    this.tm.ungetToken();
                    variableName = VariableName.get(this.tm, this.error, this.pc);
                    if (variableName.getVarDecl().isNumeric()) {
                        throw new GeneralErrorException(66, 4, token2, token2.getWord(), this.error);
                    }
                    this.setHasNational(variableName);
                    this.delimiters.addElement(variableName);
                } else {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = this.tm.getToken();
            }
        }
        if (token2.getToknum() != 542) {
            throw new ExpectedFoundException(token2, this.error, "'INTO'");
        }
        token2 = this.tm.getToken();
        int n2 = 0;
        while (true) {
            VariableName variableName;
            UnstringDestVar unstringDestVar = new UnstringDestVar();
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                if (this.pc.getOption("-cm") == null && (!variableName.getVarDecl().isUsageDisplay() || variableName.getVarDecl().isEdited())) {
                    throw new GeneralErrorException(68, 4, token2, token2.getWord(), this.error);
                }
            } else {
                if (n2 != 0) break;
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            this.setHasNational(variableName);
            unstringDestVar.destVar = variableName;
            this.destVar.addElement(unstringDestVar);
            token2 = this.tm.getToken();
            if (token2.getToknum() == 399) {
                if (!this.delimited) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                token2 = this.tm.getToken();
                if (token2.getToknum() == 526) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                }
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                if (variableName.getVarDecl().isNumeric()) {
                    throw new GeneralErrorException(66, 4, token2, token2.getWord(), this.error);
                }
                this.setHasNational(variableName);
                unstringDestVar.delimDestVar = variableName;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 382) {
                token2 = this.tm.getToken();
                if (!this.delimited) {
                    throw new UnexpectedTokenException(token2, this.error);
                }
                if (token2.getToknum() == 526) {
                    token2 = this.tm.getToken();
                }
                if (token2.getToknum() != 10009) {
                    throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
                }
                this.tm.ungetToken();
                variableName = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                if (!variableName.getVarDecl().isInteger()) {
                    throw new GeneralErrorException(46, 4, token2, token2.getWord(), this.error);
                }
                this.setHasNational(variableName);
                unstringDestVar.counter = variableName;
                token2 = this.tm.getToken();
            }
            ++n2;
        }
        if (token2.getToknum() == 813 && (token2 = this.tm.getToken()).getToknum() != 638) {
            throw new ExpectedFoundException(token2, this.error, "'POINTER'");
        }
        if (token2.getToknum() == 638) {
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.ptr_var = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            if (!this.ptr_var.getVarDecl().isInteger()) {
                throw new GeneralErrorException(46, 4, token2, token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 757) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 526) {
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.tally_var = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            if (!this.tally_var.getVarDecl().isInteger()) {
                throw new GeneralErrorException(46, 4, token2, token2.getWord(), this.error);
            }
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 598 || token2.getToknum() == 613 || token2.getToknum() == 624) {
            n2 = 0;
            if (token2.getToknum() == 598) {
                bl = true;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 613) {
                n2 = 1;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 624) {
                if (bl) {
                    this.notOverflowBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 10);
                } else {
                    this.overflowBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 9);
                }
                token2 = this.tm.getToken();
                if (!bl && token2.getToknum() == 598) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 613) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() == 624) {
                        this.notOverflowBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (bl) {
                    this.tm.ungetToken();
                }
                if (n2 != 0) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 452) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        if (this.overflowBlock != null) {
            stringBuffer.append("if(");
        } else if (this.notOverflowBlock != null) {
            stringBuffer.append("if(!");
        }
        stringBuffer.append(this.source.getCode());
        stringBuffer.append(".unstring");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            stringBuffer.append("Byte");
        }
        stringBuffer.append("(");
        if (this.delimited) {
            stringBuffer.append(this.getDelimitersCode());
            stringBuffer.append("," + eol + this.parent.getIndent());
        }
        stringBuffer.append(this.getDestinationsCode());
        stringBuffer.append("," + eol + this.parent.getIndent());
        stringBuffer.append(this.ptr_var == null ? "null" : this.ptr_var.getCode());
        stringBuffer.append(" , ");
        stringBuffer.append(this.tally_var == null ? "null" : this.tally_var.getCode());
        stringBuffer.append(",");
        stringBuffer.append(this.pc.getOption("-cudc") != null);
        stringBuffer.append(")");
        if (this.overflowBlock != null || this.notOverflowBlock != null) {
            stringBuffer.append(")");
            if (this.overflowBlock != null) {
                stringBuffer.append(this.overflowBlock.getCode());
                if (this.notOverflowBlock != null) {
                    stringBuffer.append(" else ");
                    stringBuffer.append(this.notOverflowBlock.getCode());
                }
            } else if (this.notOverflowBlock != null) {
                stringBuffer.append(this.notOverflowBlock.getCode());
            }
        } else {
            stringBuffer.append(";");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    private String getDestinationsCode() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer.append("new CobolVar[] { ");
        if (this.delimited) {
            stringBuffer2.append("new CobolVar[] { ");
            stringBuffer3.append("new NumericVar[] { ");
        }
        Enumeration enumeration = this.destVar.elements();
        while (enumeration.hasMoreElements()) {
            UnstringDestVar unstringDestVar = (UnstringDestVar)enumeration.nextElement();
            stringBuffer.append(unstringDestVar.destVar.getCode());
            if (this.delimited) {
                stringBuffer2.append(unstringDestVar.delimDestVar == null ? "null" : unstringDestVar.delimDestVar.getCode());
                stringBuffer3.append(unstringDestVar.counter == null ? "null" : unstringDestVar.counter.getCode());
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
            if (!this.delimited) continue;
            stringBuffer2.append(",");
            stringBuffer3.append(",");
        }
        stringBuffer.append(" } ");
        if (this.delimited) {
            stringBuffer2.append(" } ");
            stringBuffer3.append(" } ");
        }
        if (this.delimited) {
            stringBuffer.append("," + eol + this.parent.getIndent()).append(stringBuffer2.toString()).append("," + eol + this.parent.getIndent()).append(stringBuffer3.toString());
        }
        return stringBuffer.toString();
    }

    static Token cloneToken(Token token, int n2, String string) {
        Token token2 = new Token(token);
        token2.setToknum(n2);
        token2.setWord(string);
        token2.setAll(token.isAll());
        return token2;
    }

    private String getDelimitersCode() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("new CobolVar[] { ");
        stringBuffer2.append("new boolean[] { ");
        Enumeration enumeration = this.delimiters.elements();
        while (enumeration.hasMoreElements()) {
            CobolToken cobolToken;
            CobolToken cobolToken2 = (CobolToken)enumeration.nextElement();
            if (cobolToken2 instanceof Token) {
                cobolToken = (Token)cobolToken2;
                stringBuffer2.append(((Token)cobolToken).isAll());
                if (((Token)cobolToken).isAll()) {
                    ((Token)cobolToken).setAll(false);
                }
                stringBuffer.append(this.getCodeLiteral((Token)cobolToken));
            } else {
                cobolToken = (VariableName)cobolToken2;
                stringBuffer2.append(((VariableName)cobolToken).getNameToken().isAll());
                stringBuffer.append(((VariableName)cobolToken).getCode());
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
            stringBuffer2.append(",");
        }
        stringBuffer.append(" } ");
        stringBuffer2.append(" } ");
        return stringBuffer.append("," + eol + this.parent.getIndent()).append(stringBuffer2.toString()).toString();
    }

    public Block getOverflowBlock() {
        return this.overflowBlock;
    }

    public Block getNotOverflowBlock() {
        return this.notOverflowBlock;
    }

    public VariableName getPtrVar() {
        return this.ptr_var;
    }

    public VariableName getTallyVar() {
        return this.tally_var;
    }

    public Vector getDestVars() {
        return this.destVar;
    }

    public Vector getDelimiters() {
        return this.delimiters;
    }

    public VariableName getSource() {
        return this.source;
    }

    public boolean isDelimited() {
        return this.delimited;
    }

    private void setHasNational(VariableName variableName) {
        if (!this.hasNational) {
            VariableDeclaration variableDeclaration = variableName.getVarDecl();
            this.hasNational = variableDeclaration != null && (variableDeclaration.isNational() || variableDeclaration.isPicG());
        }
    }

    public class UnstringDestVar {
        VariableName destVar = null;
        VariableName delimDestVar = null;
        VariableName counter = null;

        public VariableName getDestVar() {
            return this.destVar;
        }

        public VariableName getDelimDestVar() {
            return this.delimDestVar;
        }

        public VariableName getCounter() {
            return this.counter;
        }
    }
}

