/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.StringList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Use
extends Verb
implements CobolToken,
ErrorsNumbers {
    boolean global;
    TokenList typeTok = new TokenList();
    StringList typeVar = new StringList();
    Paragraph parag;
    private LabelName debuggingParagraph;
    private boolean debuggingAllProcedures;

    public Use(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.parag = this.parent.parent;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 502) {
            this.global = true;
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 299) {
            this.rwUse();
            return;
        }
        if (token2.getToknum() == 284 || token2.getToknum() == 653) {
            this.prgUse(token2);
            return;
        }
        if (token2.getToknum() == 494) {
            if (this.pc.getOption("-cv") == null) {
                throw new UnexpectedTokenException(token2, this.error);
            }
            this.forUse(this.tm.getToken());
            return;
        }
        if (token2.getWord().equals("DEBUGGING")) {
            if (this.pc.getOption("-cv") == null) {
                throw new UnexpectedTokenException(token2, this.error);
            }
            this.forUse(token2);
            return;
        }
        if (token2.getToknum() == 261) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 739) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() != 472 && token2.getToknum() != 465) {
            throw new ExpectedFoundException(token2, this.error, "ERROR/EXCEPTION");
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 651) {
            token2 = this.tm.getToken();
        }
        if (token2.getToknum() == 613) {
            token2 = this.tm.getToken();
        }
        boolean bl = true;
        block8: while (bl) {
            switch (token2.getToknum()) {
                case 534: {
                    if (this.pc.declInput != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "INPUT", this.error);
                    }
                    this.pc.declInput = this.parag.getName();
                    this.typeTok.addItem(token2);
                    token2 = this.tm.getToken();
                    continue block8;
                }
                case 623: {
                    if (this.pc.declOutput != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "OUTPUT", this.error);
                    }
                    this.pc.declOutput = this.parag.getName();
                    this.typeTok.addItem(token2);
                    token2 = this.tm.getToken();
                    continue block8;
                }
                case 518: {
                    if (this.pc.declIO != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "I-O", this.error);
                    }
                    this.pc.declIO = this.parag.getName();
                    this.typeTok.addItem(token2);
                    token2 = this.tm.getToken();
                    continue block8;
                }
                case 477: {
                    if (this.pc.declExtend != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "EXTEND", this.error);
                    }
                    this.pc.declExtend = this.parag.getName();
                    this.typeTok.addItem(token2);
                    token2 = this.tm.getToken();
                    continue block8;
                }
                case 777: {
                    if (this.pc.declTransaction != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, "TRANSACTION", this.error);
                    }
                    this.pc.declTransaction = this.parag.getName();
                    this.typeTok.addItem(token2);
                    token2 = this.tm.getToken();
                    continue block8;
                }
                case 10009: {
                    Select select = this.pc.getSelect(token2.getWord());
                    if (select == null) {
                        throw new GeneralErrorException(53, 4, this.keyWord, token2.getWord(), this.error);
                    }
                    if (this.pc.getDeclarative(select) != null) {
                        throw new GeneralErrorException(65, 4, this.keyWord, this.pc.getDeclarative(select), this.error);
                    }
                    this.pc.putDeclarative(select, this.parag.getName());
                    this.typeVar.addItem(token2.getWord());
                    token2 = this.tm.getToken();
                    if (this.pc.getOption("-cv") == null || token2.getToknum() != 505) continue block8;
                    select.useGiving = VariableName.get(this.tm, this.error, this.pc);
                    if (select.useGiving == null) {
                        token2 = this.tm.getToken();
                        throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                    }
                    token2 = this.tm.getToken();
                    continue block8;
                }
            }
            this.tm.ungetToken();
            bl = false;
        }
        if (this.typeVar.getItemNum() + this.typeTok.getItemNum() == 0) {
            throw new UnexpectedTokenException(token2, this.error);
        }
        if (!this.parag.isSection || this.parent.verbs.getItemNum() > 0) {
            throw new GeneralErrorException(64, 4, this.keyWord, "", this.error);
        }
    }

    private void rwUse() throws GeneralErrorException, EndOfProgramException {
        ReportGroup reportGroup = null;
        Token token = this.tm.getToken();
        if (!token.getWord().equals("REPORTING")) {
            throw new ExpectedFoundException(token, this.error, "REPORTING");
        }
        token = this.tm.getToken();
        if (token.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        Token token2 = token;
        token = this.tm.getToken();
        if (token.getToknum() == 609 || token.getToknum() == 526) {
            token = this.tm.getToken();
            if (token.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
            ReportDescriptor reportDescriptor = this.pc.getReport(token);
            if (reportDescriptor == null) {
                throw new GeneralErrorException(181, 4, token, token.getWord(), this.error);
            }
            reportGroup = reportDescriptor.getReportGroup(token2);
            if (reportGroup == null) {
                throw new GeneralErrorException(181, 4, token2, token2.getWord(), this.error);
            }
        } else {
            this.tm.ungetToken();
            ReportDescriptor reportDescriptor = this.pc.getReport(token2);
            if (reportDescriptor == null) {
                reportGroup = this.pc.getReportGroup(token2);
                if (reportGroup == null) {
                    throw new GeneralErrorException(181, 4, token2, token2.getWord(), this.error);
                }
                reportDescriptor = reportGroup.rd;
            }
        }
        if (reportGroup != null) {
            if (reportGroup.use != null) {
                throw new GeneralErrorException(65, 4, this.keyWord, "REPORTING", this.error);
            }
            reportGroup.use = this;
        }
    }

    private void prgUse(Token token) throws GeneralErrorException, EndOfProgramException {
        if (!(this.pc instanceof CobolProgram)) {
            throw new GeneralErrorException(209, 4, this.keyWord, "USE PROGRAM", this.error);
        }
        CobolProgram cobolProgram = (CobolProgram)this.pc;
        if (token.getToknum() == 284) {
            token = this.tm.getToken();
        }
        if (token.getToknum() != 653) {
            throw new ExpectedFoundException(token, this.error, "PROGRAM");
        }
        token = this.tm.getToken();
        if (token.getToknum() == 741) {
            if (!cobolProgram.setAtProgramStart(this)) {
                throw new GeneralErrorException(65, 4, this.keyWord, "PROGRAM START", this.error);
            }
        } else if (token.getToknum() == 422) {
            if (!cobolProgram.setAtProgramEnd(this)) {
                throw new GeneralErrorException(65, 4, this.keyWord, "PROGRAM END", this.error);
            }
        } else {
            throw new ExpectedFoundException(token, this.error, "START|END");
        }
        if (!this.parag.isSection || this.parent.verbs.getItemNum() > 0) {
            throw new GeneralErrorException(64, 4, this.keyWord, "", this.error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void forUse(Token token) throws GeneralErrorException, EndOfProgramException {
        if (!token.getWord().equals("DEBUGGING")) throw new ExpectedFoundException(token, this.error, "DEBUGGING");
        token = this.tm.getToken();
        if (token.getToknum() == 613) {
            token = this.tm.getToken();
        }
        if (token.isAll()) {
            if (!token.getWord().equals("PROCEDURES")) throw new ExpectedFoundException(token, this.error, "PROCEDURES");
            this.debuggingAllProcedures = true;
        } else {
            if (token.getToknum() != 10009) throw new ExpectedFoundException(token, this.error, "ALL|PARAGRAPH NAME");
            this.tm.ungetToken();
            this.debuggingParagraph = LabelName.get(null, this.tm, this.error, this.pc);
        }
        if (this.parag.isSection && this.parent.verbs.getItemNum() <= 0) return;
        throw new GeneralErrorException(64, 4, this.keyWord, "", this.error);
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.debuggingAllProcedures) {
            if (!this.pc.addUseForDebugging(this.parag, Integer.MAX_VALUE)) {
                throw new GeneralErrorException(65, 4, this.keyWord, "", this.error);
            }
        } else if (this.debuggingParagraph != null) {
            int[] nArray = new int[2];
            String string = Perform.check(this.debuggingParagraph, null, nArray, false, false, this.pc);
            if ("declaratives".equals(string)) {
                nArray[0] = -nArray[0];
            }
            if (!this.pc.addUseForDebugging(this.parag, nArray[0])) {
                throw new GeneralErrorException(65, 4, this.keyWord, "", this.error);
            }
        }
    }

    @Override
    public String getCode() {
        return "";
    }

    static void putDeclaratives(StringBuffer stringBuffer, Pcc pcc, Select select, String string, boolean bl) {
        Use.putDeclaratives(stringBuffer, pcc, select, string, select.getName() + ".getOpenMode()", bl);
    }

    static void putFileStatus(StringBuffer stringBuffer, Select select, String string) {
        if (select.getFileStatus() != null) {
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append(select.getFileStatus().getCode());
            stringBuffer.append(".set (");
            stringBuffer.append(select.getName());
            stringBuffer.append(".getFileStatus());");
        }
    }

    static void putDeclaratives(StringBuffer stringBuffer, Pcc pcc, Select select, String string, String string2, boolean bl) {
        boolean bl2 = select.getFileStatus() != null;
        stringBuffer.append(eol);
        stringBuffer.append(string);
        stringBuffer.append("} catch (CobolIOException dex$) {");
        Use.putFileStatus(stringBuffer, select, string);
        stringBuffer.append(eol);
        stringBuffer.append(string);
        if (bl) {
            if (pcc.getDeclarative(select) != null) {
                if (select.useGiving != null) {
                    stringBuffer.append(select.useGiving.getCode());
                    stringBuffer.append(".set (Functions.vsUseGiving(dex$.getErrNum()));");
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                }
                Paragraph paragraph = pcc.getDeclParagraph(pcc.getDeclarative(select), null);
                int n2 = paragraph.getIdNumber();
                paragraph = paragraph.getLastParagraphInSameSection();
                int n3 = paragraph.getIdNumber();
                stringBuffer.append("declaratives (");
                stringBuffer.append(n2);
                stringBuffer.append(",");
                stringBuffer.append(n3);
                stringBuffer.append(");");
            } else {
                int n4;
                int n5;
                Paragraph paragraph;
                stringBuffer.append("switch (");
                stringBuffer.append(string2);
                stringBuffer.append(") {");
                if (pcc.declInput != null) {
                    paragraph = pcc.getDeclParagraph(pcc.declInput, null);
                    n5 = paragraph.getIdNumber();
                    paragraph = paragraph.getLastParagraphInSameSection();
                    n4 = paragraph.getIdNumber();
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                    stringBuffer.append("case CobolFile.OPEN_INPUT: declaratives (");
                    stringBuffer.append(n5);
                    stringBuffer.append(",");
                    stringBuffer.append(n4);
                    stringBuffer.append("); break;");
                }
                if (pcc.declOutput != null) {
                    paragraph = pcc.getDeclParagraph(pcc.declOutput, null);
                    n5 = paragraph.getIdNumber();
                    paragraph = paragraph.getLastParagraphInSameSection();
                    n4 = paragraph.getIdNumber();
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                    stringBuffer.append("case CobolFile.OPEN_OUTPUT: declaratives (");
                    stringBuffer.append(n5);
                    stringBuffer.append(",");
                    stringBuffer.append(n4);
                    stringBuffer.append("); break;");
                }
                if (pcc.declIO != null) {
                    paragraph = pcc.getDeclParagraph(pcc.declIO, null);
                    n5 = paragraph.getIdNumber();
                    paragraph = paragraph.getLastParagraphInSameSection();
                    n4 = paragraph.getIdNumber();
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                    stringBuffer.append("case CobolFile.OPEN_IO: declaratives (");
                    stringBuffer.append(n5);
                    stringBuffer.append(",");
                    stringBuffer.append(n4);
                    stringBuffer.append("); break;");
                }
                if (pcc.declExtend != null) {
                    paragraph = pcc.getDeclParagraph(pcc.declExtend, null);
                    n5 = paragraph.getIdNumber();
                    paragraph = paragraph.getLastParagraphInSameSection();
                    n4 = paragraph.getIdNumber();
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                    stringBuffer.append("case CobolFile.OPEN_EXTEND: declaratives (");
                    stringBuffer.append(n5);
                    stringBuffer.append(",");
                    stringBuffer.append(n4);
                    stringBuffer.append("); break;");
                    stringBuffer.append(eol);
                    stringBuffer.append(string);
                }
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append("default: if (!CobolIOException.isErrorsOk(");
                stringBuffer.append(bl2);
                stringBuffer.append(")) throw new CobolIOException(dex$);");
                stringBuffer.append(eol);
                stringBuffer.append(string);
                stringBuffer.append("}");
            }
        } else {
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("if (!CobolIOException.isErrorsOk(");
            stringBuffer.append(bl2);
            stringBuffer.append(")) throw new CobolIOException(dex$);");
        }
        stringBuffer.append(eol);
        stringBuffer.append(string);
        stringBuffer.append("}");
        stringBuffer.append(eol);
    }

    static void putDeclTransaction(StringBuffer stringBuffer, Pcc pcc, String string) {
        stringBuffer.append(string);
        stringBuffer.append(Verb.getLocalVar("TRANSACTION-STATUS", pcc.capitalizeNames) + ".set (\"00\");");
        stringBuffer.append(eol);
        stringBuffer.append(string);
        stringBuffer.append("} catch (TransactionException dex$) {");
        stringBuffer.append(eol);
        stringBuffer.append(string);
        stringBuffer.append(Verb.getLocalVar("TRANSACTION-STATUS", pcc.capitalizeNames) + ".set (dex$.getTransactionStatus());");
        stringBuffer.append(eol);
        stringBuffer.append(string);
        if (pcc.declTransaction != null) {
            Paragraph paragraph = pcc.getDeclParagraph(pcc.declTransaction, null);
            int n2 = paragraph.getIdNumber();
            paragraph = paragraph.getLastParagraphInSameSection();
            int n3 = paragraph.getIdNumber();
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("declaratives (");
            stringBuffer.append(n2);
            stringBuffer.append(",");
            stringBuffer.append(n3);
            stringBuffer.append(");");
            stringBuffer.append(eol);
            stringBuffer.append(string);
        } else {
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("if (!CobolIOException.isErrorsOk(true)) throw new CobolIOException(dex$);");
        }
        stringBuffer.append(eol);
        stringBuffer.append(string);
        stringBuffer.append("}");
        stringBuffer.append(eol);
    }

    public Paragraph getParagraph() {
        return this.parag;
    }
}

