/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.Function;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GenericObject;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.InlineSetGetProperty;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.MalformedDataNameException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.OffsetHelper;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SubValueList;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.interfaces.compiler.IVariableName;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;

public class VariableName
implements CobolToken,
ErrorsNumbers,
GenericObject,
IVariableName {
    Token name;
    boolean rounded;
    VariableDeclaration varDecl;
    private VariableName of;
    private SubscriptList indexes;
    private SubValueList subValue;
    private Errors error;
    private Token function;
    private VariableDeclaration functionVar;
    private boolean isSpecial;
    boolean isSelf;
    boolean isSuper;
    private boolean isAll;
    private boolean hasAllSubscript;
    private final Pcc pc;
    private boolean lambdaExpr;
    private String sqlCallMode;
    public int sqlTypeFunc = -1;
    public boolean sqlTypeCast = false;
    private String sqljName = null;
    private String sqljNameParam = null;
    private static final int RECORD_POSITION = 1;
    private static final int FUNCTION = 2;
    private static final int LENGTH_OF = 3;
    private static final int EXCEPTION_OBJECT = 4;
    private static final int LINAGE_COUNTER = 5;
    private static final int CURRENT_DATE = 6;
    private static final int TIME_OF_DAY = 7;
    private static final int WHEN_COMPILED = 8;
    private static final int ADDRESS_OF = 9;
    private static final int PROG_ID = 10;
    private static final Hashtable specialNames = new Hashtable();

    static int isSpecialName(String string, TokenManager tokenManager) {
        Integer n2 = (Integer)specialNames.get(string);
        if (n2 != null) {
            if (tokenManager.isNotReservedWord(string)) {
                switch (n2) {
                    case 8: 
                    case 10: {
                        if (tokenManager.getOptionList().getOption("-cr") != null) {
                            return n2;
                        }
                        return 0;
                    }
                }
                return 0;
            }
            return n2;
        }
        return 0;
    }

    public static VariableName get(TokenManager tokenManager, Errors errors) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tokenManager, errors, null);
    }

    private void checkIndexes(Pcc pcc) throws GeneralErrorException {
        if (this.indexes != null) {
            Subscript subscript = this.indexes.getFirst();
            while (subscript != null) {
                subscript.check(this.name, this.error, pcc);
                subscript = this.indexes.getNext();
            }
        }
    }

    public void checkAny(Pcc pcc, GetVarOpts getVarOpts) throws GeneralErrorException {
        this.associateToVarDeclAny(pcc, true, true, getVarOpts);
        this.checkIndexes(pcc);
    }

    public void checkObject(Pcc pcc) throws GeneralErrorException {
        this.associateToVarDeclObj(pcc);
        this.checkIndexes(pcc);
    }

    public void check(Pcc pcc) throws GeneralErrorException {
        this.check(pcc, true, true, GetVarOpts.NO_OPTS);
    }

    public void check(Pcc pcc, boolean bl, boolean bl2, GetVarOpts getVarOpts) throws GeneralErrorException {
        this.associateToVarDeclVar(pcc, bl, bl2, getVarOpts);
        this.checkIndexes(pcc);
    }

    public static VariableName getAny(TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        return VariableName.getAny(tokenManager, errors, null, pcc, GetVarOpts.NO_OPTS);
    }

    public static VariableName getAny(TokenManager tokenManager, Errors errors, Block block, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        return VariableName.getAny(tokenManager, errors, block, pcc, GetVarOpts.NO_OPTS);
    }

    public static VariableName getAny(TokenManager tokenManager, Errors errors, Block block, Pcc pcc, GetVarOpts getVarOpts) throws EndOfProgramException, GeneralErrorException {
        VariableName variableName = VariableName.internalGet(tokenManager, errors, block, pcc);
        if (variableName != null) {
            if (pcc != null) {
                variableName.checkAny(pcc, getVarOpts);
            }
            VariableName.checkDynGroup(variableName, getVarOpts.dynGroupAllowed, errors);
        }
        return variableName;
    }

    public static VariableName getAnyUsing(TokenManager tokenManager, Errors errors, Block block, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        VariableName variableName = VariableName.internalGet(tokenManager, errors, block, pcc);
        if (variableName != null) {
            if (pcc != null) {
                variableName.associateToVarDeclAny(pcc, false, true, GetVarOpts.DYN_GRP_ALLOW);
                variableName.checkIndexes(pcc);
            }
            VariableName.checkDynGroup(variableName, true, errors);
        }
        return variableName;
    }

    static void checkDynGroup(VariableName variableName, boolean bl, Errors errors) {
        if (variableName.getVarDecl() != null && variableName.getVarDecl().isVariableLengthGroup() && (variableName.hasSubValue() && bl || !variableName.hasSubValue() && !bl)) {
            errors.print(257, 2, variableName.getNameToken(), variableName.getName());
        }
    }

    public static VariableName getObject(TokenManager tokenManager, Errors errors, Block block, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        VariableName variableName = VariableName.internalGet(tokenManager, errors, block, pcc);
        if (variableName != null && pcc != null) {
            if ("SELF".equals(variableName.name.getWord())) {
                variableName.setVarDecl(pcc.getSelfVarDecl());
            } else {
                variableName.checkObject(pcc);
            }
        }
        return variableName;
    }

    public static VariableName get(TokenManager tokenManager, Errors errors, Pcc pcc, GetVarOpts getVarOpts) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tokenManager, errors, null, pcc, true, true, true, true, getVarOpts);
    }

    public static VariableName get(TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tokenManager, errors, pcc, true);
    }

    public static VariableName get(TokenManager tokenManager, Errors errors, Pcc pcc, boolean bl) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tokenManager, errors, pcc, bl, true);
    }

    public static VariableName get(TokenManager tokenManager, Errors errors, Pcc pcc, boolean bl, boolean bl2) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tokenManager, errors, null, pcc, bl, bl2);
    }

    public static VariableName get(TokenManager tokenManager, Errors errors, Block block, Pcc pcc, boolean bl, boolean bl2) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tokenManager, errors, block, pcc, bl, bl2, true, true, GetVarOpts.NO_OPTS);
    }

    public static VariableName get(TokenManager tokenManager, Errors errors, Block block, Pcc pcc, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tokenManager, errors, block, pcc, bl, bl2, bl3, bl4, GetVarOpts.NO_OPTS);
    }

    public static VariableName get(TokenManager tokenManager, Errors errors, Block block, Pcc pcc, boolean bl, boolean bl2, boolean bl3, boolean bl4, GetVarOpts getVarOpts) throws EndOfProgramException, GeneralErrorException {
        return VariableName.get(tokenManager, errors, block, pcc, bl, bl2, bl3, bl4, getVarOpts, false);
    }

    public static VariableName get(TokenManager tokenManager, Errors errors, Block block, Pcc pcc, boolean bl, boolean bl2, boolean bl3, boolean bl4, GetVarOpts getVarOpts, boolean bl5) throws EndOfProgramException, GeneralErrorException {
        VariableName variableName = VariableName.internalGet(tokenManager, errors, block, pcc, bl5);
        if (variableName != null) {
            if (pcc != null && bl2) {
                variableName.check(pcc, bl, bl4, getVarOpts);
                if (bl3) {
                    VariableDeclarationScreen.checkScreenName(variableName.getVarDecl(), variableName.getNameToken(), errors);
                }
            }
            VariableName.checkDynGroup(variableName, getVarOpts.dynGroupAllowed, errors);
        }
        return variableName;
    }

    private static VariableName internalGet(TokenManager tokenManager, Errors errors, Block block, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        return VariableName.internalGet(tokenManager, errors, block, pcc, true);
    }

    private static VariableName internalGet(TokenManager tokenManager, Errors errors, Block block, Pcc pcc, boolean bl) throws EndOfProgramException, GeneralErrorException {
        VariableName variableName = null;
        TokenManager.Marker marker = tokenManager.getMarker();
        tokenManager.setMarker(marker);
        Token token = tokenManager.getToken();
        boolean bl2 = token.isAll();
        if (token.getToknum() == 10018) {
            token = new Token(10009, "SELF", token.getFLN(), token.getOffset(), token.getFileName());
            tokenManager.ungetToken();
        }
        if (token.getToknum() == 10009 || token.getToknum() == 259) {
            Function function;
            Token token2;
            Object object;
            Token token3 = token;
            boolean bl3 = false;
            Token token4 = tokenManager.getToken();
            if (token3.getWord().startsWith("->")) {
                if (token4.getToknum() != 10018) {
                    throw new GeneralErrorException(274, 4, token3, token4.getWord(), errors);
                }
                token3.setWord(token3.getWord().substring(2).toUpperCase(Locale.US).replace(Pcc.hyphenRepl, '-'));
                bl3 = true;
            }
            if (token4.getToknum() == 10018 && pcc != null) {
                object = new VariableName(token, tokenManager, errors, pcc);
                ((VariableName)object).lambdaExpr = bl3;
                if ("SELF".equals(((VariableName)object).getName())) {
                    ((VariableName)object).isSelf = true;
                } else if ("SUPER".equals(((VariableName)object).getName())) {
                    ((VariableName)object).isSuper = true;
                } else {
                    ((VariableName)object).checkObject(pcc);
                }
                if (((VariableName)object).isObjectReference()) {
                    Token token5 = new Token(((VariableName)object).getNameToken());
                    token5.setWord(token5.getWord() + "::");
                    variableName = new VariableName(token5);
                    variableName.lambdaExpr = bl3;
                    variableName.error = errors;
                    variableName.varDecl = new InlineInvoke((VariableName)object, block, pcc, token, tokenManager, errors);
                    variableName.isAll = bl2;
                    return variableName;
                }
            }
            tokenManager.ungetToken();
            if (VariableName.isSpecialName(token.getWord(), tokenManager) == 1) {
                token2 = token;
                function = new Function(pcc, token, tokenManager, true);
                token = tokenManager.getToken();
                if (token.getToknum() == 609) {
                    token = tokenManager.getToken();
                }
            } else {
                token2 = null;
                function = null;
            }
            try {
                variableName = new VariableName(token, tokenManager, errors, pcc);
                if (!variableName.isSpecial) {
                    variableName.function = token2;
                    variableName.functionVar = function;
                }
            }
            catch (MalformedDataNameException malformedDataNameException) {
                tokenManager.rewindToMarker(marker);
                throw new MalformedDataNameException(token3, errors);
            }
            token = tokenManager.getToken();
            if (token.getToknum() == 40) {
                object = tokenManager.getMarker();
                tokenManager.setMarker((TokenManager.Marker)object);
                Subscript subscript = VariableName.getSubscript(tokenManager, errors, pcc);
                if (subscript == null && !bl) {
                    throw new MalformedDataNameException(token3, errors);
                }
                if (subscript != null) {
                    token = tokenManager.getToken();
                    if (token.getToknum() == 58) {
                        variableName.getSubValue(subscript, tokenManager, errors, pcc);
                        token = tokenManager.getToken();
                        if (token.getToknum() != 41) {
                            throw new MalformedDataNameException(token3, errors);
                        }
                    } else {
                        if (VariableName.isSpecialName(variableName.name.getWord(), tokenManager) == 2) {
                            throw new GeneralErrorException(80, 4, variableName.name, "", errors);
                        }
                        variableName.indexes = new SubscriptList();
                        variableName.indexes.addItem(subscript);
                        tokenManager.ungetToken();
                        while ((token = tokenManager.getToken()).getToknum() != 41) {
                            tokenManager.ungetToken();
                            subscript = VariableName.getSubscript(tokenManager, errors, pcc);
                            if (subscript == null) {
                                throw new MalformedDataNameException(token3, errors);
                            }
                            variableName.indexes.addItem(subscript);
                        }
                        TokenManager.Marker marker2 = tokenManager.getMarker();
                        tokenManager.setMarker(marker2);
                        token = tokenManager.getToken();
                        if (token.getToknum() == 40) {
                            subscript = VariableName.getSubscript(tokenManager, errors, pcc);
                            if (subscript == null) {
                                throw new MalformedDataNameException(token3, errors);
                            }
                            token = tokenManager.getToken();
                            if (token.getToknum() == 58) {
                                variableName.getSubValue(subscript, tokenManager, errors, pcc);
                                token = tokenManager.getToken();
                                if (token.getToknum() != 41) {
                                    throw new MalformedDataNameException(token3, errors);
                                }
                            } else {
                                tokenManager.rewindToMarker(marker2);
                            }
                        } else {
                            tokenManager.ungetToken();
                        }
                        if (tokenManager.getToken().getToknum() == 10018 && pcc != null) {
                            variableName.checkObject(pcc);
                            VariableName variableName2 = variableName;
                            Token token6 = new Token(variableName2.getNameToken());
                            token6.setWord(token6.getWord() + "::");
                            variableName = new VariableName(token6);
                            variableName.error = errors;
                            variableName.varDecl = new InlineInvoke(variableName2, block, pcc, token, tokenManager, errors);
                            variableName.isAll = bl2;
                            return variableName;
                        }
                        tokenManager.ungetToken();
                    }
                } else {
                    tokenManager.rewindToMarker((TokenManager.Marker)object);
                    tokenManager.ungetToken();
                }
            } else {
                tokenManager.ungetToken();
            }
        } else {
            tokenManager.rewindToMarker(marker);
        }
        if (variableName != null) {
            variableName.isAll = bl2;
        }
        return variableName;
    }

    public static VariableName getTableItemWithAll(TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        VariableName variableName = null;
        TokenManager.Marker marker = tokenManager.getMarker();
        tokenManager.setMarker(marker);
        Token token = tokenManager.getToken();
        if (token.getToknum() == 10009 && VariableName.isSpecialName(token.getWord(), tokenManager) == 0) {
            try {
                variableName = new VariableName(token, tokenManager, errors, pcc);
                token = tokenManager.getToken();
                if (token.getToknum() == 40) {
                    Subscript subscript = Subscript.getWithAll(tokenManager, errors, pcc);
                    if (subscript == null) {
                        variableName = null;
                    } else {
                        variableName.indexes = new SubscriptList();
                        variableName.hasAllSubscript |= subscript.isAll();
                        variableName.indexes.addItem(subscript);
                        while ((token = tokenManager.getToken(false)).getToknum() != 41) {
                            tokenManager.ungetToken();
                            subscript = Subscript.getWithAll(tokenManager, errors, pcc);
                            if (subscript == null) {
                                throw new MalformedDataNameException(null, errors);
                            }
                            variableName.hasAllSubscript |= subscript.isAll();
                            variableName.indexes.addItem(subscript);
                        }
                    }
                } else {
                    variableName = null;
                }
            }
            catch (MalformedDataNameException malformedDataNameException) {
                variableName = null;
            }
        }
        if (variableName == null || !variableName.hasAllSubscript) {
            variableName = null;
            tokenManager.rewindToMarker(marker);
        } else {
            variableName.checkAny(pcc, GetVarOpts.NO_OPTS);
        }
        return variableName;
    }

    public VariableName(Token token) {
        this.name = token;
        this.pc = null;
    }

    public VariableName(String string) {
        this(new Token(10009, string, 0, 0, "dummy"));
    }

    public VariableName(VariableDeclaration variableDeclaration) {
        this(new Token(10009, variableDeclaration.getName(), 0, 0, variableDeclaration.getNameToken() != null ? variableDeclaration.getNameToken().getFileName() : "dummy"));
        this.varDecl = variableDeclaration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VariableName(Token token, final TokenManager tokenManager, final Errors errors, final Pcc pcc) throws EndOfProgramException, MalformedDataNameException, GeneralErrorException {
        this.name = token;
        this.error = errors;
        this.pc = pcc;
        switch (VariableName.isSpecialName(token.getWord(), tokenManager)) {
            case 2: {
                this.function = token;
                this.varDecl = this.functionVar = new Function(pcc, token, tokenManager, errors);
                this.isSpecial = true;
                return;
            }
            case 9: {
                if (pcc == null) {
                    throw new GeneralErrorException(15, 4, token, token.getWord(), errors);
                }
            }
            case 3: {
                this.function = token;
                tokenManager.ungetToken();
                this.varDecl = this.functionVar = new Function(pcc, token, tokenManager, errors);
                this.isSpecial = true;
                return;
            }
            case 4: {
                Block block;
                if (pcc == null || (block = pcc.getCurrentBlock()) == null || !block.isExceptionBlock()) return;
                final String string = block.getParentExceptName();
                this.varDecl = new VariableDeclaration(tokenManager){
                    {
                        super(tokenManager3);
                        this.pc = pcc;
                        this.tm = tokenManager;
                        this.error = errors;
                        this.setClassName("java.lang.Throwable");
                    }

                    @Override
                    public String getUnivoqueName() {
                        return string;
                    }
                };
                this.isSpecial = true;
                return;
            }
            case 5: {
                Select select;
                this.function = token;
                Token token2 = tokenManager.getToken();
                if (token2.getToknum() == 609) {
                    token2 = tokenManager.getToken();
                    if (token2.getToknum() != 10009) throw new GeneralErrorException(24, 4, token2, token2.getWord(), errors);
                    select = pcc.getSelect(token2.getWord());
                } else {
                    tokenManager.ungetToken();
                    select = pcc.getLinageSelect(token, errors);
                }
                if (select == null) {
                    throw new GeneralErrorException(53, 4, token, token.getWord(), errors);
                }
                if (!select.hasLinage()) {
                    throw new GeneralErrorException(117, 4, token, token.getWord(), errors);
                }
                this.varDecl = this.functionVar = new Function(pcc, new Token(10009, "Factory.getNumLiteral (" + select.getName() + ".linageCounter(),10,0,false)", token.getFLN(), token.getOffset(), token.getFileName()), tokenManager, true);
                this.isSpecial = true;
                return;
            }
            case 6: {
                this.varDecl = this.functionVar = new Function(pcc, new Token(10009, "Functions.vsCurrentDate()", token.getFLN(), token.getOffset(), token.getFileName()), tokenManager, true);
                return;
            }
            case 7: {
                this.varDecl = this.functionVar = new Function(pcc, new Token(10009, "Functions.vsTimeOfDay()", token.getFLN(), token.getOffset(), token.getFileName()), tokenManager, true);
                return;
            }
            case 8: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                StringBuffer stringBuffer = new StringBuffer();
                if (this.pc.getOption("-cr") != null) {
                    int n2 = gregorianCalendar.get(11);
                    if (n2 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n2);
                    stringBuffer.append(".");
                    n2 = gregorianCalendar.get(12);
                    if (n2 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n2);
                    stringBuffer.append(".");
                    n2 = gregorianCalendar.get(13);
                    if (n2 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n2);
                    stringBuffer.append(gregorianCalendar.getDisplayName(2, 1, Locale.getDefault()));
                    stringBuffer.append(" ");
                    n2 = gregorianCalendar.get(5);
                    if (n2 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n2);
                    stringBuffer.append(", ");
                    n2 = gregorianCalendar.get(1);
                    stringBuffer.append(n2);
                } else {
                    int n3 = gregorianCalendar.get(2) + 1;
                    if (n3 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n3);
                    stringBuffer.append("/");
                    n3 = gregorianCalendar.get(5);
                    if (n3 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n3);
                    stringBuffer.append("/");
                    n3 = gregorianCalendar.get(1) % 100;
                    if (n3 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n3);
                    n3 = gregorianCalendar.get(11);
                    if (n3 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n3);
                    stringBuffer.append(".");
                    n3 = gregorianCalendar.get(12);
                    if (n3 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n3);
                    stringBuffer.append(".");
                    n3 = gregorianCalendar.get(13);
                    if (n3 < 10) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(n3);
                }
                this.varDecl = this.functionVar = new Function(pcc, new Token(10009, "Factory.getStrLiteral(\"" + stringBuffer + "\")", token.getFLN(), token.getOffset(), token.getFileName()), tokenManager, true);
                return;
            }
            case 10: {
                String string = "";
                if (this.pc instanceof CobolProgram) {
                    string = ((CobolProgram)this.pc).getCobolProgramName();
                }
                this.varDecl = this.functionVar = new Function(pcc, new Token(10009, "Factory.getStrLiteral(\"" + string + "\")", token.getFLN(), token.getOffset(), token.getFileName()), tokenManager, true);
                return;
            }
            default: {
                if (pcc != null && pcc.isExecMacro(token)) {
                    String string = pcc.getExecMacro(token, tokenManager);
                    this.varDecl = this.functionVar = new Function(pcc, new Token(10009, string, token.getFLN(), token.getOffset(), token.getFileName()), tokenManager, true);
                    return;
                }
                Token token3 = tokenManager.getToken();
                if (token3.getToknum() == 609 || token3.getToknum() == 526) {
                    token3 = tokenManager.getToken();
                    if (token3.getToknum() == 10009) {
                        this.of = new VariableName(token3, tokenManager, errors, pcc);
                        return;
                    }
                    tokenManager.ungetToken();
                    tokenManager.ungetToken();
                    return;
                }
                tokenManager.ungetToken();
            }
        }
    }

    @Override
    public boolean hasSubValue() {
        return this.subValue != null;
    }

    private void getSubValue(Subscript subscript, TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        this.subValue = new SubValueList();
        this.subValue.addItem(subscript);
        this.subValue.addItem(VariableName.getSubscript(tokenManager, errors, pcc));
    }

    private static Subscript getSubscript(TokenManager tokenManager, Errors errors, Pcc pcc) throws EndOfProgramException, GeneralErrorException {
        Subscript subscript = null;
        subscript = Subscript.get(tokenManager, errors, pcc);
        return subscript;
    }

    @Override
    public String getName() {
        return this.name.getWord();
    }

    @Override
    public Token getNameToken() {
        return this.name;
    }

    void setNameToken(Token token) {
        this.name = token;
    }

    public void setOf(VariableName variableName) {
        this.of = variableName;
    }

    @Override
    public VariableName getOf() {
        return this.of;
    }

    void associateToVarDeclAny(Pcc pcc) throws GeneralErrorException {
        this.associateToVarDeclAny(pcc, true, true, GetVarOpts.NO_OPTS);
    }

    void associateToVarDeclAny(Pcc pcc, boolean bl) throws GeneralErrorException {
        this.associateToVarDeclAny(pcc, bl, true, GetVarOpts.NO_OPTS);
    }

    public boolean isDeclared(Pcc pcc) {
        if (this.varDecl == null) {
            try {
                this.varDecl = pcc.getAny(this, false, true);
            }
            catch (GeneralErrorException generalErrorException) {
                return false;
            }
        }
        return this.varDecl != null;
    }

    void associateToVarDeclAny(Pcc pcc, boolean bl, boolean bl2, GetVarOpts getVarOpts) throws GeneralErrorException {
        if (this.varDecl == null) {
            this.varDecl = pcc.getAny(this, bl, false, null, false, getVarOpts);
        }
        if (this.varDecl == null) {
            throw new UndefinedException(this.getNameToken(), this.error, this.getName());
        }
        this.checkALL();
        if (bl2) {
            this.varDecl.setUsed();
        }
        if (this.subValue != null) {
            this.varDecl.setAccessedByAddress();
        }
    }

    void associateToVarDeclObj(Pcc pcc) throws GeneralErrorException {
        this.associateToVarDeclAny(pcc);
    }

    void associateToVarDeclVar(Pcc pcc) throws GeneralErrorException {
        this.associateToVarDeclVar(pcc, true, true, GetVarOpts.NO_OPTS);
    }

    void associateToVarDeclVar(Pcc pcc, boolean bl, boolean bl2, GetVarOpts getVarOpts) throws GeneralErrorException {
        this.associateToVarDeclAny(pcc, bl, bl2, getVarOpts);
        if (this.varDecl != null && !this.varDecl.isCobolVar() && !this.varDecl.isLobLocator()) {
            throw new GeneralErrorException(75, 4, this.name, this.name.getWord(), this.error);
        }
    }

    @Override
    public int getDimension() {
        if (this.indexes != null) {
            return this.indexes.getItemNum();
        }
        return 0;
    }

    @Override
    public VariableDeclaration getVarDecl() {
        if (this.functionVar != null) {
            return this.functionVar;
        }
        return this.varDecl;
    }

    public void setVarDecl(VariableDeclaration variableDeclaration) {
        this.varDecl = variableDeclaration;
    }

    @Override
    public boolean hasIndexes() {
        return this.indexes != null;
    }

    @Override
    public SubscriptList getIndexes() {
        return this.indexes;
    }

    public void setIndexes(SubscriptList subscriptList) {
        this.indexes = subscriptList;
    }

    @Override
    public SubValueList getSubValueList() {
        return this.subValue;
    }

    public boolean hasVariableIndex() {
        Subscript subscript;
        if (this.indexes != null) {
            subscript = this.indexes.getFirst();
            while (subscript != null) {
                if (!subscript.isLiteral()) {
                    return true;
                }
                subscript = this.indexes.getNext();
            }
        }
        if (this.subValue != null) {
            subscript = this.subValue.getFirst();
            while (subscript != null) {
                if (!subscript.isLiteral()) {
                    return true;
                }
                subscript = this.subValue.getNext();
            }
        }
        return false;
    }

    public boolean isDeclaredInLinkage() {
        if (this.varDecl != null) {
            return this.varDecl.isInLinkage();
        }
        throw new InternalErrorException("Declaration not found:" + this.getName());
    }

    public String getSubscriptCode() {
        return this.getSubscriptCode(false);
    }

    public String getSubscriptCode(boolean bl) {
        if (this.indexes != null) {
            return this.indexes.getCode(this.varDecl.isObjectReference(), this.varDecl.getOccurs() > 0, this.isEdited() && this.isNumeric(), bl && !this.varDecl.pc.isFactory() && !this.varDecl.isPic1());
        }
        return "";
    }

    @Override
    public String getCode() {
        VariableDeclaration variableDeclaration;
        if (this.pc != null && this.pc.registerScreenAttrs && !((variableDeclaration = this.getVarDecl()) instanceof VariableDeclarationScreen)) {
            String string = this.getCode(false);
            String string2 = this.pc.screenVars.get(string);
            if (string2 == null) {
                string2 = variableDeclaration != null && variableDeclaration.getClass() == VariableDeclaration.class ? variableDeclaration.getDeclUnivoqueName() : "CV";
                string2 = this.pc.newScreenName(string2);
                this.pc.screenVars.put(this.getCode(false), string2);
            }
            return "params.getValue(\"" + string2 + "\")";
        }
        return this.getCode(false);
    }

    public String getCode88() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.varDecl.getCobolClassPrefix());
        stringBuffer.append(this.varDecl.parent.getUnivoqueName());
        stringBuffer.append(this.getSubscriptCode());
        return stringBuffer.toString();
    }

    private void getCodeIndex(StringBuffer stringBuffer, boolean bl) {
        if (this.hasAllSubscript) {
            stringBuffer.append(this.indexes.getCodeWithAll());
        } else {
            stringBuffer.append(this.indexes.getCode(this.varDecl.isObjectReference(), this.varDecl.getOccurs() > 0, this.isEdited() && this.isNumeric(), bl && !this.varDecl.isInDynamic() && !this.varDecl.pc.isFactory() && !this.varDecl.isPic1()));
        }
    }

    public String getCode(boolean bl) {
        return this.getCode(true, bl);
    }

    public String getCode(boolean bl, boolean bl2) {
        return this.getCode(bl, bl2, true);
    }

    public String getCode(boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSelf || this.isSuper) {
            Pcc pcc;
            Pcc pcc2 = pcc = this.varDecl != null ? this.varDecl.pc.getRoot() : null;
            if (this.isSelf) {
                if (pcc != null && pcc != this.varDecl.pc) {
                    if (this.varDecl.pc.isDefault()) {
                        return "$This$";
                    }
                    return pcc.getFullClassName() + ".this";
                }
                return "this";
            }
            if (pcc != null && pcc != this.varDecl.pc) {
                return pcc.getFullClassName() + ".super";
            }
            return "super";
        }
        if (this.varDecl.level == 88) {
            stringBuffer.append(this.varDecl.getCobolClassPrefix());
            stringBuffer.append(this.varDecl.parent.getUnivoqueName());
        } else if (this.isAll) {
            Token token = new Token(this.varDecl.value);
            token.setAll(true);
            stringBuffer.append(this.varDecl.tm.getCodeLiteral(token));
        } else if (this.varDecl.isFactory && !this.varDecl.isLobLocator()) {
            stringBuffer.append("\"" + this.varDecl.getTypeName() + "\"");
        } else {
            stringBuffer.append(this.varDecl.getCobolClassPrefix());
            stringBuffer.append(this.varDecl.getUnivoqueName());
        }
        if (this.varDecl.hasVariableOffset()) {
            stringBuffer.append(this.getByOffset());
        } else if (bl && this.indexes != null) {
            this.getCodeIndex(stringBuffer, bl2);
        }
        if (this.subValue != null && bl3) {
            stringBuffer.append(this.subValue.getCode(this.varDecl.isNational, this.varDecl.isPic1()));
        }
        if (this.function != null && "RECORD-POSITION".equals(this.function.getWord())) {
            stringBuffer.append(".getRecordPosition()");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.hasSubValue()) {
            return this.getName() + "(:)";
        }
        return this.getName();
    }

    private String getByOffset() {
        StringBuffer stringBuffer = new StringBuffer(".offs(");
        stringBuffer.append(new OffsetHelper(this.varDecl, this.indexes));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void checkALL() throws GeneralErrorException {
        CobolToken cobolToken;
        CobolToken cobolToken2;
        Subscript subscript;
        int n2;
        if (this.isAll && !this.varDecl.isConstant()) {
            this.isAll = false;
        }
        if (this.subValue != null) {
            int n3;
            boolean bl;
            n2 = this.varDecl.isUsageBit() ? this.varDecl.getLogicLen() : this.varDecl.globalLen(this.varDecl.getOffset());
            subscript = this.subValue.getFirst();
            cobolToken2 = subscript.getExpression();
            boolean bl2 = this.pc != null && this.pc.getOption("-wref") != null;
            boolean bl3 = bl = this.pc != null && (this.pc.getOption("-cv") != null || this.pc.getOption("-cm") != null);
            if (cobolToken2 != null) {
                if (!((Expression)cobolToken2).isNumeric()) {
                    throw new GeneralErrorException(49, 4, this.name, ((Expression)cobolToken2).toString(), this.error);
                }
                cobolToken = ((Expression)cobolToken2).getAsToken();
                if (cobolToken != null && ((Token)cobolToken).getToknum() == 10002) {
                    n3 = ((Token)cobolToken).longValue();
                    if (n3 < 1) {
                        this.error.print(173, 3, (Token)cobolToken, "" + n3);
                    }
                    if (bl2) {
                        if (n2 > 0 && n3 > n2) {
                            this.error.print(173, 2, (Token)cobolToken, ((Token)cobolToken).getWord());
                        }
                    } else if (!bl && n2 > 0 && n3 > n2) {
                        this.error.print(173, 3, (Token)cobolToken, ((Token)cobolToken).getWord());
                    }
                } else {
                    n3 = 1;
                }
            } else {
                n3 = 1;
            }
            if ((subscript = this.subValue.getNext()) != null && (cobolToken2 = subscript.getExpression()) != null) {
                if (!((Expression)cobolToken2).isNumeric()) {
                    throw new GeneralErrorException(49, 4, this.name, ((Expression)cobolToken2).toString(), this.error);
                }
                cobolToken = ((Expression)cobolToken2).getAsToken();
                if (cobolToken != null && ((Token)cobolToken).getToknum() == 10002) {
                    int n4 = ((Token)cobolToken).longValue();
                    if (n4 < 1) {
                        this.error.print(173, 3, (Token)cobolToken, ((Token)cobolToken).getWord());
                    }
                    if (bl2) {
                        if (n2 > 0 && n3 + n4 > n2 + 1) {
                            this.error.print(173, 2, (Token)cobolToken, ((Token)cobolToken).getWord());
                        }
                    } else if (!bl && n2 > 0 && n3 + n4 > n2 + 1) {
                        this.error.print(173, 3, (Token)cobolToken, ((Token)cobolToken).getWord());
                    }
                }
            }
        }
        if (this.indexes != null && this.varDecl.dimension > 0) {
            int[] nArray = new int[this.varDecl.dimension];
            int[] nArray2 = new int[this.varDecl.dimension];
            n2 = this.varDecl.dimension - 1;
            cobolToken = this.varDecl;
            while (cobolToken != null && n2 >= 0) {
                if (((VariableDeclaration)cobolToken).occursMin > 0) {
                    nArray[n2] = ((VariableDeclaration)cobolToken).occursMax;
                    nArray2[n2] = ((VariableDeclaration)cobolToken).occursMin;
                    --n2;
                }
                cobolToken = ((VariableDeclaration)cobolToken).parent;
            }
            subscript = this.indexes.getFirst();
            for (n2 = 0; subscript != null && n2 < this.varDecl.dimension; ++n2) {
                if (subscript.isLiteral() && subscript.getExpression() != null) {
                    cobolToken2 = subscript.getExpression().getAsToken();
                    if (((Token)cobolToken2).getToknum() != 10002) {
                        throw new GeneralErrorException(22, 4, (Token)cobolToken2, subscript.getExpression().toString(), this.error);
                    }
                    int n5 = Integer.parseInt(((Token)cobolToken2).getWord());
                    if (n5 < 1) {
                        this.error.print(264, 3, subscript.getExpression().getAsToken(), subscript.getExpression().toString());
                    } else if (nArray[n2] > 0) {
                        if (n5 > nArray[n2]) {
                            this.error.print(264, 3, subscript.getExpression().getAsToken(), subscript.getExpression().toString());
                        }
                    } else if (nArray2[n2] > 0 && n5 > nArray2[n2]) {
                        this.error.print(264, 3, subscript.getExpression().getAsToken(), subscript.getExpression().toString());
                    }
                }
                subscript = this.indexes.getNext();
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.varDecl != null) {
            this.varDecl.check();
            this.checkALL();
        } else if (this.functionVar != null && this.isAll) {
            this.isAll = false;
        }
    }

    @Override
    public MyClass getCType() throws GeneralErrorException {
        return this.getType();
    }

    public MyClass getType() {
        MyClass myClass;
        try {
            int n2 = this.getDimension();
            myClass = n2 > 0 ? MyClass.removeDimension(this.getVarDecl().getType(), n2) : (this.hasSubValue() ? this.pc.existsClass(Pcc.TYPES_PACKAGE + ".PicX") : this.getVarDecl().getType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                myClass = MyClass.getInstance(Pcc.TYPES_PACKAGE + ".CobolVar");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new InternalErrorException("" + classNotFoundException2);
            }
        }
        return myClass;
    }

    @Override
    public boolean isPrimitive() {
        if (!this.isSelf && !this.isSuper) {
            VariableDeclaration variableDeclaration = this.getVarDecl();
            if (!variableDeclaration.isFactory) {
                try {
                    int n2 = this.getDimension();
                    MyClass myClass = n2 > 0 ? MyClass.removeDimension(variableDeclaration.getType(), n2) : variableDeclaration.getType();
                    return myClass.isPrimitive();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean isString() {
        if (!this.isSelf && !this.isSuper) {
            VariableDeclaration variableDeclaration = this.getVarDecl();
            if (!variableDeclaration.isFactory) {
                try {
                    int n2 = this.getDimension();
                    MyClass myClass = n2 > 0 ? MyClass.removeDimension(variableDeclaration.getType(), n2) : variableDeclaration.getType();
                    return myClass.isString();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean isSetGetProperty() {
        return this.varDecl instanceof InlineSetGetProperty;
    }

    @Override
    public boolean isBoolean() {
        if (!this.isSelf && !this.isSuper) {
            VariableDeclaration variableDeclaration = this.getVarDecl();
            if (!variableDeclaration.isFactory) {
                try {
                    int n2 = this.getDimension();
                    MyClass myClass = n2 > 0 ? MyClass.removeDimension(variableDeclaration.getType(), n2) : variableDeclaration.getType();
                    return myClass.isBoolean();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean isObjectReference() {
        return this.isSelf || this.isSuper || this.getVarDecl().isObjectReference();
    }

    public boolean isStrictPrimitive() {
        MyClass myClass = this.getType();
        return myClass != null && myClass.isStrictPrimitive();
    }

    public boolean isPrimitiveWrapper() {
        MyClass myClass = this.getType();
        return myClass != null && myClass.isPrimitiveWrapper();
    }

    @Override
    public boolean isCobolVar() {
        return this.getVarDecl().isCobolVar();
    }

    @Override
    public boolean isNumericVar() {
        if (this.hasSubValue()) {
            return false;
        }
        return this.getVarDecl().isNumericVar();
    }

    @Override
    public boolean isFactory() {
        if (this.isSelf || this.isSuper) {
            return false;
        }
        return this.getVarDecl().isFactory;
    }

    @Override
    public int getVariableLength() {
        return this.getVariableLength(false);
    }

    int getVariableLength(boolean bl) {
        if (this.varDecl == null) {
            return -1;
        }
        if (this.varDecl.level == 78 && this.varDecl.value != null) {
            return this.varDecl.value.getRealLength();
        }
        int n2 = this.varDecl.phisicLen;
        if (this.varDecl.isNational || this.varDecl.isPicG()) {
            n2 /= 2;
        }
        if (this.subValue != null) {
            Subscript subscript = this.subValue.getFirst();
            Expression expression = subscript.getExpression();
            if (expression == null || expression.hasOperator || expression.firstToken == null || expression.firstToken.getToknum() != 10002) {
                return -1;
            }
            int n3 = Integer.parseInt(expression.firstToken.getWord());
            int n4 = n2 - n3 + 1;
            Subscript subscript2 = this.subValue.getNext();
            if (subscript2 != null && (expression = subscript2.getExpression()) != null) {
                if (!expression.hasOperator && expression.firstToken != null && expression.firstToken.getToknum() == 10002) {
                    n4 = Integer.parseInt(expression.firstToken.getWord());
                } else {
                    return -1;
                }
            }
            n2 = bl ? n4 : Math.min(n2 - n3 + 1, n4);
        }
        return n2;
    }

    @Override
    public int getLevel() {
        if (this.isSelf || this.isSuper) {
            return 77;
        }
        VariableDeclaration variableDeclaration = this.getVarDecl();
        return variableDeclaration != null ? variableDeclaration.level : 0;
    }

    @Override
    public boolean isNumeric() {
        if (this.isSelf || this.isSuper) {
            return false;
        }
        if (this.function != null && "RECORD-POSITION".equals(this.function.getWord())) {
            return true;
        }
        if (this.subValue != null) {
            return false;
        }
        return this.getVarDecl().isNumeric();
    }

    @Override
    public boolean isInteger() {
        if (this.isSelf || this.isSuper) {
            return false;
        }
        return this.subValue == null && this.getVarDecl().isInteger();
    }

    @Override
    public boolean isEdited() {
        if (this.isSelf || this.isSuper) {
            return false;
        }
        return this.getVarDecl().isEdited();
    }

    @Override
    public boolean isSelf() {
        return this.isSelf;
    }

    @Override
    public boolean isSuper() {
        return this.isSuper;
    }

    @Override
    public boolean isFunction() {
        return this.varDecl instanceof Function;
    }

    @Override
    public boolean isMethod() {
        return this.varDecl instanceof InlineInvoke;
    }

    @Override
    public boolean isUsageDisplay() {
        return this.getVarDecl().isUsageDisplay() || this.hasSubValue();
    }

    @Override
    public boolean isUniversal() {
        return this.getVarDecl().isUniversal();
    }

    public boolean isRecordPosition() {
        return this.function != null && "RECORD-POSITION".equals(this.function.getWord());
    }

    public boolean isAssignableTo(VariableName variableName) {
        try {
            int n2 = this.getDimension();
            int n3 = variableName.getDimension();
            VariableDeclaration variableDeclaration = this.getVarDecl();
            if (variableDeclaration.isObjectReference() && variableDeclaration.getOccurs() > 0) {
                --n2;
            }
            VariableDeclaration variableDeclaration2 = variableName.getVarDecl();
            MyClass myClass = n2 > 0 ? MyClass.removeDimension(variableDeclaration.getType(), n2) : variableDeclaration.getType();
            if (variableDeclaration2.isObjectReference() && variableDeclaration2.getOccurs() > 0) {
                --n3;
            }
            MyClass myClass2 = n3 > 0 ? MyClass.removeDimension(variableDeclaration2.getType(), n3) : variableDeclaration2.getType();
            return myClass.isAssignableTo(myClass2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public VariableName getVariableName() {
        return this;
    }

    @Override
    public Token getFunction() {
        return this.function;
    }

    @Override
    public boolean isRounded() {
        return this.rounded;
    }

    public void setAll(boolean bl) {
        this.isAll = bl;
    }

    @Override
    public boolean isAll() {
        return this.isAll;
    }

    final boolean isNotXOptimizable(boolean bl) {
        return this.getVarDecl().isNotXOptimizable(bl);
    }

    public void getCodeOffset(StringBuffer stringBuffer, int n2) {
        this.getCodeOffset(stringBuffer, n2, false);
    }

    public void getCodeOffset(StringBuffer stringBuffer, int n2, boolean bl) {
        VariableDeclaration variableDeclaration = this.getVarDecl();
        if (bl) {
            variableDeclaration = variableDeclaration.getParent();
        }
        if (variableDeclaration.isInLinkage() || variableDeclaration.hasVariableOffset() || this.indexes != null) {
            if (this.indexes != null) {
                stringBuffer.append(this.getCode(false, false, this.subValue == null));
                stringBuffer.append(".getOffset");
                this.indexes.getCodeNum(stringBuffer);
            } else {
                stringBuffer.append(this.getCode(false, false, this.subValue == null));
                stringBuffer.append(".getOffset()");
            }
            if (n2 != 0) {
                stringBuffer.append("+");
                stringBuffer.append(n2);
            }
        } else {
            stringBuffer.append(variableDeclaration.getOffset() + n2);
        }
        if (this.subValue != null) {
            stringBuffer.append("+");
            stringBuffer.append(this.subValue.getOffset());
            stringBuffer.append("-1");
        }
    }

    public boolean getSubstringLen(StringBuffer stringBuffer, int n2) {
        String string = this.subValue.getLen();
        if (string.length() == 0) {
            return false;
        }
        stringBuffer.append(this.subValue.getLen());
        return true;
    }

    public void getSubstringOffs(StringBuffer stringBuffer, int n2) {
        stringBuffer.append(this.subValue.getOffset());
    }

    public void setSqlCallMode(String string) {
        this.sqlCallMode = string;
    }

    public String getSqlCallMode() {
        return this.sqlCallMode;
    }

    protected void setPropTypeSet() throws GeneralErrorException {
        if (this.varDecl instanceof InlineSetGetProperty) {
            InlineSetGetProperty inlineSetGetProperty = (InlineSetGetProperty)this.varDecl;
            if (inlineSetGetProperty.getPropType() == 0) {
                throw new GeneralErrorException(59, 4, this.getNameToken(), this.getName(), this.error);
            }
            inlineSetGetProperty.setPropType(1);
        }
    }

    protected void setPropTypeGet() throws GeneralErrorException {
        if (this.varDecl instanceof InlineSetGetProperty) {
            InlineSetGetProperty inlineSetGetProperty = (InlineSetGetProperty)this.varDecl;
            if (inlineSetGetProperty.getPropType() == 1) {
                throw new GeneralErrorException(241, 4, this.getNameToken(), this.getName(), this.error);
            }
            inlineSetGetProperty.setPropType(0);
        }
    }

    protected void checkPropTypeSetGet() throws GeneralErrorException {
        InlineSetGetProperty inlineSetGetProperty;
        if (this.varDecl instanceof InlineSetGetProperty && (inlineSetGetProperty = (InlineSetGetProperty)this.varDecl).getPropType() != 2) {
            throw new GeneralErrorException(241, 4, this.getNameToken(), this.getName(), this.error);
        }
    }

    @Override
    public String getNameIde() {
        if (this.indexes != null) {
            return this.getName() + this.indexes.getCodeIde();
        }
        return this.getName();
    }

    public boolean isVariableLengthGroup() {
        return !this.hasSubValue() && this.getVarDecl().isVariableLengthGroup();
    }

    public boolean isLambdaExpression() {
        return this.lambdaExpr;
    }

    public void setSqlj(String string) {
        this.sqljName = string;
    }

    public void setSqljParam(String string) {
        this.sqljNameParam = string;
    }

    public String getSqljName() {
        return this.sqljName;
    }

    public String getSqljNameParam() {
        return this.sqljNameParam;
    }

    static {
        specialNames.put("RECORD-POSITION", 1);
        specialNames.put("FUNCTION", 2);
        specialNames.put("LENGTH OF", 3);
        specialNames.put("EXCEPTION-OBJECT", 4);
        specialNames.put("LINAGE-COUNTER", 5);
        specialNames.put("CURRENT-DATE", 6);
        specialNames.put("TIME-OF-DAY", 7);
        specialNames.put("WHEN-COMPILED", 8);
        specialNames.put("ADDRESS OF", 9);
        specialNames.put("PROGRAM-ID", 10);
        specialNames.put("ADDRESS", 9);
    }
}

