/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.AmbiguousException;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.Condition;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.IllegalConditionException;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class VaryingAfter
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Condition until;
    private VariableName varying;
    private boolean varyingLocal;
    private VariableName fromVar;
    private Token fromToken;
    private VariableName byVar;
    private Token byToken;
    private boolean testAfter;
    private Perform prf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VaryingAfter(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors, boolean bl, Perform perform) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        this.testAfter = bl;
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, token2, token2.getWord(), this.error);
        }
        this.tm.ungetToken();
        TokenManager.Marker marker = this.tm.getMarker();
        this.tm.setMarker(marker);
        this.prf = perform;
        boolean bl2 = this.error.ignoreErrors;
        GetVarOpts getVarOpts = new GetVarOpts(perform, 1);
        try {
            this.error.ignoreErrors = true;
            this.varying = VariableName.getAny(this.tm, this.error, this.parent, this.pc, getVarOpts);
        }
        catch (UndefinedException undefinedException) {
            CobolToken cobolToken;
            this.error.ignoreErrors = bl2;
            Token token3 = token2;
            String string = null;
            if (this.tm.getToken().getToknum() == 280) {
                token2 = this.tm.getToken();
                if (token2.getToknum() == 10009) {
                    if ("ACTIVE-CLASS".equals(token2.getWord())) {
                        string = "java.lang.Object";
                    } else {
                        this.tm.ungetToken();
                        cobolToken = VariableName.getObject(this.tm, this.error, null, this.pc);
                        if (cobolToken == null || !((VariableName)cobolToken).getVarDecl().isFactory) {
                            throw new MissingClassException(token2.getWord(), token2, this.error);
                        }
                        string = ((VariableName)cobolToken).getVarDecl().getClassName();
                        token2 = this.tm.getToken();
                        if (token2.getToknum() != 614) {
                            this.tm.ungetToken();
                        }
                    }
                } else if (token2.getToknum() == 10001) {
                    string = token2.getWord().substring(1, token2.getWord().length() - 1);
                    try {
                        this.pc.existsClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new MissingClassException(token2.getWord(), token2, this.error);
                    }
                }
            }
            if (string != null) {
                cobolToken = VariableDeclaration.getObject(this.pc, token3, this.tm, string, false);
                this.pc.putLocalVariable((VariableDeclaration)cobolToken);
                this.varying = new VariableName((VariableDeclaration)cobolToken);
                this.varyingLocal = true;
            } else {
                this.tm.rewindToMarker(marker);
                VariableName.getAny(this.tm, this.error, this.parent, this.pc, getVarOpts);
            }
        }
        catch (GeneralErrorException generalErrorException) {
            this.error.ignoreErrors = bl2;
            this.tm.rewindToMarker(marker);
            VariableName.getAny(this.tm, this.error, this.parent, this.pc, getVarOpts);
        }
        finally {
            this.error.ignoreErrors = bl2;
        }
        if (!this.varying.getVarDecl().isNumeric() || this.varying.getVarDecl().isEdited()) {
            throw new GeneralErrorException(23, 4, token2, token2.getWord(), this.error);
        }
        token2 = this.tm.getToken();
        if (!this.varyingLocal && token2.getToknum() == 280) {
            throw new AmbiguousException(this.varying.getNameToken(), this.error, this.varying.getName());
        }
        if (token2.getToknum() != 498) {
            throw new ExpectedFoundException(token2, this.error, "'FROM'");
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            this.fromVar = VariableName.getAny(this.tm, this.error, this.pc);
            if (!this.fromVar.getVarDecl().isNumeric() || this.fromVar.getVarDecl().isEdited()) {
                throw new GeneralErrorException(23, 4, token2, token2.getWord(), this.error);
            }
        } else if (Token.isNumLit(token2)) {
            this.fromToken = token2;
        } else {
            throw new UnexpectedTokenException(token2, this.error);
        }
        if ((token2 = this.tm.getToken()).getToknum() != 312) {
            throw new ExpectedFoundException(token2, this.error, "'BY'");
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            this.byVar = VariableName.getAny(this.tm, this.error, this.pc);
            if (!this.byVar.getVarDecl().isNumeric() || this.byVar.getVarDecl().isEdited()) {
                throw new GeneralErrorException(23, 4, token2, token2.getWord(), this.error);
            }
        } else if (Token.isNumLit(token2)) {
            this.byToken = token2;
        } else {
            throw new UnexpectedTokenException(token2, this.error);
        }
        if ((token2 = this.tm.getToken()).getToknum() != 791) {
            throw new ExpectedFoundException(token2, this.error, "'UNTIL'");
        }
        this.until = new Condition(this.keyWord, this.parent, this.pc, this.tm, this.error);
        if (!this.until.isFullCondition()) {
            throw new IllegalConditionException(this.keyWord, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.until != null) {
            this.until.check();
        }
    }

    private void getCodeIncr(StringBuffer stringBuffer) {
        if (this.varying.isPrimitive()) {
            stringBuffer.append(this.varying.getCode());
            stringBuffer.append(" = ");
            String string = this.varying.getType().getName(true);
            if (this.byToken != null) {
                String string2 = this.getCodeLiteral(this.byToken);
                if (Expression.couldBeNativeInt(this.fromToken, 18)) {
                    String string3 = this.varying.getCode() + " + " + string2 + ".theValue.lnUnscValue";
                    stringBuffer.append(Compute.addCast(string, string3));
                } else {
                    String string4 = Expression.couldBeNativeInt(this.varying.getVarDecl()) ? "CobolNum.noo(" + this.varying.getCode() + ", 0)" : "CobolNum.noo((double) " + this.varying.getCode() + ")";
                    string4 = string4 + ".add(" + string2 + ".theValue)";
                    stringBuffer.append(Compute.getConversionMethod(string, string4));
                }
            } else if (this.byVar.isPrimitive()) {
                String string5 = this.varying.getCode() + " + " + this.byVar.getCode();
                stringBuffer.append(Compute.addCast(string, string5));
            } else {
                String string6 = Expression.couldBeNativeInt(this.varying.getVarDecl()) ? "CobolNum.noo(" + this.varying.getCode() + ", 0)" : "CobolNum.noo((double) " + this.varying.getCode() + ")";
                string6 = string6 + ".add(" + this.byVar.getCode() + ".num())";
                stringBuffer.append(Compute.getConversionMethod(string, string6));
            }
        } else {
            stringBuffer.append(this.varying.getCode());
            if (this.varying.getVarDecl().isInteger()) {
                if (this.byToken != null && this.byToken.getToknum() == 10002) {
                    stringBuffer.append(".addToMe(");
                    stringBuffer.append(this.byToken.getAsLong());
                    stringBuffer.append(")");
                    return;
                }
                if (this.byVar != null && this.byVar.getVarDecl().isInteger() && this.byVar.getVarDecl().getLogicLen() <= 18) {
                    stringBuffer.append(".addToMe(");
                    stringBuffer.append(this.byVar.getCode());
                    stringBuffer.append(".tolong())");
                    return;
                }
            }
            stringBuffer.append(".set(");
            if (this.byToken != null) {
                stringBuffer.append(this.getCodeLiteral(this.byToken));
                stringBuffer.append(".num()");
            } else if (this.byVar.isPrimitive()) {
                if (Expression.couldBeNativeInt(this.byVar.getVarDecl())) {
                    stringBuffer.append("CobolNum.noo(" + this.byVar.getCode() + ", 0)");
                } else {
                    stringBuffer.append("CobolNum.noo((double) " + this.byVar.getCode() + ")");
                }
            } else {
                stringBuffer.append(this.byVar.getCode());
                stringBuffer.append(".num()");
            }
            stringBuffer.append(".add(");
            stringBuffer.append(this.varying.getCode());
            stringBuffer.append(".num())");
            stringBuffer.append(",");
            stringBuffer.append(false);
            stringBuffer.append(",");
            stringBuffer.append(false);
            stringBuffer.append(")");
        }
    }

    public String getCodeBefore() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("for (");
        if (this.varyingLocal) {
            stringBuffer.append(this.varying.getType().getName() + " ");
        }
        if (this.varying.isPrimitive()) {
            stringBuffer.append(this.varying.getCode());
            stringBuffer.append(" = ");
            String string = this.varying.getType().getName(true);
            if (this.fromToken != null) {
                String string2 = this.getCodeLiteral(this.fromToken);
                if (Expression.couldBeNativeInt(this.fromToken, 18)) {
                    stringBuffer.append(Compute.addCast(string, string2 + ".theValue.lnUnscValue"));
                } else {
                    stringBuffer.append(Compute.getConversionMethod(string, string2 + ".theValue"));
                }
            } else if (this.fromVar.isPrimitive()) {
                stringBuffer.append(Compute.addCast(string, this.fromVar.getCode()));
            } else {
                stringBuffer.append(Compute.getConversionMethod(string, this.fromVar.getCode() + ".num()"));
            }
        } else {
            if (this.fromVar != null && this.fromVar.isPrimitive()) {
                stringBuffer.append(this.varying.getCode());
                stringBuffer.append(".set(");
                stringBuffer.append(this.fromVar.getCode());
            } else {
                if (this.fromToken != null) {
                    stringBuffer.append(this.getCodeLiteral(this.fromToken));
                } else {
                    stringBuffer.append(this.fromVar.getCode());
                }
                stringBuffer.append(".moveTo(");
                stringBuffer.append(this.varying.getCode());
            }
            stringBuffer.append(")");
        }
        stringBuffer.append("; ;");
        this.prf.endCode = null;
        this.getCodeIncr(stringBuffer);
        stringBuffer.append(") {");
        stringBuffer.append(eol);
        this.prf.getEndCode(stringBuffer);
        if (!this.testAfter) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("if (");
            stringBuffer.append(this.until.getCode());
            stringBuffer.append(") break;");
            stringBuffer.append(eol);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.testAfter) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("if (");
            stringBuffer.append(this.until.getCode());
            stringBuffer.append(") break;");
            stringBuffer.append(eol);
        }
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("}");
        stringBuffer.append(eol);
        return stringBuffer.toString();
    }

    public Condition getUntil() {
        return this.until;
    }

    public VariableName getVarying() {
        return this.varying;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public Token getFromToken() {
        return this.fromToken;
    }

    public VariableName getByVar() {
        return this.byVar;
    }

    public Token getByToken() {
        return this.byToken;
    }

    public boolean isTestAfter() {
        return this.testAfter;
    }
}

