/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.MSVariableGenerator;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.StatementDesc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IVerb;
import java.io.File;
import java.util.Vector;

public abstract class Verb
implements CobolToken,
ErrorsNumbers,
IVerb {
    protected TokenManager tm;
    protected Errors error;
    private static int uniqueId;
    protected Token keyWord;
    protected Pcc pc;
    protected Block parent;
    protected Vector nestedBlocks = new Vector();
    protected int deferredMethodId;
    protected boolean allowAllLitGen = true;
    protected String endCode;
    protected boolean endStmt;

    protected Verb(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) {
        this.keyWord = token;
        this.parent = block;
        this.pc = pcc;
        this.tm = tokenManager;
        this.error = errors;
    }

    public final String getCodeLiteral(Token token) {
        if (token.isAll() && !this.allowAllLitGen) {
            Token token2 = new Token(token);
            token2.setFigurative(token.isFigurative());
            token2.setResource(token.isResource());
            token2.setHexdecimal(token.isHexdecimal());
            token2.setAll(false);
            token = token2;
        }
        return this.tm.getCodeLiteral(token);
    }

    protected static int getUniqueId() {
        return ++uniqueId;
    }

    public Block[] getNestedBlocks() {
        Block[] blockArray = new Block[this.nestedBlocks.size()];
        this.nestedBlocks.toArray(blockArray);
        return blockArray;
    }

    public abstract void check() throws GeneralErrorException;

    protected void getCodeDebug(StringBuffer stringBuffer) {
        int n2 = this.keyWord.getFLN();
        if (this.keyWord.isLineRepl()) {
            if (n2 != this.pc.lastReplLine) {
                this.pc.lastReplLine = n2;
            } else {
                n2 = -n2;
            }
        }
        if (this.pc.getOption("-d") != null) {
            int n3 = this.keyWord.getFileIndex();
            boolean bl = this.pc.getOption("-dx") != null;
            if (bl) {
                stringBuffer.append("if(");
            }
            stringBuffer.append("Debugger.statement");
            if (bl) {
                stringBuffer.append("Ext");
            }
            stringBuffer.append(" (");
            stringBuffer.append(n2);
            stringBuffer.append(", \"");
            String string = this.keyWord.getFileName();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            stringBuffer.append(Pcc.escapeString(string));
            stringBuffer.append("\"");
            stringBuffer.append(", ");
            stringBuffer.append(n3);
            stringBuffer.append(")");
            if (bl) {
                stringBuffer.append(") {");
            } else {
                stringBuffer.append(";");
            }
            stringBuffer.append(eol);
            if (this.parent != null) {
                stringBuffer.append(this.parent.getIndent());
            }
            if (n2 > 0) {
                Pcc pcc = this.pc.getRoot();
                int n4 = 0;
                boolean bl2 = false;
                if (this.parent != null && this.parent.getParent() != null && this.parent.getParentVerb() == null) {
                    n4 = this.parent.getParent().getIdNumber();
                    bl2 = this.parent.getParent().isDeclaratives();
                }
                pcc.addLine(new StatementDesc(n3, n2, n4, bl2));
            }
        }
        this.getCodeSMAP(stringBuffer, n2, true);
    }

    protected final void getCodeSMAP(StringBuffer stringBuffer, int n2, boolean bl) {
        if (this.pc.getOption("-g") != null) {
            stringBuffer.append("/*!#");
            stringBuffer.append(n2);
            stringBuffer.append(",");
            stringBuffer.append(this.keyWord.getFileIndex());
            stringBuffer.append("*/");
            if (this.pc.optionMS && bl) {
                stringBuffer.append(eol);
                if (this.parent != null) {
                    stringBuffer.append(this.parent.getIndent());
                }
            }
        }
    }

    protected void getCodeDebugEnd(StringBuffer stringBuffer) {
        this.getEndCode(stringBuffer);
        if (this.pc.getOption("-dx") != null) {
            stringBuffer.append(this.parent.getIndent());
            stringBuffer.append("}");
            stringBuffer.append(eol);
        }
    }

    protected void getEndCode(StringBuffer stringBuffer) {
        if (this.endCode != null) {
            stringBuffer.append(this.endCode);
            this.endCode = null;
        }
    }

    public static void resetCounters() {
        uniqueId = 0;
    }

    @Override
    public Block getParent() {
        return this.parent;
    }

    protected String getLocalVar(String string) {
        return Verb.getLocalVar(string, this.pc.capitalizeNames);
    }

    protected String getReturnCode() {
        return Verb.getLocalVar("RETURN-CODE", this.pc.capitalizeNames);
    }

    protected String getExceptionObject() {
        return Verb.getLocalVar("EXCEPTION-OBJECT", this.pc.capitalizeNames);
    }

    protected static String getDebugItemLocalVar(String string, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return MSVariableGenerator.getDeclUnivoqueName("DEBUG-ITEM", 0) + "." + MSVariableGenerator.getDeclUnivoqueName(string, 0);
            }
            return ("DEBUG-ITEM." + string).replace('-', Pcc.hyphenRepl);
        }
        return string.replace('-', Pcc.hyphenRepl);
    }

    protected static String getLocalVar(String string, boolean bl) {
        if (bl) {
            return MSVariableGenerator.getDeclUnivoqueName(string, 0);
        }
        return string.replace('-', Pcc.hyphenRepl);
    }

    protected static String getReturnCode(boolean bl) {
        return Verb.getLocalVar("RETURN-CODE", bl);
    }

    protected static String getExceptionObject(boolean bl) {
        return Verb.getLocalVar("EXCEPTION-OBJECT", bl);
    }

    public abstract String getCode();

    void getCodeCorresponding(StringBuffer stringBuffer, VariableName variableName, VariableName variableName2, boolean bl) {
        VariableDeclarationList variableDeclarationList = new VariableDeclarationList();
        VariableDeclarationList variableDeclarationList2 = new VariableDeclarationList();
        int n2 = variableName.getIndexes() != null ? variableName.getIndexes().getItemNum() : 0;
        int n3 = variableName2.getIndexes() != null ? variableName2.getIndexes().getItemNum() : 0;
        Verb.getCorrespondingVars(variableDeclarationList, variableName.getVarDecl().children);
        Verb.getCorrespondingVars(variableDeclarationList2, variableName2.getVarDecl().children);
        VariableDeclaration variableDeclaration = variableDeclarationList.getFirst();
        while (variableDeclaration != null) {
            VariableDeclaration variableDeclaration2 = variableDeclarationList2.getFirst();
            while (variableDeclaration2 != null) {
                VariableDeclaration variableDeclaration3 = variableDeclaration.parent;
                String string = variableDeclaration.name.getWord();
                while (variableDeclaration3 != null && !variableDeclaration3.name.getWord().equals(variableName.name.getWord())) {
                    string = string + " OF " + variableDeclaration3.name.getWord();
                    variableDeclaration3 = variableDeclaration3.parent;
                }
                variableDeclaration3 = variableDeclaration2.parent;
                String string2 = variableDeclaration2.name.getWord();
                while (variableDeclaration3 != null && !variableDeclaration3.name.getWord().equals(variableName2.name.getWord())) {
                    string2 = string2 + " OF " + variableDeclaration3.name.getWord();
                    variableDeclaration3 = variableDeclaration3.parent;
                }
                if (string.equals(string2) && (!bl || variableDeclaration.isNumeric() && !variableDeclaration.isEdited() && variableDeclaration2.isNumeric() && !variableDeclaration2.isEdited())) {
                    VariableDeclaration variableDeclaration4;
                    int n4 = 0;
                    int n5 = 0;
                    if (variableDeclaration.children.getItemNum() > 0) {
                        variableDeclaration4 = variableDeclaration.children.getFirst();
                        while (variableDeclaration4 != null && n4 == 0) {
                            if (variableDeclaration4.level != 88 && variableDeclaration4.level != 78 && variableDeclaration4.level != 66) {
                                ++n4;
                            }
                            variableDeclaration4 = variableDeclaration.children.getNext();
                        }
                    }
                    if (variableDeclaration2.children.getItemNum() > 0) {
                        variableDeclaration4 = variableDeclaration2.children.getFirst();
                        while (variableDeclaration4 != null && n5 == 0) {
                            if (variableDeclaration4.level != 88 && variableDeclaration4.level != 78 && variableDeclaration4.level != 66) {
                                ++n5;
                            }
                            variableDeclaration4 = variableDeclaration2.children.getNext();
                        }
                    }
                    if ((n4 == 0 || n5 == 0) && variableDeclaration.dimension == n2 && variableDeclaration2.dimension == n3 && variableDeclaration.rename1 == null && variableDeclaration2.rename1 == null) {
                        String string3 = variableDeclaration.getUnivoqueName();
                        if (n2 > 0) {
                            string3 = string3 + variableName.getSubscriptCode();
                        }
                        String string4 = variableDeclaration2.getUnivoqueName();
                        if (n3 > 0) {
                            string4 = string4 + variableName2.getSubscriptCode();
                        }
                        this.getCodeCorrEach(stringBuffer, string3, variableDeclaration, string4, variableDeclaration2);
                    }
                }
                variableDeclaration2 = variableDeclarationList2.getNext();
            }
            variableDeclaration = variableDeclarationList.getNext();
        }
    }

    void getCodeCorrEach(StringBuffer stringBuffer, String string, VariableDeclaration variableDeclaration, String string2, VariableDeclaration variableDeclaration2) {
        throw new InternalErrorException("Undefined getCodeCorrEach:" + this);
    }

    static void getCorrespondingVars(VariableDeclarationList variableDeclarationList, VariableDeclarationList variableDeclarationList2) {
        if (variableDeclarationList2 != null) {
            Object[] objectArray = new VariableDeclaration[variableDeclarationList2.getItemNum()];
            variableDeclarationList2.toArray(objectArray);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                int n2;
                if (objectArray[i2] == null) continue;
                Object object = objectArray[i2];
                for (n2 = i2 + 1; !(n2 >= objectArray.length || objectArray[n2] != null && ((VariableDeclaration)object).getName().equals(((VariableDeclaration)objectArray[n2]).getName())); ++n2) {
                }
                if (n2 < objectArray.length) {
                    objectArray[n2] = null;
                    objectArray[i2] = null;
                    continue;
                }
                if (((VariableDeclaration)object).level == 88 || ((VariableDeclaration)object).redefines != null || ((VariableDeclaration)object).getName().equalsIgnoreCase("filler")) continue;
                variableDeclarationList.addItem((VariableDeclaration)object);
                Verb.getCorrespondingVars(variableDeclarationList, ((VariableDeclaration)object).children);
            }
        }
    }

    @Override
    public Token getKeyWord() {
        return this.keyWord;
    }

    public Pcc getPcc() {
        return this.pc;
    }

    public int getPreProcessorIndex() {
        return this.keyWord.getFileIndex();
    }

    public int getDeferredMethodId() {
        return this.deferredMethodId;
    }

    public void setDeferredMethodId(int n2) {
        this.deferredMethodId = n2;
    }
}

