/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.ThreadException;

public class Wait
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName threadHandle;
    private boolean last;
    private VariableName timeoutVar;
    private Token timeoutToken;
    private VariableName inThread;
    private VariableName size;
    private VariableName status;
    private BlockException onException;
    private Block notOnException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Wait(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() != 494) throw new ExpectedFoundException(token2, this.error, "'FOR'");
        token2 = this.tm.getToken();
        if (token2.getToknum() == 763 || token2.getToknum() == 10009) {
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
            }
            this.threadHandle = VariableName.get(this.tm, this.error, this.pc);
            if (this.threadHandle == null) {
                token2 = this.tm.getToken();
                throw new UnexpectedTokenException(token2, this.error);
            }
            if (!this.threadHandle.getVarDecl().isValidThreadHandle()) {
                throw new ClauseClashException(token2, this.error, this.threadHandle.getName());
            }
        } else {
            if (token2.getToknum() != 554) throw new UnexpectedTokenException(token2, this.error);
            this.last = true;
            token2 = this.tm.getToken();
            if (token2.getToknum() != 763) {
                throw new ExpectedFoundException(token2, this.error, "'THREAD'");
            }
        }
        boolean bl = true;
        block7: while (bl) {
            token2 = this.tm.getToken();
            switch (token2.getToknum()) {
                case 763: {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 526) {
                        token2 = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    this.inThread = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                    if (this.inThread == null) {
                        token2 = this.tm.getToken();
                        throw new UnexpectedTokenException(token2, this.error);
                    }
                    if (this.inThread.getVarDecl().isValidThreadHandle()) continue block7;
                    throw new ClauseClashException(token2, this.error, this.threadHandle.getName());
                }
                case 728: {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 526) {
                        token2 = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    this.size = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                    if (this.size != null) continue block7;
                    throw new UnexpectedTokenException(token2, this.error);
                }
                case 742: {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 526) {
                        token2 = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    this.status = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
                    if (this.status != null) continue block7;
                    throw new UnexpectedTokenException(token2, this.error);
                }
                case 299: {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 769) {
                        token2 = this.tm.getToken();
                    }
                    if (this.timeoutToken != null || this.timeoutVar != null) {
                        throw new ClauseClashException(token2, this.error, "BEFORE TIME");
                    }
                    if (Token.isNumLit(token2)) {
                        this.timeoutToken = token2;
                        continue block7;
                    }
                    this.tm.ungetToken();
                    this.timeoutVar = VariableName.get(this.tm, this.error, this.pc);
                    if (this.timeoutVar != null) continue block7;
                    throw new UnexpectedTokenException(token2, this.error);
                }
                case 760: {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() != 614) {
                        throw new ExpectedFoundException(token2, this.error, "'ONLY'");
                    }
                    if (this.timeoutToken != null || this.timeoutVar != null) {
                        throw new ClauseClashException(token2, this.error, "TEST ONLY");
                    }
                    this.timeoutToken = token2;
                    token2.setToknum(10002);
                    token2.setWord("0");
                    continue block7;
                }
            }
            this.tm.ungetToken();
            bl = false;
        }
        boolean bl2 = false;
        token2 = this.tm.getToken();
        if (token2.getToknum() == 598 || token2.getToknum() == 613 || token2.getToknum() == 472) {
            boolean bl3 = false;
            if (token2.getToknum() == 598) {
                bl2 = true;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 613) {
                bl3 = true;
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 472) {
                if (bl2) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(ThreadException.class));
                }
                token2 = this.tm.getToken();
                if (!bl2 && token2.getToknum() == 598) {
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 613) {
                        token2 = this.tm.getToken();
                    }
                    if (token2.getToknum() != 472) {
                        throw new ExpectedFoundException(token2, this.error, "'EXCEPTION'");
                    }
                    this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (bl2) {
                    this.tm.ungetToken();
                }
                if (bl3) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 453) {
            this.tm.ungetToken();
            return;
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        this.getCodeDebug(stringBuffer);
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        string = string + "   ";
        stringBuffer.append(string);
        stringBuffer.append("Factory.waitEnd (");
        if (this.threadHandle == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.threadHandle.getCode());
        }
        stringBuffer.append(", ");
        stringBuffer.append(this.last);
        stringBuffer.append(", ");
        if (this.timeoutVar != null) {
            stringBuffer.append(this.timeoutVar.getCode());
        } else if (this.timeoutToken != null) {
            stringBuffer.append(this.getCodeLiteral(this.timeoutToken));
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(", ");
        if (this.inThread == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.inThread.getCode());
        }
        stringBuffer.append(", ");
        if (this.size == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.size.getCode());
        }
        stringBuffer.append(", ");
        if (this.status == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.status.getCode());
        }
        stringBuffer.append(");");
        stringBuffer.append(eol);
        if (this.notOnException != null) {
            stringBuffer.append(this.notOnException.getCode());
        }
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("} catch (ThreadException ");
        stringBuffer.append(this.parent.getExceptName());
        stringBuffer.append(")");
        if (this.onException != null) {
            stringBuffer.append(this.onException.getCode());
        } else {
            stringBuffer.append("{ }");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

