/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.Move;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.Config;

public class Write
extends Verb
implements CobolToken,
ErrorsNumbers {
    private static final int XML_WRITE_DEFAULT = 0;
    private static final int XML_WRITE_ALL = 1;
    private static final int XML_WRITE_PROCESSING_INSTRUCTION = 2;
    private static final int XML_WRITE_PLAIN_TEXT = 3;
    private VariableDeclaration record;
    private FileDescriptor fd;
    private VariableName fromVar;
    private Token fromToken;
    private VariableName sizeVar;
    private Token sizeToken;
    private Token advancing;
    private boolean page;
    private int chnl;
    private Token nLinesToken;
    private VariableName nLinesVar;
    private VariableName positioningVar;
    private Block eopBlock;
    private Block notEopBlock;
    private InvalidKey invKey;
    private boolean lock;
    private boolean noStrip;
    private boolean noCr;
    private Token keyNameTk;
    private VariableName keyNameVn;
    private int xmlWrite;
    private static boolean m27333 = Config.b(".compiler.m27333", true);

    /*
     * Enabled aggressive block sorting
     */
    public Write(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2 = this.tm.getToken();
        if (token2.getToknum() == 10009) {
            this.tm.ungetToken();
            VariableName variableName = VariableName.get(this.tm, this.error, null, this.pc, true, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
            this.record = variableName.getVarDecl();
            this.fd = this.pc.getFdByRecord(this.record);
            if (this.fd != null && !this.fd.isXml()) {
                VariableName.checkDynGroup(variableName, false, this.error);
            }
        } else {
            if (token2.getToknum() != 482) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            token2 = this.tm.getToken();
            if (token2.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
            this.fd = this.pc.data.fileSec.getFD(token2.getWord());
            if (this.fd != null) {
                this.record = this.fd.recordDesc.getFirst();
            }
        }
        if (this.fd == null) {
            throw new GeneralErrorException(51, 4, this.keyWord, token2.getWord(), this.error);
        }
        if (this.fd.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, this.fd.sel.fileName.getWord(), this.error);
        }
        if (this.fd.isXml()) {
            boolean bl;
            token2 = this.tm.getToken();
            if (token2.getToknum() != 551) {
                this.tm.ungetToken();
                return;
            }
            token2 = this.tm.getToken();
            if (token2.getToknum() == 545) {
                token2 = this.tm.getToken();
            }
            if ((bl = "PROCESSING-INSTRUCTION".equals(token2.getWord())) || "PLAIN-TEXT".equals(token2.getWord())) {
                token2 = this.tm.getToken();
                switch (token2.getToknum()) {
                    case 10009: {
                        this.tm.ungetToken();
                        this.keyNameVn = VariableName.get(this.tm, this.error, this.pc);
                        if (this.keyNameVn.isNumeric()) throw new GeneralErrorException(21, 4, this.keyWord, token2.getWord(), this.error);
                        if (!this.keyNameVn.isObjectReference()) break;
                        throw new GeneralErrorException(21, 4, this.keyWord, token2.getWord(), this.error);
                    }
                    case 10001: {
                        this.keyNameTk = token2;
                        break;
                    }
                    default: {
                        throw new GeneralErrorException(21, 4, this.keyWord, token2.getWord(), this.error);
                    }
                }
                this.xmlWrite = bl ? 2 : 3;
                return;
            }
            if (token2.getToknum() != 10009) return;
            this.xmlWrite = token2.isAll() ? 1 : 0;
            this.tm.ungetToken();
            this.keyNameVn = VariableName.get(this.tm, this.error, this.pc);
            if (this.keyNameVn.isNumeric()) throw new GeneralErrorException(66, 4, this.keyWord, token2.getWord(), this.error);
            if (!this.keyNameVn.isObjectReference()) return;
            throw new GeneralErrorException(66, 4, this.keyWord, token2.getWord(), this.error);
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() == 498) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 10009) {
                this.tm.ungetToken();
                this.fromVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                if (token2.getToknum() != 10001 && token2.getToknum() != 10002) {
                    if (token2.getToknum() != 10017) throw new GeneralErrorException(24, 4, this.keyWord, token2.getWord(), this.error);
                }
                this.fromToken = token2;
            }
        } else {
            this.tm.ungetToken();
        }
        if (this.fd.sel.organization == 717) {
            token2 = this.tm.getToken();
            if (token2.getToknum() == 813 || token2.getToknum() == 596) {
                this.seqWithNo(token2);
            } else {
                this.sequential(token2);
            }
        } else {
            this.random();
        }
        token2 = this.tm.getToken();
        if (token2.getToknum() != 454) {
            this.tm.ungetToken();
            return;
        }
        this.endStmt = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void seqWithNo(Token token) throws GeneralErrorException, EndOfProgramException {
        if (token.getToknum() == 813) {
            token = this.tm.getToken();
        }
        if (token.getToknum() != 596) {
            throw new ExpectedFoundException(token, this.error, "NO");
        }
        token = this.tm.getToken();
        if (token.getToknum() == 373) {
            this.noCr = true;
        } else {
            if (token.getToknum() != 376) throw new ExpectedFoundException(token, this.error, "CONVERSION|CONTROL");
            this.noCr = true;
            this.noStrip = true;
        }
        this.fd.sel.isPrinter = true;
        this.fd.sel.isPrinterTok = token;
        token = this.tm.getToken();
        if (token.getToknum() == 728) {
            token = this.tm.getToken();
            if (token.getToknum() == 10009) {
                this.tm.ungetToken();
                this.sizeVar = VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                if (!Token.isNumLit(token)) throw new GeneralErrorException(24, 4, this.keyWord, token.getWord(), this.error);
                this.sizeToken = token;
            }
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sequential(Token token) throws GeneralErrorException, EndOfProgramException {
        Object object;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = this.pc.getOption("-cv") != null;
        if (!this.fd.sel.writeSimple && this.fd.sel.isPrinterTok != null && this.fd.sel.isPrinterTok.getToknum() == 373 && token.getToknum() != 299 && token.getToknum() != 261 && token.getToknum() != 598 && token.getToknum() != 728 && token.getToknum() != 284 && token.getToknum() != 460 && token.getToknum() != 439) {
            this.fd.sel.writeSimple = true;
        }
        if (token.getToknum() == 299 || token.getToknum() == 261) {
            if (token.getToknum() == 299) {
                this.fd.sel.hasBefore = true;
            }
            this.fd.sel.isPrinter = true;
            this.advancing = token;
            token = this.tm.getToken();
            if (bl && "POSITIONING".equals(token.getWord())) {
                token = this.tm.getToken();
                if (Token.isIntLit(token)) {
                    switch (Integer.parseInt(token.getWord())) {
                        case 0: {
                            this.page = true;
                            break;
                        }
                        default: {
                            token.setWord("1");
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            this.nLinesToken = token;
                            break;
                        }
                    }
                } else {
                    if (token.getToknum() != 10009) throw new UnexpectedTokenException(token, this.error);
                    this.tm.ungetToken();
                    this.positioningVar = VariableName.get(this.tm, this.error, this.pc);
                }
                token = this.tm.getToken();
                if (token.getToknum() == 565 || token.getToknum() == 566) {
                    token = this.tm.getToken();
                }
            } else {
                if (token.getToknum() == 260) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() == 629) {
                    this.page = true;
                    token = this.tm.getToken();
                } else {
                    if (token.getToknum() != 10009 && !Token.isIntLit(token)) throw new UnexpectedTokenException(token, this.error);
                    if (token.getToknum() == 10002) {
                        this.nLinesToken = token;
                    } else {
                        object = this.pc.getSNFunc(token.getWord());
                        if (object != null && bl && ("CSP".equals(object) || "C01".equals(object) || "C02".equals(object) || "C03".equals(object) || "C04".equals(object) || "C05".equals(object) || "C06".equals(object) || "C07".equals(object) || "C08".equals(object) || "C09".equals(object) || "C10".equals(object) || "C11".equals(object) || "C12".equals(object) || "AFP-5A".equals(object))) {
                            if ("AFP-5A".equals(object)) {
                                this.chnl = 13;
                            } else if ("CSP".equals(object)) {
                                token.setToknum(10002);
                                token.setWord("0");
                                this.nLinesToken = token;
                            } else {
                                this.chnl = Integer.parseInt(((String)object).substring(1));
                            }
                        } else {
                            this.tm.ungetToken();
                            this.nLinesVar = VariableName.get(this.tm, this.error, this.pc);
                            if (!this.nLinesVar.getVarDecl().isNumeric()) {
                                throw new GeneralErrorException(23, 4, token, token.getWord(), this.error);
                            }
                        }
                    }
                    token = this.tm.getToken();
                    if (token.getToknum() == 565 || token.getToknum() == 566) {
                        token = this.tm.getToken();
                    }
                }
            }
        }
        if (token.getToknum() == 728) {
            token = this.tm.getToken();
            if (token.getToknum() == 10009) {
                this.tm.ungetToken();
                this.sizeVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                if (!Token.isNumLit(token)) throw new GeneralErrorException(24, 4, this.keyWord, token.getWord(), this.error);
                this.sizeToken = token;
            }
            token = this.tm.getToken();
        }
        object = this.tm.getMarker();
        this.tm.setMarker((TokenManager.Marker)object);
        if (token.getToknum() == 598) {
            bl2 = true;
            token = this.tm.getToken();
            if (token.getToknum() != 284 && token.getToknum() != 460 && token.getToknum() != 439) {
                this.tm.rewindToMarker((TokenManager.Marker)object);
            }
        }
        if (token.getToknum() == 284 && (token = this.tm.getToken()).getToknum() != 460 && token.getToknum() != 439) {
            this.tm.rewindToMarker((TokenManager.Marker)object);
        }
        if (token.getToknum() == 460 || token.getToknum() == 439) {
            if (bl2) {
                this.notEopBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 12);
            } else {
                this.eopBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 11);
            }
            token = this.tm.getToken();
            if (!bl2 && token.getToknum() == 598) {
                token = this.tm.getToken();
                if (token.getToknum() == 284) {
                    token = this.tm.getToken();
                }
                if (token.getToknum() != 460 && token.getToknum() != 439) throw new ExpectedFoundException(token, this.error, "END-OF-PAGE");
                this.notEopBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                return;
            } else {
                this.tm.ungetToken();
            }
            return;
        } else if (bl) {
            this.tm.ungetToken();
            this.invKey = new InvalidKey(this.keyWord, this.fd.sel, this.parent, this, this.pc, this.tm, this.error);
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    private void random() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        if (token.getToknum() == 813 || token.getToknum() == 570) {
            if (token.getToknum() == 813) {
                token = this.tm.getToken();
            }
            if (token.getToknum() != 570) {
                throw new ExpectedFoundException(token, this.error, "LOCK");
            }
            this.lock = true;
        } else {
            this.tm.ungetToken();
        }
        this.invKey = new InvalidKey(this.keyWord, this.fd.sel, this.parent, this, this.pc, this.tm, this.error);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private void putAdvancingLines(StringBuffer stringBuffer) {
        if (this.page) {
            stringBuffer.append("0");
        } else if (this.chnl > 0) {
            stringBuffer.append(this.chnl);
        } else if (this.nLinesToken != null) {
            int n2;
            String string = this.nLinesToken.getCode();
            for (n2 = 0; n2 < string.length() - 1 && string.charAt(n2) == '0'; ++n2) {
            }
            stringBuffer.append(string.substring(n2));
        } else {
            stringBuffer.append(this.nLinesVar.getCode() + ".integer()");
        }
    }

    private String putOpts() {
        if (this.noCr) {
            if (this.noStrip) {
                return "3";
            }
            return "1";
        }
        if (this.noStrip) {
            return "2";
        }
        return "0";
    }

    @Override
    public String getCode() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.pc.getDeclarative(this.fd.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        stringBuffer.append(this.parent.getIndent());
        this.getCodeDebug(stringBuffer);
        boolean bl3 = bl = this.eopBlock != null || this.notEopBlock != null;
        if (this.fromVar != null || this.fromToken != null) {
            stringBuffer.append(this.parent.getIndent());
            if (this.fromVar != null) {
                stringBuffer.append(this.fromVar.getCode());
            } else {
                stringBuffer.append(this.getCodeLiteral(this.fromToken));
            }
            stringBuffer.append(".moveTo");
            if (Move.isDepOnGroupItem(this.record)) {
                stringBuffer.append("DepOnGroupItem");
            }
            stringBuffer.append("(");
            stringBuffer.append(this.record.getUnivoqueName());
            stringBuffer.append(");");
            stringBuffer.append(eol);
        }
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        if (this.fd.sel.isXml()) {
            stringBuffer.append(this.fd.sel.getName());
            stringBuffer.append(".writeXml(");
            stringBuffer.append(this.record.getUnivoqueName());
            stringBuffer.append(",");
            if (this.keyNameVn != null) {
                stringBuffer.append(this.keyNameVn.getCode());
            } else if (this.keyNameTk != null) {
                stringBuffer.append(this.tm.getCodeLiteral(this.keyNameTk));
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(",");
            stringBuffer.append(this.xmlWrite);
            stringBuffer.append(");");
            Use.putFileStatus(stringBuffer, this.fd.sel, this.parent.getIndent());
            Use.putDeclaratives(stringBuffer, this.pc, this.fd.sel, this.parent.getIndent(), bl2);
        } else {
            if (this.fd.sel.organization == 717) {
                if (!this.fd.sel.isPrinter) {
                    this.advancing = null;
                }
                if (bl) {
                    if (this.eopBlock != null) {
                        stringBuffer.append("if (");
                    } else {
                        stringBuffer.append("if (!");
                    }
                }
            } else {
                stringBuffer.append(this.invKey.getCodeBefore());
            }
            stringBuffer.append(this.fd.sel.getName());
            if (this.fd.sel.isPrinter) {
                stringBuffer.append(".writeAdvancing (");
                if (this.positioningVar != null) {
                    stringBuffer.append("Factory.vsPositioningType (");
                    stringBuffer.append(this.positioningVar.getCode());
                    stringBuffer.append("),");
                    stringBuffer.append("Factory.vsPositioningLines (");
                    stringBuffer.append(this.positioningVar.getCode());
                    stringBuffer.append("),");
                } else if (this.advancing != null) {
                    if (this.advancing.getToknum() == 261) {
                        if (this.chnl > 0) {
                            stringBuffer.append("IOConstants.ADVANCING_AFTER_CHNL,");
                        } else if (this.page) {
                            stringBuffer.append("IOConstants.ADVANCING_AFTER_PAGE,");
                        } else {
                            stringBuffer.append("IOConstants.ADVANCING_AFTER,");
                        }
                    } else if (this.chnl > 0) {
                        stringBuffer.append("IOConstants.ADVANCING_BEFORE_CHNL,");
                    } else if (this.page) {
                        stringBuffer.append("IOConstants.ADVANCING_BEFORE_PAGE,");
                    } else {
                        stringBuffer.append("IOConstants.ADVANCING_BEFORE,");
                    }
                    this.putAdvancingLines(stringBuffer);
                    stringBuffer.append(",");
                } else if (this.noCr) {
                    stringBuffer.append("IOConstants.ADVANCING_AFTER, 0,");
                } else if (m27333 && this.fd.sel.isLine() && this.pc.options.getOption("-cm") != null) {
                    stringBuffer.append("IOConstants.ADVANCING_BEFORE, 1,");
                } else if (this.fd.sel.writeSimple) {
                    stringBuffer.append("IOConstants.ADVANCING_BEFORE, 1,");
                } else {
                    stringBuffer.append("IOConstants.ADVANCING_AFTER, 1,");
                }
            } else {
                stringBuffer.append(".write(");
            }
            stringBuffer.append(this.lock);
            stringBuffer.append(",");
            if (this.fd.sel.organization != 677) {
                if (this.sizeVar != null) {
                    stringBuffer.append(this.sizeVar.getCode());
                    stringBuffer.append(".toint()");
                } else if (this.sizeToken != null) {
                    stringBuffer.append(this.getCodeLiteral(this.sizeToken));
                    stringBuffer.append(".toint()");
                } else if (this.record.getRecDepending() != null && this.tm.getOptionList().getOption("-crv") != null) {
                    stringBuffer.append(this.record.getUnivoqueName() + ".length()");
                } else if (this.fd.getDepending() != null) {
                    if (this.fd.getDependingOffs() > 0) {
                        stringBuffer.append(this.fd.getDependingOffs() + " + ");
                    }
                    stringBuffer.append(this.fd.getDepending().getCode());
                    stringBuffer.append(".toint()");
                } else {
                    stringBuffer.append(this.fd.recordMin > this.record.globalLen() ? this.fd.recordMin : this.record.globalLen());
                }
            } else {
                stringBuffer.append(this.fd.recordMin > this.record.globalLen() ? this.fd.recordMin : this.record.globalLen());
            }
            if (this.fd.sel.isPrinter) {
                stringBuffer.append(",");
                stringBuffer.append(this.putOpts());
            }
            stringBuffer.append(")");
            if (this.fd.sel.organization == 717) {
                if (bl) {
                    stringBuffer.append(")");
                    if (this.eopBlock != null) {
                        stringBuffer.append(this.eopBlock.getCode());
                        if (this.notEopBlock != null) {
                            stringBuffer.append(" else ");
                            stringBuffer.append(this.notEopBlock.getCode());
                        }
                    } else if (this.notEopBlock != null) {
                        stringBuffer.append(this.notEopBlock.getCode());
                    }
                } else {
                    stringBuffer.append(";");
                }
                Use.putFileStatus(stringBuffer, this.fd.sel, this.parent.getIndent());
            } else {
                stringBuffer.append(";");
                Use.putFileStatus(stringBuffer, this.fd.sel, this.parent.getIndent());
                stringBuffer.append(this.invKey.getCode());
            }
            Use.putDeclaratives(stringBuffer, this.pc, this.fd.sel, this.parent.getIndent(), bl2);
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public Block getEopBlock() {
        return this.eopBlock;
    }

    public Block getNotEopBlock() {
        return this.notEopBlock;
    }

    public InvalidKey getInvKey() {
        return this.invKey;
    }

    public Token getSizeToken() {
        return this.sizeToken;
    }

    public VariableName getSizeVar() {
        return this.sizeVar;
    }

    public VariableDeclaration getRecord() {
        return this.record;
    }

    public VariableName getPositioningVar() {
        return this.positioningVar;
    }

    public boolean isLock() {
        return this.lock;
    }

    public boolean isPage() {
        return this.page;
    }

    public Token getAdvancing() {
        return this.advancing;
    }

    public boolean isNoCr() {
        return this.noCr;
    }

    public boolean isNoStrip() {
        return this.noStrip;
    }

    public VariableName getNLinesVar() {
        return this.nLinesVar;
    }

    public Token getNLinesToken() {
        return this.nLinesToken;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public Token getFromToken() {
        return this.fromToken;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }
}

