/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.XMLException;

public class Xml
extends Verb {
    private VariableName var1;
    private VariableName from;
    private VariableName count;
    private LabelName startLabel;
    private LabelName endLabel;
    private int[] parNum;
    private String perfName;
    private BlockException onException;
    private Block notOnException;

    public Xml(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        CobolToken cobolToken;
        if (!this.pc.xmlVarsDeclared) {
            Pcc pcc2 = this.pc instanceof CobolMethod ? this.pc : this.pc.parent;
            Token token2 = new Token(10009, "XML-TEXT", 0, 0, this.tm.getFileName());
            cobolToken = VariableDeclaration.getPicAnyLength(pcc2, this.tm, token2, null, false);
            this.pc.fixedVars.addItem((VariableDeclaration)cobolToken);
            this.pc.loadVariable((VariableDeclaration)cobolToken);
            ((VariableDeclaration)cobolToken).setUsed();
            token2 = new Token(10009, "XML-CODE", 0, 0, this.tm.getFileName());
            cobolToken = VariableDeclaration.getPicDefaultNum(pcc2, this.tm, token2, true);
            this.pc.fixedVars.addItem((VariableDeclaration)cobolToken);
            this.pc.loadVariable((VariableDeclaration)cobolToken);
            ((VariableDeclaration)cobolToken).setUsed();
            token2 = new Token(10009, "XML-EVENT", 0, 0, this.tm.getFileName());
            cobolToken = VariableDeclaration.getPicX(pcc2, this.tm, token2, 30, null);
            this.pc.fixedVars.addItem((VariableDeclaration)cobolToken);
            this.pc.loadVariable((VariableDeclaration)cobolToken);
            ((VariableDeclaration)cobolToken).setUsed();
            token2 = new Token(10009, "XML-NTEXT", 0, 0, this.tm.getFileName());
            cobolToken = VariableDeclaration.getPicAnyLength(pcc2, this.tm, token2, null, true);
            this.pc.fixedVars.addItem((VariableDeclaration)cobolToken);
            this.pc.loadVariable((VariableDeclaration)cobolToken);
            ((VariableDeclaration)cobolToken).setUsed();
            token2 = new Token(10009, "XML-ERRMSG", 0, 0, this.tm.getFileName());
            cobolToken = VariableDeclaration.getPicAnyLength(pcc2, this.tm, token2, null, true);
            this.pc.fixedVars.addItem((VariableDeclaration)cobolToken);
            this.pc.loadVariable((VariableDeclaration)cobolToken);
            ((VariableDeclaration)cobolToken).setUsed();
            this.pc.addImport("import com.iscobol.rts.XMLParseGenerate;");
            this.pc.addImport("import com.iscobol.rts.XMLException;");
            this.pc.xmlVarsDeclared = true;
        }
        if (((Token)(cobolToken = this.tm.getToken())).getToknum() == 631) {
            this.parse();
        } else if (((Token)cobolToken).getToknum() == 501) {
            this.generate();
        } else {
            throw new ExpectedFoundException((Token)cobolToken, this.error, "PARSE|GENERATE");
        }
    }

    private void parse() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        this.tm.ungetToken();
        this.var1 = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (this.var1 == null) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        token = this.tm.getToken();
        if (!"PROCESSING".equals(token.getWord())) {
            throw new ExpectedFoundException(token, this.error, "PROCESSING");
        }
        token = this.tm.getToken();
        if (token.getToknum() != 651) {
            throw new ExpectedFoundException(token, this.error, "PROCEDURE");
        }
        token = this.tm.getToken();
        if (token.getToknum() != 545) {
            this.tm.ungetToken();
        }
        this.startLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
        if (this.startLabel == null) {
            throw new GeneralErrorException(47, 4, this.keyWord, null, this.error);
        }
        token = this.tm.getToken();
        if (token.getToknum() == 768 || token.getToknum() == 767) {
            this.endLabel = LabelName.get(this.parent, this.tm, this.error, this.pc);
            if (this.endLabel == null) {
                throw new GeneralErrorException(47, 4, this.keyWord, null, this.error);
            }
        } else {
            this.tm.ungetToken();
        }
        this.onExcptn();
    }

    private void onExcptn() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        if (token.getToknum() == 598 || token.getToknum() == 613 || token.getToknum() == 472) {
            boolean bl = false;
            boolean bl2 = false;
            if (token.getToknum() == 598) {
                bl2 = true;
                token = this.tm.getToken();
            }
            if (token.getToknum() == 613) {
                bl = true;
                token = this.tm.getToken();
            }
            if (token.getToknum() == 472) {
                if (bl2) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(XMLException.class));
                }
                TokenManager.Marker marker = this.tm.getMarker();
                this.tm.setMarker(marker);
                token = this.tm.getToken();
                if (!bl2 && token.getToknum() == 598) {
                    token = this.tm.getToken();
                    if (token.getToknum() == 613) {
                        token = this.tm.getToken();
                    }
                    if (token.getToknum() != 472) {
                        this.tm.rewindToMarker(marker);
                    } else {
                        this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (bl2) {
                    this.tm.ungetToken();
                }
                if (bl) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        token = this.tm.getToken();
        if (token.getToknum() != 455) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private void generate() throws GeneralErrorException, EndOfProgramException {
        Token token = this.tm.getToken();
        this.tm.ungetToken();
        this.var1 = VariableName.get(this.tm, this.error, this.pc);
        if (this.var1 == null) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        token = this.tm.getToken();
        if (token.getToknum() != 498) {
            throw new ExpectedFoundException(token, this.error, "FROM");
        }
        token = this.tm.getToken();
        this.tm.ungetToken();
        this.from = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (this.from == null) {
            throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
        }
        this.from.getVarDecl().setAutoIdentifiedBy();
        this.from.getVarDecl().setUsedAll();
        token = this.tm.getToken();
        if (token.getToknum() == 382) {
            token = this.tm.getToken();
            if (token.getToknum() != 526) {
                token = this.tm.getToken();
            }
            token = this.tm.getToken();
            this.tm.ungetToken();
            this.count = VariableName.get(this.tm, this.error, this.pc);
            if (this.count == null) {
                throw new GeneralErrorException(17, 4, token, token.getWord(), this.error);
            }
        } else {
            this.tm.ungetToken();
        }
        this.onExcptn();
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.startLabel != null) {
            this.parNum = new int[2];
            this.perfName = Perform.check(this.startLabel, this.endLabel, this.parNum, this.pc.inDeclaratives, this.pc);
        }
    }

    @Override
    public String getCode() {
        String string = this.parent.getIndent();
        StringBuffer stringBuffer = new StringBuffer();
        this.getCodeDebug(stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("try {");
        stringBuffer.append(eol);
        string = string + "   ";
        if (this.startLabel != null) {
            stringBuffer.append(string);
            stringBuffer.append("(new XMLParseGenerate (");
            stringBuffer.append(this.var1.getCode());
            if (this.var1.getVarDecl().isNational()) {
                stringBuffer.append("," + this.getLocalVar("XML-CODE") + "," + this.getLocalVar("XML-EVENT") + "," + this.getLocalVar("XML-NTEXT") + "," + this.getLocalVar("XML-ERRMSG") + ") {");
            } else {
                stringBuffer.append("," + this.getLocalVar("XML-CODE") + "," + this.getLocalVar("XML-EVENT") + "," + this.getLocalVar("XML-TEXT") + "," + this.getLocalVar("XML-ERRMSG") + ") {");
            }
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("   public void processing() {");
            stringBuffer.append(eol);
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = Perform.getPerformCode(this.pc, this.parNum[0], this.parNum[1], string + "         ", stringBuffer2, this.perfName, this.startLabel, true);
            if (bl) {
                stringBuffer.append(string);
                stringBuffer.append("      try {");
                stringBuffer.append(eol);
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(eol);
            if (bl) {
                stringBuffer.append(string);
                stringBuffer.append("      } catch (GotoException $g) { }");
            }
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("   }");
            stringBuffer.append(eol);
            stringBuffer.append(string);
            stringBuffer.append("}).parse();");
            stringBuffer.append(eol);
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string);
            stringBuffer.append("XMLParseGenerate.generate (");
            stringBuffer.append(this.var1.getCode());
            stringBuffer.append(",");
            stringBuffer.append(this.from.getCode());
            SubscriptList subscriptList = this.from.getIndexes();
            if (subscriptList == null) {
                stringBuffer.append(",null");
            } else {
                stringBuffer.append(",new int[] {");
                Subscript subscript = subscriptList.getFirst();
                while (true) {
                    stringBuffer.append(subscript.getCode());
                    subscript = subscriptList.getNext();
                    if (subscript == null) break;
                    stringBuffer.append(",");
                }
                stringBuffer.append("}");
            }
            stringBuffer.append(",");
            if (this.count != null) {
                stringBuffer.append(this.count.getCode());
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append("," + this.getLocalVar("XML-CODE") + ");");
            stringBuffer.append(eol);
        }
        if (this.notOnException != null) {
            stringBuffer.append(this.notOnException.getCode());
        }
        stringBuffer.append(eol);
        stringBuffer.append(this.parent.getIndent());
        stringBuffer.append("} catch (XMLException ");
        stringBuffer.append(this.parent.getExceptName());
        stringBuffer.append(")");
        if (this.onException != null) {
            stringBuffer.append(this.onException.getCode());
        } else {
            stringBuffer.append("{ }");
        }
        stringBuffer.append(eol);
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public LabelName getStartLabel() {
        return this.startLabel;
    }

    public LabelName getEndLabel() {
        return this.endLabel;
    }

    public VariableName getDestination() {
        return this.var1;
    }

    public VariableName getFrom() {
        return this.from;
    }

    public VariableName getCount() {
        return this.count;
    }

    public BlockException getOnException() {
        return this.onException;
    }

    public Block getNotOnException() {
        return this.notOnException;
    }

    public String getPerformMethodName() {
        return this.perfName;
    }

    public LabelName getStartName() {
        return this.startLabel;
    }

    public LabelName getEndName() {
        return this.endLabel;
    }
}

