/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.bincode;

import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.bincode.AbstractJavaCompiler;
import com.iscobol.compiler.bincode.Callable;
import com.iscobol.compiler.remote.server.RemoteCompilerClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExternalJavaCompiler
extends AbstractJavaCompiler {
    private final List options;

    public ExternalJavaCompiler(OptionList optionList, String string) {
        super(optionList);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof RemoteCompilerClassLoader) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = System.getProperty("java.class.path");
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            }
            for (File file : ((RemoteCompilerClassLoader)classLoader).getPaths()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(File.pathSeparator);
                }
                stringBuffer.append(file.getPath());
            }
            arrayList.add("-classpath");
            arrayList.add(stringBuffer.toString());
        }
        this.addCompilerOptions(arrayList);
        this.options = Collections.unmodifiableList(arrayList);
    }

    @Override
    protected Callable getCompilationTaskImpl(String[] stringArray) {
        return () -> {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.options);
            this.addSourcePathOption(arrayList, stringArray);
            for (String string : stringArray) {
                arrayList.add(string);
            }
            String[] stringArray2 = arrayList.toArray(new String[0]);
            Process process = Runtime.getRuntime().exec(stringArray2);
            new StreamDrainer(process.getInputStream(), System.out).start();
            new StreamDrainer(process.getErrorStream(), System.err).start();
            int n2 = process.waitFor();
            return new Integer(n2);
        };
    }

    private static class StreamDrainer
    extends Thread {
        private final InputStream input;
        private final PrintStream output;

        public StreamDrainer(InputStream inputStream, PrintStream printStream) {
            this.input = inputStream;
            this.output = printStream;
        }

        @Override
        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.input));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    this.output.println(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

