/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.bincode;

import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.bincode.AbstractJavaCompiler;
import com.iscobol.compiler.bincode.Callable;
import com.iscobol.compiler.bincode.NoJavaCompilerException;
import com.iscobol.compiler.remote.server.RemoteCompilerClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class InProcessJavaCompiler
extends AbstractJavaCompiler {
    private final List<String> options;

    public InProcessJavaCompiler(OptionList optionList) {
        super(optionList);
        ArrayList arrayList = new ArrayList();
        this.addCompilerOptions(arrayList);
        this.options = Collections.unmodifiableList(arrayList);
    }

    @Override
    protected Callable getCompilationTaskImpl(String[] stringArray) {
        Iterable<? extends File> iterable;
        ArrayList<String> arrayList;
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            return () -> {
                throw new NoJavaCompilerException();
            };
        }
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof RemoteCompilerClassLoader) {
            arrayList = new ArrayList<String>();
            iterable = standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH);
            if (iterable != null) {
                for (File object2 : iterable) {
                    arrayList.add((String)((Object)object2));
                }
            }
            arrayList.addAll(((RemoteCompilerClassLoader)classLoader).getPaths());
            try {
                standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, arrayList);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        arrayList = new ArrayList();
        arrayList.addAll(this.options);
        this.addSourcePathOption(arrayList, stringArray);
        iterable = new ArrayList<File>();
        PrintWriter printWriter = new PrintWriter(System.err);
        for (JavaFileObject javaFileObject : standardJavaFileManager.getJavaFileObjects(stringArray)) {
            iterable.add((JavaFileObject)javaFileObject);
        }
        JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(printWriter, standardJavaFileManager, diagnostic -> {
            if (diagnostic.getKind() != Diagnostic.Kind.NOTE) {
                System.err.println(diagnostic);
            }
        }, arrayList, null, iterable);
        return () -> compilationTask.call() != false ? 0 : 1;
    }
}

