/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.html;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EmbeddedStatement;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.html.SubstitutionMarker;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.LinkedList;

public class Exec
extends EmbeddedStatement
implements CobolToken,
ErrorsNumbers {
    private static Pcc lastPcc;
    private final ArrayList code = new ArrayList();
    private final ArrayList lines;

    public Exec(Token token, Block block, Pcc pcc, TokenManager tokenManager, Errors errors) throws GeneralErrorException, EndOfProgramException {
        super(token, block, pcc, tokenManager, errors);
        Token token2;
        if (lastPcc != this.pc.getRoot()) {
            lastPcc = this.pc.getRoot();
            if (this.pc.getOption("-cp") != null) {
                this.pc.addImport("import com.iscobol.rts.HTTPHandler;");
            }
        }
        if ((token2 = this.tm.getToken()).getToknum() != 10002) {
            throw new UnexpectedTokenException(token2, this.error);
        }
        LinkedList linkedList = pcc.getExternalExecLines();
        int n2 = token2.longValue();
        if (linkedList == null || linkedList.size() <= n2) {
            throw new UnexpectedTokenException(token2, this.error);
        }
        this.lines = (ArrayList)linkedList.get(n2);
        while ((token2 = this.tm.getToken()).getToknum() != 432) {
        }
        for (int i2 = 0; i2 < this.lines.size(); ++i2) {
            String string = (String)this.lines.get(i2);
            if (string.matches("^[ \t]*(?i)copy[ \t]*\".*\"[. \t]*$")) {
                int n3;
                int n4 = string.indexOf(34);
                String string2 = string.substring(n4 + 1, n3 = string.lastIndexOf(34));
                File file = PreProcessor.findFile(string2, this.tm.getOptionList());
                if (file == null) {
                    throw new GeneralErrorException(3, 4, this.keyWord, string2, this.error);
                }
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    String string3;
                    LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
                    while ((string3 = lineNumberReader.readLine()) != null) {
                        this.processLine(string3);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    throw new GeneralErrorException(61, 4, this.keyWord, iOException.toString(), this.error);
                }
            }
            this.processLine(string);
        }
    }

    private void processLine(String string) throws GeneralErrorException {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ':': {
                    if (i2 > 0 && (Character.isLetter(string.charAt(i2 - 1)) || i2 + 1 == n2 || !SubstitutionMarker.isValidChar(string.charAt(i2 + 1)))) {
                        stringBuffer.append(':');
                        continue block4;
                    }
                    SubstitutionMarker substitutionMarker = SubstitutionMarker.get(this.keyWord, this.pc, string, i2 + 1);
                    if (substitutionMarker != null) {
                        substitutionMarker.check(this.pc, this.error);
                        this.code.add(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        this.code.add(substitutionMarker);
                        i2 = substitutionMarker.getNextCharPos() - 1;
                        continue block4;
                    }
                    stringBuffer.append(':');
                    continue block4;
                }
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        stringBuffer.append("\\n");
        this.code.add(stringBuffer);
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getCodeDebug(stringBuffer);
        int n2 = this.code.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = this.code.get(i2);
            stringBuffer.append("      HTTPHandler.cgiDisplay (");
            if (e2 instanceof Token) {
                stringBuffer.append("\"");
                stringBuffer.append(((Token)e2).getCode());
                stringBuffer.append("\");");
            } else if (e2 instanceof SubstitutionMarker) {
                stringBuffer.append(((SubstitutionMarker)e2).getCode());
                stringBuffer.append(");");
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(e2.toString());
                stringBuffer.append("\");");
            }
            stringBuffer.append(eol);
        }
        this.getCodeDebugEnd(stringBuffer);
        return stringBuffer.toString();
    }
}

