/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.html;

import com.iscobol.compiler.OptionList;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;

public class HtmlPreProcessor
extends Reader {
    protected static String eolSt = System.getProperty("line.separator", "\n");
    protected static char[] eolCh = eolSt.toCharArray();
    private final LineNumberReader inpFile;
    private LineNumberReader cpyFile;
    private char[] currLine = eolCh;
    private int currOffs = eolCh.length;
    private final OptionList opList;
    private final int col0;
    private final LinkedList linesStack;
    private ArrayList lines;

    public HtmlPreProcessor(Reader reader, OptionList optionList, LinkedList linkedList) {
        this.inpFile = new LineNumberReader(reader);
        this.opList = optionList;
        this.col0 = optionList.getOption("-sa") != null ? 7 : (optionList.getOption("-st") != null ? 0 : 0);
        this.linesStack = linkedList;
    }

    protected boolean nextLine() throws IOException {
        String string = this.inpFile.readLine();
        if (string == null) {
            this.currLine = eolCh;
            this.currOffs = eolCh.length;
            return false;
        }
        this.currLine = this.process(string);
        this.currOffs = 0;
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.currOffs >= this.currLine.length) {
            this.currOffs = 0;
            if (this.currLine == eolCh) {
                if (this.nextLine()) {
                    return this.read();
                }
                return -1;
            }
            this.currLine = eolCh;
            return this.currLine[this.currOffs++];
        }
        return this.currLine[this.currOffs++];
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            int n6 = this.read();
            if (n6 < 0) {
                if (n4 != 0) break;
                return -1;
            }
            cArray[n5] = (char)n6;
            ++n4;
            ++n5;
        }
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        throw new IOException("skip() not supported");
    }

    @Override
    public boolean ready() throws IOException {
        throw new IOException("ready() not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n2) throws IOException {
        throw new IOException("mark() not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public void close() throws IOException {
        this.inpFile.close();
        if (this.cpyFile != null) {
            this.cpyFile.close();
        }
    }

    private char[] process(String string) {
        if (this.lines != null) {
            if (string.matches("^[ \t]*(?i)end-exec[. \t]*$")) {
                this.lines = null;
                return string.toCharArray();
            }
            if (this.col0 == 0) {
                this.lines.add(string);
                return ("*>" + string).toCharArray();
            }
            String string2 = string.substring(this.col0);
            this.lines.add(string2);
            return (string.substring(0, this.col0) + "*>" + string2).toCharArray();
        }
        if (string.matches("^[ \t]*(?i)exec[ \t][ \t]*html[ \t]*$")) {
            if (this.col0 > 0) {
                string = string.substring(0, this.col0) + string.substring(this.col0).trim();
            }
            string = string + " ";
            string = string + this.linesStack.size();
            this.lines = new ArrayList();
            this.linesStack.add(this.lines);
        }
        return string.toCharArray();
    }
}

