/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.html;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class SubstitutionMarker
implements CobolToken,
ErrorsNumbers {
    private final int nextCharPos;
    private StringBuffer value = new StringBuffer();
    private ArrayList indexes;
    private final VariableName varName;
    private final Token keyWord;
    private boolean isInteger;

    SubstitutionMarker(Token token, String string, int n2) {
        char c2 = '\u0000';
        int n3 = string.length();
        this.isInteger = true;
        while (n2 < n3 && SubstitutionMarker.isValidChar(c2 = string.charAt(n2))) {
            this.value.append(c2);
            this.isInteger &= Character.isDigit(c2);
            ++n2;
        }
        if (n2 < n3 && !this.isInteger) {
            int n4 = n2;
            while (n2 < n3 && (c2 = string.charAt(n2)) <= ' ') {
                ++n2;
            }
            if (c2 == '(' && ++n2 < n3 && SubstitutionMarker.isValidChar(string.charAt(n2))) {
                block8: {
                    SubstitutionMarker substitutionMarker;
                    this.indexes = new ArrayList();
                    do {
                        substitutionMarker = new SubstitutionMarker(token, string, n2);
                        this.indexes.add(substitutionMarker);
                        for (n2 = substitutionMarker.nextCharPos; n2 < n3 && ((c2 = string.charAt(n2)) <= ' ' || c2 == ',' || c2 == ';'); ++n2) {
                        }
                        if (n2 >= n3) break block8;
                        if (c2 != ')') continue;
                        ++n2;
                        break block8;
                    } while (SubstitutionMarker.isValidChar(c2));
                    n2 = substitutionMarker.nextCharPos;
                }
                this.nextCharPos = n2;
            } else {
                this.nextCharPos = n4;
            }
        } else {
            this.nextCharPos = n2;
        }
        this.keyWord = token;
        this.varName = new VariableName(new Token(10009, this.value.toString().toUpperCase(), this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.value);
        if (this.indexes != null) {
            stringBuffer.append('(');
            int n2 = 0;
            while (true) {
                stringBuffer.append(this.indexes.get(n2).toString());
                if (++n2 >= this.indexes.size()) break;
                stringBuffer.append(',');
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static boolean isValidChar(char c2) {
        return Character.isLetter(c2) || Character.isDigit(c2) || c2 == '-';
    }

    public static SubstitutionMarker get(Token token, Pcc pcc, String string, int n2) {
        SubstitutionMarker substitutionMarker = new SubstitutionMarker(token, string, n2);
        if (substitutionMarker.isInteger || !substitutionMarker.varName.isDeclared(pcc)) {
            substitutionMarker = null;
        }
        return substitutionMarker;
    }

    public int getNextCharPos() {
        return this.nextCharPos;
    }

    public void check(Pcc pcc, Errors errors) throws GeneralErrorException {
        if (!this.isInteger) {
            this.varName.check(pcc, false, true, GetVarOpts.NO_OPTS);
            VariableDeclaration variableDeclaration = this.varName.getVarDecl();
            if (this.indexes == null) {
                if (variableDeclaration.getDimension() != 0) {
                    throw new GeneralErrorException(41, 4, this.keyWord, this.value.toString(), errors);
                }
            } else {
                int n2 = this.indexes.size();
                if (variableDeclaration.getDimension() != n2) {
                    throw new GeneralErrorException(189, 4, this.keyWord, this.value.toString(), errors);
                }
                if (variableDeclaration.hasVariableOffset()) {
                    throw new GeneralErrorException(19, 4, this.keyWord, " -cod1:" + this.value.toString(), errors);
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((SubstitutionMarker)this.indexes.get(i2)).check(pcc, errors);
                }
            }
        }
    }

    public String getCode() {
        return this.getCode(false);
    }

    public String getCodeAsInt() {
        return this.getCode(true);
    }

    private String getCode(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isInteger) {
            stringBuffer.append(this.value);
        } else {
            Token token;
            VariableDeclaration variableDeclaration = this.varName.getVarDecl();
            if (variableDeclaration.isConstant() && (token = variableDeclaration.getValueToken()) != null) {
                stringBuffer.append("\"");
                stringBuffer.append(token.getCode());
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(variableDeclaration.getUnivoqueName());
                if (this.indexes != null) {
                    int n2 = this.indexes.size();
                    if (variableDeclaration.isObjectReference()) {
                        for (int i2 = 0; i2 < n2; ++i2) {
                            SubstitutionMarker substitutionMarker = (SubstitutionMarker)this.indexes.get(i2);
                            stringBuffer.append("[");
                            stringBuffer.append(substitutionMarker.getCodeAsInt());
                            stringBuffer.append("]");
                        }
                    } else {
                        if (variableDeclaration.isEdited() && variableDeclaration.isNumeric()) {
                            stringBuffer.append(".atEdit");
                        } else {
                            stringBuffer.append(".at");
                        }
                        if (n2 == 1) {
                            SubstitutionMarker substitutionMarker = (SubstitutionMarker)this.indexes.get(0);
                            stringBuffer.append(" (");
                            stringBuffer.append(substitutionMarker.getCodeAsInt());
                            stringBuffer.append(" )");
                        } else {
                            stringBuffer.append(" (new int[] {");
                            int n3 = 0;
                            while (true) {
                                SubstitutionMarker substitutionMarker = (SubstitutionMarker)this.indexes.get(n3);
                                stringBuffer.append(substitutionMarker.getCodeAsInt());
                                if (++n3 >= n2) break;
                                stringBuffer.append(",");
                            }
                            stringBuffer.append("})");
                        }
                    }
                }
                if (bl) {
                    stringBuffer.append(".toint()");
                } else {
                    stringBuffer.append(".toString().trim()");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        Token token = new Token(10009, "dummy", 1, 1, "System.in");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = bufferedReader.readLine();
        SubstitutionMarker substitutionMarker = new SubstitutionMarker(token, string, 0);
        System.out.println(string);
        System.out.println("0----5----0----5----0----5----0----5----0----5----");
        System.out.println(substitutionMarker);
        System.out.println(substitutionMarker.nextCharPos);
    }
}

