/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.phases;

import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.phases.Phases;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class PhasesFactory {
    private static final String STANDARD_VERSION_PHASES = "com.iscobol.compiler.StandardPhases";

    private PhasesFactory() {
    }

    public static Phases create(OptionList optionList) {
        String string = STANDARD_VERSION_PHASES;
        try {
            try {
                return PhasesFactory.createPhases(STANDARD_VERSION_PHASES, PhasesFactory.class.getClassLoader(), optionList);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return PhasesFactory.createPhases(STANDARD_VERSION_PHASES, classLoader, optionList);
                }
                throw classNotFoundException;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error("Internal Logic error - could not load class com.iscobol.compiler.StandardPhases", invocationTargetException.getCause());
        }
        catch (Exception exception) {
            throw new Error("Internal Logic error - could not load class com.iscobol.compiler.StandardPhases", exception);
        }
    }

    private static Phases createPhases(String string, ClassLoader classLoader, OptionList optionList) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass(string);
        if (!Phases.class.isAssignableFrom(clazz)) {
            throw new InstantiationException("Not a valid class");
        }
        try {
            Class[] classArray = new Class[]{OptionList.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{optionList};
            return (Phases)constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class[] classArray = new Class[]{};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{};
            return (Phases)constructor.newInstance(objectArray);
        }
    }
}

