/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.compiler.Errors;
import com.iscobol.compiler.remote.RemoteBridgeFile;
import com.iscobol.compiler.remote.RemoteErrors;
import com.iscobol.compiler.remote.RemoteFile;
import com.iscobol.interfaces.compiler.remote.IRemoteUnitOutput;
import com.iscobol.rts.RtsUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class PPFileOutput
implements IRemoteUnitOutput,
Externalizable {
    private static final long serialVersionUID = 1L;
    private RemoteFile translatedFile;
    private RemoteFile errorFile;
    private RemoteFile listingFile;
    private RemoteFile[] classFiles;
    private Vector bridgeFiles = new Vector();
    private Vector javaFiles = new Vector();
    private RemoteFile iscobolListingFile;
    private RemoteFile iscobolErrorFile;
    private Vector copyFileNames;
    private RemoteErrors errors;
    private String fullClassName;
    private String sourceFileName;

    public PPFileOutput() {
    }

    public PPFileOutput(String string) {
        this.sourceFileName = string;
    }

    @Override
    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String string) {
        this.sourceFileName = string;
    }

    @Override
    public RemoteFile getTranslatedFile() {
        return this.translatedFile;
    }

    public void setTranslatedFile(RemoteFile remoteFile) {
        this.translatedFile = remoteFile;
    }

    @Override
    public RemoteFile getErrorFile() {
        return this.errorFile;
    }

    public void setErrorFile(RemoteFile remoteFile) {
        this.errorFile = remoteFile;
    }

    @Override
    public RemoteFile getListingFile() {
        return this.listingFile;
    }

    public void setListingFile(RemoteFile remoteFile) {
        this.listingFile = remoteFile;
    }

    public RemoteFile[] getClassFiles() {
        return this.classFiles;
    }

    public void setClassFiles(RemoteFile[] remoteFileArray) {
        this.classFiles = remoteFileArray;
    }

    @Override
    public RemoteFile getJavaFile() {
        return this.javaFiles.size() > 0 ? (RemoteFile)this.javaFiles.elementAt(0) : null;
    }

    public void addJavaFile(RemoteFile remoteFile) {
        this.javaFiles.addElement(remoteFile);
    }

    @Override
    public RemoteFile getIscobolListingFile() {
        return this.iscobolListingFile;
    }

    public void setIscobolListingFile(RemoteFile remoteFile) {
        this.iscobolListingFile = remoteFile;
    }

    @Override
    public RemoteFile getIscobolErrorFile() {
        return this.iscobolErrorFile;
    }

    public void setIscobolErrorFile(RemoteFile remoteFile) {
        this.iscobolErrorFile = remoteFile;
    }

    @Override
    public Vector getCopyFileNames() {
        return this.copyFileNames;
    }

    public void setCopyFileNames(Vector vector) {
        this.copyFileNames = vector;
    }

    @Override
    public Errors getErrors() {
        return this.errors;
    }

    public void setErrors(RemoteErrors remoteErrors) {
        this.errors = remoteErrors;
    }

    @Override
    public String getFullClassName() {
        return this.fullClassName;
    }

    public void setFullClassName(String string) {
        this.fullClassName = string;
    }

    public RemoteBridgeFile[] getBridgeFiles() {
        RemoteBridgeFile[] remoteBridgeFileArray = new RemoteBridgeFile[this.bridgeFiles.size()];
        this.bridgeFiles.toArray(remoteBridgeFileArray);
        return remoteBridgeFileArray;
    }

    public void addBridgeFile(RemoteBridgeFile remoteBridgeFile) {
        this.bridgeFiles.addElement(remoteBridgeFile);
    }

    public RemoteFile[] getJavaFiles() {
        RemoteFile[] remoteFileArray = new RemoteFile[this.javaFiles.size()];
        this.javaFiles.toArray(remoteFileArray);
        return remoteFileArray;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.bridgeFiles.size());
        for (Object e2 : this.bridgeFiles) {
            ((RemoteBridgeFile)e2).writeExternal(objectOutput);
        }
        if (this.classFiles != null) {
            objectOutput.writeInt(this.classFiles.length);
            for (int i2 = 0; i2 < this.classFiles.length; ++i2) {
                this.classFiles[i2].writeExternal(objectOutput);
            }
        } else {
            objectOutput.writeInt(0);
        }
        if (this.copyFileNames != null) {
            objectOutput.writeInt(this.copyFileNames.size());
            for (Object e2 : this.copyFileNames) {
                RtsUtil.writeUTF(((String[])e2)[0], objectOutput);
                RtsUtil.writeUTF(((String[])e2)[1], objectOutput);
                RtsUtil.writeUTF(((String[])e2)[2], objectOutput);
            }
        } else {
            objectOutput.writeInt(0);
        }
        objectOutput.writeBoolean(this.errorFile != null);
        if (this.errorFile != null) {
            this.errorFile.writeExternal(objectOutput);
        }
        objectOutput.writeBoolean(this.errors != null);
        if (this.errors != null) {
            this.errors.writeExternal(objectOutput);
        }
        RtsUtil.writeUTF(this.fullClassName, objectOutput);
        objectOutput.writeBoolean(this.iscobolErrorFile != null);
        if (this.iscobolErrorFile != null) {
            this.iscobolErrorFile.writeExternal(objectOutput);
        }
        objectOutput.writeBoolean(this.iscobolListingFile != null);
        if (this.iscobolListingFile != null) {
            this.iscobolListingFile.writeExternal(objectOutput);
        }
        objectOutput.writeInt(this.javaFiles.size());
        for (Object e2 : this.javaFiles) {
            ((RemoteFile)e2).writeExternal(objectOutput);
        }
        objectOutput.writeBoolean(this.listingFile != null);
        if (this.listingFile != null) {
            this.listingFile.writeExternal(objectOutput);
        }
        RtsUtil.writeUTF(this.sourceFileName, objectOutput);
        objectOutput.writeBoolean(this.translatedFile != null);
        if (this.translatedFile != null) {
            this.translatedFile.writeExternal(objectOutput);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2;
        this.bridgeFiles.clear();
        int n3 = objectInput.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            RemoteBridgeFile remoteBridgeFile = new RemoteBridgeFile();
            remoteBridgeFile.readExternal(objectInput);
            this.bridgeFiles.addElement(remoteBridgeFile);
        }
        n3 = objectInput.readInt();
        if (n3 > 0) {
            this.classFiles = new RemoteFile[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.classFiles[n2] = new RemoteFile();
                this.classFiles[n2].readExternal(objectInput);
            }
        }
        if ((n3 = objectInput.readInt()) > 0) {
            this.copyFileNames = new Vector();
            for (n2 = 0; n2 < n3; ++n2) {
                this.copyFileNames.addElement(new String[]{RtsUtil.readUTF(objectInput), RtsUtil.readUTF(objectInput), RtsUtil.readUTF(objectInput)});
            }
        }
        if ((n2 = (int)(objectInput.readBoolean() ? 1 : 0)) != 0) {
            this.errorFile = new RemoteFile();
            this.errorFile.readExternal(objectInput);
        }
        if ((n2 = (int)(objectInput.readBoolean() ? 1 : 0)) != 0) {
            this.errors = new RemoteErrors();
            this.errors.readExternal(objectInput);
        }
        this.fullClassName = RtsUtil.readUTF(objectInput);
        n2 = objectInput.readBoolean() ? 1 : 0;
        if (n2 != 0) {
            this.iscobolErrorFile = new RemoteFile();
            this.iscobolErrorFile.readExternal(objectInput);
        }
        if ((n2 = (int)(objectInput.readBoolean() ? 1 : 0)) != 0) {
            this.iscobolListingFile = new RemoteFile();
            this.iscobolListingFile.readExternal(objectInput);
        }
        this.javaFiles.clear();
        n3 = objectInput.readInt();
        for (int i2 = 0; i2 < n3; ++i2) {
            RemoteFile remoteFile = new RemoteFile();
            remoteFile.readExternal(objectInput);
            this.javaFiles.addElement(remoteFile);
        }
        n2 = objectInput.readBoolean() ? 1 : 0;
        if (n2 != 0) {
            this.listingFile = new RemoteFile();
            this.listingFile.readExternal(objectInput);
        }
        this.sourceFileName = RtsUtil.readUTF(objectInput);
        n2 = objectInput.readBoolean() ? 1 : 0;
        if (n2 != 0) {
            this.translatedFile = new RemoteFile();
            this.translatedFile.readExternal(objectInput);
        }
    }
}

