/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.interfaces.compiler.remote.IRemoteError;
import com.iscobol.rts.RtsUtil;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoteError
implements IRemoteError,
Externalizable {
    private static final long serialVersionUID = 1L;
    private int errorNumber;
    private int errorType;
    private int lineNumber;
    private int offset;
    private String message;
    private String filename;
    private String pathFilename;
    private String other;

    public RemoteError() {
    }

    public RemoteError(int n2, int n3, int n4, int n5, String string, String string2, String string3) {
        this.errorNumber = n2;
        this.errorType = n3;
        this.lineNumber = n4;
        this.offset = n5;
        this.message = string2;
        File file = new File(string);
        this.filename = file.getName();
        this.pathFilename = file.getPath().replace('\\', '/');
        this.other = string3;
    }

    @Override
    public int getErrorNumber() {
        return this.errorNumber;
    }

    @Override
    public int getErrorType() {
        return this.errorType;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getPathFilename() {
        return this.pathFilename;
    }

    @Override
    public String getOther() {
        return this.other;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return this.message;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.errorNumber);
        objectOutput.writeInt(this.errorType);
        RtsUtil.writeUTF(this.filename, objectOutput);
        objectOutput.writeInt(this.lineNumber);
        RtsUtil.writeUTF(this.message, objectOutput);
        objectOutput.writeInt(this.offset);
        RtsUtil.writeUTF(this.other, objectOutput);
        RtsUtil.writeUTF(this.pathFilename, objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.errorNumber = objectInput.readInt();
        this.errorType = objectInput.readInt();
        this.filename = RtsUtil.readUTF(objectInput);
        this.lineNumber = objectInput.readInt();
        this.message = RtsUtil.readUTF(objectInput);
        this.offset = objectInput.readInt();
        this.other = RtsUtil.readUTF(objectInput);
        this.pathFilename = RtsUtil.readUTF(objectInput);
    }
}

