/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.compiler.Errors;
import com.iscobol.compiler.remote.RemoteError;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoteErrors
extends Errors
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private boolean printErrorMessage;
    private transient File outDir;

    public RemoteErrors() {
    }

    public RemoteErrors(File file, boolean bl) {
        this.printErrorMessage = bl;
        this.outDir = file;
    }

    @Override
    protected void addMessage(int n2, int n3, int n4, int n5, String string, String string2, String string3) {
        int n6;
        if (this.printErrorMessage) {
            System.err.println(string);
        }
        if (this.outDir != null) {
            File file;
            File file2 = new File(string3);
            StringBuffer stringBuffer = new StringBuffer(file2.getName());
            for (file = file2.getParentFile(); file != null && !file.equals(this.outDir); file = file.getParentFile()) {
                stringBuffer.insert(0, file.getName() + "/");
            }
            if (file != null) {
                string3 = stringBuffer.toString();
            }
        }
        if ((n6 = string.indexOf("; file = ")) >= 0) {
            string = string.substring(0, n6);
        }
        this.allMessages.addElement(new RemoteError(n2, n3, n4, n5, string3, string, string2));
    }

    @Override
    public boolean printEndMessage() {
        if (this.printErrorMessage) {
            int n2 = this.getUnitErrorCount(1);
            int n3 = this.getUnitErrorCount(2);
            int n4 = this.getUnitErrorCount(3);
            int n5 = this.getUnitErrorCount(4);
            boolean bl = this.isVerbose();
            if (bl || n2 > 0 || n3 > 0 || n4 > 0 || n5 > 0) {
                System.err.println(errorDesc.get(new Integer(100000)));
                if (bl || n2 > 0) {
                    System.err.println(errorDesc.get(new Integer(100001)) + " - " + this.info);
                }
                if (bl || n3 > 0) {
                    System.err.println(errorDesc.get(new Integer(100002)) + " - " + this.warning);
                }
                if (bl || n4 > 0) {
                    System.err.println(errorDesc.get(new Integer(100003)) + " - " + this.rErrors);
                }
                if (bl || n5 > 0) {
                    System.err.println(errorDesc.get(new Integer(100004)) + " - " + this.sErrors);
                }
            }
        }
        return this.sErrors > 0;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.allMessages.size());
        for (Object e2 : this.allMessages) {
            ((RemoteError)e2).writeExternal(objectOutput);
        }
        objectOutput.writeInt(this.info);
        objectOutput.writeInt(this.warning);
        objectOutput.writeInt(this.rErrors);
        objectOutput.writeInt(this.sErrors);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.allMessages.clear();
        int n2 = objectInput.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            RemoteError remoteError = new RemoteError();
            remoteError.readExternal(objectInput);
            this.allMessages.addElement(remoteError);
        }
        this.info = objectInput.readInt();
        this.warning = objectInput.readInt();
        this.rErrors = objectInput.readInt();
        this.sErrors = objectInput.readInt();
    }
}

