/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.compiler.remote.PPFileOutput;
import com.iscobol.interfaces.compiler.ClassFileFinder;
import com.iscobol.interfaces.compiler.FileFinder;
import java.io.File;

public class RemoteFileFinder
implements ClassFileFinder,
FileFinder {
    private final File srcDir;
    private PPFileOutput compileUnit;

    public RemoteFileFinder(File file) {
        this.srcDir = file;
    }

    @Override
    public File findClassFile(String string) {
        return this._findFile(string, true);
    }

    @Override
    public File findFile(String string) {
        return this._findFile(string, false);
    }

    private File _findFile(String string, boolean bl) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            return file;
        }
        if (!file.isAbsolute()) {
            file = new File(this.srcDir.getAbsolutePath() + "/" + string);
            if (file.exists() && file.isFile()) {
                return file;
            }
            if (bl) {
                return null;
            }
        }
        if ((file = new File(this.srcDir.getAbsolutePath() + "/" + file.getName())).exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    public void setCompileUnit(PPFileOutput pPFileOutput) {
        this.compileUnit = pPFileOutput;
    }

    public PPFileOutput getCompileUnit() {
        return this.compileUnit;
    }

    public String getSourceDir() {
        return this.srcDir.getAbsolutePath();
    }
}

