/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.client;

import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.remote.InputData;
import com.iscobol.compiler.remote.OutputData;
import com.iscobol.compiler.remote.RemoteFile;
import com.iscobol.compiler.remote.client.Callback;
import com.iscobol.compiler.remote.server.IDERemoteCompilerHandler;
import com.iscobol.compiler.remote.server.RemoteCompilerHandler;
import com.iscobol.gui.client.IDEClientHandler;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.IOptionList;
import com.iscobol.interfaces.compiler.remote.IRemoteCompilerClientExtension;
import com.iscobol.interfaces.runtime.IIDEClientHelper;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rpc.dualrpc.client.NotConnectedException;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rts.RtsUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class Client
extends AbstractClientRpcHandler
implements IRemoteCompilerClientExtension,
IClientCallbackHandler,
IRpcWorkerFactory {
    private String hostName;
    private int portNumber;
    private boolean compileOnServer;
    private boolean createListingFile;
    private boolean createErrorFile;
    private boolean showMessagesOnSysErr;
    private OptionList optionList;
    private String[] sourceFiles;
    private String[] preprocessorNames;
    private OutputData output;
    private DualRpcClient rpcClient;
    private FileFinder fileFinder;
    private Set filesAlreadySent;
    private IDEClientHandler ideHandler;
    private String serverHandlerName = RemoteCompilerHandler.class.getName();

    public Client() {
    }

    public Client(String string, int n2) {
        this.setHostName(string);
        this.setPortNumber(n2);
    }

    @Override
    public OutputData getOutput() {
        return this.output;
    }

    @Override
    public void connect() throws UnknownHostException, IOException, GeneralSecurityException {
        this.rpcClient = new DualRpcClient(this.hostName, this.portNumber);
        this.rpcClient.setDefaultCallTimeoutInSeconds(0);
        RemoteRegistry.setClientCaller(new ClientCaller(this.rpcClient));
        RemoteRegistry.setSharedRegistry(new RemoteRegistry());
        this.rpcClient.registerClientSideHandler(this);
        this.rpcClient.setMessageSerializer(new IscobolMessageSerializer());
        this.rpcClient.setCallbackHandler(this);
        this.rpcClient.setRpcWorkerFactory(this);
        this.rpcClient.connect();
        this.filesAlreadySent = new HashSet();
    }

    private OutputData compile(InputData inputData) throws CallException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException("not connected");
        }
        Callback callback = new Callback();
        OutputData outputData = (OutputData)this.rpcClient.call(this.serverHandlerName, "compile", callback, inputData);
        return outputData;
    }

    @Override
    public boolean isConnected() {
        try {
            return this.rpcClient != null && this.rpcClient.getSession() != null;
        }
        catch (NotConnectedException notConnectedException) {
            return false;
        }
    }

    @Override
    public Thread getRpcWorkerThread(IRpcMessageDispatcher iRpcMessageDispatcher, Message message) {
        return new Worker(iRpcMessageDispatcher, message, RemoteRegistry.getSharedRegistry());
    }

    @Override
    public void disconnect() throws NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException("not connected");
        }
        this.rpcClient.getSession().closeSession();
        this.brokenConnection();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setHostName(String string) {
        this.hostName = string;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setPortNumber(int n2) {
        this.portNumber = n2;
    }

    @Override
    public boolean getCompileOnServer() {
        return this.compileOnServer;
    }

    @Override
    public void setCompileOnServer(boolean bl) {
        this.compileOnServer = bl;
    }

    @Override
    public boolean getCreateListingFile() {
        return this.createListingFile;
    }

    @Override
    public void setCreateListingFile(boolean bl) {
        this.createListingFile = bl;
    }

    @Override
    public boolean getCreateErrorFile() {
        return this.createErrorFile;
    }

    @Override
    public void setCreateErrorFile(boolean bl) {
        this.createErrorFile = bl;
    }

    @Override
    public String[] getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public void setSourceFiles(String[] stringArray) {
        this.sourceFiles = stringArray;
    }

    @Override
    public OptionList getOptionList() {
        return this.optionList;
    }

    @Override
    public void setOptionList(IOptionList iOptionList) {
        if (iOptionList != null && !(iOptionList instanceof OptionList)) {
            throw new IllegalArgumentException(iOptionList.toString());
        }
        this.optionList = (OptionList)iOptionList;
    }

    public void setOptionList(OptionList optionList) {
        this.optionList = optionList;
    }

    @Override
    public String[] getPreprocessorNames() {
        return this.preprocessorNames;
    }

    @Override
    public void setPreprocessorNames(String[] stringArray) {
        this.preprocessorNames = stringArray;
    }

    @Override
    public void brokenConnection() {
        this.rpcClient = null;
        this.filesAlreadySent = null;
    }

    @Override
    public void compile() throws Exception {
        Object object;
        if (this.sourceFiles == null || this.sourceFiles.length == 0) {
            throw new IllegalStateException("Missing source files");
        }
        if (this.preprocessorNames == null || this.preprocessorNames.length == 0) {
            throw new IllegalStateException("Missing preproc names");
        }
        if (this.portNumber <= 0) {
            throw new IllegalStateException("Invalid port number: " + this.portNumber);
        }
        if (this.hostName == null || this.hostName.length() == 0) {
            throw new IllegalStateException("Host name cannot be null" + this.hostName);
        }
        if (this.optionList == null) {
            throw new IllegalStateException("OptionList cannot be null");
        }
        InputData inputData = new InputData();
        inputData.setCompile(this.compileOnServer);
        inputData.setListing(this.createListingFile);
        inputData.setError(this.createErrorFile);
        inputData.setShowMessagesOnSysErr(this.showMessagesOnSysErr);
        inputData.setPreProcessorsNames(this.preprocessorNames);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        final RemoteFile[] remoteFileArray = this.optionList.getAllKeys();
        while (remoteFileArray.hasMoreElements()) {
            object = remoteFileArray.nextElement().toString();
            hashtable.put((String)object, this.optionList.getOption((String)object));
        }
        inputData.setCompileOptions(hashtable);
        remoteFileArray = new RemoteFile[this.sourceFiles.length];
        object = new ArrayList();
        for (int i2 = 0; i2 < this.sourceFiles.length; ++i2) {
            Closeable closeable;
            OptionList optionList = new OptionList(new String[]{this.sourceFiles[i2]});
            String string = this.optionList.getOption("-sp=");
            if (string == null || string.length() == 0) {
                string = ".";
            }
            final String[] stringArray = RtsUtil.getPathList(string);
            final int n2 = i2;
            FileFinder fileFinder = new FileFinder((ArrayList)object){
                final /* synthetic */ ArrayList val$copyBookList;
                {
                    this.val$copyBookList = arrayList;
                }

                @Override
                public File findFile(String string) {
                    File file = Client.this.fileFinder != null ? Client.this.fileFinder.findFile(string) : Client.findFile(string, stringArray);
                    boolean bl = false;
                    if (file != null && ((bl = string.equals(Client.this.sourceFiles[n2])) || !Client.this.filesAlreadySent.contains(file))) {
                        Client.this.filesAlreadySent.add(file);
                        String string2 = string;
                        try {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            byte[] byArray = new byte[fileInputStream.available()];
                            fileInputStream.read(byArray);
                            fileInputStream.close();
                            File file2 = new File(string2);
                            RemoteFile remoteFile = new RemoteFile(byArray, file2.isAbsolute() ? file2.getName() : file2.getPath().replace('\\', '/'));
                            if (bl) {
                                remoteFileArray[n2] = remoteFile;
                            } else {
                                this.val$copyBookList.add(remoteFile);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return file;
                }
            };
            fileFinder.findFile("SQLCA");
            PreProcessor preProcessor = new PreProcessor(this.sourceFiles[i2], null, optionList, new Errors(optionList.getOption("-xmsgfmt=")), fileFinder, null);
            if (remoteFileArray[i2] == null) {
                closeable = new FileInputStream(this.sourceFiles[i2]);
                byte[] byArray = new byte[((FileInputStream)closeable).available()];
                ((FileInputStream)closeable).read(byArray);
                File file = new File(this.sourceFiles[i2]);
                remoteFileArray[i2] = new RemoteFile(byArray, file.isAbsolute() ? file.getName() : file.getPath().replace('\\', '/'));
                ((FileInputStream)closeable).close();
            }
            closeable = new InputStreamReader(new ByteArrayInputStream(remoteFileArray[i2].getContent()));
            preProcessor.start((Reader)closeable, null, (byte)0, null, true);
            while (preProcessor.getLine(null) >= 0) {
            }
        }
        inputData.setInputFiles(remoteFileArray);
        RemoteFile[] remoteFileArray2 = new RemoteFile[((ArrayList)object).size()];
        ((ArrayList)object).toArray(remoteFileArray2);
        inputData.setCopyBooks(remoteFileArray2);
        this.output = this.compile(inputData);
    }

    @Override
    public FileFinder getFileFinder() {
        return this.fileFinder;
    }

    @Override
    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public static File findFile(String string, String[] stringArray) {
        File file = new File(string);
        if (file.isFile() && file.canRead()) {
            return file;
        }
        if (file.isAbsolute()) {
            return Client.findFile0(file.getName(), stringArray);
        }
        File file2 = Client.findFile0(string, stringArray);
        if (file2 != null) {
            return file2;
        }
        String string2 = file.getName();
        if (!string2.equals(string)) {
            return Client.findFile0(string2, stringArray);
        }
        return null;
    }

    private static File findFile0(String string, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2] + '/' + string;
            File file = new File(string2);
            if (!file.isFile() || !file.canRead()) continue;
            return file;
        }
        return null;
    }

    @Override
    public boolean getShowMessagesOnSysErr() {
        return this.showMessagesOnSysErr;
    }

    @Override
    public void setShowMessagesOnSysErr(boolean bl) {
        this.showMessagesOnSysErr = bl;
    }

    @Override
    public IIDEClientHelper getIDEHelper() {
        return this.ideHandler != null ? this.ideHandler.getHelper() : null;
    }

    @Override
    public void setIDEHelper(IIDEClientHelper iIDEClientHelper) {
        if (iIDEClientHelper != null) {
            if (this.ideHandler == null) {
                this.ideHandler = new IDEClientHandler();
                this.rpcClient.registerClientSideHandler(this.ideHandler);
            }
            this.ideHandler.setHelper(iIDEClientHelper);
            this.serverHandlerName = IDERemoteCompilerHandler.class.getName();
        }
    }
}

