/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.compiler.remote.FileData;
import com.iscobol.compiler.remote.XmlParseException;
import com.iscobol.compiler.remote.server.Environment;
import com.iscobol.compiler.remote.server.Option;
import com.iscobol.compiler.remote.server.OptionList;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.interfaces.compiler.remote.IRemotePreProcessor;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreProcessor
implements IRemotePreProcessor {
    private String name = "";
    private File executable;
    private Environment environment;
    private OptionList optionList;
    private String outExt = "cbl";
    private String listExt = "list";
    private String errExt = "err";

    PreProcessor(Element element) throws XmlParseException {
        this.name = element.getAttribute("name");
        String string = element.getAttribute("executable");
        if (string != null && string.length() > 0) {
            this.executable = new File(string);
            if (!this.executable.exists() || this.executable.isDirectory()) {
                throw new XmlParseException("Invalid executable name: '" + string + "'");
            }
        } else {
            throw new XmlParseException("Invalid executable name: '" + string + "'");
        }
        string = element.getAttribute("outputFileExt");
        if (string != null && string.length() > 0) {
            this.outExt = string;
        }
        if ((string = element.getAttribute("errorFileExt")) != null && string.length() > 0) {
            this.errExt = string;
        }
        if ((string = element.getAttribute("listFileExt")) != null && string.length() > 0) {
            this.listExt = string;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (node.getNodeType() == 1 && node.getNodeName().equals("environment")) {
                this.environment = new Environment((Element)node);
                continue;
            }
            if (node.getNodeType() != 1 || !node.getNodeName().equals("optionList")) continue;
            this.optionList = new OptionList((Element)node);
        }
    }

    @Override
    public String getOutputFileExtension() {
        return this.outExt;
    }

    @Override
    public String getListingFileExtension() {
        return this.listExt;
    }

    @Override
    public String getErrorFileExtension() {
        return this.errExt;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getExecutable() {
        return this.executable;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public OptionList getOptionList() {
        return this.optionList;
    }

    public void compile(FileData fileData, File file, File file2, File file3, File file4, int n2) throws IOException {
        String string = fileData.getInputFile();
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        final PrintWriter printWriter = new PrintWriter(stringWriter);
        final PrintWriter printWriter2 = new PrintWriter(stringWriter2);
        int n3 = -1;
        File file5 = new File(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.executable);
        Option[] optionArray = this.optionList != null ? this.optionList.getOptions() : new Option[]{};
        for (int i2 = 0; i2 < optionArray.length; ++i2) {
            if (optionArray[i2].getIf() != null && (!optionArray[i2].getIf().equals("listing") || !fileData.getListing()) && (!optionArray[i2].getIf().equals("error") || !fileData.getError())) continue;
            stringBuffer.append(' ').append(optionArray[i2].getValue());
        }
        String string2 = file5.getPath();
        int n4 = string2.lastIndexOf(46);
        if (n4 >= 0) {
            string2 = string2.substring(0, n4);
        }
        String string3 = file4.getAbsolutePath() + "/" + string2 + "." + this.outExt;
        String string4 = file2.getAbsolutePath() + "/" + string2 + "." + this.listExt;
        String string5 = file3.getAbsolutePath() + "/" + string2 + this.errExt;
        File file6 = new File(string3);
        if (file6.getParentFile() != null) {
            file6.getParentFile().mkdirs();
        }
        if ((file6 = new File(string5)).getParentFile() != null) {
            file6.getParentFile().mkdirs();
        }
        if ((file6 = new File(string4)).getParentFile() != null) {
            file6.getParentFile().mkdirs();
        }
        this.replace(stringBuffer, "${inputfile}", new File(string).getName());
        this.replace(stringBuffer, "${listfile}", string4);
        this.replace(stringBuffer, "${errorfile}", string5);
        this.replace(stringBuffer, "${outputfile}", string3);
        String[] stringArray = null;
        if (this.environment != null) {
            stringArray = this.environment.toStringArray();
        }
        String string6 = file.getAbsolutePath();
        if (file5.getParent() != null) {
            string6 = string6 + "/" + file5.getParent();
        }
        final Process process = Runtime.getRuntime().exec(stringBuffer.toString(), stringArray, new File(string6));
        new Thread(){

            @Override
            public void run() {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        printWriter.println(string);
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                try {
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        printWriter2.println(string);
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
        IServerCallbackHandler iServerCallbackHandler = new IServerCallbackHandler(){

            @Override
            public void brokenConnection() {
                process.destroy();
            }
        };
        RemoteCompiler.addServerCallbackHandler(n2, iServerCallbackHandler);
        try {
            n3 = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RemoteCompiler.removeServerCallbackHandler(n2, iServerCallbackHandler);
        fileData.setStdErr(stringWriter2.toString());
        fileData.setStdOut(stringWriter.toString());
        fileData.setExitCode(n3);
        if (n3 == 0) {
            fileData.setOutputFile(string3);
            fileData.setErrorFile(string5);
            fileData.setListingFile(string4);
        }
    }

    private void replace(StringBuffer stringBuffer, String string, String string2) {
        int n2;
        for (int i2 = 0; i2 < stringBuffer.length() && (n2 = stringBuffer.indexOf(string, i2)) >= 0; i2 += string2.length()) {
            stringBuffer.replace(n2, n2 + string.length(), string2);
        }
    }
}

