/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.StandardPhases;
import com.iscobol.compiler.phases.Phases;
import com.iscobol.compiler.phases.PhasesFactory;
import com.iscobol.compiler.remote.FileData;
import com.iscobol.compiler.remote.InputData;
import com.iscobol.compiler.remote.OutputData;
import com.iscobol.compiler.remote.PPFileOutput;
import com.iscobol.compiler.remote.PccRunnable;
import com.iscobol.compiler.remote.RemoteBridgeFile;
import com.iscobol.compiler.remote.RemoteErrors;
import com.iscobol.compiler.remote.RemoteFile;
import com.iscobol.compiler.remote.RemoteFileFinder;
import com.iscobol.compiler.remote.XmlParseException;
import com.iscobol.compiler.remote.server.PreProcessor;
import com.iscobol.compiler.remote.server.RemoteCompilerClassLoader;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.remote.IRemoteCompiler;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RemoteCompiler
implements IRemoteCompiler {
    static RemoteCompiler instance;
    private static Hashtable serverCallbackHandlers;
    private ArrayList preProcessors = new ArrayList();
    private int portNumber = 11999;
    private String hostName;
    private String outputFolder;
    private String deploymentFolder;
    private File outputFolderFile;
    private boolean cleanOutputFolderWhenExit = true;
    private PccRunnable ipcc;
    private boolean ide;

    public RemoteCompiler(Element element) throws XmlParseException {
        this(element, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RemoteCompiler(Element element, PccRunnable pccRunnable) throws XmlParseException {
        this.ipcc = pccRunnable;
        if (element != null) {
            Object object;
            String string;
            String string2 = element.getAttribute("hostName");
            if (string2 != null && string2.length() > 0) {
                this.hostName = string2;
            }
            try {
                this.portNumber = Integer.parseInt(element.getAttribute("portNumber"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.cleanOutputFolderWhenExit = Boolean.valueOf(element.getAttribute("cleanOutputFolderWhenExit"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputFolder = element.getAttribute("outputFolder");
            if (this.outputFolder != null && this.outputFolder.length() > 0) {
                this.outputFolderFile = new File(this.outputFolder);
                if (!this.outputFolderFile.exists()) throw new XmlParseException("Invalid output folder: '" + this.outputFolder + "'");
                if (!this.outputFolderFile.isDirectory()) {
                    throw new XmlParseException("Invalid output folder: '" + this.outputFolder + "'");
                }
            } else {
                this.outputFolderFile = new File(System.getProperty("java.io.tmpdir"));
            }
            this.outputFolderFile = new File(this.outputFolderFile.getAbsolutePath() + "/iscobol-remote-compiler-" + this.portNumber);
            if (!this.outputFolderFile.exists()) {
                this.outputFolderFile.mkdir();
            }
            if ((string = element.getAttribute("deploymentFolder")) != null && string.length() > 0) {
                this.deploymentFolder = string;
                object = new File(this.deploymentFolder);
                if (!((File)object).exists()) throw new XmlParseException("Invalid deployment folder: '" + this.deploymentFolder + "'");
                if (!((File)object).isDirectory()) {
                    throw new XmlParseException("Invalid deployment folder: '" + this.deploymentFolder + "'");
                }
            }
            object = element.getChildNodes();
            for (int i2 = 0; i2 < object.getLength(); ++i2) {
                Node node = object.item(i2);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("preProcessor")) continue;
                this.preProcessors.add(new PreProcessor((Element)node));
            }
            return;
        }
        this.cleanOutputFolderWhenExit = true;
        this.outputFolderFile = new File(System.getProperty("java.io.tmpdir"));
        if (this.outputFolderFile.exists()) return;
        this.outputFolderFile.mkdir();
    }

    public static void addServerCallbackHandler(int n2, IServerCallbackHandler iServerCallbackHandler) {
        Integer n3 = new Integer(n2);
        if (!serverCallbackHandlers.containsKey(n3)) {
            serverCallbackHandlers.put(n3, iServerCallbackHandler);
        }
    }

    public static void removeServerCallbackHandler(int n2, IServerCallbackHandler iServerCallbackHandler) {
        serverCallbackHandlers.remove(new Integer(n2));
    }

    public static void dispatchBrokenConnection(int n2) {
        IServerCallbackHandler iServerCallbackHandler = (IServerCallbackHandler)serverCallbackHandlers.get(new Integer(n2));
        if (iServerCallbackHandler != null) {
            iServerCallbackHandler.brokenConnection();
        }
    }

    public static RemoteCompiler getInstance() {
        if (instance == null) {
            RemoteCompiler.createNewInstance();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNewInstance() {
        Object object;
        boolean bl = Config.b("iscobol.as.ide", false);
        File file = new File(Config.a(".remotecompiler.conf", System.getProperty("user.home") + "/remoteCompiler.xml"));
        Element element = null;
        if (!bl || file.exists() && file.isFile() && file.canRead()) {
            DocumentBuilder documentBuilder;
            block31: {
                object = RtsUtil.newDocumentBuilderFactory();
                documentBuilder = null;
                try {
                    documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                    if (bl) break block31;
                    System.exit(-2);
                }
            }
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader(new FileInputStream(file));
                Document document = documentBuilder.parse(new InputSource(inputStreamReader));
                element = document.getDocumentElement();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File not found: " + file);
                if (!bl) {
                    System.exit(-3);
                }
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                if (!bl) {
                    System.exit(-4);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if (!bl) {
                    System.exit(-5);
                }
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        object = new PccRunnable(){

            @Override
            public Pcc run(String string, String string2, OptionList optionList, Phases phases, Errors errors, Reader reader, boolean bl, FileFinder fileFinder) throws ErrorInCompilationException {
                return Pcc.run(string, string2, optionList, phases, errors, reader, bl, fileFinder);
            }
        };
        try {
            instance = new RemoteCompiler(element, (PccRunnable)object);
        }
        catch (XmlParseException xmlParseException) {
            xmlParseException.printStackTrace();
            if (bl) {
                try {
                    instance = new RemoteCompiler(null, (PccRunnable)object);
                }
                catch (XmlParseException xmlParseException2) {}
            }
            System.exit(-6);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (RemoteCompiler.getInstance() != null) {
                RemoteCompiler.getInstance().deleteOutputFolder();
            }
        }));
    }

    @Override
    public boolean getCleanOutputFolderWhenExit() {
        return this.cleanOutputFolderWhenExit;
    }

    @Override
    public String getDeploymentFolder() {
        return this.deploymentFolder;
    }

    @Override
    public String getOutputFolder() {
        return this.outputFolder;
    }

    public PreProcessor[] getPreProcessors() {
        PreProcessor[] preProcessorArray = new PreProcessor[this.preProcessors.size()];
        this.preProcessors.toArray(preProcessorArray);
        return preProcessorArray;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public PreProcessor getPreProcessor(String string) {
        PreProcessor preProcessor = null;
        for (int i2 = 0; i2 < this.preProcessors.size() && preProcessor == null; ++i2) {
            PreProcessor preProcessor2 = (PreProcessor)this.preProcessors.get(i2);
            if (!preProcessor2.getName().equals(string)) continue;
            preProcessor = preProcessor2;
        }
        return preProcessor;
    }

    static void deleteFile(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                RemoteCompiler.deleteFile(fileArray[i2]);
            }
        }
        file.delete();
    }

    public void deleteOutputFolder() {
        if (this.outputFolderFile != null && this.cleanOutputFolderWhenExit) {
            RemoteCompiler.deleteFile(this.outputFolderFile);
        }
    }

    static File genFile(RemoteFile remoteFile, File file) throws IOException {
        File file2 = new File(remoteFile.getPath());
        String string = file.getAbsolutePath() + "/";
        if (file2.isAbsolute()) {
            string = string + file2.getName();
        } else if (file2.getParentFile() != null) {
            string = string + "/" + file2.getParentFile().getPath();
        }
        File file3 = new File(string);
        file3.mkdirs();
        File file4 = new File(string + "/" + file2.getName());
        FileOutputStream fileOutputStream = new FileOutputStream(file4);
        fileOutputStream.write(remoteFile.getContent());
        fileOutputStream.close();
        return file4;
    }

    public static RemoteFile createRemoteFile(String string, String string2) throws IOException {
        return RemoteCompiler.createRemoteFile(string, string2, -1);
    }

    public static RemoteFile createRemoteFile(String string, String string2, int n2) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return n2 >= 0 ? new RemoteBridgeFile(byArray, string2, n2) : new RemoteFile(byArray, string2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(InputData inputData, OutputData outputData, int n2) throws IOException, ErrorInCompilationException {
        Object object;
        Object object2;
        Hashtable hashtable;
        File file;
        File file2;
        File file3;
        File file4 = new File(this.outputFolderFile.getAbsolutePath() + "/" + n2);
        if (!file4.exists()) {
            file4.mkdir();
        }
        if (!(file3 = new File(file4.getAbsolutePath() + "/" + "src")).exists()) {
            file3.mkdir();
        }
        RemoteFile[] remoteFileArray = inputData.getCopyBooks();
        for (int i2 = 0; i2 < remoteFileArray.length; ++i2) {
            try {
                RemoteCompiler.genFile(remoteFileArray[i2], file3);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        RemoteFile[] remoteFileArray2 = inputData.getInputFiles();
        String[] stringArray = new String[remoteFileArray2.length];
        for (int i3 = 0; i3 < remoteFileArray2.length; ++i3) {
            try {
                stringArray[i3] = RemoteCompiler.genFile(remoteFileArray2[i3], file3).getAbsolutePath();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        File file5 = new File(file4.getAbsolutePath() + "/" + "lst");
        if (!file5.exists()) {
            file5.mkdir();
        }
        if (!(file2 = new File(file4.getAbsolutePath() + "/" + "err")).exists()) {
            file2.mkdir();
        }
        if (!(file = new File(file4.getAbsolutePath() + "/" + "trs")).exists()) {
            file.mkdir();
        }
        String string = file.getAbsolutePath();
        File file6 = new File(file4.getAbsolutePath() + "/" + "cls");
        if (!file6.exists()) {
            file6.mkdir();
        }
        OptionList optionList = null;
        String string2 = ".";
        if (inputData.getCompile() && (hashtable = inputData.getCompileOptions()) != null && hashtable.size() > 0) {
            object2 = new ArrayList();
            String[] stringArray2 = hashtable.keySet().iterator();
            while (stringArray2.hasNext()) {
                object = stringArray2.next().toString();
                if (((String)object).equals("-sp=")) continue;
                if (((String)object).equals("-od=")) {
                    string2 = (String)hashtable.get(object);
                    continue;
                }
                if (((String)object).equals("-ze")) continue;
                if (((String)object).equals("-lf") || ((String)object).equals("-lo=")) {
                    ((ArrayList)object2).add("-lf");
                    continue;
                }
                if (((String)object).equals("-ef") || ((String)object).equals("-eo=")) {
                    ((ArrayList)object2).add("-ef");
                    continue;
                }
                ((ArrayList)object2).add((String)object + hashtable.get(object));
            }
            ((ArrayList)object2).add("-sp=" + file3.getAbsolutePath());
            ((ArrayList)object2).add("-od=" + file6.getAbsolutePath() + File.separator);
            stringArray2 = new String[((ArrayList)object2).size()];
            ((ArrayList)object2).toArray(stringArray2);
            optionList = new OptionList(stringArray2);
        } else {
            optionList = new OptionList(new String[0]);
        }
        object2 = inputData.getPreProcessorsNames();
        if (((String[])object2).length > 0) {
            object = new PreProcessor[((String[])object2).length];
            for (int i4 = 0; i4 < ((PreProcessor[])object).length; ++i4) {
                if (object2[i4].equalsIgnoreCase("ALL")) {
                    object = new PreProcessor[this.preProcessors.size()];
                    this.preProcessors.toArray((T[])object);
                    break;
                }
                if (((String)object2[i4]).equalsIgnoreCase("NONE")) {
                    object = new PreProcessor[]{};
                    inputData.setCompile(true);
                    break;
                }
                object[i4] = this.getPreProcessor((String)object2[i4]);
                if (object[i4] != null) continue;
                outputData.setStdErr("PreProcessor not found: '" + (String)object2[i4] + "'");
                outputData.setExitCode(-1);
                return;
            }
        } else {
            object = new PreProcessor[this.preProcessors.size()];
            this.preProcessors.toArray((T[])object);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        ArrayList<PPFileOutput> arrayList = new ArrayList<PPFileOutput>();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        RemoteFileFinder remoteFileFinder = new RemoteFileFinder(file3);
        StandardPhases standardPhases = (StandardPhases)PhasesFactory.create(optionList);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        RemoteCompilerClassLoader remoteCompilerClassLoader = RemoteCompilerClassLoader.getInstance();
        if (remoteCompilerClassLoader != null) {
            Thread.currentThread().setContextClassLoader(remoteCompilerClassLoader);
        }
        try {
            Object object3;
            String string3;
            Object object4;
            File[] fileArray;
            Object object5;
            Object object6;
            Object object7;
            Serializable serializable;
            Object object8;
            Object object9;
            for (int i5 = 0; i5 < stringArray.length; ++i5) {
                File file7;
                Object object10;
                Object object11;
                object9 = remoteFileArray2[i5].getPath();
                object8 = file3;
                serializable = new PPFileOutput(remoteFileArray2[i5].getPath());
                remoteFileFinder.setCompileUnit((PPFileOutput)serializable);
                arrayList.add((PPFileOutput)serializable);
                object7 = null;
                for (int i6 = 0; i6 < ((Object)object).length; ++i6) {
                    object11 = new FileData();
                    ((FileData)object11).setInputFile((String)object9);
                    boolean bl = i6 == ((Object)object).length - 1;
                    ((FileData)object11).setListing(inputData.getListing() && bl);
                    ((FileData)object11).setError(inputData.getError() && bl);
                    ((PreProcessor)object[i6]).compile((FileData)object11, (File)object8, file5, file2, file, n2);
                    stringBuffer.append(((FileData)object11).getStdOut());
                    stringBuffer2.append(((FileData)object11).getStdErr());
                    int n3 = ((FileData)object11).getExitCode();
                    if (n3 == 0) {
                        if (bl) {
                            object7 = new File(((FileData)object11).getOutputFile()).getAbsolutePath();
                            ((PPFileOutput)serializable).setTranslatedFile(RemoteCompiler.createRemoteFile(((FileData)object11).getOutputFile(), ((FileData)object11).getOutputFile().substring(string.length() + 1)));
                            if (inputData.getListing() && ((FileData)object11).getListingFile() != null) {
                                ((PPFileOutput)serializable).setListingFile(RemoteCompiler.createRemoteFile(((FileData)object11).getListingFile(), ((FileData)object11).getListingFile().substring(file5.getAbsolutePath().length() + 1)));
                            }
                            if (!inputData.getError() || ((FileData)object11).getErrorFile() == null) continue;
                            ((PPFileOutput)serializable).setErrorFile(RemoteCompiler.createRemoteFile(((FileData)object11).getErrorFile(), ((FileData)object11).getErrorFile().substring(file2.getAbsolutePath().length() + 1)));
                            continue;
                        }
                        object9 = ((FileData)object11).getOutputFile().substring(string.length() + 1);
                        object8 = file;
                        continue;
                    }
                    outputData.setExitCode(n3);
                    break;
                }
                if (object7 == null) {
                    object7 = stringArray[i5];
                }
                if (!inputData.getCompile() || this.ipcc == null) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object11 = new PrintStream(byteArrayOutputStream);
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream2);
                object6 = System.out;
                object5 = System.err;
                System.setOut((PrintStream)object11);
                System.setErr(printStream);
                fileArray = new RemoteErrors(file4, inputData.getShowMessagesOnSysErr());
                fileArray.setVerbose(optionList.getOption("-verbose") != null);
                object4 = null;
                try {
                    object4 = this.ipcc.run((String)object7, file6.getAbsolutePath() + File.separator, (OptionList)optionList.clone(), standardPhases, (Errors)fileArray, null, true, remoteFileFinder);
                }
                catch (ErrorInCompilationException errorInCompilationException) {
                    object4 = errorInCompilationException.pcc;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object4 != null) {
                    object10 = ((Pcc)object4).getEasyDBProgramsNames();
                    string3 = file6.getAbsolutePath() + File.separator;
                    object3 = object10;
                    int n4 = ((String[])object3).length;
                    for (int i7 = 0; i7 < n4; ++i7) {
                        String string4 = object3[i7];
                        ((PPFileOutput)serializable).addBridgeFile((RemoteBridgeFile)RemoteCompiler.createRemoteFile(string4, string4.substring(string.length() + 1), 1));
                        optionList.restoreProperties();
                        OptionList optionList2 = (OptionList)optionList.clone();
                        optionList2.addOption("#ef");
                        optionList2.addOption("#st");
                        optionList2.addOption("#eo=");
                        optionList2.addOption("#lf");
                        optionList2.addOption("#lo=");
                        optionList2.addOption("#cp");
                        Pcc pcc = null;
                        try {
                            pcc = this.ipcc.run(string4, string3, optionList2, standardPhases, (Errors)fileArray, null, true, remoteFileFinder);
                            if (pcc == null || pcc.getClassName() == null) continue;
                            hashMap.put(pcc.getProgName(), serializable);
                            continue;
                        }
                        catch (ErrorInCompilationException errorInCompilationException) {
                            pcc = errorInCompilationException.pcc;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                System.setOut((PrintStream)object6);
                System.setErr((PrintStream)object5);
                stringBuffer.append(byteArrayOutputStream.toString());
                stringBuffer2.append(byteArrayOutputStream2.toString());
                ((PrintStream)object11).close();
                printStream.close();
                if (object4 == null || ((Pcc)object4).getClassName() == null) continue;
                hashMap.put(((Pcc)object4).getProgName(), serializable);
                ((PPFileOutput)serializable).setErrors((RemoteErrors)fileArray);
                ((PPFileOutput)serializable).setCopyFileNames(((Pcc)object4).getCopyFilesNames());
                ((PPFileOutput)serializable).setFullClassName(((Pcc)object4).getFullClassName());
                object10 = object7;
                int n5 = ((String)object10).lastIndexOf(46);
                if (n5 >= 0) {
                    object10 = ((String)object10).substring(0, n5);
                }
                if (((File)(object3 = new File((String)object10 + ".list"))).exists()) {
                    String string5 = ((File)object3).getAbsolutePath();
                    ((PPFileOutput)serializable).setIscobolListingFile(RemoteCompiler.createRemoteFile(string5, string5.substring(string.length() + 1)));
                    ((File)object3).delete();
                }
                if (!(file7 = new File((String)object10 + ".err")).exists()) continue;
                String string6 = file7.getAbsolutePath();
                ((PPFileOutput)serializable).setIscobolErrorFile(RemoteCompiler.createRemoteFile(string6, string6.substring(string.length() + 1)));
                file7.delete();
            }
            if (optionList.getOption("-jj") == null || optionList.getOption("-jc") != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object9 = new PrintStream(byteArrayOutputStream);
                object8 = System.err;
                System.setErr((PrintStream)object9);
                serializable = new Errors(optionList.getOption("-xmsgfmt="));
                ((Errors)serializable).setVerbose(optionList.getOption("-verbose") != null);
                Pcc.generateBinaryCode(optionList, (Errors)serializable, standardPhases, file4.getPath());
                ((PrintStream)object9).close();
                stringBuffer2.append(byteArrayOutputStream.toString());
                System.setErr((PrintStream)object8);
                object7 = standardPhases.getPccToBeCompiled();
                for (Object object11 : object7.values()) {
                    String string7 = (String)object11.get("programName");
                    PPFileOutput pPFileOutput = (PPFileOutput)hashMap.get(string7);
                    object6 = new File(string7);
                    if (((File)object6).exists()) {
                        object5 = ((File)object6).getAbsolutePath();
                        fileArray = ((String)object5).substring(file6.getAbsolutePath().length() + 1);
                        if (this.ide) {
                            RemoteCompiler.copyToDeploymentFolder(string2, (File)object6, (String)fileArray);
                        } else {
                            pPFileOutput.addJavaFile(RemoteCompiler.createRemoteFile((String)object5, (String)fileArray));
                            if (this.deploymentFolder != null) {
                                this.copyToDeploymentFolder((File)object6, (String)fileArray);
                            }
                        }
                        ((File)object6).delete();
                    }
                    object5 = new File(string7.substring(0, string7.length() - 5)).getName();
                    fileArray = file6.listFiles(new FilenameFilter((String)object5){
                        final /* synthetic */ String val$classFileName;
                        {
                            this.val$classFileName = string;
                        }

                        @Override
                        public boolean accept(File file, String string) {
                            return string.endsWith(".class") && string.startsWith(this.val$classFileName);
                        }
                    });
                    object4 = new RemoteFile[fileArray.length];
                    for (int i8 = 0; i8 < fileArray.length; ++i8) {
                        string3 = fileArray[i8].getAbsolutePath();
                        object3 = string3.substring(file6.getAbsolutePath().length() + 1);
                        object4[i8] = RemoteCompiler.createRemoteFile(string3, (String)object3);
                        if (this.ide) {
                            RemoteCompiler.copyToDeploymentFolder(string2, fileArray[i8], (String)object3);
                        } else if (this.deploymentFolder != null) {
                            this.copyToDeploymentFolder(fileArray[i8], (String)object3);
                        }
                        fileArray[i8].delete();
                    }
                    if (this.ide) continue;
                    pPFileOutput.setClassFiles((RemoteFile[])object4);
                }
            }
            PPFileOutput[] pPFileOutputArray = arrayList.toArray(new PPFileOutput[arrayList.size()]);
            outputData.setPreProcessorFilesOutput(pPFileOutputArray);
            outputData.setStdErr(stringBuffer2.toString());
            outputData.setStdOut(stringBuffer.toString());
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private void copyToDeploymentFolder(File file, String string) throws IOException {
        RemoteCompiler.copyToDeploymentFolder(this.deploymentFolder, file, string);
    }

    private static void copyToDeploymentFolder(String string, File file, String string2) throws IOException {
        String string3 = string;
        int n2 = string2.lastIndexOf(File.separator);
        if (n2 >= 0 && (string2 = string2.substring(0, n2)) != null && string2.length() > 0) {
            string3 = string3 + File.separator + string2;
        }
        new File(string3).mkdirs();
        string3 = string3 + File.separator + file.getName();
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileOutputStream.write(byArray);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public boolean isIde() {
        return this.ide;
    }

    public void setIde(boolean bl) {
        this.ide = bl;
    }

    static {
        serverCallbackHandlers = new Hashtable();
    }
}

