/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.as.Login;
import com.iscobol.as.UserData;
import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.remote.InputData;
import com.iscobol.compiler.remote.OutputData;
import com.iscobol.compiler.remote.client.ICallback;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rts.Config;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class RemoteCompilerHandler
extends AbstractServerRpcHandler
implements IServerCallbackHandler {
    final String AUTH_FILE;
    static final int AUTH_NONE = 0;
    static final int AUTH_ADMINONLY = 1;
    static final int AUTH_ALL = 2;

    public RemoteCompilerHandler(DualRpcServerDispatcher dualRpcServerDispatcher) {
        super(dualRpcServerDispatcher);
        Config.c();
        this.AUTH_FILE = Config.a(".as.password_file", "password.properties");
        this.getDispatcher().setCallbackHandler(this);
        ServerCaller serverCaller = new ServerCaller(dualRpcServerDispatcher, new RemoteRegistry());
        int n2 = RemoteRegistry.setCaller(serverCaller);
        this.getDispatcher().getSession().setSessionId(n2);
    }

    @Override
    public void brokenConnection() {
        Session session = this.getDispatcher().getSession();
        RemoteCompiler.dispatchBrokenConnection(session.getSessionId());
    }

    protected boolean checkLogin(ICallback iCallback) {
        UserData userData = null;
        int n2 = Config.a(".as.authentication", 1);
        if (n2 == 2) {
            Login login = new Login();
            try {
                userData = login.login(this.AUTH_FILE);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            if (userData != null) {
                if (userData.getId() != 0) {
                    RemoteCompilerHandler.exit(iCallback, "Operation not permitted");
                    return false;
                }
            } else {
                RemoteCompilerHandler.exit(iCallback, "login failed");
                return false;
            }
        }
        return true;
    }

    public OutputData compile(ICallback iCallback, InputData inputData) throws IOException {
        OutputData outputData = new OutputData();
        if (!this.checkLogin(iCallback)) {
            outputData.setStdErr("login failed");
            outputData.setExitCode(11);
            return outputData;
        }
        RemoteCompiler remoteCompiler = RemoteCompiler.getInstance();
        if (remoteCompiler == null) {
            RemoteCompilerHandler.exit(iCallback, "RemoteCompiler not started");
            return outputData;
        }
        try {
            remoteCompiler.compile(inputData, outputData, this.getDispatcher().getSession().getSessionId());
        }
        catch (ErrorInCompilationException errorInCompilationException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            errorInCompilationException.printStackTrace(printWriter);
            System.err.println(errorInCompilationException.getMessage());
        }
        return outputData;
    }

    private static void exit(ICallback iCallback, String string) {
        try {
            iCallback.exit(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

