/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote.server;

import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.compiler.remote.server.RemoteCompilerHandler;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.common.RpcWorker;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;

public class Server {
    public static void main(String[] stringArray) {
        Config.c();
        IscobolSystem.setAS(true);
        if (RemoteCompiler.instance != null) {
            System.err.println("RemoteCompiler already started");
            System.exit(-1);
        }
        if (RemoteCompiler.getInstance() != null) {
            try {
                Server.start(RemoteCompiler.getInstance().getHostName(), RemoteCompiler.getInstance().getPortNumber());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void start(String string, int n2) throws IOException {
        System.out.println("Remote Compiler started and listening on port " + n2);
        try {
            DualRpcServer dualRpcServer = new DualRpcServer(string, n2, false, "RemoteCompiler");
            dualRpcServer.registerServerSideHandlerClassname(RemoteCompilerHandler.class.getName());
            dualRpcServer.setRpcWorkerFactory(new IRpcWorkerFactory(){

                @Override
                public Thread getRpcWorkerThread(IRpcMessageDispatcher iRpcMessageDispatcher, Message message) {
                    return new RpcWorker(iRpcMessageDispatcher, message);
                }
            });
            dualRpcServer.setMessageSerializer(new IscobolMessageSerializer());
            dualRpcServer.listen();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

