/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.CoverageCopyStatement;
import com.iscobol.coverage.CoverageElement;
import com.iscobol.coverage.CoverageParagraph;
import com.iscobol.coverage.CoverageProgram;
import com.iscobol.coverage.CoverageSession;
import com.iscobol.coverage.CoverageStatement;
import com.iscobol.coverage.Transformer;
import com.iscobol.profiler.Profiler;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICoverage;
import com.iscobol.rts.ICoverageClassLoader;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolClass;
import com.iscobol.rts.IscobolModule;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.SMAPReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.IRuntime;
import org.jacoco.core.runtime.LoggerRuntime;
import org.jacoco.core.runtime.RuntimeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Coverage
implements ICoverage {
    private static Coverage sharedInstance;
    private static final String EP_PREFIX = "_entry_Point$";
    private static final NumberFormat percFormat;
    private static final NumberFormat intFormat;
    private static final DateFormat dateFormat;
    private static final Calendar calendar;
    private static final String[] resources;
    private static final Class iscobolCall;
    private static final Class iscobolClass;
    private static final Class iscobolModule;
    private static final Class iscobolDebugger;
    private static final Set<String> invalidPackageNames;
    private IRuntime runtime;
    private RuntimeData runtimeData;
    private Instrumenter instrumenter;
    private CoverageSession session;
    private File[] classPaths;
    private File[] sourcePaths;
    private File htmlDir;
    private File xmlFile;
    private File[] xmlAppend;
    private Pattern[] includes;
    private Pattern[] excludes;
    private String sessionTitle;
    private Map<String, ClassLocation> classLocations = new HashMap<String, ClassLocation>();
    private String loadingClassName;
    private boolean coverage;
    private boolean profile;
    private Profiler profiler;
    private Transformer transformer;
    private List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private Map<String, byte[]> resourcesStream;

    public Coverage(String string, int n2) {
        this.coverage = Coverage.isCoverage(n2);
        this.profile = Coverage.isProfile(n2);
        if (!this.coverage && !this.profile) {
            throw new IllegalArgumentException("" + n2);
        }
        this.sessionTitle = string;
    }

    public Coverage(String string, File file, File file2, String string2, String string3, String string4, String string5, String string6) {
        this.coverage = true;
        this.sessionTitle = string;
        if (this.sessionTitle == null) {
            this.sessionTitle = "coverage";
        }
        this.htmlDir = file;
        this.xmlFile = file2;
        if (string2 != null) {
            this.setIncludes(string2);
        }
        if (string3 != null) {
            this.setExcludes(string3);
        }
        if (string4 != null) {
            this.setAppend(string4);
        }
        if (string5 != null) {
            this.setSourcefiles(string5);
        }
        if (string6 != null) {
            this.setClassfiles(string6);
        }
        this.runtime = new LoggerRuntime();
        this.instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)this.runtime);
    }

    @Override
    public void startSession() {
        try {
            if (this.coverage) {
                this.startCoverageSession();
            }
            if (this.profile) {
                this.startProfileSession();
            }
            this.intStartSession();
        }
        catch (Throwable throwable) {
            throw new IscobolRuntimeException(38, throwable);
        }
    }

    private void startProfileSession() throws Exception {
        this.startProfileSession(Config.a("iscobol.profiler.includes", null), Config.a("iscobol.profiler.excludes", null), Config.a("iscobol.profiler.html", null), Config.a("iscobol.profiler.xml", null));
    }

    private void startProfileSession(String string, String string2, String string3, String string4) throws Exception {
        File file = null;
        if (string3 != null) {
            file = new File(string3);
        }
        File file2 = null;
        if (string4 != null) {
            file2 = new File(string4);
        }
        if (string3 == null && string4 == null) {
            file = new File("./hprofHtmlReport");
        }
        this.profiler = Profiler.getSharedInstance(file, file2, null, string, string2);
    }

    private void startCoverageSession() throws Exception {
        int n2;
        StringTokenizer stringTokenizer;
        String string;
        this.sessionTitle = string = Config.a("iscobol.coverage.sessionname", this.sessionTitle);
        string = Config.a("iscobol.coverage.classfiles", null);
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "\n" + File.pathSeparatorChar);
            this.classPaths = new File[stringTokenizer.countTokens()];
            n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.classPaths[n2++] = new File(stringTokenizer.nextToken());
            }
        }
        if ((string = Config.a("iscobol.coverage.sourcefiles", ".")) != null) {
            stringTokenizer = new StringTokenizer(string, "\n" + File.pathSeparatorChar);
            this.sourcePaths = new File[stringTokenizer.countTokens()];
            n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.sourcePaths[n2++] = new File(stringTokenizer.nextToken());
            }
        }
        if ((string = Config.a("iscobol.coverage.html", null)) != null) {
            this.htmlDir = new File(string);
        }
        if ((string = Config.a("iscobol.coverage.xml", null)) != null) {
            this.xmlFile = new File(string);
        }
        this.checkOutputs();
        string = Config.a("iscobol.coverage.append", null);
        if (string != null) {
            this.setAppend(string);
        }
        if ((string = Config.a("iscobol.coverage.analysis.includes", null)) != null) {
            this.setIncludes(string);
        }
        if ((string = Config.a("iscobol.coverage.analysis.excludes", null)) != null) {
            this.setExcludes(string);
        }
    }

    private void setIncludes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.includes = new Pattern[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.includes[n2++] = Pattern.compile(stringTokenizer.nextToken());
        }
    }

    private void setExcludes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.excludes = new Pattern[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.excludes[n2++] = Pattern.compile(stringTokenizer.nextToken());
        }
    }

    private void setAppend(String string) {
        if ("0".equals(string)) {
            this.xmlAppend = null;
        } else if ("1".equals(string)) {
            this.xmlAppend = this.xmlFile != null ? new File[]{this.xmlFile} : null;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.xmlAppend = new File[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.xmlAppend[n2++] = new File(stringTokenizer.nextToken());
            }
        }
    }

    private void setClassfiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + File.pathSeparatorChar);
        this.classPaths = new File[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.classPaths[n2++] = new File(stringTokenizer.nextToken());
        }
    }

    private void setSourcefiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + File.pathSeparatorChar);
        this.sourcePaths = new File[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.sourcePaths[n2++] = new File(stringTokenizer.nextToken());
        }
    }

    private void checkOutputs() {
        if (this.htmlDir == null && this.xmlFile == null) {
            this.htmlDir = new File("./htmlReport");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(boolean bl) throws Exception {
        this.session = new CoverageSession();
        this.session.name.timestamp = System.currentTimeMillis();
        this.session.name.name = this.sessionTitle;
        if (bl) {
            Coverage coverage = this;
            synchronized (coverage) {
                for (ClassLocation classLocation : this.classLocations.values()) {
                    for (ClassDef classDef : classLocation.originals.values()) {
                        classDef.program = null;
                    }
                    for (ClassDef classDef : classLocation.definitions.values()) {
                        classDef.reset = true;
                    }
                }
            }
            this.runtimeData.reset();
            this.xmlFile = null;
            this.htmlDir = null;
        } else {
            this.runtimeData = new RuntimeData();
        }
        this.runtime.startup(this.runtimeData);
    }

    private void intStartSession() throws Exception {
        ClassLocation classLocation = new ClassLocation("");
        classLocation.memoryCL = new MemoryClassLoader("");
        this.classLocations.put(classLocation.location, classLocation);
        Thread.currentThread().setContextClassLoader(classLocation.memoryCL);
        if (this.coverage) {
            this.runtime = new LoggerRuntime();
            this.instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)this.runtime);
            this.startup(false);
            this.shutdownHooks.add(() -> this.shutdownAndPrintReports());
        }
        if (this.profile) {
            this.shutdownHooks.add(() -> this.profiler.shutdownAndPrintReports());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Runnable runnable : this.shutdownHooks) {
                runnable.run();
            }
        }));
    }

    private void loadClasses(File file2, String string, ClassLocation classLocation) {
        FileFilter fileFilter = file -> file.isDirectory() || file.getName().endsWith(".class") && file.getName().indexOf(36) < 0;
        for (File file3 : file2.listFiles(fileFilter)) {
            ClassDef classDef;
            if (file3.isDirectory()) {
                this.loadClasses(file3, string + file3.getName() + ".", classLocation);
                continue;
            }
            String string3 = file3.getName().substring(0, file3.getName().length() - 6);
            String string4 = string + string3;
            if (classLocation.originals.containsKey(string4) || (classDef = this.loadClass(string4, file3, classLocation.memoryCL)) == null || this.mustBeAnalyzed(classDef.cl, false) == 0) continue;
            classLocation.originals.put(string4, classDef);
            FilenameFilter filenameFilter = (file, string2) -> string2.startsWith(string3 + "$") && string2.endsWith(".class");
            for (File file4 : file2.listFiles(filenameFilter)) {
                String string5 = string + file4.getName().substring(0, file4.getName().length() - 6);
                classDef = this.loadClass(string5, file4, classLocation.memoryCL);
                if (classDef == null) continue;
                classLocation.originals.put(string5, classDef);
            }
        }
    }

    private ClassDef loadClass(String string, File file, MemoryClassLoader memoryClassLoader) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return this.loadClass(string, fileInputStream, memoryClassLoader);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private ClassDef loadClass(String string, InputStream inputStream, MemoryClassLoader memoryClassLoader) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            int n2 = inputStream.read(byArray);
            while (n2 >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            inputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            Class clazz = memoryClassLoader.DefineClass(string, byArray2, 0, byArray2.length);
            return new ClassDef(new MyClass(clazz), byArray2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void loadClassesFromJar(File file, ClassLocation classLocation) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ClassDef classDef;
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (!string.endsWith(".class") || string.indexOf(36) >= 0) continue;
                string = string.replace('/', '.');
                if (classLocation.originals.containsKey(string = string.substring(0, string.length() - 6)) || (classDef = this.loadClass(string, jarFile.getInputStream(jarEntry), classLocation.memoryCL)) == null || this.mustBeAnalyzed(classDef.cl, false) == 0) continue;
                classLocation.originals.put(string, classDef);
                Enumeration<JarEntry> enumeration2 = jarFile.entries();
                while (enumeration2.hasMoreElements()) {
                    JarEntry jarEntry2 = enumeration2.nextElement();
                    String string2 = jarEntry2.getName();
                    if (!string2.endsWith(".class")) continue;
                    string2 = string2.replace('/', '.');
                    if (!(string2 = string2.substring(0, string2.length() - 6)).startsWith(string + "$") || (classDef = this.loadClass(string2, jarFile.getInputStream(jarEntry2), classLocation.memoryCL)) == null) continue;
                    classLocation.originals.put(string2, classDef);
                }
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean shutdownAndPrintReports() {
        CoverageStatement coverageStatement;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        String[] stringArray;
        boolean bl = true;
        ExecutionDataStore executionDataStore = new ExecutionDataStore();
        SessionInfoStore sessionInfoStore = new SessionInfoStore();
        this.runtimeData.collect((IExecutionDataVisitor)executionDataStore, (ISessionInfoVisitor)sessionInfoStore, false);
        this.runtime.shutdown();
        if (this.classPaths != null) {
            stringArray = new ClassLocation("(classes)");
            stringArray.memoryCL = new MemoryClassLoader(stringArray.location);
            for (ClassLocation classLocation : this.classLocations.values()) {
                stringArray.originals.putAll(classLocation.originals);
            }
            for (File object12 : this.classPaths) {
                if (!object12.exists()) continue;
                if (object12.isDirectory()) {
                    this.loadClasses(object12, "", (ClassLocation)stringArray);
                    continue;
                }
                if (!object12.getName().endsWith(".jar")) continue;
                this.loadClassesFromJar(object12, (ClassLocation)stringArray);
            }
            for (ClassLocation classLocation : this.classLocations.values()) {
                for (String string : classLocation.originals.keySet()) {
                    stringArray.originals.remove(string);
                }
            }
            this.classLocations.put(stringArray.location, (ClassLocation)stringArray);
        }
        stringArray = this.classLocations.keySet().toArray(new String[this.classLocations.size()]);
        for (String string : stringArray) {
            object11 = new CoverageBuilder();
            object10 = new Analyzer(executionDataStore, (ICoverageVisitor)object11);
            object9 = this.classLocations.get(string);
            for (String string2 : ((ClassLocation)object9).originals.keySet()) {
                object8 = ((ClassLocation)object9).originals.get(string2);
                if (((ClassDef)object8).bytes == null) continue;
                object7 = new ByteArrayInputStream(((ClassDef)object8).bytes);
                try {
                    object10.analyzeClass((InputStream)object7, string2);
                    ((InputStream)object7).close();
                }
                catch (IOException iOException) {
                    bl = false;
                    iOException.printStackTrace();
                }
            }
            for (IClassCoverage iClassCoverage : object11.getClasses()) {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                object8 = iClassCoverage.getName().replace('/', '.');
                object7 = ((ClassLocation)object9).originals.get(object8);
                object6 = ((ClassDef)object7).cl.getEnclosingClass();
                if (object6 != null) {
                    bl4 = ((ClassDef)object7).cl.isAssignableTo(iscobolModule);
                    bl3 = !bl4 && ((ClassDef)object7).cl.getName().matches(".+\\$\\d*inner_\\d+");
                    bl2 = ((MyClass)object6).isAssignableTo(iscobolCall);
                } else {
                    bl4 = false;
                    bl3 = false;
                    bl2 = ((ClassDef)object7).cl.isAssignableTo(iscobolCall);
                }
                if (!bl4 && !bl3 && (object6 != null || ((ClassDef)object7).cl.getName().startsWith("com.iscobol.lib") || ((ClassDef)object7).cl.getName().endsWith("_CONST") || ((ClassDef)object7).cl.getName().matches(".+_CONST_\\d+"))) continue;
                object5 = "";
                if (bl4) {
                    object5 = Coverage.getMethodName(((ClassDef)object7).cl.getName());
                    object8 = ((MyClass)object6).getName();
                    object7 = ((ClassLocation)object9).originals.get(object8);
                } else if (bl3) {
                    if (((MyClass)object6).getEnclosingClass() != null && ((MyClass)object6).isAssignableTo(iscobolModule)) {
                        object5 = Coverage.getMethodName(((ClassDef)object7).cl.getName());
                        object8 = ((MyClass)object6).getEnclosingClass().getName();
                        object7 = ((ClassLocation)object9).originals.get(object8);
                    } else {
                        object8 = ((MyClass)object6).getName();
                        object7 = ((ClassLocation)object9).originals.get(object8);
                    }
                }
                if (((ClassDef)object7).program == null) {
                    this.newProgram((ClassDef)object7, (String)object8, ((ClassLocation)object9).location, this.session);
                }
                if (((ClassDef)object7).sr == null || !((ClassDef)object7).sr.isOk()) continue;
                TreeMap<SMAPReader.CobolInfo, Object> treeMap = new TreeMap<SMAPReader.CobolInfo, Object>((cobolInfo, cobolInfo2) -> {
                    int n2 = cobolInfo.fileNum - cobolInfo2.fileNum;
                    if (n2 == 0) {
                        n2 = cobolInfo.fileName.compareTo(cobolInfo2.fileName);
                    }
                    if (n2 == 0) {
                        n2 = cobolInfo.line - cobolInfo2.line;
                    }
                    return n2;
                });
                object4 = new LinkedHashMap();
                CoverageParagraph coverageParagraph = null;
                for (Object object12 : iClassCoverage.getMethods()) {
                    int n2;
                    object3 = object12.getName();
                    if (((String)object3).indexOf(60) >= 0 || bl2 && (((String)object3).equals("call") || ((String)object3).equals("finalize") || ((String)object3).equals("perform"))) continue;
                    if (((String)object3).startsWith("_dm$") && (n2 = ((String)object3).substring(4).lastIndexOf(36)) >= 0) {
                        object3 = ((String)object3).substring(4, n2 + 4);
                    }
                    if ((n2 = ((String)object3).indexOf("$$")) >= 0) {
                        String string3 = ((String)object3).substring(n2 + 2);
                        object3 = ((String)object3).substring(0, n2);
                        n2 = string3.indexOf(36);
                        if (n2 >= 0) {
                            string3 = string3.substring(0, n2);
                        }
                        object3 = ((String)object3).equals(string3) ? (String)object3 + " section" : (String)object3 + " of " + string3;
                    }
                    if (((String)object3).startsWith(EP_PREFIX)) {
                        object3 = "(ENTRY) " + ((String)object3).substring(EP_PREFIX.length()).toUpperCase();
                    }
                    object3 = (String)object5 + (String)object3;
                    for (int i2 = object12.getFirstLine(); i2 <= object12.getLastLine(); ++i2) {
                        SMAPReader.CobolInfo cobolInfo3 = null;
                        if (((ClassDef)object7).sr != null && ((ClassDef)object7).sr.isOk()) {
                            cobolInfo3 = ((ClassDef)object7).sr.getLineInfo(i2, true);
                        }
                        if (cobolInfo3 == null || treeMap.containsKey(cobolInfo3) || (object2 = Coverage.getColor(iClassCoverage.getLine(i2).getStatus())) == null) continue;
                        object = (String)((LinkedHashMap)object4).get(object12);
                        if (object == null) {
                            ((HashMap)object4).put(object12, object2);
                            if (coverageParagraph == null || !((String)object3).equals(coverageParagraph.name)) {
                                coverageParagraph = new CoverageParagraph();
                                coverageParagraph.name = object3;
                                if (coverageParagraph.color == null) {
                                    coverageParagraph.color = "red";
                                }
                                ((ClassDef)object7).program.addParagraph(coverageParagraph);
                            }
                        }
                        treeMap.put(cobolInfo3, object2);
                        coverageStatement = new CoverageStatement();
                        coverageStatement.color = object2;
                        coverageStatement.lineNumber = cobolInfo3.line;
                        coverageStatement.fileName = cobolInfo3.fileName;
                        coverageStatement.fileIndex = cobolInfo3.fileIndex;
                        coverageParagraph.addStatement(coverageStatement);
                        coverageParagraph.setMaxColor((String)object2);
                    }
                }
            }
        }
        if (this.xmlAppend != null) {
            for (File file : this.xmlAppend) {
                try {
                    object11 = RtsUtil.newDocumentBuilderFactory();
                    object10 = ((DocumentBuilderFactory)object11).newDocumentBuilder();
                    object9 = new InputStreamReader(new FileInputStream(file));
                    Document document = ((DocumentBuilder)object10).parse(new InputSource((Reader)object9));
                    Element element = document.getDocumentElement();
                    object8 = new CoverageSession.Name();
                    ((CoverageSession.Name)object8).name = element.getAttribute("name");
                    ((CoverageSession.Name)object8).timestamp = Long.parseLong(element.getAttribute("timestamp"));
                    this.session.addAppend((CoverageSession.Name)object8);
                    object7 = element.getChildNodes();
                    for (int i3 = 0; i3 < object7.getLength(); ++i3) {
                        boolean bl5;
                        Node node = object7.item(i3);
                        if (!(node instanceof Element)) continue;
                        Element element2 = (Element)node;
                        if (element2.getTagName().equals("append")) {
                            object8 = new CoverageSession.Name();
                            ((CoverageSession.Name)object8).name = element2.getAttribute("name");
                            ((CoverageSession.Name)object8).timestamp = Long.parseLong(element2.getAttribute("timestamp"));
                            this.session.addAppend((CoverageSession.Name)object8);
                            continue;
                        }
                        if (!element2.getTagName().equals("program")) continue;
                        object6 = element2.getAttribute("name");
                        object5 = this.session.getProgram((String)object6);
                        boolean bl6 = bl5 = object5 == null;
                        if (bl5) {
                            object5 = new CoverageProgram();
                            ((CoverageProgram)object5).name = object6;
                            ((CoverageProgram)object5).fileName = element2.getAttribute("fileName");
                            ((CoverageProgram)object5).location = element2.getAttribute("location");
                            ((CoverageProgram)object5).color = element2.getAttribute("color");
                            this.session.addProgram((CoverageProgram)object5);
                        } else {
                            ((CoverageElement)object5).setMaxColor(element2.getAttribute("color"));
                        }
                        object4 = element2.getChildNodes();
                        for (int i4 = 0; i4 < object4.getLength(); ++i4) {
                            Object object12;
                            Node node2 = object4.item(i4);
                            if (!(node2 instanceof Element)) continue;
                            object12 = (Element)node2;
                            if (object12.getTagName().equals("paragraph")) {
                                object3 = object12.getAttribute("name");
                                CoverageParagraph coverageParagraph = ((CoverageProgram)object5).getParagraph((String)object3);
                                if (coverageParagraph == null) {
                                    coverageParagraph = new CoverageParagraph();
                                    coverageParagraph.name = object3;
                                    coverageParagraph.color = object12.getAttribute("color");
                                    ((CoverageProgram)object5).addParagraph(coverageParagraph);
                                } else {
                                    coverageParagraph.setMaxColor(object12.getAttribute("color"));
                                }
                                NodeList nodeList = object12.getChildNodes();
                                for (int i5 = 0; i5 < nodeList.getLength(); ++i5) {
                                    object2 = nodeList.item(i5);
                                    if (!(object2 instanceof Element)) continue;
                                    object = (Element)object2;
                                    coverageStatement = new CoverageStatement();
                                    coverageStatement.lineNumber = Integer.parseInt(object.getAttribute("lineNumber"));
                                    coverageStatement.fileIndex = Integer.parseInt(object.getAttribute("fileIndex"));
                                    coverageStatement.fileName = object.getAttribute("fileName");
                                    CoverageStatement coverageStatement2 = coverageParagraph.getStatement(coverageStatement);
                                    if (coverageStatement2 == null) {
                                        coverageStatement2 = coverageStatement;
                                        coverageStatement2.color = object.getAttribute("color");
                                        coverageParagraph.addStatement(coverageStatement2);
                                        continue;
                                    }
                                    coverageStatement2.setMaxColor(object.getAttribute("color"));
                                }
                                continue;
                            }
                            if (!object12.getTagName().equals("copyStatement") || !bl5) continue;
                            object3 = new CoverageCopyStatement();
                            ((CoverageCopyStatement)object3).copyIndex = Integer.parseInt(object12.getAttribute("copyFileIndex"));
                            ((CoverageCopyStatement)object3).fileIndex = Integer.parseInt(object12.getAttribute("fileIndex"));
                            ((CoverageCopyStatement)object3).copyName = object12.getAttribute("copyFileName");
                            ((CoverageCopyStatement)object3).fileName = object12.getAttribute("fileName");
                            ((CoverageCopyStatement)object3).lineNumber = Integer.parseInt(object12.getAttribute("lineNumber"));
                            ((CoverageProgram)object5).addCopyStatement((CoverageCopyStatement)object3);
                        }
                    }
                    ((InputStreamReader)object9).close();
                }
                catch (IOException iOException) {
                    bl = false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bl = false;
                }
            }
        }
        if (this.xmlFile != null) {
            try {
                this.createXmlReport(this.session);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        if (this.htmlDir != null && !this.htmlDir.exists() && !this.htmlDir.mkdirs()) {
            System.err.println("Cannot create '" + this.htmlDir + "'");
            this.htmlDir = null;
        }
        if (this.htmlDir != null) {
            try {
                this.createHtmlReport(this.session);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }

    private static String getMethodName(String string) {
        String string2 = string;
        int n2 = string2.indexOf("$class$") + 7;
        int n3 = string2.indexOf(36, n2);
        return string2.substring(n2, n3) + "::";
    }

    private void newProgram(ClassDef classDef, String string, String string2, CoverageSession coverageSession) {
        CoverageProgram coverageProgram = new CoverageProgram();
        coverageProgram.name = string;
        coverageProgram.color = "green";
        coverageProgram.location = string2;
        coverageSession.addProgram(coverageProgram);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(classDef.bytes);
        SMAPReader sMAPReader = null;
        try {
            sMAPReader = new SMAPReader(byteArrayInputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        if (sMAPReader != null && sMAPReader.isOk()) {
            coverageProgram.fileName = sMAPReader.getFileName();
            Vector<String[]> vector = sMAPReader.getCopyStatements();
            int n2 = 0;
            for (String[] stringArray : vector) {
                String string3;
                CoverageCopyStatement coverageCopyStatement = new CoverageCopyStatement();
                coverageCopyStatement.fileName = string3 = stringArray[0];
                coverageCopyStatement.lineNumber = Integer.parseInt(stringArray[1]);
                coverageCopyStatement.copyName = string3 = stringArray[2];
                if (stringArray.length > 3) {
                    coverageCopyStatement.fileIndex = Integer.parseInt(stringArray[3]);
                    if (stringArray.length > 4) {
                        coverageCopyStatement.copyIndex = Integer.parseInt(stringArray[4]);
                    }
                } else {
                    coverageCopyStatement.copyIndex = ++n2;
                }
                coverageProgram.addCopyStatement(coverageCopyStatement);
            }
        }
        classDef.program = coverageProgram;
        classDef.sr = sMAPReader;
    }

    private int mustBeAnalyzed(MyClass myClass, boolean bl) {
        String string;
        boolean bl2;
        int n2 = 0;
        boolean bl3 = bl2 = !myClass.isInterface() && myClass.isAssignableTo(iscobolClass) && ((string = myClass.getPackageName()) == null || !invalidPackageNames.contains(string));
        if (!bl2) {
            return n2;
        }
        if (!bl) {
            return ++n2;
        }
        if (this.coverage) {
            if (this.includes != null && this.includes.length > 0) {
                bl2 = false;
                for (Pattern pattern : this.includes) {
                    if (!pattern.matcher(myClass.getName()).matches()) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2 && this.excludes != null && this.excludes.length > 0) {
                for (Pattern pattern : this.excludes) {
                    if (!pattern.matcher(myClass.getName()).matches()) continue;
                    bl2 = false;
                    break;
                }
            }
            if (bl2) {
                ++n2;
            }
        }
        if (this.profile && this.profiler.getTransformer().matches(myClass.getName())) {
            n2 += 2;
        }
        return n2;
    }

    @Override
    public Class loadClass(String string, String string2, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        return this.loadClass(string, string2, bl, new CLWrapper(classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(String string, String string2, boolean bl, CLWrapper cLWrapper) throws ClassNotFoundException {
        if (string2.equals(this.loadingClassName)) {
            throw new ClassNotFoundException(string2);
        }
        String string3 = this.loadingClassName;
        this.loadingClassName = string2;
        try {
            Class clazz = this.loadClass0(string, string2, bl, cLWrapper);
            return clazz;
        }
        finally {
            this.loadingClassName = string3;
        }
    }

    @Override
    public byte[] transformBytes(String string, String string2, byte[] byArray) {
        ClassLocation classLocation = this.getClassLocation(string);
        ClassDef classDef = null;
        try {
            classDef = this.getClassDef(classLocation, string2, byArray, true, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (classDef != null && classDef.bytes != null) {
            return classDef.bytes;
        }
        return byArray;
    }

    private synchronized ClassLocation getClassLocation(String string) {
        ClassLocation classLocation = this.classLocations.get(string);
        if (classLocation == null) {
            classLocation = new ClassLocation(string);
            classLocation.memoryCL = new MemoryClassLoader(classLocation.location);
            this.classLocations.put(string, classLocation);
        }
        return classLocation;
    }

    private Class loadClass0(String string, String string2, boolean bl, CLWrapper cLWrapper) throws ClassNotFoundException {
        ClassDef classDef;
        ClassLocation classLocation = this.getClassLocation(string);
        try {
            classDef = this.getClassDef(classLocation, string2, null, bl, cLWrapper);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            classDef = null;
        }
        if (classDef != null && classDef.bytes != null) {
            return classLocation.memoryCL.DefineClass(string2, classDef.bytes, 0, classDef.bytes.length);
        }
        return cLWrapper.LoadClass(string2, bl);
    }

    private ClassDef getClassDef(ClassLocation classLocation, String string, byte[] byArray, boolean bl, CLWrapper cLWrapper) throws Exception {
        ClassDef classDef = classLocation.definitions.get(string);
        if (classDef != null && !classDef.reset) {
            if (classDef.bytes != null) {
                return classDef;
            }
            return null;
        }
        MyClass myClass = cLWrapper != null ? new MyClass(cLWrapper.LoadClass(string, bl)) : new MyClass(byArray);
        int n2 = this.mustBeAnalyzed(myClass, true);
        if (n2 > 0) {
            String string3;
            String string4;
            File file2 = myClass.getLocation();
            if (file2 == null) {
                file2 = new File(classLocation.location);
            }
            String string5 = file2.getPath();
            int n3 = string.lastIndexOf(46);
            if (n3 >= 0) {
                string4 = string.substring(0, n3 + 1);
                string3 = string.substring(n3 + 1);
            } else {
                string4 = "";
                string3 = string;
            }
            FilenameFilter filenameFilter = (file, string2) -> string2.equals(string3 + ".class") || string2.endsWith(".class") && (string2.startsWith(string3 + "$") || string2.startsWith(string3 + "_CONST"));
            if (file2.isDirectory()) {
                File file3 = string4.length() > 0 ? new File(string5 + string4.replace('.', '/')) : file2;
                for (File file4 : file3.listFiles(filenameFilter)) {
                    Object object;
                    MyClass myClass2;
                    String string6;
                    byte[] byArray2 = null;
                    if (file4.getName().equals(string3 + ".class")) {
                        string6 = string;
                        myClass2 = myClass;
                        if (byArray != null) {
                            byArray2 = byArray;
                        }
                    } else {
                        string6 = string4 + file4.getName().substring(0, file4.getName().length() - 6);
                        if (cLWrapper == null) {
                            object = new FileInputStream(file4);
                            byArray2 = Coverage.readBytes((InputStream)object);
                            object.close();
                            myClass2 = new MyClass(byArray2);
                        } else {
                            myClass2 = new MyClass(cLWrapper.LoadClass(string6, bl));
                        }
                    }
                    try {
                        if (byArray2 == null) {
                            FileInputStream fileInputStream = new FileInputStream(file4);
                            byArray2 = Coverage.readBytes(fileInputStream);
                            fileInputStream.close();
                        }
                        object = this.instrumentClass(myClass2, byArray2, string6, n2, cLWrapper);
                        classLocation.originals.put(string6, new ClassDef(myClass2, byArray2));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        object = new byte[]{};
                    }
                    classLocation.definitions.put(string6, new ClassDef(myClass2, (byte[])object));
                    myClass2.detach();
                }
            } else {
                try {
                    ZipEntry zipEntry;
                    String string7;
                    ZipInputStream zipInputStream = file2.getName().endsWith(".jar") ? new JarInputStream(new FileInputStream(file2)) : new ZipInputStream(new FileInputStream(file2));
                    String string8 = string7 = string4.length() > 0 ? string4.replace('.', '/') : null;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        byte[] byArray3;
                        MyClass myClass3;
                        String string9;
                        String string10 = new File(zipEntry.getName()).getName();
                        if (string7 != null && !zipEntry.getName().startsWith(string7) || !filenameFilter.accept(null, string10)) continue;
                        byte[] byArray4 = null;
                        if (string10.equals(string3 + ".class")) {
                            string9 = string;
                            myClass3 = myClass;
                            if (byArray != null) {
                                byArray4 = byArray;
                            }
                        } else {
                            string9 = string4 + string10.substring(0, string10.length() - 6);
                            if (cLWrapper != null) {
                                myClass3 = new MyClass(cLWrapper.LoadClass(string9, bl));
                            } else {
                                byArray4 = Coverage.readBytes(zipInputStream);
                                myClass3 = new MyClass(byArray4);
                            }
                        }
                        if (byArray4 == null) {
                            byArray4 = Coverage.readBytes(zipInputStream);
                        }
                        try {
                            byArray3 = this.instrumentClass(myClass3, byArray4, string9, n2, cLWrapper);
                            classLocation.originals.put(string9, new ClassDef(myClass3, byArray4));
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            byArray3 = new byte[]{};
                        }
                        classLocation.definitions.put(string9, new ClassDef(myClass3, byArray3));
                        myClass3.detach();
                    }
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    classLocation.definitions.put(string, new ClassDef(myClass, null));
                }
            }
            classDef = classLocation.definitions.get(string);
            if (classDef != null && classDef.bytes != null) {
                return classDef;
            }
            return null;
        }
        return null;
    }

    private static String getColor(int n2) {
        switch (n2) {
            case 1: {
                return "red";
            }
            case 3: {
                return "yellow";
            }
            case 2: {
                return "green";
            }
        }
        return null;
    }

    private void createXmlReport(CoverageSession coverageSession) throws Exception {
        Iterator<CoverageCopyStatement> iterator;
        Object object;
        Object object2;
        Object object3;
        DocumentBuilderFactory documentBuilderFactory = RtsUtil.newDocumentBuilderFactory();
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("session");
        element.setAttribute("name", coverageSession.name.name);
        element.setAttribute("timestamp", Long.toString(coverageSession.name.timestamp));
        document.appendChild(element);
        Collection<CoverageSession.Name> collection = coverageSession.getAppended();
        for (CoverageSession.Name object52 : collection) {
            object3 = document.createElement("append");
            object3.setAttribute("name", object52.name);
            object3.setAttribute("timestamp", Long.toString(object52.timestamp));
            element.appendChild((Node)object3);
        }
        Collection<CoverageProgram> collection2 = coverageSession.getPrograms();
        Iterator iterator2 = collection2.iterator();
        while (iterator2.hasNext()) {
            Element element2;
            object3 = (CoverageProgram)iterator2.next();
            object2 = document.createElement("program");
            object2.setAttribute("name", ((CoverageProgram)object3).name);
            object2.setAttribute("color", ((CoverageProgram)object3).color);
            object2.setAttribute("fileName", ((CoverageProgram)object3).fileName);
            if (((CoverageProgram)object3).location != null && ((CoverageProgram)object3).location.length() > 0) {
                object2.setAttribute("location", ((CoverageProgram)object3).location);
            }
            element.appendChild((Node)object2);
            object = ((CoverageProgram)object3).getParagraphs();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                CoverageParagraph coverageParagraph = (CoverageParagraph)iterator.next();
                element2 = document.createElement("paragraph");
                element2.setAttribute("name", Coverage.removePrefix(coverageParagraph.name));
                element2.setAttribute("color", coverageParagraph.color);
                object2.appendChild(element2);
                Collection<CoverageStatement> collection3 = coverageParagraph.getStatements();
                for (CoverageStatement coverageStatement : collection3) {
                    Element element3 = document.createElement("statement");
                    element3.setAttribute("color", coverageStatement.color);
                    element3.setAttribute("lineNumber", Integer.toString(coverageStatement.lineNumber));
                    element3.setAttribute("fileIndex", Integer.toString(coverageStatement.fileIndex));
                    element3.setAttribute("fileName", coverageStatement.fileName);
                    element2.appendChild(element3);
                }
            }
            for (CoverageCopyStatement coverageCopyStatement : ((CoverageProgram)object3).getCopyStatements()) {
                element2 = document.createElement("copyStatement");
                element2.setAttribute("lineNumber", Integer.toString(coverageCopyStatement.lineNumber));
                element2.setAttribute("fileIndex", Integer.toString(coverageCopyStatement.fileIndex));
                element2.setAttribute("fileName", coverageCopyStatement.fileName);
                element2.setAttribute("copyFileIndex", Integer.toString(coverageCopyStatement.copyIndex));
                element2.setAttribute("copyFileName", coverageCopyStatement.copyName);
                object2.appendChild(element2);
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = transformerFactory.newTransformer();
        object2 = ((javax.xml.transform.Transformer)object3).getOutputProperties();
        ((Properties)object2).setProperty("indent", "yes");
        ((javax.xml.transform.Transformer)object3).setOutputProperties((Properties)object2);
        object = new DOMSource(document);
        iterator = new FileOutputStream(this.xmlFile);
        StreamResult streamResult = new StreamResult(new OutputStreamWriter((OutputStream)((Object)iterator)));
        ((javax.xml.transform.Transformer)object3).transform((Source)object, streamResult);
        ((FileOutputStream)((Object)iterator)).close();
    }

    private void createHtmlReport(CoverageSession coverageSession) throws IOException {
        Object object;
        int n2;
        int n3 = 120;
        int n4 = 10;
        ArrayList<CoverageProgram> arrayList = new ArrayList<CoverageProgram>(coverageSession.getPrograms());
        Collections.sort(arrayList, new ProgramComparator(0));
        ArrayList<CoverageProgram> arrayList2 = new ArrayList<CoverageProgram>(arrayList);
        int[][] nArray = new int[arrayList2.size()][9];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2][0] = n2;
        }
        for (n2 = 1; n2 < 9; ++n2) {
            Collections.sort(arrayList2, new ProgramComparator(n2));
            block2: for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                    if (arrayList.get(i2) != arrayList2.get(i3)) continue;
                    nArray[i2][n2] = i3;
                    continue block2;
                }
            }
        }
        this.createResources();
        String string = "isCOBOL Coverage Report";
        PrintStream printStream = new PrintStream(new File(this.htmlDir.getAbsolutePath() + "/index.html"));
        printStream.println("<html>");
        printStream.println("  <head>");
        printStream.println("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
        printStream.println("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />");
        printStream.println("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />");
        printStream.println("    <title>isCOBOL Coverage Report</title>");
        printStream.println("    <script type=\"text/javascript\" src=\"resources/sort.js\"></script>");
        printStream.println("   </head>");
        printStream.println("   <body onload=\"sortColumn(a, false)\">");
        printStream.println("      <h1>isCOBOL Coverage Report</h1>");
        printStream.println("      <h4>Sessions</h4>");
        printStream.println("      <p>This coverage report is based on execution data from the following\r\n      sessions:</p>");
        printStream.println("      <table class=\"coverage\" cellspacing=\"0\">");
        printStream.println("        <thead>");
        printStream.println("          <tr>");
        printStream.println("            <td>Session</td>");
        printStream.println("            <td>Executed</td>");
        printStream.println("          </tr>");
        printStream.println("        </thead>");
        printStream.println("        <tbody>");
        ArrayList<CoverageSession.Name> arrayList3 = new ArrayList<CoverageSession.Name>(coverageSession.getAppended());
        Collections.sort(arrayList3, (name, name2) -> {
            long l2 = name.timestamp - name2.timestamp;
            if (l2 > 0L) {
                return 1;
            }
            if (l2 < 0L) {
                return -1;
            }
            return 0;
        });
        for (CoverageSession.Name name3 : arrayList3) {
            this.writeHtml(printStream, name3);
        }
        this.writeHtml(printStream, coverageSession.name);
        printStream.println("        </tbody>");
        printStream.println("      </table>");
        printStream.println("      <br><br>");
        printStream.println("      <table class=\"coverage\" cellspacing=\"0\" id=\"coveragetable\">");
        printStream.println("        <thead>");
        printStream.println("          <tr>");
        printStream.println("            <td class=\"sortable\" id=\"a\" onclick=\"toggleSort(this)\">Program</td>");
        printStream.println("            <td class=\"down sortable bar\" id=\"b\" onclick=\"toggleSort(this)\">Statements Coverage</td>");
        printStream.println("            <td class=\"sortable ctr2\" id=\"c\" onclick=\"toggleSort(this)\">Covered Stmts</td>");
        printStream.println("            <td class=\"sortable ctr1\" id=\"d\" onclick=\"toggleSort(this)\">Missed Stmts</td>");
        printStream.println("            <td class=\"sortable ctr2\" id=\"e\" onclick=\"toggleSort(this)\">Total Stmts</td>");
        printStream.println("            <td class=\"down sortable bar\" id=\"f\" onclick=\"toggleSort(this)\">Paragraphs Coverage</td>");
        printStream.println("            <td class=\"sortable ctr2\" id=\"g\" onclick=\"toggleSort(this)\">Covered Pars</td>");
        printStream.println("            <td class=\"sortable ctr1\" id=\"h\" onclick=\"toggleSort(this)\">Missed Pars</td>");
        printStream.println("            <td class=\"sortable ctr2\" id=\"i\" onclick=\"toggleSort(this)\">Total Pars</td>");
        printStream.println("          </tr>");
        printStream.println("        </thead>");
        printStream.println("        <tfoot>");
        printStream.println("          <tr>");
        printStream.println("            <td>Total</td>");
        int n5 = coverageSession.getMissedStatements();
        int n6 = coverageSession.getTotalStatements();
        double d2 = coverageSession.getStatementCoverageRatio();
        int n7 = (int)Math.round(d2 * 120.0);
        String string2 = null;
        if (n6 > 0) {
            if (n5 > 0) {
                string2 = "<img src=\"resources/redbar.gif\" width=\"" + (120 - n7) + "\" height=\"" + 10 + "\" title=\"" + n5 + "\" alt=\"" + n5 + "\" />";
            }
            if (n5 < n6) {
                if (string2 == null) {
                    string2 = "";
                }
                string2 = string2 + "<img src=\"resources/greenbar.gif\" width=\"" + n7 + "\" height=\"" + 10 + "\" title=\"" + (n6 - n5) + "\" alt=\"" + (n6 - n5) + "\" />";
            }
        }
        String string3 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        printStream.println("            <td class=\"bar\">" + (string2 != null ? string2 : "") + string3 + Coverage.percFormat(d2) + "</td>");
        printStream.println("            <td class=\"ctr2\">" + intFormat.format(n6 - n5) + "</td>");
        printStream.println("            <td class=\"ctr1\">" + intFormat.format(n5) + "</td>");
        printStream.println("            <td class=\"ctr2\">" + intFormat.format(n6) + "</td>");
        n5 = coverageSession.getMissedParagraphs();
        n6 = coverageSession.getTotalParagraphs();
        d2 = coverageSession.getParagraphCoverageRatio();
        n7 = (int)Math.round(d2 * 120.0);
        string2 = null;
        if (n6 > 0) {
            if (n5 > 0) {
                string2 = "<img src=\"resources/redbar.gif\" width=\"" + (120 - n7) + "\" height=\"" + 10 + "\" title=\"" + n5 + "\" alt=\"" + n5 + "\" />";
            }
            if (n5 < n6) {
                if (string2 == null) {
                    string2 = "";
                }
                string2 = string2 + "<img src=\"resources/greenbar.gif\" width=\"" + n7 + "\" height=\"" + 10 + "\" title=\"" + (n6 - n5) + "\" alt=\"" + (n6 - n5) + "\" />";
            }
        }
        printStream.println("            <td class=\"bar\">" + (string2 != null ? string2 : "") + string3 + Coverage.percFormat(d2) + "</td>");
        printStream.println("            <td class=\"ctr2\">" + intFormat.format(n6 - n5) + "</td>");
        printStream.println("            <td class=\"ctr1\">" + intFormat.format(n5) + "</td>");
        printStream.println("            <td class=\"ctr2\">" + intFormat.format(n6) + "</td>");
        printStream.println("          </tr>");
        printStream.println("        </tfoot>");
        printStream.println("        <tbody>");
        String string4 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        int n8 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (CoverageProgram coverageProgram : arrayList) {
            object = (Boolean)hashMap.get(coverageProgram.name);
            hashMap.put(coverageProgram.name, object != null);
        }
        for (CoverageProgram coverageProgram : arrayList) {
            int n9;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            Object object5;
            File file;
            Object object6;
            n5 = coverageProgram.getMissedStatements();
            n6 = coverageProgram.getTotalStatements();
            d2 = 0.0;
            if (n6 > 0) {
                d2 = 1.0 - (double)n5 / (double)n6;
            }
            n7 = (int)Math.round(d2 * 120.0);
            object = Coverage.getUnivoqueName(hashSet, coverageProgram.name, ".html");
            printStream.println("          <tr>");
            String string5 = coverageProgram.name;
            if (((Boolean)hashMap.get(coverageProgram.name)).booleanValue() && coverageProgram.location.length() > 0) {
                object6 = new File(coverageProgram.location);
                file = new File(System.getProperty("user.dir"));
                object5 = new StringBuilder();
                if (((File)object6).isAbsolute()) {
                    for (serializable = object6; serializable != null && !((File)serializable).equals(file); serializable = ((File)serializable).getParentFile()) {
                        if (((StringBuilder)object5).length() > 0) {
                            ((StringBuilder)object5).insert(0, ((File)serializable).getName() + "/");
                            continue;
                        }
                        ((StringBuilder)object5).append(((File)serializable).getName());
                    }
                    if (serializable == null) {
                        object5 = new StringBuilder(coverageProgram.location);
                    }
                } else {
                    ((StringBuilder)object5).append(coverageProgram.location);
                }
                string5 = string5 + " (" + object5 + ")";
            }
            printStream.println("            <td id=\"a" + nArray[n8][0] + "\"> <a href=\"" + (String)object + "\" class=\"el_program\">" + string5 + "</a> </td>");
            printStream.println("            <td class=\"bar\" id=\"b" + nArray[n8][1] + "\">");
            if (n6 > 0) {
                string2 = null;
                if (n5 > 0) {
                    string2 = "               <img src=\"resources/redbar.gif\" width=\"" + (120 - n7) + "\" height=\"" + 10 + "\" title=\"" + n5 + "\" alt=\"" + n5 + "\" />";
                }
                if (n5 < n6) {
                    if (string2 == null) {
                        string2 = "               ";
                    }
                    string2 = string2 + "<img src=\"resources/greenbar.gif\" width=\"" + n7 + "\" height=\"" + 10 + "\" title=\"" + (n6 - n5) + "\" alt=\"" + (n6 - n5) + "\" />";
                }
                printStream.println(string2);
            }
            printStream.println("            " + string4 + (n6 > 0 ? Coverage.percFormat(d2) : "n/a") + "</td>");
            printStream.println("            <td class=\"ctr2\" id=\"c" + nArray[n8][2] + "\">" + (n6 > 0 ? intFormat.format(n6 - n5) : "n/a") + "</td>");
            printStream.println("            <td class=\"ctr1\" id=\"d" + nArray[n8][3] + "\">" + (n6 > 0 ? intFormat.format(n5) : "n/a") + "</td>");
            printStream.println("            <td class=\"ctr2\" id=\"e" + nArray[n8][4] + "\">" + (n6 > 0 ? intFormat.format(n6) : "n/a") + "</td>");
            n5 = coverageProgram.getMissedParagraphs();
            n6 = coverageProgram.getTotalParagraphs();
            d2 = 0.0;
            if (n6 > 0) {
                d2 = 1.0 - (double)n5 / (double)n6;
            }
            n7 = (int)Math.round(d2 * 120.0);
            printStream.println("            <td class=\"bar\" id=\"f" + nArray[n8][5] + "\">");
            if (n6 > 0) {
                string2 = null;
                if (n5 > 0) {
                    string2 = "               <img src=\"resources/redbar.gif\" width=\"" + (120 - n7) + "\" height=\"" + 10 + "\" title=\"" + n5 + "\" alt=\"" + n5 + "\" />";
                }
                if (n5 < n6) {
                    if (string2 == null) {
                        string2 = "               ";
                    }
                    string2 = string2 + "<img src=\"resources/greenbar.gif\" width=\"" + n7 + "\" height=\"" + 10 + "\" title=\"" + (n6 - n5) + "\" alt=\"" + (n6 - n5) + "\" />";
                }
                printStream.println(string2);
            }
            printStream.println("            " + string4 + (n6 > 0 ? Coverage.percFormat(d2) : "n/a") + "</td>");
            printStream.println("            <td class=\"ctr2\" id=\"g" + nArray[n8][6] + "\">" + (n6 > 0 ? intFormat.format(n6 - n5) : "n/a") + "</td>");
            printStream.println("            <td class=\"ctr1\" id=\"h" + nArray[n8][7] + "\">" + (n6 > 0 ? intFormat.format(n5) : "n/a") + "</td>");
            printStream.println("            <td class=\"ctr2\" id=\"i" + nArray[n8][8] + "\">" + (n6 > 0 ? intFormat.format(n6) : "n/a") + "</td>");
            object6 = new PrintStream(new File(this.htmlDir.getAbsolutePath() + "/" + (String)object));
            ((PrintStream)object6).println("<html>");
            ((PrintStream)object6).println("  <head>");
            ((PrintStream)object6).println("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
            ((PrintStream)object6).println("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />");
            ((PrintStream)object6).println("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />");
            ((PrintStream)object6).println("    <title>" + coverageProgram.name + "</title>");
            ((PrintStream)object6).println("    <script type=\"text/javascript\" src=\"resources/sort.js\"></script>");
            ((PrintStream)object6).println("   </head>");
            ((PrintStream)object6).println("   <body onload=\"initialSort(['breadcrumb'])\">");
            ((PrintStream)object6).println("       <div class=\"breadcrumb\" id=\"breadcrumb\">");
            ((PrintStream)object6).println("         <a href=\"index.html\" class=\"el_report\">isCOBOL Coverage Report</a> &gt; " + coverageProgram.name);
            ((PrintStream)object6).println("       </div>");
            ((PrintStream)object6).println("      <h1>" + coverageProgram.name + "</h1>");
            file = this.findSourceFile(coverageProgram.fileName);
            if (file != null) {
                object5 = Coverage.getUnivoqueName(hashSet, new File(coverageProgram.fileName).getName(), ".html");
                ((PrintStream)object6).println("      <div class=\"el_source_lnk\">Source file: <a href=\"" + (String)object5 + "\">" + file.getName() + "</a></div><br>");
                serializable = new File(this.htmlDir.getAbsolutePath() + "/" + (String)object5);
                object4 = new String[][]{{"index.html", "isCOBOL Coverage Report"}, {object5, coverageProgram.name}};
                TreeMap<CoverageStatement, CoverageStatement> treeMap = new TreeMap<CoverageStatement, CoverageStatement>();
                object3 = coverageProgram.getParagraphs();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    CoverageParagraph coverageParagraph = object2.next();
                    Collection<CoverageStatement> collection = coverageParagraph.getStatements();
                    for (CoverageStatement coverageStatement : collection) {
                        treeMap.put(coverageStatement, coverageStatement);
                    }
                }
                this.createSourceHtmlFile(file, 0, (File)serializable, coverageProgram, (Map<CoverageStatement, CoverageStatement>)treeMap, (String[][])object4, (Set<String>)hashSet);
            } else {
                ((PrintStream)object6).println("      <div class=\"el_source_lnk\">Source file not found</div><br>");
            }
            ((PrintStream)object6).println("      <table class=\"coverage\" cellspacing=\"0\" id=\"coveragetable\">");
            ((PrintStream)object6).println("        <thead>");
            ((PrintStream)object6).println("          <tr>");
            ((PrintStream)object6).println("            <td class=\"sortable\" id=\"a\" onclick=\"toggleSort(this)\">Paragraph</td>");
            ((PrintStream)object6).println("            <td class=\"down sortable bar\" id=\"b\" onclick=\"toggleSort(this)\">Statements Coverage</td>");
            ((PrintStream)object6).println("            <td class=\"sortable ctr2\" id=\"c\" onclick=\"toggleSort(this)\">Covered Stmts</td>");
            ((PrintStream)object6).println("            <td class=\"sortable ctr1\" id=\"d\" onclick=\"toggleSort(this)\">Missed Stmts</td>");
            ((PrintStream)object6).println("              <td class=\"sortable ctr2\" id=\"e\" onclick=\"toggleSort(this)\">Total Stmts</td>");
            ((PrintStream)object6).println("          </tr>");
            ((PrintStream)object6).println("        </thead>");
            ((PrintStream)object6).println("        <tfoot>");
            ((PrintStream)object6).println("          <tr>");
            ((PrintStream)object6).println("            <td>Total</td>");
            n5 = coverageProgram.getMissedStatements();
            n6 = coverageProgram.getTotalStatements();
            d2 = 0.0;
            if (n6 > 0) {
                d2 = 1.0 - (double)n5 / (double)n6;
            }
            n7 = (int)Math.round(d2 * 120.0);
            string2 = null;
            if (n6 > 0) {
                if (n5 > 0) {
                    string2 = "               <img src=\"resources/redbar.gif\" width=\"" + (120 - n7) + "\" height=\"" + 10 + "\" title=\"" + n5 + "\" alt=\"" + n5 + "\" />";
                }
                if (n5 < n6) {
                    if (string2 == null) {
                        string2 = "               ";
                    }
                    string2 = string2 + "<img src=\"resources/greenbar.gif\" width=\"" + n7 + "\" height=\"" + 10 + "\" title=\"" + (n6 - n5) + "\" alt=\"" + (n6 - n5) + "\" />";
                }
            }
            ((PrintStream)object6).println("            <td class=\"bar\">" + (string2 != null ? string2 : "") + string3 + Coverage.percFormat(d2) + "</td>");
            ((PrintStream)object6).println("            <td class=\"ctr2\">" + intFormat.format(n6 - n5) + "</td>");
            ((PrintStream)object6).println("            <td class=\"ctr1\">" + intFormat.format(n5) + "</td>");
            ((PrintStream)object6).println("            <td class=\"ctr2\">" + intFormat.format(n6) + "</td>");
            ((PrintStream)object6).println("          </tr>");
            ((PrintStream)object6).println("        </tfoot>");
            ((PrintStream)object6).println("        <tbody>");
            object5 = new ArrayList<CoverageParagraph>(coverageProgram.getParagraphs());
            Collections.sort(object5, new ParagraphComparator(0));
            serializable = new ArrayList(object5);
            object4 = new int[serializable.size()][9];
            for (n9 = 0; n9 < ((String[][])object4).length; ++n9) {
                object4[n9][0] = (String)n9;
            }
            for (n9 = 1; n9 < 5; ++n9) {
                Collections.sort(serializable, new ParagraphComparator(n9));
                block12: for (int i4 = 0; i4 < object5.size(); ++i4) {
                    for (int i5 = 0; i5 < serializable.size(); ++i5) {
                        if (object5.get(i4) != serializable.get(i5)) continue;
                        object4[i4][n9] = (String)i5;
                        continue block12;
                    }
                }
            }
            n9 = 0;
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (CoverageParagraph)object3.next();
                n5 = ((CoverageParagraph)object2).getMissedStatements();
                n6 = ((CoverageParagraph)object2).getTotalStatements();
                d2 = ((CoverageParagraph)object2).getStatementCoverageRatio();
                n7 = (int)Math.round(d2 * 120.0);
                ((PrintStream)object6).println("          <tr>");
                ((PrintStream)object6).println("            <td id=\"a" + (int)object4[n9][0] + "\"> <span class=\"el_paragraph\">" + Coverage.removePrefix(((CoverageParagraph)object2).name) + "</span> </td>");
                ((PrintStream)object6).println("            <td class=\"bar\" id=\"b" + (int)object4[n9][1] + "\">");
                if (n6 > 0) {
                    string2 = null;
                    if (n5 > 0) {
                        string2 = "               <img src=\"resources/redbar.gif\" width=\"" + (120 - n7) + "\" height=\"" + 10 + "\" title=\"" + n5 + "\" alt=\"" + n5 + "\" />";
                    }
                    if (n5 < n6) {
                        if (string2 == null) {
                            string2 = "                 ";
                        }
                        string2 = string2 + "<img src=\"resources/greenbar.gif\" width=\"" + n7 + "\" height=\"" + 10 + "\" title=\"" + (n6 - n5) + "\" alt=\"" + (n6 - n5) + "\" />";
                    }
                    ((PrintStream)object6).println(string2);
                }
                ((PrintStream)object6).println("            " + string4 + (n6 > 0 ? Coverage.percFormat(d2) : "n/a") + "</td>");
                ((PrintStream)object6).println("            <td class=\"ctr2\" id=\"c" + (int)object4[n9][2] + "\">" + (n6 > 0 ? intFormat.format(n6 - n5) : "n/a") + "</td>");
                ((PrintStream)object6).println("            <td class=\"ctr1\" id=\"d" + (int)object4[n9][3] + "\">" + (n6 > 0 ? intFormat.format(n5) : "n/a") + "</td>");
                ((PrintStream)object6).println("            <td class=\"ctr2\" id=\"e" + (int)object4[n9][4] + "\">" + (n6 > 0 ? intFormat.format(n6) : "n/a") + "</td>");
                ((PrintStream)object6).println("          </tr>");
                ++n9;
            }
            ((PrintStream)object6).println("      </tbody>");
            ((PrintStream)object6).println("    </table>");
            ((PrintStream)object6).println("  </body>");
            ((PrintStream)object6).println("</html>");
            ((PrintStream)object6).close();
            ++n8;
        }
        printStream.println("        </tbody>");
        printStream.println("      </table>");
        printStream.println("   </body>");
        printStream.println("</html>");
        printStream.close();
    }

    private void writeHtml(PrintStream printStream, CoverageSession.Name name) {
        printStream.println("          <tr>");
        printStream.println("            <td>");
        printStream.println("              <span class=\"el_session\">" + name.name + "</span>");
        printStream.println("            </td>");
        calendar.setTimeInMillis(name.timestamp);
        printStream.println("            <td>" + dateFormat.format(calendar.getTime()) + "</td>");
        printStream.println("          </tr>");
    }

    private static String removePrefix(String string) {
        if (string.startsWith("declarative$")) {
            string = string.substring(12);
        }
        return string;
    }

    private void createSourceHtmlFile(File file, int n2, File file2, CoverageProgram coverageProgram, Map<CoverageStatement, CoverageStatement> map, String[][] stringArray, Set<String> set) throws IOException {
        PrintStream printStream = new PrintStream(file2);
        printStream.println("<html>");
        printStream.println("  <head>");
        printStream.println("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
        printStream.println("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />");
        printStream.println("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />");
        printStream.println("    <link rel=\"stylesheet\" href=\"resources/prettify.css\" type=\"text/css\"/>");
        printStream.println("    <title>" + file.getName() + "</title>");
        printStream.println("    <script type=\"text/javascript\" src=\"resources/prettify.js\"></script>");
        printStream.println("   </head>");
        printStream.println("   <body onload=\"window['PR_TAB_WIDTH']=3;prettyPrint()\">");
        printStream.println("      <div class=\"breadcrumb\" id=\"breadcrumb\">");
        printStream.print("         ");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                printStream.print(" &gt; ");
            }
            printStream.print("<a href=\"" + stringArray[i2][0] + "\"");
            if (i2 == 0) {
                printStream.print(" class=\"el_report\"");
            }
            printStream.print(">" + stringArray[i2][1] + "</a>");
        }
        printStream.println();
        printStream.println("      </div>");
        printStream.println("      <h1>" + file.getName() + "</h1>");
        printStream.println("      <pre class=\"source lang-cbl linenums\">");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        int n3 = 1;
        String string = bufferedReader.readLine();
        while (string != null) {
            CoverageStatement coverageStatement = new CoverageStatement();
            coverageStatement.lineNumber = n3;
            coverageStatement.fileName = file.getPath();
            coverageStatement.fileIndex = n2;
            CoverageStatement coverageStatement2 = map.get(coverageStatement);
            String string2 = coverageStatement2 != null ? coverageStatement2.color : null;
            String string3 = null;
            if ("green".equals(string2)) {
                string3 = "fc";
            } else if ("red".equals(string2)) {
                string3 = "nc";
            } else if ("yellow".equals(string2)) {
                string3 = "pc";
            }
            if (string3 != null) {
                printStream.println("<span class=\"" + string3 + "\" id=\"L" + n3 + "\">" + Coverage.escapeText(string) + "</span>");
            } else {
                CoverageCopyStatement coverageCopyStatement = coverageProgram.getCopyStatement(coverageStatement);
                File file3 = null;
                if (coverageCopyStatement != null) {
                    file3 = this.findSourceFile(coverageCopyStatement.copyName);
                }
                if (file3 != null) {
                    int n4;
                    for (n4 = 0; n4 < string.length() && (string.charAt(n4) == ' ' || string.charAt(n4) == '\t'); ++n4) {
                    }
                    if (n4 > 0) {
                        printStream.print(Coverage.escapeText(string.substring(0, n4)));
                    }
                    String string4 = Coverage.getUnivoqueName(set, coverageProgram.name + "-" + coverageCopyStatement.lineNumber + "-" + new File(coverageCopyStatement.copyName).getName(), ".html");
                    printStream.println("<a href=\"" + string4 + "\">" + Coverage.escapeText(string.trim()) + "</a>");
                    File file4 = new File(file2.getParent() + "/" + string4);
                    String[][] stringArray2 = new String[stringArray.length + 1][2];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length][0] = file2.getName();
                    stringArray2[stringArray.length][1] = file.getName();
                    this.createSourceHtmlFile(file3, coverageCopyStatement.copyIndex, file4, coverageProgram, map, stringArray2, set);
                } else {
                    printStream.println(Coverage.escapeText(string));
                }
            }
            ++n3;
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        printStream.println("      </pre>");
        printStream.println("   </body>");
        printStream.println("</html>");
        printStream.close();
    }

    private static String escapeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        block9: for (int i2 = 0; i2 < cArray.length; ++i2) {
            switch (cArray[i2]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\u20ac': {
                    stringBuffer.append("&euro;");
                    continue block9;
                }
                case '\u00a0': {
                    stringBuffer.append("&nbsp;");
                    continue block9;
                }
                case ' ': {
                    stringBuffer.append(cArray[i2]);
                    continue block9;
                }
                default: {
                    stringBuffer.append(cArray[i2]);
                }
            }
        }
        return stringBuffer.toString();
    }

    private File findSourceFile(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            return file;
        }
        if (file.isAbsolute()) {
            return this.findSourceFile0(file.getName());
        }
        File file2 = this.findSourceFile0(string);
        if (file2 != null) {
            return file2;
        }
        return this.findSourceFile0(file.getName());
    }

    private File findSourceFile0(String string) {
        if (this.sourcePaths != null) {
            for (File file : this.sourcePaths) {
                File file2 = new File(file.getAbsolutePath() + "/" + string);
                if (!file2.exists() || !file2.isFile()) continue;
                return file2;
            }
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        int n2;
        Coverage coverage = Coverage.getSharedInstance("coverage", 1);
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < stringArray.length && !stringArray[n2].equals("--runargs"); ++n2) {
            if ("--classfiles".equals(stringArray[n2])) {
                coverage.setClassfiles(stringArray[++n2]);
                continue;
            }
            if ("--sourcefiles".equals(stringArray[n2])) {
                coverage.setSourcefiles(stringArray[++n2]);
                continue;
            }
            if ("--html".equals(stringArray[n2])) {
                coverage.htmlDir = new File(stringArray[++n2]);
                continue;
            }
            if ("--xml".equals(stringArray[n2])) {
                coverage.xmlFile = new File(stringArray[++n2]);
                continue;
            }
            if ("--includes".equals(stringArray[n2])) {
                coverage.setIncludes(stringArray[++n2]);
                continue;
            }
            if ("--excludes".equals(stringArray[n2])) {
                coverage.setExcludes(stringArray[++n2]);
                continue;
            }
            if ("--append".equals(stringArray[n2])) {
                coverage.setAppend(stringArray[++n2]);
                continue;
            }
            if ("--sessionname".equals(stringArray[n2])) {
                coverage.sessionTitle = stringArray[++n2];
                continue;
            }
            if ("--profiler".equals(stringArray[n2])) {
                bl = true;
                continue;
            }
            if ("--coverage".equals(stringArray[n2])) {
                bl2 = true;
                continue;
            }
            if ("--profilerincludes".equals(stringArray[n2])) {
                string3 = stringArray[++n2];
                continue;
            }
            if ("--profilerexcludes".equals(stringArray[n2])) {
                string4 = stringArray[++n2];
                continue;
            }
            if ("--profilerxml".equals(stringArray[n2])) {
                string2 = stringArray[++n2];
                continue;
            }
            if (!"--profilerhtml".equals(stringArray[n2])) continue;
            string = stringArray[++n2];
        }
        if (!bl2 && !bl) {
            coverage.coverage = true;
        } else {
            coverage.coverage = bl2;
            coverage.profile = bl;
        }
        if (coverage.profile) {
            coverage.startProfileSession(string3, string4, string, string2);
        }
        coverage.intStartSession();
        String[] stringArray2 = new String[stringArray.length - ++n2];
        System.arraycopy(stringArray, n2, stringArray2, 0, stringArray2.length);
        Class.forName("com.iscobol.invoke.Isrun").getMethod("main", String[].class).invoke(null, new Object[]{stringArray2});
    }

    private static String getUnivoqueName(Set<String> set, String string, String string2) {
        String string3 = string + string2;
        int n2 = 0;
        while (set.contains(string3)) {
            string3 = string + "_" + ++n2 + string2;
        }
        set.add(string3);
        return string3;
    }

    private byte[] instrumentClass(MyClass myClass, byte[] byArray, String string, int n2, ClassLoader classLoader) throws Throwable {
        if (Coverage.isCoverage(n2)) {
            byArray = this.instrumenter.instrument(byArray, string);
        }
        if (Coverage.isProfile(n2)) {
            MyClass myClass2 = null;
            if (myClass.isAssignableTo(iscobolModule) || (myClass2 = myClass.getEnclosingClass()) != null && myClass.getName().matches(".+\\$\\d*inner_\\d+")) {
                boolean bl = (myClass2 != null ? myClass2 : myClass).isAssignableTo(iscobolDebugger);
                byArray = this.profiler.getTransformer().transformBytes(byArray, classLoader, bl);
            }
        }
        return byArray;
    }

    private static boolean isCoverage(int n2) {
        return (n2 & 1) == 1;
    }

    private static boolean isProfile(int n2) {
        return (n2 & 2) == 2;
    }

    private static String percFormat(double d2) {
        String string = percFormat.format(d2);
        int n2 = 7 - string.length();
        if (n2 > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append("&nbsp;");
                stringBuilder.append("&nbsp;");
            }
            stringBuilder.append(string);
            string = stringBuilder.toString();
        }
        return string;
    }

    public void loadResources() {
        this.resourcesStream = new HashMap<String, byte[]>();
        for (String string : resources) {
            try {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/iscobol/coverage/resources/" + string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                int n2 = inputStream.read(byArray);
                while (n2 >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                    n2 = inputStream.read(byArray);
                }
                inputStream.close();
                byteArrayOutputStream.close();
                this.resourcesStream.put(string, byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void createResources() throws IOException {
        this.createResources(null);
    }

    @Override
    public void createResources(String string) throws IOException {
        if (string != null) {
            this.htmlDir = new File(string);
            if (this.htmlDir == null) {
                return;
            }
        }
        File file = new File(this.htmlDir.getAbsolutePath() + "/resources");
        file.mkdir();
        if (this.resourcesStream == null) {
            this.loadResources();
        }
        for (String string2 : this.resourcesStream.keySet()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file.getAbsolutePath() + "/" + string2));
                ((OutputStream)fileOutputStream).write(this.resourcesStream.get(string2));
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static byte[] readBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n2 = inputStream.read(byArray);
        while (n2 >= 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void set(String[] stringArray, File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if ("xml".equalsIgnoreCase(stringArray[i2])) {
                this.xmlFile = fileArray[i2];
                continue;
            }
            if ("html".equalsIgnoreCase(stringArray[i2])) {
                this.htmlDir = fileArray[i2];
                continue;
            }
            if (!"append".equalsIgnoreCase(stringArray[i2]) || fileArray[i2] == null) continue;
            arrayList.add(fileArray[i2]);
        }
        if (!arrayList.isEmpty()) {
            this.xmlAppend = arrayList.toArray(new File[arrayList.size()]);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.coverage;
    }

    public static int coverageFlush() {
        Coverage coverage = Coverage.getCoverage();
        if (coverage != null) {
            if (coverage.shutdownAndPrintReports()) {
                try {
                    coverage.startup(true);
                    return 0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return 2;
                }
            }
            return 2;
        }
        return 1;
    }

    public static int coverageSet(String[] stringArray, File[] fileArray) {
        Coverage coverage = Coverage.getCoverage();
        if (coverage != null) {
            coverage.set(stringArray, fileArray);
            return 0;
        }
        return 1;
    }

    public static Coverage getCoverage() {
        return sharedInstance;
    }

    public static Coverage getSharedInstance(String string, File file, File file2, String string2, String string3, String string4, String string5, String string6) {
        if (sharedInstance == null) {
            Coverage coverage = new Coverage(string, file, file2, string2, string3, string4, string5, string6);
            try {
                coverage.startup(false);
                coverage.setTransformer(new Transformer(coverage));
                sharedInstance = coverage;
                IscobolSystem.setCoverage(sharedInstance);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return sharedInstance;
    }

    public static Coverage getSharedInstance(String string, int n2) {
        if (sharedInstance == null) {
            Coverage coverage;
            sharedInstance = coverage = new Coverage(string, n2);
            IscobolSystem.setCoverage(sharedInstance);
        }
        return sharedInstance;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    static {
        Class<Object> clazz;
        dateFormat = DateFormat.getDateTimeInstance(1, 2);
        calendar = Calendar.getInstance();
        resources = new String[]{"down.gif", "greenbar.gif", "paragraph.gif", "prettify.css", "prettify.js", "program.gif", "redbar.gif", "report.css", "report.gif", "sort.gif", "sort.js", "up.gif"};
        iscobolCall = IscobolCall.class;
        iscobolClass = IscobolClass.class;
        iscobolModule = IscobolModule.class;
        percFormat = NumberFormat.getPercentInstance();
        percFormat.setMinimumFractionDigits(2);
        intFormat = NumberFormat.getIntegerInstance();
        try {
            clazz = Class.forName("com.iscobol.debugger.IscobolDebugger");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Object.class;
        }
        iscobolDebugger = clazz;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("com.iscobol.lib");
        hashSet.add("com.iscobol.lib_n");
        hashSet.add("com.iscobol.so");
        hashSet.add("com.iscobol.son");
        invalidPackageNames = Collections.unmodifiableSet(hashSet);
    }

    private static class ClassLocation {
        final String location;
        final Map<String, ClassDef> definitions = new HashMap<String, ClassDef>();
        final Map<String, ClassDef> originals = new HashMap<String, ClassDef>();
        MemoryClassLoader memoryCL;

        ClassLocation(String string) {
            this.location = string;
        }
    }

    private static class ProgramComparator
    implements Comparator<CoverageProgram> {
        int colIdx;

        ProgramComparator(int n2) {
            this.colIdx = n2;
        }

        @Override
        public int compare(CoverageProgram coverageProgram, CoverageProgram coverageProgram2) {
            switch (this.colIdx) {
                default: {
                    return coverageProgram.name.compareTo(coverageProgram2.name);
                }
                case 1: {
                    double d2 = coverageProgram.getStatementCoverageRatio() - coverageProgram2.getStatementCoverageRatio();
                    return d2 > 0.0 ? 1 : (d2 < 0.0 ? -1 : 0);
                }
                case 2: {
                    return coverageProgram.getTotalStatements() - coverageProgram.getMissedStatements() - coverageProgram2.getTotalStatements() + coverageProgram2.getMissedStatements();
                }
                case 3: {
                    return coverageProgram.getMissedStatements() - coverageProgram2.getMissedStatements();
                }
                case 4: {
                    return coverageProgram.getTotalStatements() - coverageProgram2.getTotalStatements();
                }
                case 5: {
                    double d3 = coverageProgram.getParagraphCoverageRatio() - coverageProgram2.getParagraphCoverageRatio();
                    return d3 > 0.0 ? 1 : (d3 < 0.0 ? -1 : 0);
                }
                case 6: {
                    return coverageProgram.getTotalParagraphs() - coverageProgram.getMissedParagraphs() - coverageProgram2.getTotalParagraphs() + coverageProgram2.getMissedParagraphs();
                }
                case 7: {
                    return coverageProgram.getMissedParagraphs() - coverageProgram2.getMissedParagraphs();
                }
                case 8: 
            }
            return coverageProgram.getTotalParagraphs() - coverageProgram2.getTotalParagraphs();
        }
    }

    private static class ParagraphComparator
    implements Comparator<CoverageParagraph> {
        int colIdx;

        ParagraphComparator(int n2) {
            this.colIdx = n2;
        }

        @Override
        public int compare(CoverageParagraph coverageParagraph, CoverageParagraph coverageParagraph2) {
            switch (this.colIdx) {
                default: {
                    return coverageParagraph.name.compareTo(coverageParagraph2.name);
                }
                case 1: {
                    double d2 = coverageParagraph.getStatementCoverageRatio() - coverageParagraph2.getStatementCoverageRatio();
                    return d2 > 0.0 ? 1 : (d2 < 0.0 ? -1 : 0);
                }
                case 2: {
                    return coverageParagraph.getTotalStatements() - coverageParagraph.getMissedStatements() - coverageParagraph2.getTotalStatements() + coverageParagraph2.getMissedStatements();
                }
                case 3: {
                    return coverageParagraph.getMissedStatements() - coverageParagraph2.getMissedStatements();
                }
                case 4: 
            }
            return coverageParagraph.getTotalStatements() - coverageParagraph2.getTotalStatements();
        }
    }

    private static class MyClass {
        private static ClassPool classPool;
        CtClass ctc;
        Class cl;

        static ClassPool getClassPool() {
            if (classPool == null) {
                classPool = ClassPool.getDefault();
                try {
                    classPool.get(Coverage.class.getName());
                }
                catch (Exception exception) {
                    ClassLoader classLoader = classPool.getClassLoader();
                    classPool = new ClassPool(classPool);
                    classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
                }
            }
            return classPool;
        }

        MyClass(Class clazz) {
            this.cl = clazz;
        }

        MyClass(byte[] byArray) throws IOException {
            this(MyClass.getClassPool().makeClass((InputStream)new ByteArrayInputStream(byArray)));
        }

        MyClass(CtClass ctClass) {
            this.ctc = ctClass;
        }

        String getName() {
            return this.cl != null ? this.cl.getName() : this.ctc.getName();
        }

        boolean isInterface() {
            return this.cl != null ? this.cl.isInterface() : this.ctc.isInterface();
        }

        String getPackageName() {
            if (this.cl != null) {
                Package package_ = this.cl.getPackage();
                return package_ != null ? package_.getName() : null;
            }
            return this.ctc.getPackageName();
        }

        boolean isAssignableTo(Class clazz) {
            return this.cl != null ? clazz.isAssignableFrom(this.cl) : this.Implements(clazz.getName());
        }

        boolean Implements(String string) {
            try {
                for (CtClass ctClass : this.ctc.getInterfaces()) {
                    if (!string.equals(ctClass.getName())) continue;
                    return true;
                }
            }
            catch (NotFoundException notFoundException) {
                notFoundException.printStackTrace();
            }
            return false;
        }

        File getLocation() {
            if (this.cl == null) {
                return null;
            }
            URL uRL = this.cl.getProtectionDomain().getCodeSource().getLocation();
            try {
                return new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return new File(uRL.getPath());
            }
        }

        MyClass getEnclosingClass() {
            if (this.cl != null) {
                Class<?> clazz = this.cl.getEnclosingClass();
                return clazz != null ? new MyClass(clazz) : null;
            }
            try {
                CtClass ctClass = this.ctc.getDeclaringClass();
                return ctClass != null ? new MyClass(ctClass) : null;
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
        }

        void detach() {
            if (this.ctc != null) {
                this.ctc.detach();
            }
        }
    }

    private static class ClassDef {
        final MyClass cl;
        final byte[] bytes;
        boolean reset;
        CoverageProgram program;
        SMAPReader sr;

        ClassDef(MyClass myClass, byte[] byArray) {
            this.cl = myClass;
            this.bytes = byArray;
        }

        public String toString() {
            return this.cl.getName();
        }
    }

    private class MemoryClassLoader
    extends ClassLoader
    implements ICoverageClassLoader {
        private final CLWrapper wrapper;
        private final String location;

        MemoryClassLoader(String string) {
            super(null);
            this.wrapper = new CLWrapper(Coverage.class.getClassLoader());
            this.location = string;
            if (IscobolSystem.isUnitTest()) {
                this.setDefaultAssertionStatus(true);
            }
        }

        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            return Coverage.this.loadClass(this.location, string, bl, this.wrapper);
        }

        public Class DefineClass(String string, byte[] byArray, int n2, int n3) throws ClassFormatError {
            return super.defineClass(string, byArray, n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getOriginalBytes(String string) {
            ClassLocation classLocation;
            Object object = this;
            synchronized (object) {
                classLocation = (ClassLocation)Coverage.this.classLocations.get(this.location);
            }
            if (classLocation != null && (object = classLocation.originals.get(string)) != null) {
                return ((ClassDef)object).bytes;
            }
            return null;
        }
    }

    private static class CLWrapper
    extends ClassLoader {
        CLWrapper(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class LoadClass(String string, boolean bl) throws ClassNotFoundException {
            return super.loadClass(string, bl);
        }
    }
}

