/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.CoverageElement;
import com.iscobol.coverage.CoverageStatement;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class CoverageParagraph
extends CoverageElement {
    private Map<CoverageStatement, CoverageStatement> statements = new TreeMap<CoverageStatement, CoverageStatement>();
    public String name;

    public CoverageStatement getStatement(CoverageStatement coverageStatement) {
        return this.statements.get(coverageStatement);
    }

    public CoverageStatement removeStatement(CoverageStatement coverageStatement) {
        return this.statements.remove(coverageStatement);
    }

    public Collection<CoverageStatement> getStatements() {
        return this.statements.values();
    }

    public void addStatement(CoverageStatement coverageStatement) {
        this.statements.put(coverageStatement, coverageStatement);
    }

    public int getTotalStatements() {
        return this.statements.size();
    }

    public int getMissedStatements() {
        if ("red".equals(this.color)) {
            return this.getTotalStatements();
        }
        Collection<CoverageStatement> collection = this.getStatements();
        int n2 = 0;
        for (CoverageStatement coverageStatement : collection) {
            if (!"red".equals(coverageStatement.color)) continue;
            ++n2;
        }
        return n2;
    }

    public double getStatementCoverageRatio() {
        int n2 = this.getMissedStatements();
        int n3 = this.getTotalStatements();
        double d2 = 0.0;
        if (n3 > 0) {
            d2 = 1.0 - (double)n2 / (double)n3;
        }
        return d2;
    }
}

