/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.CoverageCopyStatement;
import com.iscobol.coverage.CoverageElement;
import com.iscobol.coverage.CoverageParagraph;
import com.iscobol.coverage.CoverageStatement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class CoverageProgram
extends CoverageElement {
    private LinkedHashMap<String, CoverageParagraph> paragraphs = new LinkedHashMap();
    private Map<CoverageStatement, CoverageCopyStatement> copyStatements = new TreeMap<CoverageStatement, CoverageCopyStatement>();
    public String name;
    public String fileName;
    public String location = "";

    public int getTotalParagraphs() {
        return this.paragraphs.size();
    }

    public Collection<CoverageParagraph> getParagraphs() {
        return this.paragraphs.values();
    }

    public void addParagraph(CoverageParagraph coverageParagraph) {
        this.paragraphs.put(coverageParagraph.name, coverageParagraph);
    }

    public CoverageParagraph getParagraph(String string) {
        return this.paragraphs.get(string);
    }

    public CoverageParagraph removeParagraph(String string) {
        return (CoverageParagraph)this.paragraphs.remove(string);
    }

    public CoverageCopyStatement getCopyStatement(CoverageStatement coverageStatement) {
        return this.copyStatements.get(coverageStatement);
    }

    public CoverageCopyStatement removeCopyStatement(CoverageCopyStatement coverageCopyStatement) {
        return this.copyStatements.remove(coverageCopyStatement);
    }

    public Collection<CoverageCopyStatement> getCopyStatements() {
        return this.copyStatements.values();
    }

    public void addCopyStatement(CoverageCopyStatement coverageCopyStatement) {
        this.copyStatements.put(coverageCopyStatement, coverageCopyStatement);
    }

    public int getMissedParagraphs() {
        Collection<CoverageParagraph> collection = this.getParagraphs();
        int n2 = 0;
        for (CoverageParagraph coverageParagraph : collection) {
            if (!"red".equals(coverageParagraph.color)) continue;
            ++n2;
        }
        return n2;
    }

    public int getTotalStatements() {
        Collection<CoverageParagraph> collection = this.getParagraphs();
        int n2 = 0;
        for (CoverageParagraph coverageParagraph : collection) {
            n2 += coverageParagraph.getTotalStatements();
        }
        return n2;
    }

    public int getMissedStatements() {
        Collection<CoverageParagraph> collection = this.getParagraphs();
        int n2 = 0;
        for (CoverageParagraph coverageParagraph : collection) {
            n2 += coverageParagraph.getMissedStatements();
        }
        return n2;
    }

    public double getStatementCoverageRatio() {
        int n2 = this.getMissedStatements();
        int n3 = this.getTotalStatements();
        double d2 = 0.0;
        if (n3 > 0) {
            d2 = 1.0 - (double)n2 / (double)n3;
        }
        return d2;
    }

    public double getParagraphCoverageRatio() {
        int n2 = this.getMissedParagraphs();
        int n3 = this.getTotalParagraphs();
        double d2 = 0.0;
        if (n3 > 0) {
            d2 = 1.0 - (double)n2 / (double)n3;
        }
        return d2;
    }
}

