/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.CoverageProgram;
import java.util.Collection;
import java.util.LinkedHashMap;

public class CoverageSession {
    private LinkedHashMap<String, CoverageProgram> programs = new LinkedHashMap();
    private LinkedHashMap<Long, Name> appended = new LinkedHashMap();
    public Name name = new Name();

    public Collection<CoverageProgram> getPrograms() {
        return this.programs.values();
    }

    public void addProgram(CoverageProgram coverageProgram) {
        this.programs.put(coverageProgram.name, coverageProgram);
    }

    public CoverageProgram getProgram(String string) {
        return this.programs.get(string);
    }

    public CoverageProgram removeProgram(String string) {
        return (CoverageProgram)this.programs.remove(string);
    }

    public Collection<Name> getAppended() {
        return this.appended.values();
    }

    public void addAppend(Name name) {
        this.appended.put(name.timestamp, name);
    }

    public Name getAppend(long l2) {
        return this.appended.get(l2);
    }

    public Name removeAppend(long l2) {
        return (Name)this.appended.remove(l2);
    }

    public int getTotalParagraphs() {
        Collection<CoverageProgram> collection = this.getPrograms();
        int n2 = 0;
        for (CoverageProgram coverageProgram : collection) {
            n2 += coverageProgram.getTotalParagraphs();
        }
        return n2;
    }

    public int getMissedParagraphs() {
        Collection<CoverageProgram> collection = this.getPrograms();
        int n2 = 0;
        for (CoverageProgram coverageProgram : collection) {
            n2 += coverageProgram.getMissedParagraphs();
        }
        return n2;
    }

    public int getTotalStatements() {
        Collection<CoverageProgram> collection = this.getPrograms();
        int n2 = 0;
        for (CoverageProgram coverageProgram : collection) {
            n2 += coverageProgram.getTotalStatements();
        }
        return n2;
    }

    public int getMissedStatements() {
        Collection<CoverageProgram> collection = this.getPrograms();
        int n2 = 0;
        for (CoverageProgram coverageProgram : collection) {
            n2 += coverageProgram.getMissedStatements();
        }
        return n2;
    }

    public double getStatementCoverageRatio() {
        int n2 = this.getMissedStatements();
        int n3 = this.getTotalStatements();
        double d2 = 0.0;
        if (n3 > 0) {
            d2 = 1.0 - (double)n2 / (double)n3;
        }
        return d2;
    }

    public double getParagraphCoverageRatio() {
        int n2 = this.getMissedParagraphs();
        int n3 = this.getTotalParagraphs();
        double d2 = 0.0;
        if (n3 > 0) {
            d2 = 1.0 - (double)n2 / (double)n3;
        }
        return d2;
    }

    public static class Name {
        public long timestamp;
        public String name;
    }
}

