/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.Expression;
import com.iscobol.interfaces.debugger.IBreakpoint;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;

public class Breakpoint
implements DataExternalizable,
IBreakpoint {
    private static final long serialVersionUID = 1000006L;
    private int lineNumber;
    private String cobolFile;
    private int cobolFileIndex;
    private String paragraph;
    private String progName;
    private Expression condition;
    private boolean enabled = true;
    private boolean programBreakpoint;
    private String methodName;
    private boolean fromCobolRef;

    public Breakpoint() {
    }

    public Breakpoint(CobolRef cobolRef) {
        this.lineNumber = cobolRef.lineNo();
        this.cobolFile = cobolRef.filename();
        this.progName = cobolRef.progname();
        this.setFileIndex(cobolRef.getFileIndex());
        this.fromCobolRef = true;
    }

    public Breakpoint(int n2, String string, int n3, String string2, boolean bl) {
        this.lineNumber = n2;
        this.cobolFile = string;
        this.progName = string2;
        this.enabled = bl;
        this.setFileIndex(n3);
    }

    public Breakpoint(int n2, String string, int n3, String string2, Expression expression, boolean bl) {
        this.lineNumber = n2;
        this.cobolFile = string;
        this.progName = string2;
        this.enabled = bl;
        this.setFileIndex(n3);
        this.condition = expression;
    }

    public Breakpoint(String string, String string2, String string3, boolean bl) {
        this.paragraph = string;
        this.cobolFile = string2;
        this.progName = string3;
        this.enabled = bl;
    }

    public Breakpoint(String string, String string2, String string3, Expression expression, boolean bl) {
        this(string, 0, string2, 0, string3, expression, bl);
    }

    public Breakpoint(String string, int n2, String string2, int n3, String string3, Expression expression, boolean bl) {
        this.paragraph = string;
        this.lineNumber = n2;
        this.cobolFile = string2;
        this.progName = string3;
        this.enabled = bl;
        this.setFileIndex(n3);
        this.condition = expression;
    }

    private void setFileIndex(int n2) {
        this.cobolFileIndex = n2;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public String getParagraph() {
        return this.paragraph;
    }

    @Override
    public String getFile() {
        return this.cobolFile;
    }

    @Override
    public String getProgram() {
        return this.progName;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public int getFileIndex() {
        return this.cobolFileIndex;
    }

    public boolean isProgramBreakpoint() {
        return this.programBreakpoint;
    }

    public void setProgramBreakpoint(boolean bl) {
        this.programBreakpoint = bl;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Breakpoint)) {
            return false;
        }
        Breakpoint breakpoint = (Breakpoint)object;
        if (!(this.fromCobolRef || breakpoint.fromCobolRef || this.paragraph == null && breakpoint.paragraph == null)) {
            if (this.paragraph == null || breakpoint.paragraph == null) {
                return false;
            }
            if (!this.paragraph.equalsIgnoreCase(breakpoint.paragraph)) {
                return false;
            }
        } else if (this.lineNumber != breakpoint.lineNumber) {
            return false;
        }
        if (!Breakpoint.getBasename(this.cobolFile).equalsIgnoreCase(Breakpoint.getBasename(breakpoint.cobolFile))) {
            return false;
        }
        if (this.cobolFileIndex != breakpoint.cobolFileIndex && this.cobolFileIndex >= 0 && breakpoint.cobolFileIndex >= 0) {
            return false;
        }
        if (this.progName == null || breakpoint.progName == null) {
            return true;
        }
        return this.progName.equals(breakpoint.progName);
    }

    private static String getBasename(String string) {
        if (string == null) {
            return string;
        }
        return new File(string).getName();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.programBreakpoint) {
            stringBuffer.append("[program: " + this.progName);
        } else if (this.methodName != null) {
            stringBuffer.append("[method: " + this.methodName);
        } else {
            if (this.lineNumber > 0) {
                stringBuffer.append("[line: " + this.lineNumber);
            } else {
                stringBuffer.append("[paragraph: " + this.paragraph);
            }
            stringBuffer.append(", file: " + this.cobolFile);
            if (this.cobolFileIndex > 0) {
                stringBuffer.append(", index: " + this.cobolFileIndex);
            }
        }
        if (this.condition != null) {
            stringBuffer.append(". ").append("when");
            if (this.condition.isEnvProperty()) {
                stringBuffer.append(" ").append("-env");
            } else if (this.condition.isHex()) {
                stringBuffer.append(" ").append("-x");
            }
            stringBuffer.append(" ");
            stringBuffer.append(this.condition);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public String getDebugCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.programBreakpoint) {
            stringBuffer.append("b0");
            if (!this.enabled) {
                stringBuffer.append(" -d ");
            }
            stringBuffer.append(" " + this.progName);
        } else if (this.methodName != null) {
            stringBuffer.append("m0");
            if (!this.enabled) {
                stringBuffer.append(" -d ");
            }
            stringBuffer.append(" " + this.methodName);
        } else {
            stringBuffer.append("break");
            if (!this.enabled) {
                stringBuffer.append(" -d ");
            }
            if (this.paragraph != null) {
                stringBuffer.append(" " + this.paragraph);
            } else {
                stringBuffer.append(" " + this.lineNumber);
            }
            stringBuffer.append(" \"" + this.cobolFile + "\"");
            if (this.cobolFileIndex >= 0) {
                stringBuffer.append(" -fi " + this.cobolFileIndex);
            }
            if (this.progName != null) {
                stringBuffer.append(" " + this.progName);
            }
            if (this.condition != null) {
                stringBuffer.append(" ").append("when");
                if (this.condition.isEnvProperty()) {
                    stringBuffer.append(" ").append("-env");
                } else if (this.condition.isHex()) {
                    stringBuffer.append(" ").append("-x");
                }
                stringBuffer.append(" ").append(this.condition);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.lineNumber);
        RtsUtil.writeUTFOptmz(this.cobolFile, dataOutput);
        dataOutput.writeInt(this.cobolFileIndex);
        RtsUtil.writeUTFOptmz(this.paragraph, dataOutput);
        RtsUtil.writeUTFOptmz(this.progName, dataOutput);
        dataOutput.writeBoolean(this.enabled);
        dataOutput.writeBoolean(this.programBreakpoint);
        RtsUtil.writeUTFOptmz(this.methodName, dataOutput);
        dataOutput.writeBoolean(this.condition != null);
        if (this.condition != null) {
            this.condition.writeExternal(dataOutput);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.lineNumber = dataInput.readInt();
        this.cobolFile = RtsUtil.readUTFOptmz(dataInput);
        this.cobolFileIndex = dataInput.readInt();
        this.paragraph = RtsUtil.readUTFOptmz(dataInput);
        this.progName = RtsUtil.readUTFOptmz(dataInput);
        this.enabled = dataInput.readBoolean();
        this.programBreakpoint = dataInput.readBoolean();
        this.methodName = RtsUtil.readUTFOptmz(dataInput);
        if (dataInput.readBoolean()) {
            this.condition = new Expression();
            this.condition.readExternal(dataInput);
        } else {
            this.condition = null;
        }
    }
}

