/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.Condition;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.rts.INumericVar;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class BreakpointManager {
    protected static final String EXTERNAL_KEY = "external";
    private static Map<String, Vector<Breakpoint>> breakpoints = new LinkedHashMap<String, Vector<Breakpoint>>();
    private static Map<String, Watch> monitors = new LinkedHashMap<String, Watch>();
    private static Map<String, Map<String, Watch>> monitorToAdd = new LinkedHashMap<String, Map<String, Watch>>();
    private static Breakpoint temporary = null;
    private static Breakpoint jump = null;

    private static String getKey(String string, String string2) {
        return new File(string.toLowerCase()).getName() + "$" + string2;
    }

    public static void addTempBreakpoint(int n2, String string, int n3) {
        temporary = new Breakpoint(n2, string, n3, null, true);
    }

    public static void addJumppoint(int n2, String string, int n3) {
        jump = new Breakpoint(n2, string, n3, null, true);
    }

    public static void addJumppoint(String string, String string2) {
        jump = new Breakpoint(string, string2, null, true);
    }

    public static boolean checkTempBreakpoint(int n2, String string, int n3) {
        if (temporary != null && temporary.equals(new Breakpoint(n2, string, n3, null, true))) {
            temporary = null;
            return true;
        }
        return false;
    }

    public static boolean checkJumppoint(int n2, String string, int n3) {
        if (jump != null && jump.equals(new Breakpoint(n2, string, n3, null, true))) {
            jump = null;
            return true;
        }
        return false;
    }

    public static boolean checkJumppoint(String string, String string2) {
        if (jump != null && jump.equals(new Breakpoint(string, string2, null, true))) {
            jump = null;
            return true;
        }
        return false;
    }

    public static Breakpoint addBreakpoint(int n2, String string, int n3, String string2, boolean bl) {
        return BreakpointManager.addBreakpoint(n2, string, n3, string2, null, bl);
    }

    public static Breakpoint addBreakpoint(int n2, String string, int n3, String string2, Expression expression, boolean bl) {
        String string3 = BreakpointManager.getKey(string, "" + n2);
        Vector<Breakpoint> vector = breakpoints.get(string3);
        if (vector == null) {
            vector = new Vector();
        }
        Breakpoint breakpoint = new Breakpoint(n2, string, n3, string2, expression, bl);
        for (Breakpoint breakpoint2 : vector) {
            if (!breakpoint2.equals(breakpoint)) continue;
            vector.removeElement(breakpoint2);
            break;
        }
        vector.addElement(breakpoint);
        breakpoints.put(string3, vector);
        return breakpoint;
    }

    public static Breakpoint addBreakpoint(String string, int n2, String string2, int n3, String string3, Expression expression, boolean bl) {
        String string4 = BreakpointManager.getKey(string2, string.toLowerCase());
        Vector<Breakpoint> vector = breakpoints.get(string4);
        if (vector == null) {
            vector = new Vector();
        }
        Breakpoint breakpoint = new Breakpoint(string, n2, string2, n3, string3, expression, bl);
        for (Breakpoint breakpoint2 : vector) {
            if (!breakpoint2.equals(breakpoint)) continue;
            vector.removeElement(breakpoint2);
            break;
        }
        vector.addElement(breakpoint);
        breakpoints.put(string4, vector);
        return breakpoint;
    }

    public static Breakpoint removeBreakpoint(int n2, String string, int n3, String string2) {
        return BreakpointManager.intRemoveBreakpoint(BreakpointManager.getKey(string, "" + n2), new Breakpoint(n2, string, n3, string2, true));
    }

    public static Breakpoint removeBreakpoint(String string, String string2, String string3) {
        return BreakpointManager.intRemoveBreakpoint(BreakpointManager.getKey(string2, string.toLowerCase()), new Breakpoint(string, string2, string3, true));
    }

    private static Breakpoint intRemoveBreakpoint(String string, Breakpoint breakpoint) {
        Vector<Breakpoint> vector = breakpoints.get(string);
        if (vector == null) {
            return null;
        }
        Enumeration<Breakpoint> enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Breakpoint breakpoint2 = enumeration.nextElement();
            if (breakpoint2.equals(breakpoint)) {
                vector.removeElementAt(n2);
                if (vector.isEmpty()) {
                    breakpoints.remove(string);
                }
                return breakpoint2;
            }
            ++n2;
        }
        return null;
    }

    public static boolean checkBreakpoint(int n2, String string, int n3, String string2, Debugger debugger) {
        return BreakpointManager.intCheckBreakpoint(BreakpointManager.getKey(string, "" + n2), new Breakpoint(n2, string, n3, string2, true), debugger);
    }

    public static boolean checkBreakpoint(String string, String string2, String string3, Debugger debugger) {
        return BreakpointManager.intCheckBreakpoint(BreakpointManager.getKey(string2, string.toLowerCase()), new Breakpoint(string, string2, string3, true), debugger);
    }

    private static boolean intCheckBreakpoint(String string, Breakpoint breakpoint, Debugger debugger) {
        Vector<Breakpoint> vector = breakpoints.get(string);
        if (vector == null) {
            return false;
        }
        for (Breakpoint breakpoint2 : vector) {
            if (!breakpoint2.isEnabled() || !breakpoint2.equals(breakpoint)) continue;
            Expression expression = breakpoint2.getCondition();
            if (expression != null) {
                try {
                    Object object = expression.evaluate(debugger, false, expression.isHex());
                    return object instanceof Boolean && (Boolean)object != false;
                }
                catch (DebuggerException debuggerException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void removeAllBreakpoints() {
        breakpoints.clear();
    }

    public static void setMonitorToAdd(String string, VarName varName, Condition condition, String string2, boolean bl, boolean bl2) {
        BreakpointManager.removeMonitor(string, varName.getFullName(), string2);
        Map<String, Watch> map = monitorToAdd.get(string);
        if (map == null) {
            map = new LinkedHashMap<String, Watch>();
            monitorToAdd.put(string, map);
        }
        map.put(BreakpointManager.buildMonitorKey(varName.getFullName(), string, string2), new Watch(varName, null, condition, string, string2, bl, bl2));
    }

    public static Watch[] getMonitorToAdd(String string) {
        Map<String, Watch> map = monitorToAdd.get(string);
        if (map == null) {
            return new Watch[0];
        }
        return map.values().toArray(new Watch[map.size()]);
    }

    public static void addEnvMonitor(String string, String string2, Condition condition, boolean bl) {
        String string3 = "ENV$$" + string.toUpperCase();
        monitors.put(string3, new Watch(string, string2, condition, bl));
    }

    public static boolean removeEnvMonitor(String string) {
        String string2 = "ENV$$" + string.toUpperCase();
        return monitors.remove(string2) != null;
    }

    public static void addMonitor(VarName varName, Debugger.IscobolField iscobolField, Object object, String string, Condition condition, String string2, boolean bl, boolean bl2) {
        monitors.put(BreakpointManager.buildMonitorKey(string, string2, null), new Watch(varName, iscobolField, object, string, condition, string2, bl, bl2));
    }

    public static void addMonitor(INumericVar iNumericVar, String string, Condition condition, String string2, String string3, String string4, boolean bl, boolean bl2) {
        monitors.put(BreakpointManager.buildMonitorKey(string, string2, string3), new Watch(iNumericVar, string, condition, string2, string3, string4, bl, bl2));
    }

    private static boolean intRemoveMonitor(String string, String string2, String string3) {
        return monitors.remove(BreakpointManager.buildMonitorKey(string, string2, string3)) != null;
    }

    private static String buildMonitorKey(String string, String string2, String string3) {
        String string4 = string.toUpperCase() + "@" + string2;
        if (string3 != null) {
            string4 = string4 + "::" + string3.toUpperCase();
        }
        return string4;
    }

    public static void removeMonitorToAdd(String string) {
        monitorToAdd.remove(string);
    }

    public static boolean removeMonitor(String string, String string2, String string3) {
        if (BreakpointManager.intRemoveMonitor(string2, string, string3)) {
            return true;
        }
        Map<String, Watch> map = monitorToAdd.get(string);
        if (map != null) {
            map.remove(BreakpointManager.buildMonitorKey(string2, string, string3));
        }
        return false;
    }

    public static Watch[] getMonitors(Debugger debugger) {
        return BreakpointManager.getMonitors(null, debugger);
    }

    public static Watch[] getMonitors(String string, Debugger debugger) {
        Watch[] watchArray = BreakpointManager.checkMonitors(string, true, debugger);
        if (watchArray != null) {
            for (int i2 = 0; i2 < watchArray.length; ++i2) {
                Debugger.IscobolField iscobolField = watchArray[i2].getField();
                if (iscobolField != null) {
                    watchArray[i2].refresh(debugger, iscobolField, false);
                    continue;
                }
                VarName varName = watchArray[i2].getVarName();
                if (varName != null) {
                    try {
                        iscobolField = debugger.findVar(varName, false);
                    }
                    catch (DebuggerException debuggerException) {
                        // empty catch block
                    }
                }
                watchArray[i2].refresh(debugger, iscobolField, true);
            }
        }
        return watchArray;
    }

    public static Watch[] checkBreakMonitors(String string, Debugger debugger) {
        return BreakpointManager.checkMonitors(string, false, debugger);
    }

    private static Watch[] checkMonitors(String string, boolean bl, Debugger debugger) {
        Vector<Watch> vector = new Vector<Watch>();
        for (Watch object : monitors.values()) {
            if (object.getEnvProperty() == null && string != null) {
                object.setActive(object.getClassname().equals(string) || object.getClassname().equals(EXTERNAL_KEY));
            }
            if (!bl && !object.shouldNotifyChange(debugger)) continue;
            vector.addElement(object);
        }
        if (bl) {
            for (Map map : monitorToAdd.values()) {
                vector.addAll(map.values());
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Iterator<Object> iterator = new Watch[vector.size()];
        vector.toArray((T[])iterator);
        return iterator;
    }

    public static void removeAllMonitors() {
        monitors.clear();
        monitorToAdd.clear();
    }

    public static Breakpoint[] getBreakpoints() {
        Vector<Breakpoint> vector = new Vector<Breakpoint>();
        for (Vector<Breakpoint> vector2 : breakpoints.values()) {
            vector.addAll(vector2);
        }
        return vector.toArray(new Breakpoint[vector.size()]);
    }
}

