/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.ExitCommand;
import com.iscobol.debugger.commands.GetFileCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.RawTextCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.commands.SuspendCommand;
import com.iscobol.rts.Config;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Vector;

public class CommandListener
extends Thread {
    private DataInputStream debuggerInput;
    private PrintStream outputStream;
    private PipedOutputStream ppos;
    private PipedInputStream ppis;
    private LinkedList commandQueue = new LinkedList();
    private int blockingMode;
    private boolean throwStopRunExceptionOnExit;
    private volatile boolean go = true;

    public CommandListener(DataInputStream dataInputStream, int n2) {
        this.setDaemon(true);
        this.debuggerInput = dataInputStream;
        this.ppos = new PipedOutputStream();
        this.outputStream = new PrintStream(this.ppos);
        this.blockingMode = n2;
        try {
            this.ppis = new PipedInputStream(this.ppos);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setName(this.getClass().getName());
    }

    public boolean isCanceled() {
        return !this.go;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Config.c();
        while (!this.isCanceled()) {
            Serializable serializable = this.commandQueue;
            synchronized (serializable) {
                if (!this.commandQueue.isEmpty()) {
                    try {
                        this.commandQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            serializable = this.acceptCommand();
            if (serializable != null) {
                Object object;
                if (serializable instanceof RawTextCommand) {
                    object = ((RawTextCommand)serializable).getRawText();
                    this.outputStream.println((String)object);
                    this.outputStream.flush();
                    continue;
                }
                if (serializable instanceof SuspendCommand) {
                    Debugger.suspending();
                    continue;
                }
                if (serializable instanceof ExitCommand) {
                    this.throwStopRunExceptionOnExit = ((ExitCommand)serializable).isThrowStopRunException();
                    Debugger.writeResponse(new DebugResponse(0, ""));
                    continue;
                }
                if (serializable instanceof SetRedirectStreamsCommand) {
                    Debugger.setRedirectStreams(((SetRedirectStreamsCommand)serializable).getValue());
                    Debugger.writeResponse(new DebugResponse(0, ""));
                    continue;
                }
                if (serializable instanceof GetFileCommand) {
                    Object object2;
                    if (Config.b(".debug.remote_source_enabled", false)) {
                        try {
                            object2 = this.getFile((GetFileCommand)serializable);
                            object = new DebugResponse(0, (String)object2);
                        }
                        catch (DebuggerException debuggerException) {
                            object = new DebugResponse(debuggerException.getErrorId(), debuggerException.getMessage());
                        }
                    } else {
                        object2 = new DebuggerException(18);
                        object = new DebugResponse(((DebuggerException)object2).getErrorId(), ((Throwable)object2).getMessage());
                    }
                    Debugger.writeResponse((DebugResponse)object);
                    continue;
                }
                if (this.blockingMode == 1 && Debugger.getActiveDebuggerStatus() != 1) {
                    object = null;
                    switch (serializable.getId()) {
                        case 0: {
                            object = this.setBreakpoint((SetBreakpointCommand)serializable);
                            break;
                        }
                        case 9: {
                            object = this.clearBreakpoint((ClearBreakpointCommand)serializable);
                            break;
                        }
                        case 19: {
                            object = this.setProgramBreakpoint((ProgramBreakpointCommand)serializable);
                            break;
                        }
                        case 52: {
                            object = this.setMethodBreakpoint((MethodBreakpointCommand)serializable);
                            break;
                        }
                        case 1000: {
                            boolean bl = true;
                            Vector<DebugCommand> vector = ((CompositeCommand)serializable).getCommandList();
                            block24: for (DebugCommand debugCommand : vector) {
                                switch (debugCommand.getId()) {
                                    case 0: 
                                    case 9: 
                                    case 19: 
                                    case 52: {
                                        continue block24;
                                    }
                                }
                                bl = false;
                                break;
                            }
                            if (bl) {
                                block25: for (DebugCommand debugCommand : vector) {
                                    switch (debugCommand.getId()) {
                                        case 0: {
                                            object = this.setBreakpoint((SetBreakpointCommand)debugCommand);
                                            continue block25;
                                        }
                                        case 9: {
                                            object = this.clearBreakpoint((ClearBreakpointCommand)debugCommand);
                                            continue block25;
                                        }
                                        case 19: {
                                            object = this.setProgramBreakpoint((ProgramBreakpointCommand)debugCommand);
                                            continue block25;
                                        }
                                        case 52: {
                                            object = this.setMethodBreakpoint((MethodBreakpointCommand)debugCommand);
                                            continue block25;
                                        }
                                    }
                                    object = null;
                                }
                                break;
                            }
                            this.setCommand((DebugCommand)serializable);
                            object = null;
                            break;
                        }
                        default: {
                            this.setCommand((DebugCommand)serializable);
                            object = null;
                        }
                    }
                    if (object == null) continue;
                    Debugger.writeResponse((DebugResponse)object);
                    continue;
                }
                this.setCommand((DebugCommand)serializable);
                continue;
            }
            this.cancel();
        }
    }

    private DebugResponse setBreakpoint(SetBreakpointCommand setBreakpointCommand) {
        try {
            String string = Debugger.setBreakpoint(setBreakpointCommand, "", 0, null);
            return Debugger.getResponse(string, setBreakpointCommand.getId());
        }
        catch (DebuggerException debuggerException) {
            return new DebugResponse(debuggerException.getErrorId(), debuggerException.getMessage());
        }
    }

    private DebugResponse setProgramBreakpoint(ProgramBreakpointCommand programBreakpointCommand) {
        try {
            String string = Debugger.setProgramBreakpoint(programBreakpointCommand, null);
            return Debugger.getResponse(string, programBreakpointCommand.getId());
        }
        catch (DebuggerException debuggerException) {
            return new DebugResponse(debuggerException.getErrorId(), debuggerException.getMessage());
        }
    }

    private DebugResponse setMethodBreakpoint(MethodBreakpointCommand methodBreakpointCommand) {
        try {
            String string = Debugger.setMethodBreakpoint(methodBreakpointCommand, null);
            return Debugger.getResponse(string, methodBreakpointCommand.getId());
        }
        catch (DebuggerException debuggerException) {
            return new DebugResponse(debuggerException.getErrorId(), debuggerException.getMessage());
        }
    }

    private DebugResponse clearBreakpoint(ClearBreakpointCommand clearBreakpointCommand) {
        try {
            String string = Debugger.clearBreakpoint(clearBreakpointCommand, "", 0);
            return Debugger.getResponse(string, clearBreakpointCommand.getId());
        }
        catch (DebuggerException debuggerException) {
            return new DebugResponse(debuggerException.getErrorId(), debuggerException.getMessage());
        }
    }

    private String getFile(GetFileCommand getFileCommand) throws DebuggerException {
        FileLoader fileLoader = Debugger.getFileLoader();
        if (fileLoader == null) {
            throw new DebuggerException(18, "'" + getFileCommand.getPath() + "'");
        }
        String string = fileLoader.getAbsolutePath(getFileCommand.getPath());
        if (string != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                byte[] byArray = new byte[((InputStream)fileInputStream).available()];
                ((InputStream)fileInputStream).read(byArray);
                ((InputStream)fileInputStream).close();
                return new String(byArray);
            }
            catch (IOException iOException) {
                throw new DebuggerException(18, "'" + string + "'");
            }
        }
        throw new DebuggerException(18, "'" + string + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCommand(DebugCommand debugCommand) {
        LinkedList linkedList = this.commandQueue;
        synchronized (linkedList) {
            this.commandQueue.addLast(debugCommand);
            this.commandQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Debugger.unattach(this.throwStopRunExceptionOnExit);
        this.go = false;
        try {
            this.ppis.close();
            this.ppos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LinkedList linkedList = this.commandQueue;
        synchronized (linkedList) {
            this.commandQueue.notifyAll();
        }
    }

    private DebugCommand acceptCommand() {
        try {
            int n2 = this.debuggerInput.readInt();
            DebugCommand debugCommand = DebuggerConstants.commandClasses.get(n2).newInstance();
            debugCommand.readExternal(this.debuggerInput);
            return debugCommand;
        }
        catch (IOException | IllegalAccessException | InstantiationException exception) {
            return null;
        }
    }

    public InputStream getInputStream() {
        return this.ppis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugCommand getDebugCommand() {
        DebugCommand debugCommand = null;
        LinkedList linkedList = this.commandQueue;
        synchronized (linkedList) {
            if (this.commandQueue.isEmpty()) {
                try {
                    this.commandQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            debugCommand = this.commandQueue.isEmpty() ? null : (DebugCommand)this.commandQueue.removeFirst();
            this.commandQueue.notify();
        }
        return debugCommand;
    }
}

