/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Level88;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.interfaces.debugger.ICondition;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.RtsUtil;
import com.iscobol.types.CobolNum;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;

public class Condition
implements DataExternalizable,
ICondition {
    private static final long serialVersionUID = 1000006L;
    public static final int ALWAYS = 0;
    public static final int EQUAL = 2;
    public static final int NOT_EQUAL = 3;
    public static final int GREATER = 4;
    public static final int LESS = 5;
    public static final int GREATER_OR_EQUAL = 6;
    public static final int LESS_OR_EQUAL = 7;
    public static final String WHEN = "when";
    public static final String ALWAYS_STR = "always";
    public static final String NEVER_STR = "never";
    public static final String EQUAL_STR = "=";
    public static final String NOT_EQUAL_STR = "!=";
    public static final String GREATER_STR = ">";
    public static final String LESS_STR = "<";
    public static final String GREATER_OR_EQUAL_STR = ">=";
    public static final String LESS_OR_EQUAL_STR = "<=";
    public static final byte NO_CONDITION = 0;
    public static final byte OBJECT_CONDITION = 1;
    public static final byte STRING_CONDITION = 2;
    public static final String[] conditionStrings = new String[]{"always", "=", "!=", "<", "<=", ">", ">="};
    private int type = -1;
    private String stringValue;
    private boolean isHex;
    private CobolNum numericValue;

    public Condition() {
    }

    public Condition(DebugTM debugTM, boolean bl) throws DebuggerException {
        this.isHex = bl;
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(5);
        }
        if (string.equalsIgnoreCase(ALWAYS_STR)) {
            this.type = 0;
        } else if (string.equals(EQUAL_STR)) {
            this.type = 2;
        } else if (string.equals("!")) {
            this.type = 3;
        } else if (string.equals(GREATER_STR)) {
            this.type = 4;
        } else if (string.equals(LESS_STR)) {
            this.type = 5;
        } else {
            throw new DebuggerException(5);
        }
        if (this.type != 0) {
            if (this.type == 4) {
                string = debugTM.getAllToken();
                if (string != null && string.equals(EQUAL_STR)) {
                    this.type = 6;
                } else {
                    debugTM.ungetAllToken();
                }
            } else if (this.type == 5) {
                string = debugTM.getAllToken();
                if (string != null && string.equals(EQUAL_STR)) {
                    this.type = 7;
                } else {
                    debugTM.ungetAllToken();
                }
            } else if (!(this.type != 3 || (string = debugTM.getAllToken()) != null && string.equals(EQUAL_STR))) {
                throw new DebuggerException(5);
            }
            string = debugTM.getToken();
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                while ((string = debugTM.getAllToken()) != null) {
                    stringBuffer.append(string);
                }
                if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(stringBuffer.length() - 1) == '\"') {
                    stringBuffer.deleteCharAt(0);
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                this.setValue(bl, stringBuffer.toString());
            } else {
                this.stringValue = "";
            }
        }
    }

    public Condition(int n2, boolean bl, String string) {
        this.type = n2;
        this.isHex = bl;
        this.stringValue = string;
    }

    public boolean evaluate(Object object) {
        int n2;
        if (this.type == 0) {
            return true;
        }
        if (object instanceof ICobolVar) {
            ICobolVar iCobolVar = (ICobolVar)object;
            n2 = this.numericValue != null ? this.compareNumeric(iCobolVar) : this.compareString(iCobolVar);
        } else {
            n2 = object instanceof Level88 ? Boolean.toString(((Level88)object).getValue()).compareTo(this.stringValue) : object.toString().compareTo(this.stringValue);
        }
        switch (this.type) {
            case 2: {
                return n2 == 0;
            }
            case 3: {
                return n2 != 0;
            }
            case 6: {
                return n2 >= 0;
            }
            case 7: {
                return n2 <= 0;
            }
            case 4: {
                return n2 > 0;
            }
            case 5: {
                return n2 < 0;
            }
        }
        return false;
    }

    private int compareNumeric(ICobolVar iCobolVar) {
        return iCobolVar.compareTo(this.numericValue);
    }

    private int compareString(ICobolVar iCobolVar) {
        try {
            if (this.isHex) {
                return Long.valueOf(DebugUtilities.toHexString(iCobolVar), 16).compareTo(Long.valueOf(this.stringValue, 16));
            }
            return ScreenUtility.rightTrim(iCobolVar.toString()).compareTo(this.stringValue);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void setValue(boolean bl, String string) throws DebuggerException {
        this.stringValue = ScreenUtility.rightTrim(string);
        if (bl) {
            if (!DebugUtilities.checkHexString(this.stringValue)) {
                throw new DebuggerException(5);
            }
        } else {
            this.setNumericValue();
        }
    }

    private void setNumericValue() {
        try {
            this.numericValue = CobolNum.noo(new BigDecimal(this.stringValue.trim().replace(',', '.')));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getValue() {
        return this.numericValue != null ? this.numericValue.toString() : this.stringValue;
    }

    public String toString() {
        switch (this.type) {
            default: {
                return this.getTypeStr();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return this.getTypeStr() + " " + this.getValueStr();
    }

    public String getValueStr() {
        String string = this.getValue();
        if (string != null) {
            return string;
        }
        return "";
    }

    public String getTypeStr() {
        switch (this.type) {
            default: {
                return ALWAYS_STR;
            }
            case 2: {
                return EQUAL_STR;
            }
            case 3: {
                return NOT_EQUAL_STR;
            }
            case 4: {
                return GREATER_STR;
            }
            case 6: {
                return GREATER_OR_EQUAL_STR;
            }
            case 5: {
                return LESS_STR;
            }
            case 7: 
        }
        return LESS_OR_EQUAL_STR;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public static final String[] getConditionStrings() {
        return conditionStrings;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.type);
        dataOutput.writeBoolean(this.isHex);
        RtsUtil.writeUTF(this.stringValue, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.type = dataInput.readInt();
        this.isHex = dataInput.readBoolean();
        this.stringValue = RtsUtil.readUTF(dataInput);
        if (this.isHex || this.stringValue == null) {
            this.numericValue = null;
        } else {
            this.setNumericValue();
        }
    }
}

