/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.IDebugCopyFile;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public class DebugCopyFile
implements DataExternalizable,
IDebugCopyFile {
    private static final long serialVersionUID = 1000006L;
    private String parentFileName;
    private int copyStatementLineNumber;
    private String copyFileName;

    public DebugCopyFile() {
    }

    DebugCopyFile(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            this.parentFileName = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                this.copyStatementLineNumber = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    this.copyFileName = stringTokenizer.nextToken();
                }
            }
        }
    }

    public DebugCopyFile(String string, int n2, String string2) {
        this.parentFileName = string;
        this.copyStatementLineNumber = n2;
        this.copyFileName = string2;
    }

    @Override
    public String getParentFileName() {
        return this.parentFileName;
    }

    @Override
    public int getCopyStatementLineNumber() {
        return this.copyStatementLineNumber;
    }

    @Override
    public String getCopyFileName() {
        return this.copyFileName;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.parentFileName, dataOutput);
        dataOutput.writeInt(this.copyStatementLineNumber);
        RtsUtil.writeUTFOptmz(this.copyFileName, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.parentFileName = RtsUtil.readUTFOptmz(dataInput);
        this.copyStatementLineNumber = dataInput.readInt();
        this.copyFileName = RtsUtil.readUTFOptmz(dataInput);
    }
}

