/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.IDebugLine;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public class DebugLine
implements DataExternalizable,
IDebugLine {
    private static final long serialVersionUID = 1000006L;
    private int lineNumber;
    private int fileIndex;
    private int paragraphId;
    private boolean isInDeclaratives;

    public DebugLine() {
    }

    public DebugLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            this.lineNumber = Integer.parseInt(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                this.fileIndex = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
    }

    public DebugLine(int n2, int n3) {
        this.lineNumber = n2;
        this.fileIndex = n3;
    }

    public DebugLine(int n2, int n3, int n4) {
        this.lineNumber = n2;
        this.fileIndex = n3;
        this.paragraphId = n4;
    }

    public DebugLine(int n2, int n3, int n4, boolean bl) {
        this.lineNumber = n2;
        this.fileIndex = n3;
        this.paragraphId = n4;
        this.isInDeclaratives = bl;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    @Override
    public int getParagraphId() {
        return this.paragraphId;
    }

    @Override
    public boolean isInDeclaratives() {
        return this.isInDeclaratives;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.lineNumber);
        dataOutput.writeInt(this.fileIndex);
        dataOutput.writeInt(this.paragraphId);
        dataOutput.writeBoolean(this.isInDeclaratives);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.lineNumber = dataInput.readInt();
        this.fileIndex = dataInput.readInt();
        this.paragraphId = dataInput.readInt();
        this.isInDeclaratives = dataInput.readBoolean();
    }
}

