/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Function;
import com.iscobol.compiler.GuiWords;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugOutputStream;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.LocalDebugInfo;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.TextFile;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.dialogs.FindDialog;
import com.iscobol.debugger.dialogs.treetable.model.BreakpointModel;
import com.iscobol.debugger.dialogs.treetable.model.CallStackModel;
import com.iscobol.debugger.dialogs.treetable.model.MonitorModel;
import com.iscobol.debugger.dialogs.treetable.model.ThreadModel;
import com.iscobol.debugger.dialogs.treetable.model.VariableModel;
import com.iscobol.debugger.dialogs.treetable.model.VariableNode;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import com.iscobol.interfaces.debugger.Appender;
import com.iscobol.rts.Config;
import com.iscobol.types.CobolVar;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class DebugPanel
extends JPanel {
    private static final long serialVersionUID = 123L;
    private static final Cursor BUSY_CURSOR;
    private static final Cursor HAND_CURSOR;
    private static final Cursor DEF_CURSOR;
    private static final Dimension BTN_SIZE;
    private static final int NUMBER_COLUMN_PAD = 2;
    private static final int IMG_WIDTH = 20;
    private static final int BREAKPOINT_IMG_HEIGHT = 9;
    private static final int CURR_LINE_IMG_HEIGHT = 12;
    private static final int EXP_COLL_IMG_HEIGHT = 16;
    static final int CURRENT = 0;
    static final int WATCHED = 1;
    private static final Set statements;
    private static final Set keywords;
    private static final Set guiwords;
    private static Font previewFont;
    private static Font previewLinkFont;
    private static int currentFontSize;
    private static FontMetrics previewMetrics;
    private static int numberColumnLen;
    private static int preferredPreviewWidth;
    private static Color sourceBackground;
    private static Color sourceForeground;
    private static Color highBackground;
    private static Color highForeground;
    private static Color selBackground;
    private static Color commentForeground;
    private static Color keywordForeground;
    private static Color stringForeground;
    private static Color numberForeground;
    private static Color stmtForeground;
    private static Color levnumForeground;
    private static Color figconsForeground;
    private static Color bpLineBackground;
    private static Color[] copySourcePatternColors;
    private static Color lineNumberBackground;
    private static Color lineNumberForeground;
    private static Color currLineBackground;
    private static Color bpColBackground;
    private static Font tipFont;
    private static Color tipBackground;
    private static Color tipForeground;
    private static Font perfStackFont;
    private static Color perfStackBackground;
    private static Color perfStackForeground;
    private static Color perfStackSelBackground;
    private static Color perfStackSelForeground;
    private static Font bpListFont;
    private static Color bpListBackground;
    private static Color bpListForeground;
    private static Color bpListSelBackground;
    private static Color bpListSelForeground;
    private static Font monListFont;
    private static Color monListBackground;
    private static Color monListForeground;
    private static Color monListSelBackground;
    private static Color monListSelForeground;
    private static Font cmdHistoryFont;
    private static Color cmdHistoryBackground;
    private static Color cmdHistoryForeground;
    private static Color cmdHistorySelBackground;
    private static Color cmdHistorySelForeground;
    private static Font consoleFont;
    private static Color consoleBackground;
    private static Color consoleForeground;
    private static Color consoleStdErrForeground;
    private static Color consoleSelBackground;
    private static Color consoleSelForeground;
    private static Font threadListFont;
    private static Color threadListBackground;
    private static Color threadListForeground;
    private static Font disTreeFont;
    private static Color disTreeBackground;
    private static Color disTreeForeground;
    private static Color disTreeSelBackground;
    private static Color disTreeSelForeground;
    private static Font outputFont;
    private static Color outputBackground;
    private static Color outputForeground;
    private static Color outputSelBackground;
    private static Color outputSelForeground;
    private static Font inputFont;
    private static Color inputBackground;
    private static Color inputForeground;
    private static Color inputSelBackground;
    private static Color inputSelForeground;
    private static Image breakpointImage;
    private static Image currlineImage;
    private static Image disbreakpointImage;
    private static Image expandCopyImage;
    private static Image collapseCopyImage;
    private static final String PERF_STACK_TITLE = "Perform stack";
    private static final String BREAKPOINTS_TITLE = "Breakpoints";
    private static final String THREADS_TITLE = "Threads";
    private static final String MONITORS_TITLE = "Monitors";
    private static final String COMMAND_HISTORY_TITLE = "Command history";
    private static final String CONSOLE_TITLE = "Console";
    private int lastPosForVarSearch = -1;
    private boolean lastVarSearchBackward;
    private GraphDebugger graphDebug;
    private String mainProgram;
    private Hashtable textFiles = new Hashtable();
    private FindDialog.FindParam fparam;
    private String highlightedWord;
    private String highlightedVar;
    private HighlightVarType highlightVarType = HighlightVarType.NONE;
    private int highlightedVarLine;
    private int highlightedVarCol;
    private TextFileObj tFileObj;
    private int sourceFormat = -1;
    private Popup tipPopup;
    private Timer tipTimer;
    private Timer handMouseTimer;
    private Timer linkTimer;
    private JToolBar toolbar;
    private JToolBar btnToolbar;
    private JButton btnRun;
    private JButton btnStepInto;
    private JButton btnOutPar;
    private JButton btnOutProg;
    private JButton btnNext;
    private JButton btnStepTo;
    private JButton btnStepToPgm;
    private JButton btnJump;
    private JButton btnJumpOutPar;
    private JButton btnJumpOutProg;
    private JButton btnJumpNext;
    private JButton btnFind;
    private JButton btnRepeatFind;
    private JButton btnGotoCurrLine;
    private JButton btnContinue;
    private JButton btnSuspend;
    private JButton btnStop;
    private JCheckBox btnAutoStep;
    private JLabel warnLbl = new JLabel();
    private JSpinner autoStepDelay;
    private final Hashtable nrw = new Hashtable();
    private boolean ccbas;
    private JComboBox fileChooser = new JComboBox(){
        private static final long serialVersionUID = 123L;
        {
            this.setToolTipText("");
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Object object = this.getSelectedItem();
            if (object != null) {
                return object.toString();
            }
            return null;
        }
    };
    private List gotoList = new ArrayList();
    private int gotoIndex = -1;
    private JLabel variableLabel;
    private JTabbedPane variableTabbedPane;
    private JPanel outputArea;
    private JSplitPane topSplitPane;
    private int topSplitPaneDividerLocation;
    private int varSplitPaneDividerLocation;
    private JSplitPane bottomSplitPane;
    private JTextArea textOutput;
    private JScrollPane scrollTextOutput;
    private JTextField lineCommand;
    private JSplitPane mainSplitPane;
    private JPanel previewPanel;
    private CardLayout previewLayout = new CardLayout();
    JList previewArea;
    private JScrollPane scrollPreviewArea;
    private DebugListModel previewModel;
    private DebugListCellRenderer previewRenderer;
    private JTabbedPane bottomRightTabbedPane;
    private int currLine;
    private ParagraphObject selParObj;
    private int cursorColumn;
    private int cursorX;
    private int selLine;
    private int startDragLine = -1;
    private int endDragLine = -1;
    private KeyListener globalKeyListener = IsguiUtility.keyPressedAdapter(keyEvent -> {
        if (this.previewModel == null) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 36: {
                this.select(0, 0);
                break;
            }
            case 35: {
                this.select(this.previewModel.getSize() - 1, 0);
                break;
            }
            case 38: {
                if (keyEvent.isControlDown() || keyEvent.isAltDown()) break;
                if (keyEvent.isShiftDown()) {
                    int n2;
                    this.endDragLine = n2 = Math.max(0, this.endDragLine - 1);
                    this.ensureVisible(this.endDragLine);
                    this.previewArea.repaint();
                    break;
                }
                int n3 = Math.max(0, this.selLine - 1);
                this.select(n3, 0);
                break;
            }
            case 40: {
                if (keyEvent.isControlDown() || keyEvent.isAltDown()) break;
                if (keyEvent.isShiftDown()) {
                    int n4;
                    this.endDragLine = n4 = Math.min(this.endDragLine + 1, this.previewModel.getSize() - 1);
                    this.ensureVisible(this.endDragLine);
                    this.previewArea.repaint();
                    break;
                }
                int n5 = Math.min(this.selLine + 1, this.previewModel.getSize() - 1);
                this.select(n5, 0);
                break;
            }
            case 33: {
                int n6 = this.previewArea.getLastVisibleIndex();
                int n7 = this.previewArea.getFirstVisibleIndex();
                n7 -= n6 - n7;
                int n8 = Math.max(0, n7);
                if (keyEvent.isShiftDown()) {
                    this.endDragLine = n8;
                    this.ensureVisible(this.endDragLine);
                    this.previewArea.repaint();
                    break;
                }
                this.select(n8, 0);
                break;
            }
            case 34: {
                int n9 = this.previewArea.getLastVisibleIndex();
                int n10 = this.previewArea.getFirstVisibleIndex();
                n9 += n9 - n10;
                int n11 = Math.min(n9, this.previewModel.getSize() - 1);
                if (keyEvent.isShiftDown()) {
                    this.endDragLine = n11;
                    this.ensureVisible(this.endDragLine);
                    this.previewArea.repaint();
                    break;
                }
                this.select(n11, 0);
                break;
            }
            case 9: {
                this.displayVarsOnSelLine(true, keyEvent.isShiftDown());
            }
        }
    });
    private JPanel breakpointPanel;
    private JToolBar breakpointButtonPanel;
    private JTreeTable breakpointTable;
    private JButton breakpointEnAllBtn;
    private JButton breakpointDisAllBtn;
    private JButton breakpointModifyBtn;
    private JButton breakpointAddBtn;
    private JButton breakpointRemoveBtn;
    private JButton breakpointRemoveAllBtn;
    private JMenuItem breakpointModifyItem;
    private JMenuItem breakpointAddItem;
    private JMenuItem breakpointRemoveItem;
    private JMenuItem breakpointRemoveAllItem;
    private JMenuItem breakpointEnAllItem;
    private JMenuItem breakpointDisAllItem;
    private BreakpointModel breakpointModel;
    private JTreeTable callStackTable;
    private JPanel callStackNoInfoPanel;
    private JPanel callStackPanel;
    private CardLayout callStackLayout = new CardLayout();
    private CallStackModel callStackModel;
    private JPanel monitorPanel;
    private JToolBar monitorButtonPanel;
    private JTreeTable monitorTable;
    private JButton monitorEnAllBtn;
    private JButton monitorDisAllBtn;
    private JButton monitorRemoveBtn;
    private JButton monitorRemoveAllBtn;
    private JButton monitorModifyBtn;
    private JButton monitorAddBtn;
    private JMenuItem monitorModifyItem;
    private JMenuItem monitorAddItem;
    private JMenuItem monitorRemoveItem;
    private JMenuItem monitorRemoveAllItem;
    private JMenuItem monitorEnAllItem;
    private JMenuItem monitorDisAllItem;
    private MonitorModel monitorModel;
    private JPanel commandHistoryPanel;
    private JToolBar commandHistoryButtonPanel;
    private JList commandHistory;
    private JButton commandExecuteBtn;
    private JButton clearHistoryBtn;
    private JMenuItem commandExecuteItem;
    private JMenuItem clearHistoryItem;
    private DefaultListModel commandHistoryModel;
    private JPanel consolePanel;
    private JToolBar consoleButtonPanel;
    private JTextPane console;
    private JCheckBox consoleAttachedBtn;
    private JCheckBox showConsoleBtn;
    private JButton clearConsoleBtn;
    private JCheckBoxMenuItem consoleAttachedItem;
    private JCheckBoxMenuItem showConsoleItem;
    private JMenuItem clearConsoleItem;
    private ThreadModel threadModel;
    private JTreeTable threadTable;
    private JPanel threadNoInfoPanel;
    private JPanel threadPanel;
    private CardLayout threadLayout = new CardLayout();
    private JPanel variablesPanel;
    private MyVariableModel[] varModel = new MyVariableModel[2];
    private VariableNode[] varRootNode = new VariableNode[2];
    private JScrollPane[] varScrollPane = new JScrollPane[2];
    private JTreeTable[] varTreeTable = new JTreeTable[2];
    private JTree[] varTree = new JTree[2];
    private JTabbedPane[] varTabbed = new JTabbedPane[2];
    private JSplitPane varSplitPane;
    private JButton varExpandAllBtn;
    private JButton varCollapseAllBtn;
    private JButton varChangeValueBtn;
    private ToggleImageButton varAutoRefreshBtn;
    private ToggleImageButton varHexBtn;
    private JButton varAddMonBtn;
    private JButton varRemoveBtn;
    private JButton varRemoveAllBtn;
    private JButton varAddBtn;
    private JMenuItem varHexItem;
    private JMenuItem varAddMonitorItem;
    private JMenuItem varChangeValueItem;
    private JMenuItem varExpandAllItem;
    private JMenuItem varCollapseAllItem;
    private JMenuItem varAutoRefreshItem;
    private JMenuItem varRemoveItem;
    private JMenuItem varRemoveAllItem;
    private JMenuItem varAddItem;
    private JMenuItem varCopyItem;
    private JProgressBar memoryView;
    private JMenuItem listCopyItem;
    private JMenuItem displayOnLineItem;
    private JMenuItem currLineItem;
    private JMenuItem gotoItem;
    private JMenuItem contItem;
    private JMenuItem suspItem;
    private JMenuItem stepIntoItem;
    private JMenuItem stepOverItem;
    private JMenuItem runToItem;
    private JMenuItem runToNextPgmItem;
    private JMenuItem outParItem;
    private JMenuItem outProgItem;
    private JMenuItem jumpItem;
    private JMenuItem jumpOutItem;
    private JMenuItem jumpOutProgItem;
    private JMenuItem jumpNextItem;
    private JMenuItem toggleBrItem;
    private JMenuItem quickWatchItem;
    private JMenuItem refreshItem;
    private JMenuItem textOutputClearItem;
    private TipAction tipAction = new TipAction();
    private HandMouseAction handMouseAction = new HandMouseAction();
    private JPopupMenu listPopup;
    Point quickWatchPoint;
    private Rectangle lastMouseEventArea;
    private Rectangle lastLinkArea;
    private String currFile = "";
    private List<String[]> watchedVarnames = new ArrayList<String[]>();
    private KeyListener surrogateLineCommandListener = IsguiUtility.keyPressedAdapter(keyEvent -> {
        if (Character.isLetter(keyEvent.getKeyChar())) {
            this.lineCommand.setText(this.lineCommand.getText() + keyEvent.getKeyChar());
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(this.lineCommand, 1004));
        }
    });
    private ActionListener threadActionListener = actionEvent -> {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        if (!this.graphDebug.isProcessing()) {
            this.graphDebug.setTextCommand("thread " + abstractButton.getName());
        }
    };

    public DebugPanel(GraphDebugger graphDebugger, LocalDebugInfo localDebugInfo, boolean bl) {
        this.graphDebug = graphDebugger;
        this.mainProgram = localDebugInfo != null && localDebugInfo.getErrorString() == null ? this.getRealPath(localDebugInfo.getSourcefile()) : "";
        this.setDoubleBuffered(true);
        this.previewPanel = new JPanel(this.previewLayout);
        this.getFile(localDebugInfo, new Filename(this.mainProgram), 0L, bl, true);
        this.currFile = this.mainProgram;
        this.buildPopup();
        this.buildPanel();
        this.initNumberColumnLen();
        this.setPreferredListWidth();
    }

    private static Color[] loadCopySourcePatternColors(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n2 = stringTokenizer.countTokens();
        Color[] colorArray = new Color[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            colorArray[i2] = new Color(n3);
        }
        return colorArray;
    }

    private String getSelection() {
        if (this.previewModel == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.startDragLine;
        int n3 = this.endDragLine;
        if (n2 >= 0) {
            if (n3 < n2) {
                n2 = this.endDragLine;
                n3 = this.startDragLine;
            }
            for (int i2 = n2; i2 <= n3; ++i2) {
                stringBuffer.append(this.previewModel.getElementAt(i2));
                if (i2 >= n3) continue;
                stringBuffer.append(GraphDebugger.eol);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy() {
        JList jList = this.previewArea;
        synchronized (jList) {
            String string = this.getSelection();
            if (string != null && string.length() > 0) {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        }
    }

    private void buildPopup() {
        this.listPopup = new JPopupMenu();
        this.listCopyItem = new JMenuItem("Copy");
        this.listCopyItem.addActionListener(actionEvent -> this.copy());
        this.listCopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.listPopup.add(this.listCopyItem);
        this.listPopup.addSeparator();
        this.currLineItem = new JMenuItem("Current line");
        this.currLineItem.addActionListener(actionEvent -> this.selectCurrentLine());
        this.listPopup.add(this.currLineItem);
        this.gotoItem = new JMenuItem("Go to");
        this.gotoItem.addActionListener(actionEvent -> this.graphDebug.showGotoDialog());
        this.listPopup.add(this.gotoItem);
        this.listPopup.addSeparator();
        this.contItem = new JMenuItem("Continue", new ImageIcon(GraphUtilities.getImage("continue.gif")));
        this.contItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("continue"));
        this.listPopup.add(this.contItem);
        this.contItem.setEnabled(false);
        this.suspItem = new JMenuItem("Pause", new ImageIcon(GraphUtilities.getImage("suspend.gif")));
        this.suspItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("pause"));
        this.listPopup.add(this.suspItem);
        this.suspItem.setEnabled(false);
        this.stepIntoItem = new JMenuItem("Step into", new ImageIcon(GraphUtilities.getImage("stepinto.gif")));
        this.stepIntoItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("step"));
        this.listPopup.add(this.stepIntoItem);
        this.stepIntoItem.setEnabled(false);
        this.stepOverItem = new JMenuItem("Step over", new ImageIcon(GraphUtilities.getImage("stepover.gif")));
        this.stepOverItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("next"));
        this.listPopup.add(this.stepOverItem);
        this.stepOverItem.setEnabled(false);
        this.outParItem = new JMenuItem("Step out paragraph", new ImageIcon(GraphUtilities.getImage("stepout.gif")));
        this.outParItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("outpar"));
        this.listPopup.add(this.outParItem);
        this.outParItem.setEnabled(false);
        this.outProgItem = new JMenuItem("Step out program", new ImageIcon(GraphUtilities.getImage("stepoutprog.gif")));
        this.outProgItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("outprog"));
        this.listPopup.add(this.outProgItem);
        this.outProgItem.setEnabled(false);
        this.runToItem = new JMenuItem("Run to selected line", new ImageIcon(GraphUtilities.getImage("runtilcurs.gif")));
        this.runToItem.addActionListener(actionEvent -> this.graphDebug.runToSelectedLine(this.selLine, this.tFileObj.tf));
        this.listPopup.add(this.runToItem);
        this.runToItem.setEnabled(false);
        this.runToNextPgmItem = new JMenuItem("Run to next program", new ImageIcon(GraphUtilities.getImage("runtilpgm.gif")));
        this.runToNextPgmItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("prog"));
        this.listPopup.add(this.runToNextPgmItem);
        this.runToNextPgmItem.setEnabled(false);
        this.jumpNextItem = new JMenuItem("Jump next statement", new ImageIcon(GraphUtilities.getImage("jumpover.gif")));
        this.jumpNextItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("jump -next"));
        this.listPopup.add(this.jumpNextItem);
        this.jumpNextItem.setEnabled(false);
        this.jumpOutItem = new JMenuItem("Jump out paragraph", new ImageIcon(GraphUtilities.getImage("jumpout.gif")));
        this.jumpOutItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("jump -outpar"));
        this.listPopup.add(this.jumpOutItem);
        this.jumpOutItem.setEnabled(false);
        this.jumpOutProgItem = new JMenuItem("Jump out program", new ImageIcon(GraphUtilities.getImage("jumpoutprog.gif")));
        this.jumpOutProgItem.addActionListener(actionEvent -> this.graphDebug.setTextCommand("jump -outprog"));
        this.listPopup.add(this.jumpOutProgItem);
        this.jumpOutProgItem.setEnabled(false);
        this.jumpItem = new JMenuItem("Jump to selected line", new ImageIcon(GraphUtilities.getImage("jump.gif")));
        this.jumpItem.addActionListener(actionEvent -> this.jumpToSelectedLine());
        this.listPopup.add(this.jumpItem);
        this.jumpItem.setEnabled(false);
        this.listPopup.addSeparator();
        this.toggleBrItem = new JMenuItem("Toggle breakpoint");
        this.toggleBrItem.addActionListener(actionEvent -> {
            int n2;
            if (this.quickWatchPoint != null && (n2 = this.previewArea.locationToIndex(this.quickWatchPoint)) >= 0) {
                this.graphDebug.toggleBreakpoint(n2, this.tFileObj.tf, this.getBreakpoint(n2));
            }
        });
        this.listPopup.add(this.toggleBrItem);
        this.listPopup.addSeparator();
        this.displayOnLineItem = new JMenuItem("Display variables on selected line", 89);
        this.listPopup.add(this.displayOnLineItem).addActionListener(actionEvent -> this.displayVarsOnSelLine());
        this.displayOnLineItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.listPopup.addSeparator();
        this.quickWatchItem = new JMenuItem("Quick watch");
        this.quickWatchItem.addActionListener(actionEvent -> {
            MyVarName myVarName = this.getVarName();
            this.graphDebug.showQuickWatchDialog(myVarName != null ? myVarName.varName : null, this.getSelectedModule());
        });
        this.listPopup.add(this.quickWatchItem);
        this.quickWatchItem.setEnabled(false);
        this.refreshItem = new JMenuItem("Refresh Variables Area");
        this.refreshItem.setEnabled(false);
        this.refreshItem.addActionListener(actionEvent -> this.refreshVariables());
        this.listPopup.add(this.refreshItem);
    }

    private void buildThreadArea() {
        int n2;
        int n3;
        this.threadPanel = new JPanel(this.threadLayout);
        this.threadNoInfoPanel = new NoInfoPanel(threadListBackground, threadListForeground, threadListFont);
        this.threadPanel.add((Component)this.threadNoInfoPanel, "EMPTY-PANEL");
        this.threadModel = new ThreadModel(this.graphDebug);
        this.threadTable = new JTreeTable(this.threadModel);
        this.threadTable.setRootVisible(false);
        this.threadTable.setEnabled(true);
        this.threadTable.setFont(threadListFont);
        this.threadTable.setBackground(threadListBackground);
        this.threadTable.setForeground(threadListForeground);
        this.threadTable.setSelectionMode(0);
        this.threadTable.setRowSelectionAllowed(true);
        this.threadTable.setFillsViewportHeight(true);
        this.threadTable.setColumnSelectionAllowed(false);
        this.threadTable.getTableHeader().setReorderingAllowed(false);
        this.threadTable.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.threadTable.getColumnModel().getColumn(0).setMaxWidth(35);
        this.threadTable.getColumnModel().getColumn(0).setResizable(false);
        this.threadTable.addKeyListener(this.surrogateLineCommandListener);
        int n4 = Settings.getThreadTableNameColumnWidth();
        if (n4 >= 0) {
            this.threadTable.getColumnModel().getColumn(1).setPreferredWidth(n4);
        }
        if ((n3 = Settings.getThreadTableParagraphColumnWidth()) >= 0) {
            this.threadTable.getColumnModel().getColumn(2).setPreferredWidth(n3);
        }
        if ((n2 = Settings.getThreadTableProgramColumnWidth()) >= 0) {
            this.threadTable.getColumnModel().getColumn(3).setPreferredWidth(n2);
        }
        this.threadPanel.add((Component)DebugPanel.createJScrollPane(this.threadTable), "THREAD-LIST");
    }

    private static JScrollPane createJScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.getHorizontalScrollBar().setFocusable(false);
        return jScrollPane;
    }

    private void buildCallStackArea() {
        int n2;
        int n3;
        this.callStackModel = new CallStackModel(this.graphDebug);
        this.callStackTable = new JTreeTable(this.callStackModel);
        this.callStackTable.setRootVisible(false);
        this.callStackTable.setToolTipText("Double click to go to paragraph line");
        this.callStackTable.setSelectionMode(0);
        this.callStackTable.setRowSelectionAllowed(true);
        this.callStackTable.setFillsViewportHeight(true);
        this.callStackTable.setColumnSelectionAllowed(false);
        this.callStackTable.getTableHeader().setReorderingAllowed(false);
        int n4 = Settings.getCallStackTableParagraphColumnWidth();
        if (n4 >= 0) {
            this.callStackTable.getColumnModel().getColumn(0).setPreferredWidth(n4);
        }
        if ((n3 = Settings.getCallStackTableLocationColumnWidth()) >= 0) {
            this.callStackTable.getColumnModel().getColumn(1).setPreferredWidth(n3);
        }
        if ((n2 = Settings.getCallStackTableProgramColumnWidth()) >= 0) {
            this.callStackTable.getColumnModel().getColumn(2).setPreferredWidth(n2);
        }
        this.callStackTable.addKeyListener(this.surrogateLineCommandListener);
        this.callStackTable.addMouseListener(IsguiUtility.mouseClickedAdapter(mouseEvent -> {
            ParagraphObject paragraphObject;
            if (mouseEvent.getClickCount() == 2 && (paragraphObject = (ParagraphObject)this.callStackModel.elementAt(this.callStackTable.getSelectedRow())) != null) {
                DataExternalizable dataExternalizable;
                this.selParObj = paragraphObject;
                String string = this.tFileObj.tf.getClassName();
                if (!string.equals(paragraphObject.getProgName()) && (dataExternalizable = this.graphDebug.getInvoker().getInfo(paragraphObject.getProgName(), this.graphDebug.isProcessing(), true)) != null) {
                    String string2 = ((DebugResponse.DebugInfo)dataExternalizable).getSourcefile() != null ? this.getRealPath(((DebugResponse.DebugInfo)dataExternalizable).getSourcefile()) : "";
                    this.load((LocalDebugInfo)dataExternalizable, new Filename(string2), ((DebugResponse.DebugInfo)dataExternalizable).getTimestamp(), true);
                }
                dataExternalizable = null;
                int n2 = -1;
                int n3 = this.callStackModel.size() - 1;
                if (n3 >= 0 && paragraphObject != (dataExternalizable = (ParagraphObject)this.callStackModel.elementAt(n3)) && paragraphObject.getProgName().equals(((ParagraphObject)dataExternalizable).getProgName())) {
                    n2 = ((ParagraphObject)dataExternalizable).getLine();
                }
                this.goTo(paragraphObject.getLine(), null, paragraphObject.getFileIndex(), paragraphObject == dataExternalizable, n2);
            }
        }));
        this.callStackTable.setFont(perfStackFont);
        this.callStackTable.setBackground(perfStackBackground);
        this.callStackTable.setForeground(perfStackForeground);
        this.callStackTable.setSelectionBackground(perfStackSelBackground);
        this.callStackTable.setSelectionForeground(perfStackSelForeground);
        this.callStackTable.getSelectionModel().setSelectionMode(0);
        this.callStackPanel = new JPanel(this.callStackLayout);
        this.callStackNoInfoPanel = new NoInfoPanel(perfStackBackground, perfStackForeground, perfStackFont);
        this.callStackPanel.add((Component)this.callStackNoInfoPanel, "EMPTY-PANEL");
        this.callStackPanel.add((Component)DebugPanel.createJScrollPane(this.callStackTable), "CALL-STACK-LIST");
    }

    private void buildBreakpointArea() {
        this.breakpointModel = new BreakpointModel(this.graphDebug);
        this.breakpointPanel = new JPanel(new BorderLayout(0, 0));
        this.breakpointButtonPanel = new JToolBar();
        this.breakpointButtonPanel.setFloatable(false);
        this.breakpointEnAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("checkall.gif")), "Enable all", false, actionEvent -> this.enableAllBreakpoints());
        this.breakpointButtonPanel.add(this.breakpointEnAllBtn);
        this.breakpointDisAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("uncheckall.gif")), "Disable all", false, actionEvent -> this.disableAllBreakpoints());
        this.breakpointButtonPanel.add(this.breakpointDisAllBtn);
        this.breakpointModifyBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("edit.gif")), "Modify", false, actionEvent -> this.modifyBreakpoint());
        this.breakpointButtonPanel.add(this.breakpointModifyBtn);
        this.breakpointAddBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("add_item.gif")), "New", true, actionEvent -> this.newBreakpoint());
        this.breakpointButtonPanel.add(this.breakpointAddBtn);
        this.breakpointRemoveBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("remove.gif")), "Remove", false, actionEvent -> this.removeBreakpoint());
        this.breakpointButtonPanel.add(this.breakpointRemoveBtn);
        this.breakpointRemoveAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("removeall.gif")), "Remove all", false, actionEvent -> this.removeAllBreakpoints());
        this.breakpointButtonPanel.add(this.breakpointRemoveAllBtn);
        this.breakpointPanel.add((Component)this.breakpointButtonPanel, "North");
        this.breakpointTable = new JTreeTable(this.breakpointModel);
        this.breakpointTable.setRootVisible(false);
        this.breakpointTable.setToolTipText("Type 'Canc' to remove the selected breakpoint");
        this.breakpointTable.setFont(bpListFont);
        this.breakpointTable.setBackground(bpListBackground);
        this.breakpointTable.setForeground(bpListForeground);
        this.breakpointTable.setSelectionBackground(bpListSelBackground);
        this.breakpointTable.setSelectionForeground(bpListSelForeground);
        this.breakpointTable.setSelectionMode(0);
        this.breakpointTable.setRowSelectionAllowed(true);
        this.breakpointTable.setFillsViewportHeight(true);
        this.breakpointTable.setColumnSelectionAllowed(false);
        this.breakpointTable.getTableHeader().setReorderingAllowed(false);
        this.breakpointTable.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.breakpointTable.getColumnModel().getColumn(0).setMaxWidth(35);
        this.breakpointTable.getColumnModel().getColumn(0).setResizable(false);
        this.breakpointPanel.add((Component)DebugPanel.createJScrollPane(this.breakpointTable), "Center");
        final JPopupMenu jPopupMenu = new JPopupMenu();
        this.breakpointEnAllItem = new JMenuItem("Enable all", new ImageIcon(GraphUtilities.getImage("checkall.gif")));
        this.breakpointEnAllItem.setEnabled(false);
        this.breakpointEnAllItem.addActionListener(actionEvent -> this.enableAllBreakpoints());
        jPopupMenu.add(this.breakpointEnAllItem);
        this.breakpointDisAllItem = new JMenuItem("Disable all", new ImageIcon(GraphUtilities.getImage("uncheckall.gif")));
        this.breakpointDisAllItem.setEnabled(false);
        this.breakpointDisAllItem.addActionListener(actionEvent -> this.disableAllBreakpoints());
        jPopupMenu.add(this.breakpointDisAllItem);
        jPopupMenu.addSeparator();
        this.breakpointModifyItem = new JMenuItem("Modify", new ImageIcon(GraphUtilities.getImage("edit.gif")));
        this.breakpointModifyItem.setEnabled(false);
        this.breakpointModifyItem.addActionListener(actionEvent -> this.modifyBreakpoint());
        jPopupMenu.add(this.breakpointModifyItem);
        this.breakpointAddItem = new JMenuItem("New", new ImageIcon(GraphUtilities.getImage("add_item.gif")));
        this.breakpointAddItem.addActionListener(actionEvent -> this.newBreakpoint());
        jPopupMenu.add(this.breakpointAddItem);
        this.breakpointRemoveItem = new JMenuItem("Remove", new ImageIcon(GraphUtilities.getImage("remove.gif")));
        this.breakpointRemoveItem.setEnabled(false);
        this.breakpointRemoveItem.addActionListener(actionEvent -> this.removeBreakpoint());
        jPopupMenu.add(this.breakpointRemoveItem);
        this.breakpointRemoveAllItem = new JMenuItem("Remove all", new ImageIcon(GraphUtilities.getImage("removeall.gif")));
        this.breakpointRemoveAllItem.setEnabled(false);
        this.breakpointRemoveAllItem.addActionListener(actionEvent -> this.removeAllBreakpoints());
        jPopupMenu.add(this.breakpointRemoveAllItem);
        this.breakpointTable.addKeyListener(IsguiUtility.keyPressedAdapter(keyEvent -> {
            if (keyEvent.getKeyCode() == 127 && this.breakpointTable.getSelectedRowCount() > 0) {
                this.removeBreakpoint();
            }
            this.surrogateLineCommandListener.keyPressed((KeyEvent)keyEvent);
        }));
        this.breakpointTable.addMouseListener(new GraphUtilities.PopupMouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Breakpoint breakpoint;
                if (mouseEvent.getClickCount() == 2 && (breakpoint = (Breakpoint)DebugPanel.this.breakpointModel.elementAt(DebugPanel.this.breakpointTable.getSelectedRow())) != null) {
                    String string = ((DebugPanel)DebugPanel.this).tFileObj.tf.getClassName();
                    if (!string.equals(breakpoint.getProgram())) {
                        LocalDebugInfo localDebugInfo = DebugPanel.this.graphDebug.getInvoker().getInfo(breakpoint.getProgram(), DebugPanel.this.graphDebug.isProcessing(), true);
                        if (localDebugInfo != null) {
                            String string2 = localDebugInfo.getSourcefile() != null ? DebugPanel.this.getRealPath(localDebugInfo.getSourcefile()) : "";
                            DebugPanel.this.load(localDebugInfo, new Filename(string2), localDebugInfo.getTimestamp(), true);
                        } else {
                            DebugPanel.this.load(null, new Filename(breakpoint.getFile()), 0L, false);
                        }
                    }
                    DebugPanel.this.goTo(breakpoint.getLine(), null, breakpoint.getFileIndex());
                }
            }

            @Override
            public void showPopup(MouseEvent mouseEvent) {
                jPopupMenu.show(DebugPanel.this.breakpointTable, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.breakpointTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.breakpointTableSelectionChanged(this.breakpointTable.getSelectedRowCount()));
    }

    private void buildMonitorArea() {
        int n2;
        this.monitorPanel = new JPanel(new BorderLayout(0, 0));
        this.monitorButtonPanel = new JToolBar();
        this.monitorButtonPanel.setFloatable(false);
        this.monitorEnAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("checkall.gif")), "Enable all", false, actionEvent -> this.enableAllMonitors());
        this.monitorButtonPanel.add(this.monitorEnAllBtn);
        this.monitorDisAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("uncheckall.gif")), "Disable all", false, actionEvent -> this.disableAllMonitors());
        this.monitorButtonPanel.add(this.monitorDisAllBtn);
        this.monitorModifyBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("edit.gif")), "Modify", false, actionEvent -> this.modifyMonitor());
        this.monitorButtonPanel.add(this.monitorModifyBtn);
        this.monitorAddBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("add_item.gif")), "New", true, actionEvent -> this.newMonitor());
        this.monitorButtonPanel.add(this.monitorAddBtn);
        this.monitorRemoveBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("remove.gif")), "Remove", false, actionEvent -> this.removeMonitor());
        this.monitorButtonPanel.add(this.monitorRemoveBtn);
        this.monitorRemoveAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("removeall.gif")), "Remove all", false, actionEvent -> this.removeAllMonitors());
        this.monitorButtonPanel.add(this.monitorRemoveAllBtn);
        this.monitorPanel.add((Component)this.monitorButtonPanel, "North");
        this.monitorModel = new MonitorModel(this.graphDebug);
        this.monitorTable = new JTreeTable(this.monitorModel);
        this.monitorTable.setDefaultEditor(String.class, GraphUtilities.getValueEditor(this.monitorTable));
        this.monitorTable.setRootVisible(false);
        this.monitorTable.setEnabled(true);
        this.monitorTable.setToolTipText("Type 'Canc' to remove the selected monitor");
        this.monitorTable.setFont(monListFont);
        this.monitorTable.setBackground(monListBackground);
        this.monitorTable.setForeground(monListForeground);
        this.monitorTable.setSelectionBackground(monListSelBackground);
        this.monitorTable.setSelectionForeground(monListSelForeground);
        this.monitorTable.setSelectionMode(0);
        this.monitorTable.setRowSelectionAllowed(true);
        this.monitorTable.setFillsViewportHeight(true);
        this.monitorTable.setColumnSelectionAllowed(false);
        this.monitorTable.getTableHeader().setReorderingAllowed(false);
        this.monitorTable.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.monitorTable.getColumnModel().getColumn(0).setMaxWidth(35);
        this.monitorTable.getColumnModel().getColumn(0).setResizable(false);
        this.monitorPanel.add((Component)DebugPanel.createJScrollPane(this.monitorTable), "Center");
        int n3 = Settings.getMonitorTableNameColumnWidth();
        if (n3 >= 0) {
            this.monitorTable.getColumnModel().getColumn(1).setPreferredWidth(n3);
        }
        if ((n2 = Settings.getMonitorTableValueColumnWidth()) >= 0) {
            this.monitorTable.getColumnModel().getColumn(2).setPreferredWidth(n2);
        }
        this.monitorTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.monitorTableSelectionChanged(this.monitorTable.getSelectedRowCount()));
        final JPopupMenu jPopupMenu = new JPopupMenu();
        this.monitorEnAllItem = new JMenuItem("Enable all", new ImageIcon(GraphUtilities.getImage("checkall.gif")));
        this.monitorEnAllItem.setEnabled(false);
        this.monitorEnAllItem.addActionListener(actionEvent -> this.enableAllMonitors());
        jPopupMenu.add(this.monitorEnAllItem);
        this.monitorDisAllItem = new JMenuItem("Disable all", new ImageIcon(GraphUtilities.getImage("uncheckall.gif")));
        this.monitorDisAllItem.setEnabled(false);
        this.monitorDisAllItem.addActionListener(actionEvent -> this.disableAllMonitors());
        jPopupMenu.add(this.monitorDisAllItem);
        jPopupMenu.addSeparator();
        this.monitorModifyItem = new JMenuItem("Modify", new ImageIcon(GraphUtilities.getImage("edit.gif")));
        this.monitorModifyItem.setEnabled(false);
        this.monitorModifyItem.addActionListener(actionEvent -> this.modifyMonitor());
        jPopupMenu.add(this.monitorModifyItem);
        this.monitorAddItem = new JMenuItem("New", new ImageIcon(GraphUtilities.getImage("add_item.gif")));
        this.monitorAddItem.addActionListener(actionEvent -> this.newMonitor());
        jPopupMenu.add(this.monitorAddItem);
        this.monitorRemoveItem = new JMenuItem("Remove", new ImageIcon(GraphUtilities.getImage("remove.gif")));
        this.monitorRemoveItem.setEnabled(false);
        this.monitorRemoveItem.addActionListener(actionEvent -> this.removeMonitor());
        jPopupMenu.add(this.monitorRemoveItem);
        this.monitorRemoveAllItem = new JMenuItem("Remove all", new ImageIcon(GraphUtilities.getImage("removeall.gif")));
        this.monitorRemoveAllItem.setEnabled(false);
        this.monitorRemoveAllItem.addActionListener(actionEvent -> this.removeAllMonitors());
        jPopupMenu.add(this.monitorRemoveAllItem);
        this.monitorTable.addKeyListener(IsguiUtility.keyPressedAdapter(keyEvent -> {
            if (!this.graphDebug.isProcessing() && keyEvent.getKeyCode() == 127 && this.monitorTable.getSelectedRow() >= 0) {
                this.removeMonitor();
            }
            this.surrogateLineCommandListener.keyPressed((KeyEvent)keyEvent);
        }));
        this.monitorTable.addMouseListener(new GraphUtilities.PopupMouseListener(){

            @Override
            public void showPopup(MouseEvent mouseEvent) {
                jPopupMenu.show(DebugPanel.this.monitorTable, mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    private void buildCommandHistoryArea() {
        this.commandHistoryPanel = new JPanel(new BorderLayout(0, 0));
        this.commandHistoryButtonPanel = new JToolBar();
        this.commandHistoryButtonPanel.setFloatable(false);
        this.commandExecuteBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("execute.gif")), "Execute", false, actionEvent -> this.graphDebug.executeCommand(this.commandHistory.getSelectedValue().toString()));
        this.commandHistoryButtonPanel.add(this.commandExecuteBtn);
        this.clearHistoryBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("removeall.gif")), "Clear history", false, actionEvent -> this.clearCommandHistory());
        this.commandHistoryButtonPanel.add(this.clearHistoryBtn);
        this.commandHistoryPanel.add((Component)this.commandHistoryButtonPanel, "North");
        this.commandHistoryModel = new DefaultListModel();
        this.commandHistory = new JList(this.commandHistoryModel);
        this.commandHistory.setSelectionMode(0);
        this.commandHistory.setFont(cmdHistoryFont);
        this.commandHistory.setBackground(cmdHistoryBackground);
        this.commandHistory.setForeground(cmdHistoryForeground);
        this.commandHistory.setSelectionBackground(cmdHistorySelBackground);
        this.commandHistory.setSelectionForeground(cmdHistorySelForeground);
        this.commandHistoryPanel.add((Component)DebugPanel.createJScrollPane(this.commandHistory), "Center");
        this.commandHistory.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            this.commandExecuteBtn.setEnabled(this.commandHistory.getSelectedIndex() >= 0);
            this.commandExecuteItem.setEnabled(this.commandHistory.getSelectedIndex() >= 0);
        });
        final JPopupMenu jPopupMenu = new JPopupMenu();
        this.commandExecuteItem = new JMenuItem("Execute", new ImageIcon(GraphUtilities.getImage("execute.gif")));
        this.commandExecuteItem.setEnabled(false);
        this.commandExecuteItem.addActionListener(actionEvent -> this.graphDebug.executeCommand(this.commandHistory.getSelectedValue().toString()));
        jPopupMenu.add(this.commandExecuteItem);
        this.clearHistoryItem = new JMenuItem("Clear history", new ImageIcon(GraphUtilities.getImage("removeall.gif")));
        this.clearHistoryItem.setEnabled(false);
        this.clearHistoryItem.addActionListener(actionEvent -> this.clearCommandHistory());
        jPopupMenu.add(this.clearHistoryItem);
        this.commandHistory.addMouseListener(new GraphUtilities.PopupMouseListener(){

            @Override
            public void showPopup(MouseEvent mouseEvent) {
                jPopupMenu.show(DebugPanel.this.commandHistory, mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && DebugPanel.this.commandHistory.getSelectedIndex() >= 0) {
                    DebugPanel.this.graphDebug.executeCommand(DebugPanel.this.commandHistory.getSelectedValue().toString());
                }
            }
        });
        this.commandHistory.addKeyListener(this.surrogateLineCommandListener);
    }

    private void setRedirectStreams(boolean bl) {
        if (bl != Settings.isConsoleAttached()) {
            this.setRedirectStreams0(bl);
            Settings.setConsoleAttached(bl);
        }
    }

    private void setRedirectStreams0(boolean bl) {
        if (this.graphDebug.getInvoker().isRemoteDebug()) {
            this.graphDebug.getInvoker().processCommand(new SetRedirectStreamsCommand(bl));
        }
        if (bl) {
            this.overwriteSysOut();
            this.overwriteSysErr();
        } else {
            GraphUtilities.setOut(GraphUtilities.systemOut);
            GraphUtilities.setErr(GraphUtilities.systemErr);
        }
    }

    public void updateConsoleButtons() {
        if (this.graphDebug.isRemoteThinClient()) {
            return;
        }
        boolean bl = Settings.isConsoleAttached();
        if (this.consoleAttachedBtn.isSelected() != bl) {
            this.consoleAttachedBtn.setSelected(bl);
            this.consoleAttachedItem.setSelected(bl);
            this.setRedirectStreams0(bl);
        }
        bl = Settings.isShowConsole();
        if (this.showConsoleBtn.isSelected() != bl) {
            this.showConsoleBtn.setSelected(bl);
            this.showConsoleItem.setSelected(bl);
        }
    }

    private void buildConsoleArea() {
        this.consolePanel = new JPanel(new BorderLayout(0, 0));
        this.consoleButtonPanel = new JToolBar();
        this.consoleButtonPanel.setFloatable(false);
        this.consoleAttachedBtn = new ToggleImageButton("Attached", GraphUtilities.getImage("attached.gif"), actionEvent -> {
            boolean bl = this.consoleAttachedBtn.isSelected();
            this.setRedirectStreams(bl);
        }, Settings.isConsoleAttached());
        this.consoleButtonPanel.add(this.consoleAttachedBtn);
        this.consoleAttachedBtn.setEnabled(!this.graphDebug.isRemoteThinClient());
        this.showConsoleBtn = new ToggleImageButton("Show Console when the content changes", GraphUtilities.getImage("showconsole.png"), actionEvent -> Settings.setShowConsole(this.showConsoleBtn.isSelected()), Settings.isShowConsole());
        this.consoleButtonPanel.add(this.showConsoleBtn);
        this.clearConsoleBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("clearconsole.png")), "Clear Console", true, actionEvent -> this.console.setText(""));
        this.consoleButtonPanel.add(this.clearConsoleBtn);
        this.consolePanel.add((Component)this.consoleButtonPanel, "North");
        this.console = new JTextPane();
        this.console.setFont(consoleFont);
        this.console.setBackground(consoleBackground);
        this.console.setForeground(consoleForeground);
        this.console.setSelectionColor(consoleSelBackground);
        this.console.setSelectedTextColor(consoleSelForeground);
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.console.getStyledDocument().addStyle("stderr", style);
        StyleConstants.setForeground(style2, consoleStdErrForeground);
        this.console.setEditable(false);
        this.console.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (Settings.isShowConsole()) {
                    DebugPanel.this.selectConsoleTab();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.consolePanel.add((Component)DebugPanel.createJScrollPane(this.console), "Center");
        this.console.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.console){

            @Override
            protected void fillPopup() {
                super.fillPopup();
                this.popup.add(new JPopupMenu.Separator());
                DebugPanel.this.consoleAttachedItem = new JCheckBoxMenuItem(DebugPanel.this.consoleAttachedBtn.getToolTipText(), new ImageIcon(GraphUtilities.getImage("attached.gif")));
                DebugPanel.this.consoleAttachedItem.setSelected(true);
                DebugPanel.this.consoleAttachedItem.addActionListener(actionEvent -> {
                    boolean bl = DebugPanel.this.consoleAttachedItem.isSelected();
                    DebugPanel.this.setRedirectStreams(bl);
                });
                DebugPanel.this.consoleAttachedItem.setEnabled(!DebugPanel.this.graphDebug.isRemoteThinClient());
                this.popup.add(DebugPanel.this.consoleAttachedItem);
                DebugPanel.this.showConsoleItem = new JCheckBoxMenuItem(DebugPanel.this.showConsoleBtn.getToolTipText(), new ImageIcon(GraphUtilities.getImage("showconsole.png")));
                DebugPanel.this.showConsoleItem.addActionListener(actionEvent -> Settings.setShowConsole(DebugPanel.this.showConsoleItem.isSelected()));
                this.popup.add(DebugPanel.this.showConsoleItem);
                DebugPanel.this.clearConsoleItem = new JMenuItem(DebugPanel.this.clearConsoleBtn.getToolTipText(), new ImageIcon(GraphUtilities.getImage("clearconsole.png")));
                DebugPanel.this.clearConsoleItem.addActionListener(actionEvent -> DebugPanel.this.console.setText(""));
                this.popup.add(DebugPanel.this.clearConsoleItem);
            }
        });
        this.console.addKeyListener(this.surrogateLineCommandListener);
    }

    private void buildVariableArea() {
        int n2;
        this.variableLabel = new JLabel();
        this.variableTabbedPane = new JTabbedPane();
        this.variableTabbedPane.setFocusable(false);
        this.variablesPanel = new JPanel(new BorderLayout(0, 0));
        this.varRootNode[0] = new VariableNode("Current Variables", null, null, null);
        this.varRootNode[1] = new VariableNode("Watched Variables", null, null, null);
        for (int i2 = 0; i2 < this.varRootNode.length; ++i2) {
            this.varModel[i2] = new MyVariableModel(this.varRootNode[i2], false);
        }
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.varExpandAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("expandall.gif")), "Expand all", true, actionEvent -> {
            for (int i2 = 0; i2 < this.varModel.length; ++i2) {
                GraphUtilities.expandNode(this.varTree[i2], this.varModel[i2].getRootNode());
            }
        });
        jToolBar.add(this.varExpandAllBtn);
        this.varCollapseAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("collapseall.gif")), "Collapse all", true, actionEvent -> {
            for (int i2 = 0; i2 < this.varModel.length; ++i2) {
                GraphUtilities.collapseNode(this.varTree[i2], this.varModel[i2].getRootNode());
            }
        });
        jToolBar.add(this.varCollapseAllBtn);
        this.varChangeValueBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("changevalue.gif")), "Change value", false, actionEvent -> this.changeValue());
        jToolBar.add(this.varChangeValueBtn);
        this.varAddMonBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("newmonitor.gif")), "Add monitor", false, actionEvent -> this.addMonitor());
        jToolBar.add(this.varAddMonBtn);
        this.varAutoRefreshBtn = new ToggleImageButton("Auto Refresh", GraphUtilities.getImage("refresh.gif"), actionEvent -> {
            if (this.varAutoRefreshBtn.isSelected()) {
                this.refreshVariables();
            }
            this.varAutoRefreshItem.setSelected(this.varAutoRefreshBtn.isSelected());
        }, false);
        this.varAutoRefreshBtn.setSelected(true);
        jToolBar.add(this.varAutoRefreshBtn);
        this.varHexBtn = new ToggleImageButton("Show Hex Values", GraphUtilities.getImage("hex.gif"), actionEvent -> {
            for (int i2 = 0; i2 < this.varModel.length; ++i2) {
                this.varModel[i2].setShowHexValues(this.varHexBtn.isSelected());
            }
            this.refreshVariables();
            this.varHexItem.setSelected(this.varHexBtn.isSelected());
        }, false);
        jToolBar.add(this.varHexBtn);
        jToolBar.add(this.newToolBarSeparator(new Dimension(4, DebugPanel.BTN_SIZE.height - 2), false));
        jToolBar.add(this.newToolBarSeparator());
        jToolBar.add(this.newToolBarSeparator(new Dimension(4, DebugPanel.BTN_SIZE.height - 2), false));
        this.varAddBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("add_item.gif")), "New watched variable", true, actionEvent -> this.addWatchedVar());
        jToolBar.add(this.varAddBtn);
        this.varRemoveBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("remove.gif")), "Remove", false, actionEvent -> this.removeWatchedVar());
        jToolBar.add(this.varRemoveBtn);
        this.varRemoveAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("removeall.gif")), "Remove All", false, actionEvent -> this.removeAllWatchedVars());
        jToolBar.add(this.varRemoveAllBtn);
        this.variablesPanel.add((Component)jToolBar, "North");
        this.varSplitPane = new JSplitPane(0);
        for (int i3 = 0; i3 < this.varTreeTable.length; ++i3) {
            this.varTreeTable[i3] = new JTreeTable(this.varModel[i3]);
            this.varScrollPane[i3] = DebugPanel.createJScrollPane(this.varTreeTable[i3]);
            this.varTreeTable[i3].setRootVisible(false);
            this.varTreeTable[i3].getTreeTableCellRenderer().setShowsRootHandles(true);
            this.varTreeTable[i3].setSelectionMode(0);
            this.varTreeTable[i3].setRowSelectionAllowed(true);
            this.varTreeTable[i3].setFillsViewportHeight(true);
            this.varTreeTable[i3].setColumnSelectionAllowed(false);
            this.varTreeTable[i3].getTableHeader().setReorderingAllowed(false);
            this.varTreeTable[i3].setFont(disTreeFont);
            this.varTreeTable[i3].setBackground(disTreeBackground);
            this.varTreeTable[i3].setForeground(disTreeForeground);
            this.varTreeTable[i3].setSelectionBackground(disTreeSelBackground);
            this.varTreeTable[i3].setSelectionForeground(disTreeSelForeground);
            this.varTreeTable[i3].setDefaultEditor(String.class, GraphUtilities.getValueEditor(this.varTreeTable[i3]));
            this.varTabbed[i3] = new JTabbedPane();
            this.varTabbed[i3].setFocusable(false);
            if (i3 == 0) {
                this.varTabbed[i3].addTab("Current Variables", this.varScrollPane[i3]);
                this.varSplitPane.setTopComponent(this.varTabbed[i3]);
            } else {
                this.varTabbed[i3].addTab("Watched Variables", this.varScrollPane[i3]);
                this.varSplitPane.setBottomComponent(this.varTabbed[i3]);
            }
            this.varTree[i3] = this.varTreeTable[i3].getTreeTableCellRenderer();
            this.varTree[i3].setFont(disTreeFont);
            this.varTree[i3].setBackground(disTreeBackground);
            this.varTree[i3].setForeground(disTreeForeground);
            this.varTree[i3].setCellRenderer(new DefaultTreeCellRenderer(){
                private static final long serialVersionUID = 123L;

                @Override
                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
                    super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n2, bl4);
                    this.setIcon(null);
                    this.setOpaque(true);
                    if (bl) {
                        this.setBackground(disTreeSelBackground);
                        this.setForeground(disTreeSelForeground);
                    } else {
                        this.setBackground(disTreeBackground);
                        this.setForeground(disTreeForeground);
                    }
                    this.doLayout();
                    return this;
                }
            });
            n2 = i3;
            this.varTree[i3].addTreeSelectionListener(treeSelectionEvent -> {
                Object object = this.varTree[n2].getLastSelectedPathComponent();
                boolean bl = this.varAutoRefreshBtn.isEnabled();
                this.varChangeValueBtn.setEnabled(bl && object != null);
                this.varAddMonBtn.setEnabled(bl && object != null);
                this.varRemoveBtn.setEnabled(bl && object != null && n2 == 1 && ((VariableNode)object).getParent() == this.varRootNode[n2]);
                if (object != null) {
                    int n3 = n2 == 1 ? 0 : 1;
                    this.varTree[n3].clearSelection();
                }
            });
            this.varTree[i3].addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                    VariableNode variableNode = (VariableNode)treeExpansionEvent.getPath().getLastPathComponent();
                    if (variableNode.getChildCount() == 0) {
                        if (DebugPanel.this.graphDebug.isProcessing()) {
                            throw new ExpandVetoException(treeExpansionEvent);
                        }
                        try {
                            DisplayCommand displayCommand = new DisplayCommand(new VarName(new DebugTM(variableNode.getName())), variableNode.getClassName(), true, true, 1);
                            displayCommand.setDisplayAsText(true);
                            DebugResponse debugResponse = DebugPanel.this.graphDebug.getInvoker().processCommand(displayCommand);
                            Tree[] treeArray = debugResponse.getTrees();
                            if (treeArray != null && treeArray.length > 0) {
                                boolean bl = treeArray[0].isHex();
                                TreeNode treeNode = treeArray[0].getRoot();
                                TreeNode[] treeNodeArray = treeNode.getChildren();
                                for (int i2 = 0; i2 < treeNodeArray.length; ++i2) {
                                    GraphUtilities.buildVariableNode(treeNodeArray[i2], treeArray[0].getClassName(), variableNode, bl);
                                }
                            }
                        }
                        catch (DebuggerException debuggerException) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                }
            });
            this.varTreeTable[i3].addKeyListener(this.surrogateLineCommandListener);
        }
        this.variablesPanel.add((Component)this.varSplitPane, "Center");
        final JPopupMenu jPopupMenu = new JPopupMenu();
        this.varExpandAllItem = new JMenuItem("Expand all", new ImageIcon(GraphUtilities.getImage("expandall.gif")));
        this.varExpandAllItem.addActionListener(actionEvent -> {
            for (int i2 = 0; i2 < this.varModel.length; ++i2) {
                GraphUtilities.expandNode(this.varTree[i2], this.varModel[i2].getRootNode());
            }
        });
        jPopupMenu.add(this.varExpandAllItem);
        this.varCollapseAllItem = new JMenuItem("Collapse all", new ImageIcon(GraphUtilities.getImage("collapseall.gif")));
        this.varCollapseAllItem.addActionListener(actionEvent -> {
            for (int i2 = 0; i2 < this.varModel.length; ++i2) {
                GraphUtilities.collapseNode(this.varTree[i2], this.varModel[i2].getRootNode());
            }
        });
        jPopupMenu.add(this.varCollapseAllItem);
        jPopupMenu.addSeparator();
        this.varChangeValueItem = new JMenuItem("Change value", new ImageIcon(GraphUtilities.getImage("changevalue.gif")));
        this.varChangeValueItem.addActionListener(actionEvent -> this.changeValue());
        jPopupMenu.add(this.varChangeValueItem);
        this.varAddMonitorItem = new JMenuItem("Add monitor", new ImageIcon(GraphUtilities.getImage("newmonitor.gif")));
        this.varAddMonitorItem.addActionListener(actionEvent -> this.addMonitor());
        jPopupMenu.add(this.varAddMonitorItem);
        this.varAutoRefreshItem = new JCheckBoxMenuItem("Auto Refresh", new ImageIcon(GraphUtilities.getImage("refresh.gif")));
        this.varAutoRefreshItem.setSelected(true);
        this.varAutoRefreshItem.addActionListener(actionEvent -> {
            if (this.varAutoRefreshItem.isSelected()) {
                this.refreshVariables();
            }
            this.varAutoRefreshBtn.setSelected(this.varAutoRefreshItem.isSelected());
        });
        jPopupMenu.add(this.varAutoRefreshItem);
        this.varHexItem = new JCheckBoxMenuItem("Show Hex Values", new ImageIcon(GraphUtilities.getImage("hex.gif")));
        this.varHexItem.setSelected(false);
        this.varHexItem.addActionListener(actionEvent -> {
            for (int i2 = 0; i2 < this.varModel.length; ++i2) {
                this.varModel[i2].setShowHexValues(this.varHexItem.isSelected());
            }
            this.refreshVariables();
            this.varHexBtn.setSelected(this.varHexItem.isSelected());
        });
        jPopupMenu.add(this.varHexItem);
        jPopupMenu.addSeparator();
        this.varAddItem = new JMenuItem("New watched variable", new ImageIcon(GraphUtilities.getImage("add_item.gif")));
        this.varAddItem.addActionListener(actionEvent -> this.addWatchedVar());
        jPopupMenu.add(this.varAddItem);
        this.varRemoveItem = new JMenuItem("Remove", new ImageIcon(GraphUtilities.getImage("remove.gif")));
        this.varRemoveItem.addActionListener(actionEvent -> this.removeWatchedVar());
        jPopupMenu.add(this.varRemoveItem);
        this.varRemoveAllItem = new JMenuItem("Remove All", new ImageIcon(GraphUtilities.getImage("removeall.gif")));
        this.varRemoveAllItem.addActionListener(actionEvent -> this.removeAllWatchedVars());
        jPopupMenu.add(this.varRemoveAllItem);
        jPopupMenu.addSeparator();
        this.varCopyItem = new JMenuItem("Copy");
        this.varCopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.varCopyItem.addActionListener(actionEvent -> {
            JTreeTable jTreeTable = this.varTreeTable[Integer.parseInt(this.varCopyItem.getActionCommand())];
            ActionMap actionMap = jTreeTable.getActionMap();
            Action action = actionMap.get("copy");
            action.actionPerformed(new ActionEvent(jTreeTable, 1001, "copy"));
        });
        jPopupMenu.add(this.varCopyItem);
        for (n2 = 0; n2 < this.varTreeTable.length; ++n2) {
            final int n3 = n2;
            this.varTreeTable[n2].addMouseListener(new GraphUtilities.PopupMouseListener(){

                @Override
                public void showPopup(MouseEvent mouseEvent) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    Object object = DebugPanel.this.varTree[n3].getLastSelectedPathComponent();
                    boolean bl = DebugPanel.this.refreshItem.isEnabled();
                    DebugPanel.this.varChangeValueItem.setEnabled(bl && object != null);
                    DebugPanel.this.varAddMonitorItem.setEnabled(bl && object != null);
                    DebugPanel.this.varRemoveItem.setEnabled(n3 == 1 && object != null && ((VariableNode)object).getParent() == DebugPanel.this.varRootNode[n3]);
                    DebugPanel.this.varRemoveAllItem.setEnabled(DebugPanel.this.watchedVarnames.size() > 0);
                    DebugPanel.this.varCopyItem.setEnabled(bl && object != null);
                    DebugPanel.this.varCopyItem.setActionCommand("" + n3);
                }
            });
        }
        this.variableTabbedPane.addTab("Variables", null, this.variablesPanel, null);
    }

    private void buildOutputArea() {
        this.outputArea = new JPanel();
        this.outputArea.setLayout(new BorderLayout(1, 1));
        this.textOutput = new JTextArea();
        this.textOutput.setFont(outputFont);
        this.textOutput.setBackground(outputBackground);
        this.textOutput.setForeground(outputForeground);
        this.textOutput.setCaretColor(outputForeground);
        this.textOutput.setSelectionColor(outputSelBackground);
        this.textOutput.setSelectedTextColor(outputSelForeground);
        this.textOutput.setEditable(false);
        this.textOutput.setLineWrap(true);
        this.textOutput.setWrapStyleWord(true);
        this.textOutput.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.textOutput){

            @Override
            protected void fillPopup() {
                super.fillPopup();
                this.popup.add(new JPopupMenu.Separator());
                DebugPanel.this.textOutputClearItem = new JMenuItem("Clear");
                DebugPanel.this.textOutputClearItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        textComponent.setText("");
                    }
                });
                this.popup.add(DebugPanel.this.textOutputClearItem);
            }
        });
        this.textOutput.addKeyListener(this.surrogateLineCommandListener);
        this.scrollTextOutput = DebugPanel.createJScrollPane(this.textOutput);
        this.lineCommand = new JTextField(){
            private static final long serialVersionUID = 123L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 25);
            }
        };
        this.lineCommand.addActionListener(actionEvent -> {
            if (this.graphDebug.isProcessing() && this.graphDebug.isRunning() && !this.graphDebug.isCommandAllowedInProcessing(this.lineCommand.getText())) {
                this.graphDebug.getInvoker().putInput(actionEvent.getActionCommand());
                this.lineCommand.setText("");
            } else {
                String[] stringArray = this.graphDebug.setTextCommand(this.lineCommand.getText());
                if (stringArray != null) {
                    this.lineCommand.setText(stringArray[0]);
                    if (stringArray.length > 1) {
                        this.lineCommand.setCaretPosition(Integer.parseInt(stringArray[1]));
                    }
                } else {
                    this.lineCommand.setText("");
                }
            }
        });
        this.lineCommand.addKeyListener(this.globalKeyListener);
        this.lineCommand.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.lineCommand.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.lineCommand.setFont(inputFont);
        this.lineCommand.setBackground(inputBackground);
        this.lineCommand.setForeground(inputForeground);
        this.lineCommand.setCaretColor(inputForeground);
        this.lineCommand.setSelectionColor(inputSelBackground);
        this.lineCommand.setSelectedTextColor(inputSelForeground);
        this.lineCommand.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.lineCommand));
    }

    void changeValue() {
        String string;
        Object object = null;
        for (int i2 = 0; i2 < this.varTree.length && (object = this.varTree[i2].getLastSelectedPathComponent()) == null; ++i2) {
        }
        if (object == null) {
            return;
        }
        VariableNode variableNode = (VariableNode)object;
        String string2 = GraphUtilities.nodeToVarname(variableNode);
        String string3 = null;
        String string4 = "display";
        boolean bl = Settings.getHexOption();
        if (bl) {
            string4 = string4 + " -x";
        }
        if ((string = variableNode.getClassName()) != null) {
            string4 = string4 + " -c " + string;
        }
        string4 = string4 + " " + string2;
        DebugResponse debugResponse = this.graphDebug.getInvoker().processCommand(string4);
        if (debugResponse != null && debugResponse.getReturnCode() == 0) {
            string3 = debugResponse.getVarValue().trim();
            if (debugResponse.getVarType() == 12) {
                string3 = string3.substring(0, string3.indexOf(32));
                bl = false;
            }
        }
        if ((string4 = this.graphDebug.showAcceptVariableDialog(string2, string, string3, null, bl)) != null && (debugResponse = this.graphDebug.getInvoker().processCommand(string4)) != null) {
            if (debugResponse.getReturnCode() == 0) {
                this.refreshVariables();
            } else {
                this.outputResult0(debugResponse.getMessage());
            }
        }
    }

    private void newMonitor() {
        this.graphDebug.showMonitorDialog();
    }

    void addMonitor() {
        VariableNode variableNode = null;
        for (int i2 = 0; i2 < this.varTree.length && (variableNode = (VariableNode)this.varTree[i2].getLastSelectedPathComponent()) == null; ++i2) {
        }
        if (variableNode == null) {
            return;
        }
        String string = GraphUtilities.nodeToVarname(variableNode);
        String string2 = "display " + string;
        boolean bl = Settings.getHexOption();
        DebugResponse debugResponse = this.graphDebug.getInvoker().processCommand(string2);
        if (debugResponse != null && debugResponse.getReturnCode() == 0 && debugResponse.getVarType() == 12) {
            bl = false;
        }
        this.graphDebug.showMonitorDialog(string, this.getSelectedModule(), null, true, bl);
    }

    private void addWatchedVar() {
        this.graphDebug.showDisplayVariableDialog(null, null, true);
    }

    private void removeWatchedVar() {
        VariableNode variableNode = (VariableNode)this.varTree[1].getLastSelectedPathComponent();
        if (variableNode == null || variableNode.getParent() != this.varRootNode[1]) {
            return;
        }
        int n2 = this.varRootNode[1].getIndex(variableNode);
        if (n2 >= 0) {
            VariableNode variableNode2 = (VariableNode)this.varRootNode[1].getChildAt(n2);
            String string = variableNode2.getName();
            String string2 = variableNode2.getClassName();
            this.removeFromWatchedVarNames(string, string2, this.watchedVarnames);
            this.varRemoveAllBtn.setEnabled(this.watchedVarnames.size() > 0);
            this.varRootNode[1].removeChildAt(n2);
            this.varTreeTable[1].reload();
        }
    }

    private void removeFromWatchedVarNames(String string, String string2, List<String[]> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String[] stringArray = list.get(i2);
            if (!stringArray[0].equals(string) || (string2 == null || !string2.equals(stringArray[1])) && (string2 != null || stringArray[1] != null)) continue;
            list.remove(i2);
            break;
        }
    }

    private void removeAllWatchedVars() {
        this.watchedVarnames.clear();
        this.varRemoveAllBtn.setEnabled(false);
        this.varRootNode[1].removeAllChildren();
        this.varTreeTable[1].reload();
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout(1, 1));
        this.buildToolBar();
        this.add((Component)this.toolbar, "North");
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setResizeWeight(1.0);
        this.add((Component)this.mainSplitPane, "Center");
        this.buildVariableArea();
        this.buildOutputArea();
        this.topSplitPane = new JSplitPane(1);
        this.topSplitPane.setOneTouchExpandable(true);
        this.topSplitPane.setResizeWeight(1.0);
        this.bottomSplitPane = new JSplitPane(1);
        this.bottomSplitPane.setOneTouchExpandable(true);
        this.buildMonitorArea();
        this.buildBreakpointArea();
        this.buildCallStackArea();
        this.buildThreadArea();
        this.buildCommandHistoryArea();
        this.buildConsoleArea();
        this.bottomRightTabbedPane = new JTabbedPane();
        this.bottomRightTabbedPane.setFocusable(false);
        this.bottomRightTabbedPane.setTabLayoutPolicy(0);
        this.bottomRightTabbedPane.add(PERF_STACK_TITLE, this.callStackPanel);
        this.bottomRightTabbedPane.add(MONITORS_TITLE, this.monitorPanel);
        this.bottomRightTabbedPane.add(BREAKPOINTS_TITLE, this.breakpointPanel);
        this.bottomRightTabbedPane.add(THREADS_TITLE, this.threadPanel);
        this.bottomRightTabbedPane.add(COMMAND_HISTORY_TITLE, this.commandHistoryPanel);
        this.bottomRightTabbedPane.add(CONSOLE_TITLE, this.consolePanel);
        this.bottomRightTabbedPane.setMnemonicAt(0, 80);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(0, 0);
        this.bottomRightTabbedPane.setMnemonicAt(1, 77);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(1, 0);
        this.bottomRightTabbedPane.setMnemonicAt(2, 66);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(2, 0);
        this.bottomRightTabbedPane.setMnemonicAt(3, 84);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(3, 0);
        this.bottomRightTabbedPane.setMnemonicAt(4, 67);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(4, 0);
        this.bottomRightTabbedPane.setMnemonicAt(5, 79);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(5, 1);
        this.outputArea.add((Component)this.lineCommand, "South");
        this.outputArea.add((Component)this.scrollTextOutput, "Center");
        this.topSplitPane.setLeftComponent(this.previewPanel);
        this.topSplitPane.setRightComponent(this.variableLabel);
        this.bottomSplitPane.setLeftComponent(this.outputArea);
        this.bottomSplitPane.setRightComponent(this.bottomRightTabbedPane);
        this.mainSplitPane.setTopComponent(this.topSplitPane);
        this.mainSplitPane.setBottomComponent(this.bottomSplitPane);
        this.tipTimer = new Timer(Settings.getVariableHintDelay(), this.tipAction);
        this.tipTimer.setRepeats(false);
        this.handMouseTimer = new Timer(Settings.getVariableHandMouseDelay(), this.handMouseAction);
        this.handMouseTimer.setRepeats(false);
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        int n2 = object instanceof Integer ? (Integer)object : 500;
        this.linkTimer = new Timer(n2, actionEvent -> {
            int n2;
            LocalDebugInfo.Location location;
            if (this.highlightedVar != null && DebugPanel.isLink(this.highlightVarType) && this.highlightedVarLine >= 0 && (location = this.getMemberLocation(this.tFileObj.ldInfo, this.highlightedVar, n2 = this.getListingline(this.highlightedVarLine))) != null) {
                this.goTo(location.line, null, location.fileIndex);
                this.setHighlightedVar(null, HighlightVarType.NONE, -1, -1);
            }
        });
        this.linkTimer.setRepeats(false);
    }

    private void disableAllBreakpoints() {
        if (!(this.breakpointModel.isEmpty() || this.graphDebug.isProcessing() && this.graphDebug.stopImmediately)) {
            this.graphDebug.setAllBreakpointsEnabledCommand(false);
        }
    }

    private void enableAllBreakpoints() {
        if (!(this.breakpointModel.isEmpty() || this.graphDebug.isProcessing() && this.graphDebug.stopImmediately)) {
            this.graphDebug.setAllBreakpointsEnabledCommand(true);
        }
    }

    private void monitorTableSelectionChanged(int n2) {
        boolean bl = n2 > 0 && !this.graphDebug.isProcessing() && this.graphDebug.isRunning();
        this.monitorRemoveBtn.setEnabled(bl);
        this.monitorModifyBtn.setEnabled(bl);
        this.monitorRemoveItem.setEnabled(bl);
        this.monitorModifyItem.setEnabled(bl);
    }

    private void breakpointTableSelectionChanged(int n2) {
        boolean bl = n2 > 0 && !this.graphDebug.isProcessing();
        this.breakpointRemoveBtn.setEnabled(bl);
        this.breakpointModifyBtn.setEnabled(bl);
        this.breakpointRemoveItem.setEnabled(bl);
        this.breakpointModifyItem.setEnabled(bl);
    }

    private void removeBreakpoint() {
        Breakpoint breakpoint = (Breakpoint)this.breakpointModel.elementAt(this.breakpointTable.getSelectedRow());
        if (breakpoint != null) {
            String string = "clear ";
            string = breakpoint.getParagraph() != null ? string + breakpoint.getParagraph() : string + breakpoint.getLine();
            if (breakpoint.getFile() != null) {
                string = string + " \"" + breakpoint.getFile() + "\"";
            }
            if (breakpoint.getFileIndex() >= 0) {
                string = string + " -fi " + breakpoint.getFileIndex();
            }
            if (breakpoint.getProgram() != null) {
                string = string + " " + breakpoint.getProgram();
            }
            this.graphDebug.setTextCommand(string);
        }
    }

    private void removeAllBreakpoints() {
        this.graphDebug.setTextCommand("clear -a");
    }

    private void modifyBreakpoint() {
        Breakpoint breakpoint = (Breakpoint)this.breakpointModel.elementAt(this.breakpointTable.getSelectedRow());
        if (breakpoint != null) {
            if (breakpoint.getCondition() != null && !this.graphDebug.isRunning()) {
                JOptionPane.showMessageDialog(this.graphDebug.getFrame(), "Cannot modify a conditional breakpoint when the debugger is not running", this.graphDebug.getFrame().getTitle(), 0);
            } else {
                this.graphDebug.showBreakpointDialog(breakpoint);
            }
        }
    }

    private void newBreakpoint() {
        this.graphDebug.showBreakpointDialog(null);
    }

    private void modifyMonitor() {
        Watch watch = (Watch)this.monitorModel.elementAt(this.monitorTable.getSelectedRow());
        if (watch != null) {
            this.graphDebug.showModifyMonitorDialog(watch);
        }
    }

    private void enableAllMonitors() {
        if (!this.graphDebug.isProcessing() && !this.monitorModel.isEmpty()) {
            this.graphDebug.setAllMonitorsEnabledCommand(true);
        }
    }

    private void disableAllMonitors() {
        if (!this.graphDebug.isProcessing() && !this.monitorModel.isEmpty()) {
            this.graphDebug.setAllMonitorsEnabledCommand(false);
        }
    }

    private void removeMonitor() {
        Watch watch = (Watch)this.monitorModel.elementAt(this.monitorTable.getSelectedRow());
        if (watch != null) {
            this.graphDebug.setTextCommand(watch.getDebugDelCommand());
        }
    }

    private void removeAllMonitors() {
        this.graphDebug.setTextCommand("unmonitor -a");
    }

    public int getSourceFontSize() {
        return currentFontSize;
    }

    public void setSourceFontSize(int n2) {
        if (n2 >= 9 && n2 <= 20) {
            Font font = previewFont.deriveFont((float)n2);
            this.setSourceFont(font);
            Settings.setFont("Source code", font);
            this.previewArea.repaint();
        }
    }

    public void setSourceFont(Font font) {
        currentFontSize = font.getSize();
        previewFont = font;
        previewLinkFont = previewFont.deriveFont(DebugPanel.getUnderlineAttrs());
        previewMetrics = this.previewArea.getFontMetrics(previewFont);
        this.initNumberColumnLen();
        this.previewRenderer.updateFontSettings(previewMetrics);
        this.previewArea.setFont(previewFont);
        this.previewArea.setFixedCellHeight(previewMetrics.getHeight() + 2);
        this.setPreferredListWidth();
    }

    private static Map<TextAttribute, Integer> getUnderlineAttrs() {
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
        hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        return hashMap;
    }

    public void setSourceBackground(Color color) {
        sourceBackground = color;
        this.previewArea.setBackground(color);
    }

    public void setSourceForeground(Color color) {
        sourceForeground = color;
        this.previewArea.setForeground(color);
    }

    public void setHighBackground(Color color) {
        highBackground = color;
        this.previewArea.repaint();
    }

    public void setHighForeground(Color color) {
        highForeground = color;
        this.previewArea.repaint();
    }

    public void setSelectedBackground(Color color) {
        selBackground = color;
        this.previewArea.repaint();
    }

    public void setCommentForeground(Color color) {
        commentForeground = color;
        this.previewArea.repaint();
    }

    public void setKeywordForeground(Color color) {
        keywordForeground = color;
        this.previewArea.repaint();
    }

    public void setStringForeground(Color color) {
        stringForeground = color;
        this.previewArea.repaint();
    }

    public void setNumberForeground(Color color) {
        numberForeground = color;
        this.previewArea.repaint();
    }

    public void setStatementForeground(Color color) {
        stmtForeground = color;
        this.previewArea.repaint();
    }

    public void setLevelNumberForeground(Color color) {
        levnumForeground = color;
        this.previewArea.repaint();
    }

    public void setFigurativeConstantForeground(Color color) {
        figconsForeground = color;
        this.previewArea.repaint();
    }

    public void setBreakpointBackground(Color color) {
        bpLineBackground = color;
        this.previewArea.repaint();
    }

    public void setCopySourcePattern(String string) {
        copySourcePatternColors = DebugPanel.loadCopySourcePatternColors(string);
        this.previewArea.repaint();
    }

    public void setLNBackground(Color color) {
        lineNumberBackground = color;
        this.previewArea.repaint();
    }

    public void setLNForeground(Color color) {
        lineNumberForeground = color;
        this.previewArea.repaint();
    }

    public void setCurrLineBackground(Color color) {
        currLineBackground = color;
        this.previewArea.repaint();
    }

    public void setBPColBackground(Color color) {
        bpColBackground = color;
        this.previewArea.repaint();
    }

    public void setTipFont(Font font) {
        tipFont = font;
    }

    public void setTipBackground(Color color) {
        tipBackground = color;
    }

    public void setTipForeground(Color color) {
        tipForeground = color;
    }

    public void setPSFont(Font font) {
        perfStackFont = font;
        this.callStackTable.setFont(font);
        this.callStackNoInfoPanel.setFont(font);
    }

    public void setPSBackground(Color color) {
        perfStackBackground = color;
        this.callStackTable.setBackground(color);
        this.callStackNoInfoPanel.setBackground(color);
    }

    public void setPSForeground(Color color) {
        perfStackForeground = color;
        this.callStackTable.setForeground(color);
        this.callStackNoInfoPanel.setForeground(color);
    }

    public void setPSSelBackground(Color color) {
        perfStackSelBackground = color;
        this.callStackTable.setSelectionBackground(color);
    }

    public void setPSSelForeground(Color color) {
        perfStackSelForeground = color;
        this.callStackTable.setSelectionForeground(color);
    }

    public void setBPLFont(Font font) {
        bpListFont = font;
        this.breakpointTable.setFont(font);
    }

    public void setBPLBackground(Color color) {
        bpListBackground = color;
        this.breakpointTable.setBackground(color);
    }

    public void setBPLForeground(Color color) {
        bpListForeground = color;
        this.breakpointTable.setForeground(color);
    }

    public void setBPLSelBackground(Color color) {
        bpListSelBackground = color;
        this.breakpointTable.setSelectionBackground(color);
    }

    public void setBPLSelForeground(Color color) {
        bpListSelForeground = color;
        this.breakpointTable.setSelectionForeground(color);
    }

    public void setMLFont(Font font) {
        monListFont = font;
        this.monitorTable.setFont(font);
    }

    public void setMLBackground(Color color) {
        monListBackground = color;
        this.monitorTable.setBackground(color);
    }

    public void setMLForeground(Color color) {
        monListForeground = color;
        this.monitorTable.setForeground(color);
    }

    public void setMLSelBackground(Color color) {
        monListSelBackground = color;
        this.monitorTable.setSelectionBackground(color);
    }

    public void setMLSelForeground(Color color) {
        monListSelForeground = color;
        this.monitorTable.setSelectionForeground(color);
    }

    public void setCHFont(Font font) {
        cmdHistoryFont = font;
        this.commandHistory.setFont(font);
    }

    public void setCHBackground(Color color) {
        cmdHistoryBackground = color;
        this.commandHistory.setBackground(color);
    }

    public void setCHForeground(Color color) {
        cmdHistoryForeground = color;
        this.commandHistory.setForeground(color);
    }

    public void setCHSelBackground(Color color) {
        cmdHistorySelBackground = color;
        this.commandHistory.setSelectionBackground(color);
    }

    public void setCHSelForeground(Color color) {
        cmdHistorySelForeground = color;
        this.commandHistory.setSelectionForeground(color);
    }

    public void setTLFont(Font font) {
        threadListFont = font;
        this.threadNoInfoPanel.setFont(font);
        this.threadTable.setFont(font);
    }

    public void setTLBackground(Color color) {
        threadListBackground = color;
        this.threadNoInfoPanel.setBackground(color);
        this.threadTable.setBackground(color);
    }

    public void setTLForeground(Color color) {
        threadListForeground = color;
        this.threadNoInfoPanel.setForeground(color);
        this.threadTable.setForeground(color);
    }

    public void setDTFont(Font font) {
        int n2;
        disTreeFont = font;
        if (this.varTreeTable != null) {
            for (n2 = 0; n2 < this.varTreeTable.length; ++n2) {
                this.varTreeTable[n2].setFont(disTreeFont);
            }
        }
        if (this.varTree != null) {
            for (n2 = 0; n2 < this.varTree.length; ++n2) {
                this.varTree[n2].setFont(disTreeFont);
            }
        }
        this.variablesPanel.repaint();
    }

    public void setDTBackground(Color color) {
        int n2;
        disTreeBackground = color;
        if (this.varTreeTable != null) {
            for (n2 = 0; n2 < this.varTreeTable.length; ++n2) {
                this.varTreeTable[n2].setBackground(disTreeBackground);
            }
        }
        if (this.varTree != null) {
            for (n2 = 0; n2 < this.varTree.length; ++n2) {
                this.varTree[n2].setBackground(disTreeBackground);
            }
        }
        this.variablesPanel.repaint();
    }

    public void setDTForeground(Color color) {
        int n2;
        disTreeForeground = color;
        if (this.varTreeTable != null) {
            for (n2 = 0; n2 < this.varTreeTable.length; ++n2) {
                this.varTreeTable[n2].setForeground(disTreeForeground);
            }
        }
        if (this.varTree != null) {
            for (n2 = 0; n2 < this.varTree.length; ++n2) {
                this.varTree[n2].setForeground(disTreeForeground);
            }
        }
        this.variablesPanel.repaint();
    }

    public void setDTSelBackground(Color color) {
        disTreeSelBackground = color;
        this.variablesPanel.repaint();
    }

    public void setDTSelForeground(Color color) {
        disTreeSelForeground = color;
        this.variablesPanel.repaint();
    }

    public void setOutputFont(Font font) {
        outputFont = font;
        this.textOutput.setFont(font);
    }

    public void setOutputBackground(Color color) {
        outputBackground = color;
        this.textOutput.setBackground(color);
    }

    public void setOutputForeground(Color color) {
        outputForeground = color;
        this.textOutput.setForeground(color);
        this.textOutput.setCaretColor(color);
    }

    public void setOutputSelBackground(Color color) {
        outputSelBackground = color;
        this.textOutput.setSelectionColor(color);
    }

    public void setOutputSelForeground(Color color) {
        outputSelForeground = color;
        this.textOutput.setSelectedTextColor(color);
    }

    public void setConsoleFont(Font font) {
        consoleFont = font;
        this.console.setFont(font);
    }

    public void setConsoleBackground(Color color) {
        consoleBackground = color;
        this.console.setBackground(color);
    }

    public void setConsoleForeground(Color color) {
        consoleForeground = color;
        this.console.setForeground(color);
        this.console.setCaretColor(color);
    }

    public void setConsoleSelBackground(Color color) {
        consoleSelBackground = color;
        this.console.setSelectionColor(color);
    }

    public void setConsoleSelForeground(Color color) {
        consoleSelForeground = color;
        this.console.setSelectedTextColor(color);
    }

    public void setConsoleStdErrForeground(Color color) {
        consoleStdErrForeground = color;
        StyleConstants.setForeground(this.console.getStyledDocument().getStyle("stderr"), color);
    }

    public void setInputFont(Font font) {
        inputFont = font;
        this.lineCommand.setFont(font);
    }

    public void setInputBackground(Color color) {
        inputBackground = color;
        this.lineCommand.setBackground(color);
    }

    public void setInputForeground(Color color) {
        inputForeground = color;
        this.lineCommand.setForeground(color);
        this.lineCommand.setCaretColor(color);
    }

    public void setInputSelBackground(Color color) {
        inputSelBackground = color;
        this.lineCommand.setSelectionColor(color);
    }

    public void setInputSelForeground(Color color) {
        inputSelForeground = color;
        this.lineCommand.setSelectedTextColor(color);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            int n2 = Settings.getMainSplitPaneDividerLocation();
            if (n2 >= 0) {
                this.mainSplitPane.setDividerLocation(n2);
            } else {
                this.mainSplitPane.setDividerLocation(0.75);
            }
            int n3 = Settings.getOutputSplitPaneDividerLocation();
            if (n3 >= 0) {
                this.bottomSplitPane.setDividerLocation(n3);
            } else {
                this.bottomSplitPane.setDividerLocation(0.7f);
            }
            this.openVariablesArea();
            this.topSplitPaneDividerLocation = -1;
        }
    }

    private boolean isVariablesAreaOpen() {
        return this.topSplitPane.isEnabled();
    }

    private void openVariablesArea() {
        if (this.topSplitPane.getRightComponent() != null) {
            this.topSplitPane.remove(this.topSplitPane.getRightComponent());
        }
        this.topSplitPane.setRightComponent(this.variableTabbedPane);
        this.topSplitPane.setEnabled(true);
        this.topSplitPane.setOneTouchExpandable(true);
        int n2 = Settings.getSourceSplitPaneDividerLocation();
        if (n2 > 0 && n2 < this.topSplitPane.getMaximumDividerLocation()) {
            this.topSplitPane.setDividerLocation(n2);
        } else {
            this.topSplitPane.setDividerLocation(0.75);
        }
        this.topSplitPaneDividerLocation = this.topSplitPane.getDividerLocation();
        SwingUtilities.invokeLater(() -> {
            int n2 = Settings.getVariableSplitPaneDividerLocation();
            if (n2 > 0 && n2 < this.varSplitPane.getMaximumDividerLocation()) {
                this.varSplitPane.setDividerLocation(n2);
            } else {
                this.varSplitPane.setDividerLocation(0.5);
            }
            this.varSplitPaneDividerLocation = this.varSplitPane.getDividerLocation();
        });
    }

    protected void selectBreakpointsTab() {
        int n2 = this.bottomRightTabbedPane.indexOfTab(BREAKPOINTS_TITLE);
        if (n2 >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(n2);
        }
    }

    protected void selectThreadsTab() {
        int n2 = this.bottomRightTabbedPane.indexOfTab(THREADS_TITLE);
        if (n2 >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(n2);
        }
    }

    protected void selectMonitorsTab() {
        int n2 = this.bottomRightTabbedPane.indexOfTab(MONITORS_TITLE);
        if (n2 >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(n2);
        }
    }

    protected void selectPerformStackTab() {
        int n2 = this.bottomRightTabbedPane.indexOfTab(PERF_STACK_TITLE);
        if (n2 >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(n2);
        }
    }

    protected void selectConsoleTab() {
        int n2 = this.bottomRightTabbedPane.indexOfTab(CONSOLE_TITLE);
        if (n2 >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(n2);
        }
    }

    private static JButton createJButton(ImageIcon imageIcon, boolean bl, ActionListener actionListener) {
        return DebugPanel.createJButton(imageIcon, "", bl, actionListener);
    }

    private static JButton createJButton(ImageIcon imageIcon, String string, boolean bl, ActionListener actionListener) {
        JButton jButton = new JButton(imageIcon);
        jButton.setFocusable(false);
        jButton.addActionListener(actionListener);
        jButton.setToolTipText(string);
        jButton.setEnabled(bl);
        return jButton;
    }

    private void buildToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.setLayout(new BorderLayout(3, 0){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void layoutContainer(Container container) {
                Object object = DebugPanel.this.toolbar.getTreeLock();
                synchronized (object) {
                    Dimension dimension = DebugPanel.this.toolbar.getSize();
                    Insets insets = DebugPanel.this.toolbar.getInsets();
                    int n2 = insets.top;
                    int n3 = dimension.height - insets.bottom;
                    int n4 = insets.left;
                    int n5 = dimension.width - insets.right;
                    JComponent jComponent = DebugPanel.this.btnToolbar;
                    Dimension dimension2 = jComponent.getSize();
                    jComponent.setSize(dimension2.width, n3 - n2);
                    Dimension dimension3 = ((Component)jComponent).getPreferredSize();
                    Rectangle rectangle = new Rectangle(n5 - dimension3.width, n2, dimension3.width, n3 - n2);
                    n5 -= dimension3.width + 3;
                    jComponent = DebugPanel.this.memoryView;
                    dimension2 = jComponent.getSize();
                    jComponent.setSize(dimension2.width, n3 - n2);
                    dimension3 = ((Component)jComponent).getPreferredSize();
                    jComponent.setBounds(n4, n2, dimension3.width, n3 - n2);
                    jComponent = DebugPanel.this.fileChooser;
                    int n6 = n5 - (n4 += dimension3.width + 3);
                    int n7 = n4;
                    int n8 = n6 - 180;
                    if (n8 < 0) {
                        n6 += -n8;
                        rectangle.width += n8;
                        rectangle.x += -n8;
                    }
                    DebugPanel.this.btnToolbar.setBounds(rectangle);
                    jComponent.setBounds(n7, n2, n6, n3 - n2);
                }
            }
        });
        ImageIcon imageIcon = this.graphDebug.isRemote() ? new ImageIcon(GraphUtilities.getImage("connect.gif")) : new ImageIcon(GraphUtilities.getImage("rundebug.gif"));
        ImageIcon imageIcon2 = new ImageIcon(GraphUtilities.getImage("continue.gif"));
        ImageIcon imageIcon3 = new ImageIcon(GraphUtilities.getImage("suspend.gif"));
        ImageIcon imageIcon4 = new ImageIcon(GraphUtilities.getImage("stepover.gif"));
        ImageIcon imageIcon5 = new ImageIcon(GraphUtilities.getImage("stepinto.gif"));
        ImageIcon imageIcon6 = new ImageIcon(GraphUtilities.getImage("stepout.gif"));
        ImageIcon imageIcon7 = new ImageIcon(GraphUtilities.getImage("stepoutprog.gif"));
        ImageIcon imageIcon8 = new ImageIcon(GraphUtilities.getImage("runtilcurs.gif"));
        ImageIcon imageIcon9 = new ImageIcon(GraphUtilities.getImage("runtilpgm.gif"));
        ImageIcon imageIcon10 = new ImageIcon(GraphUtilities.getImage("jump.gif"));
        ImageIcon imageIcon11 = new ImageIcon(GraphUtilities.getImage("jumpout.gif"));
        ImageIcon imageIcon12 = new ImageIcon(GraphUtilities.getImage("jumpover.gif"));
        ImageIcon imageIcon13 = new ImageIcon(GraphUtilities.getImage("jumpoutprog.gif"));
        ImageIcon imageIcon14 = new ImageIcon(GraphUtilities.getImage("gotocurrline.gif"));
        ImageIcon imageIcon15 = this.graphDebug.isRemote() ? new ImageIcon(GraphUtilities.getImage("disconnect.gif")) : new ImageIcon(GraphUtilities.getImage("stop.gif"));
        ImageIcon imageIcon16 = new ImageIcon(GraphUtilities.getImage("find.gif"));
        ImageIcon imageIcon17 = new ImageIcon(GraphUtilities.getImage("find_repeat.gif"));
        breakpointImage = GraphUtilities.getImage("breakpoint.gif");
        disbreakpointImage = GrayFilter.createDisabledImage(breakpointImage);
        currlineImage = GraphUtilities.getImage("currline.gif");
        expandCopyImage = GraphUtilities.getImage("expand.gif");
        collapseCopyImage = GraphUtilities.getImage("collapse.gif");
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(breakpointImage, 0);
        mediaTracker.addImage(disbreakpointImage, 1);
        mediaTracker.addImage(currlineImage, 2);
        mediaTracker.addImage(collapseCopyImage, 3);
        mediaTracker.addImage(expandCopyImage, 4);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        UIManager.put("ProgressBar.selectionForeground", Color.blue);
        this.memoryView = new JProgressBar();
        this.memoryView.setPreferredSize(new Dimension(100, 23));
        this.memoryView.setOrientation(0);
        this.memoryView.setMinimum(0);
        this.memoryView.setMaximum(1);
        this.memoryView.setBackground(Color.white);
        this.memoryView.setForeground(Color.green);
        this.memoryView.setValue(0);
        this.memoryView.setString("");
        this.memoryView.setToolTipText("Click to force garbage collector");
        this.memoryView.setStringPainted(true);
        this.memoryView.setBorderPainted(true);
        this.memoryView.setEnabled(false);
        this.memoryView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                DebugPanel.this.memoryView.setBorder(BorderFactory.createLineBorder(Color.white));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                DebugPanel.this.memoryView.setBorder(BorderFactory.createLineBorder(Color.black));
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DebugPanel.this.graphDebug.setTextCommand("gc");
                DebugPanel.this.memoryView.setBorder(BorderFactory.createLineBorder(Color.black));
            }
        });
        this.toolbar.add((Component)this.memoryView, "West");
        this.fileChooser.setFocusable(false);
        this.fileChooser.setFont(new Font("sansserif", 0, 12));
        this.fileChooser.setPreferredSize(new Dimension(180, DebugPanel.BTN_SIZE.height));
        this.fileChooser.addActionListener(actionEvent -> {
            String string = (String)this.fileChooser.getSelectedItem();
            if (string != null && !this.currFile.equals(string)) {
                this.changeFile(true, new Filename(string), 0L, true);
            }
        });
        this.toolbar.add((Component)this.fileChooser, "Center");
        this.btnToolbar = new JToolBar();
        this.btnToolbar.setFloatable(false);
        this.btnToolbar.setLayout(new FlowLayout(0, 3, 0));
        this.warnLbl.setText("!");
        this.warnLbl.setHorizontalAlignment(0);
        this.warnLbl.setFont(new Font("sanserif", 1, 20));
        this.btnToolbar.add(this.warnLbl);
        this.btnFind = DebugPanel.createJButton(imageIcon16, true, actionEvent -> {
            this.hideTipPopup();
            this.graphDebug.getFindDialog().setVisible(this.getHighlightedWord());
        });
        this.btnToolbar.add(this.btnFind);
        this.btnRepeatFind = DebugPanel.createJButton(imageIcon17, "Repeat find", true, actionEvent -> this.repeatFind());
        this.btnToolbar.add(this.btnRepeatFind);
        this.btnToolbar.add(this.newToolBarSeparator());
        this.btnGotoCurrLine = DebugPanel.createJButton(imageIcon14, true, actionEvent -> this.selectCurrentLine());
        this.btnToolbar.add(this.btnGotoCurrLine);
        this.btnToolbar.add(this.newToolBarSeparator());
        this.btnRun = DebugPanel.createJButton(imageIcon, true, actionEvent -> this.graphDebug.setTextCommand("run " + GraphDebugger.getChainingString()));
        this.btnToolbar.add(this.btnRun);
        this.btnStop = DebugPanel.createJButton(imageIcon15, false, actionEvent -> {
            if (this.graphDebug.isProcessing()) {
                if (this.graphDebug.showConfirmQuitDialog()) {
                    this.graphDebug.setQuitCommandExecuted(true);
                    this.graphDebug.getInvoker().exitDebug(this.graphDebug.isRemote() && Settings.getForceStopRun());
                }
            } else {
                this.graphDebug.setTextCommand("quit");
            }
        });
        this.btnToolbar.add(this.btnStop);
        this.btnToolbar.add(this.newToolBarSeparator());
        this.btnContinue = DebugPanel.createJButton(imageIcon2, false, actionEvent -> this.graphDebug.setTextCommand("continue"));
        this.btnToolbar.add(this.btnContinue);
        this.btnSuspend = DebugPanel.createJButton(imageIcon3, "Pause", false, actionEvent -> this.graphDebug.setTextCommand("pause"));
        this.btnToolbar.add(this.btnSuspend);
        this.btnStepInto = DebugPanel.createJButton(imageIcon5, false, actionEvent -> this.graphDebug.setTextCommand("step"));
        this.btnToolbar.add(this.btnStepInto);
        this.btnNext = DebugPanel.createJButton(imageIcon4, false, actionEvent -> this.graphDebug.setTextCommand("next"));
        this.btnToolbar.add(this.btnNext);
        this.btnOutPar = DebugPanel.createJButton(imageIcon6, false, actionEvent -> this.graphDebug.setTextCommand("outpar"));
        this.btnToolbar.add(this.btnOutPar);
        this.btnOutProg = DebugPanel.createJButton(imageIcon7, false, actionEvent -> this.graphDebug.setTextCommand("outprog"));
        this.btnToolbar.add(this.btnOutProg);
        this.btnStepTo = DebugPanel.createJButton(imageIcon8, false, actionEvent -> this.graphDebug.runToSelectedLine(this.selLine, this.tFileObj.tf));
        this.btnToolbar.add(this.btnStepTo);
        this.btnStepToPgm = DebugPanel.createJButton(imageIcon9, false, actionEvent -> this.graphDebug.setTextCommand("prog"));
        this.btnToolbar.add(this.btnStepToPgm);
        this.btnAutoStep = new ToggleImageButton("", GraphUtilities.getImage("autostep.gif"), actionEvent -> this.autostepStateChanged(), false);
        this.btnAutoStep.setPreferredSize(BTN_SIZE);
        this.btnToolbar.add(this.btnAutoStep);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1.0, 0.1, 3.0, 0.1);
        this.autoStepDelay = new JSpinner(spinnerNumberModel);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.autoStepDelay);
        numberEditor.getTextField().setEditable(false);
        this.autoStepDelay.setFocusable(false);
        numberEditor.getTextField().setFocusable(false);
        numberEditor.getTextField().setFont(new Font("sansserif", 0, 9));
        numberEditor.getTextField().setBackground(Color.white);
        this.autoStepDelay.setEditor(numberEditor);
        this.autoStepDelay.addChangeListener(changeEvent -> {
            int n2 = (int)(1000.0 * (Double)this.autoStepDelay.getValue());
            this.graphDebug.setAutostepDelay(n2);
        });
        this.autoStepDelay.setPreferredSize(new Dimension(50, 25));
        numberEditor.getTextField().setToolTipText("Autostep delay");
        this.btnToolbar.add(this.autoStepDelay);
        this.btnJumpNext = DebugPanel.createJButton(imageIcon12, false, actionEvent -> this.graphDebug.setTextCommand("jump -next"));
        this.btnToolbar.add(this.btnJumpNext);
        this.btnJumpOutPar = DebugPanel.createJButton(imageIcon11, false, actionEvent -> this.graphDebug.setTextCommand("jump -outpar"));
        this.btnToolbar.add(this.btnJumpOutPar);
        this.btnJumpOutProg = DebugPanel.createJButton(imageIcon13, false, actionEvent -> this.graphDebug.setTextCommand("jump -outprog"));
        this.btnToolbar.add(this.btnJumpOutProg);
        this.btnJump = DebugPanel.createJButton(imageIcon10, false, actionEvent -> this.jumpToSelectedLine());
        this.btnToolbar.add(this.btnJump);
        this.toolbar.add((Component)this.btnToolbar, "East");
    }

    private void autostepStateChanged() {
        if (this.btnAutoStep.isSelected()) {
            this.btnAutoStep.setBorder(BorderFactory.createLoweredBevelBorder());
            this.btnAutoStep.setBorderPainted(true);
            this.btnAutoStep.setToolTipText("Stop autostep" + DebugPanel.getShortcutText("graphdebugger.shortcut.stoff"));
            this.graphDebug.startAutostep();
        } else {
            this.btnAutoStep.setBorder(BorderFactory.createRaisedBevelBorder());
            this.btnAutoStep.setBorderPainted(false);
            this.btnAutoStep.setToolTipText("Start autostep" + DebugPanel.getShortcutText("graphdebugger.shortcut.ston"));
            this.graphDebug.stopAutostep();
        }
    }

    private JComponent newToolBarSeparator() {
        return this.newToolBarSeparator(new Dimension(1, DebugPanel.BTN_SIZE.height - 2), true);
    }

    private JComponent newToolBarSeparator(Dimension dimension, boolean bl) {
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        if (bl) {
            class DashedBorder
            extends AbstractBorder {
                private static final long serialVersionUID = 1L;

                DashedBorder() {
                }

                @Override
                public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setColor(Color.darkGray);
                    graphics2D.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f));
                    graphics2D.drawRect(n2, n3, n4 - 1, n5 - 1);
                }
            }
            filler.setBorder(new DashedBorder());
        }
        return filler;
    }

    protected MyVarName getVarName() {
        MyVarName myVarName = null;
        if (this.quickWatchPoint != null) {
            myVarName = this.getVarName(this.quickWatchPoint);
        }
        return myVarName;
    }

    private MyVarName getVarName(Point point) {
        int n2;
        int n3 = this.previewArea.locationToIndex(point);
        int n4 = this.getListingline(n3);
        String string = this.tFileObj.tf.getLine(n4, false);
        MyVarName myVarName = this.getVarName(string, n2 = GraphUtilities.pixelsToOffset(previewMetrics, string, point.x - 20 - numberColumnLen));
        if (myVarName != null) {
            myVarName.lstLine = n4;
        }
        return myVarName;
    }

    private MyVarName getVarName(String string, int n2) {
        List<MyVarName> list = this.getVarNames(string, n2, this.getSourceFormat(), Collections.EMPTY_SET);
        if (list != null && list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    private boolean isComment(Token token, int n2, int n3) {
        return (n2 == 1 || n2 == 5) && token.getOffset() == n3 || n2 == 4 && (token.getOffset() == n3 || token.getOffset() == 0) || n2 == 2 && token.getOffset() == 0;
    }

    private int getAnsiCommentColumn(String string) {
        int n2 = 7;
        if (this.ccbas && string.length() > 3) {
            try {
                byte[] byArray = string.substring(0, 3).getBytes(CobolVar.encoding);
                n2 += 3 - byArray.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<MyVarName> getVarNames(String string, int n2, int n3, Set<String> set) {
        ArrayList<MyVarName> arrayList = new ArrayList<MyVarName>();
        TokenList tokenList = new TokenList();
        PreProcessor.tokenizer(tokenList, new StringBuffer(string), 0, "", 0, '.', null, null, false, true, n3);
        Object object = tokenList.getFirst();
        while (object != null) {
            if (((Token)object).getToknum() == 10000) {
                ((Token)object).putKeyword(this.nrw);
            }
            object = tokenList.getNext();
        }
        object = null;
        int n4 = 0;
        int n5 = this.getAnsiCommentColumn(string) - 1;
        Token token = tokenList.getFirst();
        while (token != null) {
            block16: {
                int n6;
                block19: {
                    Object object2;
                    int n7;
                    Object object3;
                    block17: {
                        block18: {
                            boolean bl = false;
                            if (token.getToknum() == 42 && token.getOffset() <= n2 && this.isComment(token, n3, n5)) {
                                return arrayList;
                            }
                            if (token.getToknum() != 10009 || n2 >= 0 && token.getOffset() > n2) break block16;
                            n6 = tokenList.getCurrentIndex();
                            if (n6 > 0) {
                                object3 = tokenList.getAt(n6 - 1);
                                bl = ((Token)object3).getToknum() == 58;
                                tokenList.getAt(n6);
                            }
                            object = new StringBuffer();
                            n4 = token.getOffset();
                            ((StringBuffer)object).append(token.getOriginalWord());
                            object3 = token;
                            Token token2 = tokenList.getNext();
                            while (token2 != null && (token2.getToknum() == 609 || token2.getToknum() == 526 || token2.getToknum() == 10006)) {
                                object3 = token2;
                                token2 = tokenList.getNext();
                                if (token2 != null && token2.getToknum() == 10009) {
                                    if (((Token)object3).getToknum() != 10006) {
                                        ((StringBuffer)object).append(" ");
                                        ((StringBuffer)object).append(((Token)object3).getOriginalWord());
                                        ((StringBuffer)object).append(" ");
                                    } else {
                                        ((StringBuffer)object).append(".");
                                    }
                                    ((StringBuffer)object).append(token2.getOriginalWord());
                                    object3 = token2;
                                    token2 = tokenList.getNext();
                                    continue;
                                }
                                if (((Token)object3).getToknum() == 10006 || bl && ((Token)object3).getToknum() == 526) break;
                                object = null;
                                token = tokenList.getAt(n6);
                                break block16;
                            }
                            if (token2 == null || token2.getToknum() != 40) break block17;
                            n7 = 1;
                            ((StringBuffer)object).append(token2.getOriginalWord()).append(" ");
                            object3 = token2;
                            token2 = tokenList.getNext();
                            while (token2 != null) {
                                ((StringBuffer)object).append(token2.getOriginalWord()).append(" ");
                                object3 = token2;
                                if (token2.getToknum() == 40) {
                                    ++n7;
                                }
                                if (token2.getToknum() == 41 && --n7 <= 0) break;
                                token2 = tokenList.getNext();
                            }
                            if (n7 == 0) break block18;
                            object = null;
                            token = tokenList.getAt(n6);
                            break block16;
                        }
                        object2 = tokenList.getNext();
                        if (object2 == null || ((Token)object2).getToknum() != 40) break block17;
                        n7 = 1;
                        ((StringBuffer)object).append(((Token)object2).getOriginalWord()).append(" ");
                        object3 = object2;
                        object2 = tokenList.getNext();
                        while (object2 != null) {
                            ((StringBuffer)object).append(((Token)object2).getOriginalWord()).append(" ");
                            object3 = object2;
                            if (((Token)object2).getToknum() == 40) {
                                ++n7;
                            }
                            if (((Token)object2).getToknum() == 41 && --n7 <= 0) break;
                            object2 = tokenList.getNext();
                        }
                        if (n7 == 0) break block17;
                        object = null;
                        token = tokenList.getAt(n6);
                        break block16;
                    }
                    if (n2 >= 0 && ((Token)object3).getOffset() + ((Token)object3).getWord().length() - 1 < n2) break block19;
                    String string2 = ((StringBuffer)object).toString().trim();
                    String string3 = string2.toUpperCase();
                    if (this.nrw.contains(string3) || !statements.contains(string3) && !keywords.contains(string3) && !set.contains(string3)) {
                        n7 = Math.min(string.length(), ((Token)object3).getOffset() + ((Token)object3).getWord().length());
                        object2 = new MyVarName(string2, string.substring(n4, n7));
                        ((MyVarName)object2).offs = n4;
                        arrayList.add((MyVarName)object2);
                        if (string2.indexOf(46) < 0) {
                            token = tokenList.getAt(n6);
                        }
                        break block16;
                    } else {
                        token = tokenList.getAt(n6);
                    }
                    break block16;
                }
                token = tokenList.getAt(n6);
            }
            token = tokenList.getNext();
        }
        return arrayList;
    }

    public static boolean isLevelNumber(String string) {
        try {
            int n2 = Integer.parseInt(string);
            return n2 >= 1 && n2 <= 49 || n2 == 66 || n2 == 77 || n2 == 78 || n2 == 88;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private DebugResponse displayVar(String string, int n2) {
        if (string != null && string.length() > 0 && (string = this.normalizeVarName(this.tFileObj.ldInfo, string, n2)) != null) {
            String string2 = "display";
            String string3 = this.getSelectedModule();
            if (string3 != null) {
                string2 = string2 + " ";
                string2 = string2 + "-c";
                string2 = string2 + " ";
                string2 = string2 + string3;
            }
            string2 = string2 + " ";
            string2 = string2 + string;
            return this.graphDebug.getInvoker().processCommand(string2);
        }
        return null;
    }

    private void initNumberColumnLen() {
        if (this.tFileObj.tf.getNumLines() > 0) {
            numberColumnLen = String.valueOf(this.tFileObj.tf.getNumLines()).length() * previewMetrics.stringWidth("0") + 4;
        }
    }

    private void setPreferredListWidth() {
        if (this.tFileObj != null && previewMetrics != null) {
            preferredPreviewWidth = previewMetrics.stringWidth(this.tFileObj.tf.getLongestLine()) + 20 + numberColumnLen + 2;
        }
    }

    private void changeFile(boolean bl, Filename filename, long l2, boolean bl2) {
        this.currFile = filename.getOrigName();
        this.graphDebug.setUnloadEnabled(!this.currFile.equals(this.mainProgram));
        if (this.tFileObj != null) {
            this.tFileObj.tf.setCurrLine(this.currLine);
        }
        if (bl) {
            this.getFile(null, filename, l2, false, bl2);
        }
        this.initNumberColumnLen();
        this.setPreferredListWidth();
        this.setCurrentLine(this.tFileObj.tf.getCurrLine());
    }

    void resetIdxs() {
        this.currLine = -1;
        this.setSelectedLine(-1);
    }

    public void doFind(String string, boolean bl, boolean bl2) {
        new IsguiWorker(false, () -> {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() < 2) {
                this.outputResult("- usage " + stringTokenizer.nextToken() + " text" + GraphDebugger.eol);
            } else {
                String string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken("\n").trim();
                this.fparam = new FindDialog.FindParam(string2, false, false, bl, true, bl2, false);
                this.find(this.fparam);
            }
        }).start();
    }

    public void repeatFind() {
        if (this.fparam != null) {
            this.find(this.fparam);
        }
    }

    public void find(FindDialog.FindParam findParam) {
        new IsguiWorker(false, () -> {
            boolean bl;
            String string;
            this.graphDebug.getFindDialog().addItemToSearchList(findParam.toSearch);
            this.fparam = findParam;
            int n2 = this.fparam.toSearch.length();
            if (this.fparam.searchFromTop) {
                this.fparam.searchFromTop = false;
                this.setSelectedLine(0);
                this.setCursorColumn(0, this.selLine);
                this.cursorX = 20 + numberColumnLen;
            }
            if (this.fparam.matchCase) {
                string = this.fparam.toSearch;
                bl = false;
            } else {
                string = this.fparam.toSearch.toUpperCase();
                bl = true;
            }
            boolean bl2 = this.fparam.matchMinusUnderscore;
            if (!bl2) {
                string = string.replaceAll("_", "-");
            }
            TextFile textFile = this.tFileObj.tf;
            int n3 = this.getListingline(this.selLine);
            if (this.fparam.backSearch) {
                int n4;
                String string2 = textFile.getLine(n3, bl, bl2);
                if (this.cursorColumn < string2.length()) {
                    string2 = string2.substring(0, this.cursorColumn);
                }
                if ((n4 = string2.lastIndexOf(string)) >= 0 && n4 + string.length() == string2.length()) {
                    string2 = string2.substring(0, string2.length() - string.length());
                    n4 = string2.lastIndexOf(string);
                }
                if (n4 >= 0) {
                    if (!this.fparam.wholeWords || this.isWholeWord(string2, n4, n2)) {
                        this.select(this.selLine, n4 + n2, this.fparam.toSearch);
                        return;
                    }
                } else {
                    int n5;
                    for (n5 = n3 - 1; n5 >= 0; --n5) {
                        string2 = textFile.getLine(n5, bl, bl2);
                        n4 = string2.lastIndexOf(string);
                        if (n4 < 0 || this.fparam.wholeWords && !this.isWholeWord(string2, n4, n2)) continue;
                        this.select(this.getLineIndex(n5, true), n4 + n2, this.fparam.toSearch);
                        return;
                    }
                    if (this.fparam.wrapSearch) {
                        for (n5 = textFile.getNumLines() - 1; n5 >= n3; --n5) {
                            string2 = textFile.getLine(n5, bl, bl2);
                            n4 = string2.lastIndexOf(string);
                            if (n4 < 0 || this.fparam.wholeWords && !this.isWholeWord(string2, n4, n2)) continue;
                            this.select(this.getLineIndex(n5, true), n4 + n2, this.fparam.toSearch);
                            return;
                        }
                    }
                }
                JOptionPane.showMessageDialog(this.graphDebug.getFrame(), "'" + this.fparam.toSearch + "' not found", "Find", 1);
            } else {
                String string3 = textFile.getLine(n3, bl, bl2);
                int n6 = string3.indexOf(string, this.cursorColumn);
                if (n6 >= 0) {
                    if (!this.fparam.wholeWords || this.isWholeWord(string3, n6, n2)) {
                        this.select(this.selLine, n6 + n2, this.fparam.toSearch);
                        return;
                    }
                } else {
                    int n7;
                    for (n7 = n3 + 1; n7 < textFile.getNumLines(); ++n7) {
                        string3 = textFile.getLine(n7, bl, bl2);
                        n6 = string3.indexOf(string);
                        if (n6 < 0 || this.fparam.wholeWords && !this.isWholeWord(string3, n6, n2)) continue;
                        this.select(this.getLineIndex(n7, true), n6 + n2, this.fparam.toSearch);
                        return;
                    }
                    if (this.fparam.wrapSearch) {
                        for (n7 = 0; n7 <= n3; ++n7) {
                            string3 = textFile.getLine(n7, bl, bl2);
                            n6 = string3.indexOf(string);
                            if (n6 < 0 || this.fparam.wholeWords && !this.isWholeWord(string3, n6, n2)) continue;
                            this.select(this.getLineIndex(n7, true), n6 + n2, this.fparam.toSearch);
                            return;
                        }
                    }
                }
                this.setHighlightedWord(null);
                JOptionPane.showMessageDialog(this.graphDebug.getFrame(), "'" + this.fparam.toSearch + "' not found", "Find", 1);
            }
        }).start();
    }

    String getHighlightedWord() {
        return this.highlightedWord;
    }

    private void setHighlightedWord(String string) {
        this.highlightedWord = string;
        if (this.highlightedWord != null) {
            this.highlightedVar = null;
        }
    }

    private void setHighlightedVar(String string) {
        this.setHighlightedVar(string, HighlightVarType.HIGHLIGHT, -1, -1);
    }

    private void setHighlightedVar(String string, HighlightVarType highlightVarType, int n2, int n3) {
        this.highlightedVar = string;
        this.highlightVarType = highlightVarType;
        this.highlightedVarLine = n2;
        this.highlightedVarCol = n3;
        this.highlightedWord = null;
        if (DebugPanel.isLink(this.highlightVarType)) {
            this.graphDebug.getFrame().setCursor(HAND_CURSOR);
        } else {
            this.graphDebug.getFrame().setCursor(DEF_CURSOR);
        }
        this.previewArea.repaint();
    }

    boolean isWholeWord(String string, int n2, int n3) {
        char c2 = n2 == 0 ? (char)' ' : string.charAt(n2 - 1);
        if (Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '_') {
            return false;
        }
        if (n2 + n3 < string.length()) {
            c2 = string.charAt(n2 + n3);
        }
        return !Character.isLetterOrDigit(c2) && c2 != '-' && c2 != 95;
    }

    public TextFile loadFile(LocalDebugInfo localDebugInfo, Filename filename, long l2, boolean bl) {
        return this.load((LocalDebugInfo)localDebugInfo, (Filename)filename, (long)l2, (boolean)bl).tf;
    }

    private TextFileObj load(LocalDebugInfo localDebugInfo, Filename filename, long l2, boolean bl) {
        this.tFileObj.tf.setCurrLine(this.currLine);
        this.getFile(localDebugInfo, filename, l2, bl, true);
        this.currLine = -1;
        this.changeFile(false, filename, l2, false);
        this.fileChooser.setSelectedItem(filename.getOrigName());
        return this.tFileObj;
    }

    public void unload() {
        this.unload(this.tFileObj.tf);
    }

    void unload(TextFile textFile) {
        if (!textFile.getFilename().equals(this.mainProgram)) {
            this.textFiles.remove(new Filename(textFile.getFilename()).getOrigName());
            this.fileChooser.removeItem(new Filename(textFile.getFilename()).getOrigName());
        }
    }

    public void goTo(int n2, String string, int n3) {
        this.goTo(n2, string, n3, false, -1);
    }

    private LocalDebugInfo.Location getMemberLocation(LocalDebugInfo localDebugInfo, String string, int n2) {
        this.checkLdInfoReady(localDebugInfo);
        return localDebugInfo.getMemberLocation(string, n2, this.tFileObj.tf);
    }

    private String normalizeVarName(LocalDebugInfo localDebugInfo, String string, int n2) {
        this.checkLdInfoReady(localDebugInfo);
        return localDebugInfo.normalizeVarName(string, n2, this.tFileObj.tf);
    }

    private void checkLdInfoReady(LocalDebugInfo localDebugInfo) {
        if (!localDebugInfo.isReady()) {
            JFrame jFrame = this.graphDebug.getFrame();
            Cursor cursor = jFrame.getCursor();
            jFrame.setCursor(BUSY_CURSOR);
            localDebugInfo.waitUntilIsReady();
            jFrame.setCursor(cursor);
        }
    }

    public void goTo(int n2, String string, int n3, boolean bl, int n4) {
        TextFile textFile = this.tFileObj.tf;
        int n5 = textFile.toListingLine(n2, n3);
        LocalDebugInfo localDebugInfo = this.tFileObj.ldInfo;
        if (string != null) {
            LocalDebugInfo.Location location;
            if (localDebugInfo != null && (location = this.getMemberLocation(localDebugInfo, string, n5)) != null) {
                n5 = textFile.toListingLine(location.line, location.file, location.fileIndex);
            } else {
                CobolRef cobolRef = textFile.paragraphToLine(string.trim());
                if (cobolRef != null) {
                    n5 = textFile.toListingLine(cobolRef.lineNo(), new Filename(cobolRef.filename()), cobolRef.getFileIndex());
                }
            }
        }
        int n6 = this.getListingline(this.selLine);
        int n7 = this.getLineIndex(n5, true);
        if (n7 >= 0) {
            if (this.currLine == -1) {
                int n8;
                if (bl) {
                    this.setCurrentLine(n7);
                }
                if (n4 > 0 && (n8 = this.getLineIndex(textFile.toListingLine(n4, n3), false)) >= 0) {
                    this.setCurrentLine(n8, false);
                }
            }
            this.gotoList.add(new Integer(n6));
            this.select(n7, 0);
            this.gotoList.add(new Integer(n5));
            this.gotoIndex = this.gotoList.size() - 1;
            this.graphDebug.updateGotoActions(true, false);
        }
    }

    public void back() {
        --this.gotoIndex;
        int n2 = (Integer)this.gotoList.get(this.gotoIndex);
        this.select(this.getLineIndex(n2, true), 0);
        this.graphDebug.updateGotoActions(this.gotoIndex > 0, this.gotoIndex < this.gotoList.size() - 1);
    }

    public void forward() {
        ++this.gotoIndex;
        int n2 = (Integer)this.gotoList.get(this.gotoIndex);
        this.select(this.getLineIndex(n2, true), 0);
        this.graphDebug.updateGotoActions(this.gotoIndex > 0, this.gotoIndex < this.gotoList.size() - 1);
    }

    public TextFile getFile() {
        return this.tFileObj.tf;
    }

    private TextFileObj getNewFile(LocalDebugInfo localDebugInfo, Filename filename, long l2, boolean bl, boolean bl2) {
        TextFileObj textFileObj = new TextFileObj();
        boolean bl3 = true;
        if (localDebugInfo != null) {
            if (localDebugInfo.getInfoFormat() > 3) {
                if (localDebugInfo.getCompilerProps() != null) {
                    for (String string : localDebugInfo.getCompilerProps()) {
                        if (!string.startsWith("iscobol.compiler.debug.replaced_source=")) continue;
                        bl3 = Config.c(string.substring(39));
                        break;
                    }
                }
            } else {
                bl3 = false;
            }
        }
        textFileObj.tf = filename.getBaseName().length() > 0 ? new TextFile(this.graphDebug.getInvoker().getFileLoader(), localDebugInfo, filename, l2, bl) : new TextFile(localDebugInfo != null ? localDebugInfo.getErrorString() : null);
        textFileObj.ldInfo = localDebugInfo;
        textFileObj.listing = bl;
        String[] stringArray = textFileObj.tf.getFilesNotFound();
        this.textFiles.put(filename.getOrigName(), textFileObj);
        if (textFileObj.tf.getNumLines() > 0) {
            if (stringArray.length > 0 && bl2) {
                this.showFileNotFoundErrorMessage(stringArray);
            }
            this.buildList(textFileObj);
            this.fileChooser.addItem(filename.getOrigName());
            this.setSourceBackground(sourceBackground);
            this.setSourceForeground(sourceForeground);
            if (this.previewPanel.getComponentCount() > 1) {
                this.previewLayout.show(this.previewPanel, filename.getOrigName());
            }
            if (bl2 && localDebugInfo != null && localDebugInfo.getErrorString() == null && bl3 && localDebugInfo.getListingInfos() == null) {
                JOptionPane.showMessageDialog(this.previewArea, "The source code could be wrong".toString(), "WARNING", 0);
            }
        } else {
            if (bl2) {
                this.showFileNotFoundErrorMessage(stringArray);
            }
            if (this.textFiles.size() == 1) {
                this.previewArea = new DebugList();
            }
        }
        return textFileObj;
    }

    private String[] getUnsynchFiles(TextFile textFile, DebugResponse.DebugInfo debugInfo) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        if (debugInfo != null && debugInfo.getTimestamp() > 0L) {
            objectArray = textFile.getFilenames();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                File file;
                String string = ((Filename)objectArray[i2]).getOrigName();
                String string2 = this.graphDebug.getInvoker().getFileLoader().getAbsolutePath(string);
                if (string2 == null || !(file = new File(string2)).exists() || file.lastModified() <= debugInfo.getTimestamp()) continue;
                vector.addElement(string);
            }
        }
        objectArray = new String[vector.size()];
        vector.toArray(objectArray);
        return objectArray;
    }

    private void getFile(LocalDebugInfo stringArray, Filename filename, long l2, boolean bl, boolean bl2) {
        String[] stringArray2;
        String[] stringArray3;
        TextFileObj textFileObj = null;
        textFileObj = (TextFileObj)this.textFiles.get(filename.getOrigName());
        boolean bl3 = false;
        if (textFileObj == null || textFileObj.tf.getNumLines() == 0) {
            textFileObj = this.getNewFile((LocalDebugInfo)stringArray, filename, l2, bl, bl2);
            bl3 = true;
        } else if (textFileObj.ldInfo != stringArray || textFileObj.tf.getTimestamp() > 0L && !this.graphDebug.getInvoker().getFileLoader().checkTimestamp(textFileObj.tf.getFilenames(), textFileObj.tf.getTimestamp())) {
            this.unload(textFileObj.tf);
            if (stringArray == null && textFileObj.listing && (stringArray3 = this.graphDebug.getInvoker().getInfo(textFileObj.tf.getClassName(), this.graphDebug.isProcessing(), true)) != null) {
                stringArray = stringArray3;
            }
            textFileObj = this.getNewFile((LocalDebugInfo)stringArray, filename, l2, textFileObj.listing, bl2);
            bl3 = true;
        } else {
            String[] stringArray4 = textFileObj.tf.getFilesNotFound();
            if (textFileObj.tf.getNumLines() > 0) {
                if (stringArray4.length > 0 && bl2) {
                    this.showFileNotFoundErrorMessage(stringArray4);
                }
                this.scrollPreviewArea = textFileObj.sp;
                this.previewArea = (JList)this.scrollPreviewArea.getViewport().getView();
                this.previewModel = (DebugListModel)this.previewArea.getModel();
                this.previewRenderer = (DebugListCellRenderer)this.previewArea.getCellRenderer();
                this.setSourceBackground(sourceBackground);
                this.setSourceForeground(sourceForeground);
                if (!this.previewArea.getFont().equals(previewFont)) {
                    this.setSourceFont(previewFont);
                }
                this.previewLayout.show(this.previewPanel, filename.getOrigName());
            } else if (bl2) {
                this.showFileNotFoundErrorMessage(stringArray4);
            }
        }
        stringArray3 = null;
        boolean bl4 = false;
        if (stringArray != null) {
            boolean bl5 = bl4 = stringArray.getListingInfos() != null;
            if (!bl4) {
                stringArray3 = this.getUnsynchFiles(textFileObj.tf, (DebugResponse.DebugInfo)stringArray);
            }
        }
        if (bl4) {
            this.warnLbl.setForeground(Color.green.darker());
            this.warnLbl.setToolTipText("source extracted from class");
        } else if (stringArray3 != null && stringArray3.length > 0) {
            stringArray2 = new StringBuffer("<html>");
            if (stringArray3.length == 1) {
                stringArray2.append("File");
            } else {
                stringArray2.append("Files");
            }
            if (stringArray3.length == 1) {
                stringArray2.append(" '" + stringArray3[0] + "'");
            } else {
                for (int i2 = 0; i2 < stringArray3.length; ++i2) {
                    stringArray2.append(", ");
                    stringArray2.append("   '" + stringArray3[i2] + "'");
                }
            }
            stringArray2.append("<br>");
            if (stringArray3.length == 1) {
                stringArray2.append(" has");
            } else {
                stringArray2.append(" have");
            }
            stringArray2.append(" been modified since last compilation!");
            this.warnLbl.setForeground(Color.red);
            this.warnLbl.setToolTipText(stringArray2.toString());
        } else {
            this.warnLbl.setForeground(Color.blue);
            this.warnLbl.setToolTipText("source loaded from disk");
        }
        this.tFileObj = textFileObj;
        this.sourceFormat = -1;
        this.nrw.clear();
        this.ccbas = false;
        if (this.tFileObj != null && this.tFileObj.ldInfo != null) {
            stringArray2 = this.tFileObj.ldInfo.getCompilerOptions();
            if (stringArray2 != null) {
                OptionList optionList = new OptionList(new String[0]);
                optionList.addOptions(stringArray2);
                String string = optionList.getOption("-rw=");
                if (string != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken().toUpperCase();
                        this.nrw.put(string2, string2);
                    }
                }
                boolean bl6 = this.ccbas = optionList.getOption("-ccbas") != null;
            }
            if (bl3 && !Settings.isExpandCopiesOnLoad()) {
                this.collapseAllCopies();
            }
        }
    }

    private void showFileNotFoundErrorMessage(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length == 1) {
            stringBuffer.append("File");
        } else {
            stringBuffer.append("Files");
        }
        stringBuffer.append(" not found:");
        if (stringArray.length == 1) {
            stringBuffer.append(" '" + stringArray[0] + "'");
        } else {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringBuffer.append(GraphDebugger.eol);
                stringBuffer.append("   '" + stringArray[i2] + "'");
            }
        }
        stringBuffer.append(GraphDebugger.eol);
        stringBuffer.append("Make sure the directory containing ");
        if (stringArray.length == 1) {
            stringBuffer.append("this file");
        } else {
            stringBuffer.append("these files");
        }
        stringBuffer.append(" is listed");
        stringBuffer.append(GraphDebugger.eol);
        stringBuffer.append("in CLASSPATH or iscobol.debug.code_prefix");
        JOptionPane.showMessageDialog(this.previewArea, stringBuffer.toString(), "ERROR", 0);
    }

    Breakpoint getBreakpoint(int n2) {
        CobolRef cobolRef = this.tFileObj.tf.getBPArgs(this.getListingline(n2));
        if (cobolRef == null || this.breakpointModel == null || this.breakpointModel.size() == 0) {
            return null;
        }
        Breakpoint breakpoint = new Breakpoint(cobolRef);
        int n3 = this.breakpointModel.indexOf(breakpoint);
        if (n3 >= 0) {
            return (Breakpoint)this.breakpointModel.elementAt(n3);
        }
        return null;
    }

    private void buildList(TextFileObj textFileObj) {
        Serializable serializable;
        this.previewModel = new DebugListModel();
        this.loadList(textFileObj.tf, this.previewModel);
        this.previewArea = new DebugList();
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                DebugPanel.this.endDragLine = DebugPanel.this.previewArea.locationToIndex(mouseEvent.getPoint());
                DebugPanel.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (DebugPanel.this.graphDebug.getFrame().isActive()) {
                    Point point = mouseEvent.getPoint();
                    if (DebugPanel.this.tipPopup != null) {
                        if (!DebugPanel.this.lastMouseEventArea.contains(point)) {
                            DebugPanel.this.hideTipPopup();
                            DebugPanel.this.lastMouseEventArea = null;
                            DebugPanel.this.tipAction.setMousePos(point);
                            DebugPanel.this.tipTimer.restart();
                        }
                    } else {
                        DebugPanel.this.tipAction.setMousePos(point);
                        DebugPanel.this.tipTimer.restart();
                    }
                    if (DebugPanel.isLink(DebugPanel.this.highlightVarType)) {
                        if (!DebugPanel.this.lastLinkArea.contains(point)) {
                            if (DebugPanel.this.highlightVarType == HighlightVarType.LINK) {
                                DebugPanel.this.setHighlightedVar(null, HighlightVarType.NONE, -1, -1);
                            } else {
                                DebugPanel.this.setHighlightedVar(DebugPanel.this.highlightedVar, HighlightVarType.HIGHLIGHT, DebugPanel.this.highlightedVarLine, DebugPanel.this.highlightedVarCol);
                            }
                            DebugPanel.this.lastLinkArea = null;
                            DebugPanel.this.handMouseAction.setMousePos(point);
                            DebugPanel.this.handMouseTimer.restart();
                        }
                    } else {
                        DebugPanel.this.handMouseAction.setMousePos(point);
                        DebugPanel.this.handMouseTimer.restart();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DebugPanel.this.quickWatchPoint = mouseEvent.getPoint();
                if (mouseEvent.isPopupTrigger()) {
                    DebugPanel.this.listPopup.show(DebugPanel.this.previewArea, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DebugPanel.this.setHighlightedWord(null);
                if (DebugPanel.this.previewModel == null) {
                    return;
                }
                DebugPanel.this.quickWatchPoint = mouseEvent.getPoint();
                if (mouseEvent.isPopupTrigger()) {
                    DebugPanel.this.listPopup.show(DebugPanel.this.previewArea, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                int n2 = DebugPanel.this.previewArea.locationToIndex(mouseEvent.getPoint());
                if (n2 < DebugPanel.this.previewModel.getSize()) {
                    if (mouseEvent.getX() < 20) {
                        CobolRef cobolRef = ((DebugPanel)DebugPanel.this).tFileObj.tf.getBPArgs(DebugPanel.this.getListingline(n2));
                        if (cobolRef.isCopyStatement()) {
                            if (((DebugPanel)DebugPanel.this).previewModel.getLineAt((int)n2).copyExpanded) {
                                DebugPanel.this.collapseCopy(n2);
                            } else {
                                DebugPanel.this.expandCopy(n2);
                            }
                        } else {
                            Breakpoint breakpoint = DebugPanel.this.getBreakpoint(n2);
                            String string = breakpoint != null ? "clear" : "break";
                            string = string + " ";
                            string = breakpoint != null && breakpoint.getParagraph() != null ? string + breakpoint.getParagraph() : string + cobolRef.lineNo();
                            string = string + " \"" + cobolRef.filename() + "\"";
                            if (cobolRef.getFileIndex() >= 0) {
                                string = string + " -fi " + cobolRef.getFileIndex();
                            }
                            if (cobolRef.progname() != null) {
                                string = string + " " + cobolRef.progname();
                            }
                            DebugPanel.this.graphDebug.setTextCommand(string);
                        }
                    } else if (mouseEvent.getX() > numberColumnLen + 20) {
                        String string = ((DebugPanel)DebugPanel.this).previewModel.getLineAt((int)n2).lineStr;
                        int n3 = GraphUtilities.pixelsToOffset(previewMetrics, string, mouseEvent.getX() - 20 - numberColumnLen);
                        DebugPanel.this.setCursorColumn(n3, n2);
                    }
                }
                if (mouseEvent.getButton() == 1) {
                    if (mouseEvent.isShiftDown()) {
                        DebugPanel.this.endDragLine = DebugPanel.this.previewArea.locationToIndex(mouseEvent.getPoint());
                        DebugPanel.this.repaint();
                    } else {
                        DebugPanel.this.setSelectedLine(DebugPanel.this.previewArea.locationToIndex(mouseEvent.getPoint()));
                    }
                }
                DebugPanel.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                block0 : switch (mouseEvent.getClickCount()) {
                    case 1: {
                        DebugPanel.this.linkTimer.restart();
                        break;
                    }
                    case 2: {
                        int n2 = DebugPanel.this.previewArea.locationToIndex(mouseEvent.getPoint());
                        int n3 = DebugPanel.this.getListingline(n2);
                        CobolRef cobolRef = DebugPanel.this.getFile().toCobolLine(n3);
                        MyVarName myVarName = DebugPanel.this.getVarName(mouseEvent.getPoint());
                        if (myVarName == null || myVarName.varName.length() <= 0) break;
                        String string = myVarName.varName.trim();
                        if (DebugPanel.this.graphDebug.isRunning() && !DebugPanel.this.graphDebug.isProcessing()) {
                            DebugPanel.this.restartTimers(mouseEvent.getPoint());
                            DebugResponse debugResponse = DebugPanel.this.displayVar(string, n3);
                            if (debugResponse != null) {
                                switch (debugResponse.getReturnCode()) {
                                    case 0: 
                                    case 22: {
                                        DebugPanel.this.setHighlightedVar(myVarName.origText);
                                        if (debugResponse.getReturnCode() != 0) break block0;
                                        DebugPanel.this.outputResult(debugResponse.getMessage() + GraphDebugger.eol);
                                        break;
                                    }
                                    case 6: 
                                    case 25: {
                                        break;
                                    }
                                    default: {
                                        DebugPanel.this.goTo(cobolRef.lineNo(), string, cobolRef.getFileIndex());
                                        break;
                                    }
                                }
                                break;
                            }
                            DebugPanel.this.goTo(cobolRef.lineNo(), string, cobolRef.getFileIndex());
                            break;
                        }
                        DebugPanel.this.goTo(cobolRef.lineNo(), string, cobolRef.getFileIndex());
                    }
                }
                DebugPanel.this.lineCommand.requestFocusInWindow();
            }
        };
        this.previewArea.addMouseMotionListener(mouseInputAdapter);
        this.previewArea.addMouseListener(mouseInputAdapter);
        this.previewArea.addKeyListener(this.globalKeyListener);
        this.previewArea.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.previewArea.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 2);
        String string = "previewArea.copy";
        InputMap inputMap = this.previewArea.getInputMap();
        if (inputMap != null) {
            for (serializable = inputMap; serializable != null; serializable = serializable.getParent()) {
                serializable.remove(keyStroke);
            }
        } else {
            inputMap = new InputMap();
            this.previewArea.setInputMap(0, inputMap);
        }
        inputMap.put(keyStroke, "previewArea.copy");
        serializable = this.previewArea.getActionMap();
        if (serializable == null) {
            serializable = new ActionMap();
            this.previewArea.setActionMap((ActionMap)serializable);
        }
        ((ActionMap)serializable).put("previewArea.copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DebugPanel.this.copy();
            }
        });
        this.previewArea.setModel(this.previewModel);
        this.previewArea.setFont(previewFont);
        if (previewMetrics == null) {
            previewMetrics = this.previewArea.getFontMetrics(previewFont);
        }
        this.previewRenderer = new DebugListCellRenderer(previewMetrics);
        this.previewArea.setCellRenderer(this.previewRenderer);
        this.previewArea.setFixedCellHeight(previewMetrics.getHeight() + 2);
        this.scrollPreviewArea = DebugPanel.createJScrollPane(this.previewArea);
        this.scrollPreviewArea.getVerticalScrollBar().setUnitIncrement(this.previewArea.getFixedCellHeight());
        textFileObj.sp = this.scrollPreviewArea;
        this.previewPanel.add((Component)this.scrollPreviewArea, new Filename(textFileObj.tf.getFilename()).getOrigName());
    }

    private void loadList(TextFile textFile, DebugListModel debugListModel) {
        int n2 = textFile.getNumLines();
        debugListModel.allocate(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            CobolRef cobolRef = textFile.toCobolLine(i2);
            if (cobolRef == null) continue;
            Line line = new Line(cobolRef.lineNo(), i2, textFile.getLine(i2, false), cobolRef.getCopyDeep(), cobolRef.getCopyFileIndex());
            debugListModel.add(line);
        }
    }

    public void setBreakpoints(Breakpoint[] breakpointArray) {
        this.breakpointModel.setItems(breakpointArray);
        this.breakpointTable.reload();
        boolean bl = false;
        boolean bl2 = false;
        if (breakpointArray != null) {
            for (int i2 = 0; i2 < breakpointArray.length; ++i2) {
                if (breakpointArray[i2].isEnabled()) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
        }
        this.breakpointEnAllBtn.setEnabled(bl2);
        this.breakpointDisAllBtn.setEnabled(bl);
        this.breakpointEnAllItem.setEnabled(bl2);
        this.breakpointDisAllItem.setEnabled(bl);
        this.breakpointRemoveAllBtn.setEnabled(breakpointArray != null && breakpointArray.length > 0);
        this.breakpointRemoveAllItem.setEnabled(breakpointArray != null && breakpointArray.length > 0);
        this.breakpointTableSelectionChanged(0);
        this.previewArea.repaint();
    }

    public void overwriteSysOut() {
        GraphUtilities.setOut(new DebugOutputStream(new MyAppender(false)));
    }

    public void overwriteSysErr() {
        GraphUtilities.setErr(new DebugOutputStream(new MyAppender(true)));
    }

    void displayVarsOnSelLine() {
        this.displayVarsOnSelLine(false, false);
    }

    private void displayVarsOnSelLine(boolean bl, boolean bl2) {
        block10: {
            int n2 = this.getSelListingLine();
            if (n2 < 0) {
                return;
            }
            String string = this.tFileObj.tf.getLine(n2, false);
            List<MyVarName> list = this.getVarNames(string, -1, this.getSourceFormat(), Collections.EMPTY_SET);
            if (list == null || list.size() == 0) {
                if (!bl) {
                    this.outputResult("No variables found on selected line" + GraphDebugger.eol);
                }
                return;
            }
            if (bl2 != this.lastVarSearchBackward) {
                this.lastPosForVarSearch = bl2 ? (this.lastPosForVarSearch -= 2) : (this.lastPosForVarSearch += 2);
                this.lastVarSearchBackward = bl2;
            }
            if (this.lastPosForVarSearch < 0 || this.lastPosForVarSearch >= list.size()) {
                this.lastPosForVarSearch = bl2 ? list.size() - 1 : 0;
            }
            int n3 = this.lastPosForVarSearch;
            do {
                boolean bl3;
                MyVarName myVarName = list.get(bl2 ? n3-- : n3++);
                DebugResponse debugResponse = this.displayVar(myVarName.varName, n2);
                boolean bl4 = bl3 = debugResponse != null;
                if (bl3) {
                    bl3 = bl ? (bl3 &= debugResponse.getReturnCode() == 0 || debugResponse.getReturnCode() == 22) : (bl3 &= debugResponse.getReturnCode() == 0);
                    if (bl) {
                        this.cursorColumn = myVarName.offs;
                        this.setHighlightedVar(myVarName.origText);
                    } else {
                        String string2 = "+ " + debugResponse.getVarName() + " = " + debugResponse.getVarValue() + GraphDebugger.eol;
                        this.outputResult(string2);
                    }
                    this.lastPosForVarSearch = n3;
                    break block10;
                }
                if (bl2) {
                    if (n3 >= 0) continue;
                    n3 = list.size() - 1;
                    continue;
                }
                if (n3 != list.size()) continue;
                n3 = 0;
            } while (n3 != this.lastPosForVarSearch);
            if (bl) break block10;
            this.outputResult("No variables found on selected line" + GraphDebugger.eol);
        }
    }

    protected String[] getVarNamesOnSelectedLine() {
        if (this.selLine < 0) {
            return null;
        }
        String string = this.tFileObj.tf.getLine(this.selLine, false);
        List<MyVarName> list = this.getVarNames(string, -1, this.getSourceFormat(), Collections.EMPTY_SET);
        String[] stringArray = null;
        if (list != null) {
            stringArray = new String[list.size()];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = list.get((int)i2).varName;
            }
        }
        return stringArray;
    }

    public void outputResult(String string) {
        new IsguiWorker(false, () -> this.outputResult0(string)).start();
    }

    void outputResult0(String string) {
        this.textOutput.append(string);
        this.textOutput.setCaretPosition(this.textOutput.getDocument().getLength());
    }

    public void selectLast() {
        if (this.previewModel != null) {
            this.select(this.previewModel.getSize() - 1, 0);
        }
    }

    public void selectCurrentLine() {
        this.select(this.currLine, 0);
    }

    public void select(int n2, int n3) {
        this.select(n2, n3, null);
    }

    private void select(int n2, int n3, String string) {
        this.setHighlightedWord(string);
        this.setSelectedLine(n2);
        this.setCursorColumn(n3, n2);
        this.ensureVisible(n2);
        this.previewArea.repaint();
    }

    protected void setSelectedLine(int n2) {
        if (this.selLine != n2) {
            if (n2 < 0) {
                n2 = 0;
            }
            this.startDragLine = this.endDragLine = n2;
            this.selLine = this.endDragLine;
            this.lastPosForVarSearch = -1;
            this.lastVarSearchBackward = false;
        }
    }

    protected int getSelectedLine() {
        return this.selLine;
    }

    private void setCursorColumn(int n2, int n3) {
        if (this.previewModel == null) {
            return;
        }
        this.cursorColumn = n2;
        this.cursorX = 20 + numberColumnLen;
        if (n2 > 0 && n3 < this.previewModel.getSize()) {
            this.cursorX += previewMetrics.stringWidth(this.previewModel.getLineAt((int)n3).lineStr.substring(0, n2));
        }
    }

    private void ensureVisible(int n2) {
        new IsguiWorker(true, () -> this.previewArea.ensureIndexIsVisible(n2)).start();
    }

    private void restartTimers(Point point) {
        this.hideTipPopup();
        this.tipAction.setMousePos(point);
        this.handMouseAction.setMousePos(point);
        this.tipTimer.restart();
        this.handMouseTimer.restart();
    }

    public void setCurrentLine(int n2) {
        this.setCurrentLine(n2, true);
    }

    public void setCurrentLine(int n2, boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setCurrentLine0(n2, bl);
        } else {
            SwingUtilities.invokeLater(() -> this.setCurrentLine0(n2, bl));
        }
    }

    private void setCurrentLine0(int n2, boolean bl) {
        int n3;
        this.currLine = n3 = n2;
        this.setSelectedLine(n3);
        int n4 = this.previewArea.getFirstVisibleIndex();
        int n5 = this.previewArea.getLastVisibleIndex();
        if (this.previewModel != null && n5 > 0 && this.currLine >= n5 + 1) {
            n3 = Math.min(n3 + n5 - n4 - 1, this.previewModel.getSize() - 1);
        }
        if (bl) {
            this.ensureVisible(n3);
        }
        this.setCursorColumn(0, n3);
        this.previewArea.repaint();
        this.gotoList.clear();
        this.gotoIndex = -1;
        this.graphDebug.updateGotoActions(false, false);
    }

    public int getCurrentLine() {
        return this.currLine;
    }

    void repaintSource() {
        this.previewArea.repaint();
    }

    public void clearOutput() {
        new IsguiWorker(false, () -> this.textOutput.setText("")).start();
    }

    public void setEnabledAll(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        boolean bl5;
        if (bl) {
            this.callStackLayout.last(this.callStackPanel);
            this.threadLayout.last(this.threadPanel);
        } else {
            this.callStackLayout.first(this.callStackPanel);
            this.threadLayout.first(this.threadPanel);
        }
        this.btnStepInto.setEnabled(bl);
        this.btnNext.setEnabled(bl);
        this.btnContinue.setEnabled(bl);
        this.btnSuspend.setEnabled(!bl && this.graphDebug.isRunning());
        this.setJumpCommandEnabled(bl && bl2);
        this.btnOutPar.setEnabled(bl);
        this.btnOutProg.setEnabled(bl);
        this.btnStepTo.setEnabled(bl);
        this.btnStepToPgm.setEnabled(bl);
        this.btnAutoStep.setEnabled(bl);
        this.contItem.setEnabled(bl);
        this.suspItem.setEnabled(!bl);
        this.stepIntoItem.setEnabled(bl);
        this.stepOverItem.setEnabled(bl);
        this.runToItem.setEnabled(bl);
        this.runToNextPgmItem.setEnabled(bl);
        this.jumpItem.setEnabled(bl && bl2);
        this.jumpOutItem.setEnabled(bl && bl2);
        this.jumpOutProgItem.setEnabled(bl && bl2);
        this.jumpNextItem.setEnabled(bl && bl2);
        this.outParItem.setEnabled(bl);
        this.outProgItem.setEnabled(bl);
        this.quickWatchItem.setEnabled(bl);
        this.refreshItem.setEnabled(bl);
        if (this.graphDebug.stopImmediately) {
            this.toggleBrItem.setEnabled(bl);
        }
        this.displayOnLineItem.setEnabled(bl);
        this.varAddBtn.setEnabled(bl);
        this.varHexBtn.setEnabled(bl);
        this.varAddItem.setEnabled(bl);
        this.varHexItem.setEnabled(bl);
        if (this.graphDebug.stopImmediately) {
            bl5 = this.graphDebug.isRunning() ? bl : true;
            bl4 = this.breakpointTable.getSelectedRowCount() > 0;
            bl3 = false;
            boolean bl6 = false;
            Breakpoint[] breakpointArray = this.getBreakpoints();
            int n2 = breakpointArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Breakpoint breakpoint = breakpointArray[i2];
                if (breakpoint.isEnabled()) {
                    bl3 = true;
                } else {
                    bl6 = true;
                }
                if (bl3 && bl6) break;
            }
            this.breakpointAddBtn.setEnabled(bl5);
            this.breakpointEnAllBtn.setEnabled(bl5 && bl6);
            this.breakpointDisAllBtn.setEnabled(bl5 && bl3);
            this.breakpointModifyBtn.setEnabled(bl5 && bl4);
            this.breakpointRemoveBtn.setEnabled(bl5 && bl4);
            this.breakpointRemoveAllBtn.setEnabled(bl5);
            this.breakpointAddItem.setEnabled(bl5);
            this.breakpointEnAllItem.setEnabled(bl5 && bl6);
            this.breakpointDisAllItem.setEnabled(bl5 && bl3);
            this.breakpointModifyItem.setEnabled(bl5 && bl4);
            this.breakpointRemoveItem.setEnabled(bl5 && bl4);
            this.breakpointRemoveAllItem.setEnabled(bl5);
        }
        bl5 = this.monitorTable.getSelectedRowCount() > 0;
        bl4 = false;
        bl3 = false;
        for (Watch watch : this.getMonitors()) {
            if (watch.isEnabled()) {
                bl4 = true;
            } else {
                bl3 = true;
            }
            if (bl4 && bl3) break;
        }
        this.monitorAddBtn.setEnabled(bl);
        this.monitorEnAllBtn.setEnabled(bl && bl3);
        this.monitorDisAllBtn.setEnabled(bl && bl4);
        this.monitorModifyBtn.setEnabled(bl && bl5);
        this.monitorRemoveBtn.setEnabled(bl && bl5);
        this.monitorRemoveAllBtn.setEnabled(bl);
        this.monitorAddItem.setEnabled(bl);
        this.monitorEnAllItem.setEnabled(bl && bl3);
        this.monitorDisAllItem.setEnabled(bl && bl4);
        this.monitorModifyItem.setEnabled(bl && bl5);
        this.monitorRemoveItem.setEnabled(bl && bl5);
        this.monitorRemoveAllItem.setEnabled(bl);
    }

    void setRunQuitEnabled(boolean bl) {
        this.btnRun.setEnabled(!bl);
        this.btnStop.setEnabled(bl);
    }

    void setRunEnabled(boolean bl) {
        this.btnRun.setEnabled(bl);
    }

    void setQuitEnabled(boolean bl) {
        this.btnStop.setEnabled(bl);
    }

    public void setRunCommandsButtonsEnabled(boolean bl, boolean bl2) {
        this.btnRun.setEnabled(!bl);
        this.btnStop.setEnabled(bl);
        this.btnContinue.setEnabled(bl);
        this.btnSuspend.setEnabled(bl);
        this.setJumpCommandEnabled(bl && bl2);
        this.btnNext.setEnabled(bl);
        this.btnOutPar.setEnabled(bl);
        this.btnOutProg.setEnabled(bl);
        this.btnStepInto.setEnabled(bl);
        this.btnStepTo.setEnabled(bl);
        this.btnStepToPgm.setEnabled(bl);
        this.memoryView.setEnabled(bl);
    }

    void clearTrees() {
        for (int i2 = 0; i2 < this.varRootNode.length; ++i2) {
            this.varRootNode[i2].removeAllChildren();
            this.varTreeTable[i2].reload();
        }
    }

    protected void setAutostepState(boolean bl) {
        new IsguiWorker(false, () -> {
            this.btnAutoStep.setSelected(bl);
            this.autostepStateChanged();
        }).start();
    }

    public Watch[] getMonitors() {
        Object[] objectArray = this.monitorModel.toArray();
        Watch[] watchArray = new Watch[objectArray.length];
        System.arraycopy(objectArray, 0, watchArray, 0, objectArray.length);
        return watchArray;
    }

    public Breakpoint[] getBreakpoints() {
        Object[] objectArray = this.breakpointModel.toArray();
        Breakpoint[] breakpointArray = new Breakpoint[objectArray.length];
        System.arraycopy(objectArray, 0, breakpointArray, 0, objectArray.length);
        return breakpointArray;
    }

    public String[][] getWatchedVariableNames() {
        String[][] stringArray = new String[this.watchedVarnames.size()][2];
        for (int i2 = 0; i2 < this.watchedVarnames.size(); ++i2) {
            stringArray[i2] = this.watchedVarnames.get(i2);
        }
        return stringArray;
    }

    protected void setWatchedVariableNames(List<String[]> list) {
        this.watchedVarnames = list;
        this.varRemoveAllBtn.setEnabled(this.watchedVarnames.size() > 0);
    }

    String[] getWatchedVariableCommands() {
        String[] stringArray = new String[this.watchedVarnames.size()];
        String string = "display -tree -x";
        int n2 = 0;
        while (n2 < stringArray.length) {
            String[] stringArray2 = this.watchedVarnames.get(n2);
            stringArray[n2] = "display -tree -x";
            if (stringArray2[1] != null) {
                int n3 = n2;
                stringArray[n3] = stringArray[n3] + " -c " + stringArray2[1];
            }
            int n4 = n2++;
            stringArray[n4] = stringArray[n4] + " " + stringArray2[0];
        }
        return stringArray;
    }

    public boolean hasBreakpoints() {
        return this.breakpointModel.size() > 0;
    }

    public boolean hasMonitors() {
        return this.monitorModel.size() > 0;
    }

    public void setMonitors(Watch[] watchArray) {
        this.monitorModel.setItems(watchArray);
        this.monitorTable.reload();
        boolean bl = false;
        boolean bl2 = false;
        if (watchArray != null) {
            for (int i2 = 0; i2 < watchArray.length; ++i2) {
                if (watchArray[i2].isEnabled()) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
        }
        this.monitorEnAllBtn.setEnabled(bl2);
        this.monitorDisAllBtn.setEnabled(bl);
        this.monitorEnAllItem.setEnabled(bl2);
        this.monitorDisAllItem.setEnabled(bl);
        this.monitorRemoveAllBtn.setEnabled(watchArray != null && watchArray.length > 0);
        this.monitorRemoveAllItem.setEnabled(watchArray != null && watchArray.length > 0);
        this.monitorTableSelectionChanged(0);
    }

    public void deactivateMonitors() {
        new IsguiWorker(false, () -> {
            Object[] objectArray = new Watch[this.monitorModel.size()];
            this.monitorModel.toArray(objectArray);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ((Watch)objectArray[i2]).setActive(false);
            }
            this.setMonitors((Watch[])objectArray);
        }).start();
    }

    public void setParStack(ParagraphObject[] paragraphObjectArray) {
        if (paragraphObjectArray != null && paragraphObjectArray.length > 0) {
            for (ParagraphObject paragraphObject : paragraphObjectArray) {
                this.graphDebug.getInvoker().setSection(paragraphObject);
            }
            this.selParObj = paragraphObjectArray[paragraphObjectArray.length - 1];
        }
        this.callStackModel.setItems(paragraphObjectArray);
        this.callStackTable.reload();
        new IsguiWorker(false, () -> {
            Rectangle rectangle = this.callStackTable.getCellRect(this.callStackModel.size() - 1, 0, true);
            this.callStackTable.scrollRectToVisible(rectangle);
        }).start();
    }

    private Set<String> findVarNamesInStatement(int n2, int n3, DebugLine[] debugLineArray, Set<String> set) {
        CobolRef cobolRef;
        int n4;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (debugLineArray == null) {
            return linkedHashSet;
        }
        TextFile textFile = this.getFile();
        int n5 = -1;
        int n6 = textFile.getNumLines();
        for (n4 = 0; n4 < debugLineArray.length; ++n4) {
            if (debugLineArray[n4].getLineNumber() != n2 || debugLineArray[n4].getFileIndex() != n3) continue;
            n5 = textFile.toListingLine(debugLineArray[n4].getLineNumber(), n3);
            if (n4 >= debugLineArray.length - 1) break;
            n6 = textFile.toListingLine(debugLineArray[n4 + 1].getLineNumber(), debugLineArray[n4 + 1].getFileIndex()) - 1;
            break;
        }
        if (n5 < 0) {
            return linkedHashSet;
        }
        n4 = this.getSourceFormat();
        for (int i2 = n5; i2 <= n6 && (cobolRef = textFile.toCobolLine(i2)) != null; ++i2) {
            String string = textFile.getLine(i2, false);
            List<MyVarName> list = this.getVarNames(string, -1, n4, set);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                linkedHashSet.add(list.get((int)i3).varName);
            }
        }
        return linkedHashSet;
    }

    boolean isAutoRefreshEnabled() {
        return this.varAutoRefreshBtn.isSelected();
    }

    void refreshCurrentVariables(int n2, int n3, int n4, int n5) {
        DebugLine[] debugLineArray = this.getFile().getDebugLines();
        HashSet<String> hashSet = new HashSet<String>();
        this.getFile().getParagraphsNames(hashSet);
        Set<String> set = this.findVarNamesInStatement(n2, n3, debugLineArray, hashSet);
        if (n4 > 0) {
            set.addAll(this.findVarNamesInStatement(n4, n5, debugLineArray, hashSet));
        }
        if (!set.isEmpty()) {
            Tree[] treeArray;
            String string = this.getCurrentModule();
            Vector<DebugCommand> vector = new Vector<DebugCommand>();
            LinkedHashMap<String, VariableNode> linkedHashMap = new LinkedHashMap<String, VariableNode>();
            for (String object2 : set) {
                treeArray = null;
                for (int string2 = 0; string2 < this.varRootNode[0].getChildCount(); ++string2) {
                    Tree[] n6 = (Tree[])this.varRootNode[0].getChildAt(string2);
                    if (!n6.getName().equalsIgnoreCase(object2)) continue;
                    if (n6.getClassName() != null) {
                        if (!n6.getClassName().equals(string)) continue;
                        treeArray = n6;
                        break;
                    }
                    if (string != null) continue;
                    treeArray = n6;
                    break;
                }
                if (treeArray != null && treeArray.getChildCount() > 0) {
                    this.addDisplayCommand((VariableNode)treeArray, linkedHashMap, vector);
                    continue;
                }
                String identityHashMap = null;
                identityHashMap = treeArray != null ? treeArray.getClassName() : string;
                linkedHashMap.put(DebugPanel.getKey(object2, identityHashMap), (VariableNode)treeArray);
                this.addDisplayCommand(object2, identityHashMap, (short)0, vector);
            }
            CompositeCommand compositeCommand = new CompositeCommand(vector);
            DebugResponse debugResponse = this.graphDebug.getInvoker().processCommand(compositeCommand);
            treeArray = debugResponse.getTrees();
            if (treeArray != null && treeArray.length > 0) {
                IdentityHashMap<VariableNode, VariableNode> identityHashMap = new IdentityHashMap<VariableNode, VariableNode>();
                for (Tree tree : treeArray) {
                    TreeNode treeNode = tree.getRoot();
                    String string2 = treeNode.getVarName();
                    String string3 = DebugPanel.getKey(string2, tree.getClassName());
                    if (!linkedHashMap.containsKey(string3)) continue;
                    VariableNode variableNode = linkedHashMap.get(string3);
                    TreeNode treeNode2 = treeNode;
                    TreeNode[] treeNodeArray = treeNode2.getChildren();
                    if (treeNodeArray.length == 1 && treeNodeArray[0].getVarName().equals(treeNode2.getVarName())) {
                        treeNode2 = treeNodeArray[0];
                    }
                    if (variableNode != null && variableNode.getParent() != null) {
                        VariableNode variableNode2 = GraphUtilities.buildVariableNode(treeNode2, tree.getClassName(), null, tree.isHex());
                        this.varModel[0].updateNode(variableNode, variableNode2);
                        VariableNode variableNode3 = (VariableNode)variableNode.getParent();
                        while (variableNode3 != this.varRootNode[0]) {
                            variableNode = variableNode3;
                            variableNode3 = (VariableNode)variableNode.getParent();
                        }
                    } else {
                        variableNode = GraphUtilities.buildVariableNode(treeNode2, tree.getClassName(), this.varRootNode[0], tree.isHex());
                    }
                    identityHashMap.put(variableNode, variableNode);
                }
                int n6 = 0;
                while (n6 < this.varRootNode[0].getChildCount()) {
                    if (!identityHashMap.containsKey((VariableNode)this.varRootNode[0].getChildAt(n6))) {
                        this.varRootNode[0].removeChildAt(n6);
                        continue;
                    }
                    ++n6;
                }
            } else {
                this.varRootNode[0].removeAllChildren();
            }
        } else {
            this.varRootNode[0].removeAllChildren();
        }
        this.reloadAndRestoreExpandedPaths(0);
    }

    private void addDisplayCommand(String string, String string2, short s2, Vector<DebugCommand> vector) {
        try {
            DisplayCommand displayCommand = new DisplayCommand(new VarName(new DebugTM(string)), string2, true, true, s2);
            displayCommand.setDisplayAsText(true);
            vector.addElement(displayCommand);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    private void addDisplayCommand(VariableNode variableNode, LinkedHashMap<String, VariableNode> linkedHashMap, Vector<DebugCommand> vector) {
        this.addDisplayCommand(variableNode.getName(), variableNode.getClassName(), (short)1, vector);
        linkedHashMap.put(DebugPanel.getKey(variableNode.getName(), variableNode.getClassName()), variableNode);
        for (int i2 = 0; i2 < variableNode.getChildCount(); ++i2) {
            VariableNode variableNode2 = (VariableNode)variableNode.getChildAt(i2);
            if (variableNode2.getChildCount() <= 0) continue;
            this.addDisplayCommand(variableNode2, linkedHashMap, vector);
        }
    }

    void refreshVariables() {
        for (int i2 = 0; i2 < this.varRootNode.length; ++i2) {
            this.refreshVariables(i2);
        }
    }

    private static String getKey(String string, String string2) {
        String string3 = new DebugTM(string.toLowerCase()).toString();
        if (string2 != null) {
            string3 = string3 + "[" + string2 + "]";
        }
        return string3;
    }

    void refreshVariables(int n2) {
        Vector<DebugCommand> vector = new Vector<DebugCommand>();
        LinkedHashMap<String, VariableNode> linkedHashMap = new LinkedHashMap<String, VariableNode>();
        VariableNode variableNode = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (n2 == 1) {
            arrayList.addAll(this.watchedVarnames);
        }
        for (int i2 = 0; i2 < this.varRootNode[n2].getChildCount(); ++i2) {
            variableNode = (VariableNode)this.varRootNode[n2].getChildAt(i2);
            if (variableNode != null && variableNode.getChildCount() > 0) {
                this.addDisplayCommand(variableNode, linkedHashMap, vector);
            } else {
                linkedHashMap.put(DebugPanel.getKey(variableNode.getName(), variableNode.getClassName()), variableNode);
                this.addDisplayCommand(variableNode.getName(), variableNode.getClassName(), (short)0, vector);
            }
            this.removeFromWatchedVarNames(variableNode.getName(), variableNode.getClassName(), arrayList);
        }
        if (n2 == 1) {
            for (String[] object2 : arrayList) {
                this.addDisplayCommand(object2[0], object2[1], (short)0, vector);
                linkedHashMap.put(DebugPanel.getKey(object2[0], object2[1]), null);
            }
        }
        CompositeCommand compositeCommand = new CompositeCommand(vector);
        DebugResponse debugResponse = this.graphDebug.getInvoker().processCommand(compositeCommand);
        Tree[] treeArray = debugResponse.getTrees();
        if (treeArray != null && treeArray.length > 0) {
            for (Tree tree : treeArray) {
                TreeNode treeNode = tree.getRoot();
                String string = treeNode.getVarName();
                String string2 = DebugPanel.getKey(string, tree.getClassName());
                if (!linkedHashMap.containsKey(string2)) continue;
                variableNode = linkedHashMap.get(string2);
                TreeNode treeNode2 = treeNode;
                TreeNode[] treeNodeArray = treeNode2.getChildren();
                if (treeNodeArray.length == 1 && treeNodeArray[0].getVarName().equals(treeNode2.getVarName())) {
                    treeNode2 = treeNodeArray[0];
                }
                if (variableNode != null && variableNode.getParent() != null) {
                    VariableNode variableNode2 = GraphUtilities.buildVariableNode(treeNode2, tree.getClassName(), null, tree.isHex());
                    this.varModel[n2].updateNode(variableNode, variableNode2);
                    continue;
                }
                variableNode = GraphUtilities.buildVariableNode(treeNode2, tree.getClassName(), this.varRootNode[n2], tree.isHex());
            }
            this.reloadAndRestoreExpandedPaths(n2);
        }
    }

    private boolean isWatchedVarName(String string, String string2) {
        for (String[] stringArray : this.watchedVarnames) {
            if (!string.equals(stringArray[0]) || (string2 == null || !string2.equals(stringArray[1])) && (string2 != null || stringArray[1] != null)) continue;
            return true;
        }
        return false;
    }

    public void setTree(Tree tree, boolean bl) {
        this.setTree(tree, bl, 1);
    }

    private void setTree(Tree tree, boolean bl, int n2) {
        VariableNode variableNode;
        VariableNode variableNode2;
        if (tree == null) {
            return;
        }
        String string = tree.getRoot().getVarName();
        VariableNode variableNode3 = null;
        for (int i2 = 0; i2 < this.varRootNode[n2].getChildCount(); ++i2) {
            variableNode2 = (VariableNode)this.varRootNode[n2].getChildAt(i2);
            if (!variableNode2.getName().equalsIgnoreCase(string)) continue;
            variableNode3 = variableNode2;
            break;
        }
        if ((variableNode = GraphUtilities.buildVariableNode(tree)).getChildCount() == 1) {
            variableNode2 = (VariableNode)variableNode.getChildAt(0);
            String string2 = variableNode.getName();
            String string3 = variableNode2.getName();
            int n3 = string2.indexOf(40);
            if (n3 >= 0) {
                string2 = string2.substring(0, n3).trim();
                n3 = string3.indexOf(40);
                if (n3 >= 0) {
                    string3 = string3.substring(0, n3).trim();
                }
            }
            if (string2.equals(string3)) {
                variableNode2.setName(variableNode.getName());
                variableNode = variableNode2;
            }
        }
        if (variableNode3 != null) {
            this.varModel[n2].updateNode(variableNode3, variableNode);
        } else {
            this.varRootNode[n2].addChild(variableNode);
            if (n2 == 1 && !this.isWatchedVarName(string, tree.getClassName())) {
                this.watchedVarnames.add(new String[]{string, tree.getClassName()});
                this.varRemoveAllBtn.setEnabled(true);
            }
        }
        if (bl) {
            this.reloadAndRestoreExpandedPaths(n2);
        }
        if (!this.isVariablesAreaOpen()) {
            this.openVariablesArea();
        }
    }

    private void reloadAndRestoreExpandedPaths(int n2) {
        SwingUtilities.invokeLater(() -> {
            Vector<TreePath> vector = new Vector<TreePath>();
            JTree jTree = this.varTree[n2];
            DebugPanel.getAllExpandedPaths(jTree, new TreePath(this.varRootNode[n2].getPath()), vector);
            JScrollPane jScrollPane = this.varScrollPane[n2];
            int n3 = jScrollPane.getVerticalScrollBar().getValue();
            this.varTreeTable[n2].reload();
            if (!vector.isEmpty()) {
                DebugPanel.setExpandedPaths(jTree, vector);
            }
            jScrollPane.getVerticalScrollBar().setValue(n3);
        });
    }

    private static void getAllExpandedPaths(JTree jTree, TreePath treePath, Vector<TreePath> vector) {
        if (!jTree.isExpanded(treePath)) {
            return;
        }
        vector.add(treePath);
        VariableNode variableNode = (VariableNode)treePath.getLastPathComponent();
        if (variableNode != null && variableNode.getChildCount() > 0) {
            Enumeration enumeration = variableNode.children();
            while (enumeration.hasMoreElements()) {
                VariableNode variableNode2 = (VariableNode)enumeration.nextElement();
                TreePath treePath2 = new TreePath(variableNode2.getPath());
                DebugPanel.getAllExpandedPaths(jTree, treePath2, vector);
            }
        }
    }

    private static void setExpandedPaths(JTree jTree, Vector<TreePath> vector) {
        for (TreePath treePath : vector) {
            if (jTree.isExpanded(treePath)) continue;
            jTree.expandPath(treePath);
        }
    }

    public void setThreads(ThreadObject[] threadObjectArray, ThreadObject threadObject) {
        if (threadObject != null) {
            this.threadModel.setCurrThread(threadObject.getName());
        } else {
            this.threadModel.setCurrThread("");
        }
        this.threadModel.setItems(threadObjectArray);
        this.threadTable.reload();
    }

    public void setMemory(long l2, long l3) {
        new IsguiWorker(false, () -> {
            if (l2 > 0L) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>Total memory: ");
                long l4 = l2 - l3;
                long l5 = l2 / 1000000L;
                stringBuffer.append(l5);
                stringBuffer.append(".");
                stringBuffer.append(l2 % 1000000L / 1000L);
                stringBuffer.append("Mb<br>");
                stringBuffer.append("Used memory: ");
                long l6 = l4 / 1000000L;
                stringBuffer.append(l6);
                stringBuffer.append(".");
                stringBuffer.append(l4 % 1000000L / 1000L);
                stringBuffer.append("Mb<br>");
                stringBuffer.append("Free memory: ");
                long l7 = l3 / 1000000L;
                stringBuffer.append(l7);
                stringBuffer.append(".");
                stringBuffer.append(l3 % 1000000L / 1000L);
                stringBuffer.append("Mb<br>");
                stringBuffer.append("Click to force garbage collector<html>");
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(l6);
                stringBuffer2.append(".");
                stringBuffer2.append(l4 % 1000000L / 1000L);
                stringBuffer2.append("/");
                stringBuffer2.append(l5);
                stringBuffer2.append(".");
                stringBuffer2.append(l2 % 1000000L / 1000L);
                stringBuffer2.append("Mb");
                this.memoryView.setString(stringBuffer2.toString());
                this.memoryView.setMaximum((int)l2);
                this.memoryView.setValue((int)l4);
                this.memoryView.setToolTipText(stringBuffer.toString());
            } else {
                this.memoryView.setValue(0);
                this.memoryView.setMaximum(1);
                this.memoryView.setString("");
                this.memoryView.setToolTipText("Click to force garbage collector");
            }
        }).start();
    }

    public void setInitFocus() {
        GraphUtilities.setFirstFocusedComponent(this.lineCommand);
    }

    public String menuBPintoCMD(int n2) {
        return "\"" + this.tFileObj.tf.getFilename() + "\"";
    }

    public void setVariableHintDelay(int n2) {
        this.graphDebug.dataSettingsChanged = true;
        this.tipAction.enabled = n2 > 0;
        if (this.tipAction.enabled) {
            this.tipTimer.setInitialDelay(n2);
            this.tipTimer.restart();
        }
    }

    public void setVariableHandMouseDelay(int n2) {
        this.handMouseAction.enabled = n2 > 0;
        if (this.handMouseAction.enabled) {
            this.handMouseTimer.setInitialDelay(n2);
            this.handMouseTimer.restart();
        }
    }

    public void hideTipPopup() {
        if (this.tipPopup != null) {
            this.tipPopup.hide();
            this.tipPopup = null;
        }
    }

    protected void setLineCommandText(String string) {
        this.lineCommand.setText(string);
    }

    protected void setAutostepDelay(double d2) {
        this.autoStepDelay.setValue(new Double(d2));
    }

    protected double getAutostepDelay() {
        return (Double)this.autoStepDelay.getValue();
    }

    protected void setJumpCommandEnabled(boolean bl) {
        this.btnJump.setEnabled(bl);
        this.btnJumpOutPar.setEnabled(bl);
        this.btnJumpOutProg.setEnabled(bl);
        this.btnJumpNext.setEnabled(bl);
    }

    protected ActionListener getThreadActionListener() {
        return this.threadActionListener;
    }

    protected String getHighlightedVariable(boolean bl) {
        return bl || this.highlightVarType == HighlightVarType.HIGHLIGHT ? this.highlightedVar : null;
    }

    protected String getHighlightedVariable() {
        return this.getHighlightedVariable(false);
    }

    private void jumpToSelectedLine() {
        int n2 = this.getSelectedLine();
        if (n2 >= 0) {
            CobolRef cobolRef = this.tFileObj.tf.getBPArgs(this.getListingline(n2));
            this.graphDebug.setTextCommand("jump " + cobolRef.lineNo() + " \"" + cobolRef.filename() + "\" " + "-fi" + " " + cobolRef.getFileIndex());
        }
    }

    protected void saveWindowLayout() {
        Settings.setMainSplitPaneDividerLocation(this.mainSplitPane.getDividerLocation());
        Settings.setOutputSplitPaneDividerLocation(this.bottomSplitPane.getDividerLocation());
        this.topSplitPaneDividerLocation = this.topSplitPane.getDividerLocation();
        this.varSplitPaneDividerLocation = this.varSplitPane.getDividerLocation();
        Settings.setSourceSplitPaneDividerLocation(this.topSplitPaneDividerLocation);
        Settings.setVariableSplitPaneDividerLocation(this.varSplitPaneDividerLocation);
        Settings.setThreadTableColumnsWidths(this.threadTable.getColumnModel().getColumn(1).getWidth(), this.threadTable.getColumnModel().getColumn(2).getWidth(), this.threadTable.getColumnModel().getColumn(3).getWidth());
        Settings.setMonitorTableColumnsWidths(this.monitorTable.getColumnModel().getColumn(1).getWidth(), this.monitorTable.getColumnModel().getColumn(2).getWidth());
        Settings.setCallStackTableColumnsWidths(this.callStackTable.getColumnModel().getColumn(0).getWidth(), this.callStackTable.getColumnModel().getColumn(1).getWidth(), this.callStackTable.getColumnModel().getColumn(2).getWidth());
    }

    protected void setLastCommand(String string) {
        if (this.commandHistoryModel.size() == 50) {
            this.commandHistoryModel.remove(0);
        }
        this.commandHistoryModel.addElement(string);
        this.commandHistory.ensureIndexIsVisible(this.commandHistoryModel.size() - 1);
        this.clearHistoryItem.setEnabled(true);
        this.clearHistoryBtn.setEnabled(true);
    }

    private void clearCommandHistory() {
        this.graphDebug.clearCommandHistory();
        this.commandHistoryModel.clear();
        this.clearHistoryItem.setEnabled(false);
        this.clearHistoryBtn.setEnabled(false);
    }

    private int getCurrListingLine() {
        return this.previewModel != null && this.currLine >= 0 && this.currLine < this.previewModel.getSize() ? this.previewModel.getLineAt((int)this.currLine).listingLine : -1;
    }

    private void setCurrListingLine(int n2) {
        this.currLine = Math.max(0, this.getLineIndex(n2, false));
    }

    private int getSelListingLine() {
        return this.previewModel != null && this.selLine >= 0 && this.selLine < this.previewModel.getSize() ? this.previewModel.getLineAt((int)this.selLine).listingLine : -1;
    }

    private void setSelListingLine(int n2) {
        this.selLine = Math.max(0, this.getLineIndex(n2, false));
    }

    public void expandCopy(int n2) {
        if (this.previewModel == null || n2 >= this.previewModel.getSize()) {
            return;
        }
        int n3 = this.getCurrListingLine();
        int n4 = this.getSelListingLine();
        this.previewModel.expandCopy(this.previewModel.getLineAt(n2), n2);
        if (n3 >= 0) {
            this.setCurrListingLine(n3);
        }
        if (n4 >= 0) {
            this.setSelListingLine(n4);
        }
        this.startDragLine = -1;
        this.endDragLine = -1;
    }

    public void expandAllCopies() {
        if (this.previewModel == null) {
            return;
        }
        int n2 = this.getCurrListingLine();
        int n3 = this.getSelListingLine();
        this.previewModel.expandAllCopies();
        if (n2 >= 0) {
            this.setCurrListingLine(n2);
        }
        if (n3 >= 0) {
            this.setSelListingLine(n3);
        }
        this.startDragLine = -1;
        this.endDragLine = -1;
    }

    public void collapseCopy(int n2) {
        if (this.previewModel == null || n2 >= this.previewModel.getSize()) {
            return;
        }
        int n3 = this.getCurrListingLine();
        int n4 = this.getSelListingLine();
        this.previewModel.collapseCopy(this.previewModel.getLineAt(n2), this.getFile(), n2);
        if (n3 >= 0) {
            this.setCurrListingLine(n3);
        }
        if (n4 >= 0) {
            this.setSelListingLine(n4);
        }
        this.startDragLine = -1;
        this.endDragLine = -1;
    }

    public void collapseAllCopies() {
        if (this.previewModel == null) {
            return;
        }
        int n2 = this.getCurrListingLine();
        int n3 = this.getSelListingLine();
        this.previewModel.collapseAllCopies(this.getFile());
        if (n2 >= 0) {
            this.setCurrListingLine(n2);
        }
        if (n3 >= 0) {
            this.setSelListingLine(n3);
        }
        this.startDragLine = -1;
        this.endDragLine = -1;
    }

    int getListingline(int n2) {
        return this.previewModel != null && n2 < this.previewModel.getSize() ? this.previewModel.getLineAt((int)n2).listingLine : -1;
    }

    int getLineIndex(int n2, boolean bl) {
        if (this.previewModel == null) {
            return -1;
        }
        int n3 = this.getCurrListingLine();
        int n4 = this.getSelListingLine();
        int n5 = this.previewModel.getSize();
        int n6 = this.previewModel.getLineIndex(n2, bl);
        if (n5 != this.previewModel.getSize()) {
            if (n3 >= 0) {
                this.setCurrListingLine(n3);
            }
            if (n4 >= 0) {
                this.setSelListingLine(n4);
            }
            this.startDragLine = -1;
            this.endDragLine = -1;
        }
        return n6;
    }

    private String getRealPath(String string) {
        return this.graphDebug.getInvoker().getRealPath(string);
    }

    private static KeyStroke getKeyStroke(JMenuItem jMenuItem, String string) {
        String string2 = Settings.getShortcut(string);
        int[] nArray = Settings.getShortcutParams(string2);
        return KeyStroke.getKeyStroke(nArray[1], nArray[0]);
    }

    void setAccelerators() {
        this.currLineItem.setAccelerator(DebugPanel.getKeyStroke(this.currLineItem, "graphdebugger.shortcut.curr_line"));
        this.gotoItem.setAccelerator(DebugPanel.getKeyStroke(this.gotoItem, "graphdebugger.shortcut.goto"));
        this.contItem.setAccelerator(DebugPanel.getKeyStroke(this.contItem, "graphdebugger.shortcut.continue"));
        this.stepIntoItem.setAccelerator(DebugPanel.getKeyStroke(this.stepIntoItem, "graphdebugger.shortcut.step"));
        this.stepOverItem.setAccelerator(DebugPanel.getKeyStroke(this.stepOverItem, "graphdebugger.shortcut.next"));
        this.outParItem.setAccelerator(DebugPanel.getKeyStroke(this.outParItem, "graphdebugger.shortcut.outpar"));
        this.outProgItem.setAccelerator(DebugPanel.getKeyStroke(this.outProgItem, "graphdebugger.shortcut.outprog"));
        this.runToItem.setAccelerator(DebugPanel.getKeyStroke(this.runToItem, "graphdebugger.shortcut.toline"));
        this.runToNextPgmItem.setAccelerator(DebugPanel.getKeyStroke(this.runToNextPgmItem, "graphdebugger.shortcut.prog"));
        this.toggleBrItem.setAccelerator(DebugPanel.getKeyStroke(this.toggleBrItem, "graphdebugger.shortcut.togglebreak"));
        this.displayOnLineItem.setAccelerator(DebugPanel.getKeyStroke(this.displayOnLineItem, "graphdebugger.shortcut.displayonselline"));
        this.quickWatchItem.setAccelerator(DebugPanel.getKeyStroke(this.quickWatchItem, "graphdebugger.shortcut.quickwatch"));
        this.refreshItem.setAccelerator(DebugPanel.getKeyStroke(this.refreshItem, "graphdebugger.shortcut.refreshvararea"));
        this.btnFind.setToolTipText("Find..." + DebugPanel.getShortcutText("graphdebugger.shortcut.find"));
        this.btnGotoCurrLine.setToolTipText("Go to current line" + DebugPanel.getShortcutText("graphdebugger.shortcut.curr_line"));
        this.btnRun.setToolTipText(this.graphDebug.isRemote() ? "Connect" : "Run" + DebugPanel.getShortcutText("graphdebugger.shortcut.run"));
        this.btnStop.setToolTipText(this.graphDebug.isRemote() ? "Disconnect" : "Finish session" + DebugPanel.getShortcutText("graphdebugger.shortcut.quit"));
        this.btnContinue.setToolTipText("Continue" + DebugPanel.getShortcutText("graphdebugger.shortcut.continue"));
        this.btnStepInto.setToolTipText("Step into" + DebugPanel.getShortcutText("graphdebugger.shortcut.step"));
        this.btnNext.setToolTipText("Step over" + DebugPanel.getShortcutText("graphdebugger.shortcut.next"));
        this.btnOutPar.setToolTipText("Step out paragraph" + DebugPanel.getShortcutText("graphdebugger.shortcut.outpar"));
        this.btnOutProg.setToolTipText("Step out program" + DebugPanel.getShortcutText("graphdebugger.shortcut.outprog"));
        this.btnStepTo.setToolTipText("Run to selected line" + DebugPanel.getShortcutText("graphdebugger.shortcut.toline"));
        this.btnStepToPgm.setToolTipText("Run to next program" + DebugPanel.getShortcutText("graphdebugger.shortcut.prog"));
        this.btnJump.setToolTipText("Jump to selected line" + DebugPanel.getShortcutText("graphdebugger.shortcut.jumptoline"));
        this.btnJumpNext.setToolTipText("Jump next statement" + DebugPanel.getShortcutText("graphdebugger.shortcut.jumpnext"));
        this.btnJumpOutPar.setToolTipText("Jump out paragraph" + DebugPanel.getShortcutText("graphdebugger.shortcut.jumpoutpar"));
        this.btnJumpOutProg.setToolTipText("Jump out program" + DebugPanel.getShortcutText("graphdebugger.shortcut.jumpoutprog"));
        if (this.btnAutoStep.isSelected()) {
            this.btnAutoStep.setToolTipText("Stop autostep" + DebugPanel.getShortcutText("graphdebugger.shortcut.stoff"));
        } else {
            this.btnAutoStep.setToolTipText("Start autostep" + DebugPanel.getShortcutText("graphdebugger.shortcut.ston"));
        }
    }

    private static String getShortcutText(String string) {
        String string2 = Settings.getShortcut(string);
        int[] nArray = Settings.getShortcutParams(string2);
        String string3 = KeyEvent.getKeyModifiersText(nArray[0]);
        String string4 = KeyEvent.getKeyText(nArray[1]);
        String string5 = string3.length() > 0 ? string3 + "-" + string4 : string4;
        return " (" + string5 + ")";
    }

    public GraphDebugger getGraphDebugger() {
        return this.graphDebug;
    }

    private int getSourceFormat() {
        if (this.sourceFormat < 0) {
            int n2 = Settings.getSourceFormat();
            if (n2 == 0 && this.tFileObj != null) {
                if (this.tFileObj.tf.isFreeFormat()) {
                    n2 = 3;
                } else if (this.tFileObj.ldInfo != null) {
                    n2 = this.tFileObj.ldInfo.getFormat();
                }
            }
            this.sourceFormat = n2;
        }
        return this.sourceFormat;
    }

    String getSelectedModule() {
        String string = null;
        if (this.selParObj != null) {
            string = this.selParObj.getProgName();
            if (this.selParObj.getMethodName() != null) {
                string = string + ":>" + this.selParObj.getMethodName();
            }
        }
        return string;
    }

    String getCurrentModule() {
        String string = null;
        if (this.callStackModel.size() > 0) {
            ParagraphObject paragraphObject = (ParagraphObject)this.callStackModel.elementAt(this.callStackModel.size() - 1);
            string = paragraphObject.getProgName();
            if (paragraphObject.getMethodName() != null) {
                string = string + ":>" + paragraphObject.getMethodName();
            }
        }
        return string;
    }

    private static boolean isLink(HighlightVarType highlightVarType) {
        return highlightVarType == HighlightVarType.LINK || highlightVarType == HighlightVarType.HIGHLIGHT_LINK;
    }

    static /* synthetic */ int access$1700(DebugPanel debugPanel, String string) {
        return debugPanel.getAnsiCommentColumn(string);
    }

    static /* synthetic */ Color access$1800() {
        return bpColBackground;
    }

    static /* synthetic */ Image access$1900() {
        return collapseCopyImage;
    }

    static /* synthetic */ Image access$2000() {
        return expandCopyImage;
    }

    static /* synthetic */ Image access$2200() {
        return currlineImage;
    }

    static /* synthetic */ Image access$2300() {
        return breakpointImage;
    }

    static /* synthetic */ Image access$2400() {
        return disbreakpointImage;
    }

    static /* synthetic */ Color access$2500() {
        return lineNumberBackground;
    }

    static /* synthetic */ Color access$2600() {
        return lineNumberForeground;
    }

    static /* synthetic */ int access$2700(DebugPanel debugPanel) {
        return debugPanel.getSourceFormat();
    }

    static /* synthetic */ Color access$3000() {
        return commentForeground;
    }

    static /* synthetic */ Color access$3100() {
        return levnumForeground;
    }

    static /* synthetic */ Color access$3200() {
        return numberForeground;
    }

    static /* synthetic */ Color access$3300() {
        return stringForeground;
    }

    static /* synthetic */ Color access$3400() {
        return figconsForeground;
    }

    static /* synthetic */ boolean access$3500(DebugPanel debugPanel, Token token, int n2, int n3) {
        return debugPanel.isComment(token, n2, n3);
    }

    static {
        int n2;
        BUSY_CURSOR = new Cursor(3);
        HAND_CURSOR = new Cursor(12);
        DEF_CURSOR = new Cursor(0);
        BTN_SIZE = new Dimension(25, 25);
        statements = new HashSet();
        keywords = new HashSet();
        guiwords = new HashSet();
        for (n2 = 0; n2 < CobolToken.tokDesc.length; ++n2) {
            if (CobolToken.isStat[n2]) {
                statements.add(CobolToken.tokDesc[n2]);
                continue;
            }
            keywords.add(CobolToken.tokDesc[n2]);
        }
        statements.add("::");
        statements.add(":>");
        for (n2 = 0; n2 < GuiWords.guiWords.length; ++n2) {
            guiwords.add(GuiWords.guiWords[n2]);
        }
        previewFont = Settings.getFont("Source code");
        previewLinkFont = previewFont.deriveFont(DebugPanel.getUnderlineAttrs());
        currentFontSize = previewFont.getSize();
        sourceBackground = Settings.getBackground("Source code");
        sourceForeground = Settings.getForeground("Source code");
        highBackground = Settings.getBackground("Highlighted by search");
        highForeground = Settings.getForeground("Highlighted by search");
        selBackground = Settings.getBackground("Source code (selected)");
        commentForeground = Settings.getForeground("Comments");
        keywordForeground = Settings.getForeground("Keywords");
        stringForeground = Settings.getForeground("String literals");
        numberForeground = Settings.getForeground("Numeric literals");
        stmtForeground = Settings.getForeground("Statements");
        levnumForeground = Settings.getForeground("Level numbers");
        figconsForeground = Settings.getForeground("Figurative constants");
        bpLineBackground = Settings.getBackground("Breakpoint line");
        copySourcePatternColors = DebugPanel.loadCopySourcePatternColors(Settings.getCopySourcePattern());
        lineNumberBackground = Settings.getBackground("Line number column");
        lineNumberForeground = Settings.getForeground("Line number column");
        currLineBackground = Settings.getBackground("Current line");
        bpColBackground = Settings.getBackground("Breakpoint column");
        tipFont = Settings.getFont("Variable hint");
        tipBackground = Settings.getBackground("Variable hint");
        tipForeground = Settings.getForeground("Variable hint");
        perfStackFont = Settings.getFont(PERF_STACK_TITLE);
        perfStackBackground = Settings.getBackground(PERF_STACK_TITLE);
        perfStackForeground = Settings.getForeground(PERF_STACK_TITLE);
        perfStackSelBackground = Settings.getBackground("Perform stack (selected)");
        perfStackSelForeground = Settings.getForeground("Perform stack (selected)");
        bpListFont = Settings.getFont("Breakpoint list");
        bpListBackground = Settings.getBackground("Breakpoint list");
        bpListForeground = Settings.getForeground("Breakpoint list");
        bpListSelBackground = Settings.getBackground("Breakpoint list (selected)");
        bpListSelForeground = Settings.getForeground("Breakpoint list (selected)");
        monListFont = Settings.getFont("Monitor list");
        monListBackground = Settings.getBackground("Monitor list");
        monListForeground = Settings.getForeground("Monitor list");
        monListSelBackground = Settings.getBackground("Monitor list (selected)");
        monListSelForeground = Settings.getForeground("Monitor list (selected)");
        cmdHistoryFont = Settings.getFont(COMMAND_HISTORY_TITLE);
        cmdHistoryBackground = Settings.getBackground(COMMAND_HISTORY_TITLE);
        cmdHistoryForeground = Settings.getForeground(COMMAND_HISTORY_TITLE);
        cmdHistorySelBackground = Settings.getBackground("Command history (selected)");
        cmdHistorySelForeground = Settings.getForeground("Command history (selected)");
        consoleFont = Settings.getFont(CONSOLE_TITLE);
        consoleBackground = Settings.getBackground(CONSOLE_TITLE);
        consoleForeground = Settings.getForeground(CONSOLE_TITLE);
        consoleStdErrForeground = Settings.getForeground("Console StdErr");
        consoleSelBackground = Settings.getBackground("Console (selected)");
        consoleSelForeground = Settings.getForeground("Console (selected)");
        threadListFont = Settings.getFont("Thread list");
        threadListBackground = Settings.getBackground("Thread list");
        threadListForeground = Settings.getForeground("Thread list");
        disTreeFont = Settings.getFont("Display tree area");
        disTreeBackground = Settings.getBackground("Display tree area");
        disTreeForeground = Settings.getForeground("Display tree area");
        disTreeSelBackground = Settings.getBackground("Display tree area (selected)");
        disTreeSelForeground = Settings.getForeground("Display tree area (selected)");
        outputFont = Settings.getFont("Output area");
        outputBackground = Settings.getBackground("Output area");
        outputForeground = Settings.getForeground("Output area");
        outputSelBackground = Settings.getBackground("Output area (selected)");
        outputSelForeground = Settings.getForeground("Output area (selected)");
        inputFont = Settings.getFont("Line command");
        inputBackground = Settings.getBackground("Line command");
        inputForeground = Settings.getForeground("Line command");
        inputSelBackground = Settings.getBackground("Line command (selected)");
        inputSelForeground = Settings.getForeground("Line command (selected)");
    }

    private class TipAction
    extends MyAction {
        final int maxCols = 120;
        final int maxRows = 10;
        int numRows;

        TipAction() {
            this.maxCols = 120;
            this.maxRows = 10;
            this.enabled = Settings.isVariableHintEnabled();
        }

        private String split(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            this.numRows = 1;
            while (120 < string.length()) {
                stringBuffer.append(string.substring(0, 120) + GraphDebugger.eol);
                string = string.substring(120);
                ++this.numRows;
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            if (!this.check()) {
                return;
            }
            String string = null;
            if (this.mousePos.x < 20) {
                int n2 = DebugPanel.this.previewArea.locationToIndex(this.mousePos);
                if (n2 < DebugPanel.this.previewModel.getSize() && ((Line)(object2 = DebugPanel.this.previewModel.getLineAt(n2))).copyStmt()) {
                    object = DebugPanel.this.getFile().getFilenames()[((Line)object2).copyFileIndex].getOrigName();
                    String string2 = DebugPanel.this.graphDebug.getInvoker().getFileLoader().getAbsolutePath((String)object);
                    string = (((Line)object2).copyExpanded ? "Collapse" : "Expand") + " copy '" + string2 + "'";
                }
            } else if (this.mousePos.x < 20 + numberColumnLen) {
                int n3 = DebugPanel.this.previewArea.locationToIndex(this.mousePos);
                if (n3 < DebugPanel.this.previewModel.getSize()) {
                    object2 = DebugPanel.this.previewModel.getLineAt(n3);
                    object = ((DebugPanel)DebugPanel.this).tFileObj.tf.getBPArgs(((Line)object2).listingLine);
                    string = object != null ? "Line " + ((CobolRef)object).lineNo() + " of \"" + ((CobolRef)object).filename() + "\"" : "Line " + ((Line)object2).cobolLine;
                }
            } else {
                MyVarName myVarName = DebugPanel.this.getVarName(this.mousePos);
                if (!DebugPanel.this.graphDebug.isRunning() || DebugPanel.this.graphDebug.isProcessing() || DebugPanel.this.listPopup.isVisible()) {
                    return;
                }
                if (myVarName != null && (object = DebugPanel.this.displayVar((String)(object2 = myVarName.varName.trim()), myVarName.lstLine)) != null && ((DebugResponse)object).getReturnCode() == 0) {
                    boolean bl;
                    switch (((DebugResponse)object).getVarType()) {
                        case 12: 
                        case 13: 
                        case 15: {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    String string3 = bl ? ((DebugResponse)object).getVarName() + ": offset = " + ((DebugResponse)object).getVarOffset() + ", length = " + ((DebugResponse)object).getVarLength() + ", value = '" + ((DebugResponse)object).getVarValue() + "'" : ((DebugResponse)object).getVarName() + ": " + ((DebugResponse)object).getVarValue();
                    string = this.split(string3);
                }
            }
            if (string != null) {
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setFont(tipFont);
                jTextArea.setRows(Math.min(10, this.numRows));
                jTextArea.setEditable(false);
                jTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
                jTextArea.setBackground(tipBackground);
                jTextArea.setForeground(tipForeground);
                object2 = DebugPanel.this.previewArea.getLocationOnScreen();
                object = this.numRows > 10 ? new JScrollPane(jTextArea) : jTextArea;
                DebugPanel.this.lastMouseEventArea = new Rectangle(this.mousePos.x - 5, this.mousePos.y - 5, 11, 11);
                DebugPanel.this.tipPopup = PopupFactory.getSharedInstance().getPopup(null, (Component)object, this.mousePos.x + ((Point)object2).x + 5, this.mousePos.y + ((Point)object2).y + 22);
                jTextArea.setCaretPosition(0);
                DebugPanel.this.tipPopup.show();
            }
        }
    }

    private class HandMouseAction
    extends MyAction {
        HandMouseAction() {
            this.enabled = Settings.isVariableHandMouseEnabled();
        }

        private boolean isFunction(String string) {
            int n2 = string.indexOf(40);
            return Function.is(n2 > 0 ? string.substring(0, n2) : string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MyVarName myVarName;
            if (!this.check()) {
                return;
            }
            if (this.mousePos.x >= 20 + numberColumnLen && (myVarName = DebugPanel.this.getVarName(this.mousePos)) != null) {
                String string = myVarName.varName.toUpperCase();
                if (!(statements.contains(string) || keywords.contains(string) || guiwords.contains(string) || this.isFunction(string))) {
                    int n2 = DebugPanel.this.previewArea.locationToIndex(this.mousePos);
                    String string2 = ((DebugPanel)DebugPanel.this).previewModel.getLineAt((int)n2).lineStr;
                    int n3 = GraphUtilities.pixelsToOffset(previewMetrics, string2, this.mousePos.x - 20 - numberColumnLen);
                    HighlightVarType highlightVarType = myVarName.origText.equals(DebugPanel.this.highlightedVar) || myVarName.origText.equals(DebugPanel.this.highlightedWord) ? HighlightVarType.HIGHLIGHT_LINK : HighlightVarType.LINK;
                    DebugPanel.this.setHighlightedVar(myVarName.origText, highlightVarType, n2, n3);
                    Point point = DebugPanel.this.previewArea.indexToLocation(n2);
                    int n4 = point.x + 20 + numberColumnLen;
                    if (myVarName.offs > 0) {
                        n4 += previewMetrics.stringWidth(string2.substring(0, myVarName.offs));
                    }
                    DebugPanel.this.lastLinkArea = new Rectangle(n4, point.y, previewMetrics.stringWidth(myVarName.origText), previewMetrics.getHeight());
                }
            }
        }
    }

    private abstract class MyAction
    implements ActionListener {
        Point mousePos;
        boolean enabled = true;

        private MyAction() {
        }

        void setMousePos(Point point) {
            this.mousePos = point;
        }

        boolean check() {
            return this.enabled && this.mousePos != null && DebugPanel.this.previewModel != null;
        }
    }

    private class MyAppender
    implements Appender {
        final boolean stderr;

        MyAppender(boolean bl) {
            this.stderr = bl;
        }

        @Override
        public void appendLine(String string) {
            StyledDocument styledDocument = DebugPanel.this.console.getStyledDocument();
            Style style = this.stderr ? styledDocument.getStyle("stderr") : null;
            try {
                styledDocument.insertString(styledDocument.getLength(), string + "\n", style);
                DebugPanel.this.console.setCaretPosition(styledDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static class DebugListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 123L;
        private List delegate;
        private Map collapsedCopyLines;

        private DebugListModel() {
        }

        @Override
        public Object getElementAt(int n2) {
            return n2 < this.delegate.size() ? this.delegate.get(n2) : null;
        }

        Line getLineAt(int n2) {
            return (Line)this.getElementAt(n2);
        }

        @Override
        public int getSize() {
            return this.delegate.size();
        }

        void allocate(int n2) {
            this.delegate = new ArrayList(n2);
            this.collapsedCopyLines = new HashMap();
        }

        void add(Line line) {
            this.delegate.add(line);
        }

        void expandCopy(int n2) {
            for (Line line : this.collapsedCopyLines.keySet()) {
                List list = (List)this.collapsedCopyLines.get(line);
                Line line2 = (Line)list.get(0);
                Line line3 = (Line)list.get(list.size() - 1);
                if (n2 < line2.listingLine || n2 > line3.listingLine) continue;
                int n3 = this.getLineIndex0(line.listingLine);
                this.expandCopy(line, n3);
                break;
            }
        }

        void expandCopy(Line line, int n2) {
            int n3 = n2 + 1;
            List list = (List)this.collapsedCopyLines.remove(line);
            if (list != null) {
                if (n3 < this.getSize()) {
                    this.delegate.addAll(n3, list);
                } else {
                    this.delegate.addAll(list);
                }
                this.fireIntervalAdded(this, n3, list.size() - 1);
            }
            line.copyExpanded = true;
        }

        void expandAllCopies() {
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                Line line = this.getLineAt(i2);
                if (!line.copyStmt() || line.copyExpanded) continue;
                this.expandCopy(line, i2);
            }
        }

        void collapseCopy(Line line, TextFile textFile, int n2) {
            int n3;
            CobolRef cobolRef;
            int n4;
            short s2 = textFile.toCobolLine(line.listingLine).getFileIndex();
            for (n4 = n3 = n2 + 1; n4 < this.getSize() && (cobolRef = textFile.toCobolLine(this.getLineAt((int)n4).listingLine)).getFileIndex() > s2; ++n4) {
            }
            if (n4 > n3) {
                ArrayList arrayList = new ArrayList();
                int n5 = n4 - n3;
                for (int i2 = 0; i2 < n5; ++i2) {
                    arrayList.add(this.delegate.remove(n3));
                }
                this.fireIntervalRemoved(this, n3, n4 - 1);
                this.collapsedCopyLines.put(line, arrayList);
            }
            line.copyExpanded = false;
        }

        public void collapseAllCopies(TextFile textFile) {
            for (int i2 = 0; i2 < this.getSize(); ++i2) {
                Line line = this.getLineAt(i2);
                if (!line.copyStmt() || !line.copyExpanded) continue;
                this.collapseCopy(line, textFile, i2);
            }
        }

        int getLineIndex(int n2, boolean bl) {
            int n3 = this.getLineIndex0(n2);
            if (n3 >= 0 || !bl) {
                return n3;
            }
            this.expandCopy(n2);
            return this.getLineIndex0(n2);
        }

        private int getLineIndex0(int n2) {
            int n3 = 0;
            int n4 = this.getSize() - 1;
            if (n4 < 0) {
                return -1;
            }
            while (n3 <= n4) {
                int n5 = (n3 + n4) / 2;
                Line line = this.getLineAt(n5);
                if (line.listingLine == n2) {
                    return n5;
                }
                if (line.listingLine < n2) {
                    n3 = n5 + 1;
                    continue;
                }
                n4 = n5 - 1;
            }
            return -1;
        }
    }

    private class DebugListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 123L;
        private final int imageX = 5;
        private int index;
        private int prefHeight;
        private FontMetrics metrics;
        private int baseline;
        private int bpImageY = 3;
        private int clImageY = 3;
        private int expCollImageY = 3;
        private Line lineObj;

        public DebugListCellRenderer(FontMetrics fontMetrics) {
            this.setLayout(null);
            this.updateFontSettings(fontMetrics);
        }

        public void updateFontSettings(FontMetrics fontMetrics) {
            this.metrics = fontMetrics;
            this.baseline = fontMetrics.getAscent();
            this.prefHeight = fontMetrics.getHeight() + 2;
            this.bpImageY = Math.max((this.prefHeight - 9) / 2, 0);
            this.clImageY = Math.max((this.prefHeight - 12) / 2, 0);
            this.expCollImageY = Math.max((this.prefHeight - 16) / 2, 0);
        }

        private void drawHighlight(Graphics graphics) {
            boolean bl;
            boolean bl2;
            String string;
            if (this.lineObj == null) {
                return;
            }
            if (DebugPanel.this.highlightedWord == null && DebugPanel.this.highlightVarType != HighlightVarType.NONE) {
                string = DebugPanel.this.highlightedVar;
                bl2 = false;
                bl = false;
            } else {
                string = DebugPanel.this.highlightedWord;
                bl2 = DebugPanel.this.fparam == null || ((DebugPanel)DebugPanel.this).fparam.matchMinusUnderscore;
                bl = DebugPanel.this.fparam == null || ((DebugPanel)DebugPanel.this).fparam.matchCase;
            }
            boolean bl3 = DebugPanel.isLink(DebugPanel.this.highlightVarType);
            if ((this.index == DebugPanel.this.selLine || this.index == DebugPanel.this.highlightedVarLine && bl3) && string != null) {
                int n2;
                int n3;
                String string2 = this.lineObj.lineStr;
                if (!bl2) {
                    string = string.replaceAll("-", "_");
                    string2 = string2.replaceAll("-", "_");
                }
                if (!bl) {
                    string = string.toUpperCase();
                    string2 = string2.toUpperCase();
                }
                if ((n3 = string2.indexOf(string, Math.max(0, (n2 = bl3 ? DebugPanel.this.highlightedVarCol : DebugPanel.this.cursorColumn) - string.length()))) >= 0 && n3 <= n2) {
                    int n4 = numberColumnLen + 20 + this.metrics.stringWidth(this.lineObj.lineStr.substring(0, n3));
                    String string3 = this.lineObj.lineStr.substring(n3, n3 + string.length());
                    switch (DebugPanel.this.highlightVarType) {
                        case LINK: {
                            graphics.setColor(Color.blue);
                            graphics.setFont(previewLinkFont);
                            break;
                        }
                        case HIGHLIGHT_LINK: {
                            graphics.setFont(previewLinkFont);
                        }
                        default: {
                            graphics.setColor(highBackground);
                            graphics.fillRect(n4, 0, this.metrics.stringWidth(string3), this.prefHeight);
                            graphics.setColor(highForeground);
                        }
                    }
                    graphics.drawString(string3, n4, this.baseline);
                }
            }
        }

        private boolean isFirstToken(Token token, int n2) {
            return (n2 == 1 || n2 == 5) && token.getOffset() < 7;
        }

        String getWordUp(Token token) {
            String string = token.getWord();
            switch (token.getToknum()) {
                case 10001: 
                case 10024: {
                    if (string.length() <= 1) break;
                    switch (string.charAt(0)) {
                        case 'H': 
                        case 'R': 
                        case 'X': {
                            return string.substring(1);
                        }
                        case 'N': {
                            switch (string.charAt(1)) {
                                case 'X': {
                                    return string.substring(2);
                                }
                            }
                            return string.substring(1);
                        }
                    }
                }
            }
            return string;
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.lineObj == null) {
                return;
            }
            this.paint(graphics, this.lineObj.lineStr);
        }

        /*
         * Unable to fully structure code
         */
        public void paint(Graphics var1_1, String var2_2) {
            var3_3 = Toolkit.getDefaultToolkit();
            var4_4 = (Map)var3_3.getDesktopProperty("awt.font.desktophints");
            if (var4_4 != null) {
                ((Graphics2D)var1_1).addRenderingHints(var4_4);
            }
            var5_5 = DebugPanel.access$1700(DebugPanel.this, var2_2);
            var6_6 = var5_5 - 1;
            var7_7 = DebugPanel.access$1300() + 20;
            var1_1.setColor(DebugPanel.access$1800());
            var1_1.fillRect(0, 0, 20, this.prefHeight);
            if (this.lineObj.copyStmt()) {
                var1_1.drawImage(this.lineObj.copyExpanded != false ? DebugPanel.access$1900() : DebugPanel.access$2000(), 5, this.expCollImageY, null);
            } else {
                if (this.index == DebugPanel.access$2100(DebugPanel.this)) {
                    var1_1.drawImage(DebugPanel.access$2200(), 5, this.clImageY, null);
                }
                if ((var8_8 = DebugPanel.this.getBreakpoint(this.index)) != null) {
                    var1_1.drawImage(var8_8.isEnabled() != false ? DebugPanel.access$2300() : DebugPanel.access$2400(), 5, this.bpImageY, null);
                }
            }
            var1_1.setColor(DebugPanel.access$2500());
            var1_1.fillRect(20, 0, DebugPanel.access$1300(), this.prefHeight);
            var1_1.setColor(DebugPanel.access$2600());
            var9_9 = "" + this.lineObj.cobolLine;
            var1_1.drawString(var9_9, var7_7 - 2 - this.metrics.stringWidth(var9_9), this.baseline);
            var1_1.setColor(this.getBackground());
            var1_1.fillRect(var7_7, 0, DebugPanel.this.previewArea.getWidth() - var7_7, this.prefHeight);
            var10_10 = DebugPanel.access$2700(DebugPanel.this);
            var11_11 = false;
            var12_12 = true;
            var13_13 = PreProcessor.tokenizer(new StringBuffer(var2_2), '.', true, true, DebugPanel.access$2800(DebugPanel.this));
            var17_14 = 0;
            var18_15 = 0;
            var20_16 = var13_13.getFirstWithSep();
            while (var20_16 != null) {
                block34: {
                    block36: {
                        block35: {
                            var15_18 = this.getWordUp(var20_16);
                            var16_19 = var20_16.getOffset();
                            var19_20 = var17_14 - var16_19;
                            var17_14 = Math.min(this.lineObj.lineStr.length(), var16_19 + var15_18.length());
                            if (var19_20 >= 0) {
                                var18_15 = Math.min(var17_14, var16_19 + var19_20);
                                var14_17 = this.lineObj.lineStr.substring(var18_15, var17_14);
                            } else {
                                var18_15 = Math.min(var16_19, var16_19 + var19_20);
                                var14_17 = this.lineObj.lineStr.substring(var18_15, var16_19);
                                var1_1.setColor(DebugPanel.access$2900());
                                var1_1.drawString(var14_17, var7_7, this.baseline);
                                var7_7 += this.metrics.stringWidth(var14_17);
                                var14_17 = this.lineObj.lineStr.substring(var16_19, var17_14);
                            }
                            if (var14_17.length() == 0) break block34;
                            if (!var11_11) break block35;
                            var1_1.setColor(DebugPanel.access$3000());
                            break block36;
                        }
                        switch (var20_16.getToknum()) {
                            case 10016: 
                            case 10020: {
                                var21_21 = "*>";
                                if (var20_16.getWord().startsWith("*>")) ** GOTO lbl60
                                var21_21 = "|";
                                if (!var20_16.getWord().startsWith("|")) ** GOTO lbl71
lbl60:
                                // 2 sources

                                if ((var10_10 == 1 || var10_10 == 5) && (var21_21 == "*>" && var20_16.getOffset() < var6_6 || var21_21 == "|" && var20_16.getOffset() < var5_5) || var10_10 == 4 && (var21_21 == "*>" && var20_16.getOffset() < var6_6 && var20_16.getOffset() > 0 || var21_21 == "|" && var20_16.getOffset() < var5_5)) {
                                    var22_22 = var2_2.substring(0, var20_16.getOffset());
                                    for (var23_25 = 0; var23_25 < var21_21.length(); ++var23_25) {
                                        var22_22 = var22_22 + " ";
                                    }
                                    var22_22 = var22_22 + var20_16.getWord().substring(var21_21.length());
                                    this.paint(var1_1, var22_22);
                                    return;
                                }
                                var1_1.setColor(DebugPanel.access$3000());
                                var12_12 = this.isFirstToken(var20_16, var10_10);
                                break;
lbl71:
                                // 1 sources

                                if (var14_17.trim().length() > 0) {
                                    var12_12 = this.isFirstToken(var20_16, var10_10);
                                }
                                var1_1.setColor(DebugPanel.access$2900());
                                break;
                            }
                            case 10002: {
                                if (var12_12 && DebugPanel.isLevelNumber(var14_17)) {
                                    var1_1.setColor(DebugPanel.access$3100());
                                } else {
                                    var1_1.setColor(DebugPanel.access$3200());
                                }
                                var12_12 = this.isFirstToken(var20_16, var10_10);
                                break;
                            }
                            case 10017: {
                                var1_1.setColor(DebugPanel.access$3200());
                                var12_12 = this.isFirstToken(var20_16, var10_10);
                                break;
                            }
                            case 10001: 
                            case 10024: {
                                var1_1.setColor(DebugPanel.access$3300());
                                var12_12 = this.isFirstToken(var20_16, var10_10);
                                break;
                            }
                            case 576: 
                            case 577: 
                            case 601: 
                            case 660: 
                            case 661: 
                            case 736: 
                            case 737: 
                            case 822: 
                            case 824: 
                            case 825: {
                                var1_1.setColor(DebugPanel.access$3400());
                                var12_12 = this.isFirstToken(var20_16, var10_10);
                                break;
                            }
                            case 10005: {
                                if (var10_10 != 1 && var10_10 != 5) ** GOTO lbl100
                                var21_21 = "*>";
                                if (var20_16.getWord().startsWith("*>") && var20_16.getOffset() < var6_6) ** GOTO lbl105
                                var21_21 = "|";
                                if (var20_16.getWord().startsWith("|") && var20_16.getOffset() < var5_5) ** GOTO lbl105
lbl100:
                                // 2 sources

                                if (var10_10 != 4) ** GOTO lbl112
                                var21_21 = "*>";
                                if (var20_16.getWord().startsWith("*>") && var20_16.getOffset() < var6_6 && var20_16.getOffset() > 0) ** GOTO lbl105
                                var21_21 = "|";
                                if (!var20_16.getWord().startsWith("|") || var20_16.getOffset() >= var5_5) ** GOTO lbl112
lbl105:
                                // 4 sources

                                var22_23 = var2_2.substring(0, var20_16.getOffset());
                                for (var23_26 = 0; var23_26 < var21_21.length(); ++var23_26) {
                                    var22_23 = var22_23 + " ";
                                }
                                var22_23 = var22_23 + var20_16.getWord().substring(var21_21.length());
                                this.paint(var1_1, var22_23);
                                return;
lbl112:
                                // 2 sources

                                var1_1.setColor(DebugPanel.access$3000());
                                var11_11 = true;
                                break;
                            }
                            case 10003: {
                                if (var20_16.getWord().startsWith(">>")) {
                                    var22_24 = (var10_10 == 1 || var10_10 == 5) && var20_16.getOffset() < var6_6 || var10_10 == 4 && var20_16.getOffset() < var6_6 ? "  " : "*>";
                                    var23_27 = var2_2.substring(0, var20_16.getOffset()) + var22_24 + var2_2.substring(var20_16.getOffset() + 2);
                                    this.paint(var1_1, var23_27);
                                    return;
                                }
                                this.drawDefault(var1_1, var15_18);
                                var12_12 = this.isFirstToken(var20_16, var10_10);
                                break;
                            }
                            case 36: 
                            case 42: {
                                if (DebugPanel.access$3500(DebugPanel.this, var20_16, var10_10, var6_6)) {
                                    var1_1.setColor(DebugPanel.access$3000());
                                    var11_11 = true;
                                } else {
                                    var1_1.setColor(DebugPanel.access$2900());
                                }
                                var12_12 = this.isFirstToken(var20_16, var10_10);
                                break;
                            }
                            default: {
                                this.drawDefault(var1_1, var15_18);
                                var12_12 = this.isFirstToken(var20_16, var10_10);
                            }
                        }
                    }
                    var1_1.drawString(var14_17, var7_7, this.baseline);
                    var7_7 += this.metrics.stringWidth(var14_17);
                }
                var20_16 = var13_13.getNextWithSep();
            }
            if (var17_14 < this.lineObj.lineStr.length()) {
                var1_1.setColor(DebugPanel.access$2900());
                var1_1.drawString(this.lineObj.lineStr.substring(var17_14), var7_7, this.baseline);
            }
            this.drawHighlight(var1_1);
            this.drawCursor(var1_1);
        }

        private void drawDefault(Graphics graphics, String string) {
            if (!DebugPanel.this.nrw.contains(string)) {
                if (statements.contains(string)) {
                    graphics.setColor(stmtForeground);
                } else if (keywords.contains(string) || guiwords.contains(string)) {
                    graphics.setColor(keywordForeground);
                } else {
                    graphics.setColor(sourceForeground);
                }
            } else {
                graphics.setColor(sourceForeground);
            }
        }

        private void drawCursor(Graphics graphics) {
            if (this.index == DebugPanel.this.selLine) {
                graphics.setColor(this.getForeground());
                graphics.drawLine(DebugPanel.this.cursorX, 0, DebugPanel.this.cursorX, graphics.getClipBounds().height);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            this.lineObj = (Line)object;
            if (this.lineObj == null) {
                return this;
            }
            this.setForeground(sourceForeground);
            if (n2 == DebugPanel.this.currLine) {
                this.setBackground(currLineBackground);
            } else {
                Breakpoint breakpoint = DebugPanel.this.getBreakpoint(n2);
                if (breakpoint != null) {
                    if (breakpoint.isEnabled()) {
                        this.setBackground(bpLineBackground);
                    } else {
                        this.setBackground(bpLineBackground.darker());
                    }
                } else if (n2 == DebugPanel.this.selLine || n2 >= DebugPanel.this.startDragLine && n2 <= DebugPanel.this.endDragLine || n2 >= DebugPanel.this.endDragLine && n2 <= DebugPanel.this.startDragLine) {
                    this.setBackground(selBackground);
                } else if (this.lineObj.copyDeep > 0) {
                    int n3 = (this.lineObj.copyDeep - 1) % copySourcePatternColors.length;
                    this.setBackground(copySourcePatternColors[n3]);
                } else {
                    this.setBackground(sourceBackground);
                }
            }
            this.index = n2;
            return this;
        }
    }

    private static enum HighlightVarType {
        NONE,
        HIGHLIGHT,
        LINK,
        HIGHLIGHT_LINK;

    }

    private class DebugList
    extends JList {
        private static final long serialVersionUID = 123L;

        private DebugList() {
        }

        @Override
        public Dimension getPreferredSize() {
            if (preferredPreviewWidth > 0) {
                return new Dimension(preferredPreviewWidth, super.getPreferredSize().height);
            }
            return super.getPreferredSize();
        }

        public List getSelectedValuesList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (DebugPanel.this.previewModel == null) {
                return arrayList;
            }
            int n2 = DebugPanel.this.startDragLine;
            int n3 = DebugPanel.this.endDragLine;
            if (n2 < 0 || n3 < 0) {
                return arrayList;
            }
            if (n2 > n3) {
                n2 = DebugPanel.this.endDragLine;
                n3 = DebugPanel.this.startDragLine;
            }
            for (int i2 = n2; i2 <= n3; ++i2) {
                arrayList.add(((DebugPanel)DebugPanel.this).previewModel.getLineAt((int)i2).lineStr);
            }
            return arrayList;
        }
    }

    private static class ToggleImageButton
    extends JCheckBox
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        ActionListener listener;

        ToggleImageButton(String string, Image image, ActionListener actionListener, boolean bl) {
            super(new ImageIcon(image));
            this.setToolTipText(string);
            this.setSelected(bl);
            this.addActionListener(this);
            this.setFocusable(false);
            this.listener = actionListener;
        }

        @Override
        public void setSelected(boolean bl) {
            super.setSelected(bl);
            this.updateBorder();
        }

        void updateBorder() {
            if (this.isSelected()) {
                this.setBorder(BorderFactory.createLoweredBevelBorder());
                this.setBorderPainted(true);
            } else {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
                this.setBorderPainted(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.updateBorder();
            this.listener.actionPerformed(actionEvent);
        }
    }

    static class Line {
        final int cobolLine;
        final int listingLine;
        final String lineStr;
        final byte copyDeep;
        final short copyFileIndex;
        boolean copyExpanded = true;

        Line(int n2, int n3, String string, byte by, short s2) {
            this.cobolLine = n2;
            this.listingLine = n3;
            this.lineStr = string;
            this.copyDeep = by;
            this.copyFileIndex = s2;
        }

        boolean copyStmt() {
            return this.copyFileIndex > 0;
        }

        public String toString() {
            return this.lineStr;
        }
    }

    private static class NoInfoPanel
    extends JPanel {
        JLabel lbl;
        private static final long serialVersionUID = 123L;

        NoInfoPanel(Color color, Color color2, Font font) {
            super(new FlowLayout());
            this.setBackground(color);
            this.lbl = new JLabel("<no information>");
            this.lbl.setForeground(color2);
            this.add(this.lbl);
            this.lbl.setFont(font);
        }

        @Override
        public void setForeground(Color color) {
            if (this.lbl == null) {
                super.setForeground(color);
            } else {
                this.lbl.setForeground(color);
            }
        }

        @Override
        public void setFont(Font font) {
            if (this.lbl == null) {
                super.setFont(font);
            } else {
                this.lbl.setFont(font);
            }
        }
    }

    private static class TextFileObj {
        TextFile tf;
        JScrollPane sp;
        boolean listing;
        LocalDebugInfo ldInfo;

        private TextFileObj() {
        }
    }

    static class MyVarName {
        String varName;
        String origText;
        int lstLine = -1;
        int offs;

        MyVarName(String string, String string2) {
            this.varName = string;
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this.origText = string2;
        }
    }

    static class MyVariableModel
    extends VariableModel {
        public MyVariableModel(VariableNode variableNode, boolean bl) {
            super(variableNode, bl);
        }

        @Override
        public Object[] getChildren(Object object) {
            if (object == this.rootNode) {
                return ((VariableNode)object).getChildren().toArray();
            }
            return super.getChildren(object);
        }

        @Override
        public boolean isLeaf(Object object) {
            return ((VariableNode)object).isLeaf();
        }
    }
}

