/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.IDebugParagraphExtension;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public class DebugParagraph
implements DataExternalizable,
IDebugParagraphExtension,
Comparable<DebugParagraph> {
    private static final long serialVersionUID = 1000006L;
    private String paragraphName;
    private int lineNumber;
    private int fileIndex;
    private boolean isInDeclaratives;
    private int paragraphNumber;
    private boolean isSection;
    private String methodName;

    public DebugParagraph() {
    }

    public DebugParagraph(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            this.paragraphName = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                this.lineNumber = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    this.fileIndex = Integer.parseInt(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        this.isInDeclaratives = stringTokenizer.nextToken().equals("D");
                        if (stringTokenizer.hasMoreTokens()) {
                            this.paragraphNumber = Integer.parseInt(stringTokenizer.nextToken());
                        }
                    }
                }
            }
        }
    }

    public DebugParagraph(String string, int n2, int n3) {
        this.paragraphName = string;
        this.lineNumber = n2;
        this.fileIndex = n3;
    }

    public DebugParagraph(String string, int n2, int n3, boolean bl, int n4) {
        this(null, string, n2, n3, bl, n4, false);
    }

    public DebugParagraph(String string, String string2, int n2, int n3, boolean bl, int n4) {
        this(string, string2, n2, n3, bl, n4, false);
    }

    public DebugParagraph(String string, String string2, int n2, int n3, boolean bl, int n4, boolean bl2) {
        this.methodName = string;
        this.paragraphName = string2;
        this.lineNumber = n2;
        this.fileIndex = n3;
        this.isInDeclaratives = bl;
        this.paragraphNumber = n4;
        this.isSection = bl2;
    }

    @Override
    public String getParagraphName() {
        return this.paragraphName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    @Override
    public boolean isInDeclaratives() {
        return this.isInDeclaratives;
    }

    @Override
    public boolean isSection() {
        return this.isSection;
    }

    @Override
    public int getParagraphNumber() {
        return this.paragraphNumber;
    }

    @Override
    public int compareTo(DebugParagraph debugParagraph) {
        int n2 = 0;
        if (this.methodName != null) {
            n2 = this.methodName.compareTo(debugParagraph.methodName);
        }
        if (n2 == 0) {
            if (this.isInDeclaratives) {
                n2 = debugParagraph.isInDeclaratives ? 0 : -1;
            } else {
                int n3 = n2 = debugParagraph.isInDeclaratives ? 1 : 0;
            }
        }
        if (n2 == 0) {
            n2 = this.paragraphNumber - debugParagraph.paragraphNumber;
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.methodName != null) {
            String string = this.methodName;
            stringBuilder.append(string).append(".");
        }
        if (this.isInDeclaratives) {
            stringBuilder.append("decl$");
        }
        stringBuilder.append(this.paragraphName);
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.paragraphName, dataOutput);
        dataOutput.writeInt(this.lineNumber);
        dataOutput.writeInt(this.fileIndex);
        dataOutput.writeInt(this.paragraphNumber);
        dataOutput.writeBoolean(this.isInDeclaratives);
        dataOutput.writeBoolean(this.isSection);
        RtsUtil.writeUTFOptmz(this.methodName, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.paragraphName = RtsUtil.readUTFOptmz(dataInput);
        this.lineNumber = dataInput.readInt();
        this.fileIndex = dataInput.readInt();
        this.paragraphNumber = dataInput.readInt();
        this.isInDeclaratives = dataInput.readBoolean();
        this.isSection = dataInput.readBoolean();
        this.methodName = RtsUtil.readUTFOptmz(dataInput);
    }
}

