/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.interfaces.debugger.IDebugInfoExtension2;
import com.iscobol.interfaces.debugger.IDebugResponseExtension2;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;

public class DebugResponse
implements DataExternalizable,
IDebugResponseExtension2 {
    private static final long serialVersionUID = 1000006L;
    public static final int NO_INFO = 0;
    public static final int FILENAMES_INFO = 1;
    public static final int LINES_INFO = 2;
    public static final int PARAGRAPH_INFO = 4;
    public static final int COPYFILES_INFO = 8;
    public static final int SOURCEFILE_INFO = 16;
    public static final int COPYPATH_INFO = 32;
    public static final int TIMESTAMP_INFO = 64;
    public static final int COMPILER_OPTIONS_INFO = 128;
    public static final int FILE_SEPARATORS_INFO = 256;
    public static final int LISTING_INFO = 512;
    public static final int DEFAULT_INFO = 991;
    private DebugInfo dInfo;
    private int returnCode;
    private int lineNo;
    private String file = "";
    private int fileIndex;
    private String progFile = "";
    private int lastCmd = -1;
    private String varFullname;
    private String varValue;
    private int varType;
    private int varOffset;
    private int varLength;
    private Breakpoint[] breakpoints;
    private Watch[] watches;
    private ThreadObject[] threads;
    private int curThreadIdx;
    private boolean jumpCommandAllowed;
    private long totalMemory;
    private long freeMemory;
    private long timestamp;
    private Tree[] trees;
    private String message;
    private int oldLineNo;
    private String oldFile;
    private int oldFileIndex;
    private String oldProgram;
    private int firstBlockMode;

    public DebugResponse() {
    }

    public DebugResponse(DebugInfo debugInfo) {
        this.dInfo = debugInfo;
    }

    public DebugResponse(int n2, String string) {
        this(n2, 0, null, null, null, -1, 0L, 0L, "", -1, "", 0L, -1, null, (Tree[])null, string);
    }

    public DebugResponse(int n2, String string, int n3) {
        this(n2, string);
        this.lastCmd = n3;
    }

    public DebugResponse(int n2, int n3, String string, int n4, VarName varName, String string2) {
        this(n2, n3, null, null, null, -1, 0L, 0L, string, n4, "", 0L, -1, varName, (Tree[])null, string2);
    }

    public DebugResponse(int n2, int n3, Breakpoint[] breakpointArray, Watch[] watchArray, ThreadObject[] threadObjectArray, int n4, long l2, long l3, String string, int n5, String string2, int n6, VarName varName, Tree tree, String string3) {
        this(n2, n3, breakpointArray, watchArray, threadObjectArray, n4, l2, l3, string, n5, string2, 0L, n6, varName, new Tree[]{tree}, string3);
    }

    public DebugResponse(int n2, int n3, Breakpoint[] breakpointArray, Watch[] watchArray, ThreadObject[] threadObjectArray, int n4, long l2, long l3, String string, int n5, String string2, long l4, int n6, VarName varName, Tree tree, String string3) {
        this(n2, n3, breakpointArray, watchArray, threadObjectArray, n4, l2, l3, string, n5, string2, l4, n6, varName, new Tree[]{tree}, string3);
    }

    public DebugResponse(int n2, int n3, Breakpoint[] breakpointArray, Watch[] watchArray, ThreadObject[] threadObjectArray, int n4, long l2, long l3, String string, int n5, String string2, long l4, int n6, VarName varName, Tree[] treeArray, String string3) {
        this.returnCode = n2;
        this.lineNo = n3;
        this.breakpoints = breakpointArray;
        this.watches = watchArray;
        this.threads = threadObjectArray;
        this.curThreadIdx = n4;
        this.totalMemory = l2;
        this.freeMemory = l3;
        this.file = string;
        this.fileIndex = n5;
        if (string2 != null) {
            this.progFile = string2;
            this.timestamp = l4;
        }
        this.setVarName(varName);
        this.trees = treeArray;
        this.lastCmd = n6;
        this.message = string3;
    }

    public void setInfo(DebugInfo debugInfo) {
        this.dInfo = debugInfo;
    }

    @Override
    public DebugInfo getInfo() {
        return this.dInfo;
    }

    @Override
    public boolean isJumpCommandAllowed() {
        return this.jumpCommandAllowed;
    }

    public void setJumpCommandAllowed(boolean bl) {
        this.jumpCommandAllowed = bl;
    }

    public Watch[] getMonitors() {
        return this.watches;
    }

    public void setMonitors(Watch[] watchArray) {
        this.watches = watchArray;
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int n2) {
        this.returnCode = n2;
    }

    @Override
    public int getLastCmd() {
        return this.lastCmd;
    }

    public void setLastCmd(int n2) {
        this.lastCmd = n2;
    }

    public Breakpoint[] getBreakpoints() {
        return this.breakpoints;
    }

    public void setBreakpoints(Breakpoint[] breakpointArray) {
        this.breakpoints = breakpointArray;
    }

    public ThreadObject[] getThreads() {
        return this.threads;
    }

    public void setThreads(ThreadObject[] threadObjectArray) {
        this.threads = threadObjectArray;
    }

    @Override
    public ThreadObject getCurrentThread() {
        if (this.threads != null && this.curThreadIdx >= 0 && this.curThreadIdx < this.threads.length) {
            return this.threads[this.curThreadIdx];
        }
        return null;
    }

    public void setCurThreadIdx(int n2) {
        this.curThreadIdx = n2;
    }

    @Override
    public int getCurThreadIdx() {
        return this.curThreadIdx;
    }

    @Override
    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long l2) {
        this.totalMemory = l2;
    }

    @Override
    public long getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(long l2) {
        this.freeMemory = l2;
    }

    public Tree[] getTrees() {
        return this.trees;
    }

    @Override
    public Tree getTree() {
        return this.trees != null && this.trees.length > 0 ? this.trees[0] : null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public int getLine() {
        return this.lineNo;
    }

    public void setLine(int n2) {
        this.lineNo = n2;
    }

    @Override
    public String getLastFile() {
        return this.file;
    }

    @Override
    public int getLastFileIndex() {
        return this.fileIndex;
    }

    public void setLastFileIndex(int n2) {
        this.fileIndex = n2;
    }

    public void setLastFile(String string) {
        this.file = string;
    }

    @Override
    public String getLastProgram() {
        return this.progFile;
    }

    @Override
    public long getLastProgramTimestamp() {
        return this.timestamp;
    }

    public void setLastProgram(String string) {
        this.progFile = string;
    }

    public ParagraphObject[] getParStack() {
        if (this.threads != null && this.curThreadIdx >= 0 && this.curThreadIdx < this.threads.length) {
            return this.threads[this.curThreadIdx].getParStack();
        }
        return null;
    }

    @Override
    public String getLastClass() {
        ParagraphObject[] paragraphObjectArray = this.getParStack();
        if (paragraphObjectArray != null && paragraphObjectArray.length > 0) {
            return paragraphObjectArray[paragraphObjectArray.length - 1].getProgName();
        }
        return null;
    }

    public void setVarName(VarName varName) {
        if (varName != null) {
            this.varFullname = varName.getFullName();
            this.varValue = varName.getValue();
            this.varType = varName.getType();
            this.varLength = varName.getLength();
            this.varOffset = varName.getOffset();
        }
    }

    @Override
    public int getVarType() {
        return this.varType;
    }

    @Override
    public int getVarLength() {
        return this.varLength;
    }

    @Override
    public int getVarOffset() {
        return this.varOffset;
    }

    @Override
    public String getVarName() {
        return this.varFullname;
    }

    @Override
    public String getVarValue() {
        return this.varValue;
    }

    protected void setVarValue(String string) {
        this.varValue = string;
    }

    public void setOldLine(int n2) {
        this.oldLineNo = n2;
    }

    public void setOldFile(String string) {
        this.oldFile = string;
    }

    @Override
    public int getOldLine() {
        return this.oldLineNo;
    }

    @Override
    public String getOldFile() {
        return this.oldFile;
    }

    @Override
    public int getOldFileIndex() {
        return this.oldFileIndex;
    }

    public void setOldFileIndex(int n2) {
        this.oldFileIndex = n2;
    }

    @Override
    public String getOldProgram() {
        return this.oldProgram;
    }

    public void setOldProgram(String string) {
        this.oldProgram = string;
    }

    public void setTrees(Tree[] treeArray) {
        this.trees = treeArray;
    }

    @Override
    public boolean isErrorCode() {
        return DebugResponse.isErrorCode(this.returnCode);
    }

    public static boolean isErrorCode(int n2) {
        switch (n2) {
            case 103: 
            case 106: 
            case 201: 
            case 202: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFirstBlockMode() {
        return this.firstBlockMode;
    }

    public void setFirstBlockMode(int n2) {
        this.firstBlockMode = n2;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.dInfo != null);
        if (this.dInfo != null) {
            this.dInfo.writeExternal(dataOutput);
        }
        dataOutput.writeInt(this.returnCode);
        dataOutput.writeInt(this.lineNo);
        RtsUtil.writeUTFOptmz(this.file, dataOutput);
        dataOutput.writeInt(this.fileIndex);
        RtsUtil.writeUTFOptmz(this.progFile, dataOutput);
        dataOutput.writeInt(this.lastCmd);
        RtsUtil.writeUTFOptmz(this.varFullname, dataOutput);
        RtsUtil.writeUTF(this.varValue, dataOutput);
        dataOutput.writeInt(this.varType);
        dataOutput.writeInt(this.varOffset);
        dataOutput.writeInt(this.varLength);
        if (this.breakpoints != null) {
            dataOutput.writeInt(this.breakpoints.length);
            for (DataExternalizable dataExternalizable : this.breakpoints) {
                ((Breakpoint)dataExternalizable).writeExternal(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        if (this.watches != null) {
            dataOutput.writeInt(this.watches.length);
            for (DataExternalizable dataExternalizable : this.watches) {
                ((Watch)dataExternalizable).writeExternal(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        if (this.threads != null) {
            dataOutput.writeInt(this.threads.length);
            for (DataExternalizable dataExternalizable : this.threads) {
                ((ThreadObject)dataExternalizable).writeExternal(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        dataOutput.writeInt(this.curThreadIdx);
        dataOutput.writeBoolean(this.jumpCommandAllowed);
        dataOutput.writeLong(this.totalMemory);
        dataOutput.writeLong(this.freeMemory);
        dataOutput.writeLong(this.timestamp);
        if (this.trees != null) {
            dataOutput.writeInt(this.trees.length);
            for (DataExternalizable dataExternalizable : this.trees) {
                ((Tree)dataExternalizable).writeExternal(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
        RtsUtil.writeUTF(this.message, dataOutput);
        dataOutput.writeInt(this.oldLineNo);
        RtsUtil.writeUTFOptmz(this.oldFile, dataOutput);
        dataOutput.writeInt(this.oldFileIndex);
        RtsUtil.writeUTFOptmz(this.oldProgram, dataOutput);
        dataOutput.writeInt(this.firstBlockMode);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        int n2;
        if (dataInput.readBoolean()) {
            this.dInfo = new DebugInfo();
            this.dInfo.readExternal(dataInput);
        }
        this.returnCode = dataInput.readInt();
        this.lineNo = dataInput.readInt();
        this.file = RtsUtil.readUTFOptmz(dataInput);
        this.fileIndex = dataInput.readInt();
        this.progFile = RtsUtil.readUTFOptmz(dataInput);
        this.lastCmd = dataInput.readInt();
        this.varFullname = RtsUtil.readUTFOptmz(dataInput);
        this.varValue = RtsUtil.readUTF(dataInput);
        this.varType = dataInput.readInt();
        this.varOffset = dataInput.readInt();
        this.varLength = dataInput.readInt();
        this.breakpoints = new Breakpoint[dataInput.readInt()];
        for (n2 = 0; n2 < this.breakpoints.length; ++n2) {
            this.breakpoints[n2] = new Breakpoint();
            this.breakpoints[n2].readExternal(dataInput);
        }
        this.watches = new Watch[dataInput.readInt()];
        for (n2 = 0; n2 < this.watches.length; ++n2) {
            this.watches[n2] = new Watch();
            this.watches[n2].readExternal(dataInput);
        }
        this.threads = new ThreadObject[dataInput.readInt()];
        for (n2 = 0; n2 < this.threads.length; ++n2) {
            this.threads[n2] = new ThreadObject();
            this.threads[n2].readExternal(dataInput);
        }
        this.curThreadIdx = dataInput.readInt();
        this.jumpCommandAllowed = dataInput.readBoolean();
        this.totalMemory = dataInput.readLong();
        this.freeMemory = dataInput.readLong();
        this.timestamp = dataInput.readLong();
        this.trees = new Tree[dataInput.readInt()];
        for (n2 = 0; n2 < this.trees.length; ++n2) {
            this.trees[n2] = new Tree();
            this.trees[n2].readExternal(dataInput);
        }
        this.message = RtsUtil.readUTF(dataInput);
        this.oldLineNo = dataInput.readInt();
        this.oldFile = RtsUtil.readUTFOptmz(dataInput);
        this.oldFileIndex = dataInput.readInt();
        this.oldProgram = RtsUtil.readUTFOptmz(dataInput);
        this.firstBlockMode = dataInput.readInt();
    }

    public static class DebugInfo
    implements DataExternalizable,
    IDebugInfoExtension2 {
        private static final long serialVersionUID = 1000006L;
        private String[] filenames;
        private DebugLine[] lines;
        private DebugParagraph[] paragraphs;
        private DebugCopyFile[] copyfiles;
        private String sourcefile;
        private String copypath;
        private String className;
        private String errorString;
        private long timestamp;
        private boolean jumpCommandSupported;
        private String[] compilerOptions;
        private String[] compilerProps;
        private byte[] listingInfos;
        private int infoFormat;
        protected String[] fileSeparators;

        public DebugInfo() {
        }

        public DebugInfo(String string, String[] stringArray, DebugLine[] debugLineArray, DebugParagraph[] debugParagraphArray, DebugCopyFile[] debugCopyFileArray, String string2, String string3, long l2, boolean bl, String[] stringArray2, String[] stringArray3, String[] stringArray4, byte[] byArray, int n2) {
            this.className = string;
            this.filenames = stringArray;
            this.lines = debugLineArray;
            this.paragraphs = debugParagraphArray;
            this.copyfiles = debugCopyFileArray;
            this.sourcefile = string2;
            this.copypath = string3;
            this.timestamp = l2;
            this.jumpCommandSupported = bl;
            this.compilerOptions = stringArray2;
            this.fileSeparators = stringArray3;
            this.compilerProps = stringArray4;
            this.infoFormat = n2;
            this.listingInfos = byArray;
        }

        public DebugInfo(String string) {
            this("$Dummy$", new String[0], new DebugLine[0], new DebugParagraph[0], new DebugCopyFile[0], "", "", 0L, false, null, null, null, null, 0);
            this.errorString = string;
        }

        @Override
        public byte[] getListingInfos() {
            return this.listingInfos;
        }

        @Override
        public char getHyphenReplacingChar() {
            int n2 = 95;
            if (this.compilerOptions != null) {
                for (String string : this.compilerOptions) {
                    if (!"-smfu".equalsIgnoreCase(string)) continue;
                    n2 = 36;
                    break;
                }
            }
            return (char)n2;
        }

        @Override
        public String getFileSeparator() {
            if (this.fileSeparators != null) {
                return this.fileSeparators[0];
            }
            return File.separator;
        }

        @Override
        public String getPathSeparator() {
            if (this.fileSeparators != null) {
                return this.fileSeparators[1];
            }
            return File.pathSeparator;
        }

        @Override
        public boolean isJumpCommandSupported() {
            return this.jumpCommandSupported;
        }

        @Override
        public void setJumpCommandSupported(boolean bl) {
            this.jumpCommandSupported = bl;
        }

        @Override
        public String getErrorString() {
            return this.errorString;
        }

        @Override
        public String[] getFilenames() {
            return this.filenames;
        }

        public DebugLine[] getLines() {
            return this.lines;
        }

        @Override
        public String[] getCompilerOptions() {
            return this.compilerOptions;
        }

        @Override
        public String[] getCompilerProps() {
            return this.compilerProps;
        }

        @Override
        public int getInfoFormat() {
            return this.infoFormat;
        }

        public DebugParagraph[] getParagraphs() {
            return this.paragraphs;
        }

        public DebugCopyFile[] getCopyfiles() {
            return this.copyfiles;
        }

        @Override
        public String getSourcefile() {
            return this.sourcefile;
        }

        @Override
        public String getCopyPath() {
            return this.copypath;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public void writeExternal(DataOutput dataOutput) throws IOException {
            if (this.filenames != null) {
                dataOutput.writeInt(this.filenames.length);
                for (String object : this.filenames) {
                    RtsUtil.writeUTFOptmz(object, dataOutput);
                }
            } else {
                dataOutput.writeInt(0);
            }
            if (this.lines != null) {
                dataOutput.writeInt(this.lines.length);
                for (DebugLine debugLine : this.lines) {
                    debugLine.writeExternal(dataOutput);
                }
            } else {
                dataOutput.writeInt(0);
            }
            if (this.paragraphs != null) {
                dataOutput.writeInt(this.paragraphs.length);
                for (DebugParagraph debugParagraph : this.paragraphs) {
                    debugParagraph.writeExternal(dataOutput);
                }
            } else {
                dataOutput.writeInt(0);
            }
            if (this.copyfiles != null) {
                dataOutput.writeInt(this.copyfiles.length);
                for (DebugCopyFile debugCopyFile : this.copyfiles) {
                    debugCopyFile.writeExternal(dataOutput);
                }
            } else {
                dataOutput.writeInt(0);
            }
            RtsUtil.writeUTFOptmz(this.sourcefile, dataOutput);
            RtsUtil.writeUTF(this.copypath, dataOutput);
            RtsUtil.writeUTFOptmz(this.className, dataOutput);
            RtsUtil.writeUTF(this.errorString, dataOutput);
            dataOutput.writeLong(this.timestamp);
            dataOutput.writeBoolean(this.jumpCommandSupported);
            if (this.compilerOptions != null) {
                dataOutput.writeInt(this.compilerOptions.length);
                for (String string : this.compilerOptions) {
                    RtsUtil.writeUTFOptmz(string, dataOutput);
                }
            } else {
                dataOutput.writeInt(0);
            }
            if (this.fileSeparators != null) {
                dataOutput.writeInt(this.fileSeparators.length);
                for (String string : this.fileSeparators) {
                    RtsUtil.writeUTFOptmz(string, dataOutput);
                }
            } else {
                dataOutput.writeInt(0);
            }
            if (this.listingInfos != null) {
                dataOutput.writeInt(this.listingInfos.length);
                dataOutput.write(this.listingInfos, 0, this.listingInfos.length);
            } else {
                dataOutput.writeInt(0);
            }
            if (this.compilerProps != null) {
                dataOutput.writeInt(this.compilerProps.length);
                for (String string : this.compilerProps) {
                    RtsUtil.writeUTFOptmz(string, dataOutput);
                }
            } else {
                dataOutput.writeInt(0);
            }
            dataOutput.writeInt(this.infoFormat);
        }

        @Override
        public void readExternal(DataInput dataInput) throws IOException {
            int n2;
            this.filenames = new String[dataInput.readInt()];
            for (n2 = 0; n2 < this.filenames.length; ++n2) {
                this.filenames[n2] = RtsUtil.readUTFOptmz(dataInput);
            }
            this.lines = new DebugLine[dataInput.readInt()];
            for (n2 = 0; n2 < this.lines.length; ++n2) {
                this.lines[n2] = new DebugLine();
                this.lines[n2].readExternal(dataInput);
            }
            this.paragraphs = new DebugParagraph[dataInput.readInt()];
            for (n2 = 0; n2 < this.paragraphs.length; ++n2) {
                this.paragraphs[n2] = new DebugParagraph();
                this.paragraphs[n2].readExternal(dataInput);
            }
            this.copyfiles = new DebugCopyFile[dataInput.readInt()];
            for (n2 = 0; n2 < this.copyfiles.length; ++n2) {
                this.copyfiles[n2] = new DebugCopyFile();
                this.copyfiles[n2].readExternal(dataInput);
            }
            this.sourcefile = RtsUtil.readUTFOptmz(dataInput);
            this.copypath = RtsUtil.readUTF(dataInput);
            this.className = RtsUtil.readUTFOptmz(dataInput);
            this.errorString = RtsUtil.readUTF(dataInput);
            this.timestamp = dataInput.readLong();
            this.jumpCommandSupported = dataInput.readBoolean();
            this.compilerOptions = new String[dataInput.readInt()];
            for (n2 = 0; n2 < this.compilerOptions.length; ++n2) {
                this.compilerOptions[n2] = RtsUtil.readUTFOptmz(dataInput);
            }
            this.fileSeparators = new String[dataInput.readInt()];
            for (n2 = 0; n2 < this.fileSeparators.length; ++n2) {
                this.fileSeparators[n2] = RtsUtil.readUTFOptmz(dataInput);
            }
            n2 = dataInput.readInt();
            if (n2 > 0) {
                this.listingInfos = new byte[n2];
                dataInput.readFully(this.listingInfos, 0, this.listingInfos.length);
            } else {
                this.listingInfos = null;
            }
            this.compilerProps = new String[dataInput.readInt()];
            for (int i2 = 0; i2 < this.compilerProps.length; ++i2) {
                this.compilerProps[i2] = RtsUtil.readUTFOptmz(dataInput);
            }
            this.infoFormat = dataInput.readInt();
        }
    }
}

