/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.rts.Base64;
import com.iscobol.rts.SMAPReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.InflaterInputStream;

public class DebugSMAPReader
extends SMAPReader {
    private Vector<DebugCopyFile> copyFiles;
    private Vector<DebugLine> dbgLines;
    private Vector<DebugParagraph> dbgParagraphs;
    private String sourceFileName;
    private String[] fileSeparator;
    private String[][] _78levels;
    private String[] compilerProps;
    private byte[] listingInfos;

    public DebugSMAPReader(InputStream inputStream, String string) throws IOException {
        super(inputStream, string == null);
        if (string != null) {
            int n2 = this.newFormat;
            if (n2 == 0) {
                this.initVectors();
                this.newFormat = 6;
                this.compilerProps = new String[]{"iscobol.compiler.debug.replaced_source=0"};
            }
            byte[] byArray = Base64.decode(string.getBytes("utf-8"));
            DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
            this.initDebugInfo(dataInputStream);
            this.readCopyStmts(dataInputStream);
            if (n2 == 0) {
                TreeSet<FileObj> treeSet = new TreeSet<FileObj>();
                class FileObj
                implements Comparable<FileObj> {
                    final int index;
                    final String name;

                    FileObj(int n2, String string) {
                        this.index = n2;
                        this.name = string;
                    }

                    @Override
                    public int compareTo(FileObj fileObj) {
                        return this.index - fileObj.index;
                    }
                }
                treeSet.add(new FileObj(0, this.sourceFileName));
                for (String[] object : this.getCopyStatements()) {
                    this.copyFiles.addElement(new DebugCopyFile(object[0], Integer.parseInt(object[1]), object[2]));
                    treeSet.add(new FileObj(Integer.parseInt(object[4]), object[2]));
                }
                Vector<String> vector = this.getFileNames();
                for (FileObj fileObj : treeSet) {
                    vector.addElement(fileObj.name);
                }
            } else {
                this.getCopyStatements().clear();
            }
            this.timestamp = dataInputStream.readLong();
            dataInputStream.close();
        }
    }

    @Override
    protected void buildOld2(DataInputStream dataInputStream) throws IOException {
        super.buildOld2(dataInputStream);
        this.buildExt(dataInputStream, null);
    }

    @Override
    protected void buildExt(DataInputStream dataInputStream, DataInputStream dataInputStream2) throws IOException {
        Object[] objectArray2;
        DataInputStream dataInputStream3 = dataInputStream2 != null ? dataInputStream2 : dataInputStream;
        boolean bl = dataInputStream3.readBoolean();
        if (!bl) {
            return;
        }
        if (this.newFormat < 5) {
            this.timestamp = dataInputStream3.readLong();
        }
        this.initVectors();
        for (Object[] objectArray2 : this.getCopyStatements()) {
            this.copyFiles.addElement(new DebugCopyFile(objectArray2[0], Integer.parseInt(objectArray2[1]), objectArray2[2]));
        }
        if (this.newFormat < 6) {
            this.initDebugInfo(dataInputStream3);
        }
        if (this.newFormat >= 4) {
            this.compilerProps = new String[dataInputStream3.readInt()];
            for (int i2 = 0; i2 < this.compilerProps.length; ++i2) {
                this.compilerProps[i2] = dataInputStream3.readUTF();
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        objectArray2 = new byte[8192];
        int n2 = dataInputStream.read((byte[])objectArray2);
        while (n2 > 0) {
            byteArrayOutputStream.write((byte[])objectArray2, 0, n2);
            n2 = dataInputStream.read((byte[])objectArray2);
        }
        this.listingInfos = byteArrayOutputStream.toByteArray();
    }

    private void initDebugInfo(DataInputStream dataInputStream) throws IOException {
        int n2;
        int n3;
        int n4;
        this.fileSeparator = new String[]{dataInputStream.readUTF(), dataInputStream.readUTF()};
        if (this.newFormat < 6) {
            n4 = dataInputStream.readInt();
            for (n3 = 0; n3 < n4; ++n3) {
                dataInputStream.readByte();
                dataInputStream.readUTF();
                dataInputStream.readUTF();
            }
        }
        n4 = dataInputStream.readInt();
        for (n3 = 0; n3 < n4; ++n3) {
            this.dbgLines.addElement(new DebugLine(dataInputStream.readInt(), dataInputStream.readShort(), dataInputStream.readInt(), dataInputStream.readBoolean()));
        }
        n3 = dataInputStream.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            this.dbgParagraphs.add(new DebugParagraph(dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readInt(), dataInputStream.readShort(), dataInputStream.readBoolean(), dataInputStream.readInt(), dataInputStream.readBoolean()));
        }
        this.sourceFileName = dataInputStream.readUTF();
        n2 = dataInputStream.readInt();
        this._78levels = new String[n2][2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this._78levels[i2][0] = dataInputStream.readUTF();
            this._78levels[i2][1] = dataInputStream.readUTF();
        }
    }

    public String[] getCompilerProps() {
        return this.compilerProps;
    }

    public Vector<DebugCopyFile> getCopyFiles() {
        return this.copyFiles;
    }

    public Vector<DebugLine> getDbgLines() {
        return this.dbgLines;
    }

    public Vector<DebugParagraph> getDbgParagraphs() {
        return this.dbgParagraphs;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String[] getFileSeparator() {
        return this.fileSeparator;
    }

    public byte[] getListingInfos() {
        return this.listingInfos;
    }

    public String[][] get_78Levels() {
        return this._78levels;
    }

    private void initVectors() {
        this.copyFiles = new Vector();
        this.dbgLines = new Vector();
        this.dbgParagraphs = new Vector();
    }
}

