/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IDebugTM;
import com.iscobol.interfaces.debugger.IDebugTMMarker;
import java.util.StringTokenizer;

public class DebugTM
implements IDebugTM {
    private String[] tokenBuffer;
    private int tokenIdx;
    private DebugCommand[] commands;

    public DebugTM(String string) {
        this(string, " ,;(:=)+*\"<>", DebuggerInvoker.standardCommands);
    }

    public DebugTM(String string, String string2, DebugCommand[] debugCommandArray) {
        this.commands = debugCommandArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        int n2 = stringTokenizer.countTokens();
        this.tokenBuffer = new String[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.tokenBuffer[n3] = stringTokenizer.nextToken();
            ++n3;
        }
    }

    protected String getCommandAlias(String string) {
        return null;
    }

    @Override
    public int getCommand() throws DebuggerException {
        return this.getCommand(this.getToken());
    }

    @Override
    public int getCommand(String string) throws DebuggerException {
        int n2 = -2;
        String string2 = null;
        if (string == null) {
            return -1;
        }
        if (string.equals("?")) {
            return 20;
        }
        for (int i2 = 0; i2 < this.commands.length; ++i2) {
            String string3 = this.commands[i2].getStringId();
            String string4 = this.getCommandAlias(string3);
            if (string4 != null) {
                string3 = string4;
            }
            String string5 = string3;
            if (this.commands[i2].isWholeWord() && string5.equalsIgnoreCase(string)) {
                n2 = this.commands[i2].getId();
                break;
            }
            if (this.commands[i2].isWholeWord() || string5.length() < string.length() || !string5.substring(0, string.length()).equalsIgnoreCase(string)) continue;
            if (string2 == null) {
                string2 = string + ": " + string3;
                n2 = this.commands[i2].getId();
                continue;
            }
            string2 = string2 + ", " + string3;
            n2 = -2;
        }
        if (n2 == -2) {
            if (string2 == null) {
                throw new DebuggerException(33, "'" + string + "'");
            }
            throw new DebuggerException(34, string2);
        }
        return n2;
    }

    @Override
    public Marker setMarker() {
        return new Marker(Math.min(this.tokenIdx, this.tokenBuffer.length - 1));
    }

    @Override
    public void rewindToMarker(IDebugTMMarker iDebugTMMarker) {
        if (!(iDebugTMMarker instanceof Marker)) {
            throw new IllegalArgumentException("" + iDebugTMMarker);
        }
        this.rewindToMarker((Marker)iDebugTMMarker);
    }

    public void rewindToMarker(Marker marker) {
        this.tokenIdx = marker.idx;
    }

    @Override
    public String getAllToken() {
        if (this.tokenIdx < this.tokenBuffer.length) {
            return this.tokenBuffer[this.tokenIdx++];
        }
        return null;
    }

    @Override
    public void ungetAllToken() {
        if (this.tokenIdx > 0) {
            --this.tokenIdx;
        }
    }

    @Override
    public void ungetToken() {
        while (this.tokenIdx > 0) {
            this.ungetAllToken();
            if (DebugTM.isSeparator(this.tokenBuffer[this.tokenIdx])) continue;
            break;
        }
    }

    @Override
    public String getTokenAndComma() {
        while (this.tokenIdx < this.tokenBuffer.length) {
            String string = this.getAllToken();
            if (!string.equals(",") && DebugTM.isSeparator(string)) continue;
            return string;
        }
        return null;
    }

    @Override
    public String getToken() {
        while (this.tokenIdx < this.tokenBuffer.length) {
            String string = this.getAllToken();
            if (DebugTM.isSeparator(string)) continue;
            return string;
        }
        return null;
    }

    @Override
    public int countAllTokens() {
        return this.tokenBuffer.length - this.tokenIdx;
    }

    @Override
    public int countTokens() {
        int n2 = 0;
        int n3 = this.countAllTokens();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (DebugTM.isSeparator(this.tokenBuffer[this.tokenIdx + i2])) continue;
            ++n2;
        }
        return n2;
    }

    public static boolean isSeparator(String string) {
        return string.equals(" ") || string.equals(",");
    }

    public String toString(Marker marker, Marker marker2) {
        return this.toString(marker.idx, marker2.idx);
    }

    public String toString() {
        return this.toString(0, this.tokenBuffer.length - 1);
    }

    private String toString(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (DebugTM.isSeparator(this.tokenBuffer[i2])) continue;
            stringBuffer.append(this.tokenBuffer[i2] + " ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public class Marker
    implements IDebugTMMarker {
        private int idx;

        private Marker(int n2) {
            this.idx = n2;
        }
    }
}

