/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugSMAPReader;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.ErrorResponse;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.Level88;
import com.iscobol.debugger.RawTextResponse;
import com.iscobol.debugger.RepositoryEntry;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.BaseGUIWindow;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.interfaces.debugger.IVarValue;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.Config;
import com.iscobol.rts.DebuggerHelper;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IDebuggerHelper;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IObjectVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DebugUtilities {
    public static final int LINE_SEPARATOR = 10;
    public static final String INTERNAL_PROP_PREFIX = "debug.internal.";
    public static final String MAX_HEX_DUMP_LENGTH_PROP = "debug.internal.max_hex_dump_length";
    public static final String HEX_DUMP_START_PROP = "debug.internal.hex_dump_start";
    public static final String MAX_ARRAY_LENGTH_PROP = "debug.internal.max_array_length";
    public static final String ARRAY_START_PROP = "debug.internal.array_start";
    public static final String MAX_TEXT_LENGTH_PROP = "debug.internal.max_text_length";
    public static final String MAX_TEXT_LENGTH_OUT_PROP = "debug.internal.max_text_length_out";
    private static final String eol = System.getProperty("line.separator");
    private static final IDebuggerHelper DEFAULT_HELPER_RTS = new DebuggerHelper();
    private static final IDebuggerHelper DEFAULT_HELPER_RTS_N = DebugUtilities.getDefaultHelper_rts_n();
    private static final Map<Class, DebugSMAPReader> smaps = new HashMap<Class, DebugSMAPReader>();
    public static final Enumeration EMPTY_ENUMERATION = new EmptyEnumeration();

    private static IDebuggerHelper getDefaultHelper_rts_n() {
        try {
            return (IDebuggerHelper)Class.forName("com.iscobol.rts_n.DebuggerHelper").newInstance();
        }
        catch (Exception exception) {
            return DEFAULT_HELPER_RTS;
        }
    }

    static int MAX_DISPLAY_LENGTH() {
        return Config.a("iscobol.debug.internal.max_text_length_out", 1024);
    }

    private static boolean isElementAllocated(ICobolVar iCobolVar, int[] nArray, int n2) {
        if (!iCobolVar.isInDynamicTable()) {
            return true;
        }
        try {
            if (iCobolVar.getDynamicCapacity(nArray, false) >= n2) {
                return true;
            }
            int[] nArray2 = nArray;
            nArray = new int[nArray2.length + 1];
            int n3 = nArray2.length;
            nArray[n3] = n2;
            --n3;
            while (n3 >= 0) {
                nArray[n3] = nArray2[n3];
                --n3;
            }
            return iCobolVar.getDynamicCapacity(nArray, true) > 0;
        }
        catch (IscobolRuntimeException iscobolRuntimeException) {
            return false;
        }
    }

    static Tree buildTree(String string, ICobolVar iCobolVar, int[] nArray, boolean bl, boolean bl2, short s2) {
        TreeNode treeNode;
        Object object;
        String string2 = "iscobol.";
        int[] nArray2 = new int[]{Config.a("iscobol.debug.internal.max_hex_dump_length", 256), Config.a("iscobol.debug.internal.hex_dump_start", 1), Config.a("iscobol.debug.internal.max_array_length", 25), Config.a("iscobol.debug.internal.array_start", 1), Config.a("iscobol.debug.internal.max_text_length", 512)};
        if (nArray == null || nArray.length == 0) {
            object = DebugUtilities.getDimensions(iCobolVar);
            if (object != null && ((int[])object).length > 0) {
                if (s2 != 0) {
                    if (s2 == 1) {
                        s2 = 0;
                    }
                    treeNode = new TreeNode(string, null);
                    nArray = new int[]{};
                    int[] nArray3 = new int[1];
                    for (int i2 = 1; i2 <= object[0]; ++i2) {
                        nArray3[0] = i2;
                        if (!DebugUtilities.isElementAllocated(iCobolVar, nArray, i2)) continue;
                        treeNode.addNode(DebugUtilities.buildNode(nArray3, null, iCobolVar.intIAt(nArray3), bl, bl2, s2, nArray2));
                    }
                } else {
                    TreeNode treeNode2 = DebugUtilities.buildNode(nArray, string, iCobolVar, bl, bl2, s2, nArray2);
                    treeNode2.setHasChildren(true);
                    treeNode2.setVarValue("");
                    treeNode = treeNode2;
                }
            } else {
                treeNode = DebugUtilities.buildNode(nArray, string, iCobolVar, bl, bl2, s2, nArray2);
            }
        } else {
            object = DebugUtilities.getDimensions(iCobolVar);
            if (object != null && ((int[])object).length == nArray.length + 1) {
                if (s2 != 0) {
                    if (s2 == 1) {
                        s2 = 0;
                    }
                    treeNode = new TreeNode(string, null);
                    int[] nArray4 = new int[nArray.length + 1];
                    System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
                    for (int i3 = 1; i3 <= object[nArray.length]; ++i3) {
                        nArray4[nArray.length] = i3;
                        if (!DebugUtilities.isElementAllocated(iCobolVar, nArray, i3)) continue;
                        treeNode.addNode(DebugUtilities.buildNode(nArray4, null, iCobolVar.intIAt(nArray4), bl, bl2, s2, nArray2));
                    }
                } else {
                    TreeNode treeNode3 = DebugUtilities.buildNode(nArray, null, iCobolVar, bl, bl2, s2, nArray2);
                    treeNode3.setHasChildren(true);
                    treeNode3.setVarValue("");
                    treeNode3.setVarName(string);
                    treeNode = treeNode3;
                }
            } else {
                treeNode = DebugUtilities.buildNode(nArray, null, iCobolVar.intIAt(nArray), bl, bl2, s2, nArray2);
                treeNode.setVarName(string);
            }
        }
        object = new Tree(treeNode, bl);
        return object;
    }

    static Tree buildTree(String string, Level88 level88, boolean bl) {
        TreeNode treeNode = new TreeNode(string, null);
        Tree tree = new Tree(treeNode, bl);
        boolean bl2 = false;
        try {
            bl2 = level88.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        treeNode.addNode(new TreeNode(level88.getName(), "" + bl2));
        return tree;
    }

    static Tree buildTree(String string, String string2, boolean bl) {
        return DebugUtilities.buildTree(string, string2, bl, 0, 0);
    }

    static Tree buildTree(String string, String string2, boolean bl, int n2, int n3) {
        TreeNode treeNode = new TreeNode(string, null);
        Tree tree = new Tree(treeNode, bl);
        treeNode.addNode(new TreeNode(string, string2, n2, n3));
        return tree;
    }

    static String buildValueStringLevel78(String string, boolean bl) {
        int n2;
        int n3;
        String string2 = "iscobol.";
        int[] nArray = new int[]{Config.a("iscobol.debug.internal.max_hex_dump_length", 256) * 2, Config.a("iscobol.debug.internal.hex_dump_start", 1) * 2 - 2, Config.a("iscobol.debug.internal.max_text_length", 512)};
        String string3 = "";
        if (nArray[0] <= 0 || string.length() <= nArray[0]) {
            n3 = 0;
            n2 = string.length();
        } else {
            if (nArray[1] < 0) {
                n3 = 0;
                string3 = "...";
            } else {
                n3 = Math.min(nArray[1], string.length() - nArray[0]);
            }
            n2 = nArray[0];
            string = string.substring(n3, n3 + n2);
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < string.length() && stringBuffer.length() < nArray[2]; i2 += 2) {
                stringBuffer.append((char)Integer.parseInt(string.substring(i2, i2 + 2), 16));
            }
            String string4 = stringBuffer.toString();
            return string + string3 + "\u0001" + string4;
        }
        return string + string3;
    }

    static List<ICobolVar> getAllChildren(ICobolVar iCobolVar) {
        ArrayList<ICobolVar> arrayList = new ArrayList<ICobolVar>();
        Enumeration enumeration = iCobolVar.getChildren();
        while (enumeration.hasMoreElements()) {
            ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
            arrayList.add(iCobolVar2);
            Enumeration enumeration2 = iCobolVar2.getRedefines();
            while (enumeration2.hasMoreElements()) {
                arrayList.add((ICobolVar)enumeration2.nextElement());
            }
        }
        return arrayList;
    }

    private static TreeNode buildNode(int[] nArray, String string, ICobolVar iCobolVar, boolean bl, boolean bl2, short s2, int[] nArray2) {
        StringBuffer stringBuffer = new StringBuffer(string != null ? string : iCobolVar.getName());
        if (nArray != null) {
            stringBuffer.append(" ( ");
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                stringBuffer.append(nArray[i2] + " ");
            }
            stringBuffer.append(")");
        }
        String string2 = null;
        List<ICobolVar> list = DebugUtilities.getAllChildren(iCobolVar);
        if (list.isEmpty()) {
            String string3 = DebugUtilities.toString(iCobolVar);
            if (nArray2[4] > 0 && string3.length() > nArray2[4]) {
                string3 = string3.substring(0, nArray2[4]);
            }
            if (bl) {
                string2 = DebugUtilities.toHexString(iCobolVar, nArray2[1] - 1, nArray2[0]);
                if (bl2) {
                    string2 = string2 + "\u0001" + string3;
                }
            } else {
                string2 = string3;
            }
            TreeNode treeNode = new TreeNode(stringBuffer.toString(), string2, iCobolVar.getOffset(), iCobolVar.getLength());
            return treeNode;
        }
        TreeNode treeNode = new TreeNode(stringBuffer.toString(), null, iCobolVar.getOffset(), iCobolVar.getLength());
        ListIterator<ICobolVar> listIterator = list.listIterator();
        if (s2 != 0) {
            if (s2 == 1) {
                s2 = 0;
            }
            while (listIterator.hasNext()) {
                int n2;
                int n3;
                int n4;
                int[] nArray3;
                ICobolVar iCobolVar2 = listIterator.next();
                if (nArray == null) {
                    int[] nArray4 = DebugUtilities.getDimensions(iCobolVar2);
                    if (nArray4 != null) {
                        nArray3 = new int[1];
                        nArray = new int[]{};
                        n4 = nArray4[0];
                        if (nArray2[2] <= 0 || n4 <= nArray2[2]) {
                            n3 = 1;
                            n2 = n4;
                        } else {
                            n3 = Math.min(nArray2[3], n4 - nArray2[2]);
                            n2 = n3 + nArray2[2] - 1;
                        }
                        for (int i3 = n3; i3 <= n2; ++i3) {
                            nArray3[0] = i3;
                            if (!DebugUtilities.isElementAllocated(iCobolVar2, nArray, i3)) continue;
                            treeNode.addNode(DebugUtilities.buildNode(nArray3, null, iCobolVar2.intIAt(nArray3), bl, bl2, s2, nArray2));
                        }
                        continue;
                    }
                    treeNode.addNode(DebugUtilities.buildNode(nArray, null, iCobolVar2, bl, bl2, s2, nArray2));
                    continue;
                }
                int n5 = nArray.length;
                nArray3 = DebugUtilities.getDimensions(iCobolVar2);
                if (nArray3 != null && nArray3.length > n5) {
                    int[] nArray5 = new int[n5 + 1];
                    System.arraycopy(nArray, 0, nArray5, 0, n5);
                    n4 = nArray3[n5];
                    if (nArray2[2] <= 0 || n4 <= nArray2[2]) {
                        n3 = 1;
                        n2 = n4;
                    } else {
                        n3 = Math.min(nArray2[3], n4 - nArray2[2]);
                        n2 = n3 + nArray2[2] - 1;
                    }
                    for (int i4 = n3; i4 <= n2; ++i4) {
                        nArray5[n5] = i4;
                        if (!DebugUtilities.isElementAllocated(iCobolVar2, nArray, i4)) continue;
                        treeNode.addNode(DebugUtilities.buildNode(nArray5, null, iCobolVar2.intIAt(nArray5), bl, bl2, s2, nArray2));
                    }
                    continue;
                }
                ICobolVar iCobolVar3 = nArray.length > 0 ? iCobolVar2.intIAt(nArray) : iCobolVar2;
                treeNode.addNode(DebugUtilities.buildNode(nArray, null, iCobolVar3, bl, bl2, s2, nArray2));
            }
        } else {
            treeNode.setHasChildren(listIterator.hasNext());
        }
        return treeNode;
    }

    static IDebuggerHelper getHelper(Class clazz) {
        if (clazz != null) {
            try {
                return (IDebuggerHelper)clazz.getMethod("get$DebuggerHelper", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    Field field = clazz.getDeclaredField("RETURN_CODE");
                    if (field.getType().getName().indexOf("types_n") >= 0) {
                        return DEFAULT_HELPER_RTS_N;
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        return DEFAULT_HELPER_RTS;
    }

    static boolean setValueAsHex(ICobolVar iCobolVar, String string) {
        byte[] byArray;
        if (string.length() == 0) {
            return true;
        }
        if ((string = string.toUpperCase()).length() % 2 == 1) {
            string = "0" + string;
        }
        if ((byArray = DebugUtilities.hexToBytes(string)) == null) {
            return false;
        }
        int n2 = DebugUtilities.getAvailableLength(iCobolVar);
        iCobolVar.set(byArray, 0, Math.min(byArray.length, n2), false);
        return true;
    }

    public static int getAvailableLength(ICobolVar iCobolVar) {
        int n2 = iCobolVar.length();
        int n3 = iCobolVar.getOffset();
        if (n3 < 0) {
            return 0;
        }
        int n4 = n3 + n2 - iCobolVar.getMemoryLength();
        if (n4 > 0) {
            n2 -= n4;
        }
        return n2;
    }

    public static boolean checkHexString(String string) {
        char[] cArray = string.toUpperCase().toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] >= '0' && cArray[i2] <= '9' || cArray[i2] >= 'A' && cArray[i2] <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static String toString(Object object) {
        return DebugUtilities.toString(object, -1);
    }

    public static String toString(Object object, int n2) {
        if (object == null) {
            return DebuggerConstants.NULL_VALUE;
        }
        if (object instanceof ICobolVar) {
            ICobolVar iCobolVar = (ICobolVar)object;
            boolean bl = iCobolVar.hasDynamicData();
            int n3 = iCobolVar.length();
            int n4 = DebugUtilities.getAvailableLength(iCobolVar);
            if (n4 == 0) {
                if (bl) {
                    return DebuggerConstants.DYNDATA_VALUE;
                }
                return DebuggerConstants.EMPTY_VALUE;
            }
            try {
                String string = "";
                if (n4 < n3) {
                    if (n2 > 0 && n2 < n4) {
                        n4 = n2;
                        string = "...";
                    }
                    iCobolVar = iCobolVar.intISub(1, n4);
                    return iCobolVar.toString() + string + "<null " + (n3 - n4) + ">";
                }
                if (n2 > 0 && n2 < n3) {
                    iCobolVar = iCobolVar.intISub(1, n2);
                    string = "...";
                }
                String string2 = iCobolVar.toString() + string;
                if (bl) {
                    string2 = string2 + DebuggerConstants.DYNDATA_VALUE;
                }
                return string2;
            }
            catch (IscobolRuntimeException iscobolRuntimeException) {
                if (iscobolRuntimeException.getErrNum() == 31) {
                    return DebuggerConstants.NON_NUMERIC_VALUE;
                }
                return DebuggerConstants.ERROR_VALUE;
            }
            catch (Exception exception) {
                return DebuggerConstants.ERROR_VALUE;
            }
        }
        if (object instanceof Level88) {
            try {
                return ((Level88)object).toString(n2);
            }
            catch (Exception exception) {
                return DebuggerConstants.ERROR_VALUE;
            }
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            return DebuggerConstants.ERROR_VALUE;
        }
    }

    public static String toHexString(ICobolVar iCobolVar) {
        return DebugUtilities.toHexString(iCobolVar, -1, -1);
    }

    public static String toHexString(ICobolVar iCobolVar, int n2) {
        return DebugUtilities.toHexString(iCobolVar, -1, n2);
    }

    public static String toHexString(ICobolVar iCobolVar, int n2, int n3) {
        int n4 = iCobolVar.length();
        int n5 = DebugUtilities.getAvailableLength(iCobolVar);
        boolean bl = iCobolVar.hasDynamicData();
        if (n5 == 0) {
            if (bl) {
                return DebuggerConstants.DYNDATA_VALUE;
            }
            return DebuggerConstants.EMPTY_VALUE;
        }
        byte[] byArray = new byte[n5];
        iCobolVar.getBytes(byArray, byArray.length);
        String string = DebugUtilities.toHexString(byArray, n2, n3);
        if (n5 < n4) {
            string = string + "<null " + (n4 - n5) + ">";
        } else if (bl) {
            string = string + DebuggerConstants.DYNDATA_VALUE;
        }
        return string;
    }

    public static String toHexString(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        String string = "";
        if (n3 <= 0 || byArray.length <= n3) {
            n5 = 0;
            n4 = byArray.length;
        } else {
            if (n2 < 0) {
                n5 = 0;
                string = "...";
            } else {
                n5 = Math.min(n2, byArray.length - n3);
            }
            n4 = n3;
        }
        return DebugUtilities.bytesToHex(byArray, n5, n4) + string;
    }

    public static String bytesToHex(byte[] byArray, int n2) {
        return DebugUtilities.bytesToHex(byArray, 0, n2);
    }

    public static String bytesToHex(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            String string = Integer.toHexString(byArray[i2]).toUpperCase();
            if (string.length() < 2) {
                string = "0" + string;
            } else if (string.length() > 2) {
                string = string.substring(string.length() - 2);
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static byte[] hexToBytes(String string) {
        if (string.length() % 2 == 1) {
            string = "0" + string;
        }
        try {
            byte[] byArray = new byte[string.length() / 2];
            int n2 = 0;
            int n3 = 0;
            while (n2 < string.length()) {
                byArray[n3] = (byte)Integer.parseInt(string.substring(n2, n2 + 2), 16);
                n2 += 2;
                ++n3;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static String getJavaName(String string, char c2) {
        String string2 = string;
        if (Character.isDigit(string2.charAt(0))) {
            string2 = "_" + string2;
        }
        string2 = string2.replace('-', c2);
        return string2;
    }

    static String getJavaNameUpper(String string, char c2) {
        return DebugUtilities.getJavaName(string, c2).toUpperCase();
    }

    public static String getIscobolClassName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        string2 = Filename.getBaseName(string.toUpperCase());
        int n2 = string2.lastIndexOf(46);
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        if ((string2 = string2.replace('-', '_')).length() > 0 && Character.isDigit(string2.charAt(0))) {
            string2 = "$" + string2;
        }
        return string2;
    }

    static boolean isValidCobolIdentifierName(String string) {
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (!(i2 == 0 ? !DebugUtilities.isValidCobolIdentifierStart(cArray[i2]) : !DebugUtilities.isValidCobolIdentifierPart(cArray[i2]))) continue;
            return false;
        }
        return true;
    }

    static boolean isValidCobolIdentifierPart(char c2) {
        return Character.isLetter(c2) || Character.isDigit(c2) || c2 == '-' || c2 == '_';
    }

    static boolean isValidCobolIdentifierStart(char c2) {
        return Character.isLetter(c2) || Character.isDigit(c2);
    }

    static Class getIscobolClass(String string) {
        if (string == null) {
            return null;
        }
        Class clazz = null;
        String string2 = string;
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
        }
        try {
            clazz = DebugUtilities.classForName(string2);
        }
        catch (Throwable throwable) {
            string2 = DebugUtilities.getIscobolClassName(string);
            try {
                clazz = DebugUtilities.classForName(string2);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return clazz;
    }

    static String inquireProp(INumericVar iNumericVar, String string, Class clazz, boolean bl) {
        Object object;
        Object object2;
        Object object3 = null;
        Object object4 = null;
        object4 = iNumericVar instanceof IObjectVar ? ((IObjectVar)iNumericVar).getId() : UserHandles.getId(iNumericVar.toint());
        if (object4 != null) {
            try {
                if (object4 instanceof BaseGUIControl) {
                    object2 = ScrFactory.getGUIEnviroment().inquireControl((BaseGUIControl)object4);
                    if (string.equalsIgnoreCase("VALUE")) {
                        object3 = ((BaseGUIControl)object2).getValue();
                    } else if (string.equalsIgnoreCase("TITLE")) {
                        object3 = ((BaseGUIControl)object2).getTitle();
                    } else if (string.equalsIgnoreCase("LINE")) {
                        object3 = "" + ((BaseGUIControl)object2).getLine();
                    } else if (string.equalsIgnoreCase("COL") || string.equalsIgnoreCase("COLUMN") || string.equalsIgnoreCase("POS") || string.equalsIgnoreCase("POSITION")) {
                        object3 = "" + ((BaseGUIControl)object2).getColumn();
                    } else if (string.equalsIgnoreCase("SIZE")) {
                        object3 = "" + ((BaseGUIControl)object2).getWidth();
                    } else if (string.equalsIgnoreCase("LINES")) {
                        object3 = "" + ((BaseGUIControl)object2).getHeight();
                    } else if (string.equalsIgnoreCase("ID")) {
                        object3 = "" + ((BaseGUIControl)object2).getId();
                    } else if (string.equalsIgnoreCase("HELP-ID")) {
                        object3 = "" + ((BaseGUIControl)object2).getHelpId();
                    } else if (string.equalsIgnoreCase("CLASS")) {
                        object3 = "" + ((BaseGUIControl)object2).getClassType();
                    } else if (string.equalsIgnoreCase("ENABLED")) {
                        object3 = ((BaseGUIControl)object2).getEnabled() ? "1" : "0";
                    } else if (string.equalsIgnoreCase("VISIBLE")) {
                        object3 = ((BaseGUIControl)object2).isVisible() ? "1" : "0";
                    } else if (string.equalsIgnoreCase("BACKGROUND-COLOR")) {
                        object3 = "" + ((BaseGUIControl)object2).getBackground();
                    } else if (string.equalsIgnoreCase("FOREGROUND-COLOR")) {
                        object3 = "" + ((BaseGUIControl)object2).getForeground();
                    } else if (string.equalsIgnoreCase("COLOR")) {
                        object3 = "" + ((BaseGUIControl)object2).getColor();
                    } else {
                        object = DebugUtilities.getHelper(clazz).getPicXAnyLength("result");
                        ((BaseGUIControl)object2).getProp(string, (ICobolVar)object);
                        object3 = object;
                    }
                    ((BaseGUIControl)object2).endInquire();
                } else if (object4 instanceof BaseGUIWindow) {
                    object2 = (BaseGUIWindow)object4;
                    if (string.equalsIgnoreCase("TITLE")) {
                        object3 = ((BaseGUIWindow)object2).getTitle();
                    } else if (string.equalsIgnoreCase("LINE")) {
                        object3 = "" + ((BaseGUIWindow)object2).getAtLine();
                    } else if (string.equalsIgnoreCase("COL") || string.equalsIgnoreCase("COLUMN") || string.equalsIgnoreCase("POS") || string.equalsIgnoreCase("POSITION")) {
                        object3 = "" + ((BaseGUIWindow)object2).getAtColumn();
                    } else if (string.equalsIgnoreCase("SIZE")) {
                        object3 = "" + ((BaseGUIWindow)object2).getSizes();
                    } else if (string.equalsIgnoreCase("LINES")) {
                        object3 = "" + ((BaseGUIWindow)object2).getLines();
                    } else if (string.equalsIgnoreCase("SCREENLINE")) {
                        object3 = "" + ((BaseGUIWindow)object2).getScreenLine();
                    } else if (string.equalsIgnoreCase("SCREENCOL") || string.equalsIgnoreCase("SCREENCOLUMN") || string.equalsIgnoreCase("SCREENPOS") || string.equalsIgnoreCase("SCREENPOSITION")) {
                        object3 = "" + ((BaseGUIWindow)object2).getScreenColumn();
                    } else if (string.equalsIgnoreCase("ENABLED")) {
                        object3 = ((BaseGUIWindow)object2).isEnabled() ? "1" : "0";
                    } else if (string.equalsIgnoreCase("VISIBLE")) {
                        object3 = ((BaseGUIWindow)object2).isVisible() ? "1" : "0";
                    } else if (string.equalsIgnoreCase("MASS-UPDATE")) {
                        object3 = object2 instanceof DisplayWindow ? (((DisplayWindow)object2).getMassUpdate() ? "1" : "0") : "0";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object3 == null) {
            object2 = "null";
        } else if (object3 instanceof ICobolVar) {
            object2 = bl ? DebugUtilities.toHexString((ICobolVar)object3, DebugUtilities.MAX_DISPLAY_LENGTH()) : object3.toString();
        } else if (bl) {
            try {
                object = ((String)object3).getBytes(CobolVar.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = ((String)object3).getBytes();
            }
            object2 = DebugUtilities.toHexString(object, -1, DebugUtilities.MAX_DISPLAY_LENGTH());
        } else {
            object2 = (String)object3;
        }
        return object2;
    }

    static void modifyProp(INumericVar iNumericVar, String string, String string2, Class clazz) {
        Object object = null;
        object = iNumericVar instanceof IObjectVar ? ((IObjectVar)iNumericVar).getId() : UserHandles.getId(iNumericVar.toint());
        boolean bl = true;
        float f2 = 0.0f;
        try {
            f2 = Float.parseFloat(string2);
            bl = false;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (object != null) {
            try {
                if (object instanceof BaseGUIControl) {
                    BaseGUIControl baseGUIControl = ScrFactory.getGUIEnviroment().modifyControl((BaseGUIControl)object);
                    if (string.equalsIgnoreCase("VALUE")) {
                        baseGUIControl.setValue(string2);
                    } else if (string.equalsIgnoreCase("TITLE")) {
                        baseGUIControl.modifyTitle(string2);
                    } else if (string.equalsIgnoreCase("LINE")) {
                        if (!bl) {
                            baseGUIControl.modifyAtLine(f2);
                        }
                    } else if (string.equalsIgnoreCase("COL") || string.equalsIgnoreCase("COLUMN") || string.equalsIgnoreCase("POS") || string.equalsIgnoreCase("POSITION")) {
                        if (!bl) {
                            baseGUIControl.modifyAtColumn(f2);
                        }
                    } else if (string.equalsIgnoreCase("SIZE")) {
                        if (!bl) {
                            baseGUIControl.modifySizes(f2);
                        }
                    } else if (string.equalsIgnoreCase("LINES")) {
                        if (!bl) {
                            baseGUIControl.modifyLines(f2);
                        }
                    } else if (string.equalsIgnoreCase("ENABLED")) {
                        if (!bl) {
                            baseGUIControl.modifyEnabled(f2 > 0.0f);
                        }
                    } else if (string.equalsIgnoreCase("VISIBLE")) {
                        if (!bl) {
                            baseGUIControl.modifyVisible(f2 > 0.0f);
                        }
                    } else if (string.equalsIgnoreCase("BACKGROUND-COLOR")) {
                        if (!bl) {
                            baseGUIControl.modifyColorBackground((int)f2);
                        }
                    } else if (string.equalsIgnoreCase("FOREGROUND-COLOR")) {
                        if (!bl) {
                            baseGUIControl.modifyColorForeground((int)f2);
                        }
                    } else if (string.equalsIgnoreCase("COLOR")) {
                        if (!bl) {
                            baseGUIControl.modifyColor((int)f2);
                        }
                    } else {
                        baseGUIControl.modifyProp(string, (CobValue)DebugUtilities.getHelper(clazz).getStrLiteral(string2));
                    }
                    baseGUIControl.endModify();
                } else if (object instanceof BaseGUIWindow) {
                    BaseGUIWindow baseGUIWindow = (BaseGUIWindow)object;
                    if (string.equalsIgnoreCase("TITLE")) {
                        baseGUIWindow.setTitle(string2);
                    } else if (string.equalsIgnoreCase("LINE")) {
                        if (!bl) {
                            baseGUIWindow.modifyAtLine(f2);
                        }
                    } else if (string.equalsIgnoreCase("COL") || string.equalsIgnoreCase("COLUMN") || string.equalsIgnoreCase("POS") || string.equalsIgnoreCase("POSITION")) {
                        if (!bl) {
                            baseGUIWindow.modifyAtColumn(f2);
                        }
                    } else if (string.equalsIgnoreCase("SIZE")) {
                        if (!bl) {
                            baseGUIWindow.modifySizes(f2);
                        }
                    } else if (string.equalsIgnoreCase("LINES")) {
                        if (!bl) {
                            baseGUIWindow.modifyLines(f2);
                        }
                    } else if (string.equalsIgnoreCase("SCREENLINE")) {
                        if (!bl) {
                            baseGUIWindow.modifyScreenLineColumn(f2, baseGUIWindow.getScreenColumn());
                        }
                    } else if (string.equalsIgnoreCase("SCREENCOL") || string.equalsIgnoreCase("SCREENCOLUMN") || string.equalsIgnoreCase("SCREENPOS") || string.equalsIgnoreCase("SCREENPOSITION")) {
                        if (!bl) {
                            baseGUIWindow.modifyScreenLineColumn(baseGUIWindow.getScreenColumn(), f2);
                        }
                    } else if (string.equalsIgnoreCase("ENABLED")) {
                        if (!bl) {
                            baseGUIWindow.modifyEnabled(f2 > 0.0f);
                        }
                    } else if (string.equalsIgnoreCase("VISIBLE")) {
                        if (!bl) {
                            baseGUIWindow.modifyVisible(f2 > 0.0f);
                        }
                    } else if (string.equalsIgnoreCase("MASS-UPDATE") && !bl) {
                        baseGUIWindow.modifyMassUpdate(Integer.toString((int)f2));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static ByteArrayOutputStream readLine(InputStream inputStream, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n3;
            while ((n3 = inputStream.read()) != n2) {
                if (n3 == -1) {
                    return null;
                }
                byteArrayOutputStream.write(n3);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream;
    }

    static void writeCommand(DebugCommand debugCommand, DataOutput dataOutput) {
        try {
            dataOutput.writeInt(debugCommand.getId());
            debugCommand.writeExternal(dataOutput);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeHeader(DataOutput dataOutput, boolean[] blArray) throws IOException {
        if (blArray[0]) {
            dataOutput.writeInt(1000006);
            RtsUtil.writeUTFOptmz(Charset.defaultCharset().name(), dataOutput);
            blArray[0] = false;
        }
    }

    static void writeResponse(DebugResponse debugResponse, DataOutput dataOutput, boolean[] blArray) {
        try {
            DebugUtilities.writeHeader(dataOutput, blArray);
            dataOutput.writeInt(1);
            debugResponse.writeExternal(dataOutput);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void writeErrorMessage(DataOutput dataOutput, String string, boolean[] blArray) {
        ErrorResponse errorResponse = new ErrorResponse(string);
        try {
            DebugUtilities.writeHeader(dataOutput, blArray);
            dataOutput.writeInt(2);
            errorResponse.writeExternal(dataOutput);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void writeRawText(DataOutput dataOutput, String string, boolean[] blArray) {
        RawTextResponse rawTextResponse = new RawTextResponse(string);
        try {
            DebugUtilities.writeHeader(dataOutput, blArray);
            dataOutput.writeInt(3);
            rawTextResponse.writeExternal(dataOutput);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String[] getFilenames(Class clazz) throws Exception {
        DebugSMAPReader debugSMAPReader = DebugUtilities.getDSR(clazz);
        if (debugSMAPReader != null) {
            return debugSMAPReader.getFileNames().toArray(new String[debugSMAPReader.getFileNames().size()]);
        }
        Method method = clazz.getMethod("get$Filenames", new Class[0]);
        return (String[])method.invoke(null, new Object[0]);
    }

    static String[] getFileSeparators(Class clazz) throws Exception {
        DebugSMAPReader debugSMAPReader = DebugUtilities.getDSR(clazz);
        if (debugSMAPReader != null) {
            return debugSMAPReader.getFileSeparator();
        }
        Method method = clazz.getMethod("get$FileSeparators", new Class[0]);
        return (String[])method.invoke(null, new Object[0]);
    }

    static DebugParagraph[] getParagraphs(Class clazz) throws Exception {
        DebugSMAPReader debugSMAPReader = DebugUtilities.getDSR(clazz);
        if (debugSMAPReader != null) {
            if (debugSMAPReader.getDbgParagraphs() != null) {
                return debugSMAPReader.getDbgParagraphs().toArray(new DebugParagraph[debugSMAPReader.getDbgParagraphs().size()]);
            }
            return null;
        }
        try {
            Method method = clazz.getMethod("get$DebugParagraphs", new Class[0]);
            return (DebugParagraph[])method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method method = clazz.getMethod("get$Paragraphs", new Class[0]);
            String[] stringArray = (String[])method.invoke(null, new Object[0]);
            DebugParagraph[] debugParagraphArray = new DebugParagraph[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i2]);
                debugParagraphArray[i2] = new DebugParagraph(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            return debugParagraphArray;
        }
    }

    static String[] getCompilerOptions(Class clazz) throws Exception {
        Field field = clazz.getField("$comp_flags$");
        return (String[])field.get(null);
    }

    static long getTimestamp(Class clazz) throws Exception {
        DebugSMAPReader debugSMAPReader = DebugUtilities.getDSR(clazz);
        if (debugSMAPReader != null) {
            return debugSMAPReader.getTimestamp();
        }
        Method method = clazz.getMethod("get$Timestamp", new Class[0]);
        return (Long)method.invoke(null, new Object[0]);
    }

    static String findConstant(String string, Object object, boolean bl) {
        DebugSMAPReader debugSMAPReader;
        Class<?> clazz = object.getClass();
        if (clazz.getEnclosingClass() == null) {
            DebugSMAPReader debugSMAPReader2 = DebugUtilities.getDSR(clazz);
            if (debugSMAPReader2 != null) {
                return DebugUtilities.findConstant(string, debugSMAPReader2.get_78Levels(), bl);
            }
            return DebugUtilities.findConstantOld(string, object, bl);
        }
        String string2 = DebugUtilities.findConstantOld(string, object, bl);
        if (string2 == null && (debugSMAPReader = DebugUtilities.getDSR(clazz.getEnclosingClass())) != null) {
            string2 = DebugUtilities.findConstant(string, debugSMAPReader.get_78Levels(), bl);
        }
        return string2;
    }

    private static String findConstant(String string, String[][] stringArray, boolean bl) {
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2][0].equalsIgnoreCase(string)) continue;
                String string2 = stringArray[i2][1];
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i3 = 0; i3 < string2.length(); i3 += 2) {
                        stringBuffer.append((char)Integer.parseInt(string2.substring(i3, i3 + 2), 16));
                    }
                    return stringBuffer.toString();
                }
                return string2;
            }
            return null;
        }
        return null;
    }

    private static String findConstantOld(String string, Object object, boolean bl) {
        String string2 = null;
        try {
            Method method = object.getClass().getMethod("get$Constants", new Class[0]);
            String string3 = (String)method.invoke(object, new Object[0]);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            while (stringTokenizer.hasMoreTokens() && string2 == null) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
                String string4 = stringTokenizer2.nextToken();
                if (!string4.equalsIgnoreCase(string)) continue;
                if (stringTokenizer2.hasMoreTokens()) {
                    String string5 = stringTokenizer2.nextToken();
                    if (bl) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i2 = 0; i2 < string5.length(); i2 += 2) {
                            stringBuffer.append((char)Integer.parseInt(string5.substring(i2, i2 + 2), 16));
                        }
                        string2 = stringBuffer.toString();
                        continue;
                    }
                    string2 = string5;
                    continue;
                }
                string2 = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    static DebugLine[] getLines(Class clazz) throws Exception {
        DebugSMAPReader debugSMAPReader = DebugUtilities.getDSR(clazz);
        if (debugSMAPReader != null) {
            if (debugSMAPReader.getDbgLines() != null) {
                return debugSMAPReader.getDbgLines().toArray(new DebugLine[debugSMAPReader.getDbgLines().size()]);
            }
            return null;
        }
        try {
            Method method = clazz.getMethod("get$DebugLines", new Class[0]);
            return (DebugLine[])method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method method = clazz.getMethod("get$Lines", new Class[0]);
            String[] stringArray = (String[])method.invoke(null, new Object[0]);
            DebugLine[] debugLineArray = new DebugLine[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i2]);
                debugLineArray[i2] = new DebugLine(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            return debugLineArray;
        }
    }

    static String getSourcefile(String string) throws Exception {
        return DebugUtilities.getSourcefile(DebugUtilities.classForName(string));
    }

    static String getSourcefile(Class clazz) throws Exception {
        DebugSMAPReader debugSMAPReader = DebugUtilities.getDSR(clazz);
        if (debugSMAPReader != null) {
            return debugSMAPReader.getSourceFileName();
        }
        Method method = clazz.getMethod("get$Sourcefile", new Class[0]);
        return (String)method.invoke(null, new Object[0]);
    }

    static String getCopyPath(Class clazz) throws Exception {
        Method method = clazz.getMethod("get$CopyPath", new Class[0]);
        return (String)method.invoke(null, new Object[0]);
    }

    static DebugCopyFile[] getCopyfiles(Class clazz) throws Exception {
        DebugSMAPReader debugSMAPReader = DebugUtilities.getDSR(clazz);
        if (debugSMAPReader != null) {
            if (debugSMAPReader.getCopyFiles() != null) {
                return debugSMAPReader.getCopyFiles().toArray(new DebugCopyFile[debugSMAPReader.getCopyFiles().size()]);
            }
            return null;
        }
        try {
            Method method = clazz.getMethod("get$DebugCopyfiles", new Class[0]);
            return (DebugCopyFile[])method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method method = clazz.getMethod("get$CopyfilesObj", new Class[0]);
                Object[][] objectArray = (Object[][])method.invoke(null, new Object[0]);
                DebugCopyFile[] debugCopyFileArray = new DebugCopyFile[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    debugCopyFileArray[i2] = new DebugCopyFile((String)objectArray[i2][0], (Integer)objectArray[i2][1], (String)objectArray[i2][2]);
                }
                return debugCopyFileArray;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                Method method = clazz.getMethod("get$Copyfiles", new Class[0]);
                String[] stringArray = (String[])method.invoke(null, new Object[0]);
                DebugCopyFile[] debugCopyFileArray = new DebugCopyFile[stringArray.length];
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i3]);
                    debugCopyFileArray[i3] = new DebugCopyFile(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), stringTokenizer.nextToken());
                }
                return debugCopyFileArray;
            }
        }
    }

    static int getVarType(Object object, IDebuggerHelper iDebuggerHelper) {
        if (object instanceof Level88) {
            return 12;
        }
        if (object instanceof BaseGUIControl) {
            return 15;
        }
        if (!(object instanceof ICobolVar)) {
            return 2;
        }
        ICobolVar iCobolVar = (ICobolVar)object;
        if (iDebuggerHelper.isNumericEdited(iCobolVar)) {
            return 8;
        }
        if (iDebuggerHelper.isBinary(iCobolVar)) {
            return 7;
        }
        if (iDebuggerHelper.isDecimalStorage(iCobolVar)) {
            return 4;
        }
        if (iDebuggerHelper.isPackedDecimalStorage(iCobolVar)) {
            return 5;
        }
        if (iDebuggerHelper.isAsciiStorage(iCobolVar)) {
            return 6;
        }
        if (iDebuggerHelper.isAlphanumeric(iCobolVar)) {
            return 3;
        }
        return 1;
    }

    static String buildValueString(Object object, int n2, int n3, int n4, int n5, IDebuggerHelper iDebuggerHelper) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = DebugUtilities.getVarType(object, iDebuggerHelper);
        stringBuffer.append(n6);
        stringBuffer.append("\u0001");
        if (!(object instanceof ICobolVar)) {
            stringBuffer.append("\u0001").append("\u0001");
            string = object != null ? object.toString() : DebuggerConstants.NULL_VALUE;
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            byte[] byArray;
            ICobolVar iCobolVar = (ICobolVar)object;
            stringBuffer.append(n2);
            stringBuffer.append("\u0001");
            try {
                byArray = iCobolVar.getBytes();
                n11 = iCobolVar.length();
                string = DebugUtilities.toString(iCobolVar);
            }
            catch (Exception exception) {
                byArray = new byte[1];
                n11 = 1;
                string = DebuggerConstants.NULL_VALUE;
            }
            if (n11 <= n3) {
                n10 = 0;
                n9 = n11;
            } else {
                n10 = Math.min(n4 - 1, n11 - n3);
                n9 = n3;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n8 = n10; n8 < n9; ++n8) {
                if (byArray[n8] >= 32 && byArray[n8] <= 126) {
                    stringBuffer2.append((char)byArray[n8]);
                    continue;
                }
                stringBuffer2.append(".");
            }
            n8 = n10 + n9;
            int n12 = n10;
            int n13 = 0;
            int n14 = 0;
            while (n12 < n8) {
                if (n13 % 16 == 0) {
                    StringBuffer stringBuffer3;
                    int n15;
                    if (n13 > 0) {
                        stringBuffer.append(" [");
                        stringBuffer.append(stringBuffer2.substring(n14, n13));
                        stringBuffer.append("]");
                        n14 = n13;
                    }
                    if (n13 > 0) {
                        stringBuffer.append(eol);
                    }
                    if ((n15 = (stringBuffer3 = new StringBuffer(DebugUtilities.dec2hex(n12, false))).length()) < 5) {
                        for (n7 = 0; n7 < 5 - n15; ++n7) {
                            stringBuffer3.insert(0, '0');
                        }
                    }
                    stringBuffer.append(stringBuffer3);
                    stringBuffer.append(":");
                }
                if (n13 % 4 == 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(DebugUtilities.dec2hex(byArray[n12] & 0xFF, true));
                ++n12;
                ++n13;
            }
            int n16 = n13 % 16;
            StringBuffer stringBuffer4 = new StringBuffer().append(stringBuffer2);
            if (n16 > 0) {
                n16 = 16 - n16;
                n7 = 0;
                while (n7 < n16) {
                    if (n13 % 4 == 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("--");
                    stringBuffer4.append("-");
                    ++n7;
                    ++n13;
                }
            }
            stringBuffer.append(" [");
            stringBuffer.append(stringBuffer4.substring(n14));
            stringBuffer.append("]");
            stringBuffer.append("\u0001");
        }
        if (string.length() > n5) {
            string = string.substring(0, n5);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String dec2hex(int n2, boolean bl) {
        String string = Long.toHexString(n2).toUpperCase();
        if (bl && string.length() % 2 == 1) {
            string = "0" + string;
        }
        return string;
    }

    public static boolean isGroupItem(int n2) {
        switch (n2) {
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static VarValue parseVarValue(String string) {
        VarValue varValue = new VarValue();
        if (string == null) {
            return varValue;
        }
        try {
            varValue.type = Integer.parseInt(string);
            return varValue;
        }
        catch (NumberFormatException numberFormatException) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0001", true);
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("\u0001")) {
                    varValue.type = 0;
                } else {
                    varValue.type = Integer.parseInt(string2);
                    stringTokenizer.nextToken();
                }
                string2 = stringTokenizer.nextToken();
                if (string2.equals("\u0001")) {
                    varValue.occurs = 0;
                } else {
                    varValue.occurs = Integer.parseInt(string2);
                    stringTokenizer.nextToken();
                }
                string2 = stringTokenizer.nextToken();
                if (string2.equals("\u0001")) {
                    varValue.hexDump = "";
                } else {
                    varValue.hexDump = string2;
                    stringTokenizer.nextToken();
                }
                varValue.textValue = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            }
            return varValue;
        }
    }

    public static int indexOfParagraph(int n2, boolean bl, DebugParagraph[] debugParagraphArray) {
        int n3 = 0;
        int n4 = debugParagraphArray.length - 1;
        int n5 = n3 + (n4 - n3) / 2;
        while (n3 <= n4) {
            int n6 = DebugUtilities.compare(n2, bl, debugParagraphArray[n5]);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n4 = n5 - 1;
            } else {
                n3 = n5 + 1;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return -1;
    }

    private static int compare(int n2, boolean bl, DebugParagraph debugParagraph) {
        if (bl == debugParagraph.isInDeclaratives()) {
            return n2 - debugParagraph.getParagraphNumber();
        }
        return bl ? -1 : 1;
    }

    public static Class classForNameNoInitialize(String string) throws ClassNotFoundException {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            classLoader = DebugUtilities.class.getClassLoader();
        }
        return Class.forName(string, false, classLoader);
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classLoader != null ? Class.forName(string, true, classLoader) : Class.forName(string);
    }

    static RepositoryEntry[] getRepositoryEntries(Class clazz) throws Exception {
        Method method = clazz.getMethod("get$RepEntries", new Class[0]);
        String[] stringArray = (String[])method.invoke(null, new Object[0]);
        RepositoryEntry[] repositoryEntryArray = new RepositoryEntry[stringArray.length];
        int n2 = 0;
        for (String string : stringArray) {
            String[] stringArray2 = string.split("\\,");
            repositoryEntryArray[n2++] = new RepositoryEntry(stringArray2[0], stringArray2[1], stringArray2[2]);
        }
        return repositoryEntryArray;
    }

    static DebugSMAPReader getDSR(Class clazz) {
        return DebugUtilities.getDSR(clazz, null);
    }

    static DebugSMAPReader getDSR(Class clazz, Throwable[] throwableArray) {
        DebugSMAPReader debugSMAPReader;
        block10: {
            if (smaps.containsKey(clazz)) {
                return smaps.get(clazz);
            }
            debugSMAPReader = null;
            boolean bl = false;
            String string = null;
            try {
                clazz.getMethod("get$Filenames", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = true;
                try {
                    string = (String)clazz.getField("$debugInfos$").get(null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (bl) {
                InputStream inputStream;
                String string2 = clazz.getName();
                int n2 = string2.lastIndexOf(46);
                if (n2 >= 0) {
                    string2 = string2.substring(n2 + 1);
                }
                if ((inputStream = clazz.getResourceAsStream(string2 = string2 + ".class")) != null) {
                    try {
                        debugSMAPReader = new DebugSMAPReader(inputStream, string);
                    }
                    catch (Exception exception) {
                        if (throwableArray == null) break block10;
                        throwableArray[0] = exception;
                    }
                }
            }
        }
        smaps.put(clazz, debugSMAPReader);
        return debugSMAPReader;
    }

    public static void setCompilerConsts(String[] stringArray, boolean bl) {
        if (!bl) {
            String[] stringArray2 = Config.e();
            Enumeration<?> enumeration = stringArray2.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("iscobol.compiler.") || string.startsWith("iscobol.compiler.license.")) continue;
                Config.d(string);
            }
        }
        for (String string : stringArray) {
            int n2 = string.indexOf(61);
            if (n2 < 0) continue;
            Config.b(string.substring(0, n2), string.substring(n2 + 1));
        }
    }

    public static int[] getDimensions(ICobolVar iCobolVar) {
        try {
            iCobolVar.getLastDimension();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iCobolVar.getDimensions();
    }

    public static ICobolVar getVar(ICobolVar iCobolVar, ICobolVar iCobolVar2, int n2) {
        ICobolVar iCobolVar3 = iCobolVar2.getIParent();
        if (iCobolVar3 == null) {
            return iCobolVar;
        }
        Vector<ICobolVar> vector = new Vector<ICobolVar>();
        while (iCobolVar3 != null) {
            vector.addElement(iCobolVar3);
            iCobolVar3 = iCobolVar3.getIParent();
        }
        ICobolVar iCobolVar4 = (ICobolVar)vector.lastElement();
        if (iCobolVar4.length() == iCobolVar4.getMaxLength()) {
            return iCobolVar;
        }
        int n3 = DebugUtilities.getDependingDelta(iCobolVar4.getChildren(), vector, iCobolVar2);
        if (n3 > 0) {
            return iCobolVar2.intIOffs(n2 - n3);
        }
        return iCobolVar2;
    }

    private static int getDependingDelta(Enumeration enumeration, Vector<ICobolVar> vector, ICobolVar iCobolVar) {
        ICobolVar iCobolVar2;
        int n2 = 0;
        while (enumeration.hasMoreElements() && (iCobolVar2 = (ICobolVar)enumeration.nextElement()) != iCobolVar) {
            if (DebugUtilities.contains(vector, iCobolVar2)) {
                n2 += DebugUtilities.getDependingDelta(iCobolVar2.getChildren(), vector, iCobolVar);
                break;
            }
            if (iCobolVar2.getDependingOn() != null) {
                n2 += iCobolVar2.getDependingDelta();
                continue;
            }
            n2 += iCobolVar2.getMaxLength() - iCobolVar2.length();
        }
        return n2;
    }

    private static <T> boolean contains(List<T> list, T t2) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (list.get(i2) != t2) continue;
            return true;
        }
        return false;
    }

    private static class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }

    public static class VarValue
    implements IVarValue {
        public static final int GROUP_TYPE = 1;
        public static final int OBJECT_REFERENCE_TYPE = 2;
        public static final int ALPHANUMERIC_TYPE = 3;
        public static final int DECIMAL_STORAGE_TYPE = 4;
        public static final int PACKED_DECIMAL_STORAGE_TYPE = 5;
        public static final int ASCII_STORAGE_TYPE = 6;
        public static final int BINARY_TYPE = 7;
        public static final int NUMERIC_EDITED_TYPE = 8;
        public static final int WORKING_STORAGE_TYPE = 9;
        public static final int LINKAGE_TYPE = 10;
        public static final int FILE_TYPE = 11;
        public static final int _88_LEVEL_TYPE = 12;
        public static final int FILE_DESCRIPTOR_TYPE = 13;
        public static final int CONST_TYPE = 14;
        public static final int GRAPHICAL_TYPE = 15;
        public static final String SEPARATOR = "\u0001";
        public int type;
        public int occurs;
        public String hexDump = "";
        public String textValue = "";

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getOccurs() {
            return this.occurs;
        }

        @Override
        public String getHexDump() {
            return this.hexDump;
        }

        @Override
        public String getTextValue() {
            return this.textValue;
        }
    }
}

