/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.BreakpointManager;
import com.iscobol.debugger.CommandListener;
import com.iscobol.debugger.Condition;
import com.iscobol.debugger.ConnectionListener;
import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugFieldWrapper;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugOutputStream;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugSMAPReader;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.IscobolDebugger;
import com.iscobol.debugger.IscobolDebuggerExtension;
import com.iscobol.debugger.Level88;
import com.iscobol.debugger.MethodObject;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.RepositoryEntry;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.EnvCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.GetVariablesCommand;
import com.iscobol.debugger.commands.JumpCommand;
import com.iscobol.debugger.commands.LengthCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.OffsetCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetMonitorCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.commands.StepIntoCommand;
import com.iscobol.debugger.commands.StepToCommand;
import com.iscobol.debugger.commands.StepToNextProgramCommand;
import com.iscobol.debugger.commands.ThreadCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.io.CobolFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.GotoException;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IDebuggerHelper;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolClass;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MonitorNotifier;
import com.iscobol.rts.NewRunUnitException;
import com.iscobol.rts.StopRunException;
import com.iscobol.rts.Version;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class Debugger {
    public static final String eol = System.getProperty("line.separator", "\n");
    static final Object NULL_OBJECT = new String("<null>");
    private static final InputStream systemIn = System.in;
    private static final PrintStream systemOut = System.out;
    private static final PrintStream systemErr = System.err;
    private static InputStream debugIn = systemIn;
    private static PrintStream debugOut = systemOut;
    private static PrintStream debugErr = systemErr;
    private static DataInputStream debugDataIn;
    private static DataOutputStream debugDataOut;
    private static CommandListener commandListener;
    private static boolean redirectStreams;
    private static int blockingMode;
    private static boolean firstBlock;
    private static ConnectionListener connList;
    private static String[] programArgs;
    private static Debugger activeDebugger;
    private static GlobalStatus globalStatus;
    private static boolean firstProcess;
    private static boolean[] firstWrite;
    private static Hashtable debuggerInstances;
    private static boolean doNotify;
    private static Vector deferredDisplayCommands;
    private static Map<Class, String[]> classLocations;
    private static int lastCmd;
    private static boolean isCompositeCmd;
    private static VarName dbgVar;
    private static String dbgEnvValue;
    private static DebugResponse.DebugInfo debugInfo;
    private static Vector tree;
    private static int returnCode;
    private int status = 0;
    private ByteArrayOutputStream response = new ByteArrayOutputStream();
    private PrintStream out;
    private Stack<ParagraphObject> parStack = new Stack();
    private Stack progStack = new Stack();
    private Stack<MethodObject> methodStack = new Stack();
    private boolean blockDebugger;
    private int currLine = 1;
    private String currFile = "";
    private int currFileIndex = -1;
    private int oldLine = 1;
    private int oldFileIndex;
    private String oldFile = "";
    private Class oldProgramClass;
    private Class currProgramClass;
    private char hyphenRepl = (char)95;
    private boolean cod1;
    private String currProgramClassLocation;
    private Object theProgramObj;
    private Object theMethodObj;
    private Object currProgram;
    private Class currMethodClass;
    private Object currMethod;
    private String currMethodName;
    private int intoDeep;
    private int intoDeepPrg;
    private int lastPerformParnum;
    private int stepNumber = 1;
    private ThreadObject threadObj;
    private final AppData appData;

    private void createOutStream() {
        try {
            this.out = new PrintStream((OutputStream)this.response, false, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.out = new PrintStream(this.response);
        }
    }

    private String getResponse() {
        try {
            return this.response.toString("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.response.toString();
        }
    }

    private static AppData getAppData() {
        AppData appData = (AppData)IscobolSystem.get(AppData.class);
        if (appData == null) {
            appData = new AppData();
            appData.parStackLog = LoggerFactory.get(4);
            appData.fileLoader = new FileLoader();
            LoggerFactory.addPropertyChangeListener(appData);
            IscobolSystem.set(AppData.class, appData);
        }
        return appData;
    }

    public Debugger(String string) {
        this();
        this.currFile = string;
    }

    public Debugger() {
        this.appData = Debugger.getAppData();
        this.createOutStream();
    }

    public Debugger(Debugger debugger) {
        this.appData = debugger.appData;
        this.createOutStream();
        this.currProgramClass = debugger.currProgramClass;
        this.hyphenRepl = debugger.hyphenRepl;
        this.cod1 = debugger.cod1;
        this.currProgramClassLocation = debugger.currProgramClassLocation;
        this.currMethodClass = debugger.currMethodClass;
        this.updateMethodObj(debugger.currMethod);
        this.currMethod = debugger.currMethod;
        this.currMethodName = debugger.currMethodName;
        this.updateProgramObj(debugger.currProgram);
        this.currProgram = debugger.currProgram;
    }

    IDebuggerHelper getHelper() {
        return DebugUtilities.getHelper(this.getCurrClass());
    }

    public static IDebuggerHelper getHelper(Class clazz) {
        return DebugUtilities.getHelper(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String string, String[] stringArray) {
        Object object;
        Class clazz;
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        try {
            clazz = Debugger.classForName(string, null);
            if (!DebuggerConstants.DEBUGGER_CLASS.isAssignableFrom(clazz)) {
                string2 = clazz.getName();
                string3 = "+ Warning: class '" + clazz.getName() + "' has not debugging informations";
                n2 = 203;
            }
        }
        catch (Exception exception) {
            Object var2_6 = null;
            string3 = "Cannot load class '" + string + "'";
            Debugger.writeResponse(new DebugResponse(201, string3));
            return;
        }
        Method method = null;
        if (!DebuggerConstants.CALL_CLASS.isAssignableFrom(clazz)) {
            object = new Class[]{new String[0].getClass()};
            try {
                method = clazz.getMethod("main", (Class<?>)object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                string3 = "Invalid class '" + string + "'";
                Debugger.writeResponse(new DebugResponse(202, string3));
                return;
            }
        }
        activeDebugger = new Debugger(string2);
        Debugger.activeDebugger.threadObj = ThreadObject.getIscobolThreadObject(Thread.currentThread());
        Debugger.activeDebugger.status = 3;
        Debugger.activeDebugger.stepNumber = 1;
        debuggerInstances.put(Thread.currentThread(), activeDebugger);
        activeDebugger.setCurrProgramClass(clazz);
        Debugger.activeDebugger.response.reset();
        object = new DebugResponse(n2, string3);
        ((DebugResponse)object).setInfo(Debugger.getInfo(991, clazz));
        if (((DebugResponse)object).getInfo().getErrorString() != null) {
            ((DebugResponse)object).setReturnCode(1);
        }
        Debugger.writeResponse((DebugResponse)object);
        try {
            activeDebugger.process();
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
        if (method != null) {
            try {
                try {
                    method.invoke(null, new Object[]{programArgs});
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable != null) {
                        throw throwable;
                    }
                    throw invocationTargetException;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            IscobolCall iscobolCall = null;
            try {
                iscobolCall = (IscobolCall)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object[] objectArray = Factory.setCommandLineArgs(iscobolCall, programArgs);
            IDebuggerHelper iDebuggerHelper = DebugUtilities.getHelper(clazz);
            Object[] objectArray2 = programArgs;
            try {
                Logger logger = LoggerFactory.get(2);
                while (true) {
                    try {
                        activeDebugger.updateProgramObj(iscobolCall);
                        Debugger.activeDebugger.currProgram = iscobolCall;
                        IscobolCall iscobolCall2 = iDebuggerHelper.activeCallsPush(iscobolCall, objectArray2);
                        if (logger != null) {
                            logger.info("ENTER PROGRAM '" + string + "' {");
                        }
                        ICobolVar iCobolVar = (ICobolVar)iscobolCall2.call(objectArray);
                        iDebuggerHelper.stopRun(iCobolVar.toint());
                        Debugger.writeResponse(new DebugResponse(103, ""));
                    }
                    catch (NewRunUnitException newRunUnitException) {
                        iDebuggerHelper.activeCallsPop();
                        iscobolCall = newRunUnitException.call;
                        objectArray2 = newRunUnitException.argv;
                        objectArray = newRunUnitException.argv;
                        continue;
                    }
                    finally {
                        if (logger == null) continue;
                        logger.info("EXIT PROGRAM '" + string + "' }");
                        continue;
                    }
                    break;
                }
            }
            catch (StopRunException stopRunException) {
                Debugger.writeResponse(new DebugResponse(103, ""));
            }
            catch (Throwable throwable) {
                Debugger.unexpectedException(throwable);
            }
        }
    }

    private static DebugResponse.DebugInfo checkVersion(Class clazz) {
        String string = DebuggerException.getFormattedInfoMessage(5, clazz.getName());
        if (IscobolClass.class.isAssignableFrom(clazz)) {
            try {
                IscobolClass iscobolClass = (IscobolClass)clazz.newInstance();
                try {
                    Version.checkVersion(iscobolClass);
                }
                catch (IscobolRuntimeException iscobolRuntimeException) {
                    string = iscobolRuntimeException.getMessage();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DebugResponse.DebugInfo(string);
    }

    public static void unexpectedException(Throwable throwable) {
        long l2;
        String string;
        Object object;
        if (globalStatus.getValue() == 0) {
            return;
        }
        Debugger debugger = Debugger.getCurrentDebugger();
        IDebuggerHelper iDebuggerHelper = debugger.getHelper();
        try {
            iDebuggerHelper.callErrorProc(throwable);
        }
        catch (Exception exception) {
            Debugger.unexpectedException(exception);
            return;
        }
        iDebuggerHelper.layoutExceptionCobol(throwable);
        int n2 = debugger.currLine;
        int n3 = debugger.currFileIndex;
        if (!debugger.parStack.empty()) {
            object = debugger.parStack.peek();
            string = object.getName();
        } else {
            string = "";
            try {
                object = DebugUtilities.getParagraphs(debugger.oldProgramClass);
                for (int i2 = ((DebugParagraph[])object).length - 1; i2 >= 0; --i2) {
                    if (object[i2].getFileIndex() != n3 || object[i2].getLineNumber() >= n2) continue;
                    string = object[i2].getParagraphName();
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = "- Exception caught at line: " + n2 + ", file: " + Debugger.getFilename(debugger.currFile) + ", paragraph: '" + string + "' (" + throwable + ")";
        try {
            l2 = DebugUtilities.getTimestamp(debugger.currProgramClass);
        }
        catch (Exception exception) {
            l2 = 0L;
        }
        DebugResponse debugResponse = new DebugResponse(104, debugger.currLine, null, null, null, -1, 0L, 0L, debugger.currFile, debugger.currFileIndex, debugger.currFile, l2, -1, null, (Tree[])null, (String)object);
        if (debugger.oldProgramClass != null) {
            DebugResponse.DebugInfo debugInfo = Debugger.getInfo(991, debugger.oldProgramClass);
            debugResponse.setInfo(debugInfo);
        }
        Debugger.writeResponse(debugResponse);
    }

    public static void activeRemoteDebugging() {
        if (globalStatus.getWait() && globalStatus.getValue() == 3) {
            Debugger.waitForConnection();
            globalStatus.setWait(false);
        }
    }

    public static void startListener(int n2, int n3, boolean bl) {
        Debugger.startListener(n2, n3, bl, true, 0);
    }

    public static void startListener(int n2, int n3, boolean bl, boolean bl2) {
        Debugger.startListener(n2, n3, bl, bl2, 0);
    }

    public static void startListener(int n2, int n3, boolean bl, boolean bl2, int n4) {
        if ((n2 == 1 || n2 == 2) && connList == null) {
            redirectStreams = bl;
            blockingMode = n4;
            connList = new ConnectionListener(n3, bl2);
            connList.start();
            globalStatus.setValue(3);
            if (n2 == 2) {
                globalStatus.setWait(true);
            }
        }
    }

    public static void stopListener(boolean bl) {
        if (connList != null) {
            redirectStreams = true;
            blockingMode = 0;
            firstBlock = false;
            connList.stop(bl);
            connList = null;
            activeDebugger = null;
            globalStatus.setValue(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForConnection() {
        doNotify = true;
        ConnectionListener connectionListener = connList;
        synchronized (connectionListener) {
            try {
                connList.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Debugger getCurrentDebugger() {
        Debugger debugger = null;
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            int n2;
            debugger = (Debugger)debuggerInstances.get(Thread.currentThread());
            if (debugger == null) {
                debugger = new Debugger();
                int n3 = globalStatus.getValue();
                if (n3 != 0) {
                    ThreadObject threadObject = null;
                    if (activeDebugger == null) {
                        threadObject = ThreadObject.getIscobolThreadObject(Thread.currentThread());
                        activeDebugger = debugger;
                    } else {
                        threadObject = ThreadObject.getJavaThreadObject(Thread.currentThread());
                    }
                    debugger.threadObj = threadObject;
                    if (n3 != 3) {
                        Debugger.pruneDeathThreads();
                        if (debuggerInstances.size() == 0) {
                            debugger.status = n3 == 4 && blockingMode == 1 ? 4 : 1;
                            activeDebugger = debugger;
                        } else {
                            debugger.status = 4;
                        }
                        debugger.stepNumber = 1;
                    }
                }
                debuggerInstances.put(Thread.currentThread(), debugger);
            } else if (debugger.threadObj == null && (n2 = globalStatus.getValue()) != 0) {
                ThreadObject threadObject = null;
                if (activeDebugger == null) {
                    threadObject = ThreadObject.getIscobolThreadObject(Thread.currentThread());
                    activeDebugger = debugger;
                } else {
                    threadObject = ThreadObject.getJavaThreadObject(Thread.currentThread());
                }
                debugger.threadObj = threadObject;
            }
        }
        return debugger;
    }

    static void writeResponse(DebugResponse debugResponse) {
        DebugUtilities.writeResponse(debugResponse, debugDataOut, firstWrite);
    }

    /*
     * Exception decompiling
     */
    private boolean process() throws GotoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean processCommand(DebugCommand debugCommand, boolean[] blArray) throws GotoException {
        boolean bl = false;
        try {
            lastCmd = debugCommand.getId();
            switch (lastCmd) {
                case -1: {
                    break;
                }
                case 57: {
                    Debugger.setRedirectStreams(((SetRedirectStreamsCommand)debugCommand).getValue());
                    returnCode = 0;
                    break;
                }
                case 43: {
                    this.out.print(this.getVariables((GetVariablesCommand)debugCommand));
                    break;
                }
                case 2: {
                    String string = this.run((RunCommand)debugCommand);
                    bl = true;
                    break;
                }
                case 0: {
                    this.out.print(Debugger.setBreakpoint((SetBreakpointCommand)debugCommand, this.currFile, this.currFileIndex, this));
                    break;
                }
                case 9: {
                    this.out.print(Debugger.clearBreakpoint((ClearBreakpointCommand)debugCommand, this.currFile, this.currFileIndex));
                    break;
                }
                case 1: {
                    String string = this.Continue();
                    if (!string.equals("")) {
                        this.out.print(string);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 3: {
                    String string = this.stepInto((StepIntoCommand)debugCommand);
                    if (!string.equals("")) {
                        this.out.print(string);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 4: {
                    String string = this.stepOver();
                    if (!string.equals("")) {
                        this.out.print(string);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 16: {
                    ThreadCommand threadCommand = (ThreadCommand)debugCommand;
                    String string = this.switchThread(threadCommand);
                    if (returnCode != 0 || threadCommand.isListing()) {
                        this.out.print(string);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 24: {
                    this.out.print(this.gc());
                    break;
                }
                case 25: {
                    this.out.print(this.memory());
                    break;
                }
                case 26: {
                    this.out.print(this.env((EnvCommand)debugCommand));
                    break;
                }
                case 17: {
                    this.out.print(this.traceOn((TraceOnCommand)debugCommand));
                    break;
                }
                case 18: {
                    this.out.print(this.traceOff());
                    break;
                }
                case 19: {
                    this.out.print(Debugger.setProgramBreakpoint((ProgramBreakpointCommand)debugCommand, this));
                    break;
                }
                case 52: {
                    this.out.print(Debugger.setMethodBreakpoint((MethodBreakpointCommand)debugCommand, this));
                    break;
                }
                case 5: {
                    this.out.print(this.display((DisplayCommand)debugCommand));
                    break;
                }
                case 6: {
                    this.out.print(this.let((LetCommand)debugCommand));
                    break;
                }
                case 10: {
                    String string = this.stepOutOfParagraph();
                    if (!string.equals("")) {
                        this.out.print(string);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 11: {
                    String string = this.stepOutOfProgram();
                    if (!string.equals("")) {
                        this.out.print(string);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 12: {
                    String string = this.stepToLine((StepToCommand)debugCommand);
                    if (!string.equals("")) {
                        this.out.print(string);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 56: {
                    String string = this.stepToProgram((StepToNextProgramCommand)debugCommand);
                    if (!string.equals("")) {
                        this.out.print(string);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 29: {
                    this.jumpToLine((JumpCommand)debugCommand);
                    bl = true;
                    blArray[0] = false;
                    break;
                }
                case 13: {
                    this.out.print(this.setMonitor((SetMonitorCommand)debugCommand));
                    break;
                }
                case 14: {
                    this.out.print(this.clearMonitor((ClearMonitorCommand)debugCommand));
                    break;
                }
                case 54: {
                    this.out.print(this.length((LengthCommand)debugCommand));
                    break;
                }
                case 55: {
                    this.out.print(this.offset((OffsetCommand)debugCommand));
                    break;
                }
                case 23: {
                    returnCode = 0;
                    break;
                }
                case 30: {
                    this.getInfo((GetInfoCommand)debugCommand);
                    break;
                }
                default: {
                    throw new DebuggerException(26);
                }
            }
        }
        catch (DebuggerException debuggerException) {
            returnCode = debuggerException.getErrorId();
            this.out.println(debuggerException.getMessage());
        }
        return bl;
    }

    static InputStream getDebugIn() {
        return debugIn;
    }

    private static DebugCommand acceptCommand() {
        return commandListener.getDebugCommand();
    }

    private boolean[] disableAllWindows(Vector vector) {
        DisplayWindow displayWindow;
        int n2;
        vector.addAll(ScrFactory.getGUIEnviroment().getWindowList());
        int n3 = vector.size();
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            displayWindow = (DisplayWindow)vector.elementAt(n2);
            try {
                if (displayWindow.getComponent() == null) continue;
                blArray[n2] = displayWindow.getComponent().isEnabled();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            displayWindow = (DisplayWindow)vector.elementAt(n2);
            try {
                if (displayWindow.getComponent() == null) continue;
                displayWindow.getComponent().setProperty(-1, "_debug_window_enabled", Boolean.FALSE);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return blArray;
    }

    private void restoreAllWindows(boolean[] blArray, Vector vector) {
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DisplayWindow displayWindow = (DisplayWindow)vector.elementAt(i2);
            try {
                if (displayWindow.getComponent() == null) continue;
                displayWindow.getComponent().setProperty(-1, "_debug_window_enabled", blArray[i2]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean debug(String string) throws GotoException {
        int n2;
        boolean bl = true;
        if (this != activeDebugger) {
            while (globalStatus.getValue() == 1) {
                GlobalStatus globalStatus = Debugger.globalStatus;
                synchronized (globalStatus) {
                    try {
                        Debugger.globalStatus.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((n2 = globalStatus.mustSuspend()) == 2) {
            this.getHelper().stopRun(0);
        } else if (n2 == 1) {
            this.status = 1;
            this.stepNumber = 1;
        }
        switch (this.status) {
            default: {
                break;
            }
            case 8: {
                if (this.checkJumppoint(string)) {
                    bl = this.process();
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (string != null) break;
                --this.stepNumber;
                if (this.stepNumber == 0) {
                    this.checkBreakMonitors();
                    bl = this.process();
                    break;
                }
                if (!this.checkBreakMonitors() && !this.checkBreakpoint(string)) break;
                bl = this.process();
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                if (this.blockDebugger) {
                    bl = this.process();
                    break;
                }
                bl = false;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                if (!this.checkBreakMonitors() && !this.blockDebugger && !this.checkBreakpoint(string)) break;
                bl = this.process();
                break;
            }
            case 4: {
                if (!this.checkBreakMonitors() && !this.checkBreakpoint(string)) break;
                bl = this.process();
                break;
            }
            case 7: {
                if (!this.checkBreakMonitors() && !this.checkTempBreakpoint() && !this.checkBreakpoint(string)) break;
                bl = this.process();
            }
        }
        return bl;
    }

    protected Class getCurrClass() {
        Class<Object> clazz = this.currProgramClass != null ? this.currProgramClass : (!this.progStack.isEmpty() ? this.progStack.peek().getClass() : null);
        return clazz;
    }

    private String getCurrClassname() {
        String string = this.currMethodName != null ? this.currProgramClass.getName() + ":>" + this.currMethodName : (this.currMethodClass != null ? this.currMethodClass.getName() : this.currProgramClass.getName());
        return string;
    }

    protected Object getProgramObject() {
        return this.theProgramObj;
    }

    protected Object getMethodObject() {
        return this.theMethodObj;
    }

    protected Object getCurrProgram() {
        return this.currProgram;
    }

    protected Object getCurrMethod() {
        return this.currMethod;
    }

    protected Class getCurrProgramClass() {
        return this.currProgramClass;
    }

    protected Class getCurrMethodClass() {
        return this.currMethodClass;
    }

    private boolean checkBreakMonitors() {
        Watch[] watchArray = BreakpointManager.checkBreakMonitors(this.getCurrClassname(), this);
        if (watchArray != null && watchArray.length > 0) {
            dbgVar = new VarName();
            dbgVar.setFullName(watchArray[0].getFullName());
            dbgVar.setValue(watchArray[0].getValue());
            returnCode = 102;
            String string = "";
            for (int i2 = 0; i2 < watchArray.length; ++i2) {
                string = string + eol + watchArray[i2];
            }
            this.out.println(DebuggerException.getInfoMessage(1, string));
            return true;
        }
        return false;
    }

    private boolean checkBreakpoint(String string) {
        String string2 = this.currProgramClass.getName();
        if (string != null && BreakpointManager.checkBreakpoint(string, this.currFile, string2, this) || BreakpointManager.checkBreakpoint(this.currLine, this.currFile, this.currFileIndex, string2, this)) {
            returnCode = 101;
            if (string != null) {
                this.out.println(DebuggerException.getInfoMessage(2, string + ", file " + Debugger.getFilename(this.currFile)));
            } else {
                this.out.println(DebuggerException.getInfoMessage(3, this.currLine + ", file " + Debugger.getFilename(this.currFile)));
            }
            return true;
        }
        return false;
    }

    private boolean checkJumppoint(String string) {
        return string != null && BreakpointManager.checkJumppoint(string, this.currFile) || BreakpointManager.checkJumppoint(this.currLine, this.currFile, this.currFileIndex);
    }

    private boolean checkTempBreakpoint() {
        if (BreakpointManager.checkTempBreakpoint(this.currLine, this.currFile, this.currFileIndex)) {
            returnCode = 101;
            this.out.println(DebuggerException.getInfoMessage(3, this.currLine + ", file " + Debugger.getFilename(this.currFile)));
            return true;
        }
        return false;
    }

    private String gc() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Runtime.getRuntime().gc();
        returnCode = 0;
        return DebuggerException.getInfoMessage(4, eol);
    }

    private String memory() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Runtime.getRuntime().gc();
        returnCode = 0;
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = runtime.freeMemory();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("+ ");
        stringBuffer.append("Total memory: " + l2 + " bytes" + eol);
        stringBuffer.append("   Used memory: " + (l2 - l3) + " bytes" + eol);
        stringBuffer.append("   Free memory: " + Runtime.getRuntime().freeMemory() + " bytes" + eol);
        return stringBuffer.toString();
    }

    private String env(EnvCommand envCommand) throws DebuggerException {
        return this.env(envCommand.getEnvName(), false);
    }

    private String env(String string, boolean bl) throws DebuggerException {
        String string2 = string.trim().toLowerCase().replace('-', '_');
        String string3 = Config.a() + string2;
        String string4 = Config.a(string3, Config.f(string3), null);
        if (string4 == null) {
            string4 = System.getProperty(string2);
        }
        if (string4 != null) {
            if (bl) {
                byte[] byArray;
                try {
                    byArray = string4.getBytes(CobolVar.encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string4.getBytes();
                }
                string4 = DebugUtilities.toHexString(byArray, -1, DebugUtilities.MAX_DISPLAY_LENGTH());
            }
            returnCode = 0;
            dbgEnvValue = string4;
            return "+ " + string + " = " + string4 + eol;
        }
        throw new DebuggerException(27, "'" + string + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String switchThread(ThreadCommand threadCommand) throws DebuggerException {
        int n2;
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        String string = threadCommand.getThreadName();
        if (threadCommand.isListing()) {
            returnCode = 0;
            return this.listThreads();
        }
        if (string.equalsIgnoreCase(Debugger.activeDebugger.threadObj.getName())) {
            throw new DebuggerException();
        }
        ThreadObject[] threadObjectArray = Debugger.getThreads(false, null);
        for (n2 = 0; n2 < threadObjectArray.length && !threadObjectArray[n2].getName().equalsIgnoreCase(string); ++n2) {
        }
        if (n2 == threadObjectArray.length) {
            throw new DebuggerException(19, "'" + string + "'");
        }
        this.status = 4;
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            activeDebugger = (Debugger)debuggerInstances.get(threadObjectArray[n2].getThread());
        }
        Debugger.activeDebugger.status = 1;
        Debugger.activeDebugger.stepNumber = 1;
        this.stepNumber = 1;
        returnCode = 0;
        return "";
    }

    private void jumpToLine(JumpCommand jumpCommand) throws DebuggerException, GotoException {
        DebugParagraph[] debugParagraphArray;
        String[] stringArray;
        DebugLine[] debugLineArray;
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        if (!IscobolDebuggerExtension.class.isAssignableFrom(this.currProgramClass)) {
            throw new DebuggerException(36);
        }
        if (jumpCommand.getType() != 0) {
            this.blockDebugger = false;
            if (jumpCommand.isJumpOutParagraph()) {
                this.status = 9;
                this.intoDeep = this.parStack.size();
            } else if (jumpCommand.isJumpOutProgram()) {
                this.status = 10;
                this.intoDeepPrg = this.getModuleStackSize();
            } else if (jumpCommand.isJumpNext()) {
                this.intoDeep = this.parStack.size();
                this.intoDeepPrg = this.getModuleStackSize();
                this.status = 12;
            }
            this.stepNumber = 1;
            returnCode = 0;
            return;
        }
        try {
            debugLineArray = DebugUtilities.getLines(this.currProgramClass);
        }
        catch (Exception exception) {
            debugLineArray = null;
        }
        if (debugLineArray == null) {
            throw new DebuggerException(36);
        }
        try {
            stringArray = DebugUtilities.getFilenames(this.currProgramClass);
        }
        catch (Exception exception) {
            stringArray = null;
        }
        if (stringArray == null) {
            throw new DebuggerException(36);
        }
        try {
            debugParagraphArray = DebugUtilities.getParagraphs(this.currProgramClass);
        }
        catch (Exception exception) {
            debugParagraphArray = null;
        }
        if (debugParagraphArray == null) {
            throw new DebuggerException(36);
        }
        boolean bl = this.parStack.peek().isDeclaratives();
        int n2 = jumpCommand.getLineNumber();
        int n3 = 0;
        if (n2 > 0) {
            int n4;
            String string;
            int n5 = -1;
            if (jumpCommand.getFilename() != null) {
                string = jumpCommand.getFilename();
                if (jumpCommand.getFileIndex() >= 0) {
                    n5 = jumpCommand.getFileIndex();
                } else {
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        if (!stringArray[n4].equalsIgnoreCase(string)) continue;
                        n5 = n4;
                        break;
                    }
                    if (n5 < 0) {
                        n5 = this.currFileIndex;
                    }
                }
            } else {
                string = Debugger.getFilename(this.currFile);
                n5 = this.currFileIndex;
            }
            block7: for (n4 = 0; n4 < debugLineArray.length; ++n4) {
                int n6;
                int n7 = debugLineArray[n4].getLineNumber();
                int n8 = debugLineArray[n4].getFileIndex();
                if (n2 != n7 || n5 != n8) continue;
                if (debugLineArray[n4].getParagraphId() > 0) {
                    for (n6 = 0; n6 < debugParagraphArray.length; ++n6) {
                        if (debugParagraphArray[n6].getParagraphNumber() != debugLineArray[n4].getParagraphId() || debugParagraphArray[n6].isInDeclaratives() != debugLineArray[n4].isInDeclaratives()) continue;
                        if (debugParagraphArray[n6].isInDeclaratives() == bl) {
                            n3 = debugParagraphArray[n6].getParagraphNumber();
                            BreakpointManager.addJumppoint(n2, string, n5);
                            break;
                        }
                        if (bl) {
                            throw new DebuggerException(38);
                        }
                        throw new DebuggerException(37);
                    }
                    if (n3 != 0) break;
                    throw new DebuggerException(2);
                }
                for (n6 = n4 - 1; n6 >= 0; --n6) {
                    if (debugLineArray[n6].getParagraphId() <= 0) continue;
                    for (int i2 = 0; i2 < debugParagraphArray.length; ++i2) {
                        if (debugParagraphArray[i2].getParagraphNumber() != debugLineArray[n6].getParagraphId() || debugParagraphArray[i2].isInDeclaratives() != debugLineArray[n6].isInDeclaratives()) continue;
                        if (debugParagraphArray[i2].isInDeclaratives() == bl) {
                            n3 = debugParagraphArray[i2].getParagraphNumber();
                            BreakpointManager.addJumppoint(debugLineArray[n6].getLineNumber(), stringArray[debugLineArray[n6].getFileIndex()], debugLineArray[n6].getFileIndex());
                            this.out.println(DebuggerException.getInfoMessage(20, null));
                            break;
                        }
                        if (bl) {
                            throw new DebuggerException(38);
                        }
                        throw new DebuggerException(37);
                    }
                    if (n3 != 0) break block7;
                    throw new DebuggerException(2);
                }
                break;
            }
            if (n3 == 0) {
                for (n4 = 0; n4 < debugParagraphArray.length; ++n4) {
                    if (debugParagraphArray[n4].getLineNumber() != n2 || debugParagraphArray[n4].getFileIndex() != n5) continue;
                    if (debugParagraphArray[n4].isInDeclaratives() == bl) {
                        n3 = debugParagraphArray[n4].getParagraphNumber();
                        BreakpointManager.addJumppoint(debugParagraphArray[n4].getParagraphName(), stringArray[debugParagraphArray[n4].getFileIndex()]);
                        break;
                    }
                    if (bl) {
                        throw new DebuggerException(38);
                    }
                    throw new DebuggerException(37);
                }
                if (n3 == 0) {
                    throw new DebuggerException(2);
                }
            }
        } else {
            String string = jumpCommand.getParagraphName();
            for (int i3 = 0; i3 < debugParagraphArray.length; ++i3) {
                if (!debugParagraphArray[i3].getParagraphName().equalsIgnoreCase(string)) continue;
                if (debugParagraphArray[i3].isInDeclaratives() == bl) {
                    n3 = debugParagraphArray[i3].getParagraphNumber();
                    BreakpointManager.addJumppoint(debugParagraphArray[i3].getParagraphName(), stringArray[debugParagraphArray[i3].getFileIndex()]);
                    break;
                }
                if (bl) {
                    throw new DebuggerException(38);
                }
                throw new DebuggerException(37);
            }
            if (n3 == 0) {
                throw new DebuggerException(3);
            }
        }
        this.status = 8;
        this.stepNumber = 1;
        returnCode = 0;
        Debugger.exitPar();
        throw new GotoException(n3);
    }

    private String stepToProgram(StepToNextProgramCommand stepToNextProgramCommand) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.stepNumber = 1;
        this.blockDebugger = false;
        this.status = 11;
        returnCode = 0;
        return "";
    }

    private String stepToLine(StepToCommand stepToCommand) throws DebuggerException {
        String[] stringArray;
        DebugLine[] debugLineArray;
        int n2;
        String string;
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        int n3 = stepToCommand.getLineNumber();
        if (stepToCommand.getFilename() != null) {
            string = stepToCommand.getFilename();
            n2 = stepToCommand.getFileIndex();
        } else {
            string = Debugger.getFilename(this.currFile);
            n2 = this.currFileIndex;
        }
        try {
            debugLineArray = DebugUtilities.getLines(this.currProgramClass);
        }
        catch (Exception exception) {
            debugLineArray = null;
        }
        if (debugLineArray == null) {
            returnCode = 203;
            return DebuggerException.getFormattedInfoMessage(5, this.currProgramClass.getName()) + eol;
        }
        try {
            stringArray = DebugUtilities.getFilenames(this.currProgramClass);
        }
        catch (Exception exception) {
            stringArray = null;
        }
        if (stringArray == null) {
            returnCode = 203;
            return DebuggerException.getInfoMessage(5, "'" + this.currProgramClass.getName() + "'" + eol);
        }
        boolean bl = false;
        Filename filename = new Filename(string);
        for (int i2 = 0; i2 < debugLineArray.length; ++i2) {
            int n4 = debugLineArray[i2].getLineNumber();
            int n5 = debugLineArray[i2].getFileIndex();
            if (n3 != n4 || !new Filename(stringArray[n5]).equals(filename)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new DebuggerException(2, "" + n3 + ", file " + string);
        }
        BreakpointManager.addTempBreakpoint(n3, string, n2);
        this.status = 7;
        this.stepNumber = 1;
        returnCode = 0;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVariables(GetVariablesCommand getVariablesCommand) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        VarName[] varNameArray = getVariablesCommand.getVariablesNames();
        TreeNode treeNode = new TreeNode("GetVariables", null);
        String[] stringArray = getVariablesCommand.getClassNames();
        for (int i2 = 0; i2 < varNameArray.length; ++i2) {
            String string = stringArray != null && i2 < stringArray.length ? stringArray[i2] : null;
            Object[] objectArray = null;
            try {
                objectArray = this.setCurrentObjects(string);
            }
            catch (DebuggerException debuggerException) {
                continue;
            }
            try {
                Object object;
                CharSequence charSequence;
                IscobolDataItem iscobolDataItem;
                IDebuggerHelper iDebuggerHelper;
                int[] nArray;
                VarName varName;
                block25: {
                    DataExternalizable dataExternalizable;
                    varName = varNameArray[i2];
                    nArray = new int[varName.getNSubscripts() + 1];
                    for (int i3 = 0; i3 < nArray.length - 1; ++i3) {
                        dataExternalizable = varName.getSubscript(i3);
                        nArray[i3] = ((BigDecimal)((Expression)dataExternalizable).evaluate(this, true, false)).intValue();
                    }
                    iDebuggerHelper = this.getHelper();
                    dataExternalizable = (VarName)varName.clone();
                    if (getVariablesCommand.getGetChildren()) {
                        ((VarName)dataExternalizable).clearSubscripts();
                    }
                    iscobolDataItem = null;
                    try {
                        iscobolDataItem = this.findObjectVar((VarName)dataExternalizable, false, true);
                    }
                    catch (DebuggerException debuggerException) {
                        if (debuggerException.getErrorId() != 41 && debuggerException.getErrorId() != 25) break block25;
                        int n2 = 0;
                        ((VarName)dataExternalizable).clearSubscripts();
                        try {
                            iscobolDataItem = this.findObjectVar((VarName)dataExternalizable, false, true);
                            n2 = DebugUtilities.getVarType(iscobolDataItem.getVar(), iDebuggerHelper);
                            iscobolDataItem = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        charSequence = new StringBuffer();
                        charSequence.append(n2);
                        charSequence.append("\u0001");
                        charSequence.append("\u0001");
                        charSequence.append("\u0001");
                        charSequence.append(DebuggerConstants.NULL_VALUE);
                        treeNode.addNode(new TreeNode(varName.getFullName(), charSequence.toString()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (iscobolDataItem == null) continue;
                if (iscobolDataItem.getVar() instanceof ICobolVar) {
                    int n3;
                    Object object2;
                    object = (ICobolVar)iscobolDataItem.getVar();
                    int[] nArray2 = DebugUtilities.getDimensions((ICobolVar)object);
                    charSequence = null;
                    int n4 = nArray2 != null ? nArray2.length : 0;
                    int n5 = nArray[0];
                    if (n4 > 0) {
                        object2 = new StringBuffer();
                        ((StringBuffer)object2).append("(");
                        for (n3 = 0; n3 < nArray2.length - 1; ++n3) {
                            ((StringBuffer)object2).append(" ").append(nArray[n3]);
                        }
                        charSequence = ((StringBuffer)object2).toString();
                    }
                    if (getVariablesCommand.getGetChildren()) {
                        object2 = new ArrayList();
                        if (n4 >= nArray.length) {
                            int n6;
                            n3 = getVariablesCommand.getMaxArrayLength();
                            int n7 = getVariablesCommand.getStartArrayOffset();
                            int n8 = nArray2[nArray.length - 1];
                            if (n8 <= n3) {
                                n5 = 1;
                                n6 = n8;
                            } else {
                                n5 = Math.min(n7, n8 - n3);
                                n6 = n5 + n3 - 1;
                            }
                            int n9 = n5;
                            while (n9 <= n6) {
                                nArray[nArray.length - 1] = n9++;
                                object2.add(object.intIAt(nArray));
                            }
                            nArray[nArray.length - 1] = n5;
                        } else {
                            object2.addAll(DebugUtilities.getAllChildren((ICobolVar)object));
                            nArray = null;
                        }
                        if (object2.isEmpty()) continue;
                        Object[] objectArray2 = object2.toArray();
                        Debugger.getChildVariables(objectArray2, (String)charSequence, n5, n4, treeNode, getVariablesCommand.getMaxHexDumpLength(), getVariablesCommand.getStartHexDumpOffset(), getVariablesCommand.getMaxTextLength(), nArray != null && n4 >= nArray.length, iDebuggerHelper);
                        continue;
                    }
                    object2 = varName.getFullName();
                    Debugger.getChildVariable(object, (String)object2, (String)charSequence, n5, n4, treeNode, getVariablesCommand.getMaxHexDumpLength(), getVariablesCommand.getStartHexDumpOffset(), getVariablesCommand.getMaxTextLength(), nArray != null && n4 >= nArray.length, iDebuggerHelper);
                    continue;
                }
                if (varName.hasSubscript() && (iscobolDataItem = this.findObjectVar(varName, false, true)) == null) continue;
                object = iscobolDataItem.getVar();
                Debugger.getChildVariables(new Object[]{new DebugFieldWrapper(object, varName.getFullName())}, null, 0, 0, treeNode, getVariablesCommand.getMaxHexDumpLength(), getVariablesCommand.getStartHexDumpOffset(), getVariablesCommand.getMaxTextLength(), false, iDebuggerHelper);
                continue;
            }
            finally {
                this.restoreCurrentObjects(objectArray);
            }
        }
        Debugger.addTree(new Tree(treeNode, false), null);
        returnCode = 0;
        return "";
    }

    private static void addTree(Tree tree, String string) {
        if (Debugger.tree == null) {
            Debugger.tree = new Vector();
        }
        tree.setClassName(string);
        Debugger.tree.addElement(tree);
    }

    private static void getChildVariables(Object[] objectArray, String string, int n2, int n3, TreeNode treeNode, int n4, int n5, int n6, boolean bl, IDebuggerHelper iDebuggerHelper) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Debugger.getChildVariable(objectArray[i2], null, string, n2, n3, treeNode, n4, n5, n6, bl, iDebuggerHelper);
        }
    }

    private static void getChildVariable(Object object, String string, String string2, int n2, int n3, TreeNode treeNode, int n4, int n5, int n6, boolean bl, IDebuggerHelper iDebuggerHelper) {
        TreeNode treeNode2;
        if (object instanceof ICobolVar) {
            ICobolVar iCobolVar = (ICobolVar)object;
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(iCobolVar.getName());
                if (string2 != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append(" ");
                    stringBuffer.append(n2);
                    stringBuffer.append(" )");
                    if (bl) {
                        ++n2;
                    }
                }
            }
            int[] nArray = DebugUtilities.getDimensions(iCobolVar);
            int n7 = nArray != null && nArray.length > n3 ? nArray[n3] : 0;
            String string3 = DebugUtilities.buildValueString(object, n7, n4, n5, n6, iDebuggerHelper);
            treeNode2 = new TreeNode(stringBuffer.toString(), string3);
        } else {
            DebugFieldWrapper debugFieldWrapper = (DebugFieldWrapper)object;
            String string4 = DebugUtilities.buildValueString(debugFieldWrapper.getFieldValue(), 0, n4, n5, n6, iDebuggerHelper);
            treeNode2 = new TreeNode(debugFieldWrapper.getFieldName(), string4);
        }
        treeNode.addNode(treeNode2);
    }

    static String setBreakpoint(SetBreakpointCommand setBreakpointCommand, String string, int n2, Debugger debugger) throws DebuggerException {
        if (setBreakpointCommand.isListing()) {
            return Debugger.listBreakpoints();
        }
        int n3 = setBreakpointCommand.getLineNumber();
        String string2 = setBreakpointCommand.getParagraph();
        String string3 = Debugger.getFilename(string);
        int n4 = n2;
        if (setBreakpointCommand.getFilename() != null) {
            string3 = setBreakpointCommand.getFilename();
            n4 = setBreakpointCommand.getFileIndex();
        }
        String string4 = setBreakpointCommand.getProgName();
        if (n3 != 0) {
            return Debugger.setBreakpoint(n3, string3, n4, string4, setBreakpointCommand.isEnabled(), setBreakpointCommand.getPath(), setBreakpointCommand.getCondition(), debugger);
        }
        return Debugger.setBreakpoint(string2, string3, n4, string4, setBreakpointCommand.isEnabled(), setBreakpointCommand.getPath(), setBreakpointCommand.getCondition(), debugger);
    }

    static String clearBreakpoint(ClearBreakpointCommand clearBreakpointCommand, String string, int n2) throws DebuggerException {
        if (clearBreakpointCommand.isClearAll()) {
            return Debugger.clearAllBreakpoints();
        }
        int n3 = clearBreakpointCommand.getLineNumber();
        String string2 = clearBreakpointCommand.getParagraph();
        String string3 = Debugger.getFilename(string);
        int n4 = n2;
        if (clearBreakpointCommand.getFilename() != null) {
            string3 = clearBreakpointCommand.getFilename();
            n4 = clearBreakpointCommand.getFileIndex();
        }
        String string4 = clearBreakpointCommand.getProgName();
        if (n3 != 0) {
            return Debugger.clearBreakpoint(n3, string3, n4, string4);
        }
        return Debugger.clearBreakpoint(string2, string3, n4, string4, clearBreakpointCommand.getPath());
    }

    private static Class classForName(String string, Debugger debugger) throws ClassNotFoundException {
        try {
            return DebugUtilities.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            CallLoader callLoader = debugger != null ? debugger.appData.getCallLoader() : CallLoader.getInstance(Config.a(".code_prefix", ""), false);
            if (callLoader != null) {
                return callLoader.loadClass(string);
            }
            throw classNotFoundException;
        }
    }

    private void getInfo(GetInfoCommand getInfoCommand) {
        Class clazz = null;
        if (getInfoCommand.getClassName() != null) {
            try {
                clazz = Debugger.classForName(getInfoCommand.getClassName(), this);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            clazz = this.currProgramClass;
        }
        if (clazz != null) {
            debugInfo = Debugger.getInfo(getInfoCommand.getCode(), clazz);
        }
    }

    private static DebugResponse.DebugInfo getInfo(int n2, Class clazz) {
        if (!IscobolDebugger.class.isAssignableFrom(clazz)) {
            return new DebugResponse.DebugInfo(DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + ". Please recompile with -d option");
        }
        String[] stringArray = null;
        DebugLine[] debugLineArray = null;
        DebugParagraph[] debugParagraphArray = null;
        DebugCopyFile[] debugCopyFileArray = null;
        String string = null;
        String string2 = null;
        long l2 = 0L;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        int n3 = 0;
        byte[] byArray = null;
        Throwable[] throwableArray = new Throwable[1];
        DebugSMAPReader debugSMAPReader = DebugUtilities.getDSR(clazz, throwableArray);
        if (debugSMAPReader == null && throwableArray[0] != null) {
            return Debugger.checkVersion(clazz);
        }
        if (debugSMAPReader != null) {
            try {
                if ((n2 & 1) == 1) {
                    stringArray = debugSMAPReader.getFileNames().toArray(new String[debugSMAPReader.getFileNames().size()]);
                }
                if ((n2 & 4) == 4 && debugSMAPReader.getDbgParagraphs() != null) {
                    debugParagraphArray = debugSMAPReader.getDbgParagraphs().toArray(new DebugParagraph[debugSMAPReader.getDbgParagraphs().size()]);
                }
                if ((n2 & 2) == 2 && debugSMAPReader.getDbgLines() != null) {
                    debugLineArray = debugSMAPReader.getDbgLines().toArray(new DebugLine[debugSMAPReader.getDbgLines().size()]);
                }
                if ((n2 & 8) == 8 && debugSMAPReader.getCopyFiles() != null) {
                    debugCopyFileArray = debugSMAPReader.getCopyFiles().toArray(new DebugCopyFile[debugSMAPReader.getCopyFiles().size()]);
                }
                if ((n2 & 0x10) == 16) {
                    string = debugSMAPReader.getSourceFileName();
                }
                if ((n2 & 0x40) == 64) {
                    l2 = debugSMAPReader.getTimestamp();
                }
                try {
                    if ((n2 & 0x80) == 128) {
                        stringArray2 = DebugUtilities.getCompilerOptions(clazz);
                    }
                }
                catch (Exception exception) {
                    if (clazz.isInterface()) {
                        stringArray2 = new String[]{};
                    }
                    throw exception;
                }
                try {
                    if ((n2 & 0x100) == 256) {
                        stringArray4 = debugSMAPReader.getFileSeparator();
                    }
                }
                catch (Exception exception) {
                    stringArray4 = new String[]{File.separator, File.pathSeparator};
                }
                if ((n2 & 0x200) == 512 && Config.b("iscobol.debug.embedded_source", true)) {
                    byArray = debugSMAPReader.getListingInfos();
                }
                n3 = debugSMAPReader.getSmapFormat();
                stringArray3 = debugSMAPReader.getCompilerProps();
            }
            catch (Exception exception) {
                return Debugger.checkVersion(clazz);
            }
        }
        try {
            if ((n2 & 1) == 1) {
                stringArray = DebugUtilities.getFilenames(clazz);
            }
            if ((n2 & 4) == 4) {
                debugParagraphArray = DebugUtilities.getParagraphs(clazz);
            }
            if ((n2 & 2) == 2) {
                debugLineArray = DebugUtilities.getLines(clazz);
            }
            if ((n2 & 8) == 8) {
                debugCopyFileArray = DebugUtilities.getCopyfiles(clazz);
            }
            if ((n2 & 0x20) == 32) {
                string2 = DebugUtilities.getCopyPath(clazz);
            }
            if ((n2 & 0x10) == 16) {
                string = DebugUtilities.getSourcefile(clazz);
            }
            if ((n2 & 0x40) == 64) {
                l2 = DebugUtilities.getTimestamp(clazz);
            }
            try {
                if ((n2 & 0x80) == 128) {
                    stringArray2 = DebugUtilities.getCompilerOptions(clazz);
                }
            }
            catch (Exception exception) {
                if (clazz.isInterface()) {
                    stringArray2 = new String[]{};
                }
                throw exception;
            }
            try {
                if ((n2 & 0x100) == 256) {
                    stringArray4 = DebugUtilities.getFileSeparators(clazz);
                }
            }
            catch (Exception exception) {
                stringArray4 = new String[]{File.separator, File.pathSeparator};
            }
        }
        catch (Exception exception) {
            return Debugger.checkVersion(clazz);
        }
        return new DebugResponse.DebugInfo(clazz.getName(), stringArray, debugLineArray, debugParagraphArray, debugCopyFileArray, string, string2, l2, IscobolDebuggerExtension.class.isAssignableFrom(clazz), stringArray2, stringArray4, stringArray3, byArray, n3);
    }

    private String display(DisplayCommand displayCommand) throws DebuggerException {
        if (displayCommand.displayAsTree()) {
            return this.displayTree(displayCommand);
        }
        if (displayCommand.getEnvName() != null) {
            return this.env(displayCommand.getEnvName(), displayCommand.displayAsHex());
        }
        if (displayCommand.displayClassInfo()) {
            return this.displayClassInfo();
        }
        if (displayCommand.displayAsHex() && displayCommand.getPropertyName() == null) {
            return this.displayAsHexString(displayCommand.getVarName(), displayCommand.getClassName());
        }
        return this.display(displayCommand.getVarName(), displayCommand.getClassName(), displayCommand.getPropertyName(), displayCommand.displayAsHex(), false);
    }

    private String length(LengthCommand lengthCommand) throws DebuggerException {
        this.display(lengthCommand.getVarName(), lengthCommand.getClassName(), null, false, true);
        if (dbgVar != null) {
            return "+ length of " + lengthCommand.getVarName().getFullName() + " = " + dbgVar.getLength() + eol;
        }
        return "- unknown length" + eol;
    }

    private String offset(OffsetCommand offsetCommand) throws DebuggerException {
        this.display(offsetCommand.getVarName(), offsetCommand.getClassName(), null, false, true);
        if (dbgVar != null) {
            return "+ offset of " + offsetCommand.getVarName().getFullName() + " = " + dbgVar.getOffset() + eol;
        }
        return "- unknown offset" + eol;
    }

    private String displayClassInfo() throws DebuggerException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.currProgramClass != null || this.currProgram != null) {
            returnCode = 0;
            stringBuffer.append("+");
            stringBuffer.append(" ");
            if (this.currProgram != null) {
                stringBuffer.append(Factory.info(this.currProgram));
            } else {
                try {
                    stringBuffer.append(Factory.info(this.currProgramClass));
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new DebuggerException("isCOBOL class version: unknown");
                }
            }
        } else {
            stringBuffer.append("isCOBOL class version: unknown");
            throw new DebuggerException(stringBuffer.toString());
        }
        stringBuffer.append(eol);
        return stringBuffer.toString();
    }

    private static void pruneDeathThreads() {
        ArrayList arrayList = new ArrayList();
        for (Object k2 : debuggerInstances.keySet()) {
            Debugger debugger = (Debugger)debuggerInstances.get(k2);
            if (debugger.threadObj == null || debugger.threadObj.isAlive()) continue;
            arrayList.add(k2);
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            debuggerInstances.remove(arrayList.get(i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadObject[] getThreads(boolean bl, int[] nArray) {
        ThreadObject[] threadObjectArray = null;
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            Debugger.pruneDeathThreads();
            Vector<ThreadObject> vector = new Vector<ThreadObject>();
            int n2 = 0;
            for (Object k2 : debuggerInstances.keySet()) {
                Debugger debugger = (Debugger)debuggerInstances.get(k2);
                if (debugger.threadObj == null) continue;
                if (bl) {
                    debugger.threadObj.setParStack(debugger.getParStack());
                    if (debugger == activeDebugger) {
                        nArray[0] = n2;
                    }
                }
                vector.addElement(debugger.threadObj);
                ++n2;
            }
            threadObjectArray = new ThreadObject[vector.size()];
            vector.toArray(threadObjectArray);
        }
        return threadObjectArray;
    }

    private String setMonitor(SetMonitorCommand setMonitorCommand) throws DebuggerException {
        if (setMonitorCommand.isListing()) {
            this.out.print(this.listMonitors());
            return "";
        }
        if (setMonitorCommand.getEnvName() != null) {
            String string = setMonitorCommand.getEnvName();
            Condition condition = setMonitorCommand.getCondition();
            return this.setEnvMonitor(string, condition, setMonitorCommand.isEnabled());
        }
        String string = setMonitorCommand.getClassName();
        if (string != null && this.status == 3) {
            BreakpointManager.setMonitorToAdd(string, setMonitorCommand.getVarName(), setMonitorCommand.getCondition(), setMonitorCommand.getPropertyName(), setMonitorCommand.isHexadecimal(), setMonitorCommand.isEnabled());
            return "";
        }
        return this.setMonitor(setMonitorCommand.getVarName(), setMonitorCommand.getCondition(), string, setMonitorCommand.getPropertyName(), setMonitorCommand.isHexadecimal(), setMonitorCommand.isEnabled(), false);
    }

    private String clearMonitor(ClearMonitorCommand clearMonitorCommand) throws DebuggerException {
        if (clearMonitorCommand.isClearAll()) {
            this.out.print(this.clearAllMonitors());
            return "";
        }
        if (clearMonitorCommand.getEnvName() != null) {
            return this.clearEnvMonitor(clearMonitorCommand.getEnvName());
        }
        String string = clearMonitorCommand.getClassName();
        return this.clearMonitor(clearMonitorCommand.getVarName(), string, clearMonitorCommand.getPropertyName());
    }

    private IscobolDataItem[] getMethodFields(String string) {
        ArrayList arrayList = new ArrayList();
        Debugger.addIscobolFields(string, this.currMethodClass, arrayList);
        if (this.theMethodObj != null) {
            Class<?>[] classArray = this.currMethodClass.getDeclaredClasses();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (!IscobolDebugger.class.isAssignableFrom(classArray[i2])) continue;
                Debugger.addIscobolFields(string, classArray[i2], arrayList);
            }
        }
        return arrayList.toArray(new IscobolDataItem[arrayList.size()]);
    }

    private static IscobolDataItem[] getLocalStorageFields(String string, Class clazz) {
        ArrayList arrayList = new ArrayList();
        Debugger.addIscobolFields(string, clazz, arrayList);
        return arrayList.toArray(new IscobolDataItem[arrayList.size()]);
    }

    private IscobolDataItem[] getClassFields(String string) {
        ArrayList arrayList = new ArrayList();
        Debugger.addIscobolFields(string, this.currProgramClass, arrayList);
        return arrayList.toArray(new IscobolDataItem[arrayList.size()]);
    }

    private IscobolDataItem[] getProgramFields(String string) {
        ArrayList arrayList = new ArrayList();
        Debugger.addIscobolFields(string, this.currProgramClass, arrayList);
        if (this.theProgramObj != null) {
            Object object;
            for (object = this.currProgramClass.getSuperclass(); object != null && IscobolDebugger.class.isAssignableFrom((Class<?>)object); object = object.getSuperclass()) {
                Debugger.addIscobolFields(string, object, arrayList);
            }
            object = this.currProgramClass.getDeclaredClasses();
            for (int i2 = 0; i2 < ((Class<?>[])object).length; ++i2) {
                if (!IscobolDebugger.class.isAssignableFrom(object[i2])) continue;
                Debugger.addIscobolFields(string, object[i2], arrayList);
            }
        }
        return arrayList.toArray(new IscobolDataItem[arrayList.size()]);
    }

    private static void addIscobolFields(String string, Class clazz, ArrayList arrayList) {
        try {
            String string2 = string + "\\$\\d+";
            for (Field field : clazz.getDeclaredFields()) {
                String string3 = field.getName();
                if (!string3.equals(string) && (!Handle.class.isAssignableFrom(field.getType()) || !string3.matches(string2))) continue;
                IscobolDataItem iscobolDataItem = new IscobolDataItem();
                iscobolDataItem.field = field;
                arrayList.add(iscobolDataItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String let(LetCommand letCommand) throws DebuggerException {
        if (letCommand.getEnvName() != null) {
            return this.let(letCommand.getEnvName(), letCommand.getNewValue());
        }
        if (letCommand.acceptAsHex()) {
            return this.letAsHex(letCommand.getVarName(), letCommand.getClassName(), letCommand.getNewValue());
        }
        return this.let(letCommand.getVarName(), letCommand.getClassName(), letCommand.getPropertyName(), letCommand.getNewValue());
    }

    private String let(String string, String string2) throws DebuggerException {
        String string3 = Config.a() + string.trim().toLowerCase().replace('-', '_');
        Config.b(string3, string2);
        String string4 = Config.a(string3, null);
        returnCode = 0;
        if (string.startsWith("debug.internal.")) {
            return "";
        }
        return "+ new value of " + string3 + " is " + string4 + eol;
    }

    private IscobolDataItem findObjectVar(VarName varName, boolean bl) throws DebuggerException {
        return this.findObjectVar(varName, true, bl);
    }

    private IscobolProp findProp(Class clazz, IscobolDataItem iscobolDataItem, boolean bl, String string, boolean bl2) {
        string = DebugUtilities.getJavaNameUpper(string, this.hyphenRepl);
        Field field = null;
        try {
            field = clazz.getField(string);
            if (!Modifier.isStatic(field.getModifiers()) && iscobolDataItem == null && !bl) {
                field = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (field != null) {
            return new IscobolProp(field, iscobolDataItem, bl2);
        }
        string = (bl2 ? "set" : "get") + string;
        try {
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(string) || !Modifier.isStatic(method.getModifiers()) && iscobolDataItem == null && !bl) continue;
                if (bl2) {
                    if (method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1) {
                        return new IscobolProp(method, clazz.getField("tmp" + string), iscobolDataItem, bl2);
                    }
                } else if (method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0) {
                    return new IscobolProp(method, null, iscobolDataItem, bl2);
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private IscobolProp findProp(VarName varName, boolean bl) {
        Object object;
        int n2 = varName.getNAncestors();
        if (n2 == 0) {
            return null;
        }
        RepositoryEntry[] repositoryEntryArray = null;
        try {
            repositoryEntryArray = DebugUtilities.getRepositoryEntries(this.getCurrClass());
        }
        catch (Exception exception) {
            return null;
        }
        String string = n2 > 1 ? varName.getAncestor(n2 - 2) : varName.getName();
        String string2 = RepositoryEntry.findPropertyName(string, repositoryEntryArray);
        if (string2 == null) {
            return null;
        }
        Class clazz = null;
        IscobolDataItem iscobolDataItem = null;
        String string3 = varName.getAncestor(n2 - 1);
        if ("self".equalsIgnoreCase(string3)) {
            clazz = this.currProgramClass;
            iscobolDataItem = new SelfDataItem(this.currProgram);
        } else if ("super".equalsIgnoreCase(string3)) {
            clazz = this.currProgramClass.getSuperclass();
            iscobolDataItem = new SelfDataItem(this.currProgram);
        } else {
            try {
                iscobolDataItem = this.findObjectVar(new VarName(string3, null), false);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            if (iscobolDataItem != null) {
                clazz = ((IscobolDataItem)iscobolDataItem).getType();
            } else {
                object = RepositoryEntry.findClassName(string3, repositoryEntryArray);
                if (object != null) {
                    try {
                        clazz = Debugger.classForName((String)object, this);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            }
        }
        if (clazz == null || !IscobolClass.class.isAssignableFrom(clazz)) {
            return null;
        }
        object = this.findProp(clazz, iscobolDataItem, false, string2, bl && n2 == 1);
        if (object != null && n2 > 1) {
            String[] stringArray = new String[n2 - 1];
            stringArray[0] = varName.getName();
            for (int i2 = 0; i2 < n2 - 2; ++i2) {
                stringArray[i2 + 1] = varName.getAncestor(i2);
            }
            Object object2 = object;
            for (int i3 = stringArray.length - 1; i3 >= 0; --i3) {
                clazz = ((IscobolProp)object2).getType();
                if (!IscobolClass.class.isAssignableFrom(clazz)) {
                    return null;
                }
                string2 = RepositoryEntry.findPropertyName(stringArray[i3], repositoryEntryArray);
                if (string2 == null) {
                    return null;
                }
                IscobolProp iscobolProp = this.findProp(clazz, null, true, string2, bl && i3 == 0);
                if (iscobolProp == null) {
                    return null;
                }
                ((IscobolProp)object2).next = iscobolProp;
                object2 = iscobolProp;
            }
        }
        return object;
    }

    protected IscobolField findVar(VarName varName, boolean bl) throws DebuggerException {
        IscobolField iscobolField = this.findObjectVar(varName, true, bl);
        if (iscobolField == null) {
            iscobolField = this.findGetProp(varName);
        }
        return iscobolField;
    }

    private IscobolProp findSetProp(VarName varName) {
        return this.findProp(varName, true);
    }

    private IscobolProp findGetProp(VarName varName) {
        IscobolProp iscobolProp = this.findProp(varName, false);
        if (iscobolProp != null) {
            iscobolProp.refresh(this);
        }
        return iscobolProp;
    }

    private IscobolDataItem findObjectVar(VarName varName, boolean bl, boolean bl2) throws DebuggerException {
        if (varName == null) {
            return null;
        }
        String string = DebugUtilities.getJavaNameUpper(varName.getName(), this.hyphenRepl);
        IscobolDataItem iscobolDataItem = this.findObjectVar(varName, "file$" + string, bl, bl2);
        if (iscobolDataItem == null) {
            iscobolDataItem = this.findObjectVar(varName, string, bl, bl2);
        }
        return iscobolDataItem;
    }

    private Object[] setCurrentObjects(String string) throws DebuggerException {
        Object[] objectArray = new Object[]{this.currProgramClass, this.currProgram, this.theProgramObj, this.currMethodClass, this.currMethod, this.theMethodObj};
        if (string != null) {
            String[] stringArray = Debugger.getMethodAndClass(string, false);
            int n2 = this.parStack.size();
            if (stringArray[2] != null) {
                String string2 = stringArray[2];
                String string3 = stringArray[0];
                boolean bl = false;
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    ParagraphObject paragraphObject = (ParagraphObject)this.parStack.elementAt(i2);
                    if (!string2.equals(paragraphObject.getMethodName()) || !string3.equals(paragraphObject.getProgClass().getName())) continue;
                    this.currMethod = paragraphObject.getMethod();
                    this.currMethodClass = this.currMethod.getClass();
                    this.theMethodObj = Debugger.getMethodObj(this.currMethod);
                    this.currProgramClass = paragraphObject.getProgClass();
                    this.currProgram = paragraphObject.getProgram();
                    this.theProgramObj = null;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new DebuggerException(40, string2);
                }
            } else {
                String string4 = stringArray[0];
                boolean bl = false;
                for (int i3 = n2 - 1; i3 >= 0; --i3) {
                    ParagraphObject paragraphObject = (ParagraphObject)this.parStack.elementAt(i3);
                    if (!string4.equalsIgnoreCase(paragraphObject.getProgName())) continue;
                    this.currMethod = null;
                    this.currMethodClass = null;
                    this.theMethodObj = null;
                    this.currProgramClass = paragraphObject.getProgClass();
                    this.currProgram = paragraphObject.getProgram();
                    this.theProgramObj = Debugger.getProgramObj(this.currProgram);
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new DebuggerException(23, string4);
                }
            }
        }
        return objectArray;
    }

    private void restoreCurrentObjects(Object[] objectArray) {
        this.currProgramClass = (Class)objectArray[0];
        this.currProgram = objectArray[1];
        this.theProgramObj = objectArray[2];
        this.currMethodClass = (Class)objectArray[3];
        this.currMethod = objectArray[4];
        this.theMethodObj = objectArray[5];
    }

    private IscobolDataItem findObjectVar(VarName varName, String string, boolean bl, boolean bl2) throws DebuggerException {
        IscobolDataItem iscobolDataItem = null;
        if (this.currMethodClass != null) {
            Object object;
            IscobolDataItem[] iscobolDataItemArray = this.getMethodFields(string);
            if (iscobolDataItemArray.length > 0) {
                iscobolDataItem = this.findObjectVar(varName, bl, bl2, iscobolDataItemArray, this.theMethodObj != null ? this.theMethodObj : this.currMethod);
            }
            if (iscobolDataItem == null && (iscobolDataItemArray = this.getClassFields(string)).length > 0) {
                iscobolDataItem = this.findObjectVar(varName, bl, bl2, iscobolDataItemArray, this.currProgram);
            }
            if (iscobolDataItem == null && (object = this.getHelper().peekMethodLocalStorage()) != null && (iscobolDataItemArray = Debugger.getLocalStorageFields(string, object.getClass())).length > 0) {
                iscobolDataItem = this.findObjectVar(varName, bl, bl2, iscobolDataItemArray, object);
            }
            if (iscobolDataItem == null && (object = this.getHelper().peekMethodThreadLocalStorage()) != null && (iscobolDataItemArray = Debugger.getLocalStorageFields(string, object.getClass())).length > 0) {
                iscobolDataItem = this.findObjectVar(varName, bl, bl2, iscobolDataItemArray, object);
            }
        } else {
            Object object;
            IscobolDataItem[] iscobolDataItemArray = this.getProgramFields(string);
            if (iscobolDataItemArray.length > 0) {
                iscobolDataItem = this.findObjectVar(varName, bl, bl2, iscobolDataItemArray, this.theProgramObj != null ? this.theProgramObj : this.currProgram);
            }
            if (iscobolDataItem == null && (object = this.getHelper().peekCallLocalStorage()) != null && (iscobolDataItemArray = Debugger.getLocalStorageFields(string, object.getClass())).length > 0) {
                iscobolDataItem = this.findObjectVar(varName, bl, bl2, iscobolDataItemArray, object);
            }
            if (iscobolDataItem == null && (object = this.getHelper().peekCallThreadLocalStorage()) != null && (iscobolDataItemArray = Debugger.getLocalStorageFields(string, object.getClass())).length > 0) {
                iscobolDataItem = this.findObjectVar(varName, bl, bl2, iscobolDataItemArray, object);
            }
        }
        return iscobolDataItem;
    }

    private IscobolDataItem findObjectVar(VarName varName, boolean bl, boolean bl2, IscobolDataItem[] iscobolDataItemArray, Object object) throws DebuggerException {
        int n2 = 0;
        IscobolField iscobolField = null;
        Object object2 = null;
        for (IscobolDataItem iscobolDataItem : iscobolDataItemArray) {
            iscobolDataItem.field.setAccessible(true);
            int[] nArray = null;
            try {
                if (object == null && !Modifier.isStatic(iscobolDataItem.field.getModifiers())) continue;
                object2 = iscobolDataItem.field.get(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ICobolVar iCobolVar = null;
            Level88 level88 = null;
            boolean bl3 = true;
            if (varName.hasSubscript()) {
                nArray = this.resolveSubscripts(varName);
            }
            if (object2 instanceof ICobolVar) {
                iCobolVar = this.findCobolVar((ICobolVar)object2, iscobolDataItem, varName, nArray, bl2);
                bl3 = iCobolVar != null;
            } else if (object2 instanceof Level88) {
                level88 = this.findLevel88((Level88)object2, varName, nArray);
                bl3 = level88 != null;
            } else if (varName.hasSubscript()) {
                iscobolDataItem.adjustIndexes(nArray);
                object2 = Debugger.findObjectVarAt(object2, nArray);
                boolean bl4 = bl3 = object2 != null;
            }
            if (!bl3) continue;
            iscobolField = iscobolDataItem;
            IscobolDataItem.access$502((IscobolDataItem)iscobolField, nArray);
            ++n2;
            if (iCobolVar != null) {
                iscobolField.setVar(iCobolVar);
            } else if (level88 != null) {
                iscobolField.setVar(level88);
            } else {
                iscobolField.setVar(object2);
            }
            if (n2 <= 1) continue;
            throw new DebuggerException(8, "'" + varName.getName() + "'");
        }
        if (n2 == 1) {
            if (iscobolField.getVar() == null) {
                iscobolField.setVar(NULL_OBJECT);
            }
            if (bl) {
                if (iscobolField.getVar() instanceof ICobolVar) {
                    int n3;
                    int n4 = n3 = ((IscobolDataItem)iscobolField).dimensions == null ? 0 : ((IscobolDataItem)iscobolField).dimensions.length;
                    if (n3 > varName.getNSubscripts()) {
                        throw new DebuggerException(6, "'" + varName.getName() + "'");
                    }
                    if (n3 < varName.getNSubscripts()) {
                        throw new DebuggerException(25, "'" + varName.getName() + "'");
                    }
                } else if (iscobolField.getVar() instanceof Level88) {
                    Level88 level88 = (Level88)iscobolField.getVar();
                    int n5 = level88.getDimCount();
                    if (n5 > varName.getNSubscripts()) {
                        throw new DebuggerException(6, "'" + varName.getName() + "'");
                    }
                    if (n5 < varName.getNSubscripts()) {
                        throw new DebuggerException(25, "'" + varName.getName() + "'");
                    }
                } else if (iscobolField.getVar().getClass().isArray() && varName.getNSubscripts() == 0) {
                    throw new DebuggerException(6, "'" + varName.getName() + "'");
                }
            }
            return iscobolField;
        }
        return null;
    }

    static Object findObjectVarAt(Object object, int[] nArray) throws DebuggerException {
        int n2 = 0;
        while (true) {
            try {
                object = Array.get(object, nArray[n2]);
            }
            catch (Exception exception) {
                throw new DebuggerException(25);
            }
            if (object == null || n2 == nArray.length - 1 && !object.getClass().isArray()) {
                return object != null ? object : NULL_OBJECT;
            }
            ++n2;
        }
    }

    private ICobolVar findCobolVar(ICobolVar iCobolVar, IscobolDataItem iscobolDataItem, VarName varName, int[] nArray, boolean bl) throws DebuggerException {
        Object object;
        boolean bl2;
        boolean bl3;
        if (iCobolVar.isFinal()) {
            return iCobolVar;
        }
        iscobolDataItem.setCobolVar(true);
        IscobolDataItem.access$602(iscobolDataItem, DebugUtilities.getDimensions(iCobolVar));
        Enumeration enumeration = varName.getAncestors();
        ICobolVar iCobolVar2 = iCobolVar;
        ICobolVar iCobolVar3 = iCobolVar.getIParent();
        for (bl2 = true; enumeration.hasMoreElements() && bl2; bl2 &= bl3) {
            object = enumeration.nextElement().toString();
            bl3 = false;
            while (iCobolVar3 != null && !bl3) {
                bl3 = iCobolVar3.getName().equalsIgnoreCase((String)object);
                iCobolVar3 = iCobolVar3.getIParent();
            }
        }
        if (bl && bl2 && varName.hasSubscript()) {
            if (nArray == null) {
                return null;
            }
            if (this.shouldCheckDynamic() && !Debugger.checkDynamicIndexes(iCobolVar, nArray)) {
                throw new DebuggerException(41, "'" + varName.getName() + "'");
            }
            try {
                iCobolVar = iCobolVar.intIAt(nArray);
                DebugUtilities.toString(iCobolVar);
            }
            catch (Exception exception) {
                throw new DebuggerException(25, "'" + varName.getName() + "'");
            }
        }
        if (this.cod1) {
            iCobolVar = DebugUtilities.getVar(iCobolVar, iCobolVar2, iCobolVar.getOffset());
        }
        if (bl2 && varName.hasSubvalue()) {
            object = varName.getSubLen();
            if (object != null) {
                try {
                    iscobolDataItem.subLen = this.evaluateExprAsInt((Expression)object);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if ((object = varName.getLeftPos()) != null) {
                try {
                    iscobolDataItem.leftPos = this.evaluateExprAsInt((Expression)object);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (bl) {
                try {
                    iCobolVar = iscobolDataItem.subLen != -1 ? iCobolVar.intISub(iscobolDataItem.leftPos, iscobolDataItem.subLen) : iCobolVar.intISub(iscobolDataItem.leftPos);
                }
                catch (IscobolRuntimeException iscobolRuntimeException) {
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            return iCobolVar;
        }
        return null;
    }

    private Level88 findLevel88(Level88 level88, VarName varName, int[] nArray) throws DebuggerException {
        ICobolVar iCobolVar = level88.getParent();
        String string = varName.getName().replace(this.hyphenRepl, '-');
        boolean bl = level88.getName().equalsIgnoreCase(string);
        Enumeration enumeration = varName.getAncestors();
        while (bl && enumeration.hasMoreElements()) {
            String string2 = iCobolVar != null ? iCobolVar.getName() : "";
            String string3 = enumeration.nextElement().toString();
            bl &= string2.equalsIgnoreCase(string3);
            iCobolVar = iCobolVar.getIParent();
        }
        if (bl && varName.hasSubscript()) {
            if (nArray == null) {
                return null;
            }
            if (!this.shouldCheckDynamic() || Debugger.checkDynamicIndexes(level88.getParent(), nArray)) {
                try {
                    level88 = level88.intAt(nArray);
                }
                catch (IscobolRuntimeException iscobolRuntimeException) {
                    bl = false;
                }
            } else {
                throw new DebuggerException(41, "'" + varName.getName() + "'");
            }
        }
        if (bl) {
            return level88;
        }
        return null;
    }

    private int[] resolveSubscripts(VarName varName) {
        int n2 = varName.getNSubscripts();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = varName.getSubscript(i2);
            try {
                nArray[i2] = this.evaluateExprAsInt(expression);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return nArray;
    }

    private int evaluateExprAsInt(Expression expression) throws DebuggerException {
        Object object = expression.evaluate(this, true, false);
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).intValue();
        }
        return 0;
    }

    public static void isIscobolDebugger(String string) {
        int n2 = globalStatus.getValue();
        if (n2 != 0 && n2 != 3) {
            Debugger debugger = Debugger.getCurrentDebugger();
            try {
                Class clazz = DebugUtilities.classForName(string);
                if (!DebuggerConstants.DEBUGGER_CLASS.isAssignableFrom(clazz)) {
                    debugger.out.println(DebuggerException.getFormattedInfoMessage(5, clazz.getName()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void callThreadAborted(Debugger debugger) {
        if (globalStatus.getValue() != 0 && debugger.status == 1) {
            Debugger debugger2 = Debugger.getCurrentDebugger();
            debugger2.status = 1;
            debugger2.stepNumber = debugger.stepNumber;
            activeDebugger = debugger2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Debugger newThread() {
        ThreadObject threadObject = null;
        Debugger debugger = null;
        Debugger debugger2 = Debugger.getCurrentDebugger();
        debugger = new Debugger(debugger2);
        int n2 = globalStatus.getValue();
        if (n2 != 0) {
            threadObject = ThreadObject.getIscobolThreadObject(null);
            if (debugger2 == activeDebugger && debugger2.status == 1) {
                debugger2.status = 4;
                debugger.status = 1;
                debugger.stepNumber = debugger2.stepNumber;
                debugger2.stepNumber = 1;
                activeDebugger = debugger;
            } else if (n2 != 3) {
                Hashtable hashtable = debuggerInstances;
                synchronized (hashtable) {
                    Debugger.pruneDeathThreads();
                    if (debuggerInstances.size() == 0) {
                        debugger.status = 1;
                        activeDebugger = debugger;
                    } else {
                        debugger.status = 4;
                    }
                    debugger.stepNumber = 1;
                }
            }
        }
        debugger.threadObj = threadObject;
        return debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterThread(Debugger debugger) {
        if (debugger != null) {
            if (globalStatus.getValue() != 0) {
                debugger.threadObj.setThread();
            }
            Hashtable hashtable = debuggerInstances;
            synchronized (hashtable) {
                debuggerInstances.put(Thread.currentThread(), debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitThread() {
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            debuggerInstances.remove(Thread.currentThread());
        }
    }

    public static Object callThread(NumericVar numericVar, String string, IscobolCall iscobolCall, Object[] objectArray) {
        return Debugger.callThread(numericVar, string, iscobolCall, objectArray, DebugUtilities.getHelper(null));
    }

    public static Object callThread(INumericVar iNumericVar, String string, IscobolCall iscobolCall, Object[] objectArray, IDebuggerHelper iDebuggerHelper) {
        Debugger.callThread(iNumericVar, string, iscobolCall, objectArray, null, iDebuggerHelper);
        return iDebuggerHelper.getNumLiteral(0L, 1, 0, false);
    }

    public static void callThread(INumericVar iNumericVar, String string, IscobolCall iscobolCall, Object[] objectArray, ICobolVar iCobolVar, IDebuggerHelper iDebuggerHelper) {
        Debugger debugger = Debugger.newThread();
        try {
            iDebuggerHelper.callThread(iNumericVar, string, iscobolCall, objectArray, iCobolVar, new MyNotifier(debugger));
        }
        catch (IscobolRuntimeException iscobolRuntimeException) {
            Debugger.callThreadAborted(debugger);
            throw iscobolRuntimeException;
        }
    }

    public static Object callRun(String string, IscobolCall iscobolCall, Object[] objectArray) {
        return Debugger.callRun(string, iscobolCall, objectArray, DebugUtilities.getHelper(null));
    }

    public static Object callRun(String string, IscobolCall iscobolCall, Object[] objectArray, IDebuggerHelper iDebuggerHelper) {
        Debugger.callRun(string, iscobolCall, objectArray, null, iDebuggerHelper);
        return iDebuggerHelper.getNumLiteral(0L, 1, 0, false);
    }

    public static void callRun(String string, IscobolCall iscobolCall, Object[] objectArray, ICobolVar iCobolVar, IDebuggerHelper iDebuggerHelper) {
        Debugger debugger = Debugger.newThread();
        try {
            iDebuggerHelper.callRun(string, iscobolCall, objectArray, iCobolVar, new MyNotifier(debugger));
        }
        catch (IscobolRuntimeException iscobolRuntimeException) {
            Debugger.callThreadAborted(debugger);
            throw iscobolRuntimeException;
        }
    }

    public static Object clientCallThread(NumericVar numericVar, String string, Object[] objectArray) {
        return Debugger.clientCallThread(numericVar, string, objectArray, DebugUtilities.getHelper(null));
    }

    public static Object clientCallThread(INumericVar iNumericVar, String string, Object[] objectArray, IDebuggerHelper iDebuggerHelper) {
        Debugger.clientCallThread(iNumericVar, string, objectArray, null, iDebuggerHelper);
        return iDebuggerHelper.getNumLiteral(0L, 1, 0, false);
    }

    public static void clientCallThread(INumericVar iNumericVar, String string, Object[] objectArray, ICobolVar iCobolVar, IDebuggerHelper iDebuggerHelper) {
        iDebuggerHelper.clientCallThread(iNumericVar, string, objectArray, iCobolVar, new MyNotifier(Debugger.newThread()));
    }

    public static Object clientCallRun(String string, Object[] objectArray) {
        return Debugger.clientCallRun(string, objectArray, DebugUtilities.getHelper(null));
    }

    public static Object clientCallRun(String string, Object[] objectArray, IDebuggerHelper iDebuggerHelper) {
        Debugger.clientCallRun(string, objectArray, null, iDebuggerHelper);
        return iDebuggerHelper.getNumLiteral(0L, 1, 0, false);
    }

    public static void clientCallRun(String string, Object[] objectArray, ICobolVar iCobolVar, IDebuggerHelper iDebuggerHelper) {
        iDebuggerHelper.clientCallRun(string, objectArray, iCobolVar, new MyNotifier(Debugger.newThread()));
    }

    public static PicX acceptFromCommandLine(String[] stringArray) {
        return Factory.acceptFromCommandLine(Debugger.getCommandLineArgs(stringArray));
    }

    public static String[] getCommandLineArgs(String[] stringArray) {
        return stringArray != null ? stringArray : programArgs;
    }

    private String run(RunCommand runCommand) throws DebuggerException {
        if (this.status != 3) {
            throw new DebuggerException(10);
        }
        programArgs = runCommand.getArgs();
        this.status = 1;
        this.stepNumber = 1;
        returnCode = 0;
        return "";
    }

    /*
     * WARNING - void declaration
     */
    static String setProgramBreakpoint(ProgramBreakpointCommand programBreakpointCommand, Debugger debugger) throws DebuggerException {
        String string = programBreakpointCommand.getProgName();
        Class clazz = null;
        try {
            clazz = Debugger.classForName(DebugUtilities.getIscobolClassName(string), debugger);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (clazz != null) {
            void var7_12;
            Object object;
            String string2;
            int n2;
            String[] stringArray;
            DebugParagraph[] debugParagraphArray;
            try {
                debugParagraphArray = DebugUtilities.getParagraphs(clazz);
            }
            catch (Exception exception) {
                debugParagraphArray = null;
            }
            if (debugParagraphArray == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
            }
            try {
                stringArray = DebugUtilities.getFilenames(clazz);
            }
            catch (Exception exception) {
                stringArray = null;
            }
            if (stringArray == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
            }
            HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
            String[] object2 = stringArray;
            int n3 = object2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                string2 = object2[n2];
                object = (int[])hashMap.get(string2);
                if (object == null) {
                    hashMap.put(string2, new int[]{1});
                    continue;
                }
                object[0] = object[0] + 1;
            }
            Object var7_11 = null;
            for (n3 = 0; n3 < debugParagraphArray.length && var7_12 == null; ++n3) {
                if (debugParagraphArray[n3].isInDeclaratives()) continue;
                DebugParagraph debugParagraph = debugParagraphArray[n3];
            }
            if (var7_12 != null) {
                n3 = var7_12.getLineNumber();
                n2 = var7_12.getFileIndex();
                object = BreakpointManager.addBreakpoint(n3, string2, ((int[])hashMap.get(string2 = stringArray[n2]))[0] > 1 ? n2 : -1, clazz.getName(), programBreakpointCommand.getCondition(), programBreakpointCommand.isEnabled());
                object.setProgramBreakpoint(true);
                returnCode = 0;
                return DebuggerException.getInfoMessage(6, "'" + string + "'" + eol);
            }
            throw new DebuggerException(3, "'" + string + "'");
        }
        throw new DebuggerException(23, "'" + string + "'");
    }

    private static String[] getMethodAndClass(String string, boolean bl) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (String string5 : new String[]{".", ":>", "::"}) {
            int n2 = string.indexOf(string5);
            if (n2 < 0 || n2 >= string.length() - string5.length()) continue;
            string4 = string.substring(0, n2);
            string2 = string.substring(n2 + string5.length());
            break;
        }
        if (string4 == null) {
            if (bl) {
                string2 = string;
            } else {
                string4 = string;
            }
        }
        if (string2 != null) {
            int n3;
            string3 = string2.endsWith("()") ? (string2 = string2.substring(0, string2.length() - 2)) : ((n3 = string2.indexOf(40)) >= 0 ? string2.substring(0, n3) : string2);
        }
        return new String[]{string4, string2, string3};
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String setMethodBreakpoint(MethodBreakpointCommand methodBreakpointCommand, Debugger debugger) throws DebuggerException {
        String string;
        void var11_19;
        int n2;
        String[] stringArray;
        DebugParagraph[] debugParagraphArray;
        String string2 = methodBreakpointCommand.getMethodName();
        Class clazz = null;
        String[] stringArray2 = Debugger.getMethodAndClass(string2, true);
        String string3 = stringArray2[0];
        String string4 = stringArray2[1];
        String string5 = stringArray2[2];
        if (string3 == null) {
            if (debugger == null) throw new DebuggerException(40, "'" + string5 + "'");
            string3 = debugger.currProgramClass.getName();
            string2 = string3 + ":>" + string2;
            clazz = debugger.currProgramClass;
        } else {
            try {
                clazz = Debugger.classForName(string3, debugger);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (clazz == null) throw new DebuggerException(23, "'" + string3 + "'");
        try {
            debugParagraphArray = DebugUtilities.getParagraphs(clazz);
        }
        catch (Exception exception) {
            debugParagraphArray = null;
        }
        if (debugParagraphArray == null) {
            returnCode = 203;
            return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
        }
        try {
            stringArray = DebugUtilities.getFilenames(clazz);
        }
        catch (Exception exception) {
            stringArray = null;
        }
        if (stringArray == null) {
            returnCode = 203;
            return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
        }
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        String[] stringArray3 = stringArray;
        int n3 = stringArray3.length;
        for (n2 = 0; n2 < n3; ++n2) {
            String string6 = stringArray3[n2];
            int[] nArray = (int[])hashMap.get(string6);
            if (nArray == null) {
                hashMap.put(string6, new int[]{1});
                continue;
            }
            nArray[0] = nArray[0] + 1;
        }
        Object var11_15 = null;
        if (string4 != string5) {
            void var11_16;
            for (n2 = 0; n2 < debugParagraphArray.length && var11_16 == null; ++n2) {
                String string7 = debugParagraphArray[n2].getMethodName();
                if (string7 == null || !string7.equals(string4)) continue;
                DebugParagraph debugParagraph = debugParagraphArray[n2];
            }
        } else {
            HashMap<String, DebugParagraph> hashMap2 = new HashMap<String, DebugParagraph>();
            for (int i2 = 0; i2 < debugParagraphArray.length; ++i2) {
                String string8 = debugParagraphArray[i2].getMethodName();
                if (string8 == null) continue;
                if (string8.equals(string4)) {
                    hashMap2.clear();
                    hashMap2.put(string8, debugParagraphArray[i2]);
                    break;
                }
                if (!string8.startsWith(string4) || hashMap2.containsKey(string8)) continue;
                hashMap2.put(string8, debugParagraphArray[i2]);
            }
            if (hashMap2.size() > 1) {
                throw new DebuggerException(8, "'" + string5 + "'");
            }
            if (hashMap2.size() == 1) {
                DebugParagraph debugParagraph = (DebugParagraph)hashMap2.values().toArray()[0];
            }
        }
        if (var11_19 == null) throw new DebuggerException(40, "'" + string5 + "'");
        int n4 = var11_19.getLineNumber();
        int n5 = var11_19.getFileIndex();
        Breakpoint breakpoint = BreakpointManager.addBreakpoint(n4, string, ((int[])hashMap.get(string = stringArray[n5]))[0] > 1 ? n5 : -1, clazz.getName(), methodBreakpointCommand.getCondition(), methodBreakpointCommand.isEnabled());
        breakpoint.setMethodName(string2);
        returnCode = 0;
        return DebuggerException.getInfoMessage(21, "'" + string5 + "'" + eol);
    }

    /*
     * WARNING - void declaration
     */
    private static String setBreakpoint(int n2, String string, int n3, String string2, boolean bl, String string3, Expression expression, Debugger debugger) throws DebuggerException {
        String[] stringArray;
        Object object;
        Object object2;
        Class clazz = null;
        boolean bl2 = true;
        clazz = DebugUtilities.getIscobolClass(string2);
        if (clazz == null) {
            clazz = DebugUtilities.getIscobolClass(string);
        }
        boolean bl3 = false;
        if (clazz == null && debugger != null && debugger.currProgramClass != null) {
            clazz = debugger.currProgramClass;
            try {
                void var15_20;
                object2 = DebugUtilities.getFilenames(clazz);
                object = new Filename(string);
                stringArray = object2;
                int n4 = stringArray.length;
                boolean bl4 = false;
                while (var15_20 < n4) {
                    String string4 = stringArray[var15_20];
                    if (new Filename(string4).equals(object)) {
                        bl3 = true;
                        break;
                    }
                    ++var15_20;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl3) {
                clazz = null;
            }
        }
        object2 = "";
        if (clazz != null) {
            try {
                object = DebugUtilities.getLines(clazz);
            }
            catch (Exception exception) {
                object = null;
            }
            if (object == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
            }
            try {
                stringArray = DebugUtilities.getFilenames(clazz);
            }
            catch (Exception exception) {
                stringArray = null;
            }
            if (stringArray == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
            }
            bl2 = false;
            Filename filename = new Filename(string);
            for (DebugLine debugLine : object) {
                int n5 = debugLine.getLineNumber();
                int n6 = debugLine.getFileIndex();
                if (n2 != n5 || !new Filename(stringArray[n6]).equals(filename)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new DebuggerException(2, "" + n2 + ", file " + string);
            }
        } else {
            object2 = "; " + DebuggerException.getWarningMessage(1);
        }
        BreakpointManager.addBreakpoint(n2, string, n3, string2, expression, bl);
        returnCode = 0;
        return DebuggerException.getInfoMessage(7, "" + n2 + ", file " + string3 + (String)object2 + eol);
    }

    private static String setBreakpoint(String string, String string2, int n2, String string3, boolean bl, String string4, Expression expression, Debugger debugger) throws DebuggerException {
        int n3;
        Object object;
        Object[] objectArray;
        int n32 = 0;
        Class clazz = null;
        boolean bl2 = true;
        String string5 = "";
        clazz = DebugUtilities.getIscobolClass(string3);
        if (clazz == null) {
            clazz = DebugUtilities.getIscobolClass(string2);
        }
        boolean bl3 = false;
        if (clazz == null && debugger != null && debugger.currProgramClass != null) {
            clazz = debugger.currProgramClass;
            try {
                objectArray = DebugUtilities.getFilenames(clazz);
                object = new Filename(string2);
                Object[] object3 = objectArray;
                n3 = object3.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object2 = object3[i2];
                    if (!new Filename((String)object2).equals(object)) continue;
                    bl3 = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl3) {
                clazz = null;
            }
        }
        if (clazz != null) {
            try {
                objectArray = DebugUtilities.getParagraphs(clazz);
            }
            catch (Exception exception) {
                objectArray = null;
            }
            if (objectArray == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
            }
            try {
                object = DebugUtilities.getFilenames(clazz);
            }
            catch (Exception exception) {
                object = null;
            }
            if (object == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
            }
            bl2 = false;
            Filename filename = new Filename(string2);
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                String string6 = ((DebugParagraph)objectArray[n3]).getParagraphName();
                n32 = ((DebugParagraph)objectArray[n3]).getLineNumber();
                int n4 = ((DebugParagraph)objectArray[n3]).getFileIndex();
                if (!string.equalsIgnoreCase(string6) || !new Filename(object[n4]).equals(filename)) continue;
                bl2 = true;
                n2 = n4;
                break;
            }
            if (!bl2) {
                throw new DebuggerException(3, string + ", file " + string2);
            }
        } else {
            string5 = "; " + DebuggerException.getWarningMessage(2);
        }
        BreakpointManager.addBreakpoint(string, n32, string2, n2, string3, expression, bl);
        returnCode = 0;
        return DebuggerException.getInfoMessage(8, string + ", file " + string4 + string5 + eol);
    }

    private static String clearBreakpoint(String string, String string2, int n2, String string3, String string4) throws DebuggerException {
        Object object;
        int n3 = 0;
        Class clazz = null;
        boolean bl = true;
        clazz = DebugUtilities.getIscobolClass(string3);
        if (clazz == null) {
            clazz = DebugUtilities.getIscobolClass(string2);
        }
        if (clazz != null) {
            String[] stringArray;
            try {
                object = DebugUtilities.getParagraphs(clazz);
            }
            catch (Exception exception) {
                object = null;
            }
            if (object == null) {
                returnCode = 203;
                return DebuggerException.getFormattedInfoMessage(5, clazz.getName()) + eol;
            }
            try {
                stringArray = DebugUtilities.getFilenames(clazz);
            }
            catch (Exception exception) {
                stringArray = null;
            }
            if (stringArray == null) {
                returnCode = 203;
                return DebuggerException.getInfoMessage(5, "'" + clazz.getName() + "'" + eol);
            }
            bl = false;
            Filename filename = new Filename(string2);
            for (int i2 = 0; i2 < ((DebugParagraph[])object).length; ++i2) {
                String string5 = object[i2].getParagraphName();
                n3 = object[i2].getLineNumber();
                int n4 = object[i2].getFileIndex();
                if (!string.equalsIgnoreCase(string5) || !new Filename(stringArray[n4]).equals(filename)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new DebuggerException(28, string + ", file " + string2);
            }
        }
        if ((object = string != null ? BreakpointManager.removeBreakpoint(string, string2, string3) : BreakpointManager.removeBreakpoint(n3, string2, n2, string3)) != null) {
            returnCode = 0;
            return DebuggerException.getInfoMessage(9, string + ", file " + string4 + eol);
        }
        throw new DebuggerException(28, string + ", file " + string4);
    }

    private static String listBreakpoints() {
        StringBuffer stringBuffer = new StringBuffer();
        Breakpoint[] breakpointArray = BreakpointManager.getBreakpoints();
        for (int i2 = 0; i2 < breakpointArray.length; ++i2) {
            stringBuffer.append(breakpointArray[i2] + eol);
        }
        returnCode = 0;
        return stringBuffer.toString();
    }

    private static String clearAllBreakpoints() {
        BreakpointManager.removeAllBreakpoints();
        returnCode = 0;
        return DebuggerException.getInfoMessage(10, eol);
    }

    private static String clearBreakpoint(int n2, String string, int n3, String string2) throws DebuggerException {
        Breakpoint breakpoint = BreakpointManager.removeBreakpoint(n2, string, n3, string2);
        if (breakpoint != null) {
            returnCode = 0;
            return DebuggerException.getInfoMessage(18, "" + n2 + ", file " + string + eol);
        }
        throw new DebuggerException(29, "" + n2 + ", file " + string);
    }

    private String showMonitors() {
        StringBuffer stringBuffer = new StringBuffer();
        Watch[] watchArray = BreakpointManager.getMonitors(this);
        if (watchArray != null) {
            for (int i2 = 0; i2 < watchArray.length; ++i2) {
                stringBuffer.append(watchArray[i2] + eol);
            }
        }
        return stringBuffer.toString();
    }

    private String listMonitors() {
        returnCode = 0;
        return this.showMonitors();
    }

    private String listThreads() {
        StringBuffer stringBuffer = new StringBuffer();
        ThreadObject[] threadObjectArray = Debugger.getThreads(false, null);
        for (int i2 = 0; i2 < threadObjectArray.length; ++i2) {
            stringBuffer.append(threadObjectArray[i2] + eol);
        }
        return stringBuffer.toString();
    }

    private String setEnvMonitor(String string, Condition condition, boolean bl) {
        BreakpointManager.addEnvMonitor(string, this.getHelper().acceptFromEnv(string), condition, bl);
        return DebuggerException.getInfoMessage(19, "'" + string + "'" + eol);
    }

    private String clearEnvMonitor(String string) throws DebuggerException {
        if (!BreakpointManager.removeEnvMonitor(string)) {
            throw new DebuggerException(30, "'" + string + "'");
        }
        returnCode = 0;
        return DebuggerException.getInfoMessage(11, "'" + string + "'" + eol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setMonitor(VarName varName, Condition condition, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws DebuggerException {
        Object[] objectArray;
        boolean bl4;
        block27: {
            if (this.status == 3) {
                throw new DebuggerException(9);
            }
            bl4 = !varName.containsVariables();
            objectArray = null;
            try {
                objectArray = this.setCurrentObjects(string);
            }
            catch (DebuggerException debuggerException) {
                if (bl3) break block27;
                throw debuggerException;
            }
        }
        try {
            String string3;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            IscobolField iscobolField = this.findObjectVar(varName, bl4);
            if (iscobolField == null && varName != null) {
                object4 = this.findConstant(varName.getName(), false);
                if (object4 != null) {
                    throw new DebuggerException(13, "'" + varName.getName() + "'");
                }
                iscobolField = this.findGetProp(varName);
            }
            if (iscobolField == null) {
                throw new DebuggerException(7, varName != null ? "'" + varName.getName() + "'" : null);
            }
            if (iscobolField.getVar() instanceof CobolFile) {
                throw new DebuggerException(15, "'" + varName.getName() + "'");
            }
            object4 = this.getHelper();
            boolean bl5 = iscobolField.getVar() instanceof ICobolVar;
            boolean bl6 = false;
            if (bl5) {
                for (object3 = (ICobolVar)iscobolField.getVar(); object3 != null && !bl6; object3 = object3.getIParent()) {
                    bl6 = object4.isExternal(object3.getName());
                }
            }
            if (bl && !bl5) {
                throw new DebuggerException(15, "'" + varName.getName() + "'");
            }
            if (bl5 && ((ICobolVar)iscobolField.getVar()).isFinal()) {
                throw new DebuggerException(13, "'" + varName.getName() + "'");
            }
            if (iscobolField.getVar() instanceof Level88 && condition != null && (object3 = condition.getValue()) != null) {
                if (!((String)object3).equalsIgnoreCase("true") && !((String)object3).equalsIgnoreCase("false")) {
                    throw new DebuggerException(24, "'" + (String)object3 + "'");
                }
                condition.setValue(false, ((String)object3).toLowerCase());
            }
            if (string2 != null) {
                if (iscobolField.getVar() instanceof BaseGUIControl) {
                    object2 = object4.getVarObject(4, ((BaseGUIControl)iscobolField.getVar()).getName(), false);
                    object2.setIId(iscobolField.getVar());
                    iscobolField.setVar(object2);
                } else if (!(iscobolField.getVar() instanceof INumericVar)) {
                    throw new DebuggerException(21, "'" + varName.getName() + "'");
                }
            } else if (iscobolField.getVar() instanceof BaseGUIControl) {
                throw new DebuggerException(22);
            }
            object2 = this.getCurrClassname();
            if (string2 != null) {
                object = (INumericVar)iscobolField.getVar();
                string3 = DebugUtilities.inquireProp((INumericVar)object, string2, this.currProgramClass, false);
                BreakpointManager.addMonitor((INumericVar)object, varName.getFullName(), condition, (String)object2, string2, string3, bl, bl2);
            } else {
                BreakpointManager.addMonitor(varName, bl4 ? iscobolField : null, iscobolField.getVar(), varName.getFullName(), condition, (String)(bl6 ? "external" : object2), bl, bl2);
            }
            returnCode = 0;
            object = new StringBuffer();
            ((StringBuffer)object).append("'" + varName.getFullName() + "'");
            if (condition != null && condition.getType() != 0) {
                ((StringBuffer)object).append(", NOTIFY WHEN ");
                ((StringBuffer)object).append(condition);
            }
            if (!bl2) {
                ((StringBuffer)object).append(", DISABLED");
            }
            ((StringBuffer)object).append(eol);
            string3 = DebuggerException.getInfoMessage(12, ((StringBuffer)object).toString());
            return string3;
        }
        finally {
            if (!bl3) {
                this.restoreCurrentObjects(objectArray);
            }
        }
    }

    private String clearMonitor(VarName varName, String string, String string2) throws DebuggerException {
        boolean bl = false;
        if (this.status == 3) {
            if (string == null) {
                throw new DebuggerException(9);
            }
            bl = BreakpointManager.removeMonitor(string, varName.getFullName(), string2);
        } else {
            if (string == null) {
                string = this.getCurrClassname();
            }
            bl = BreakpointManager.removeMonitor(string, varName.getFullName(), string2);
        }
        if (bl) {
            returnCode = 0;
            return DebuggerException.getInfoMessage(13, "'" + varName.getFullName() + "'" + eol);
        }
        throw new DebuggerException(11, "'" + varName.getFullName() + "'");
    }

    private String clearAllMonitors() {
        BreakpointManager.removeAllMonitors();
        returnCode = 0;
        return DebuggerException.getInfoMessage(14, eol);
    }

    private String Continue() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 4;
        this.stepNumber = 1;
        returnCode = 0;
        return "";
    }

    private String stepInto(StepIntoCommand stepIntoCommand) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 1;
        this.stepNumber = stepIntoCommand.getStepNumber() > 0 ? stepIntoCommand.getStepNumber() : 1;
        returnCode = 0;
        return "";
    }

    private String stepOver() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 2;
        this.stepNumber = 1;
        this.blockDebugger = false;
        this.intoDeep = this.parStack.size();
        this.intoDeepPrg = this.getModuleStackSize();
        returnCode = 0;
        return "";
    }

    private boolean shouldCheckDynamic() {
        return lastCmd != 6;
    }

    static boolean checkDynamicIndexes(ICobolVar iCobolVar, int[] nArray) {
        return !iCobolVar.isInDynamicTable() || iCobolVar.existsDynamicElement(nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String displayTree(DisplayCommand displayCommand) throws DebuggerException {
        boolean bl = displayCommand.isDeferredIfNotRunning();
        VarName varName = displayCommand.getVarName();
        boolean bl2 = displayCommand.displayAsHex();
        boolean bl3 = displayCommand.displayAsText();
        String string = displayCommand.getClassName();
        short s2 = displayCommand.getShowChildren();
        if (this.status == 3) {
            if (bl) {
                deferredDisplayCommands.add(displayCommand);
                returnCode = 0;
                return "";
            }
            throw new DebuggerException(9);
        }
        Object[] objectArray = this.setCurrentObjects(string);
        try {
            Object object;
            IscobolField iscobolField;
            if (string == null) {
                string = this.getCurrClassname();
            }
            int[] nArray = null;
            if (varName.hasSubscript()) {
                nArray = this.resolveSubscripts(varName);
                if (nArray == null) {
                    throw new DebuggerException(5);
                }
                varName.clearSubscripts();
            }
            if ((iscobolField = this.findObjectVar(varName, false, true)) == null) {
                object = this.findConstant(varName.getName(), !bl2);
                if (object != null) {
                    int n2;
                    String string2;
                    if (bl2) {
                        string2 = DebugUtilities.buildValueStringLevel78((String)object, bl3);
                        n2 = ((String)object).length() / 2;
                    } else {
                        string2 = object;
                        n2 = ((String)object).length();
                    }
                    Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), string2, bl2, 0, n2), string);
                    returnCode = 0;
                    String string3 = DebuggerException.getInfoMessage(15, "'" + varName.getFullName() + "'" + eol);
                    return string3;
                }
                iscobolField = this.findGetProp(varName);
            }
            if (iscobolField == null) {
                throw new DebuggerException(7, varName != null ? "'" + varName.getName() + "'" : null);
            }
            if (iscobolField.getVar() instanceof ICobolVar) {
                if (varName.hasSubvalue()) {
                    nArray = null;
                }
                object = (ICobolVar)iscobolField.getVar();
                if (nArray != null && !Debugger.checkDynamicIndexes((ICobolVar)object, nArray)) {
                    Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), DebuggerConstants.NULL_VALUE, bl2), string);
                } else {
                    try {
                        Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), (ICobolVar)object, nArray, bl2, bl3, s2), string);
                    }
                    catch (IscobolRuntimeException iscobolRuntimeException) {
                        int n3;
                        String string4 = null;
                        if (iscobolRuntimeException.getErrNum() == 1) {
                            n3 = 6;
                        } else {
                            n3 = 26;
                            string4 = ": DISPLAY '" + varName.getName() + "' (" + iscobolRuntimeException + ")";
                        }
                        throw new DebuggerException(n3, string4);
                    }
                    catch (NullPointerException nullPointerException) {
                        Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), DebuggerConstants.NULL_VALUE, bl2), string);
                    }
                    catch (Exception exception) {
                        if (exception instanceof ClassCastException && object.isInDynamicTable()) {
                            throw new DebuggerException(6);
                        }
                        throw new DebuggerException(26, ": DISPLAY '" + varName.getName() + "' (" + exception + ")");
                    }
                }
            } else if (iscobolField.getVar() instanceof Level88) {
                object = (Level88)iscobolField.getVar();
                ICobolVar iCobolVar = ((Level88)object).getParent();
                if (nArray != null && !Debugger.checkDynamicIndexes(iCobolVar, nArray)) {
                    Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), DebuggerConstants.NULL_VALUE, bl2), string);
                } else {
                    try {
                        if (nArray != null) {
                            object = ((Level88)object).intAt(nArray);
                        }
                        Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), (Level88)object, bl2), string);
                    }
                    catch (Exception exception) {
                        Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), "false", bl2), string);
                    }
                }
            } else if (iscobolField.getVar() instanceof CobolFile) {
                Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), Debugger.getFileInfo((CobolFile)iscobolField.getVar()), bl2), string);
            } else {
                if (nArray != null) {
                    iscobolField.adjustIndexes(nArray);
                    iscobolField.setVar(Debugger.findObjectVarAt(iscobolField.getVar(), nArray));
                }
                Debugger.addTree(DebugUtilities.buildTree(varName.getFullName(), DebugUtilities.toString(iscobolField.getVar()), bl2), string);
            }
            returnCode = 0;
            object = DebuggerException.getInfoMessage(15, "'" + varName.getFullName() + "'" + eol);
            return object;
        }
        finally {
            this.restoreCurrentObjects(objectArray);
        }
    }

    static String getFileInfo(CobolFile cobolFile) {
        String string = "Closed ";
        switch (cobolFile.getOpenMode()) {
            case 1: {
                string = "Opened INPUT ";
                break;
            }
            case 2: {
                string = "Opened OUTPUT ";
                break;
            }
            case 3: {
                string = "Opened I-O ";
                break;
            }
            case 6: {
                string = "Opened EXTEND ";
            }
        }
        string = string + "last file-status = '" + cobolFile.getFileStatus() + "'";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String display(VarName varName, String string, String string2, boolean bl, boolean bl2) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Object[] objectArray = this.setCurrentObjects(string);
        try {
            String string3;
            Object object;
            IscobolField iscobolField = this.findObjectVar(varName, true);
            if (iscobolField == null) {
                object = this.findConstant(varName.getName(), true);
                if (object != null) {
                    dbgVar = varName;
                    dbgVar.setType(14);
                    dbgVar.setValue((String)object);
                    dbgVar.setOffset(0);
                    dbgVar.setLength(object != null ? ((String)object).length() : 0);
                } else {
                    iscobolField = this.findGetProp(varName);
                    if (iscobolField == null) {
                        throw new DebuggerException(7, varName != null ? "'" + varName.getName() + "'" : null);
                    }
                }
            }
            if (iscobolField != null) {
                dbgVar = varName;
                if (string2 != null) {
                    if (bl2) {
                        throw new DebuggerException(5);
                    }
                    if (iscobolField.getVar() instanceof BaseGUIControl) {
                        object = this.getHelper().getVarObject(4, ((BaseGUIControl)iscobolField.getVar()).getName(), false);
                        object.setIId(iscobolField.getVar());
                        iscobolField.setVar(object);
                    } else if (!(iscobolField.getVar() instanceof INumericVar)) {
                        throw new DebuggerException(21, "'" + varName.getName() + "'");
                    }
                    dbgVar.setOffset(0);
                    dbgVar.setLength(0);
                    dbgVar.setType(15);
                    dbgVar.setValue(DebugUtilities.inquireProp((INumericVar)iscobolField.getVar(), string2, this.currProgramClass, bl));
                } else {
                    if (iscobolField.getVar() instanceof BaseGUIControl) {
                        throw new DebuggerException(bl2 ? 15 : 22);
                    }
                    if (iscobolField.getVar() instanceof ICobolVar) {
                        object = (ICobolVar)iscobolField.getVar();
                        dbgVar.setType(DebugUtilities.getVarType(object, this.getHelper()));
                        try {
                            dbgVar.setValue(DebugUtilities.toString(object, DebugUtilities.MAX_DISPLAY_LENGTH()));
                            dbgVar.setOffset(object.getOffset());
                            dbgVar.setLength(object instanceof IPicAnyLength ? object.getLength() : object.getMaxLength());
                        }
                        catch (Exception exception) {
                            dbgVar.setValue(DebuggerConstants.NULL_VALUE);
                            dbgVar.setOffset(0);
                            dbgVar.setLength(0);
                        }
                    } else if (iscobolField.getVar() instanceof Level88) {
                        if (bl2) {
                            throw new DebuggerException(15);
                        }
                        object = (Level88)iscobolField.getVar();
                        dbgVar.setType(12);
                        dbgVar.setValue(((Level88)object).toString(DebugUtilities.MAX_DISPLAY_LENGTH()));
                        dbgVar.setOffset(0);
                        dbgVar.setLength(0);
                    } else if (iscobolField.getVar() instanceof CobolFile) {
                        if (bl2) {
                            throw new DebuggerException(15);
                        }
                        object = (CobolFile)iscobolField.getVar();
                        string3 = Debugger.getFileInfo((CobolFile)object);
                        dbgVar.setType(13);
                        dbgVar.setValue(string3);
                        dbgVar.setOffset(0);
                        dbgVar.setLength(0);
                    } else if (iscobolField.getVar() == NULL_OBJECT) {
                        dbgVar.setType(2);
                        dbgVar.setValue(DebuggerConstants.NULL_VALUE);
                        dbgVar.setOffset(0);
                        dbgVar.setLength(0);
                    } else {
                        dbgVar.setType(2);
                        object = DebugUtilities.toString(iscobolField.getVar());
                        dbgVar.setValue((String)object);
                        dbgVar.setOffset(0);
                        dbgVar.setLength(object == DebuggerConstants.NULL_VALUE || object == DebuggerConstants.ERROR_VALUE ? 0 : ((String)object).length());
                    }
                }
            }
            returnCode = 0;
            object = new StringBuffer("+ " + varName.getFullName());
            if (string2 != null) {
                ((StringBuffer)object).append("::" + string2);
            }
            ((StringBuffer)object).append(" = " + dbgVar.getValue() + eol);
            string3 = ((StringBuffer)object).toString();
            return string3;
        }
        finally {
            this.restoreCurrentObjects(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String displayAsHexString(VarName varName, String string) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Object[] objectArray = this.setCurrentObjects(string);
        try {
            Object object;
            IscobolField iscobolField = this.findObjectVar(varName, true);
            String string2 = this.findConstant(varName.getName(), false);
            StringBuffer stringBuffer = new StringBuffer();
            if (string2 != null) {
                dbgVar = varName;
                object = DebugUtilities.buildValueStringLevel78(string2, false);
                dbgVar.setValue((String)object);
                dbgVar.setType(14);
                dbgVar.setOffset(0);
                dbgVar.setLength(string2.length());
                stringBuffer.append((String)object);
            } else {
                if (iscobolField == null) {
                    iscobolField = this.findGetProp(varName);
                }
                if (iscobolField == null) {
                    throw new DebuggerException(7, varName != null ? "'" + varName.getName() + "'" : null);
                }
                if (iscobolField.getVar() instanceof Level88) {
                    dbgVar = varName;
                    dbgVar.setType(12);
                    try {
                        dbgVar.setValue(DebugUtilities.toString(iscobolField.getVar(), DebugUtilities.MAX_DISPLAY_LENGTH()));
                    }
                    catch (Exception exception) {
                        dbgVar.setValue(DebuggerConstants.NULL_VALUE);
                    }
                } else {
                    if (!(iscobolField.getVar() instanceof ICobolVar)) {
                        throw new DebuggerException(15, "'" + varName.getName() + "'");
                    }
                    dbgVar = varName;
                    object = (ICobolVar)iscobolField.getVar();
                    dbgVar.setType(DebugUtilities.getVarType(object, this.getHelper()));
                    try {
                        stringBuffer.append(DebugUtilities.toHexString((ICobolVar)object, DebugUtilities.MAX_DISPLAY_LENGTH()));
                        dbgVar.setValue(stringBuffer.toString());
                    }
                    catch (Exception exception) {
                        dbgVar.setValue(DebuggerConstants.NULL_VALUE);
                        stringBuffer.append(DebuggerConstants.NULL_VALUE);
                    }
                }
            }
            returnCode = 0;
            object = stringBuffer.insert(0, "+ " + varName.getFullName() + " = ").append(eol).toString();
            return object;
        }
        finally {
            this.restoreCurrentObjects(objectArray);
        }
    }

    private String findConstant(String string, boolean bl) {
        Object object = null;
        if (this.currMethod != null) {
            object = this.currMethod;
        } else if (this.currProgram != null) {
            object = this.currProgram;
        }
        if (object != null) {
            return DebugUtilities.findConstant(string, object, bl);
        }
        return null;
    }

    private String let(VarName varName, String string, String string2, String string3) throws DebuggerException {
        Object object;
        IscobolField iscobolField;
        Object[] objectArray;
        block27: {
            if (this.status == 3) {
                throw new DebuggerException(9);
            }
            objectArray = this.setCurrentObjects(string);
            iscobolField = this.findObjectVar(varName, true);
            if (iscobolField == null && varName != null) {
                object = this.findConstant(varName.getName(), false);
                if (object != null) {
                    throw new DebuggerException(13, "'" + varName.getName() + "'");
                }
                iscobolField = this.findSetProp(varName);
            }
            if (iscobolField == null) {
                throw new DebuggerException(7, varName != null ? "'" + varName.getName() + "'" : null);
            }
            if (string2 != null) {
                if (iscobolField.getVar() instanceof BaseGUIControl) {
                    object = this.getHelper().getVarObject(4, ((BaseGUIControl)iscobolField.getVar()).getName(), false);
                    object.setIId(iscobolField.getVar());
                    iscobolField.setVar(object);
                } else if (!(iscobolField.getVar() instanceof INumericVar)) {
                    throw new DebuggerException(21, "'" + varName.getName() + "'");
                }
                DebugUtilities.modifyProp((INumericVar)iscobolField.getVar(), string2, string3, this.currProgramClass);
                returnCode = 0;
                object = "+ new value of " + varName.getFullName() + "::" + string2 + " is " + DebugUtilities.inquireProp((INumericVar)iscobolField.getVar(), string2, this.currProgramClass, false) + eol;
                return object;
            }
            if (iscobolField.getVar() instanceof BaseGUIControl) {
                throw new DebuggerException(22);
            }
            if (iscobolField.getVar() instanceof Level88) {
                if (!string3.equalsIgnoreCase("true") && !string3.equalsIgnoreCase("false")) {
                    throw new DebuggerException(24, "'" + string3 + "'");
                }
                object = (Level88)iscobolField.getVar();
                try {
                    ((Level88)object).setValue(Boolean.valueOf(string3));
                    String string4 = "+ new value of " + varName.getFullName() + " is " + object + eol;
                    return string4;
                }
                catch (Exception exception) {
                    throw new DebuggerException(26, ": LET '" + varName.getName() + "' (" + exception + ")");
                }
            }
            if (!(iscobolField.getVar() instanceof ICobolVar)) break block27;
            object = (ICobolVar)iscobolField.getVar();
            if (object.isFinal()) {
                throw new DebuggerException(13, "'" + varName.getName() + "'");
            }
            try {
                IDebuggerHelper iDebuggerHelper = this.getHelper();
                ICobolVar iCobolVar = object instanceof INumericVar ? iDebuggerHelper.numVal(string3, object.isDecimalPointComma()) : (object instanceof IPicNumEdit ? iDebuggerHelper.numValC(string3, object.isDecimalPointComma(), ((IPicNumEdit)object).getCurrencyChar()) : iDebuggerHelper.getStrLiteral(string3));
                object.setValue(iCobolVar);
                returnCode = 0;
                String string5 = "+ new value of " + varName.getFullName() + " is " + object + eol;
                return string5;
            }
            catch (Exception exception) {
                throw new DebuggerException(26, ":LET '" + varName.getName() + "' (" + exception + ")");
            }
        }
        if (iscobolField instanceof IscobolProp && iscobolField.isCobolVar()) {
            try {
                object = this.getHelper();
                ICobolVar iCobolVar = INumericVar.class.isAssignableFrom(iscobolField.getType()) ? object.numVal(string3, false) : (IPicNumEdit.class.isAssignableFrom(iscobolField.getType()) ? object.numValC(string3, false, '$') : object.getStrLiteral(string3));
                ((IscobolProp)iscobolField).setValue(iCobolVar, this);
                returnCode = 0;
                String string6 = "+ new value of " + varName.getFullName() + " is " + iCobolVar + eol;
                return string6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable.getCause() != null) {
                    throwable2 = throwable.getCause();
                }
                throw new DebuggerException(26, ":LET '" + varName.getName() + "' (" + throwable2 + ")");
            }
        }
        throw new DebuggerException(15, "'" + varName.getName() + "'");
        finally {
            this.restoreCurrentObjects(objectArray);
        }
    }

    private String letAsHex(VarName varName, String string, String string2) throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        Object[] objectArray = this.setCurrentObjects(string);
        try {
            Object object;
            IscobolField iscobolField = this.findObjectVar(varName, true);
            if (iscobolField == null && varName != null) {
                object = this.findConstant(varName.getName(), false);
                if (object != null) {
                    throw new DebuggerException(13, "'" + varName.getName() + "'");
                }
                iscobolField = this.findSetProp(varName);
            }
            if (iscobolField == null) {
                throw new DebuggerException(7, varName != null ? "'" + varName.getName() + "'" : null);
            }
            if (iscobolField.getVar() instanceof ICobolVar) {
                object = (ICobolVar)iscobolField.getVar();
                if (object.isFinal()) {
                    throw new DebuggerException(13, "'" + varName.getName() + "'");
                }
                boolean bl = false;
                try {
                    bl = DebugUtilities.setValueAsHex((ICobolVar)object, string2);
                }
                catch (Exception exception) {
                    throw new DebuggerException(26, ": LET '" + varName.getName() + "' (" + exception + ")");
                }
                if (bl) {
                    returnCode = 0;
                    String string3 = "+ new value of " + varName.getFullName() + " is " + DebugUtilities.toHexString((ICobolVar)object, DebugUtilities.MAX_DISPLAY_LENGTH()) + eol;
                    return string3;
                }
                throw new DebuggerException(32, "'" + string2 + "'");
            }
            if (iscobolField instanceof IscobolProp && iscobolField.isCobolVar()) {
                try {
                    ((IscobolProp)iscobolField).setHexValue(string2, this);
                }
                catch (DebuggerException debuggerException) {
                    throw debuggerException;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable.getCause() != null) {
                        throwable2 = throwable.getCause();
                    }
                    throw new DebuggerException(26, ": LET '" + varName.getName() + "' (" + throwable2 + ")");
                }
                returnCode = 0;
                object = "+ new value of " + varName.getFullName() + " is " + string2 + eol;
                return object;
            }
            throw new DebuggerException(15, "'" + varName.getName() + "'");
        }
        finally {
            this.restoreCurrentObjects(objectArray);
        }
    }

    private String stepOutOfParagraph() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 5;
        this.stepNumber = 1;
        this.blockDebugger = false;
        this.intoDeep = this.parStack.size();
        returnCode = 0;
        return "";
    }

    private String stepOutOfProgram() throws DebuggerException {
        if (this.status == 3) {
            throw new DebuggerException(9);
        }
        this.status = 6;
        this.stepNumber = 1;
        this.blockDebugger = false;
        this.intoDeepPrg = this.getModuleStackSize();
        returnCode = 0;
        return "";
    }

    ParagraphObject[] getParStack() {
        ParagraphObject[] paragraphObjectArray = new ParagraphObject[this.parStack.size()];
        this.parStack.toArray(paragraphObjectArray);
        return paragraphObjectArray;
    }

    private String traceOn(TraceOnCommand traceOnCommand) {
        Config.b("iscobol.tracelevel", "" + traceOnCommand.getTraceLevel());
        String string = traceOnCommand.getLogfileName();
        if (string != null && string.length() > 0) {
            Config.b("iscobol.logfile", string);
        }
        returnCode = 0;
        return DebuggerException.getInfoMessage(16, "tracelevel = " + traceOnCommand.getTraceLevel() + (string != null ? ", logfile = " + LoggerFactory.getLogFile() : "") + eol);
    }

    private String traceOff() throws DebuggerException {
        if (LoggerFactory.getTraceLevel() == 0) {
            throw new DebuggerException(17);
        }
        Config.b("iscobol.tracelevel", "0");
        returnCode = 0;
        return DebuggerException.getInfoMessage(17, eol);
    }

    public static void enterPar(int n2, String string, String string2, int n3, Class clazz, Object object, Object object2) {
        try {
            Debugger.intEnterPar(n2, string, -1, string2, n3, clazz, object, object2, null, false);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void enterPar(int n2, String string, String string2, int n3, Class clazz, Object object, Object object2, String string3) {
        try {
            Debugger.intEnterPar(n2, string, -1, string2, n3, clazz, object, object2, string3, false);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void enterPar(int n2, String string, int n3, String string2, int n4, Class clazz, Object object, Object object2, String string3) {
        try {
            Debugger.intEnterPar(n2, string, n3, string2, n4, clazz, object, object2, string3, false);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void enterParExt(int n2, String string, int n3, String string2, int n4, Class clazz, Object object, Object object2, String string3, boolean bl) throws GotoException {
        Debugger.intEnterPar(n2, string, n3, string2, n4, clazz, object, object2, string3, bl);
    }

    private static void intEnterPar(int n2, String string, int n3, String string2, int n4, Class clazz, Object object, Object object2, String string3, boolean bl) throws GotoException {
        Debugger debugger = null;
        AppData appData = Debugger.getAppData();
        if (appData.parStackLog != null) {
            appData.parStackLog.info("ENTER PARAGRAPH '" + string2 + "' [" + clazz.getName() + (string3 != null ? ":>" + string3 : "") + "]");
        }
        if (globalStatus.getValue() != 0) {
            debugger = Debugger.getCurrentDebugger();
            boolean bl2 = debugger.lastPerformParnum == 0 || n4 == debugger.lastPerformParnum;
            String string4 = Debugger.getClassLocation(clazz);
            String string5 = null;
            if (object2 == clazz) {
                object2 = null;
                string5 = string3;
                string3 = null;
            }
            ParagraphObject paragraphObject = new ParagraphObject(string, n3, string2, bl2, clazz, object, string4, object2, string3, debugger.progStack.size(), debugger.methodStack.size(), n2, bl, n4);
            if (string5 != null) {
                paragraphObject.setEntryPointName(string5);
            }
            debugger.parStack.push(paragraphObject);
            debugger.currMethodName = string3;
            if (debugger.threadObj.getDescription() == null) {
                debugger.threadObj.setDescription(string2 + " [" + clazz.getName() + "]");
            }
            debugger.oldLine = debugger.currLine;
            debugger.oldFile = debugger.currFile;
            debugger.oldProgramClass = debugger.currProgramClass;
            debugger.oldFileIndex = debugger.currFileIndex;
            debugger.currLine = n2;
            debugger.currFile = string;
            debugger.currFileIndex = n3;
            debugger.setCurrProgramClass(clazz);
            debugger.currProgramClassLocation = string4;
            if (debugger.currMethod != object2) {
                debugger.updateMethodObj(object2);
            }
            debugger.currMethodClass = object2 != null ? object2.getClass() : null;
            debugger.currMethod = object2;
            if (debugger.status != 11) {
                debugger.blockDebugger = false;
            }
            if (debugger.currProgram != object) {
                debugger.updateProgramObj(object);
            }
            debugger.currProgram = object;
            debugger.debug(string2);
        } else {
            debugger = Debugger.getCurrentDebugger();
            boolean bl3 = debugger.lastPerformParnum == 0 || n4 == debugger.lastPerformParnum;
            debugger.parStack.push(new ParagraphObject(string, n3, string2, bl3, clazz, object, null, object2, string3, debugger.progStack.size(), debugger.methodStack.size(), n2, bl, n4));
            debugger.currMethodName = string3;
        }
    }

    public static void exitPar() {
        ParagraphObject paragraphObject = null;
        Debugger debugger = Debugger.getCurrentDebugger();
        if (!debugger.parStack.isEmpty()) {
            paragraphObject = debugger.parStack.pop();
            if (globalStatus.getValue() != 0) {
                if (debugger.appData.parStackLog != null) {
                    debugger.appData.parStackLog.info("EXIT PARAGRAPH '" + paragraphObject.getName() + "' [" + paragraphObject.getProgName() + "]");
                }
                debugger.blockDebugIfNecessary(paragraphObject);
                if (paragraphObject.isLastPar()) {
                    debugger.lastPerformParnum = 0;
                }
            } else if (debugger.appData.parStackLog != null) {
                debugger.appData.parStackLog.info("EXIT PARAGRAPH '" + paragraphObject.getName() + "' [" + paragraphObject.getProgName() + "]");
            }
        }
    }

    public static void outlinePerform(int n2, String string, int n3) {
        Debugger debugger = Debugger.getCurrentDebugger();
        debugger.lastPerformParnum = n3;
        try {
            debugger.intStatement(n2, string, -1);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void outlinePerform(int n2, String string, int n3, int n4) {
        Debugger debugger = Debugger.getCurrentDebugger();
        debugger.lastPerformParnum = n4;
        try {
            debugger.intStatement(n2, string, n3);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static boolean outlinePerformExt(int n2, String string, int n3, int n4) throws GotoException {
        Debugger debugger = Debugger.getCurrentDebugger();
        debugger.lastPerformParnum = n4;
        return debugger.intStatement(n2, string, n3);
    }

    public static void statement(int n2, String string, String string2) {
        Debugger debugger = Debugger.getCurrentDebugger();
        try {
            debugger.intStatement(n2, string, -1);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void statement(int n2, String string) {
        Debugger debugger = Debugger.getCurrentDebugger();
        try {
            debugger.intStatement(n2, string, -1);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static void statement(int n2, String string, int n3) {
        Debugger debugger = Debugger.getCurrentDebugger();
        try {
            debugger.intStatement(n2, string, n3);
        }
        catch (GotoException gotoException) {
            // empty catch block
        }
    }

    public static boolean statementExt(int n2, String string, int n3) throws GotoException {
        Debugger debugger = Debugger.getCurrentDebugger();
        return debugger.intStatement(n2, string, n3);
    }

    private boolean intStatement(int n2, String string, int n3) throws GotoException {
        if (globalStatus.getValue() != 0) {
            this.oldLine = this.currLine;
            this.oldFile = this.currFile;
            this.oldFileIndex = this.currFileIndex;
            this.oldProgramClass = this.currProgramClass;
            this.currLine = n2;
            this.currFile = string;
            this.currFileIndex = n3;
            if (!this.parStack.isEmpty()) {
                ParagraphObject paragraphObject = this.parStack.peek();
                paragraphObject.setLine(this.currLine);
                paragraphObject.setFile(this.currFile);
                paragraphObject.setFileIndex(this.currFileIndex);
            }
            if (n2 < 0) {
                switch (this.status) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: {
                        return false;
                    }
                }
                return true;
            }
            if ((this.status == 2 || this.status == 12) && this.intoDeep == this.parStack.size() && this.intoDeepPrg == this.getModuleStackSize()) {
                this.blockDebugger = true;
            }
            return this.debug(null);
        }
        return true;
    }

    public static void enterMethod(Class clazz, Object object, Object object2) {
        Debugger.enterMethod(clazz, object, object2, null);
    }

    public static void enterMethod(Class clazz, Object object, Object object2, String string) {
        Debugger debugger = null;
        if (globalStatus.getValue() != 0) {
            debugger = Debugger.getCurrentDebugger();
            debugger.methodStack.push(new MethodObject(object2, clazz, object, string));
            if (string != null && debugger.appData.parStackLog != null) {
                debugger.appData.parStackLog.info("ENTER METHOD " + clazz.getName() + ":>" + string + " {");
            }
            debugger.updateMethodObj(object2);
            debugger.currMethod = object2;
            debugger.currMethodName = string;
            debugger.currMethodClass = object2.getClass();
            debugger.setCurrProgramClass(clazz);
            debugger.currProgram = object;
            debugger.executeDeferredOperations();
        } else {
            debugger = Debugger.getCurrentDebugger();
            debugger.methodStack.push(new MethodObject(object2, clazz, object, string));
            if (string != null && debugger.appData.parStackLog != null) {
                debugger.appData.parStackLog.info("ENTER METHOD " + clazz.getName() + ":>" + string + " {");
            }
            debugger.currMethodName = string;
        }
    }

    private boolean blockDebugIfNecessary(ParagraphObject paragraphObject) {
        int n2 = Debugger.getStatus();
        if ((n2 == 5 || n2 == 9) && this.intoDeep > this.parStack.size() || (n2 == 2 || n2 == 12) && this.intoDeep >= this.parStack.size() && this.intoDeepPrg >= this.getModuleStackSize() && paragraphObject.isLastPar()) {
            this.blockDebugger = true;
        }
        return this.blockDebugger;
    }

    private boolean blockDebugIfNecessary() {
        int n2 = this.getModuleStackSize();
        if ((this.status == 6 || this.status == 10) && this.intoDeepPrg > n2 || (this.status == 2 || this.status == 12) && this.intoDeep >= this.parStack.size() && this.intoDeepPrg >= n2) {
            this.blockDebugger = true;
        }
        return this.blockDebugger;
    }

    private int getModuleStackSize() {
        return this.progStack.size() + this.methodStack.size();
    }

    public static void exitMethod() {
        Debugger.getCurrentDebugger().intExitMethod();
    }

    private void intExitMethod() {
        MethodObject methodObject = this.methodStack.pop();
        this.removeMethParagraphs(this.methodStack.size() + 1);
        if (this.currMethodName != null && this.appData.parStackLog != null) {
            this.appData.parStackLog.info("EXIT METHOD " + methodObject.getProgramClass().getName() + ":>" + this.currMethodName + " }");
        }
        if (!this.parStack.isEmpty()) {
            ParagraphObject paragraphObject = this.parStack.peek();
            this.currMethodName = paragraphObject.getMethodName();
            if (globalStatus.getValue() != 0) {
                if (this.currMethod != paragraphObject.getMethod()) {
                    this.updateMethodObj(paragraphObject.getMethod());
                }
                this.currMethod = paragraphObject.getMethod();
                Class clazz = this.currMethodClass = this.currMethod != null ? this.currMethod.getClass() : null;
                if (this.currProgram != paragraphObject.getProgram()) {
                    this.updateProgramObj(paragraphObject.getProgram());
                }
                this.currProgram = paragraphObject.getProgram();
                this.setCurrProgramClass(paragraphObject.getProgClass());
                if (paragraphObject.isLastPar()) {
                    this.lastPerformParnum = 0;
                }
                if (!this.blockDebugger && !this.blockDebugIfNecessary(paragraphObject)) {
                    this.blockDebugIfNecessary();
                }
            }
        }
    }

    private void addMonitors(String string, String string2) {
        Watch[] watchArray = BreakpointManager.getMonitorToAdd(string);
        if (watchArray.length > 0) {
            for (int i2 = 0; i2 < watchArray.length; ++i2) {
                int n2 = returnCode;
                try {
                    this.setMonitor(watchArray[i2].getVarName(), watchArray[i2].getCondition(), string2, watchArray[i2].getPropName(), watchArray[i2].isHexadecimal(), watchArray[i2].isEnabled(), true);
                }
                catch (DebuggerException debuggerException) {
                    // empty catch block
                }
                returnCode = n2;
            }
            BreakpointManager.removeMonitorToAdd(string);
        }
    }

    private void executeDeferredOperations() {
        String string = this.getCurrClassname();
        this.addMonitors(string, string);
        this.addMonitors("external", null);
        while (!deferredDisplayCommands.isEmpty()) {
            try {
                this.displayTree((DisplayCommand)deferredDisplayCommands.remove(0));
            }
            catch (DebuggerException debuggerException) {}
        }
    }

    public static void enterProgram(String string, Object object) {
        Debugger debugger = null;
        if (globalStatus.getValue() != 0) {
            debugger = Debugger.getCurrentDebugger();
            debugger.progStack.push(object);
            debugger.setCurrProgramClass(object.getClass());
            if (debugger.currProgram != object) {
                debugger.updateProgramObj(object);
            }
            debugger.currProgram = object;
            debugger.oldFile = debugger.currFile;
            debugger.currFile = string;
            debugger.currFileIndex = -1;
            boolean bl = debugger.blockDebugger = debugger.status == 11;
            if (object != null) {
                debugger.executeDeferredOperations();
            }
        } else {
            debugger = Debugger.getCurrentDebugger();
            debugger.progStack.push(object);
        }
    }

    public static void exitProgram() {
        Debugger debugger = Debugger.getCurrentDebugger();
        if (debugger.currMethod == null) {
            debugger.intExitProgram();
        } else {
            debugger.intExitMethod();
        }
    }

    private void setCurrProgramClass(Class clazz) {
        this.currProgramClass = clazz;
        this.currProgramClassLocation = Debugger.getClassLocation(clazz);
        this.hyphenRepl = (char)95;
        this.cod1 = false;
        try {
            for (String string : DebugUtilities.getCompilerOptions(clazz)) {
                if ("-smfu".equalsIgnoreCase(string)) {
                    this.hyphenRepl = (char)36;
                } else {
                    if (!"-cod1".equalsIgnoreCase(string)) continue;
                    this.cod1 = true;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getClassLocation(Class clazz) {
        String[] stringArray = classLocations.get(clazz);
        if (stringArray == null) {
            File file;
            stringArray = new String[1];
            if (clazz.getClassLoader() instanceof CallLoader.LoaderWithTime && (file = ((CallLoader.LoaderWithTime)clazz.getClassLoader()).getClassLocation()).isDirectory()) {
                stringArray[0] = file.getAbsolutePath();
            }
            classLocations.put(clazz, stringArray);
        }
        return stringArray[0];
    }

    private void intExitProgram() {
        if (globalStatus.getValue() != 0) {
            this.progStack.pop();
            this.removeProgParagraphs(this.progStack.size() + 1);
            if (!this.parStack.isEmpty()) {
                ParagraphObject paragraphObject = this.parStack.peek();
                this.currMethodName = paragraphObject.getMethodName();
                this.setCurrProgramClass(paragraphObject.getProgClass());
                if (this.currProgram != paragraphObject.getProgram()) {
                    this.updateProgramObj(paragraphObject.getProgram());
                }
                this.currProgram = paragraphObject.getProgram();
                if (this.currMethod != paragraphObject.getMethod()) {
                    this.updateMethodObj(paragraphObject.getMethod());
                }
                this.currMethod = paragraphObject.getMethod();
                Class clazz = this.currMethodClass = this.currMethod != null ? this.currMethod.getClass() : null;
                if (paragraphObject.isLastPar()) {
                    this.lastPerformParnum = 0;
                }
                this.blockDebugIfNecessary(paragraphObject);
            }
            if (!this.blockDebugger) {
                this.blockDebugIfNecessary();
            }
        } else {
            this.progStack.pop();
            this.removeProgParagraphs(this.progStack.size() + 1);
        }
    }

    public static void exit() {
        Debugger.exit(0);
    }

    public static void exit(int n2) {
        int n3 = globalStatus.getValue();
        if (n3 != 0 && n3 != 3) {
            Debugger.writeResponse(new DebugResponse(103, ""));
        }
        System.exit(n2);
    }

    public static void stop(String string) {
        Debugger.stop(null, null, 0, true, string);
    }

    public static void stop(String string, String string2, int n2, boolean bl, String string3) {
        IDebuggerHelper iDebuggerHelper = Debugger.getCurrentDebugger().getHelper();
        iDebuggerHelper.displayUponSysOut(false, string3, string2, n2, bl);
        if (!Debugger.suspending()) {
            iDebuggerHelper.acceptFromConsole(string);
        }
    }

    private void removeProgParagraphs(int n2) {
        ParagraphObject paragraphObject;
        int n3 = this.parStack.size();
        for (int i2 = n3 - 1; i2 >= 0 && (paragraphObject = (ParagraphObject)this.parStack.elementAt(i2)).getProgStackSize() == n2; --i2) {
            this.parStack.remove(i2);
        }
    }

    private void removeMethParagraphs(int n2) {
        ParagraphObject paragraphObject;
        int n3 = this.parStack.size();
        for (int i2 = n3 - 1; i2 >= 0 && (paragraphObject = (ParagraphObject)this.parStack.elementAt(i2)).getMethStackSize() == n2; --i2) {
            this.parStack.remove(i2);
        }
    }

    private static void suspend() {
        globalStatus.setValue(1);
    }

    private static void resume() {
        Debugger.resume(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resume(int n2) {
        globalStatus.setValue(n2);
        GlobalStatus globalStatus = Debugger.globalStatus;
        synchronized (globalStatus) {
            Debugger.globalStatus.notifyAll();
        }
    }

    public static void attach(InputStream inputStream, OutputStream outputStream) {
        Debugger.attach(inputStream, outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attach(InputStream inputStream, OutputStream outputStream, boolean bl) {
        Object object;
        Debugger.suspend();
        DebugResponse debugResponse = null;
        if (activeDebugger == null) {
            if (bl) {
                debugResponse = new DebugResponse(0, "", 2);
                object = IscobolSystem.isAS() ? "isCOBOL Application Server" : "Loading...";
                debugResponse.setInfo(new DebugResponse.DebugInfo((String)object));
            }
        } else {
            long l2;
            String string2;
            Watch[] watchArray;
            ThreadObject[] threadObjectArray;
            object = debuggerInstances;
            synchronized (object) {
                threadObjectArray = debuggerInstances.elements();
                while (threadObjectArray.hasMoreElements()) {
                    watchArray = (Watch[])threadObjectArray.nextElement();
                    ((Watch[])threadObjectArray.nextElement()).status = 4;
                    watchArray.stepNumber = 1;
                }
            }
            object = new int[1];
            threadObjectArray = Debugger.getThreads(true, (int[])object);
            watchArray = BreakpointManager.getMonitors(activeDebugger.getCurrClassname(), activeDebugger);
            try {
                string2 = DebugUtilities.getSourcefile(Debugger.activeDebugger.currProgramClass);
            }
            catch (Exception exception) {
                string2 = "";
            }
            try {
                l2 = DebugUtilities.getTimestamp(Debugger.activeDebugger.currProgramClass);
            }
            catch (Exception exception) {
                l2 = 0L;
            }
            debugResponse = new DebugResponse(0, Debugger.activeDebugger.currLine, null, watchArray, threadObjectArray, (int)object[0], Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory(), Debugger.activeDebugger.currFile, Debugger.activeDebugger.currFileIndex, string2, l2, 2, null, (Tree[])null, "");
            debugResponse.setInfo(Debugger.getInfo(991, Debugger.activeDebugger.currProgramClass));
        }
        debugDataOut = new DataOutputStream(outputStream);
        debugDataIn = new DataInputStream(inputStream);
        commandListener = new CommandListener(debugDataIn, blockingMode);
        debugIn = commandListener.getInputStream();
        if (bl) {
            Debugger.firstWrite[0] = true;
        }
        debugOut = new DebugOutputStream(string -> DebugUtilities.writeRawText(debugDataOut, string, firstWrite));
        debugErr = new DebugOutputStream(string -> DebugUtilities.writeErrorMessage(debugDataOut, string, firstWrite));
        if (redirectStreams) {
            System.setIn(debugIn);
            System.setOut(debugOut);
            System.setErr(debugErr);
        }
        lastCmd = 3;
        returnCode = 0;
        if (bl) {
            debugResponse.setFirstBlockMode(blockingMode);
            firstProcess = false;
            if (blockingMode == 1) {
                firstBlock = true;
            }
            Debugger.writeResponse(debugResponse);
        }
        globalStatus.setThrowStopRunException(false);
        Debugger.resume(4);
        if (doNotify) {
            doNotify = false;
            object = connList;
            synchronized (object) {
                connList.notifyAll();
            }
        }
        commandListener.start();
    }

    public static boolean isBreakpointCommand(int n2) {
        switch (n2) {
            case 0: 
            case 9: 
            case 19: 
            case 23: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRuntimeCommand(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 56: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMonitorCommand(int n2) {
        switch (n2) {
            case 13: 
            case 14: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unattach(boolean bl) {
        System.setIn(systemIn);
        System.setOut(systemOut);
        System.setErr(systemErr);
        connList.endConnection();
        commandListener = null;
        Hashtable hashtable = debuggerInstances;
        synchronized (hashtable) {
            Enumeration enumeration = debuggerInstances.elements();
            while (enumeration.hasMoreElements()) {
                Debugger debugger = (Debugger)enumeration.nextElement();
                ((Debugger)enumeration.nextElement()).status = 0;
                debugger.stepNumber = 1;
            }
        }
        globalStatus.setWait(false);
        globalStatus.setThrowStopRunException(bl);
        Debugger.resume(3);
    }

    private void updateProgramObj(Object object) {
        this.theProgramObj = object == null ? null : Debugger.getProgramObj(object);
    }

    private void updateMethodObj(Object object) {
        this.theMethodObj = object == null ? null : Debugger.getMethodObj(object);
    }

    private static Object getProgramObj(Object object) {
        try {
            Field field = object.getClass().getDeclaredField("$$theProgram$$");
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object getMethodObj(Object object) {
        try {
            Field field = object.getClass().getDeclaredField("$$theMethod$$");
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean suspending() {
        if (globalStatus.getValue() != 0 && globalStatus.getValue() != 3) {
            globalStatus.setValue(5);
            return true;
        }
        return false;
    }

    public static int getStatus() {
        return Debugger.getCurrentDebugger().status;
    }

    private static String getFilename(String string) {
        return string == null || string.length() == 0 ? string : new File(string).getName();
    }

    static FileLoader getFileLoader() {
        return activeDebugger != null ? Debugger.activeDebugger.appData.fileLoader : null;
    }

    static DebugResponse getResponse(String string, int n2) {
        boolean bl = activeDebugger != null ? Debugger.activeDebugger.status != 3 : false;
        return Debugger.getResponse(null, bl, 0, string, n2);
    }

    private static DebugResponse getResponse(Debugger debugger, boolean bl, int n2, String string, int n3) {
        Breakpoint[] breakpointArray = null;
        Watch[] watchArray = null;
        ThreadObject[] threadObjectArray = null;
        int[] nArray = new int[]{-1};
        Tree[] treeArray = null;
        String string2 = "";
        String string3 = "";
        long l2 = 0L;
        int n4 = 0;
        int n5 = 0;
        String string4 = "";
        int n6 = 0;
        int n7 = 0;
        String string5 = "";
        if (isCompositeCmd || Debugger.isBreakpointCommand(n3)) {
            breakpointArray = BreakpointManager.getBreakpoints();
        }
        if (debugger != null) {
            n4 = debugger.currLine;
            string4 = debugger.currFile;
            n5 = debugger.currFileIndex;
            n6 = debugger.oldLine;
            string5 = debugger.oldFile;
            n7 = debugger.oldFileIndex;
            if (isCompositeCmd || Debugger.isRuntimeCommand(n3) || Debugger.isMonitorCommand(n3)) {
                watchArray = BreakpointManager.getMonitors(debugger.getCurrClassname(), debugger);
            }
            if (bl) {
                threadObjectArray = Debugger.getThreads(true, nArray);
            }
            if (tree != null && !tree.isEmpty()) {
                treeArray = new Tree[tree.size()];
                tree.toArray(treeArray);
            }
            try {
                string2 = DebugUtilities.getSourcefile(debugger.currProgramClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string3 = DebugUtilities.getSourcefile(debugger.oldProgramClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                l2 = DebugUtilities.getTimestamp(debugger.currProgramClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DebugResponse debugResponse = new DebugResponse(returnCode, n4, breakpointArray, watchArray, threadObjectArray, nArray[0], bl ? Runtime.getRuntime().totalMemory() : 0L, bl ? Runtime.getRuntime().freeMemory() : 0L, string4, n5, string2, l2, n3, dbgVar, treeArray, string);
        debugResponse.setOldLine(n6);
        debugResponse.setOldFile(string5);
        debugResponse.setOldFileIndex(n7);
        debugResponse.setOldProgram(string3);
        debugResponse.setFirstBlockMode(n2);
        if (dbgEnvValue != null) {
            debugResponse.setVarValue(dbgEnvValue);
        }
        return debugResponse;
    }

    static void setRedirectStreams(boolean bl) {
        if (redirectStreams != bl) {
            redirectStreams = bl;
            if (redirectStreams) {
                System.setOut(debugOut);
                System.setErr(debugErr);
            } else {
                System.setOut(systemOut);
                System.setErr(systemErr);
            }
        }
    }

    static int getActiveDebuggerStatus() {
        return activeDebugger != null ? Debugger.activeDebugger.status : 3;
    }

    static {
        redirectStreams = true;
        globalStatus = new GlobalStatus(0);
        firstProcess = true;
        firstWrite = new boolean[]{true};
        debuggerInstances = new Hashtable();
        deferredDisplayCommands = new Vector();
        classLocations = new HashMap<Class, String[]>();
    }

    private static class MyNotifier
    implements MonitorNotifier {
        Debugger dbg;

        MyNotifier(Debugger debugger) {
            this.dbg = debugger;
        }

        @Override
        public void startThread() {
            Debugger.enterThread(this.dbg);
        }

        @Override
        public void endThread() {
            Debugger.exitThread();
        }
    }

    private static class AppData
    implements PropertyChangeListener {
        private Logger parStackLog;
        private FileLoader fileLoader;
        private String codePrefix = "";
        private CallLoader callLoader;

        private AppData() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(Config.a() + "tracelevel")) {
                this.parStackLog = LoggerFactory.get(4);
            }
        }

        CallLoader getCallLoader() {
            String string = Config.a(".code_prefix", "");
            if (!string.equals(this.codePrefix)) {
                this.callLoader = CallLoader.getInstance(string, false);
                this.codePrefix = string;
            }
            return this.callLoader;
        }
    }

    private static class GlobalStatus {
        private int value = 1;
        private boolean waitConnection;
        private boolean throwStopRunException;

        public GlobalStatus(int n2) {
            this.setValue(n2);
        }

        public boolean getThrowStopRunException() {
            return this.throwStopRunException;
        }

        public synchronized void setThrowStopRunException(boolean bl) {
            this.throwStopRunException = bl;
        }

        public synchronized void setWait(boolean bl) {
            this.waitConnection = bl;
        }

        public synchronized boolean getWait() {
            return this.waitConnection;
        }

        public synchronized void setValue(int n2) {
            this.value = n2;
        }

        public synchronized int getValue() {
            return this.value;
        }

        public synchronized int mustSuspend() {
            if (this.getThrowStopRunException()) {
                return 2;
            }
            if (this.value == 5) {
                this.value = 2;
                return 1;
            }
            if (this.value == 4) {
                this.value = 2;
                return blockingMode != 1 ? 1 : 0;
            }
            return 0;
        }
    }

    public static class SelfDataItem
    extends IscobolDataItem {
        SelfDataItem(Object object) {
            this.var = object;
        }

        @Override
        public Class getType() {
            return this.var.getClass();
        }

        @Override
        public Object refresh(Debugger debugger) {
            return this.var;
        }
    }

    public static class IscobolDataItem
    extends IscobolField {
        private int[] indexes;
        private int[] dimensions;
        private int leftPos;
        private int subLen;

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public Object refresh(Debugger debugger) {
            Object object = null;
            if (debugger == null) {
                return this.var;
            }
            if (debugger.getProgramObject() != null) {
                object = debugger.getProgramObject();
            } else if (debugger.getMethodObject() != null) {
                object = debugger.getMethodObject();
            } else if (this.field.getDeclaringClass() == debugger.getCurrProgramClass()) {
                object = debugger.getCurrProgram();
            } else if (this.field.getDeclaringClass() == debugger.getCurrMethodClass()) {
                object = debugger.getCurrMethod();
            } else {
                return this.var;
            }
            try {
                this.var = this.field.get(object);
                if (this.isCobolVar) {
                    ICobolVar iCobolVar = (ICobolVar)this.var;
                    if (this.indexes != null) {
                        if (Debugger.checkDynamicIndexes(iCobolVar, this.indexes)) {
                            iCobolVar = iCobolVar.intIAt(this.indexes);
                        } else {
                            this.var = null;
                            return null;
                        }
                    }
                    if (this.leftPos > 0) {
                        iCobolVar = this.subLen > 0 ? iCobolVar.intISub(this.leftPos, this.subLen) : iCobolVar.intISub(this.leftPos);
                    }
                    this.var = iCobolVar;
                } else if (this.indexes != null) {
                    this.var = Debugger.findObjectVarAt(this.var, this.indexes);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.var;
        }

        @Override
        public String toString() {
            try {
                return DebugUtilities.toString(this.var);
            }
            catch (Exception exception) {
                return DebuggerConstants.NULL_VALUE;
            }
        }

        @Override
        void adjustIndexes(int[] nArray) {
            try {
                Field field = this.field.getDeclaringClass().getDeclaredField(this.field.getName() + "$occurs");
                if (field.getType() == Boolean.TYPE) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        int n3 = n2++;
                        nArray[n3] = nArray[n3] - 1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static /* synthetic */ int[] access$502(IscobolDataItem iscobolDataItem, int[] nArray) {
            iscobolDataItem.indexes = nArray;
            return nArray;
        }

        static /* synthetic */ int[] access$602(IscobolDataItem iscobolDataItem, int[] nArray) {
            iscobolDataItem.dimensions = nArray;
            return nArray;
        }
    }

    public static class IscobolProp
    extends IscobolField {
        private IscobolProp next;
        private Field setfield;
        private IscobolDataItem dataItem;
        private Method method;
        private boolean set;

        IscobolProp(Field field, IscobolDataItem iscobolDataItem, boolean bl) {
            this.field = field;
            this.dataItem = iscobolDataItem;
            this.set = bl;
        }

        IscobolProp(Method method, Field field, IscobolDataItem iscobolDataItem, boolean bl) {
            this.dataItem = iscobolDataItem;
            this.method = method;
            this.setfield = field;
            this.set = bl;
        }

        @Override
        public void setCobolVar(boolean bl) {
        }

        @Override
        public boolean isCobolVar() {
            return ICobolVar.class.isAssignableFrom(this.getType());
        }

        @Override
        public Class getType() {
            if (this.next != null) {
                return this.next.getType();
            }
            if (this.field != null) {
                return this.field.getType();
            }
            if (this.set) {
                return this.method.getParameterTypes()[0];
            }
            return this.method.getReturnType();
        }

        public void setHexValue(String string, Debugger debugger) throws Exception {
            this.setValue(null, string, debugger);
        }

        public void setValue(ICobolVar iCobolVar, Debugger debugger) throws Exception {
            this.setValue(iCobolVar, null, debugger);
        }

        private void setValue(ICobolVar iCobolVar, String string, Debugger debugger) throws Exception {
            if (this.next != null || this.set && this.isCobolVar()) {
                Object object = null;
                if (this.dataItem != null) {
                    object = this.dataItem.refresh(debugger);
                }
                IscobolProp iscobolProp = this;
                while (iscobolProp.next != null) {
                    object = iscobolProp.refresh(debugger, object);
                    iscobolProp = iscobolProp.next;
                }
                if (iscobolProp.field != null) {
                    ICobolVar iCobolVar2 = (ICobolVar)iscobolProp.field.get(object);
                    this.setValue(iCobolVar, string, iCobolVar2);
                } else {
                    ICobolVar iCobolVar3 = (ICobolVar)iscobolProp.setfield.get(object);
                    this.setValue(iCobolVar, string, iCobolVar3);
                    iscobolProp.method.invoke(object, iCobolVar3);
                }
            }
        }

        private void setValue(ICobolVar iCobolVar, String string, ICobolVar iCobolVar2) throws Exception {
            if (iCobolVar != null) {
                iCobolVar2.setValue(iCobolVar);
            } else {
                try {
                    DebugUtilities.setValueAsHex(iCobolVar2, string);
                }
                catch (Exception exception) {
                    throw new DebuggerException(32, "'" + string + "'");
                }
            }
        }

        @Override
        public Object refresh(Debugger debugger) {
            Object object = null;
            if (this.dataItem != null) {
                object = this.dataItem.refresh(debugger);
            }
            object = this.refresh(debugger, object);
            IscobolProp iscobolProp = this.next;
            while (iscobolProp != null) {
                object = iscobolProp.refresh(debugger, object);
                iscobolProp = iscobolProp.next;
            }
            this.var = object;
            return this.var;
        }

        private Object refresh(Debugger debugger, Object object) {
            if (this.field != null) {
                try {
                    this.setVar(this.field.get(object));
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.setVar(this.method.invoke(object, new Object[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.var;
        }

        @Override
        void adjustIndexes(int[] nArray) {
        }
    }

    public static abstract class IscobolField {
        protected Field field;
        protected Object var;
        protected boolean isCobolVar;

        public abstract Class getType();

        abstract void adjustIndexes(int[] var1);

        public Object getVar() {
            return this.var;
        }

        public void setVar(Object object) {
            this.var = object;
        }

        public boolean isCobolVar() {
            return this.isCobolVar;
        }

        public void setCobolVar(boolean bl) {
            this.isCobolVar = bl;
        }

        public abstract Object refresh(Debugger var1);

        public String toString() {
            try {
                return DebugUtilities.toString(this.var);
            }
            catch (Exception exception) {
                return DebuggerConstants.NULL_VALUE;
            }
        }
    }
}

