/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;

public class DebuggerException
extends Exception {
    private static Hashtable<Integer, String> errorDesc = new Hashtable();
    private static Hashtable<Integer, String> infoDesc = new Hashtable();
    private static Hashtable<Integer, String> warnDesc = new Hashtable();
    private int errorId = 1;

    public DebuggerException() {
        this(1);
    }

    public DebuggerException(int n2) {
        super("- " + errorDesc.get(n2));
        this.errorId = n2;
    }

    public DebuggerException(String string) {
        this(1, string);
    }

    public DebuggerException(int n2, String string) {
        super("- " + errorDesc.get(n2) + (string != null ? " " + string : ""));
        this.errorId = n2;
    }

    public static String getInfoMessage(int n2, String string) {
        return "+ " + infoDesc.get(n2) + (string != null ? " " + string : "");
    }

    public static String getFormattedInfoMessage(int n2, Object ... objectArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.format("+ " + infoDesc.get(n2), objectArray);
        printWriter.close();
        return stringWriter.toString();
    }

    public static String getWarningMessage(int n2) {
        return warnDesc.get(n2);
    }

    public int getErrorId() {
        return this.errorId;
    }

    static {
        errorDesc.put(26, "Internal error");
        errorDesc.put(33, "unknown command");
        errorDesc.put(34, "ambiguous command");
        errorDesc.put(9, "program is not running");
        errorDesc.put(27, "environment variable not found");
        errorDesc.put(7, "data-item not found");
        errorDesc.put(19, "thread not found");
        errorDesc.put(2, "no verb at line");
        errorDesc.put(8, "Error: ambiguous identifier");
        errorDesc.put(6, "Error: subscript required");
        errorDesc.put(25, "Error: index out of bounds");
        errorDesc.put(10, "program is already running");
        errorDesc.put(23, "no such program");
        errorDesc.put(3, "no such paragraph");
        errorDesc.put(40, "no such method");
        errorDesc.put(28, "not found breakpoint in paragraph");
        errorDesc.put(29, "not found breakpoint at line");
        errorDesc.put(30, "not found monitor on environment variable");
        errorDesc.put(13, "this is a level 78 data-item");
        errorDesc.put(24, "boolean value required (true|false)");
        errorDesc.put(21, "numeric variable required");
        errorDesc.put(22, "property required");
        errorDesc.put(11, "not found monitor");
        errorDesc.put(5, "Syntax error");
        errorDesc.put(15, "not a Cobol variable");
        errorDesc.put(31, "variable not linked");
        errorDesc.put(32, "hexadecimal value required");
        errorDesc.put(17, "tracing not started");
        errorDesc.put(16, "tracing already started");
        errorDesc.put(4, "no such file");
        errorDesc.put(35, "evaluation error");
        errorDesc.put(14, "invalid handle");
        errorDesc.put(1, "unexpected error");
        errorDesc.put(36, "JUMP command not supported for this program. Please recompile with -dx option");
        errorDesc.put(37, "Cannot jump from a not DECLARATIVES paragraph to a DECLARATIVES paragraph");
        errorDesc.put(38, "Cannot jump from a DECLARATIVES paragraph to a not DECLARATIVES paragraph");
        errorDesc.put(39, "Unsupported feature");
        errorDesc.put(41, "Dynamic item not allocated");
        infoDesc.put(1, "changed variables:");
        infoDesc.put(2, "hit breakpoint in paragraph");
        infoDesc.put(3, "hit breakpoint at line");
        infoDesc.put(4, "garbage collector done.");
        infoDesc.put(5, "Warning: '%s' does not have debugging information");
        infoDesc.put(6, "set breakpoint at the first line of program");
        infoDesc.put(21, "set breakpoint at the first line of method");
        infoDesc.put(7, "set breakpoint at line");
        infoDesc.put(8, "set breakpoint in paragraph");
        infoDesc.put(9, "clear breakpoint in paragraph");
        infoDesc.put(18, "clear breakpoint at line");
        infoDesc.put(10, "clear all breakpoints");
        infoDesc.put(11, "clear monitor on environment variable");
        infoDesc.put(12, "add monitor on");
        infoDesc.put(13, "clear monitor on");
        infoDesc.put(14, "clear all monitors");
        infoDesc.put(15, "built tree of");
        infoDesc.put(16, "start tracing");
        infoDesc.put(17, "stop tracing");
        infoDesc.put(19, "add monitor on environment variable");
        infoDesc.put(20, "Warning: cannot jump to a line inside a block");
        warnDesc.put(1, "warning: unable to check line number");
        warnDesc.put(2, "warning: unable to check paragraph name");
    }
}

