/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Condition;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugOutputStream;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.IscobolDebugger;
import com.iscobol.debugger.Listing;
import com.iscobol.debugger.ListingException;
import com.iscobol.debugger.ListingInfo;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.ContinueCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DirectoryCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.EnvCommand;
import com.iscobol.debugger.commands.ExitCommand;
import com.iscobol.debugger.commands.GCCommand;
import com.iscobol.debugger.commands.GetFileCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.GetVariablesCommand;
import com.iscobol.debugger.commands.JumpCommand;
import com.iscobol.debugger.commands.LengthCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.LoadCommand;
import com.iscobol.debugger.commands.MemoryCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.OffsetCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.QuitCommand;
import com.iscobol.debugger.commands.RawTextCommand;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.debugger.commands.SaveCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetMonitorCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.commands.StepIntoCommand;
import com.iscobol.debugger.commands.StepOutParagraphCommand;
import com.iscobol.debugger.commands.StepOutProgramCommand;
import com.iscobol.debugger.commands.StepOverCommand;
import com.iscobol.debugger.commands.StepToCommand;
import com.iscobol.debugger.commands.StepToNextProgramCommand;
import com.iscobol.debugger.commands.SuspendCommand;
import com.iscobol.debugger.commands.ThreadCommand;
import com.iscobol.debugger.commands.TraceOffCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.interfaces.debugger.Appender;
import com.iscobol.interfaces.debugger.ICondition;
import com.iscobol.interfaces.debugger.IDebugCommand;
import com.iscobol.interfaces.debugger.IDebugCopyFile;
import com.iscobol.interfaces.debugger.IDebugTM;
import com.iscobol.interfaces.debugger.IDebuggerExtension7;
import com.iscobol.interfaces.debugger.IDebuggerInvoker;
import com.iscobol.interfaces.debugger.IExpression;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.interfaces.debugger.IFilename;
import com.iscobol.interfaces.debugger.IListing;
import com.iscobol.interfaces.debugger.IListingInfo;
import com.iscobol.interfaces.debugger.IVarName;
import com.iscobol.interfaces.debugger.IVarValue;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class DebuggerImpl
implements IDebuggerExtension7 {
    @Override
    public IDebuggerInvoker newDebuggerInvoker() {
        return new DebuggerInvoker();
    }

    @Override
    public IDebugTM newDebugTM(String string, int n2) {
        DebugCommand[] debugCommandArray;
        switch (n2) {
            case 1: {
                debugCommandArray = DebuggerInvoker.standardCommands;
                break;
            }
            default: {
                debugCommandArray = new DebugCommand[]{};
            }
        }
        return new DebugTM(string, " ,;(:=)+*\"<>", debugCommandArray);
    }

    @Override
    public IDebugCommand newGetInfoCommand(int n2, String string) {
        return new GetInfoCommand(n2, string);
    }

    @Override
    public IListing newListing(IFileLoader iFileLoader, IDebugCopyFile[] iDebugCopyFileArray, IFilename iFilename, int n2, String string, boolean bl) throws ListingException {
        HashSet<String> hashSet = new HashSet<String>();
        if (n2 != 0 && string == null) {
            switch (n2) {
                case 2: {
                    string = "-st";
                    break;
                }
                case 1: {
                    string = "-sa";
                    break;
                }
                case 3: {
                    string = "-sf";
                    break;
                }
                case 4: {
                    string = "-sv";
                    break;
                }
                case 5: {
                    string = "-sl";
                }
            }
            if (string != null) {
                hashSet.add(string);
            }
        }
        return this.newListing(iFileLoader, iDebugCopyFileArray, iFilename, null, hashSet, bl);
    }

    @Override
    public IListing newListing(IFileLoader iFileLoader, IDebugCopyFile[] iDebugCopyFileArray, IFilename iFilename, Set<String> set, boolean bl) throws ListingException {
        return this.newListing(iFileLoader, iDebugCopyFileArray, iFilename, null, set, bl);
    }

    @Override
    public IListing newListing(IFileLoader iFileLoader, IDebugCopyFile[] iDebugCopyFileArray, IFilename iFilename, String string, Set<String> set, boolean bl) throws ListingException {
        DebugCopyFile[] debugCopyFileArray = this.checkNewListingArgs(iFilename, iDebugCopyFileArray);
        return new Listing(iFileLoader, debugCopyFileArray, (Filename)iFilename, string, set);
    }

    private DebugCopyFile[] checkNewListingArgs(IFilename iFilename, IDebugCopyFile[] iDebugCopyFileArray) {
        DebugCopyFile[] debugCopyFileArray;
        if (iFilename != null && !(iFilename instanceof Filename)) {
            throw new IllegalArgumentException(iFilename.toString());
        }
        if (iDebugCopyFileArray != null) {
            debugCopyFileArray = new DebugCopyFile[iDebugCopyFileArray.length];
            for (int i2 = 0; i2 < iDebugCopyFileArray.length; ++i2) {
                if (!(iDebugCopyFileArray[i2] instanceof DebugCopyFile)) {
                    throw new IllegalArgumentException("" + iDebugCopyFileArray[i2]);
                }
                debugCopyFileArray[i2] = (DebugCopyFile)iDebugCopyFileArray[i2];
            }
        } else {
            debugCopyFileArray = new DebugCopyFile[]{};
        }
        return debugCopyFileArray;
    }

    @Override
    public IListing newListing(byte[] byArray, int n2, IDebugCopyFile[] iDebugCopyFileArray, IFilename iFilename, String string, Set<String> set) throws IOException {
        DebugCopyFile[] debugCopyFileArray = this.checkNewListingArgs(iFilename, iDebugCopyFileArray);
        return new Listing(byArray, n2, debugCopyFileArray, (Filename)iFilename, string, set);
    }

    @Override
    public IFilename newFilename(String string) {
        return new Filename(string);
    }

    @Override
    public IDebugCommand newGetVariablesCommand(IVarName[] iVarNameArray, String[] stringArray, int n2, int n3, int n4, int n5, int n6) {
        GetVariablesCommand getVariablesCommand = (GetVariablesCommand)this.newGetVariablesCommand(iVarNameArray, n2, n3, n4, n5, n6);
        getVariablesCommand.setClassNames(stringArray);
        return getVariablesCommand;
    }

    @Override
    public IDebugCommand newGetVariablesCommand(IVarName[] iVarNameArray, int n2, int n3, int n4, int n5, int n6) {
        VarName[] varNameArray;
        if (iVarNameArray != null) {
            varNameArray = new VarName[iVarNameArray.length];
            for (int i2 = 0; i2 < iVarNameArray.length; ++i2) {
                if (!(iVarNameArray[i2] instanceof VarName)) {
                    throw new IllegalArgumentException("" + iVarNameArray[i2]);
                }
                varNameArray[i2] = (VarName)iVarNameArray[i2];
            }
        } else {
            varNameArray = new VarName[]{};
        }
        return new GetVariablesCommand(varNameArray, n2, n3, n4, n5, n6);
    }

    @Override
    public IDebugCommand newGetVariablesCommand(IVarName iVarName, String[] stringArray, int n2, int n3, int n4, int n5, int n6) {
        GetVariablesCommand getVariablesCommand = (GetVariablesCommand)this.newGetVariablesCommand(iVarName, n2, n3, n4, n5, n6);
        getVariablesCommand.setClassNames(stringArray);
        return getVariablesCommand;
    }

    @Override
    public IDebugCommand newGetVariablesCommand(IVarName iVarName, int n2, int n3, int n4, int n5, int n6) {
        if (!(iVarName instanceof VarName)) {
            throw new IllegalArgumentException("" + iVarName);
        }
        return new GetVariablesCommand((VarName)iVarName, n2, n3, n4, n5, n6);
    }

    @Override
    public IVarName newVarName(IDebugTM iDebugTM) throws Exception {
        if (!(iDebugTM instanceof DebugTM)) {
            throw new IllegalArgumentException("" + iDebugTM);
        }
        return new VarName((DebugTM)iDebugTM);
    }

    @Override
    public IVarValue parseVarValue(String string) {
        return DebugUtilities.parseVarValue(string);
    }

    @Override
    public IDebugCommand newTraceOnCommand(int n2, String string) {
        return new TraceOnCommand(n2, string);
    }

    @Override
    public IDebugCommand newTraceOffCommand() {
        return new TraceOffCommand();
    }

    @Override
    public PrintStream newDebugOutputStream(Appender appender) {
        return new DebugOutputStream(appender);
    }

    @Override
    public void unexpectedException(Throwable throwable) {
        Debugger.unexpectedException(throwable);
    }

    @Override
    public boolean hasIscobolDebugInfos(Object object) {
        return object != null && IscobolDebugger.class.isAssignableFrom(object.getClass());
    }

    @Override
    public void startListener(int n2, int n3, boolean bl, boolean bl2, int n4) {
        Debugger.startListener(n2, n3, bl, bl2, n4);
    }

    @Override
    public void stopListener(boolean bl) {
        Debugger.stopListener(bl);
    }

    @Override
    public boolean suspending() {
        return Debugger.suspending();
    }

    @Override
    public IListingInfo getListingInfo(byte[] byArray) {
        try {
            return byArray != null ? new ListingInfo(byArray, 4) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public IDebugCommand newSetRedirectStreamsCommand(boolean bl) {
        return new SetRedirectStreamsCommand(bl);
    }

    @Override
    public IDebugCommand newClearBreakpointCommand(int n2, String string, int n3, String string2, String string3) {
        return new ClearBreakpointCommand(n2, string, n3, string2, string3);
    }

    @Override
    public IDebugCommand newClearBreakpointCommand(String string, String string2, int n2, String string3, String string4) {
        return new ClearBreakpointCommand(string, string2, n2, string3, string4);
    }

    @Override
    public IDebugCommand newClearBreakpointCommand(boolean bl) {
        return new ClearBreakpointCommand(bl);
    }

    @Override
    public IDebugCommand newClearMonitorCommand(IVarName iVarName, String string, String string2) {
        return new ClearMonitorCommand((VarName)iVarName, string, string2);
    }

    @Override
    public IDebugCommand newClearMonitorCommand(boolean bl) {
        return new ClearMonitorCommand(bl);
    }

    @Override
    public IDebugCommand newClearMonitorCommand(String string) {
        return new ClearMonitorCommand(string);
    }

    public IDebugCommand newCompositeCommand(Vector vector) {
        return new CompositeCommand(vector);
    }

    @Override
    public IDebugCommand newContinueCommand() {
        return new ContinueCommand();
    }

    @Override
    public IDebugCommand newDirectoryCommand(String string) {
        return new DirectoryCommand(string);
    }

    @Override
    public IDebugCommand newDisplayCommand(boolean bl) {
        return new DisplayCommand(bl);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName iVarName, boolean bl, boolean bl2) {
        return new DisplayCommand((VarName)iVarName, null, bl, bl2);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName iVarName, String string) {
        return new DisplayCommand((VarName)iVarName, null, string);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName iVarName, boolean bl) {
        return new DisplayCommand((VarName)iVarName, null, bl);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName iVarName, boolean bl, boolean bl2, String string) {
        return new DisplayCommand((VarName)iVarName, string, bl, bl2);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName iVarName, String string, String string2) {
        return new DisplayCommand((VarName)iVarName, string2, string);
    }

    @Override
    public IDebugCommand newDisplayCommand(IVarName iVarName, boolean bl, String string) {
        return new DisplayCommand((VarName)iVarName, string, bl);
    }

    @Override
    public IDebugCommand newDisplayCommand(String string) {
        return new DisplayCommand(string);
    }

    @Override
    public IDebugCommand newEnvCommand(String string) {
        return new EnvCommand(string);
    }

    @Override
    public IDebugCommand newExitCommand(boolean bl) {
        return new ExitCommand(bl);
    }

    @Override
    public IDebugCommand newGCCommand() {
        return new GCCommand();
    }

    @Override
    public IDebugCommand newGetFileCommand(String string) {
        return new GetFileCommand(string);
    }

    @Override
    public IDebugCommand newJumpCommand(int n2, String string, int n3) {
        return this.newJumpCommand(n2, string, n3);
    }

    @Override
    public IDebugCommand newJumpCommand(String string) {
        return new JumpCommand(string);
    }

    @Override
    public IDebugCommand newJumpOutParagraphCommand() {
        return JumpCommand.getJumpOutParagraphInstance();
    }

    @Override
    public IDebugCommand newJumpOutProgramCommand() {
        return JumpCommand.getJumpOutProgramInstance();
    }

    @Override
    public IDebugCommand newLengthCommand(IVarName iVarName) {
        return new LengthCommand((VarName)iVarName, null);
    }

    @Override
    public IDebugCommand newLengthCommand(IVarName iVarName, String string) {
        return new LengthCommand((VarName)iVarName, string);
    }

    @Override
    public IDebugCommand newLetCommand(IVarName iVarName, boolean bl, String string) {
        return new LetCommand((VarName)iVarName, null, bl, string);
    }

    @Override
    public IDebugCommand newLetCommand(IVarName iVarName, String string, String string2) {
        return new LetCommand((VarName)iVarName, null, string, string2);
    }

    @Override
    public IDebugCommand newLetCommand(IVarName iVarName, boolean bl, String string, String string2) {
        return new LetCommand((VarName)iVarName, string2, bl, string);
    }

    @Override
    public IDebugCommand newLetCommand(IVarName iVarName, String string, String string2, String string3) {
        return new LetCommand((VarName)iVarName, string3, string, string2);
    }

    @Override
    public IDebugCommand newLetCommand(String string, String string2) {
        return new LetCommand(string, string2);
    }

    @Override
    public IDebugCommand newLoadSessionCommand(String string) {
        return new LoadCommand(string);
    }

    @Override
    public IDebugCommand newMemoryCommand() {
        return new MemoryCommand();
    }

    @Override
    public IDebugCommand newSetMethodBreakpointCommand(String string, boolean bl, IExpression iExpression) {
        return new MethodBreakpointCommand(string, bl, (Expression)iExpression);
    }

    @Override
    public IDebugCommand newOffsetCommand(IVarName iVarName) {
        return new OffsetCommand((VarName)iVarName, null);
    }

    @Override
    public IDebugCommand newOffsetCommand(IVarName iVarName, String string) {
        return new OffsetCommand((VarName)iVarName, string);
    }

    @Override
    public IDebugCommand newSetProgramBreakpointCommand(String string, boolean bl, IExpression iExpression) {
        return new ProgramBreakpointCommand(string, bl, (Expression)iExpression);
    }

    @Override
    public IDebugCommand newQuitCommand() {
        return new QuitCommand();
    }

    @Override
    public IDebugCommand newRawTextCommand(String string) {
        return new RawTextCommand(string);
    }

    @Override
    public IDebugCommand newRunCommand(String[] stringArray) {
        return new RunCommand(stringArray);
    }

    @Override
    public IDebugCommand newSaveSessionCommand(String string) {
        return new SaveCommand(string);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(int n2, String string, int n3, String string2, boolean bl, String string3) {
        return new SetBreakpointCommand(n2, string, n3, string2, bl, string3);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(int n2, String string, int n3, String string2, boolean bl, String string3, IExpression iExpression) {
        return new SetBreakpointCommand(n2, string, n3, string2, bl, string3, (Expression)iExpression);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(String string, String string2, int n2, String string3, boolean bl, String string4, IExpression iExpression) {
        return new SetBreakpointCommand(string, string2, n2, string3, bl, string4, (Expression)iExpression);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(String string, String string2, int n2, String string3, boolean bl, String string4) {
        return new SetBreakpointCommand(string, string2, n2, string3, bl, string4);
    }

    @Override
    public IDebugCommand newSetBreakpointCommand(boolean bl) {
        return new SetBreakpointCommand(bl);
    }

    @Override
    public IDebugCommand newSetMonitorCommand(IVarName iVarName, String string, boolean bl, ICondition iCondition, boolean bl2) {
        return new SetMonitorCommand((VarName)iVarName, string, bl, (Condition)iCondition, bl2);
    }

    @Override
    public IDebugCommand newSetMonitorCommand(IVarName iVarName, String string, String string2, ICondition iCondition, boolean bl) {
        return new SetMonitorCommand((VarName)iVarName, string, string2, (Condition)iCondition, bl);
    }

    @Override
    public IDebugCommand newSetMonitorCommand(String string, ICondition iCondition, boolean bl) {
        return new SetMonitorCommand(string, (Condition)iCondition, bl);
    }

    @Override
    public IDebugCommand newSetMonitorCommand(boolean bl) {
        return new SetMonitorCommand(bl);
    }

    @Override
    public IDebugCommand newStepIntoCommand(int n2) {
        return new StepIntoCommand(n2);
    }

    @Override
    public IDebugCommand newStepOutParagraphCommand() {
        return new StepOutParagraphCommand();
    }

    @Override
    public IDebugCommand newStepOutProgramCommand() {
        return new StepOutProgramCommand();
    }

    @Override
    public IDebugCommand newStepOverCommand() {
        return new StepOverCommand();
    }

    @Override
    public IDebugCommand newStepToCommand(int n2, String string, int n3) {
        return new StepToCommand(n2, string, n3);
    }

    @Override
    public IDebugCommand newStepToNextProgramCommand() {
        return new StepToNextProgramCommand();
    }

    @Override
    public IDebugCommand newSuspendCommand() {
        return new SuspendCommand();
    }

    @Override
    public IDebugCommand newThreadCommand(String string) {
        return new ThreadCommand(string);
    }

    @Override
    public IDebugCommand newThreadCommand(boolean bl) {
        return new ThreadCommand(bl);
    }
}

