/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.Condition;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.FileLoaderHelper;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.InputChild;
import com.iscobol.debugger.LocalDebugInfo;
import com.iscobol.debugger.OutputChild;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.AutoOffCommand;
import com.iscobol.debugger.commands.AutoOnCommand;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.ClearMonitorCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.ContinueCommand;
import com.iscobol.debugger.commands.CurrentLineCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DirectoryCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.DownCommand;
import com.iscobol.debugger.commands.EnvCommand;
import com.iscobol.debugger.commands.ExitCommand;
import com.iscobol.debugger.commands.FindBackwardsCommand;
import com.iscobol.debugger.commands.FindForwardsCommand;
import com.iscobol.debugger.commands.FindFromTopCommand;
import com.iscobol.debugger.commands.FirstExLineCommand;
import com.iscobol.debugger.commands.FirstLineCommand;
import com.iscobol.debugger.commands.GCCommand;
import com.iscobol.debugger.commands.GetFileCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.HelpCommand;
import com.iscobol.debugger.commands.JumpCommand;
import com.iscobol.debugger.commands.LastLineCommand;
import com.iscobol.debugger.commands.LengthCommand;
import com.iscobol.debugger.commands.LetCommand;
import com.iscobol.debugger.commands.ListCommand;
import com.iscobol.debugger.commands.LoadCommand;
import com.iscobol.debugger.commands.MemoryCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.OffsetCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.QuitCommand;
import com.iscobol.debugger.commands.RepeatFindCommand;
import com.iscobol.debugger.commands.RunCommand;
import com.iscobol.debugger.commands.SaveCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetMonitorCommand;
import com.iscobol.debugger.commands.ShowLineCommand;
import com.iscobol.debugger.commands.StackInfoCommand;
import com.iscobol.debugger.commands.StepIntoCommand;
import com.iscobol.debugger.commands.StepOutParagraphCommand;
import com.iscobol.debugger.commands.StepOutProgramCommand;
import com.iscobol.debugger.commands.StepOverCommand;
import com.iscobol.debugger.commands.StepToCommand;
import com.iscobol.debugger.commands.StepToNextProgramCommand;
import com.iscobol.debugger.commands.SuspendCommand;
import com.iscobol.debugger.commands.ThreadCommand;
import com.iscobol.debugger.commands.TraceOffCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.debugger.commands.UpCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.interfaces.debugger.IDebugCommand;
import com.iscobol.interfaces.debugger.IDebugTM;
import com.iscobol.interfaces.debugger.IDebuggerInvokerExtension2;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class DebuggerInvoker
implements IDebuggerInvokerExtension2 {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final DebugCommand[] graphCommands = new DebugCommand[]{new AutoOffCommand(), new AutoOnCommand(), new CurrentLineCommand(), new DirectoryCommand(), new DownCommand(), new FindBackwardsCommand(), new FindForwardsCommand(), new FindFromTopCommand(), new FirstExLineCommand(), new FirstLineCommand(), new LastLineCommand(), new RepeatFindCommand(), new UpCommand()};
    public static final DebugCommand[] standardCommands = new DebugCommand[]{new ClearBreakpointCommand(), new ClearMonitorCommand(), new ContinueCommand(), new DisplayCommand(), new EnvCommand(), new ExitCommand(), new GCCommand(), new HelpCommand(), new JumpCommand(), new LengthCommand(), new LetCommand(), new ListCommand(), new LoadCommand(), new MemoryCommand(), new MethodBreakpointCommand(), new OffsetCommand(), new ProgramBreakpointCommand(), new QuitCommand(), new RunCommand(), new SaveCommand(), new SetBreakpointCommand(), new SetMonitorCommand(), new ShowLineCommand(), new StackInfoCommand(), new StepIntoCommand(), new StepOutParagraphCommand(), new StepOutProgramCommand(), new StepOverCommand(), new StepToCommand(), new StepToNextProgramCommand(), new SuspendCommand(), new ThreadCommand(), new TraceOffCommand(), new TraceOnCommand()};
    public static final DebugCommand[] defCommands = new DebugCommand[graphCommands.length + standardCommands.length];
    private static final Vector activeProcesses;
    private static boolean defaultMonitorEnabledState;
    private static boolean defaultBreakpointEnabledState;
    private OutputChild outputThread;
    private InputChild inputThread;
    private Process process;
    private Socket dbgSocket;
    private String remoteHost;
    private int remotePort;
    private Hashtable<String, LocalDebugInfo> debugInfos = new Hashtable();
    private Set<File> loadedFilePaths = new HashSet<File>();
    private boolean checkFileOfBreakpoints = true;
    private FileLoader fileLoader = new FileLoader(this);
    private String mainClass;
    private String[] programArgs;
    private String lastCmdString;
    private int currLine = 1;
    private int selStackFrameIndex = -1;
    private ParagraphObject[] parStack;
    private int selLine = 1;
    private int startSelLine = 1;
    private String selFile = "";
    private int selPos;
    private String lastFind;
    private String currFile = "";
    private int currFileIndex;
    private FileLoaderHelper fileLoaderHelper;
    private LocalDebugInfo info;
    private int listSize = 5;

    @Override
    public void setCheckFileOfBreakpoints(boolean bl) {
        this.checkFileOfBreakpoints = bl;
    }

    public boolean isCheckFileOfBreakpoints() {
        return this.checkFileOfBreakpoints;
    }

    @Override
    public DebugResponse processCommand(String string) {
        if (string.equals("")) {
            string = this.lastCmdString;
        } else {
            this.lastCmdString = string;
        }
        DebugTM debugTM = new DebugTM(string, " ,;(:=)+*\"<>", defCommands);
        String string2 = debugTM.getToken();
        try {
            return this.processCommand(debugTM.getCommand(string2), debugTM);
        }
        catch (DebuggerException debuggerException) {
            return new DebugResponse(debuggerException.getErrorId(), debuggerException.getMessage() + eol);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new DebugResponse(1, "Internal error: " + string2 + eol);
        }
    }

    @Override
    public DebugResponse processCommand(int n2, IDebugTM iDebugTM) throws Exception {
        if (!(iDebugTM instanceof DebugTM)) {
            throw new IllegalArgumentException("" + iDebugTM);
        }
        return this.processCommand(n2, (DebugTM)iDebugTM);
    }

    public DebugResponse processCommand(int n2, DebugTM debugTM) throws DebuggerException, IllegalArgumentException {
        DebugResponse debugResponse = null;
        switch (n2) {
            case -1: {
                debugResponse = null;
                break;
            }
            case 20: {
                debugResponse = this.help(debugTM);
                break;
            }
            case 2: {
                debugResponse = this.run(debugTM);
                break;
            }
            case 0: {
                debugResponse = this.setBreakpoint(debugTM);
                break;
            }
            case 9: {
                debugResponse = this.clearBreakpoint(debugTM);
                break;
            }
            case 1: {
                debugResponse = this.continue0();
                break;
            }
            case 3: {
                debugResponse = this.stepInto(debugTM);
                break;
            }
            case 4: {
                debugResponse = this.stepOver();
                break;
            }
            case 16: {
                debugResponse = this.switchThread(debugTM);
                break;
            }
            case 24: {
                debugResponse = this.gc();
                break;
            }
            case 25: {
                debugResponse = this.memory();
                break;
            }
            case 26: {
                debugResponse = this.env(debugTM);
                break;
            }
            case 17: {
                debugResponse = this.traceOn(debugTM);
                break;
            }
            case 18: {
                debugResponse = this.traceOff();
                break;
            }
            case 19: {
                debugResponse = this.setProgramBreakpoint(debugTM);
                break;
            }
            case 52: {
                debugResponse = this.setMethodBreakpoint(debugTM);
                break;
            }
            case 5: {
                debugResponse = this.display(debugTM);
                break;
            }
            case 6: {
                debugResponse = this.let(debugTM);
                break;
            }
            case 7: {
                debugResponse = this.getLine();
                break;
            }
            case 8: {
                debugResponse = this.list(debugTM);
                break;
            }
            case 10: {
                debugResponse = this.stepOutOfParagraph();
                break;
            }
            case 11: {
                debugResponse = this.stepOutOfProgram();
                break;
            }
            case 12: {
                debugResponse = this.stepToLine(debugTM);
                break;
            }
            case 56: {
                debugResponse = this.stepToNextProgram();
                break;
            }
            case 13: {
                debugResponse = this.setMonitor(debugTM);
                break;
            }
            case 14: {
                debugResponse = this.clearMonitor(debugTM);
                break;
            }
            case 15: {
                debugResponse = this.getStackInfo(this.parseStackInfo(debugTM).isAllInfos());
                break;
            }
            case 21: {
                debugResponse = this.quit();
                break;
            }
            case 22: {
                debugResponse = this.load(debugTM);
                break;
            }
            case 23: {
                debugResponse = this.save(debugTM);
                break;
            }
            case 27: {
                debugResponse = this.exit();
                break;
            }
            case 30: {
                debugResponse = this.getInfo(debugTM);
                break;
            }
            case 29: {
                debugResponse = this.jump(debugTM);
                break;
            }
            case 31: {
                debugResponse = this.find(debugTM, false, false, n2);
                break;
            }
            case 32: {
                debugResponse = this.find(debugTM, true, false, n2);
                break;
            }
            case 33: {
                debugResponse = this.find(debugTM, false, true, n2);
                break;
            }
            case 34: {
                debugResponse = this.find(false, false, n2);
                break;
            }
            case 35: {
                debugResponse = this.firstLine();
                break;
            }
            case 36: {
                debugResponse = this.lastLine();
                break;
            }
            case 37: {
                debugResponse = this.currLine();
                break;
            }
            case 38: {
                debugResponse = this.firstExecLine();
                break;
            }
            case 44: {
                debugResponse = this.up();
                break;
            }
            case 45: {
                debugResponse = this.down();
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 46: {
                debugResponse = this.directory(this.parseDirectory(debugTM));
                break;
            }
            case 55: {
                debugResponse = this.offset(debugTM);
                break;
            }
            case 54: {
                debugResponse = this.length(debugTM);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return debugResponse;
    }

    private DebugResponse update(DebugCommand debugCommand, DebugResponse debugResponse) {
        if (debugResponse == null) {
            return null;
        }
        switch (debugCommand.getId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 28: 
            case 29: 
            case 56: 
            case 1000: {
                this.update(debugResponse);
                break;
            }
            case 16: {
                if (((ThreadCommand)debugCommand).isListing()) break;
                this.update(debugResponse);
            }
        }
        return debugResponse;
    }

    @Override
    public DebugCommand parseCommand(String string) throws DebuggerException, IllegalArgumentException {
        DebugTM debugTM = new DebugTM(string, " ,;(:=)+*\"<>", defCommands);
        return this.parseCommand(debugTM.getCommand(), debugTM);
    }

    @Override
    public DebugCommand parseCommand(int n2, IDebugTM iDebugTM) throws Exception {
        if (!(iDebugTM instanceof DebugTM)) {
            throw new IllegalArgumentException("" + iDebugTM);
        }
        return this.parseCommand(n2, (DebugTM)iDebugTM);
    }

    public DebugCommand parseCommand(int n2, DebugTM debugTM) throws DebuggerException, IllegalArgumentException {
        DebugCommand debugCommand = null;
        switch (n2) {
            case -1: {
                debugCommand = null;
                break;
            }
            case 20: {
                debugCommand = this.parseHelp(debugTM);
                break;
            }
            case 2: {
                debugCommand = this.parseRun(debugTM);
                break;
            }
            case 0: {
                debugCommand = this.parseSetBreakpoint(debugTM);
                break;
            }
            case 9: {
                debugCommand = this.parseClearBreakpoint(debugTM);
                break;
            }
            case 1: {
                debugCommand = new ContinueCommand();
                break;
            }
            case 3: {
                debugCommand = new StepIntoCommand();
                break;
            }
            case 4: {
                debugCommand = new StepOverCommand();
                break;
            }
            case 16: {
                debugCommand = this.parseSwitchThread(debugTM);
                break;
            }
            case 24: {
                debugCommand = new GCCommand();
                break;
            }
            case 25: {
                debugCommand = new MemoryCommand();
                break;
            }
            case 26: {
                debugCommand = this.parseEnv(debugTM);
                break;
            }
            case 17: {
                debugCommand = this.parseTraceOn(debugTM);
                break;
            }
            case 18: {
                debugCommand = new TraceOffCommand();
                break;
            }
            case 19: {
                debugCommand = this.parseSetProgramBreakpoint(debugTM);
                break;
            }
            case 52: {
                debugCommand = this.parseSetMethodBreakpoint(debugTM);
                break;
            }
            case 5: {
                debugCommand = this.parseDisplay(debugTM);
                break;
            }
            case 6: {
                debugCommand = this.parseLet(debugTM);
                break;
            }
            case 7: {
                debugCommand = new ShowLineCommand();
                break;
            }
            case 8: {
                debugCommand = this.parseList(debugTM);
                break;
            }
            case 10: {
                debugCommand = new StepOutParagraphCommand();
                break;
            }
            case 11: {
                debugCommand = new StepOutProgramCommand();
                break;
            }
            case 12: {
                debugCommand = this.parseStepToLine(debugTM);
                break;
            }
            case 56: {
                debugCommand = new StepToNextProgramCommand();
                break;
            }
            case 13: {
                debugCommand = this.parseSetMonitor(debugTM);
                break;
            }
            case 14: {
                debugCommand = this.parseClearMonitor(debugTM);
                break;
            }
            case 15: {
                debugCommand = this.parseStackInfo(debugTM);
                break;
            }
            case 21: {
                debugCommand = new QuitCommand();
                break;
            }
            case 22: {
                debugCommand = this.parseLoad(debugTM);
                break;
            }
            case 23: {
                debugCommand = new SaveCommand();
                break;
            }
            case 27: {
                debugCommand = new ExitCommand();
                break;
            }
            case 30: {
                debugCommand = new GetInfoCommand();
                break;
            }
            case 29: {
                debugCommand = this.parseJump(debugTM);
                break;
            }
            case 31: {
                debugCommand = new FindForwardsCommand(this.parseFind(debugTM));
                break;
            }
            case 32: {
                debugCommand = new FindBackwardsCommand(this.parseFind(debugTM));
                break;
            }
            case 33: {
                debugCommand = new FindFromTopCommand(this.parseFind(debugTM));
                break;
            }
            case 34: {
                debugCommand = new RepeatFindCommand();
                break;
            }
            case 35: {
                debugCommand = new FirstLineCommand();
                break;
            }
            case 36: {
                debugCommand = new LastLineCommand();
                break;
            }
            case 37: {
                debugCommand = new CurrentLineCommand();
                break;
            }
            case 38: {
                debugCommand = new FirstExLineCommand();
                break;
            }
            case 44: {
                debugCommand = new UpCommand();
                break;
            }
            case 45: {
                debugCommand = new DownCommand();
                break;
            }
            case 39: {
                debugCommand = this.parseAutoOn(debugTM);
                break;
            }
            case 40: {
                debugCommand = new AutoOffCommand();
                break;
            }
            case 46: {
                debugCommand = this.parseDirectory(debugTM);
                break;
            }
            case 54: {
                debugCommand = this.parseLength(debugTM);
                break;
            }
            case 55: {
                debugCommand = this.parseOffset(debugTM);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return debugCommand;
    }

    public void setInfo(LocalDebugInfo localDebugInfo) {
        this.info = localDebugInfo;
    }

    private void update(DebugResponse debugResponse) {
        int n2 = debugResponse.getReturnCode();
        if (n2 == 0 || n2 == 101 || n2 == 102) {
            if (debugResponse.getLine() > 0) {
                this.currLine = debugResponse.getLine();
                this.setSelLine(this.currLine);
            }
            if (debugResponse.getLastFile() != null && debugResponse.getLastFile().length() > 0) {
                this.currFile = this.selFile = this.getRealPath(debugResponse.getLastFile());
                this.currFileIndex = debugResponse.getLastFileIndex();
            }
            if (debugResponse.getParStack() != null) {
                this.parStack = debugResponse.getParStack();
            }
            this.selPos = 0;
            if (debugResponse.getMessage() != null) {
                StringBuffer stringBuffer = new StringBuffer(debugResponse.getMessage());
                if (n2 == 102) {
                    stringBuffer.insert(0, "+ at " + this.showLine(debugResponse.getOldLine(), debugResponse.getOldFile(), -1));
                }
                stringBuffer.append(this.showLine(this.currLine, this.currFile, this.currFileIndex));
                debugResponse.setMessage(stringBuffer.toString());
            }
        }
    }

    void setSection(ParagraphObject paragraphObject) {
        LocalDebugInfo localDebugInfo = this.getInfo(paragraphObject.getProgName(), false, false, false);
        if (localDebugInfo == null) {
            return;
        }
        DebugParagraph[] debugParagraphArray = localDebugInfo.getParagraphs();
        int n2 = DebugUtilities.indexOfParagraph(paragraphObject.getParagraphNumber(), paragraphObject.isDeclaratives(), debugParagraphArray);
        if (n2 < 0 || debugParagraphArray[n2].isSection()) {
            return;
        }
        for (int i2 = n2 - 1; i2 >= 0 && paragraphObject.isDeclaratives() == debugParagraphArray[i2].isInDeclaratives(); --i2) {
            if (!debugParagraphArray[i2].isSection()) continue;
            paragraphObject.setParentSection(debugParagraphArray[i2].getParagraphName());
            break;
        }
    }

    protected DebugResponse gc() {
        return this.processCommand(new GCCommand());
    }

    protected DebugResponse memory() {
        return this.processCommand(new MemoryCommand());
    }

    protected DebugCommand parseEnv(DebugTM debugTM) throws DebuggerException {
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(EnvCommand.USAGE);
        }
        String string2 = string;
        string = debugTM.getAllToken();
        while (string != null) {
            string2 = string2 + string;
            string = debugTM.getAllToken();
        }
        return new EnvCommand(string2);
    }

    protected DebugResponse env(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseEnv(debugTM));
    }

    protected DebugCommand parseSwitchThread(DebugTM debugTM) throws DebuggerException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = debugTM.getAllToken();
        while (string != null) {
            stringBuffer.append(string);
            string = debugTM.getAllToken();
        }
        string = stringBuffer.toString().trim();
        if (string.length() == 0) {
            throw new DebuggerException(ThreadCommand.USAGE);
        }
        if (string.equalsIgnoreCase("-l")) {
            return new ThreadCommand(true);
        }
        return new ThreadCommand(string);
    }

    protected DebugResponse switchThread(DebugTM debugTM) throws DebuggerException {
        ThreadCommand threadCommand = (ThreadCommand)this.parseSwitchThread(debugTM);
        return this.processCommand(threadCommand);
    }

    protected DebugCommand parseLoad(DebugTM debugTM) {
        String string = this.mainClass + ".isd";
        String string2 = debugTM.getAllToken();
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            while ((string2 = debugTM.getAllToken()) != null) {
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString().trim();
        }
        return new LoadCommand(string);
    }

    protected String getChainingString() {
        return null;
    }

    protected void setChainingString(String string) {
    }

    protected DebugResponse load(DebugTM debugTM) {
        DebugResponse debugResponse;
        boolean bl;
        LoadCommand loadCommand = (LoadCommand)this.parseLoad(debugTM);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        String[] stringArray = new String[1];
        boolean bl2 = bl = this.load(loadCommand.getFilename(), vector, vector2, vector3, stringArray) != null;
        if (stringArray[0] != null) {
            this.setChainingString(stringArray[0]);
        }
        if (bl) {
            String string = "+ loaded information from '" + loadCommand.getFilename() + "'" + eol;
            debugResponse = new DebugResponse(0, string, 22);
            Breakpoint[] breakpointArray = new Breakpoint[vector.size()];
            vector.toArray(breakpointArray);
            debugResponse.setBreakpoints(breakpointArray);
            Watch[] watchArray = new Watch[vector2.size()];
            vector2.toArray(watchArray);
            debugResponse.setMonitors(watchArray);
            Tree[] treeArray = new Tree[vector3.size()];
            vector3.toArray(treeArray);
            debugResponse.setTrees(treeArray);
        } else {
            debugResponse = new DebugResponse(1, "-fail loading information from file '" + loadCommand.getFilename() + "'" + eol);
        }
        return debugResponse;
    }

    protected DebugCommand parseSave(DebugTM debugTM) {
        String string = this.mainClass + ".isd";
        String string2 = debugTM.getAllToken();
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            while ((string2 = debugTM.getAllToken()) != null) {
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString().trim();
        }
        return new SaveCommand(string);
    }

    protected DebugResponse save(DebugTM debugTM) {
        SaveCommand saveCommand = (SaveCommand)this.parseSave(debugTM);
        Breakpoint[] breakpointArray = null;
        Watch[] watchArray = null;
        DebugResponse debugResponse = this.processCommand(saveCommand);
        boolean bl = debugResponse != null;
        if (bl) {
            breakpointArray = debugResponse.getBreakpoints();
            watchArray = debugResponse.getMonitors();
        }
        if (bl) {
            if (!DebuggerInvoker.save(saveCommand.getFilename(), breakpointArray, watchArray, null, this.getChainingString())) {
                return new DebugResponse(18, "- file '" + saveCommand.getFilename() + "' not found" + eol);
            }
        } else {
            return new DebugResponse(1, "");
        }
        return new DebugResponse(0, "+ saved information in '" + saveCommand.getFilename() + "'" + eol, 23);
    }

    protected DebugCommand parseStepToLine(DebugTM debugTM) throws DebuggerException {
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(StepToCommand.USAGE);
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string2 = this.currFile;
        string = debugTM.getToken();
        if (string != null) {
            string2 = this.parseFilename(string, debugTM);
        }
        string = debugTM.getToken();
        int n3 = -1;
        if (string != null && string.equalsIgnoreCase("-fi")) {
            try {
                n3 = Integer.parseInt(debugTM.getToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new StepToCommand(n2, string2, n3);
    }

    protected String parseFilename(String string, DebugTM debugTM) {
        String string2 = string;
        if (string2.equals("\"")) {
            string2 = "";
            string = debugTM.getAllToken();
            while (string != null && !string.equals("\"")) {
                string2 = string2 + string;
                string = debugTM.getAllToken();
            }
        } else {
            string = debugTM.getToken();
            if (string != null) {
                if (string.equals(":")) {
                    string2 = string2 + string;
                    string = debugTM.getToken();
                    if (string != null) {
                        string2 = string2 + string;
                    } else {
                        debugTM.ungetToken();
                    }
                } else {
                    debugTM.ungetToken();
                }
            }
        }
        return string2;
    }

    private void setSelLine(int n2) {
        this.selLine = n2;
    }

    private DebugResponse stepToLine(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseStepToLine(debugTM));
    }

    protected Object parseBreakpointCondition(DebugTM debugTM, boolean bl) throws DebuggerException {
        Expression expression = null;
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(SetMonitorCommand.USAGE);
        }
        boolean bl2 = string.equalsIgnoreCase("-env");
        boolean bl3 = string.equalsIgnoreCase("-x");
        if (!bl2 && !bl3) {
            debugTM.ungetAllToken();
        }
        expression = new Expression(debugTM, true, bl2, bl3);
        return expression;
    }

    protected DebugCommand parseSetBreakpoint(DebugTM debugTM) throws DebuggerException {
        boolean bl;
        int n2 = debugTM.countTokens();
        if (n2 < 1) {
            throw new DebuggerException(SetBreakpointCommand.USAGE);
        }
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(SetBreakpointCommand.USAGE);
        }
        if (string.equalsIgnoreCase("-l")) {
            return new SetBreakpointCommand(true);
        }
        if (string.equalsIgnoreCase("-d")) {
            bl = false;
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else if (string.equalsIgnoreCase("-e")) {
            bl = true;
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else {
            bl = defaultBreakpointEnabledState;
        }
        Object object = null;
        int n3 = 0;
        String string2 = "";
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            string2 = string;
        }
        int n4 = -1;
        String string3 = null;
        String string4 = this.currFile;
        string = debugTM.getToken();
        if (string != null) {
            if (string.equalsIgnoreCase("when")) {
                object = this.parseBreakpointCondition(debugTM, bl);
            } else {
                string4 = this.parseFilename(string, debugTM);
                string = debugTM.getToken();
                if (string != null) {
                    if (string.equalsIgnoreCase("-fi")) {
                        try {
                            n4 = Integer.parseInt(debugTM.getToken());
                        }
                        catch (Exception exception) {
                            throw new DebuggerException(5);
                        }
                        string = debugTM.getToken();
                        if (string != null) {
                            if (string.equalsIgnoreCase("when")) {
                                object = this.parseBreakpointCondition(debugTM, bl);
                            } else {
                                string3 = string;
                            }
                        }
                    } else if (string.equalsIgnoreCase("when")) {
                        object = this.parseBreakpointCondition(debugTM, bl);
                    } else {
                        string3 = string;
                    }
                }
            }
        }
        if (object == null && (string = debugTM.getToken()) != null && string.equalsIgnoreCase("when")) {
            object = this.parseBreakpointCondition(debugTM, bl);
        }
        String string5 = "";
        if (this.checkFileOfBreakpoints && (string5 = this.fileLoader.getAbsolutePath(string4)) == null) {
            throw new DebuggerException(4, "'" + string4 + "'");
        }
        if (n3 != 0) {
            return new SetBreakpointCommand(n3, string4, n4, string3, bl, string5, (Expression)object);
        }
        return new SetBreakpointCommand(string2, string4, n4, string3, bl, string5, (Expression)object);
    }

    protected DebugCommand parseJump(DebugTM debugTM) throws DebuggerException {
        int n2 = debugTM.countTokens();
        if (n2 < 1) {
            throw new DebuggerException(JumpCommand.USAGE);
        }
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(JumpCommand.USAGE);
        }
        int n3 = 0;
        String string2 = "";
        try {
            n3 = Integer.parseInt(string);
            int n4 = -1;
            String string3 = this.currFile;
            string = debugTM.getToken();
            if (string != null) {
                string3 = this.parseFilename(string, debugTM);
                string = debugTM.getToken();
                if (string != null && string.equalsIgnoreCase("-fi")) {
                    try {
                        n4 = Integer.parseInt(debugTM.getToken());
                    }
                    catch (Exception exception) {
                        throw new DebuggerException(5);
                    }
                }
            }
            return new JumpCommand(n3, string3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equalsIgnoreCase("-outpar")) {
                return JumpCommand.getJumpOutParagraphInstance();
            }
            if (string.equalsIgnoreCase("-outprog")) {
                return JumpCommand.getJumpOutProgramInstance();
            }
            if (string.equalsIgnoreCase("-next")) {
                return JumpCommand.getJumpNextInstance();
            }
            string2 = string;
            return new JumpCommand(string2);
        }
    }

    protected DebugResponse setBreakpoint(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseSetBreakpoint(debugTM));
    }

    protected DebugResponse jump(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseJump(debugTM));
    }

    protected DebugCommand parseClearBreakpoint(DebugTM debugTM) throws DebuggerException {
        int n2 = debugTM.countTokens();
        if (n2 < 1) {
            throw new DebuggerException(ClearBreakpointCommand.USAGE);
        }
        int n3 = 0;
        String string = "";
        String string2 = debugTM.getToken();
        if (string2.equalsIgnoreCase("-a")) {
            return new ClearBreakpointCommand(true);
        }
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = string2;
        }
        String string3 = this.currFile;
        string2 = debugTM.getToken();
        if (string2 != null) {
            string3 = this.parseFilename(string2, debugTM);
        }
        String string4 = null;
        int n4 = -1;
        string2 = debugTM.getToken();
        if (string2 != null) {
            if (string2.equalsIgnoreCase("-fi")) {
                try {
                    n4 = Integer.parseInt(debugTM.getToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string4 = debugTM.getToken();
            } else {
                string4 = string2;
            }
        }
        if (n3 == 0) {
            String string5 = "";
            if (this.checkFileOfBreakpoints && (string5 = this.fileLoader.getAbsolutePath(string3)) == null) {
                throw new DebuggerException(4, "'" + string3 + "'");
            }
            return new ClearBreakpointCommand(string, string3, n4, string4, string5);
        }
        return new ClearBreakpointCommand(n3, string3, n4, string4, null);
    }

    protected DebugResponse clearBreakpoint(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseClearBreakpoint(debugTM));
    }

    private DebugResponse getInfo(DebugTM debugTM) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(debugTM.getToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = debugTM.getToken();
        return this.processCommand(new GetInfoCommand(n2, string));
    }

    protected DebugCommand parseDisplay(DebugTM debugTM) throws DebuggerException {
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(DisplayCommand.USAGE);
        }
        if (string.equalsIgnoreCase("-classinfo")) {
            return new DisplayCommand(true);
        }
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            if (string.equalsIgnoreCase("-tree")) {
                bl2 = true;
            } else if (string.equalsIgnoreCase("-x")) {
                bl = true;
            } else {
                if (!string.equalsIgnoreCase("-env")) break;
                if (bl2) {
                    throw new DebuggerException(DisplayCommand.USAGE);
                }
                String string2 = debugTM.getToken();
                if (string2 == null) {
                    throw new DebuggerException(DisplayCommand.USAGE);
                }
                if (!bl && string2.equalsIgnoreCase("-x")) {
                    bl = true;
                    string2 = "";
                }
                string = debugTM.getAllToken();
                while (string != null) {
                    string2 = string2 + string;
                    string = debugTM.getAllToken();
                }
                DisplayCommand displayCommand = new DisplayCommand(string2.trim());
                displayCommand.setDisplayAsHex(bl);
                return displayCommand;
            }
            string = debugTM.getToken();
        }
        String string3 = this.getModuleName(debugTM, string);
        if (string3 != null && (string = debugTM.getToken()) == null) {
            throw new DebuggerException(5);
        }
        VarName varName = null;
        debugTM.ungetToken();
        varName = new VarName(debugTM);
        if (bl2) {
            return new DisplayCommand(varName, string3, bl, true);
        }
        string = debugTM.getToken();
        String string4 = null;
        if (string != null && (string.equalsIgnoreCase("prop") || string.equalsIgnoreCase("property")) && (string4 = debugTM.getToken()) == null) {
            throw new DebuggerException(5);
        }
        if (string4 != null) {
            DisplayCommand displayCommand = new DisplayCommand(varName, string3, string4);
            displayCommand.setDisplayAsHex(bl);
            return displayCommand;
        }
        return new DisplayCommand(varName, string3, bl);
    }

    private String getModuleName(DebugTM debugTM, String string) throws DebuggerException {
        String string2 = null;
        if (string.equalsIgnoreCase("-c")) {
            string2 = debugTM.getToken();
            if (string2 == null) {
                throw new DebuggerException(5);
            }
            if (string2.equals("\"")) {
                string = debugTM.getAllToken();
                while (string != null && !string.equals("\"")) {
                    string2 = string2 + string;
                    string = debugTM.getAllToken();
                }
                string = debugTM.getToken();
            } else {
                string = debugTM.getAllToken();
                while (string != null && !string.equals(" ")) {
                    string2 = string2 + string;
                    string = debugTM.getAllToken();
                }
            }
        }
        return string2;
    }

    protected DebugCommand parseOffset(DebugTM debugTM) throws DebuggerException {
        String string = debugTM.getToken();
        String string2 = this.getModuleName(debugTM, string);
        if (string2 != null) {
            string = debugTM.getToken();
        }
        if (string == null) {
            throw new DebuggerException(OffsetCommand.USAGE);
        }
        VarName varName = null;
        debugTM.ungetToken();
        varName = new VarName(debugTM);
        string = debugTM.getToken();
        return new OffsetCommand(varName, string2);
    }

    protected DebugCommand parseLength(DebugTM debugTM) throws DebuggerException {
        String string = debugTM.getToken();
        String string2 = this.getModuleName(debugTM, string);
        if (string2 != null) {
            string = debugTM.getToken();
        }
        if (string == null) {
            throw new DebuggerException(LengthCommand.USAGE);
        }
        VarName varName = null;
        debugTM.ungetToken();
        varName = new VarName(debugTM);
        string = debugTM.getToken();
        return new LengthCommand(varName, string2);
    }

    protected DebugResponse display(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseDisplay(debugTM));
    }

    protected DebugResponse offset(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseOffset(debugTM));
    }

    protected DebugResponse length(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseLength(debugTM));
    }

    protected DebugCommand parseSetMonitor(DebugTM debugTM) throws DebuggerException {
        boolean bl;
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(SetMonitorCommand.USAGE);
        }
        String string2 = null;
        if (string.equalsIgnoreCase("-l")) {
            return new SetMonitorCommand(true);
        }
        if (string.equalsIgnoreCase("-d")) {
            bl = false;
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(SetMonitorCommand.USAGE);
            }
        } else if (string.equalsIgnoreCase("-e")) {
            bl = true;
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(SetMonitorCommand.USAGE);
            }
        } else {
            bl = defaultMonitorEnabledState;
        }
        if (string.equalsIgnoreCase("-env")) {
            String string3 = debugTM.getToken();
            if (string3 == null) {
                throw new DebuggerException(5);
            }
            string = debugTM.getAllToken();
            while (string != null && string.equals("*")) {
                string3 = string3 + string;
                string = debugTM.getAllToken();
                if (string != null) {
                    string3 = string3 + string;
                }
                string = debugTM.getAllToken();
            }
            Condition condition = this.getCondition(debugTM.getToken(), debugTM, false);
            return new SetMonitorCommand(string3, condition, bl);
        }
        boolean bl2 = false;
        if (string.equalsIgnoreCase("-x")) {
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(5);
            }
            bl2 = true;
        }
        string2 = this.getModuleName(debugTM, string);
        VarName varName = null;
        if (string2 == null) {
            debugTM.ungetToken();
        }
        varName = new VarName(debugTM);
        String string4 = null;
        string = debugTM.getToken();
        if (string != null && (string.equalsIgnoreCase("prop") || string.equalsIgnoreCase("property"))) {
            if (bl2) {
                throw new DebuggerException(5);
            }
            string4 = debugTM.getToken();
            if (string4 == null) {
                throw new DebuggerException(5);
            }
            string = debugTM.getToken();
        }
        Condition condition = this.getCondition(string, debugTM, bl2);
        if (string4 != null) {
            return new SetMonitorCommand(varName, string2, string4, condition, bl);
        }
        return new SetMonitorCommand(varName, string2, bl2, condition, bl);
    }

    protected DebugResponse setMonitor(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseSetMonitor(debugTM));
    }

    private Condition getCondition(String string, DebugTM debugTM, boolean bl) throws DebuggerException {
        Condition condition = null;
        if (string != null) {
            if (string.equalsIgnoreCase("when")) {
                condition = new Condition(debugTM, bl);
            } else {
                throw new DebuggerException(5);
            }
        }
        return condition;
    }

    protected DebugCommand parseClearMonitor(DebugTM debugTM) throws DebuggerException {
        String string = null;
        String string2 = debugTM.getToken();
        if (string2 == null) {
            throw new DebuggerException(ClearMonitorCommand.USAGE);
        }
        if (string2.equalsIgnoreCase("-a")) {
            return new ClearMonitorCommand(true);
        }
        if (string2.equalsIgnoreCase("-env")) {
            String string3 = debugTM.getToken();
            if (string3 == null) {
                throw new DebuggerException(5);
            }
            string2 = debugTM.getAllToken();
            while (string2 != null) {
                string3 = string3 + string2;
                string2 = debugTM.getAllToken();
            }
            return new ClearMonitorCommand(string3);
        }
        if (string2.equalsIgnoreCase("-c")) {
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(5);
            }
            string2 = debugTM.getToken();
            if (string2 == null) {
                throw new DebuggerException(5);
            }
        }
        VarName varName = null;
        debugTM.ungetToken();
        varName = new VarName(debugTM);
        string2 = debugTM.getToken();
        String string4 = null;
        if (string2 != null && (string2.equalsIgnoreCase("prop") || string2.equalsIgnoreCase("property")) && (string4 = debugTM.getToken()) == null) {
            throw new DebuggerException(5);
        }
        return new ClearMonitorCommand(varName, string, string4);
    }

    protected DebugResponse clearMonitor(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseClearMonitor(debugTM));
    }

    private DebugCommand parseLetEnv(DebugTM debugTM, boolean bl) throws DebuggerException {
        String string;
        String string2 = debugTM.getToken();
        if (string2 == null) {
            throw new DebuggerException(LetCommand.USAGE);
        }
        String string3 = string2;
        string2 = debugTM.getAllToken();
        while (string2 != null && !string2.equals("=")) {
            string3 = string3 + string2;
            string2 = debugTM.getAllToken();
        }
        if (string2 == null) {
            if (bl) {
                return new LetCommand(string3, null);
            }
            throw new DebuggerException(LetCommand.USAGE);
        }
        string2 = debugTM.getAllToken();
        if (string2 == null) {
            string = " ";
        } else {
            StringBuffer stringBuffer = new StringBuffer(string2);
            while ((string2 = debugTM.getAllToken()) != null) {
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        return new LetCommand(string3, string);
    }

    protected DebugCommand parseLet(DebugTM debugTM) throws DebuggerException {
        return this.parseLet(debugTM, false);
    }

    protected DebugCommand parseLet(DebugTM debugTM, boolean bl) throws DebuggerException {
        String string;
        String string2;
        boolean bl2 = false;
        String string3 = debugTM.getToken();
        if (string3 == null) {
            throw new DebuggerException(LetCommand.USAGE);
        }
        if (string3.equalsIgnoreCase("-env")) {
            return this.parseLetEnv(debugTM, bl);
        }
        if (string3.equalsIgnoreCase("-x")) {
            bl2 = true;
            string3 = debugTM.getToken();
            if (string3 == null) {
                throw new DebuggerException(LetCommand.USAGE);
            }
        }
        if ((string2 = this.getModuleName(debugTM, string3)) != null && (string3 = debugTM.getToken()) == null) {
            throw new DebuggerException(5);
        }
        VarName varName = null;
        debugTM.ungetToken();
        varName = new VarName(debugTM);
        string3 = debugTM.getToken();
        String string4 = null;
        if (string3 != null && (string3.equalsIgnoreCase("prop") || string3.equalsIgnoreCase("property"))) {
            if (bl2) {
                throw new DebuggerException(5);
            }
            string4 = debugTM.getToken();
            if (string4 == null) {
                throw new DebuggerException(5);
            }
            string3 = debugTM.getToken();
        }
        if (string3 == null || !string3.equals("=")) {
            if (bl) {
                if (string4 != null) {
                    return new LetCommand(varName, string2, string4, null);
                }
                return new LetCommand(varName, string2, bl2, null);
            }
            throw new DebuggerException(LetCommand.USAGE);
        }
        string3 = debugTM.getAllToken();
        if (string3 == null) {
            string = " ";
        } else {
            StringBuffer stringBuffer = new StringBuffer(string3);
            while ((string3 = debugTM.getAllToken()) != null) {
                stringBuffer.append(string3);
            }
            string = stringBuffer.toString();
        }
        if (string4 != null) {
            return new LetCommand(varName, string2, string4, string);
        }
        return new LetCommand(varName, string2, bl2, string);
    }

    protected DebugResponse let(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseLet(debugTM));
    }

    protected DebugResponse help(DebugTM debugTM) {
        HelpCommand helpCommand = this.parseHelp(debugTM);
        StringBuffer stringBuffer = new StringBuffer();
        DebugCommand[] debugCommandArray = new DebugCommand[standardCommands.length + graphCommands.length];
        System.arraycopy(standardCommands, 0, debugCommandArray, 0, standardCommands.length);
        System.arraycopy(graphCommands, 0, debugCommandArray, standardCommands.length, graphCommands.length);
        if (helpCommand.getCommand() != null) {
            for (int i2 = 0; i2 < debugCommandArray.length; ++i2) {
                if (!debugCommandArray[i2].getStringId().equalsIgnoreCase(helpCommand.getCommand())) continue;
                stringBuffer.append(debugCommandArray[i2].getStringId());
                stringBuffer.append(debugCommandArray[i2].getShortDescription()).append(eol).append(eol);
                if (debugCommandArray[i2].getUsage() != null && debugCommandArray[i2].getUsage().length() > 0) {
                    stringBuffer.append(debugCommandArray[i2].getUsage()).append(eol);
                }
                return new DebugResponse(0, stringBuffer.toString());
            }
            return new DebugResponse(1, "Command '" + helpCommand.getCommand() + "' does not exist" + eol);
        }
        Arrays.sort(debugCommandArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((DebugCommand)object).getStringId().compareTo(((DebugCommand)object2).getStringId());
            }
        });
        for (int i3 = 0; i3 < debugCommandArray.length; ++i3) {
            stringBuffer.append(debugCommandArray[i3].getStringId()).append(debugCommandArray[i3].getShortDescription()).append(eol);
        }
        return new DebugResponse(0, stringBuffer.toString());
    }

    protected HelpCommand parseHelp(DebugTM debugTM) {
        return new HelpCommand(debugTM.getToken());
    }

    protected DebugCommand parseRun(DebugTM debugTM) {
        if (debugTM.countAllTokens() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Object object = debugTM.getAllToken();
            while (object != null) {
                stringBuffer.append((String)object);
                object = debugTM.getAllToken();
            }
            object = new StringTokenizer(stringBuffer.toString().trim(), " \"", true);
            ArrayList<String> arrayList = new ArrayList<String>();
            stringBuffer = new StringBuffer();
            boolean bl = false;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                if (string.equals(" ")) {
                    if (bl) {
                        stringBuffer.append(string);
                        continue;
                    }
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (string.equals("\"")) {
                    bl = !bl;
                    continue;
                }
                stringBuffer.append(string);
            }
            arrayList.add(stringBuffer.toString());
            this.programArgs = new String[arrayList.size()];
            arrayList.toArray(this.programArgs);
        }
        return new RunCommand(this.programArgs);
    }

    protected DebugResponse run(DebugTM debugTM) {
        return this.processCommand(this.parseRun(debugTM));
    }

    protected DebugCommand parseSetProgramBreakpoint(DebugTM debugTM) throws DebuggerException {
        boolean bl;
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(ProgramBreakpointCommand.USAGE);
        }
        if (string.equalsIgnoreCase("-d")) {
            bl = false;
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else if (string.equalsIgnoreCase("-e")) {
            bl = true;
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else {
            bl = defaultBreakpointEnabledState;
        }
        String string2 = string;
        string = debugTM.getToken();
        Expression expression = null;
        if ("when".equalsIgnoreCase(string)) {
            expression = (Expression)this.parseBreakpointCondition(debugTM, bl);
        }
        return new ProgramBreakpointCommand(string2, bl, expression);
    }

    protected DebugCommand parseSetMethodBreakpoint(DebugTM debugTM) throws DebuggerException {
        boolean bl;
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(MethodBreakpointCommand.USAGE);
        }
        if (string.equalsIgnoreCase("-d")) {
            bl = false;
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else if (string.equalsIgnoreCase("-e")) {
            bl = true;
            string = debugTM.getToken();
            if (string == null) {
                throw new DebuggerException(SetBreakpointCommand.USAGE);
            }
        } else {
            bl = defaultBreakpointEnabledState;
        }
        String string2 = string;
        if (string.equals("\"")) {
            string = debugTM.getAllToken();
            while (string != null && !string.equals("\"")) {
                string2 = string2 + string;
                string = debugTM.getAllToken();
            }
            string = debugTM.getToken();
        } else {
            string = debugTM.getAllToken();
            while (string != null && !string.equalsIgnoreCase("when")) {
                string2 = string2 + string;
                string = debugTM.getAllToken();
            }
        }
        Expression expression = null;
        if (string != null && "when".equalsIgnoreCase(string)) {
            expression = (Expression)this.parseBreakpointCondition(debugTM, bl);
        }
        return new MethodBreakpointCommand(string2.trim(), bl, expression);
    }

    protected DebugCommand parseStepInto(DebugTM debugTM) {
        String string = debugTM.getToken();
        int n2 = 1;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new StepIntoCommand(n2);
    }

    protected DebugResponse setProgramBreakpoint(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseSetProgramBreakpoint(debugTM));
    }

    protected DebugResponse setMethodBreakpoint(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseSetMethodBreakpoint(debugTM));
    }

    protected DebugResponse continue0() {
        return this.processCommand(new ContinueCommand());
    }

    protected DebugResponse stepToNextProgram() {
        return this.processCommand(new StepToNextProgramCommand());
    }

    protected DebugResponse stepInto(DebugTM debugTM) {
        return this.processCommand(this.parseStepInto(debugTM));
    }

    protected DebugResponse stepOver() {
        return this.processCommand(new StepOverCommand());
    }

    /*
     * WARNING - void declaration
     */
    private String getStackInfo0(boolean bl) {
        if (this.parStack != null && this.parStack.length > 0) {
            for (ParagraphObject paragraphObject : this.parStack) {
                this.setSection(paragraphObject);
            }
            String string = "";
            StringBuffer stringBuffer = new StringBuffer();
            for (ParagraphObject paragraphObject : this.parStack) {
                void var2_4;
                stringBuffer.append((String)var2_4);
                stringBuffer.append("+");
                stringBuffer.append(" ");
                stringBuffer.append(paragraphObject.getName());
                if (paragraphObject.getParentSection() != null) {
                    stringBuffer.append(" of ");
                    stringBuffer.append(paragraphObject.getParentSection());
                }
                stringBuffer.append(" [");
                if (paragraphObject.getEntryPointName() != null) {
                    stringBuffer.append(paragraphObject.getEntryPointName());
                    stringBuffer.append(" of ");
                } else if (paragraphObject.getMethodName() != null) {
                    stringBuffer.append(paragraphObject.getMethodName());
                    stringBuffer.append(" of ");
                }
                stringBuffer.append(paragraphObject.getProgName());
                stringBuffer.append("]");
                if (bl) {
                    stringBuffer.append(" ");
                    String string2 = paragraphObject.getFile();
                    if (string2 != null) {
                        stringBuffer.append(string2);
                        stringBuffer.append(":");
                        stringBuffer.append(paragraphObject.getLine());
                    } else {
                        stringBuffer.append(paragraphObject.getLine());
                    }
                }
                stringBuffer.append(eol);
                String string3 = (String)var2_4 + "  ";
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public String showLine(int n2, String string) {
        return this.showLine(n2, string, -1);
    }

    @Override
    public String showLine(int n2, String string, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" line=");
        stringBuffer.append(n2);
        stringBuffer.append(" file=");
        stringBuffer.append(string);
        stringBuffer.append(eol);
        String string2 = null;
        if (this.fileLoaderHelper != null) {
            string2 = this.fileLoaderHelper.getLine(n2, string, n3);
        }
        if (string2 == null) {
            try {
                string2 = this.fileLoader.getLine(n2, string, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                string2 = "";
            }
        }
        stringBuffer.append("   ");
        stringBuffer.append(string2);
        stringBuffer.append(eol);
        return stringBuffer.toString();
    }

    protected DebugResponse getLine() {
        return new DebugResponse(0, "+ " + this.showLine(this.currLine, this.currFile, this.currFileIndex), 7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DebugCommand parseList(DebugTM debugTM) throws DebuggerException {
        int n2;
        int n3;
        String string = debugTM.getTokenAndComma();
        if (string == null) {
            return new ListCommand(this.selLine + 1, this.selLine + this.listSize);
        }
        if (string.equalsIgnoreCase("-get")) {
            return ListCommand.Get();
        }
        if (string.equalsIgnoreCase("-set")) {
            string = debugTM.getToken();
            try {
                return ListCommand.Set(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new DebuggerException(5);
            }
        }
        if (string.equalsIgnoreCase("-f")) {
            return ListCommand.FileList();
        }
        String string2 = null;
        if (string.equals(",")) {
            LineSpec lineSpec = new LineSpec(debugTM);
            if (lineSpec.lineNumber <= 0 || lineSpec.up || lineSpec.down) {
                throw new DebuggerException(5);
            }
            n3 = 1;
            n2 = lineSpec.lineNumber;
            return new ListCommand(n3, n2, string2);
        } else {
            debugTM.ungetToken();
            LineSpec lineSpec = new LineSpec(debugTM);
            if (lineSpec.up) {
                n3 = lineSpec.lineNumber == 0 ? this.startSelLine - this.listSize : this.startSelLine - lineSpec.lineNumber;
                n2 = this.startSelLine - 1;
                return new ListCommand(n3, n2, string2);
            } else if (lineSpec.down) {
                n2 = lineSpec.lineNumber == 0 ? this.selLine + this.listSize : this.selLine + lineSpec.lineNumber;
                n3 = this.selLine + 1;
                return new ListCommand(n3, n2, string2);
            } else if (lineSpec.lineNumber > 0) {
                string2 = lineSpec.fileName;
                string = debugTM.getTokenAndComma();
                if (string != null && string.equals(",")) {
                    n3 = lineSpec.lineNumber;
                    LineSpec lineSpec2 = new LineSpec(debugTM);
                    if (lineSpec2.up) {
                        n3 = lineSpec2.lineNumber == 0 ? lineSpec.lineNumber - this.listSize : lineSpec.lineNumber - lineSpec2.lineNumber;
                        n2 = lineSpec.lineNumber - 1;
                        return new ListCommand(n3, n2, string2);
                    } else if (lineSpec2.down) {
                        n3 = lineSpec.lineNumber + 1;
                        n2 = lineSpec2.lineNumber == 0 ? lineSpec.lineNumber + this.listSize : lineSpec.lineNumber + lineSpec2.lineNumber;
                        return new ListCommand(n3, n2, string2);
                    } else {
                        n2 = lineSpec2.isNull ? this.getLineCount(string2 != null ? string2 : this.selFile, false) : lineSpec2.lineNumber;
                    }
                    return new ListCommand(n3, n2, string2);
                } else {
                    n3 = lineSpec.lineNumber - Math.round((float)this.listSize / 2.0f) + 1;
                    n2 = lineSpec.lineNumber + this.listSize / 2;
                }
                return new ListCommand(n3, n2, string2);
            } else {
                string2 = lineSpec.fileName;
                if (lineSpec.parName != null) {
                    if (this.info == null) throw new DebuggerException("Paragraph '" + lineSpec.parName + "' not found");
                    String[] stringArray = this.info.getFilenames();
                    DebugParagraph[] debugParagraphArray = this.info.getParagraphs();
                    boolean bl = false;
                    Filename filename = string2 != null ? new Filename(string2) : null;
                    n3 = 0;
                    for (int i2 = 0; i2 < debugParagraphArray.length && !bl; ++i2) {
                        Filename filename2 = new Filename(stringArray[debugParagraphArray[i2].getFileIndex()]);
                        if (!debugParagraphArray[i2].getParagraphName().equalsIgnoreCase(lineSpec.parName) || string2 != null && !filename2.equals(filename)) continue;
                        n3 = debugParagraphArray[i2].getLineNumber();
                        string2 = filename2.getOrigName();
                        bl = true;
                    }
                    if (!bl) throw new DebuggerException("Paragraph '" + lineSpec.parName + "' not found");
                    string = debugTM.getTokenAndComma();
                    if (string != null && string.equals(",")) {
                        LineSpec lineSpec3 = new LineSpec(debugTM);
                        if (lineSpec3.lineNumber <= 0 || lineSpec3.up || lineSpec3.down) {
                            throw new DebuggerException(5);
                        }
                        n2 = lineSpec3.lineNumber;
                        return new ListCommand(n3, n2, string2);
                    } else {
                        n2 = n3 + this.listSize;
                    }
                    return new ListCommand(n3, n2, string2);
                } else {
                    n3 = lineSpec.lineNumber - Math.round((float)this.listSize / 2.0f) + 1;
                    n2 = lineSpec.lineNumber + this.listSize / 2;
                }
            }
        }
        return new ListCommand(n3, n2, string2);
    }

    protected DebugResponse list(DebugTM debugTM) throws DebuggerException {
        ListCommand listCommand = (ListCommand)this.parseList(debugTM);
        return this.list(listCommand, this.currLine, this.currFile);
    }

    protected DebugResponse list(ListCommand listCommand, int n2, String string) throws DebuggerException {
        if (listCommand.isGet()) {
            return new DebugResponse(0, "ListSize: " + this.listSize + eol);
        }
        if (listCommand.isSet()) {
            this.listSize = listCommand.getListSize();
            return new DebugResponse(0, "ListSize: " + this.listSize + eol);
        }
        if (listCommand.isFileList()) {
            if (this.info != null) {
                String[] stringArray = this.info.getFilenames();
                StringBuffer stringBuffer = new StringBuffer();
                if (stringArray.length > 0) {
                    stringBuffer.append(stringArray[0]);
                    for (int i2 = 1; i2 < stringArray.length; ++i2) {
                        stringBuffer.append(eol).append(stringArray[i2]);
                    }
                }
                stringBuffer.append(eol);
                return new DebugResponse(0, stringBuffer.toString());
            }
            return new DebugResponse(1, "File List unavailable" + eol);
        }
        String string2 = listCommand.getFileName();
        if (string2 == null) {
            string2 = this.selFile;
        }
        int[] nArray = new int[1];
        String[] stringArray = new String[]{};
        int n3 = new Filename(string2).equals(new Filename(string)) ? n2 : -1;
        int n4 = listCommand.getFromLine();
        int n5 = listCommand.getToLine();
        try {
            int n6 = this.fileLoader.getLineCount(string2, false);
            int n7 = 1 - n4;
            if (n7 > 0) {
                n4 = 1;
                n5 += n7;
            } else {
                n7 = n5 - n6;
                if (n7 > 0) {
                    n5 = n6;
                    n4 -= n7;
                }
            }
            if (n5 > n6) {
                n5 = n6;
            }
            if (n4 < 1) {
                n4 = 1;
            }
            stringArray = this.fileLoader.list(string2, n4, n5, nArray, false);
            this.startSelLine = n4;
            this.selLine = n5;
            this.selFile = string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("File '").append(string2).append("' not found").append(eol);
            stringBuffer.append("Make sure the directory containing this file is listed in CLASSPATH or in ");
            stringBuffer.append("iscobol.debug.code_prefix");
            stringBuffer.append(eol);
            return new DebugResponse(1, stringBuffer.toString());
        }
        return new DebugResponse(0, DebuggerInvoker.formatLines(stringArray, n4, n3, this.selFile), 8);
    }

    private static String normalizeString(String string) {
        return string.replace('_', '-').toUpperCase();
    }

    private String getLine(int n2, String string, boolean bl) throws FileNotFoundException {
        return this.fileLoader.getLine(n2, string, bl);
    }

    private int getLineCount(String string, boolean bl) {
        try {
            return this.fileLoader.getLineCount(string, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0;
        }
    }

    protected DebugResponse directory(DirectoryCommand directoryCommand) {
        String string = directoryCommand.getDirectory();
        String string2 = Config.a(".debug.code_prefix", null);
        if (string != null) {
            if (string2 != null) {
                string2 = string + ";" + string2;
                Config.b(".debug.code_prefix", string2);
            } else {
                string2 = string;
                Config.b(".debug.code_prefix", string2);
            }
            this.fileLoader = new FileLoader(this);
        }
        return new DebugResponse(0, "debug.code_prefix = " + string2 + eol);
    }

    private int find(boolean bl, boolean bl2) throws FileNotFoundException {
        int n2;
        String string = DebuggerInvoker.normalizeString(this.lastFind);
        int n3 = string.length();
        int n4 = this.selLine;
        int n5 = this.selPos;
        if (bl2) {
            n4 = 1;
            n5 = 0;
        }
        if (bl) {
            int n6;
            int n7;
            String string2 = this.getLine(n4, this.selFile, false);
            if (n5 < string2.length()) {
                string2 = string2.substring(0, n5);
            }
            if ((n7 = (string2 = DebuggerInvoker.normalizeString(string2)).lastIndexOf(string)) >= 0 && n7 + string.length() == string2.length()) {
                string2 = string2.substring(0, string2.length() - string.length());
                n7 = string2.lastIndexOf(string);
            }
            if (n7 >= 0) {
                this.selPos = n7 + n3;
                this.setSelLine(n4);
                return this.selLine;
            }
            for (n6 = n4 - 1; n6 > 0; --n6) {
                string2 = DebuggerInvoker.normalizeString(this.getLine(n6, this.selFile, false));
                n7 = string2.lastIndexOf(string);
                if (n7 < 0) continue;
                this.setSelLine(n6);
                this.selPos = n7 + n3;
                return this.selLine;
            }
            n6 = this.getLineCount(this.selFile, false);
            n5 = 0;
            for (int i2 = n6; i2 >= n4; --i2) {
                string2 = DebuggerInvoker.normalizeString(this.getLine(i2, this.selFile, false));
                n7 = string2.lastIndexOf(string);
                if (n7 < 0) continue;
                this.setSelLine(i2);
                this.selPos = n7 + n3;
                return this.selLine;
            }
            return -1;
        }
        String string3 = DebuggerInvoker.normalizeString(this.getLine(n4, this.selFile, false));
        int n8 = string3.indexOf(string, n5);
        if (n8 >= 0) {
            this.setSelLine(n4);
            this.selPos = n8 + n3;
            return this.selLine;
        }
        int n9 = this.getLineCount(this.selFile, false);
        for (n2 = n4 + 1; n2 <= n9; ++n2) {
            string3 = DebuggerInvoker.normalizeString(this.getLine(n2, this.selFile, false));
            n8 = string3.indexOf(string);
            if (n8 < 0) continue;
            this.setSelLine(n2);
            this.selPos = n8 + n3;
            return this.selLine;
        }
        n5 = 0;
        for (n2 = 1; n2 <= n4; ++n2) {
            string3 = DebuggerInvoker.normalizeString(this.getLine(n2, this.selFile, false));
            n8 = string3.indexOf(string);
            if (n8 < 0) continue;
            this.setSelLine(n2);
            this.selPos = n8 + n3;
            return this.selLine;
        }
        return -1;
    }

    protected DebugCommand parseAutoOn(DebugTM debugTM) throws DebuggerException {
        String string = debugTM.getToken();
        if (string == null) {
            return new AutoOnCommand();
        }
        if (string.equalsIgnoreCase("-get")) {
            return AutoOnCommand.Get();
        }
        if (string.equalsIgnoreCase("-set")) {
            string = debugTM.getToken();
            try {
                return AutoOnCommand.Set(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new DebuggerException(5);
            }
        }
        try {
            return new AutoOnCommand(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new DebuggerException(5);
        }
    }

    protected DirectoryCommand parseDirectory(DebugTM debugTM) throws DebuggerException {
        String string = "";
        debugTM.getAllToken();
        Object object = debugTM.getAllToken();
        while (object != null) {
            string = string + (String)object;
            object = debugTM.getAllToken();
        }
        if (string.trim().length() == 0) {
            return new DirectoryCommand();
        }
        object = new File(string);
        if (!((File)object).exists() || !((File)object).isDirectory()) {
            throw new DebuggerException(1, ": invalid directory name");
        }
        return new DirectoryCommand(string);
    }

    protected StackInfoCommand parseStackInfo(DebugTM debugTM) throws DebuggerException {
        boolean bl = "-a".equalsIgnoreCase(debugTM.getToken());
        return new StackInfoCommand(bl);
    }

    protected String parseFind(DebugTM debugTM) {
        String string = "";
        debugTM.getAllToken();
        String string2 = debugTM.getAllToken();
        while (string2 != null) {
            string = string + string2;
            string2 = debugTM.getAllToken();
        }
        return string;
    }

    protected DebugResponse find(DebugTM debugTM, boolean bl, boolean bl2, int n2) {
        this.lastFind = this.parseFind(debugTM);
        return this.find(bl, bl2, n2);
    }

    protected DebugResponse find(boolean bl, boolean bl2, int n2) {
        if (this.lastFind != null && this.lastFind.length() > 0) {
            try {
                int n3 = this.find(bl, bl2);
                if (n3 > 0) {
                    int n4;
                    int n5 = Integer.toString(n3).length();
                    StringBuffer stringBuffer = new StringBuffer(DebuggerInvoker.formatLine(this.getLine(n3, this.selFile, false), n3, false, this.selFile));
                    if (this.selFile != null) {
                        n5 += this.selFile.length();
                    }
                    int n6 = this.selPos - this.lastFind.length() + n5 + 3;
                    for (n4 = 0; n4 < n6; ++n4) {
                        stringBuffer.append(' ');
                    }
                    for (n4 = n6; n4 < n6 + this.lastFind.length(); ++n4) {
                        stringBuffer.append('^');
                    }
                    return new DebugResponse(0, stringBuffer.toString() + eol, n2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return new DebugResponse(1, "'" + this.lastFind + "' not found" + eol);
        }
        return new DebugResponse(1, "");
    }

    protected DebugResponse firstLine() {
        int n2 = 1;
        String string = this.selFile;
        if (this.info != null && this.info.getFilenames() != null && this.info.getFilenames().length > 0) {
            string = this.info.getFilenames()[0];
        }
        try {
            String string2 = this.getLine(n2, string, false);
            this.setSelLine(n2);
            this.selFile = string;
            this.selPos = 0;
            return new DebugResponse(0, DebuggerInvoker.formatLine(string2, 1, false, this.selFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new DebugResponse(1, "");
        }
    }

    protected DebugResponse firstExecLine() {
        if (this.info != null && this.info.getParagraphs() != null && this.info.getParagraphs().length > 0) {
            DebugParagraph debugParagraph = this.info.getParagraphs()[0];
            try {
                int n2 = debugParagraph.getLineNumber();
                String string = this.info.getFilenames()[debugParagraph.getFileIndex()];
                String string2 = this.getLine(n2, string, false);
                this.setSelLine(n2);
                this.selFile = string;
                this.selPos = 0;
                return new DebugResponse(0, DebuggerInvoker.formatLine(string2, debugParagraph.getLineNumber(), false, this.selFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return new DebugResponse(1, "");
    }

    protected DebugResponse down() throws DebuggerException {
        ParagraphObject paragraphObject;
        if (this.parStack != null && this.parStack.length > 0) {
            if (this.selStackFrameIndex == -1) {
                paragraphObject = this.parStack[this.parStack.length - 1];
                this.selStackFrameIndex = this.parStack.length - 1;
            } else if (this.selStackFrameIndex > 0) {
                paragraphObject = this.parStack[this.selStackFrameIndex - 1];
                --this.selStackFrameIndex;
            } else {
                paragraphObject = this.parStack[this.selStackFrameIndex];
            }
        } else {
            paragraphObject = null;
        }
        if (paragraphObject != null) {
            ListCommand listCommand = new ListCommand(paragraphObject.getLine(), paragraphObject.getLine() + this.listSize, paragraphObject.getFile());
            return this.list(listCommand, paragraphObject.getLine(), paragraphObject.getFile());
        }
        return new DebugResponse(1, "lower stack frame unavailable" + eol);
    }

    protected DebugResponse up() throws DebuggerException {
        ParagraphObject paragraphObject;
        if (this.parStack != null && this.parStack.length > 0) {
            if (this.selStackFrameIndex == -1) {
                paragraphObject = this.parStack[this.parStack.length - 1];
                this.selStackFrameIndex = this.parStack.length - 1;
            } else if (this.selStackFrameIndex < this.parStack.length - 1) {
                paragraphObject = this.parStack[this.selStackFrameIndex + 1];
                ++this.selStackFrameIndex;
            } else {
                paragraphObject = this.parStack[this.selStackFrameIndex];
            }
        } else {
            paragraphObject = null;
        }
        if (paragraphObject != null) {
            ListCommand listCommand = new ListCommand(paragraphObject.getLine(), paragraphObject.getLine() + this.listSize, paragraphObject.getFile());
            return this.list(listCommand, paragraphObject.getLine(), paragraphObject.getFile());
        }
        return new DebugResponse(1, "higher stack frame unavailable" + eol);
    }

    protected DebugResponse currLine() {
        int n2 = this.currLine;
        String string = this.currFile;
        try {
            String string2 = this.getLine(n2, string, false);
            this.setSelLine(n2);
            this.selFile = string;
            this.selPos = 0;
            return new DebugResponse(0, DebuggerInvoker.formatLine(string2, this.selLine, false, this.selFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new DebugResponse(1, "");
        }
    }

    protected DebugResponse lastLine() {
        try {
            Object object;
            String string;
            if (this.info != null) {
                string = this.info.getFilenames()[0];
                if (this.info.getCopyfiles() != null && this.info.getCopyfiles().length > 0) {
                    DebugCopyFile[] debugCopyFileArray = this.info.getCopyfiles();
                    object = new Filename(string);
                    int n2 = this.fileLoader.getLineCount(string, false);
                    for (int i2 = debugCopyFileArray.length - 1; i2 >= 0; --i2) {
                        if (!new Filename(debugCopyFileArray[i2].getParentFileName()).equals(object)) continue;
                        if (debugCopyFileArray[i2].getCopyStatementLineNumber() >= n2) {
                            string = debugCopyFileArray[i2].getCopyFileName();
                            object = new Filename(string);
                            n2 = this.fileLoader.getLineCount(string, false);
                            i2 = debugCopyFileArray.length;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                string = this.currFile;
            }
            int n3 = this.getLineCount(string, false);
            object = this.getLine(n3, string, false);
            this.setSelLine(n3);
            this.selPos = 0;
            this.selFile = string;
            return new DebugResponse(0, DebuggerInvoker.formatLine((String)object, n3, false, this.selFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new DebugResponse(1, "");
        }
    }

    private static String formatLine(String string, int n2, boolean bl, String string2) {
        return DebuggerInvoker.formatLines(new String[]{string}, n2, bl ? n2 : -1, string2);
    }

    private static String formatLines(String[] stringArray, int n2, int n3, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = Integer.toString(n2 + stringArray.length - 1).length();
        int n5 = 0;
        int n6 = n2;
        while (n5 < stringArray.length) {
            String string2 = Integer.toString(n6);
            for (int i2 = 0; i2 < n4 - string2.length(); ++i2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
            if (string != null) {
                stringBuffer.append(':');
                stringBuffer.append(string);
            }
            if (n6 == n3) {
                stringBuffer.append('<');
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[n5]);
            stringBuffer.append(eol);
            ++n5;
            ++n6;
        }
        return stringBuffer.toString();
    }

    protected DebugResponse stepOutOfParagraph() {
        return this.processCommand(new StepOutParagraphCommand());
    }

    protected DebugResponse stepOutOfProgram() {
        return this.processCommand(new StepOutProgramCommand());
    }

    protected DebugResponse getStackInfo(boolean bl) {
        String string = this.getStackInfo0(bl);
        if (string != null) {
            return new DebugResponse(0, string);
        }
        return new DebugResponse(1, "stack info unavailable" + eol);
    }

    protected DebugResponse quit() {
        return this.processCommand(new QuitCommand());
    }

    protected DebugCommand parseTraceOn(DebugTM debugTM) throws DebuggerException {
        String string = null;
        String string2 = debugTM.getToken();
        if (string2 == null) {
            throw new DebuggerException(TraceOnCommand.USAGE);
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string2 = debugTM.getToken();
        if (string2 != null) {
            string = this.parseFilename(string2, debugTM);
        }
        return new TraceOnCommand(n2, string);
    }

    protected DebugResponse traceOn(DebugTM debugTM) throws DebuggerException {
        return this.processCommand(this.parseTraceOn(debugTM));
    }

    protected DebugResponse traceOff() {
        return this.processCommand(new TraceOffCommand());
    }

    @Override
    public DebugResponse exit() {
        return this.processCommand(new ExitCommand());
    }

    public static void main(String[] stringArray) {
        int n2 = Integer.parseInt(stringArray[0]);
        Config.a(2, n2, true, false, 0);
        Debugger.activeRemoteDebugging();
        String string = stringArray[1];
        String[] stringArray2 = new String[stringArray.length - 2];
        if (stringArray2.length > 0) {
            System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
        }
        Debugger.init(string, stringArray2);
    }

    public void setCurrFile(String string) {
        this.currFile = this.selFile = this.getRealPath(string);
        this.currFileIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFreePort() {
        while (true) {
            ServerSocket serverSocket = null;
            try {
                int n2;
                serverSocket = new ServerSocket(0);
                int n3 = n2 = serverSocket.getLocalPort();
                return n3;
            }
            catch (IOException iOException) {}
            continue;
            finally {
                if (serverSocket == null) continue;
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
    }

    @Override
    public int launchIsCobolProgram(String[] stringArray) {
        try {
            int n2;
            String string = "-Discobol.gui.cstimeout=";
            Vector<String> vector = new Vector<String>();
            String string2 = System.getProperty("java.home");
            String string3 = string2 != null ? string2 + "/bin/java" : "java";
            vector.addElement(string3);
            for (n2 = 0; n2 < stringArray.length && stringArray[n2].startsWith("-"); ++n2) {
                vector.addElement(stringArray[n2]);
            }
            vector.addElement("-Discobol.gui.cstimeout=0");
            vector.addElement("-cp");
            vector.addElement(System.getProperty("java.class.path"));
            vector.addElement(DebuggerInvoker.class.getName());
            int n3 = DebuggerInvoker.getFreePort();
            vector.addElement(Integer.toString(n3));
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
            stringArray = new String[vector.size()];
            vector.toArray(stringArray);
            this.process = Runtime.getRuntime().exec(stringArray);
            activeProcesses.add(this.process);
            new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(DebuggerInvoker.this.process.getInputStream()));
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            System.out.println(string);
                            string = bufferedReader.readLine();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(DebuggerInvoker.this.process.getErrorStream()));
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            System.err.println(string);
                            string = bufferedReader.readLine();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
            return n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public DebugResponse invokeRemote(String string, int n2, int n3, boolean bl) {
        return this.invokeRemote(string, n2, n3, bl, null);
    }

    public DebugResponse invokeRemote(String string, int n2) {
        return this.invokeRemote(string, n2, 1, false, null);
    }

    @Override
    public DebugResponse invokeRemote(String string, int n2, int n3, boolean bl, PrintStream printStream) {
        for (int i2 = 0; i2 < n3; ++i2) {
            try {
                this.dbgSocket = new Socket(string, n2);
                break;
            }
            catch (UnknownHostException unknownHostException) {
                return new DebugResponse(106, "");
            }
            catch (IOException iOException) {
                if (i2 >= n3 - 1) continue;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (this.dbgSocket == null) {
            return new DebugResponse(106, "");
        }
        try {
            OutputStream outputStream = this.dbgSocket.getOutputStream();
            InputStream inputStream = this.dbgSocket.getInputStream();
            this.outputThread = new OutputChild(inputStream, printStream);
            this.inputThread = new InputChild(outputStream);
            DebugResponse debugResponse = this.outputThread.getResponse(-1);
            if (!debugResponse.isErrorCode()) {
                if (debugResponse.getInfo() != null) {
                    this.putLocalDebugInfo(debugResponse.getInfo().getClassName(), 991, this.createLocalDebugInfo(debugResponse), bl);
                }
            } else {
                this.exitDebug();
            }
            this.remoteHost = string;
            this.remotePort = n2;
            return debugResponse;
        }
        catch (IOException iOException) {
            return new DebugResponse(106, "");
        }
    }

    public void putLocalDebugInfo(String string, int n2, LocalDebugInfo localDebugInfo, boolean bl) {
        String[] stringArray;
        this.debugInfos.put(string + "$" + n2, localDebugInfo);
        if (localDebugInfo.getListingInfos() != null && (stringArray = localDebugInfo.getFilenames()) != null && stringArray != null) {
            for (String string2 : stringArray) {
                File file = new File(string2);
                this.loadedFilePaths.add(file);
                if (file.getParent() == null) continue;
                this.loadedFilePaths.add(new File(file.getName()));
            }
        }
        if (bl) {
            localDebugInfo.loadMetadata(true);
        }
    }

    public LocalDebugInfo getLocalDebugInfo(String string, int n2) {
        return this.debugInfos.get(string + "$" + n2);
    }

    public boolean isPathLoaded(File file) {
        return this.loadedFilePaths.contains(file);
    }

    public LocalDebugInfo createLocalDebugInfo(DebugResponse debugResponse) {
        if (debugResponse != null && debugResponse.getInfo() != null) {
            if (debugResponse.getInfo().getErrorString() != null) {
                return new LocalDebugInfo(debugResponse.getInfo().getErrorString());
            }
            return new LocalDebugInfo(this, debugResponse.getInfo());
        }
        return null;
    }

    @Override
    public DebugResponse processCommand(IDebugCommand iDebugCommand) {
        if (!(iDebugCommand instanceof DebugCommand)) {
            throw new IllegalArgumentException("" + iDebugCommand);
        }
        return this.processCommand((DebugCommand)iDebugCommand);
    }

    public DebugResponse processCommand(DebugCommand debugCommand) {
        this.inputThread.setCommand(debugCommand);
        return this.update(debugCommand, this.outputThread.getResponse(0));
    }

    @Override
    public DebugResponse getResponse() {
        return this.getResponse(0);
    }

    @Override
    public DebugResponse getResponse(int n2) {
        if (this.outputThread != null) {
            DebugResponse debugResponse = this.outputThread.getResponse(n2);
            this.update(debugResponse);
            return debugResponse;
        }
        return new DebugResponse(103, "");
    }

    @Override
    public void putInput(String string) {
        try {
            this.inputThread.putInput(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    @Override
    public void suspend() {
        if (this.inputThread != null) {
            this.inputThread.setCommand(new SuspendCommand());
        }
    }

    @Override
    public void exitDebug() {
        this.exitDebug(false);
    }

    public void exitDebug(boolean bl) {
        if (bl && this.inputThread != null && this.outputThread != null) {
            this.inputThread.setCommand(new ExitCommand(true));
            this.outputThread.getResponse(0);
        }
        if (this.outputThread != null) {
            this.outputThread.stop();
            this.outputThread = null;
        }
        if (this.inputThread != null) {
            this.inputThread.stop();
            this.inputThread = null;
        }
        if (this.dbgSocket != null) {
            try {
                this.dbgSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dbgSocket = null;
            this.remoteHost = null;
            this.remotePort = 0;
        }
        if (this.process != null) {
            this.process.destroy();
            activeProcesses.remove(this.process);
            this.process = null;
        }
    }

    @Override
    public boolean isRemoteDebug() {
        return this.process == null && this.dbgSocket != null;
    }

    @Override
    public String getRemoteFileContents(String string) {
        DebugResponse debugResponse;
        if (this.isRemoteDebug() && (debugResponse = this.processCommand(new GetFileCommand(string))) != null && debugResponse.getReturnCode() == 0) {
            return debugResponse.getMessage();
        }
        return null;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    public LocalDebugInfo getInfo(String string, boolean bl, boolean bl2) {
        return this.getInfo(string, bl, bl2, true);
    }

    public LocalDebugInfo getInfo(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.isRunning() && !bl;
        DebugResponse debugResponse = null;
        LocalDebugInfo localDebugInfo = null;
        int n2 = 991;
        if (string != null) {
            GetInfoCommand getInfoCommand;
            DebugResponse.DebugInfo debugInfo;
            localDebugInfo = this.getLocalDebugInfo(string, n2);
            if (localDebugInfo == null) {
                GetInfoCommand getInfoCommand2;
                if (bl4 && (localDebugInfo = this.createLocalDebugInfo(debugResponse = this.processCommand(getInfoCommand2 = new GetInfoCommand(n2, string)))) != null) {
                    this.putLocalDebugInfo(string, n2, localDebugInfo, bl2);
                }
            } else if (bl4 && bl3 && (debugInfo = this.processCommand(getInfoCommand = new GetInfoCommand(64, string)).getInfo()) != null && debugInfo.getTimestamp() > localDebugInfo.getTimestamp() && (localDebugInfo = this.createLocalDebugInfo(debugResponse = this.processCommand(getInfoCommand = new GetInfoCommand(n2, string)))) != null) {
                this.putLocalDebugInfo(string, n2, localDebugInfo, bl2);
            }
        } else if (bl4) {
            GetInfoCommand getInfoCommand = new GetInfoCommand(n2, string);
            debugResponse = this.processCommand(getInfoCommand);
            localDebugInfo = this.createLocalDebugInfo(debugResponse);
        }
        return localDebugInfo;
    }

    @Override
    public boolean isRunning() {
        return this.process != null || this.dbgSocket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeCommand load(String string, Vector vector, Vector vector2, Vector vector3, String[] stringArray) {
        boolean bl = this.checkFileOfBreakpoints;
        this.checkFileOfBreakpoints = false;
        FileInputStream fileInputStream = null;
        Breakpoint[] breakpointArray = null;
        Watch[] watchArray = null;
        Tree[] treeArray = null;
        CompositeCommand compositeCommand = null;
        try {
            String string2;
            fileInputStream = new FileInputStream(string);
            DebugResponse debugResponse = null;
            SessionProperties sessionProperties = new SessionProperties();
            RtsUtil.loadProperties((Properties)sessionProperties, fileInputStream);
            if (stringArray != null && stringArray.length > 0) {
                stringArray[0] = sessionProperties.getChainingString();
            }
            Vector<DebugCommand> vector4 = new Vector<DebugCommand>();
            Iterator iterator = sessionProperties.breakpointKeys();
            while (iterator.hasNext()) {
                string2 = sessionProperties.getProperty((String)iterator.next());
                try {
                    vector4.addElement(this.parseCommand(string2));
                }
                catch (DebuggerException debuggerException) {}
            }
            iterator = sessionProperties.monitorKeys();
            while (iterator.hasNext()) {
                string2 = sessionProperties.getProperty((String)iterator.next());
                try {
                    vector4.addElement(this.parseCommand(string2));
                }
                catch (DebuggerException debuggerException) {}
            }
            iterator = sessionProperties.displayKeys();
            while (iterator.hasNext()) {
                string2 = sessionProperties.getProperty((String)iterator.next());
                try {
                    DisplayCommand displayCommand = (DisplayCommand)this.parseCommand(string2);
                    displayCommand.setDeferredIfNotRunning(true);
                    vector4.addElement(displayCommand);
                }
                catch (DebuggerException debuggerException) {}
            }
            compositeCommand = new CompositeCommand(vector4);
            if (!vector4.isEmpty() && (debugResponse = this.processCommand(compositeCommand)) != null) {
                if (debugResponse.getBreakpoints() != null) {
                    breakpointArray = debugResponse.getBreakpoints();
                }
                if (debugResponse.getMonitors() != null) {
                    watchArray = debugResponse.getMonitors();
                }
                if (debugResponse.getTrees() != null) {
                    treeArray = debugResponse.getTrees();
                }
            }
        }
        catch (IOException iOException) {
            CompositeCommand compositeCommand2 = null;
            return compositeCommand2;
        }
        finally {
            this.checkFileOfBreakpoints = bl;
        }
        if (breakpointArray != null && vector != null) {
            vector.addAll(Arrays.asList(breakpointArray));
        }
        if (watchArray != null && vector2 != null) {
            vector2.addAll(Arrays.asList(watchArray));
        }
        if (vector3 != null && treeArray != null) {
            vector3.addAll(Arrays.asList(treeArray));
        }
        return compositeCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(String string, Breakpoint[] breakpointArray, Watch[] watchArray, String[] stringArray, String string2) {
        try (PrintStream printStream = null;){
            int n2;
            printStream = new PrintStream(new FileOutputStream(string));
            SessionProperties sessionProperties = new SessionProperties();
            if (breakpointArray != null) {
                for (n2 = 0; n2 < breakpointArray.length; n2 += 1) {
                    sessionProperties.storeBreakpoint(breakpointArray[n2]);
                }
            }
            if (watchArray != null) {
                for (n2 = 0; n2 < watchArray.length; n2 += 1) {
                    sessionProperties.storeMonitor(watchArray[n2]);
                }
            }
            if (stringArray != null) {
                for (n2 = 0; n2 < stringArray.length; n2 += 1) {
                    sessionProperties.storeDisplay(stringArray[n2]);
                }
            }
            if (string2 != null) {
                sessionProperties.storeChainingString(string2);
            }
            sessionProperties.store(printStream, "isCOBOL Debugger Session");
            n2 = 1;
            return n2 != 0;
        }
    }

    @Override
    public boolean isAlive() {
        if (this.outputThread != null) {
            return this.outputThread.isAlive();
        }
        return false;
    }

    public static boolean isDefaultMonitorEnabledState() {
        return defaultMonitorEnabledState;
    }

    public static void setDefaultMonitorEnabledState(boolean bl) {
        defaultMonitorEnabledState = bl;
    }

    public static boolean isDefaultBreakpointEnabledState() {
        return defaultBreakpointEnabledState;
    }

    public static void setDefaultBreakpointEnabledState(boolean bl) {
        defaultBreakpointEnabledState = bl;
    }

    public FileLoaderHelper getFileLoaderHelper() {
        return this.fileLoaderHelper;
    }

    public void setFileLoaderHelper(FileLoaderHelper fileLoaderHelper) {
        this.fileLoaderHelper = fileLoaderHelper;
    }

    @Override
    public FileLoader getFileLoader() {
        return this.fileLoader;
    }

    @Override
    public String getRealPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        File file = new File(string);
        if (this.isPathLoaded(file)) {
            return string;
        }
        if (this.isPathLoaded(new File(file.getName()))) {
            return file.getName();
        }
        String string2 = string;
        if (!file.exists() && this.getFileLoader() != null && (string = this.getFileLoader().getAbsolutePath(file.getName())) != null) {
            string2 = string;
        }
        return string2;
    }

    @Override
    public String getRemoteEncoding() {
        return this.outputThread != null ? this.outputThread.getRemoteEncoding() : null;
    }

    static {
        System.arraycopy(graphCommands, 0, defCommands, 0, graphCommands.length);
        System.arraycopy(standardCommands, 0, defCommands, graphCommands.length, standardCommands.length);
        activeProcesses = new Vector();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (int i2 = 0; i2 < activeProcesses.size(); ++i2) {
                    ((Process)activeProcesses.elementAt(i2)).destroy();
                }
            }
        });
        defaultMonitorEnabledState = false;
        defaultBreakpointEnabledState = true;
    }

    private static class LineSpec {
        String fileName;
        String parName;
        boolean down;
        boolean up;
        int lineNumber;
        boolean isNull;

        LineSpec(DebugTM debugTM) throws DebuggerException {
            String string = debugTM.getToken();
            this.isNull = string == null;
            if (this.isNull) {
                return;
            }
            if (string.equals("+")) {
                this.down = true;
                string = debugTM.getToken();
                if (string != null) {
                    try {
                        this.lineNumber = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        debugTM.ungetToken();
                    }
                } else {
                    debugTM.ungetToken();
                }
            } else if (string.equals("-")) {
                this.up = true;
            } else {
                if (string.startsWith("-")) {
                    this.up = true;
                    try {
                        this.lineNumber = Integer.parseInt(string.substring(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new DebuggerException(5);
                    }
                }
                try {
                    this.lineNumber = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = string;
                    DebugTM.Marker marker = debugTM.setMarker();
                    StringBuffer stringBuffer = new StringBuffer(string);
                    string = debugTM.getAllToken();
                    while (string != null && !string.equals(":") && !string.equals(",")) {
                        stringBuffer.append(string);
                        string = debugTM.getToken();
                    }
                    if (string != null && string.equals(":")) {
                        this.fileName = stringBuffer.toString();
                        string = debugTM.getToken();
                        if (string == null) {
                            this.lineNumber = 1;
                        } else {
                            try {
                                this.lineNumber = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                this.parName = string;
                            }
                        }
                    }
                    this.parName = string2;
                    debugTM.rewindToMarker(marker);
                }
            }
        }
    }

    private static class SessionProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        static final String BREAKPOINT_PREFIX = "breakpoint";
        static final String MONITOR_PREFIX = "monitor";
        static final String DISPLAY_PREFIX = "display";
        int prog;

        private SessionProperties() {
        }

        Iterator breakpointKeys() {
            return this.keys(BREAKPOINT_PREFIX);
        }

        Iterator monitorKeys() {
            return this.keys(MONITOR_PREFIX);
        }

        Iterator displayKeys() {
            return this.keys(DISPLAY_PREFIX);
        }

        Iterator keys(String string) {
            TreeSet<String> treeSet = new TreeSet<String>();
            Enumeration<Object> enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                if (!string2.startsWith(string)) continue;
                treeSet.add(string2);
            }
            return treeSet.iterator();
        }

        String getChainingString() {
            return this.getProperty("chaining");
        }

        String createKey(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = Integer.toString(++this.prog);
            for (int i2 = 0; i2 < 4 - string2.length(); ++i2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }

        void storeBreakpoint(Breakpoint breakpoint) {
            this.setProperty(this.createKey(BREAKPOINT_PREFIX), breakpoint.getDebugCommand());
        }

        void storeMonitor(Watch watch) {
            this.setProperty(this.createKey(MONITOR_PREFIX), watch.getDebugCommand());
        }

        void storeDisplay(String string) {
            this.setProperty(this.createKey(DISPLAY_PREFIX), string);
        }

        void storeChainingString(String string) {
            this.setProperty("chaining", string);
        }
    }
}

