/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EnvVarName
implements DataExternalizable,
Cloneable {
    private static final long serialVersionUID = 1000006L;
    private String name;

    EnvVarName() {
    }

    public EnvVarName(String string) {
        this.name = string;
    }

    public EnvVarName(DebugTM debugTM) throws DebuggerException {
        this.analyze(debugTM);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EnvVarName)) {
            return false;
        }
        EnvVarName envVarName = (EnvVarName)object;
        return this.getName().equals(envVarName.getName());
    }

    private void analyze(DebugTM debugTM) throws DebuggerException {
        String string = debugTM.getToken();
        if (string == null) {
            throw new DebuggerException(5);
        }
        this.name = string;
        string = debugTM.getAllToken();
        while (string != null && string.equals("*")) {
            this.name = this.name + string;
            string = debugTM.getAllToken();
            if (string != null) {
                this.name = this.name + string;
            }
            string = debugTM.getAllToken();
        }
    }

    public String toString() {
        return this.name;
    }

    public EnvVarName Clone() {
        try {
            return (EnvVarName)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        RtsUtil.writeUTFOptmz(this.name, dataOutput);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.name = RtsUtil.readUTFOptmz(dataInput);
    }
}

