/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.EnvVarName;
import com.iscobol.debugger.VarName;
import com.iscobol.interfaces.debugger.IExpression;
import com.iscobol.interfaces.debugger.IExpressionOp;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class Expression
implements DataExternalizable,
IExpression {
    private static final long serialVersionUID = 1000006L;
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int DIVIDE = 2;
    public static final int MULTIPLY = 3;
    public static final int GREATER = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int LESS = 6;
    public static final int LESS_OR_EQUAL = 7;
    public static final int EQUAL = 8;
    public static final int NOT_EQUAL = 9;
    public static final int NOT = 10;
    public static final int AND = 11;
    public static final int OR = 12;
    private static final int OPEN_PAR = 13;
    private static final int ELEM_OP = 1;
    private static final int ELEM_STRING = 2;
    private static final int ELEM_BD_STRING = 3;
    private static final int ELEM_ENV_VN = 4;
    private static final int ELEM_VN = 5;
    private static final int ELEM_EXPR = 6;
    private transient int openPar;
    private transient DebugTM tm;
    private Vector elements;
    private boolean conditional;
    private boolean envProperty;
    private boolean hexadecimal;

    public Expression() {
    }

    public Expression(DebugTM debugTM) throws DebuggerException {
        this(debugTM, false, false, false);
    }

    public Expression(DebugTM debugTM, boolean bl, boolean bl2, boolean bl3) throws DebuggerException {
        Op op;
        Stack<Object> stack = new Stack<Object>();
        Stack<Op> stack2 = new Stack<Op>();
        this.tm = debugTM;
        this.conditional = bl;
        this.envProperty = bl2;
        this.hexadecimal = bl3;
        boolean bl4 = true;
        String string = debugTM.getToken();
        block7: while (string != null) {
            Object object;
            op = null;
            try {
                op = new Op(string, this);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            if (op != null) {
                switch (op.type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: {
                        while (!stack2.isEmpty()) {
                            object = (Op)stack2.peek();
                            if (((Op)object).priority < op.priority) break;
                            stack.push(this.op(stack2, stack));
                        }
                        stack2.push(op);
                        bl4 = true;
                        break;
                    }
                    case 13: {
                        if (bl4) {
                            ++this.openPar;
                            stack2.push(op);
                            break;
                        }
                        debugTM.ungetToken();
                        break block7;
                    }
                    case 10: {
                        stack2.push(op);
                        bl4 = true;
                    }
                }
            } else if (string.equals(")")) {
                if (this.openPar > 0) {
                    --this.openPar;
                } else {
                    debugTM.ungetToken();
                    break;
                }
                while (!stack2.isEmpty()) {
                    object = (Op)stack2.peek();
                    if (((Op)object).type == 13) {
                        stack2.pop();
                        break;
                    }
                    stack.push(this.op(stack2, stack));
                }
                bl4 = false;
            } else if (string.equals("\"")) {
                object = string;
                String string2 = debugTM.getAllToken();
                while (string2 != null && !string2.equals("\"")) {
                    object = (String)object + string2;
                    string2 = debugTM.getAllToken();
                }
                if ("\"".equals(string2)) {
                    object = (String)object + string2;
                }
                stack.push(object);
            } else if (bl4) {
                object = this.value(string);
                if (object != null) {
                    stack.push(object);
                } else if (DebugUtilities.isValidCobolIdentifierName(string)) {
                    debugTM.ungetToken();
                    if (bl2) {
                        stack.push(new EnvVarName(debugTM));
                    } else {
                        stack.push(new VarName(debugTM));
                    }
                } else {
                    debugTM.ungetToken();
                    break;
                }
                bl4 = false;
            } else {
                debugTM.ungetToken();
                break;
            }
            string = debugTM.getToken();
        }
        while (!stack2.isEmpty()) {
            stack.push(this.op(stack2, stack));
        }
        if (stack.size() == 1) {
            op = stack.pop();
            if (op instanceof Expression) {
                this.elements = ((Expression)((Object)op)).elements;
            } else {
                this.elements = new Vector();
                this.elements.addElement(op);
            }
        } else {
            throw new DebuggerException(5);
        }
    }

    public Expression(Vector vector, boolean bl, boolean bl2, boolean bl3) {
        this.elements = vector;
        this.conditional = bl;
        this.envProperty = bl2;
        this.hexadecimal = bl3;
    }

    @Override
    public boolean isEnvProperty() {
        return this.envProperty;
    }

    @Override
    public boolean isCondition() {
        return this.conditional;
    }

    @Override
    public boolean isHex() {
        return this.hexadecimal;
    }

    private Object op(Stack stack, Stack stack2) throws DebuggerException {
        Op op = (Op)stack.pop();
        if (op.isUnaryOp()) {
            if (stack2.isEmpty()) {
                throw new DebuggerException(5);
            }
            Object e2 = stack2.pop();
            Expression expression = new Expression();
            expression.elements = new Vector();
            expression.elements.addElement(op);
            expression.elements.addElement(e2);
            return expression;
        }
        if (stack2.size() < 2) {
            throw new DebuggerException(5);
        }
        Object e3 = stack2.pop();
        Object e4 = stack2.pop();
        Expression expression = new Expression();
        expression.elements = new Vector();
        expression.elements.addElement(e4);
        expression.elements.addElement(op);
        expression.elements.addElement(e3);
        return expression;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public Boolean evaluateBoolean(Object object, Debugger debugger) throws DebuggerException {
        if (object instanceof Expression) {
            Object object2 = ((Expression)object).evaluate(debugger, false, false);
            if (object2 instanceof Boolean) {
                return (Boolean)object2;
            }
        } else if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }

    public Comparable evaluateComparable(Object object, boolean bl, boolean bl2, Debugger debugger) throws DebuggerException {
        if (object instanceof Expression) {
            Object object2 = ((Expression)object).evaluate(debugger, bl, bl2);
            if (object2 instanceof Comparable) {
                return (Comparable)object2;
            }
        } else if (object instanceof VarName) {
            Debugger.IscobolField iscobolField = debugger.findVar((VarName)object, false);
            if (iscobolField != null) {
                if (iscobolField.getVar() instanceof Comparable) {
                    return (Comparable)iscobolField.getVar();
                }
                if (iscobolField.getVar() instanceof ICobolVar) {
                    ICobolVar iCobolVar = (ICobolVar)iscobolField.getVar();
                    if (bl2) {
                        return DebugUtilities.bytesToHex(iCobolVar.getBytes(), iCobolVar.length());
                    }
                    if (iCobolVar instanceof INumericVar) {
                        return ((INumericVar)iCobolVar).num().bigDecimalValue();
                    }
                    return iCobolVar.toString();
                }
            }
        } else {
            if (object instanceof EnvVarName) {
                return Config.a(Config.a() + ((EnvVarName)object).getName().trim().toLowerCase().replace('-', '_'), null);
            }
            if (object instanceof String) {
                String string = (String)object;
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                return string;
            }
            if (object instanceof Comparable) {
                return (Comparable)object;
            }
        }
        return null;
    }

    public BigDecimal evaluateBigDecimal(Object object, Debugger debugger) throws DebuggerException {
        if (object instanceof Expression) {
            Object object2 = ((Expression)object).evaluate(debugger, true, false);
            if (object2 instanceof BigDecimal) {
                return (BigDecimal)object2;
            }
        } else if (object instanceof VarName) {
            Debugger.IscobolField iscobolField = debugger.findVar((VarName)object, false);
            if (iscobolField != null && iscobolField.getVar() instanceof INumericVar) {
                return ((INumericVar)iscobolField.getVar()).num().bigDecimalValue();
            }
        } else if (object instanceof EnvVarName) {
            String string = Config.a(Config.a() + ((EnvVarName)object).getName().trim().toLowerCase().replace('-', '_'), null);
            try {
                return new BigDecimal(string.replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object evaluate(Debugger debugger, boolean bl, boolean bl2) throws DebuggerException {
        void var4_13;
        void var4_5;
        Comparable<BigDecimal> comparable;
        Object var4_4 = null;
        Enumeration enumeration = this.getElements();
        Op op = null;
        Object var7_16 = null;
        while (enumeration.hasMoreElements()) {
            var7_16 = enumeration.nextElement();
            if (var7_16 instanceof Op) {
                op = var7_16;
                continue;
            }
            if (op != null) {
                Comparable<Boolean> comparable2;
                if (op.type == 10) {
                    comparable = this.evaluateBoolean(var7_16, debugger);
                    if (comparable == null) throw new DebuggerException(35);
                    Boolean bl3 = !((Boolean)comparable).booleanValue();
                    continue;
                }
                if (op.isLogicalOp()) {
                    comparable = this.evaluateBoolean(var4_5, debugger);
                    comparable2 = this.evaluateBoolean(var7_16, debugger);
                    if (comparable == null || comparable2 == null) throw new DebuggerException(35);
                    Boolean bl4 = this.compute(op, (Boolean)comparable, (Boolean)comparable2);
                    continue;
                }
                if (op.isRelationalOp()) {
                    comparable = this.evaluateComparable(var4_5, bl, bl2, debugger);
                    comparable2 = this.evaluateComparable(var7_16, bl, bl2, debugger);
                    if (comparable == null || comparable2 == null || comparable.getClass() != comparable2.getClass()) throw new DebuggerException(35);
                    Boolean bl5 = this.computeRelation(op, comparable, comparable2);
                    continue;
                }
                comparable = this.evaluateBigDecimal(var4_5, debugger);
                comparable2 = this.evaluateBigDecimal(var7_16, debugger);
                if (comparable == null || comparable2 == null) throw new DebuggerException(35);
                BigDecimal bigDecimal = this.compute(op, (BigDecimal)comparable, (BigDecimal)comparable2);
                continue;
            }
            Object var4_10 = var7_16;
        }
        if (bl) {
            comparable = this.evaluateBigDecimal(var4_5, debugger);
            if (comparable == null) throw new DebuggerException(35);
            Comparable<BigDecimal> comparable3 = comparable;
            return var4_13;
        } else {
            comparable = this.evaluateComparable(var4_5, bl, bl2, debugger);
            if (comparable == null) throw new DebuggerException(35);
            Comparable<BigDecimal> comparable4 = comparable;
        }
        return var4_13;
    }

    private Object value(String string) {
        if (this.hexadecimal) {
            if (DebugUtilities.hexToBytes(string) != null) {
                return string.toUpperCase();
            }
            return null;
        }
        try {
            return new BigDecimal(string.replace(',', '.'));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private BigDecimal compute(Op op, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3;
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal("0");
        }
        switch (op.type) {
            case 0: {
                bigDecimal3 = bigDecimal.add(bigDecimal2);
                break;
            }
            case 1: {
                bigDecimal3 = bigDecimal.subtract(bigDecimal2);
                break;
            }
            case 3: {
                bigDecimal3 = bigDecimal.multiply(bigDecimal2);
                break;
            }
            case 2: {
                bigDecimal3 = bigDecimal.divide(bigDecimal2, 1);
                break;
            }
            default: {
                bigDecimal3 = null;
            }
        }
        return bigDecimal3;
    }

    private Boolean compute(Op op, Boolean bl, Boolean bl2) {
        Boolean bl3;
        if (bl == null) {
            bl = false;
        }
        switch (op.type) {
            case 11: {
                bl3 = bl != false && bl2 != false;
                break;
            }
            case 12: {
                bl3 = bl != false || bl2 != false;
                break;
            }
            case 10: {
                bl3 = bl == false;
                break;
            }
            default: {
                bl3 = null;
            }
        }
        return bl3;
    }

    private Boolean computeRelation(Op op, Comparable object, Comparable object2) {
        Boolean bl;
        if (object == null) {
            object = new BigDecimal("0");
        }
        if (object instanceof String && object2 instanceof String) {
            object = ((String)object).replaceAll("\\s+$", "");
            object2 = ((String)object2).replaceAll("\\s+$", "");
        }
        switch (op.type) {
            case 4: {
                bl = object.compareTo(object2) > 0;
                break;
            }
            case 5: {
                bl = object.compareTo(object2) >= 0;
                break;
            }
            case 6: {
                bl = object.compareTo(object2) < 0;
                break;
            }
            case 7: {
                bl = object.compareTo(object2) <= 0;
                break;
            }
            case 8: {
                bl = object.compareTo(object2) == 0;
                break;
            }
            case 9: {
                bl = object.compareTo(object2) != 0;
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    @Override
    public Enumeration getElements() {
        return this.elements != null ? this.elements.elements() : DebugUtilities.EMPTY_ENUMERATION;
    }

    @Override
    public int getElementCount() {
        return this.elements != null ? this.elements.size() : 0;
    }

    @Override
    public boolean containsVariables() {
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (!(e2 instanceof VarName) && !(e2 instanceof EnvVarName) && (!(e2 instanceof Expression) || !((Expression)e2).containsVariables())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.conditional);
        dataOutput.writeBoolean(this.envProperty);
        dataOutput.writeBoolean(this.hexadecimal);
        if (this.elements != null) {
            int n2 = this.elements.size();
            dataOutput.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object e2 = this.elements.elementAt(i2);
                if (e2 instanceof Op) {
                    dataOutput.writeInt(1);
                    ((Op)e2).writeExternal(dataOutput);
                    continue;
                }
                if (e2 instanceof BigDecimal) {
                    dataOutput.writeInt(3);
                    RtsUtil.writeUTFOptmz(e2.toString(), dataOutput);
                    continue;
                }
                if (e2 instanceof String) {
                    dataOutput.writeInt(2);
                    RtsUtil.writeUTFOptmz((String)e2, dataOutput);
                    continue;
                }
                if (e2 instanceof EnvVarName) {
                    dataOutput.writeInt(4);
                    ((EnvVarName)e2).writeExternal(dataOutput);
                    continue;
                }
                if (e2 instanceof VarName) {
                    dataOutput.writeInt(5);
                    ((VarName)e2).writeExternal(dataOutput);
                    continue;
                }
                if (e2 instanceof Expression) {
                    dataOutput.writeInt(6);
                    ((Expression)e2).writeExternal(dataOutput);
                    continue;
                }
                throw new IOException("Expression.writeExternal: Unknown element type");
            }
        } else {
            dataOutput.writeInt(0);
        }
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.conditional = dataInput.readBoolean();
        this.envProperty = dataInput.readBoolean();
        this.hexadecimal = dataInput.readBoolean();
        int n2 = dataInput.readInt();
        if (n2 > 0) {
            this.elements = new Vector();
            block8: for (int i2 = 0; i2 < n2; ++i2) {
                switch (dataInput.readInt()) {
                    case 1: {
                        Op op = new Op();
                        op.readExternal(dataInput);
                        this.elements.addElement(op);
                        continue block8;
                    }
                    case 3: {
                        this.elements.addElement(new BigDecimal(RtsUtil.readUTFOptmz(dataInput)));
                        continue block8;
                    }
                    case 2: {
                        this.elements.addElement(RtsUtil.readUTFOptmz(dataInput));
                        continue block8;
                    }
                    case 4: {
                        EnvVarName envVarName = new EnvVarName();
                        envVarName.readExternal(dataInput);
                        this.elements.addElement(envVarName);
                        continue block8;
                    }
                    case 5: {
                        VarName varName = new VarName();
                        varName.readExternal(dataInput);
                        this.elements.addElement(varName);
                        continue block8;
                    }
                    case 6: {
                        Expression expression = new Expression();
                        expression.readExternal(dataInput);
                        this.elements.addElement(expression);
                        continue block8;
                    }
                    default: {
                        throw new IOException("Expression.readExternal: Unknown element type");
                    }
                }
            }
        } else {
            this.elements = null;
        }
    }

    public static class Op
    implements DataExternalizable,
    IExpressionOp {
        int type;
        transient int priority;
        private static final long serialVersionUID = 1000006L;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Op(String string, Expression expression) throws DebuggerException {
            if (string.equals("+")) {
                this.type = 0;
                this.setPriority();
                return;
            } else if (string.equals("-")) {
                this.type = 1;
                this.setPriority();
                return;
            } else if (string.equals("/")) {
                this.type = 2;
                this.setPriority();
                return;
            } else if (string.equals("*")) {
                this.type = 3;
                this.setPriority();
                return;
            } else if (string.equals("(")) {
                this.type = 13;
                return;
            } else {
                if (!expression.conditional) throw new DebuggerException(5);
                if (string.equals(">")) {
                    string = expression.tm.getAllToken();
                    if (string.equals("=")) {
                        this.type = 5;
                    } else {
                        expression.tm.ungetAllToken();
                        this.type = 4;
                    }
                    this.setPriority();
                    return;
                } else if (string.equals("<")) {
                    string = expression.tm.getAllToken();
                    if (string.equals("=")) {
                        this.type = 7;
                    } else {
                        expression.tm.ungetAllToken();
                        this.type = 6;
                    }
                    this.setPriority();
                    return;
                } else if (string.equals("=")) {
                    this.type = 8;
                    this.priority = 3;
                    return;
                } else if (string.equals("||")) {
                    this.type = 12;
                    this.setPriority();
                    return;
                } else if (string.equals("&&")) {
                    this.type = 11;
                    this.setPriority();
                    return;
                } else {
                    if (!string.equals("!")) throw new DebuggerException(5);
                    string = expression.tm.getAllToken();
                    if (string.equals("=")) {
                        this.type = 9;
                        this.setPriority();
                        return;
                    } else {
                        expression.tm.ungetAllToken();
                        this.type = 10;
                        this.setPriority();
                    }
                }
            }
        }

        public Op() {
        }

        public Op(int n2) {
            this.type = n2;
            this.setPriority();
        }

        private void setPriority() {
            switch (this.type) {
                case 0: 
                case 1: {
                    this.priority = 5;
                    break;
                }
                case 2: 
                case 3: {
                    this.priority = 6;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.priority = 4;
                    break;
                }
                case 8: 
                case 9: {
                    this.priority = 3;
                    break;
                }
                case 12: {
                    this.priority = 1;
                    break;
                }
                case 11: {
                    this.priority = 2;
                    break;
                }
                case 10: {
                    this.priority = 7;
                    break;
                }
                default: {
                    this.priority = 0;
                }
            }
        }

        @Override
        public boolean isUnaryOp() {
            switch (this.type) {
                case 10: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isLogicalOp() {
            switch (this.type) {
                case 10: 
                case 11: 
                case 12: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isRelationalOp() {
            switch (this.type) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isMathematicalOp() {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSameCategory(Op op) {
            return this.isLogicalOp() && op.isLogicalOp() || this.isRelationalOp() && op.isRelationalOp() || this.isMathematicalOp() && op.isMathematicalOp();
        }

        @Override
        public int getType() {
            return this.type;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "+";
                }
                case 1: {
                    return "-";
                }
                case 3: {
                    return "*";
                }
                case 2: {
                    return "/";
                }
                case 5: {
                    return ">=";
                }
                case 4: {
                    return ">";
                }
                case 7: {
                    return "<";
                }
                case 6: {
                    return "<";
                }
                case 8: {
                    return "=";
                }
                case 9: {
                    return "!=";
                }
                case 10: {
                    return "!";
                }
                case 11: {
                    return "&&";
                }
                case 12: {
                    return "||";
                }
                case 13: {
                    return "(";
                }
            }
            return "?";
        }

        @Override
        public void writeExternal(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.type);
        }

        @Override
        public void readExternal(DataInput dataInput) throws IOException {
            this.type = dataInput.readInt();
            this.setPriority();
        }
    }
}

