/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Filename;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import com.iscobol.types.CobolVar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class FileLoader
implements IFileLoader {
    private String[] pathList;
    private Map cobolFiles;
    private Map remoteFiles;
    private String debugCodePrefix;
    private DebuggerInvoker invoker;
    private String encoding;

    public FileLoader() {
        this(null);
    }

    public FileLoader(DebuggerInvoker debuggerInvoker) {
        this.invoker = debuggerInvoker;
        if (this.invoker != null) {
            this.encoding = this.invoker.getRemoteEncoding();
        }
        if (this.encoding == null) {
            this.encoding = CobolVar.encoding;
        }
        this.debugCodePrefix = Config.a(".debug.code_prefix", ".debug_code_prefix", null);
        if (this.debugCodePrefix == null) {
            this.debugCodePrefix = System.getProperty("java.class.path", ".");
        }
        if (File.separatorChar != '/') {
            this.debugCodePrefix = this.debugCodePrefix.replace(File.separatorChar, '/');
        }
        this.cobolFiles = new HashMap();
        this.remoteFiles = new HashMap();
        this.pathList = RtsUtil.getPathList(this.debugCodePrefix, true);
    }

    String getRemoteEncoding() {
        return this.encoding;
    }

    public String getLine(int n2, String string, boolean bl) throws FileNotFoundException {
        String[] stringArray = this.loadFile((String)string, (boolean)bl).lines;
        if (n2 > 0 && n2 <= stringArray.length) {
            return stringArray[n2 - 1];
        }
        return "";
    }

    public String getLongestLine(String string, boolean bl) throws FileNotFoundException {
        return this.loadFile((String)string, (boolean)bl).longestLine;
    }

    public int getMaxLineLength(String string, boolean bl) throws FileNotFoundException {
        return this.loadFile((String)string, (boolean)bl).maxLength;
    }

    public String[] list(String string, int n2, boolean bl) throws FileNotFoundException {
        return this.list(string, n2, 100000000, null, bl);
    }

    public String[] list(String string, int n2, int n3, boolean bl) throws FileNotFoundException {
        return this.list(string, n2, n3, null, bl);
    }

    public String[] list(String string, int n2, int n3, int[] nArray, boolean bl) throws FileNotFoundException {
        String[] stringArray = this.loadFile((String)string, (boolean)bl).lines;
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n3 > stringArray.length) {
            n3 = stringArray.length;
        }
        if (n2 > stringArray.length || n2 > n3) {
            return new String[0];
        }
        int n4 = n2 - 1;
        if (nArray != null && nArray.length > 0) {
            nArray[0] = n4;
        }
        int n5 = n3 - 1;
        String[] stringArray2 = new String[n5 - n4 + 1];
        int n6 = n4;
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            stringArray2[i2] = stringArray[n6];
            ++n6;
        }
        return stringArray2;
    }

    public String[] getLines(String string, boolean bl) throws FileNotFoundException {
        return this.loadFile((String)string, (boolean)bl).lines;
    }

    public int getLineCount(String string, boolean bl) throws FileNotFoundException {
        return this.loadFile((String)string, (boolean)bl).lines.length;
    }

    public void finalize() {
        this.cobolFiles.clear();
        this.remoteFiles.clear();
    }

    private FileObj loadFile(String string, boolean bl) throws FileNotFoundException {
        String string2 = string;
        if (!bl && this.cobolFiles.containsKey(string2)) {
            return (FileObj)this.cobolFiles.get(string2);
        }
        Vector<String[]> vector = new Vector<String[]>();
        try {
            String string3 = this.getAbsolutePath(string, false);
            if (string3 == null) {
                throw new FileNotFoundException(string);
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(string3), this.encoding));
            String[] stringArray = "";
            int n2 = 0;
            String[] stringArray2 = ((BufferedReader)lineNumberReader).readLine();
            while (stringArray2 != null) {
                int n3 = stringArray2.length();
                if (n3 > n2) {
                    n2 = n3;
                    stringArray = stringArray2;
                }
                vector.addElement(stringArray2);
                stringArray2 = ((BufferedReader)lineNumberReader).readLine();
            }
            lineNumberReader.close();
            stringArray2 = new String[vector.size()];
            vector.toArray(stringArray2);
            FileObj fileObj = new FileObj(string3, stringArray2, (String)stringArray);
            this.cobolFiles.put(string2, fileObj);
            return fileObj;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            return new FileObj(string, new String[0], "");
        }
    }

    @Override
    public String getAbsolutePath(String string) {
        return this.getAbsolutePath(string, true);
    }

    private String getAbsolutePath(String string, boolean bl) {
        String string2 = this.getAbsolutePath0(string, bl);
        if (string2 == null) {
            string2 = this.findFileRemotely(string);
        }
        return string2;
    }

    private String getAbsolutePath0(String string, boolean bl) {
        Object object;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (bl && this.cobolFiles.containsKey(object = string)) {
            return ((FileObj)this.cobolFiles.get((Object)object)).path;
        }
        object = new File(string);
        if (this.invoker != null && this.invoker.isPathLoaded((File)object)) {
            return string;
        }
        if (((File)object).isFile() && ((File)object).canRead()) {
            return string;
        }
        if (((File)object).isAbsolute()) {
            return this.findFile(((File)object).getName());
        }
        String string2 = this.findFile(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = ((File)object).getName();
        if (!string3.equals(string)) {
            return this.findFile(string3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findFileRemotely(String string) {
        String string2;
        if (!Config.b(".debug.remote_source", false) || this.invoker == null) {
            return null;
        }
        Map map = this.remoteFiles;
        synchronized (map) {
            String string3 = new File(string).getName();
            if (this.remoteFiles.containsKey(string3)) {
                string2 = (String)this.remoteFiles.get(string3);
            } else {
                string2 = null;
                String string4 = this.invoker.getRemoteFileContents(string);
                if (string4 != null) {
                    String string5 = System.getProperty("java.io.tmpdir") + File.separator + this.invoker.getRemoteHost() + "-" + this.invoker.getRemotePort();
                    new File(string5).mkdirs();
                    string5 = string5 + File.separator + new File(string).getName();
                    try {
                        File file = new File(string5);
                        file.deleteOnExit();
                        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                        printWriter.write(string4);
                        printWriter.close();
                        file.setLastModified(0L);
                        string2 = string5;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.remoteFiles.put(string3, string2);
            }
        }
        return string2;
    }

    private String findFile(String string) {
        for (int i2 = 0; i2 < this.pathList.length; ++i2) {
            String string2 = this.pathList[i2] + '/' + string;
            File file = new File(string2);
            if (!file.isFile() || !file.canRead()) continue;
            return string2;
        }
        return null;
    }

    public boolean checkTimestamp(Filename[] filenameArray, long l2) {
        for (int i2 = 0; i2 < filenameArray.length; ++i2) {
            String string = this.getAbsolutePath(filenameArray[i2].getOrigName());
            if (string == null || new File(string).lastModified() < l2) continue;
            return false;
        }
        return true;
    }

    private static class FileObj {
        public String path;
        public String[] lines;
        public String longestLine;
        public int maxLength;

        public FileObj(String string, String[] stringArray, String string2) {
            this.path = string;
            this.lines = stringArray;
            this.longestLine = string2;
            this.maxLength = string2.length();
        }
    }
}

